#include <stdio.h>
#include <stdlib.h>
#include <pthread.h>
#include <time.h>

#define NUMBER_OF_ITERATIONS    1e7
#define ARRAY_SIZE              128

int array[ARRAY_SIZE];

void* thread_write_first_half(void* arg)
{
    for( int j = 0 ; j < NUMBER_OF_ITERATIONS ; j++ )
    {
        for( int i = 0 ; i < ARRAY_SIZE / 2 ; i++ )
        {
            array[i]++;
        }
    }
    return NULL;
}

void* thread_write_second_half(void* arg)
{
    for( int j = 0 ; j < NUMBER_OF_ITERATIONS ; j++ )
    {
        for( int i = ARRAY_SIZE / 2; i < ARRAY_SIZE; i++ )
        {
            array[i]++;
        }
    }
    return NULL;
}

void* thread_write_even(void* arg)
{
    for( int j = 0 ; j < NUMBER_OF_ITERATIONS ; j++ )
    {
        for( int i = 0 ; i < ARRAY_SIZE ; i += 2 )
        {
            array[i]++;
        }
    }
    return NULL;
}

void* thread_write_odd(void* arg)
{
    for( int j = 0 ; j < NUMBER_OF_ITERATIONS ; j++ )
    {
        for( int i = 1 ; i < ARRAY_SIZE ; i += 2 )
        {
            array[i]++;
        }
    }
    return NULL;
}

int main(void)
{
    clock_t start, end;
    pthread_t thread1, thread2;

    printf("--- Start : one thread accesses the first half of the array, the other accesses the second half\n");
    start = clock();
    pthread_create(&thread1, NULL, thread_write_first_half, NULL);
    pthread_create(&thread2, NULL, thread_write_second_half, NULL);

    pthread_join(thread1, NULL);
    pthread_join(thread2, NULL);
    end = clock();
    printf("    Time for writing first and second halves = %f s\n", ((double)(end-start)) / CLOCKS_PER_SEC );


    printf("--- Start : one thread accesses the even cells of the array, the other accesses the odd cells\n");
    start = clock();
    pthread_create(&thread1, NULL, thread_write_even, NULL);
    pthread_create(&thread2, NULL, thread_write_odd, NULL);

    pthread_join(thread1, NULL);
    pthread_join(thread2, NULL);
    end = clock();
    printf("    Time for writing evens and odds = %f s\n", ((double)(end-start)) / CLOCKS_PER_SEC );
    

    return 0;
}

