/******************************************************************************
 * FILE PURPOSE: TSIP LLD example files.
 ******************************************************************************
 * FILE NAME: module.xs
 *
 * DESCRIPTION: 
 *  This file contains the module specification for TSIP LLD example files.
 *
 * Copyright (C) 2010, Texas Instruments, Inc.
 *****************************************************************************/

/* Load the library utility. */
var libUtility = xdc.loadCapsule ("../build/buildlib.xs");

/**************************************************************************
 * FUNCTION NAME : modBuild
 **************************************************************************
 * DESCRIPTION   :
 *  The function is used to add all the source files in the example 
 *  directory into the package.
 **************************************************************************/
function modBuild() 
{
    /* Add all the .c files to the release package. */
    var exampleFiles = libUtility.listAllFiles (".c", "example", true);
    for (var k = 0 ; k < exampleFiles.length; k++)
        Pkg.otherFiles[Pkg.otherFiles.length++] = exampleFiles[k];

    /* Add all the .h files to the release package. */
    var exampleFiles = libUtility.listAllFiles (".h", "example", true);
    for (var k = 0 ; k < exampleFiles.length; k++)
        Pkg.otherFiles[Pkg.otherFiles.length++] = exampleFiles[k];

    /* Add all the .cmd files to the release package. */
    var exampleFiles = libUtility.listAllFiles (".cmd", "example", true);
    for (var k = 0 ; k < exampleFiles.length; k++)
        Pkg.otherFiles[Pkg.otherFiles.length++] = exampleFiles[k];

    /* Add all the .cfg files to the release package. */
    var exampleFiles = libUtility.listAllFiles (".cfg", "example", true);
    for (var k = 0 ; k < exampleFiles.length; k++)
        Pkg.otherFiles[Pkg.otherFiles.length++] = exampleFiles[k];

    /* Add the Readme.txt to the package */
    Pkg.otherFiles[Pkg.otherFiles.length++] = "example/sample/Readme.txt";
    Pkg.otherFiles[Pkg.otherFiles.length++] = "example/sample/TSIP_exampleProject.txt";

    /* Add example project related files. */
/*
    Pkg.otherFiles[Pkg.otherFiles.length++] = "example/sample/LE/SampleProjectLE/.ccsproject";
    Pkg.otherFiles[Pkg.otherFiles.length++] = "example/sample/LE/SampleProjectLE/.cdtproject";
    Pkg.otherFiles[Pkg.otherFiles.length++] = "example/sample/LE/SampleProjectLE/.project";
    Pkg.otherFiles[Pkg.otherFiles.length++] = "example/sample/LE/SampleProjectLE/.cdtbuild";

    Pkg.otherFiles[Pkg.otherFiles.length++] = "example/sample/BE/SampleProjectBE/.ccsproject";
    Pkg.otherFiles[Pkg.otherFiles.length++] = "example/sample/BE/SampleProjectBE/.cdtproject";
    Pkg.otherFiles[Pkg.otherFiles.length++] = "example/sample/BE/SampleProjectBE/.project";
    Pkg.otherFiles[Pkg.otherFiles.length++] = "example/sample/BE/SampleProjectBE/.cdtbuild";

    Pkg.otherFiles[Pkg.otherFiles.length++] = "example/sample/LE/SampleProjectLE_configuration/.ccsproject";
    Pkg.otherFiles[Pkg.otherFiles.length++] = "example/sample/LE/SampleProjectLE_configuration/.cdtproject";
    Pkg.otherFiles[Pkg.otherFiles.length++] = "example/sample/LE/SampleProjectLE_configuration/.project";
    Pkg.otherFiles[Pkg.otherFiles.length++] = "example/sample/LE/SampleProjectLE_configuration/.cdtbuild";

    Pkg.otherFiles[Pkg.otherFiles.length++] = "example/sample/BE/SampleProjectBE_configuration/.ccsproject";
    Pkg.otherFiles[Pkg.otherFiles.length++] = "example/sample/BE/SampleProjectBE_configuration/.cdtproject";
    Pkg.otherFiles[Pkg.otherFiles.length++] = "example/sample/BE/SampleProjectBE_configuration/.project";
    Pkg.otherFiles[Pkg.otherFiles.length++] = "example/sample/BE/SampleProjectBE_configuration/.cdtbuild";
*/

}
