
/* Resource table defines */
#include "ti/drv/rm/test/rm_test.h"

#define RM_TEST_CORE0_PERMS \
    (RM_RESOURCE_FLAG_DSP_SHIFT(0, RM_RESOURCE_PERM_ALLOWED))

/** @brief QMSS DPSP default start and end ranges */
#define QMSS_PDSP_DEFAULT_START_RANGE (0u)
#define QMSS_PDSP_DEFAULT_END_RANGE (2u)
/** @brief QMSS queue default start and end ranges */
#define QMSS_QUEUE_DEFAULT_START_RANGE (0u)
#define QMSS_QUEUE_DEFAULT_END_RANGE (8192u)
/** @brief QMSS memory region default start and end ranges */
#define QMSS_MEM_REGION_DEFAULT_START_RANGE (0u)
#define QMSS_MEM_REGION_DEFAULT_END_RANGE (19u)
/** @brief QMSS Linking RAM default start and end ranges */
#define QMSS_LINK_RAM_DEFAULT_START_RANGE (0x00000000)
#define QMSS_LINK_RAM_DEFAULT_END_RANGE (0xFFFFFFFF)
/** @brief QMSS Accumulator channels default start and end ranges */
#define QMSS_ACCUM_CH_DEFAULT_START_RANGE (0u)
#define QMSS_ACCUM_CH_DEFAULT_END_RANGE (47u)
/** @brief QMSS QOS clusters default start and end ranges */
#define QMSS_QOS_CLUSTER_DEFAULT_START_RANGE (0u)
#define QMSS_QOS_CLUSTER_DEFAULT_END_RANGE (7u)
/** @brief QMSS QOS queue default start and end ranges */
#define QMSS_QOS_QUEUE_DEFAULT_START_RANGE (0u)
#define QMSS_QOS_QUEUE_DEFAULT_END_RANGE (63u)

/** @brief CPPI SRIO tx channels default start and end ranges */
#define CPPI_SRIO_TX_CH_DEFAULT_START_RANGE (0u)
#define CPPI_SRIO_TX_CH_DEFAULT_END_RANGE (15u)
/** @brief CPPI SRIO rx channels default start and end ranges */
#define CPPI_SRIO_RX_CH_DEFAULT_START_RANGE (0u)
#define CPPI_SRIO_RX_CH_DEFAULT_END_RANGE (15u)
/** @brief CPPI SRIO rx flows default start and end ranges */
#define CPPI_SRIO_FLOW_DEFAULT_START_RANGE (0u)
#define CPPI_SRIO_FLOW_DEFAULT_END_RANGE (19u)
/** @brief CPPI PASS tx channels default start and end ranges */
#define CPPI_PASS_TX_CH_DEFAULT_START_RANGE (0u)
#define CPPI_PASS_TX_CH_DEFAULT_END_RANGE (8u)
/** @brief CPPI PASS rx channels default start and end ranges */
#define CPPI_PASS_RX_CH_DEFAULT_START_RANGE (0u)
#define CPPI_PASS_RX_CH_DEFAULT_END_RANGE (23u)
/** @brief CPPI PASS rx flows default start and end ranges */
#define CPPI_PASS_FLOW_DEFAULT_START_RANGE (0u)
#define CPPI_PASS_FLOW_DEFAULT_END_RANGE (31u)
/** @brief CPPI QMSS tx channels default start and end ranges */
#define CPPI_QMSS_TX_CH_DEFAULT_START_RANGE (0u)
#define CPPI_QMSS_TX_CH_DEFAULT_END_RANGE (31u)
/** @brief CPPI QMSS rx channels default start and end ranges */
#define CPPI_QMSS_RX_CH_DEFAULT_START_RANGE (0u)
#define CPPI_QMSS_RX_CH_DEFAULT_END_RANGE (31u)
/** @brief CPPI QMSS rx flows default start and end ranges */
#define CPPI_QMSS_FLOW_DEFAULT_START_RANGE (0u)
#define CPPI_QMSS_FLOW_DEFAULT_END_RANGE (63u)

/** @brief PA LUT entry default start and end ranges */
#define PA_LUT_ENTRY_DEFAULT_START_RANGE (0u)
#define PA_LUT_ENTRY_DEFAULT_END_RANGE (4u)

/** @brief RM LLD resource table permissions
  * Must be cache line aligned. */
#pragma DATA_ALIGN (rmTestResourceTable, 128)
Rm_Resource rmTestResourceTable[] =
{
    /* Magic Number structure to verify RM can read the resource table */
    {
        /** DSP QMSS Firmware access */
        RM_RESOURCE_MAGIC_NUMBER,
        /** No start range */
        0u,
        /** No end range */
        0u,
        /** No init permissions */
        0u,
        /** No use permissions */
        0u,
    },

    /* QMSS Resource Definitions */

    {
        /** DSP QMSS PDSP Firmware access */
        RM_RESOURCE_QMSS_FIRMWARE_PDSP,
        /** PDSP start range */
        QMSS_PDSP_DEFAULT_START_RANGE,
        /** PDSP end range */
        QMSS_PDSP_DEFAULT_END_RANGE,
        /** Full permissions for DSP CORE0 */
        RM_TEST_CORE0_PERMS,
        /** Full use permissions for DSP CORE0 */
        RM_TEST_CORE0_PERMS,
    },
    {
        /** DSP QMSS queue access */
        RM_RESOURCE_QMSS_QUEUE,
        /** Queue start range*/
        QMSS_QUEUE_DEFAULT_START_RANGE,
        /** Queue end range */
        QMSS_QUEUE_DEFAULT_END_RANGE,
        /** Full permissions for DSP CORE0 */
        RM_TEST_CORE0_PERMS,
        /** Full use permissions for DSP CORE0 */
        RM_TEST_CORE0_PERMS,
    },
    {
        /** DSP QMSS Memory Region */
        RM_RESOURCE_QMSS_MEMORY_REGION,
        /** Memory Region start range*/
        QMSS_MEM_REGION_DEFAULT_START_RANGE,
        /** Memory Region end range */
        QMSS_MEM_REGION_DEFAULT_END_RANGE,
        /** Full permissions for DSP CORE0 */
        RM_TEST_CORE0_PERMS,
        /** Full use permissions for DSP CORE0 */
        RM_TEST_CORE0_PERMS,
    },
    {
        /** DSP QMSS Linking RAM Control access */
        RM_RESOURCE_QMSS_LINKING_RAM_CONTROL,
        /** No start range*/
        0u,
        /** No end range */
        0u,
        /** Full permissions for all DSPs */
        RM_TEST_CORE0_PERMS,
        /** Full use permissions for all DSPs */
        RM_TEST_CORE0_PERMS,
    },
    {
        /** DSP QMSS Linking RAM access */
        RM_RESOURCE_QMSS_LINKING_RAM,
        /** Linking RAM start range*/
        QMSS_LINK_RAM_DEFAULT_START_RANGE,
        /** Linking RAM end range */
        QMSS_LINK_RAM_DEFAULT_END_RANGE,
        /** Full permissions for DSP CORE0 */
        RM_TEST_CORE0_PERMS,
        /** Full use permissions for DSP CORE0 */
        RM_TEST_CORE0_PERMS,
    },
    {
        /** DSP QMSS accumulator channels */
        RM_RESOURCE_QMSS_ACCUMULATOR_CH,
        /** Accumulator channel start range*/
        QMSS_ACCUM_CH_DEFAULT_START_RANGE,
        /** Accumulator channel end range */
        QMSS_ACCUM_CH_DEFAULT_END_RANGE,
        /** Full permissions for DSP CORE0 */
        RM_TEST_CORE0_PERMS,
        /** Full use permissions for DSP CORE0 */
        RM_TEST_CORE0_PERMS,
    },

    {
        /** DSP QMSS QOS PDSP Timer */
        RM_RESOURCE_QMSS_QOS_PDSP_TIMER,
        /** No start range*/
        0u,
        /** No end range */
        0u,
        /** Full permissions for DSP CORE0 */
        RM_TEST_CORE0_PERMS,
        /** Full use permissions for DSP CORE0 */
        RM_TEST_CORE0_PERMS,        
    },      
    {
        /** DSP QMSS QOS clusters */
        RM_RESOURCE_QMSS_QOS_CLUSTER,
        /** QOS cluster start range*/
        QMSS_QOS_CLUSTER_DEFAULT_START_RANGE,
        /** QOS cluster end range */
        QMSS_QOS_CLUSTER_DEFAULT_END_RANGE,
        /** Full permissions for DSP CORE0 */
        RM_TEST_CORE0_PERMS,
        /** Full use permissions for DSP CORE0 */
        RM_TEST_CORE0_PERMS,        
    },  
    {
        /** DSP QMSS QOS queues */
        RM_RESOURCE_QMSS_QOS_QUEUE,
        /** QOS queues start range*/
        QMSS_QOS_QUEUE_DEFAULT_START_RANGE,
        /** QOS queues end range */
        QMSS_QOS_QUEUE_DEFAULT_END_RANGE,
        /** Full permissions for DSP CORE0 */
        RM_TEST_CORE0_PERMS,
        /** Full use permissions for DSP CORE0 */
        RM_TEST_CORE0_PERMS,        
    },      

    /* CPPI Resource Definitions */

    {
        /** DSP CPPI SRIO tx channels */
        RM_RESOURCE_CPPI_SRIO_TX_CH,
        /** CPPI SRIO tx channel start range*/
        CPPI_SRIO_TX_CH_DEFAULT_START_RANGE,
        /** CPPI SRIO tx channel  end range */
        CPPI_SRIO_TX_CH_DEFAULT_END_RANGE,
        /** Full permissions for DSP CORE0 */
        RM_TEST_CORE0_PERMS,
        /** Full use permissions for DSP CORE0 */
        RM_TEST_CORE0_PERMS,
    },
    {
        /** DSP CPPI SRIO rx channels */
        RM_RESOURCE_CPPI_SRIO_RX_CH,
        /** CPPI SRIO rx channel  start range*/
        CPPI_SRIO_RX_CH_DEFAULT_START_RANGE,
        /** CPPI SRIO rx channel  end range */
        CPPI_SRIO_RX_CH_DEFAULT_END_RANGE,
        /** Full permissions for DSP CORE0 */
        RM_TEST_CORE0_PERMS,
        /** Full use permissions for DSP CORE0 */
        RM_TEST_CORE0_PERMS,
    },
    {
        /** DSP CPPI SRIO rx flows */
        RM_RESOURCE_CPPI_SRIO_FLOW,
        /** CPPI SRIO rx flow start range*/
        CPPI_SRIO_FLOW_DEFAULT_START_RANGE,
        /** CPPI SRIO rx flow end range */
        CPPI_SRIO_FLOW_DEFAULT_END_RANGE,
        /** Full permissions for DSP CORE0 */
        RM_TEST_CORE0_PERMS,
        /** Full use permissions for DSP CORE0 */
        RM_TEST_CORE0_PERMS,
    },
    {
        /** DSP CPPI PASS tx channels */
        RM_RESOURCE_CPPI_PASS_TX_CH,
        /** CPPI PASS tx channel start range*/
        CPPI_PASS_TX_CH_DEFAULT_START_RANGE,
        /** CPPI PASS tx channel  end range */
        CPPI_PASS_TX_CH_DEFAULT_END_RANGE,
        /** Full permissions for DSP CORE0 */
        RM_TEST_CORE0_PERMS,
        /** Full use permissions for DSP CORE0 */
        RM_TEST_CORE0_PERMS,
    },
    {
        /** DSP CPPI PASS rx channels */
        RM_RESOURCE_CPPI_PASS_RX_CH,
        /** CPPI PASS rx channel  start range*/
        CPPI_PASS_RX_CH_DEFAULT_START_RANGE,
        /** CPPI PASS rx channel  end range */
        CPPI_PASS_RX_CH_DEFAULT_END_RANGE,
        /** Full permissions for DSP CORE0 */
        RM_TEST_CORE0_PERMS,
        /** Full use permissions for DSP CORE0 */
        RM_TEST_CORE0_PERMS,
    },
    {
        /** DSP CPPI PASS rx flows */
        RM_RESOURCE_CPPI_PASS_FLOW,
        /** CPPI PASS rx flow start range*/
        CPPI_PASS_FLOW_DEFAULT_START_RANGE,
        /** CPPI PASS rx flow end range */
        CPPI_PASS_FLOW_DEFAULT_END_RANGE,
        /** Full permissions for DSP CORE0 */
        RM_TEST_CORE0_PERMS,
        /** Full use permissions for DSP CORE0 */
        RM_TEST_CORE0_PERMS,
    },
    {
        /** DSP CPPI QMSS tx channels */
        RM_RESOURCE_CPPI_QMSS_TX_CH,
        /** CPPI QMSS tx channel start range*/
        CPPI_QMSS_TX_CH_DEFAULT_START_RANGE,
        /** CPPI QMSS tx channel  end range */
        CPPI_QMSS_TX_CH_DEFAULT_END_RANGE,
        /** Full permissions for DSP CORE0 */
        RM_TEST_CORE0_PERMS,
        /** Full use permissions for DSP CORE0 */
        RM_TEST_CORE0_PERMS,
    },
    {
        /** DSP CPPI QMSS rx channels */
        RM_RESOURCE_CPPI_QMSS_RX_CH,
        /** CPPI QMSS rx channel  start range*/
        CPPI_QMSS_RX_CH_DEFAULT_START_RANGE,
        /** CPPI QMSS rx channel  end range */
        CPPI_QMSS_RX_CH_DEFAULT_END_RANGE,
        /** Full permissions for DSP CORE0 */
        RM_TEST_CORE0_PERMS,
        /** Full use permissions for DSP CORE0 */
        RM_TEST_CORE0_PERMS,
    },
    {
        /** DSP CPPI QMSS rx flows */
        RM_RESOURCE_CPPI_QMSS_FLOW,
        /** CPPI QMSS rx flow start range*/
        CPPI_QMSS_FLOW_DEFAULT_START_RANGE,
        /** CPPI QMSS rx flow end range */
        CPPI_QMSS_FLOW_DEFAULT_END_RANGE,
        /** Full permissions for DSP CORE0 */
        RM_TEST_CORE0_PERMS,
        /** Full use permissions for DSP CORE0 */
        RM_TEST_CORE0_PERMS,
    },

    /* PA Resource Definitions */

    {
        /** DSP QMSS Firmware access */
        RM_RESOURCE_PA_FIRMWARE,
        /** No start range*/
        0u,
        /** No end range */
        0u,
        /** Full permissions for DSP CORE0 */
        RM_TEST_CORE0_PERMS,
        /** Full use permissions for DSP CORE0 */
        RM_TEST_CORE0_PERMS,
    },
    {
        /** DSP PA Look-up entry tables */
        RM_RESOURCE_PA_LUT_ENTRY,
        /** PA Look-up entry start range*/
        PA_LUT_ENTRY_DEFAULT_START_RANGE,
        /** PA Look-up entry end range */
        PA_LUT_ENTRY_DEFAULT_END_RANGE,
        /** Full init permissions for DSP CORE0 */
        RM_TEST_CORE0_PERMS,
        /** Full use permissions for DSP CORE0 */
        RM_TEST_CORE0_PERMS,
    },

    /* Final entry structure for RM to find the last entry of resource table */

    {
        /** Final entry */
        RM_RESOURCE_FINAL_ENTRY,
        /** No start range*/
        0u,
        /** No end range */
        0u,
        /** No init permissions */
        0u,
        /** No use permissions */
        0u,
    },

    /* Extra entries added to avoid a cache invalidate wiping out data placed after array
      * Seven extra entries covers an extra cache line */
    {RM_RESOURCE_FINAL_ENTRY, 0u, 0u, 0u, 0u},  /* extra entry: 1 */
    {RM_RESOURCE_FINAL_ENTRY, 0u, 0u, 0u, 0u},  /* extra entry: 2 */
    {RM_RESOURCE_FINAL_ENTRY, 0u, 0u, 0u, 0u},  /* extra entry: 3 */
    {RM_RESOURCE_FINAL_ENTRY, 0u, 0u, 0u, 0u},  /* extra entry: 4 */
    {RM_RESOURCE_FINAL_ENTRY, 0u, 0u, 0u, 0u},  /* extra entry: 5 */
    {RM_RESOURCE_FINAL_ENTRY, 0u, 0u, 0u, 0u},  /* extra entry: 6 */
    {RM_RESOURCE_FINAL_ENTRY, 0u, 0u, 0u, 0u}   /* extra entry: 7 */
};
