/* Standard includes */
#include <c6x.h>
#include <string.h>

/* XDC includes */
#include <xdc/std.h>
#include <xdc/runtime/Error.h>
#include <xdc/runtime/System.h>

/* BIOS includes */
#include <ti/sysbios/hal/Hwi.h>
#include <ti/sysbios/BIOS.h>

/* CSL Cache module includes */
#include <ti/csl/csl_cacheAux.h>
/* CSL XMC module includes */
#include <ti/csl/csl_xmcAux.h>
/* CSL Semaphore module includes */
#include <ti/csl/csl_semAux.h>

/* RM LLD include */
#include "ti/drv/rm/rm.h"

#ifndef RM_TEST_H
#define RM_TEST_H

#define MAX_NUM_CORES 8

#undef L2_CACHE
#ifdef L2_CACHE
    /* Invalidate L2 cache. This should invalidate L1D as well. 
     * Wait until operation is complete. */    
#define SYS_CACHE_INV(addr, size, code)    CACHE_invL2 (addr, size, code)

    /* Writeback L2 cache. This should Writeback L1D as well. 
     * Wait until operation is complete. */ 
#define SYS_CACHE_WB(addr, size, code)     CACHE_wbL2 (addr, size, code)

#else       
    /* Invalidate L1D cache and wait until operation is complete. 
     * Use this approach if L2 cache is not enabled */    
#define SYS_CACHE_INV(addr, size, code)    CACHE_invL1d (addr, size, code)
    /* Writeback L1D cache and wait until operation is complete. 
     * Use this approach if L2 cache is not enabled */    
#define SYS_CACHE_WB(addr, size, code)     CACHE_wbL1d (addr, size, code)

#endif

extern Rm_Resource rmTestResourceTable[];

typedef enum {
    rm_granted, /* RM granted the resource */
    rm_denied   /* RM denied the resource */
} rm_test_expect_e;

#define RM_PRINT_RESULT(name, expect, result, ret_val)\
do {\
if (expect == result)\
	System_printf ("RM test core id: %d, passed for %s, val %d\n", DNUM, name, ret_val);\
else\
	System_printf ("RM test core id: %d, failed for %s, val %d\n", DNUM, name, ret_val);\
} while(0)

void rm_test_cppi(Rm_Handle rm_handle, rm_test_expect_e expect);

void rm_test_qmss(Rm_Handle rm_handle, rm_test_expect_e expect);

#ifndef _C6657_Atrenta_DSP1_H_  /* C6657 does not have PA */
void rm_test_pa(Rm_Handle rm_handle, rm_test_expect_e expect);
#endif

#endif /*RM_TEST_H*/
