/**
 *   @file  qmss_test.c
 *
 *   @brief   
 *      This is the QMSS unit test code.
 *
 *  \par
 *  ============================================================================
 *  @n   (C) Copyright 2009-2012, Texas Instruments, Inc.
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  \par
*/

#include <xdc/std.h>
#include <xdc/runtime/System.h>

/* QMSS LLD include */
#include <ti/drv/qmss/qmss_drv.h>

/* CSL RL includes */
#include <ti/csl/csl_chip.h>

/* OSAL includes */
#include <qmss_osal.h>

/************************ GLOBAL VARIABLES ********************/

/* Error counter */
UInt32                  errorCount = 0;

/************************ EXTERN VARIABLES ********************/

extern Void run_test (Void); 

Void main (Void)
{
    UInt32                  corenum; 

    System_printf ("***********************************************************\n");
    System_printf ("******************* QMSS LLD Testing **********************\n");
    System_printf ("***********************************************************\n");

    /* Get the core number. */
    corenum = CSL_chipReadReg(CSL_CHIP_DNUM); 

    System_printf ("********************Test running on Core %d ********************\n", corenum);

    System_printf ("Version string: %s\n", Qmss_getVersionStr());
    run_test ();

    System_printf ("***********************************************************\n");
    System_printf ("******************** QMSS LLD Testing DONE ****************\n");
    System_printf ("***********************************************************\n");

    if (errorCount == 0)
        System_printf ("\nQMSS LLD ALL TESTS PASSED\n");
    else
        System_printf ("\nQMSS LLD %d TESTS FAILED\n", errorCount);
}

