/**  
 * @file fw_test.h
 *
 * @brief 
 *  Holds all the constants and API definitions required by the example
 *  application to run.
 *
 *  \par
 *  ============================================================================
 *  @n   (C) Copyright 2012, Texas Instruments, Inc.
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/
#ifndef _FW_TEST_H_
#define _FW_TEST_H_

/* C Standard library Include */
#include <stdio.h>
/* System level header files */
#include <stdint.h>

/* CPPI LLD include */
#include <ti/drv/cppi/cppi_drv.h>
#include <ti/drv/cppi/cppi_desc.h>

/* QMSS LLD include */
#include <ti/drv/qmss/qmss_drv.h>

#define CACHE_LINESZ    64

typedef uint16_t fw_Bool_t;
#define  fw_TRUE  1
#define  fw_FALSE  0

/* Total Permanent memory required in Example
 * for Packet buffers & descriptor buffers
 * Allocating entire MSMC
 */
#define MSMC_TEST_PERM_MEM_SZ   (2*1024*1024)

/* Physical address map & size for various subsystems */
#define QMSS_CFG_BASE_ADDR  CSL_QM_SS_CFG_QUE_PEEK_REGS
#define QMSS_CFG_BLK_SZ (1*1024*1024)
#define QMSS_DATA_BASE_ADDR 0x44020000 
#define QMSS_DATA_BASE_QUEUE_PROXY_ADDR 0x44040000 
#define QMSS_DATA_BLK_SZ (0x60000)
#define SRIO_CFG_BASE_ADDR  CSL_SRIO_CONFIG_REGS
#define SRIO_CFG_BLK_SZ (132*1024)
#define PASS_CFG_BASE_ADDR  CSL_PA_SS_CFG_REGS 
#define PASS_CFG_BLK_SZ (1*1024*1024)
#define MSMC_SRAM_BASE_ADDR CSL_MSMC_SRAM_REGS

/* Global variables to hold virtual address of various subsystems */
void *fw_qmssCfgVaddr;
void *fw_qmssDataVaddr;
void *fw_srioCfgVaddr;
void *fw_passCfgVaddr;


/** Enable Extended Debug with printfs */
//#define EXT_DEBUG 1

/* Invalidate  cache. This should invalidate Cache
 * Wait until operation is complete. Currently stub function
 */    
#define SYS_CACHE_INV(addr, size, code)  Osal_invalidateCache(addr,size)  

/* Writeback L2 cache. This should Writeback L1D as well. 
 * Wait until operation is complete. Currently stub function
 */ 
#define SYS_CACHE_WB(addr, size, code) Osal_writeBackCache(addr,size) 

/* GCC align attribute */
#define ALIGN(x)    __attribute__((aligned (x)))

/**********************************/
/* Resources used by Linux Kernel */
/**********************************/

/* Memory region used by the Kernel */
#define KERNEL_QMSS_MEM_REGION  5
#define KERNEL_QMSS_MEM_REG_START_IDX   0x2000

/* CPPI FLow used by the Kernel */
#define KERNEL_CPPI_RX_FLOW 31

/* General Purpose Queues used by the Kernel */
#define KERNEL_QMSS_GP_QUEUE_START  4000
#define KERNEL_QMSS_GP_QUEUE_NUM    2 

/* High priority Accumulator Queues used by the Kernel */
#define KERNEL_QMSS_ACC_QUEUE_START  732
#define KERNEL_QMSS_ACC_QUEUE_NUM    2 

#endif

