#!/bin/bash
# REM ******************************************************************************
# REM * FILE PURPOSE: PDK Builder
# REM ******************************************************************************
# REM * FILE NAME: pdkbuilder.bat
# REM *
# REM * DESCRIPTION: 
# REM *  The shell script file cleans and builds the installed PDK components. Please
# REM *  make sure that the PDK Build Environment is setup correctly before calling
# REM *  this file. Following environment variables will be pre-requisite before running the batch file
# REM *  C6X_GEN_INSTALL_PATH: Installation directory for Code Generation Tool
# REM *
# REM * Copyright (C) 2011, Texas Instruments, Inc.
# REM *****************************************************************************

# REM *****************************************************************************
# REM Clean all components which are a part of the PDK repository
# REM *****************************************************************************
make -C ti/csl            LIBDIR=./lib clean
make -C ti/drv/qmss       LIBDIR=./lib clean
make -C ti/drv/cppi       LIBDIR=./lib clean
make -C ti/drv/pa         LIBDIR=./lib clean
make -C ti/drv/tsip       LIBDIR=./lib clean
make -C ti/drv/hyplnk     LIBDIR=./lib clean
make -C ti/drv/srio       LIBDIR=./lib clean
make -C ti/drv/pcie       LIBDIR=./lib clean

# REM *****************************************************************************
# REM Build both BE and LE libraries
# REM *****************************************************************************
make -C ti/csl            LIBDIR=./lib all
make -C ti/drv/qmss       LIBDIR=./lib all
make -C ti/drv/cppi       LIBDIR=./lib all
make -C ti/drv/pa         LIBDIR=./lib all
make -C ti/drv/tsip       LIBDIR=./lib all
make -C ti/drv/hyplnk     LIBDIR=./lib all
make -C ti/drv/srio       LIBDIR=./lib all
make -C ti/drv/pcie       LIBDIR=./lib all

# REM *****************************************************************************
# REM  DONE
# REM *****************************************************************************

