/*  ============================================================================
 *   Copyright (c) Texas Instruments Incorporated 2010
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/


/**  
 * @file pcie_sample.h
 *
 * @brief 
 *  Holds all the constants and API definitions required by the example
 *  application to run.  
 *
 *  \par
 *  ============================================================================
 *  @n   (C) Copyright 2010, Texas Instruments, Inc.
 *  @n   Use of this software is controlled by the terms and conditions found 
 *  @n   in the license agreement under which this software has been supplied.
 *  ===========================================================================
 *  \par 
 */

#ifndef _PCIE_SAMPLE_H_
#define _PCIE_SAMPLE_H_

/* C Standard library include */
#include <string.h>

/* XDC include */
#include <xdc/std.h>
//#include <xdc/runtime/System.h>

/* BIOS include */
#include <ti/sysbios/BIOS.h>
#include <ti/sysbios/knl/Task.h>
#include <ti/sysbios/family/c64p/EventCombiner.h>
#include <ti/sysbios/family/c64p/Hwi.h>
#include <ti/sysbios/knl/Event.h>

/* CSL include */
#include <ti/csl/csl_pscAux.h>
#include <ti/csl/cslr_device.h>

/* PCIE LLD include */
#include <ti/drv/pcie/pcie.h>

/* Size of application buffers */
#define PCIE_BUFSIZE_APP 40 

/* Write pattern */
#define PCIE_WR_PATTERN 0xFACEFACE

/* In this example all addresses are 32bit */
/* Outbound Base Address for PCIe Master */
#define PCIE_OB_LO_ADDR_M    0x70000000
#define PCIE_OB_HI_ADDR_M    0

/* Inbound  Base Address for PCIe Master */
#define PCIE_IB_LO_ADDR_M    0x90000000
#define PCIE_IB_HI_ADDR_M    0

/* Outbound Base Address for PCIe Slave */
#define PCIE_OB_LO_ADDR_S    PCIE_IB_LO_ADDR_M
#define PCIE_OB_HI_ADDR_S    0

/* Inbound  Base Address for PCIe Slave */
#define PCIE_IB_LO_ADDR_S    PCIE_OB_LO_ADDR_M
#define PCIE_IB_HI_ADDR_S    0

/* BAR mask */
#define PCIE_BAR_MASK         0x0FFFFFFF

/* BAR Index PCie*/
#define PCIE_BAR_IDX_M         1
#define PCIE_BAR_IDX_S         1


/* PCIe Regions used in the example */
#define PCIE_IB_REGION_M    0
#define PCIE_OB_REGION_M    0
#define PCIE_IB_REGION_S    0
#define PCIE_OB_REGION_S    0



#endif
