/*
 *
 * Copyright (C) 2010 Texas Instruments Incorporated - http://www.ti.com/ 
 * 
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/




#include "pautest.h"

Void topLevelTest (UArg a0, UArg a1);

/* NULL terminated The list of tests */
extern paTest_t  paTestList[];

/* The exit code is a global. This is used so
 * the clock function can terminate the program with
 * the proper exit code */
Int exitCode;


/* Creates a single task - the top level task. This is a low priority task that
 * spawns the individual tests */
extern cregister volatile unsigned int TSCL;
Void main ()
{
	Task_Params tparams;
	
	/* The only initial task is the top level test */
	Task_Params_init (&tparams);
	tparams.instance->name = "Top Level Test";
	tparams.priority      = 1;
	
	Task_create (topLevelTest, &tparams, NULL);
	
	/* Start the cycle counter */
	TSCL = 1;
	
	BIOS_start ();
}


Void clk1Fxn (UArg a0)
{
	BIOS_exit (exitCode);
}

/* Initialize the test framework and launch the individual tests */
Void topLevelTest (UArg a0, UArg a1)
{
	Task_Params tparams;
	Task_Handle thandle;
	Task_Stat   tstat;
	
	Clock_Handle clkh;       
    Clock_Params clkParams;
    
	Int i;
	
	Int passCount;
	Int failCount;
	Int notRunCount;
	
	/* For some reason some printfs are lost unless there is a delay between System_flush
	 * and System_exit, so delay is forced */	
	Clock_Params_init(&clkParams);
    clkParams.period    = 0;
    clkParams.startFlag = FALSE;
    clkh = Clock_create(clk1Fxn, 1, &clkParams, NULL);
    
    System_printf ("\n\n ------- PA Unit Test Starting ---------\n");
    
    /* Initialize the PA, PA cpdma, QM and CPPI. Each test will use
     * the same framework */
    if (setupTestFramework ())  {
    	System_printf ("topLevelTest (%s:%d): setupTestFramework returned error, exiting\n", __FILE__, __LINE__);
    	System_flush ();
    	exitCode = -1;
    	Clock_start(clkh);
    	Task_exit ();
    }
    
    /* Make sure the setup matches what is expected */
    if (verifyTestFramework())  {
    	System_printf ("topLevelTest (%s:%d): verifyTestFramework returned error after initial framework setup, exiting\n", __FILE__, __LINE__);
    	System_flush();
    	exitCode = -1;
    	Clock_start(clkh);
    	Task_exit ();
    }
     
    /* Configure task parameters common to all test tasks */
    Task_Params_init (&tparams);
    tparams.priority = 2;
    tparams.arg0     = (UArg) &tFramework;
	
	/* Run the tests */
	for (i = 0; paTestList[i].testFunction != NULL; i++ )  {
		
		tparams.arg1 = (UArg)&paTestList[i];
		tparams.instance->name = paTestList[i].name;
		
		thandle = Task_create (paTestList[i].testFunction, &tparams, NULL);
		
		/* The test task will terminate upon completion. Verify that the
		 * task has completed in case the task itself uses multiple tasks
		 * that all wind up idle for a while. */
		do  {
			Task_stat (thandle, &tstat);
		} while (tstat.mode != Task_Mode_TERMINATED);
		
		Task_delete (&thandle);
		
		if (paTestList[i].testStatus == PA_TEST_PASSED)
		  System_printf ("%s:  PASSED\n", paTestList[i].name);
		else
		  System_printf ("%s:  FAILED\n", paTestList[i].name);
		  
		System_flush();
		
		/* Do a quick check of the test framework */
		if (verifyTestFramework ())  {
			System_printf ("topLevelTest (%s:%d): verifyTestFramework returned error after test %s. Exiting.\n", __FILE__, __LINE__, paTestList[i].name);
			exitCode = -1;
			System_flush ();
			Clock_start(clkh);
		}
	} 
		
	
	/* Summarize the test results */
	for (i = passCount = failCount = notRunCount = 0; paTestList[i].testFunction != NULL; i++)  {
		if (paTestList[i].testStatus == PA_TEST_PASSED)
			passCount += 1;
		else if (paTestList[i].testStatus == PA_TEST_FAILED)
			failCount += 1;
		else
			notRunCount += 1;
	}
	
	System_printf ("\n\nTest summary:\n\tTests Passed: %d\n\tTests Failed: %d\n\tTests not run: %d\n\n",
	  passCount, failCount, notRunCount);
	


	System_printf ("\n\n ------- PA Unit Test Complete ---------\n");
	System_flush();
	Clock_start(clkh);
	
	Task_exit();
}




