/*
 *
 * Copyright (C) 2010-2012 Texas Instruments Incorporated - http://www.ti.com/ 
 * 
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/



/* Static memory allocation for test framework */

#include "pautest.h"

tFramework_t tFramework;

/* HW interrupt disable handle */
GateHwi_Handle gateHwi;

#pragma DATA_ALIGN(memPaInst, TF_CACHE_LINESZ)
UInt8 memPaInst[TF_ROUND_UP(TF_PA_INST_SIZE, TF_CACHE_LINESZ)];

#pragma DATA_ALIGN(memL2Ram, TF_CACHE_LINESZ)
UInt8 memL2Ram[TF_ROUND_UP(TF_L2_TABLE_SIZE, TF_CACHE_LINESZ)];

#pragma DATA_ALIGN(memL3Ram, TF_CACHE_LINESZ);
UInt8 memL3Ram[TF_ROUND_UP(TF_L3_TABLE_SIZE, TF_CACHE_LINESZ)];

#pragma DATA_ALIGN(memUsrStatsLnkTbl, TF_CACHE_LINESZ);
UInt8 memUsrStatsLnkTbl[TF_ROUND_UP(TF_USR_STATS_LNK_TABLE_SIZE, TF_CACHE_LINESZ)];

/* Memory used for the linking RAM and descriptor RAM */
#pragma DATA_ALIGN(memLinkRam, 16)
UInt64 memLinkRam[TF_NUM_DESC];

#pragma DATA_ALIGN(memDescRam, 16)
UInt8 memDescRam[TF_NUM_DESC * TF_SIZE_DESC];

/* Queue handles */
Int32 QPaTx[TF_PA_NUM_TX_CPDMA_CHANNELS];
Int32 QfreeDesc;		      	/* Unassociated descriptor queue handle */
Int32 QtDown;				  	/* Teardown queue handle */
Int32 QLinkedBuf1;			  	/* Queue of descriptors with linked buffers */
Int32 QLinkedBuf2;			  	/* Queue of descriptors with linked buffers */
Int32 QLinkedBuf3;			  	/* Queue of descriptors with linked buffers */
Int32 QGen[TF_NUM_GEN_QUEUES];	/* General Use queues */


/* PA CPDMA instance and channel handles */
Cppi_Handle tfPaCppiHandle;
Cppi_ChHnd  tfPaTxChHnd[TF_PA_NUM_TX_CPDMA_CHANNELS];
Cppi_ChHnd  tfPaRxChHnd[TF_PA_NUM_RX_CPDMA_CHANNELS];


/* Packet buffers attached to descriptors */
#pragma DATA_ALIGN(memQ1, 16)
#pragma DATA_ALIGN(memQ2, 16)
#pragma DATA_ALIGN(memQ3, 16)
UChar memQ1[TF_LINKED_BUF_Q1_NBUFS][TF_LINKED_BUF_Q1_BUF_SIZE];
UChar memQ2[TF_LINKED_BUF_Q2_NBUFS][TF_LINKED_BUF_Q2_BUF_SIZE];
UChar memQ3[TF_LINKED_BUF_Q3_NBUFS][TF_LINKED_BUF_Q3_BUF_SIZE];

/* Semaphore handles for PA tables */
Semaphore_Handle tfPaTableL2;
Semaphore_Handle tfPaTableL3;


/* Flow handles */
Cppi_FlowHnd tfPaFlowHnd;


