/******************************************************************************
 * FILE PURPOSE: HYPLNK Source module specification file.
 ******************************************************************************
 * FILE NAME: module.xs
 *
 * DESCRIPTION: 
 *  This file contains the module specification for the HYPLNK source directory.
 *
 * Copyright (C) 2009, Texas Instruments, Inc.
 *****************************************************************************/

/* Load the library utility. */
var libUtility = xdc.loadCapsule ("../build/buildlib.xs");

/**************************************************************************
 * FUNCTION NAME : modBuild
 **************************************************************************
 * DESCRIPTION   :
 *  The function is used to build all the components of the HYPLNK library
 **************************************************************************/
function modBuild() 
{
    /* Explicitly list each source file */
    Pkg.otherFiles[Pkg.otherFiles.length++] = "example/memoryMappedExample/hyplnkExample.c";
    Pkg.otherFiles[Pkg.otherFiles.length++] = "example/memoryMappedExample/memoryMappedExample.cfg";
    Pkg.otherFiles[Pkg.otherFiles.length++] = "example/common/hyplnkIsr.c";
    Pkg.otherFiles[Pkg.otherFiles.length++] = "example/common/hyplnkIsr.h";
    Pkg.otherFiles[Pkg.otherFiles.length++] = "example/common/hyplnkLLDCfg.h";
    Pkg.otherFiles[Pkg.otherFiles.length++] = "example/common/hyplnkPlatCfg.h";
    Pkg.otherFiles[Pkg.otherFiles.length++] = "example/common/hyplnkLLDIFace.c";
    Pkg.otherFiles[Pkg.otherFiles.length++] = "example/common/hyplnkLLDIFace.h";
    /* Add the Readme.txt to the package */
    Pkg.otherFiles[Pkg.otherFiles.length++] = "example/memoryMappedExample/Readme.txt";
    /* Add project files */
    Pkg.otherFiles[Pkg.otherFiles.length++] = "example/memoryMappedExample/hyplnk_exampleProject.txt";
}

