/********************************************************************
* Copyright (C) 2003-2010 Texas Instruments Incorporated.
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/
#ifndef _CSLR_PCIE_CFG_SPACE_ENDPOINT_H_
#define _CSLR_PCIE_CFG_SPACE_ENDPOINT_H_

#include <ti/csl/cslr.h>
#include <ti/csl/tistdtypes.h>



/* Minimum unit = 1 byte */

/**************************************************************************\
* Register Overlay Structure
\**************************************************************************/
typedef struct  {
    volatile Uint32 VENDOR_DEVICE_ID;
    volatile Uint32 STATUS_COMMAND;
    volatile Uint32 CLASSCODE_REVID;
    volatile Uint32 BIST_HEADER;
    volatile Uint32 BAR[6];
    volatile Uint32 CARDBUS;
    volatile Uint32 SUBSYS_VNDR_ID;
    volatile Uint32 EXPNSN_ROM;
    volatile Uint32 CAP_PTR;
    volatile Uint8 RSVD0[4];
    volatile Uint32 INT_PIN;
    volatile Uint32 PMCAP;
    volatile Uint32 PM_CTL_STAT;
    volatile Uint8 RSVD1[8];
    volatile Uint32 MSI_CAP;
    volatile Uint32 MSI_LOW32;
    volatile Uint32 MSI_UP32;
    volatile Uint32 MSI_DATA;
    volatile Uint8 RSVD2[16];
    volatile Uint32 PCIES_CAP;
    volatile Uint32 DEVICE_CAP;
    volatile Uint32 DEV_STAT_CTRL;
    volatile Uint32 LINK_CAP;
    volatile Uint32 LINK_STAT_CTRL;
    volatile Uint8 RSVD3[16];
    volatile Uint32 DEV_CAP2;
    volatile Uint32 DEV_STAT_CTRL2;
    volatile Uint8 RSVD4[4];
    volatile Uint32 LINK_CTRL2;
    volatile Uint8 RSVD5[92];
    volatile Uint32 PCIE_EXTCAP;
    volatile Uint32 PCIE_UNCERR;
    volatile Uint32 PCIE_UNCERR_MASK;
    volatile Uint32 PCIE_UNCERR_SVRTY;
    volatile Uint32 PCIE_CERR;
    volatile Uint32 PCIE_CERR_MASK;
    volatile Uint32 PCIE_ACCR;
    volatile Uint32 HDR_LOG[4];
    volatile Uint32 RC_ERR_CMD;
    volatile Uint32 RC_ERR_ST;
    volatile Uint32 ERR_SRC_ID;
    volatile Uint8 RSVD6[1480];
    volatile Uint32 PL_ACKTIMER;
    volatile Uint32 PL_OMSG;
    volatile Uint32 PL_FORCE_LINK;
    volatile Uint32 ACK_FREQ;
    volatile Uint32 PL_LINK_CTRL;
    volatile Uint32 LANE_SKEW;
    volatile Uint32 SYM_NUM;
    volatile Uint32 SYMTIMER_FLTMASK;
    volatile Uint32 FLT_MASK2;
    volatile Uint8 RSVD7[4];
    volatile Uint32 DEBUG0;
    volatile Uint32 DEBUG1;
    volatile Uint8 RSVD8[220];
    volatile Uint32 PL_GEN2;
} CSL_Pcie_cfg_space_endpointRegs;

/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* VENDOR_DEVICE_ID */

#define CSL_PCIE_CFG_SPACE_ENDPOINT_VENDOR_DEVICE_ID_VENDOR_ID_MASK (0xFFFF0000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_VENDOR_DEVICE_ID_VENDOR_ID_SHIFT (0x00000010u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_VENDOR_DEVICE_ID_VENDOR_ID_RESETVAL (0x00008888u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_VENDOR_DEVICE_ID_DEVICE_ID_MASK (0x0000FFFFu)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_VENDOR_DEVICE_ID_DEVICE_ID_SHIFT (0x00000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_VENDOR_DEVICE_ID_DEVICE_ID_RESETVAL (0x0000104Cu)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_VENDOR_DEVICE_ID_RESETVAL (0x8888104Cu)

/* STATUS_COMMAND */

#define CSL_PCIE_CFG_SPACE_ENDPOINT_STATUS_COMMAND_PARITY_ERROR_MASK (0x80000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_STATUS_COMMAND_PARITY_ERROR_SHIFT (0x0000001Fu)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_STATUS_COMMAND_PARITY_ERROR_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_STATUS_COMMAND_SIGNALED_SYSTEM_ERROR_MASK (0x40000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_STATUS_COMMAND_SIGNALED_SYSTEM_ERROR_SHIFT (0x0000001Eu)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_STATUS_COMMAND_SIGNALED_SYSTEM_ERROR_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_STATUS_COMMAND_RECEIVED_MASTER_ABORT_MASK (0x20000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_STATUS_COMMAND_RECEIVED_MASTER_ABORT_SHIFT (0x0000001Du)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_STATUS_COMMAND_RECEIVED_MASTER_ABORT_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_STATUS_COMMAND_RECEIVED_TARGET_ABORT_MASK (0x10000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_STATUS_COMMAND_RECEIVED_TARGET_ABORT_SHIFT (0x0000001Cu)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_STATUS_COMMAND_RECEIVED_TARGET_ABORT_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_STATUS_COMMAND_SIGNALED_TARGET_ABORT_MASK (0x08000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_STATUS_COMMAND_SIGNALED_TARGET_ABORT_SHIFT (0x0000001Bu)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_STATUS_COMMAND_SIGNALED_TARGET_ABORT_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_STATUS_COMMAND_DATA_PARITY_ERROR_MASK (0x01000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_STATUS_COMMAND_DATA_PARITY_ERROR_SHIFT (0x00000018u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_STATUS_COMMAND_DATA_PARITY_ERROR_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_STATUS_COMMAND_CAPABILITIES_LIST_MASK (0x00100000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_STATUS_COMMAND_CAPABILITIES_LIST_SHIFT (0x00000014u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_STATUS_COMMAND_CAPABILITIES_LIST_RESETVAL (0x00000001u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_STATUS_COMMAND_INTERRUPT_STATUS_MASK (0x00080000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_STATUS_COMMAND_INTERRUPT_STATUS_SHIFT (0x00000013u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_STATUS_COMMAND_INTERRUPT_STATUS_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_STATUS_COMMAND_INTX_DISABLE_MASK (0x00000400u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_STATUS_COMMAND_INTX_DISABLE_SHIFT (0x0000000Au)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_STATUS_COMMAND_INTX_DISABLE_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_STATUS_COMMAND_SERR_ENABLE_MASK (0x00000100u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_STATUS_COMMAND_SERR_ENABLE_SHIFT (0x00000008u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_STATUS_COMMAND_SERR_ENABLE_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_STATUS_COMMAND_PARITY_ERROR_RESPONSE_MASK (0x00000040u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_STATUS_COMMAND_PARITY_ERROR_RESPONSE_SHIFT (0x00000006u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_STATUS_COMMAND_PARITY_ERROR_RESPONSE_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_STATUS_COMMAND_BUS_MASTER_MASK (0x00000004u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_STATUS_COMMAND_BUS_MASTER_SHIFT (0x00000002u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_STATUS_COMMAND_BUS_MASTER_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_STATUS_COMMAND_MEMORY_SPACE_MASK (0x00000002u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_STATUS_COMMAND_MEMORY_SPACE_SHIFT (0x00000001u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_STATUS_COMMAND_MEMORY_SPACE_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_STATUS_COMMAND_IO_SPACE_MASK (0x00000001u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_STATUS_COMMAND_IO_SPACE_SHIFT (0x00000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_STATUS_COMMAND_IO_SPACE_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_STATUS_COMMAND_RESETVAL (0x00100000u)

/* CLASSCODE_REVID */

#define CSL_PCIE_CFG_SPACE_ENDPOINT_CLASSCODE_REVID_CLASS_CODE_MASK (0xFFFFFF00u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_CLASSCODE_REVID_CLASS_CODE_SHIFT (0x00000008u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_CLASSCODE_REVID_CLASS_CODE_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_CLASSCODE_REVID_REVISION_ID_MASK (0x000000FFu)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_CLASSCODE_REVID_REVISION_ID_SHIFT (0x00000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_CLASSCODE_REVID_REVISION_ID_RESETVAL (0x00000001u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_CLASSCODE_REVID_RESETVAL (0x00000001u)

/* BIST_HEADER */

#define CSL_PCIE_CFG_SPACE_ENDPOINT_BIST_HEADER_BIST_CAPABLE_MASK (0x80000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_BIST_HEADER_BIST_CAPABLE_SHIFT (0x0000001Fu)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_BIST_HEADER_BIST_CAPABLE_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_BIST_HEADER_START_BIST_MASK (0x40000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_BIST_HEADER_START_BIST_SHIFT (0x0000001Eu)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_BIST_HEADER_START_BIST_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_BIST_HEADER_COMPLETION_CODE_MASK (0x0F000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_BIST_HEADER_COMPLETION_CODE_SHIFT (0x00000018u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_BIST_HEADER_COMPLETION_CODE_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_BIST_HEADER_MULTI_FUNCTION_DEVICE_MASK (0x00800000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_BIST_HEADER_MULTI_FUNCTION_DEVICE_SHIFT (0x00000017u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_BIST_HEADER_MULTI_FUNCTION_DEVICE_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_BIST_HEADER_HEADER_TYPE_MASK (0x007F0000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_BIST_HEADER_HEADER_TYPE_SHIFT (0x00000010u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_BIST_HEADER_HEADER_TYPE_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_BIST_HEADER_LATENCY_TIMER_MASK (0x0000FF00u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_BIST_HEADER_LATENCY_TIMER_SHIFT (0x00000008u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_BIST_HEADER_LATENCY_TIMER_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_BIST_HEADER_CACHE_LINE_SIZE_MASK (0x000000FFu)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_BIST_HEADER_CACHE_LINE_SIZE_SHIFT (0x00000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_BIST_HEADER_CACHE_LINE_SIZE_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_BIST_HEADER_RESETVAL (0x00000000u)

/* BAR */

#define CSL_PCIE_CFG_SPACE_ENDPOINT_BAR_BASE_ADDRESS_MASK (0xFFFFFFF0u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_BAR_BASE_ADDRESS_SHIFT (0x00000004u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_BAR_BASE_ADDRESS_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_BAR_PREFETCHABLE_MASK (0x00000008u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_BAR_PREFETCHABLE_SHIFT (0x00000003u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_BAR_PREFETCHABLE_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_BAR_TYPE_MASK (0x00000006u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_BAR_TYPE_SHIFT (0x00000001u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_BAR_TYPE_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_BAR_MEMORY_SPACE_MASK (0x00000001u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_BAR_MEMORY_SPACE_SHIFT (0x00000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_BAR_MEMORY_SPACE_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_BAR_RESETVAL (0x00000000u)

/* CARDBUS */

#define CSL_PCIE_CFG_SPACE_ENDPOINT_CARDBUS_RESERVED_MASK (0xFFFFFFFFu)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_CARDBUS_RESERVED_SHIFT (0x00000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_CARDBUS_RESERVED_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_CARDBUS_RESETVAL (0x00000000u)

/* SUBSYS_VNDR_ID */

#define CSL_PCIE_CFG_SPACE_ENDPOINT_SUBSYS_VNDR_ID_SUBSYSTEM_ID_MASK (0xFFFF0000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_SUBSYS_VNDR_ID_SUBSYSTEM_ID_SHIFT (0x00000010u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_SUBSYS_VNDR_ID_SUBSYSTEM_ID_RESETVAL (0x00000001u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_SUBSYS_VNDR_ID_SUBSYSTEM_VENDOR_ID_MASK (0x0000FFFFu)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_SUBSYS_VNDR_ID_SUBSYSTEM_VENDOR_ID_SHIFT (0x00000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_SUBSYS_VNDR_ID_SUBSYSTEM_VENDOR_ID_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_SUBSYS_VNDR_ID_RESETVAL (0x00010000u)

/* EXPNSN_ROM */

#define CSL_PCIE_CFG_SPACE_ENDPOINT_EXPNSN_ROM_EXPANSION_ROM_BASE_ADDRESS_MASK (0xFFFFF800u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_EXPNSN_ROM_EXPANSION_ROM_BASE_ADDRESS_SHIFT (0x0000000Bu)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_EXPNSN_ROM_EXPANSION_ROM_BASE_ADDRESS_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_EXPNSN_ROM_EXPANSION_ROM_ENABLE_MASK (0x00000001u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_EXPNSN_ROM_EXPANSION_ROM_ENABLE_SHIFT (0x00000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_EXPNSN_ROM_EXPANSION_ROM_ENABLE_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_EXPNSN_ROM_RESETVAL (0x00000000u)

/* CAP_PTR */

#define CSL_PCIE_CFG_SPACE_ENDPOINT_CAP_PTR_CAP_PTR_MASK (0x000000FFu)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_CAP_PTR_CAP_PTR_SHIFT (0x00000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_CAP_PTR_CAP_PTR_RESETVAL (0x00000040u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_CAP_PTR_RESETVAL (0x00000040u)

/* INT_PIN */

#define CSL_PCIE_CFG_SPACE_ENDPOINT_INT_PIN_MAX_LATENCY_MASK (0xFF000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_INT_PIN_MAX_LATENCY_SHIFT (0x00000018u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_INT_PIN_MAX_LATENCY_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_INT_PIN_MIN_GRANT_MASK (0x00FF0000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_INT_PIN_MIN_GRANT_SHIFT (0x00000010u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_INT_PIN_MIN_GRANT_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_INT_PIN_INT_PIN_MASK (0x0000FF00u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_INT_PIN_INT_PIN_SHIFT (0x00000008u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_INT_PIN_INT_PIN_RESETVAL (0x00000001u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_INT_PIN_INT_LINE_MASK (0x000000FFu)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_INT_PIN_INT_LINE_SHIFT (0x00000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_INT_PIN_INT_LINE_RESETVAL (0x000000FFu)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_INT_PIN_RESETVAL (0x000001FFu)

/* PMCAP */

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PMCAP_PME_SUPP_N_MASK (0xF8000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PMCAP_PME_SUPP_N_SHIFT (0x0000001Bu)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PMCAP_PME_SUPP_N_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PMCAP_D2_SUPP_N_MASK (0x04000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PMCAP_D2_SUPP_N_SHIFT (0x0000001Au)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PMCAP_D2_SUPP_N_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PMCAP_D1_SUPP_N_MASK (0x02000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PMCAP_D1_SUPP_N_SHIFT (0x00000019u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PMCAP_D1_SUPP_N_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PMCAP_AUX_CURR_N_MASK (0x01C00000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PMCAP_AUX_CURR_N_SHIFT (0x00000016u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PMCAP_AUX_CURR_N_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PMCAP_DSI_N_MASK (0x00200000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PMCAP_DSI_N_SHIFT (0x00000015u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PMCAP_DSI_N_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PMCAP_PME_CLK_MASK (0x00080000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PMCAP_PME_CLK_SHIFT (0x00000013u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PMCAP_PME_CLK_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PMCAP_PME_SPEC_VER_MASK (0x00070000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PMCAP_PME_SPEC_VER_SHIFT (0x00000010u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PMCAP_PME_SPEC_VER_RESETVAL (0x00000003u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PMCAP_PM_NEXT_PTR_MASK (0x0000FF00u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PMCAP_PM_NEXT_PTR_SHIFT (0x00000008u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PMCAP_PM_NEXT_PTR_RESETVAL (0x00000050u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PMCAP_PM_CAP_ID_MASK (0x000000FFu)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PMCAP_PM_CAP_ID_SHIFT (0x00000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PMCAP_PM_CAP_ID_RESETVAL (0x00000001u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PMCAP_RESETVAL (0x00035001u)

/* PM_CTL_STAT */

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PM_CTL_STAT_DATA_REG_MASK (0xFF000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PM_CTL_STAT_DATA_REG_SHIFT (0x00000018u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PM_CTL_STAT_DATA_REG_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PM_CTL_STAT_CLK_CTRL_EN_MASK (0x00800000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PM_CTL_STAT_CLK_CTRL_EN_SHIFT (0x00000017u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PM_CTL_STAT_CLK_CTRL_EN_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PM_CTL_STAT_B2_B3_SUPPORT_MASK (0x00400000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PM_CTL_STAT_B2_B3_SUPPORT_SHIFT (0x00000016u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PM_CTL_STAT_B2_B3_SUPPORT_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PM_CTL_STAT_PME_STATUS_MASK (0x00008000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PM_CTL_STAT_PME_STATUS_SHIFT (0x0000000Fu)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PM_CTL_STAT_PME_STATUS_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PM_CTL_STAT_DATA_SCALE_MASK (0x00006000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PM_CTL_STAT_DATA_SCALE_SHIFT (0x0000000Du)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PM_CTL_STAT_DATA_SCALE_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PM_CTL_STAT_DATA_SELECT_MASK (0x00001E00u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PM_CTL_STAT_DATA_SELECT_SHIFT (0x00000009u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PM_CTL_STAT_DATA_SELECT_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PM_CTL_STAT_PME_EN_MASK (0x00000100u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PM_CTL_STAT_PME_EN_SHIFT (0x00000008u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PM_CTL_STAT_PME_EN_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PM_CTL_STAT_NO_SOFT_RST_MASK (0x00000008u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PM_CTL_STAT_NO_SOFT_RST_SHIFT (0x00000003u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PM_CTL_STAT_NO_SOFT_RST_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PM_CTL_STAT_PWR_STATE_MASK (0x00000003u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PM_CTL_STAT_PWR_STATE_SHIFT (0x00000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PM_CTL_STAT_PWR_STATE_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PM_CTL_STAT_RESETVAL (0x00000000u)

/* MSI_CAP */

#define CSL_PCIE_CFG_SPACE_ENDPOINT_MSI_CAP_64BIT_EN_MASK (0x00800000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_MSI_CAP_64BIT_EN_SHIFT (0x00000017u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_MSI_CAP_64BIT_EN_RESETVAL (0x00000001u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_MSI_CAP_MULT_MSG_EN_MASK (0x00700000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_MSI_CAP_MULT_MSG_EN_SHIFT (0x00000014u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_MSI_CAP_MULT_MSG_EN_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_MSI_CAP_MULT_MSG_CAP_MASK (0x000E0000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_MSI_CAP_MULT_MSG_CAP_SHIFT (0x00000011u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_MSI_CAP_MULT_MSG_CAP_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_MSI_CAP_MSI_EN_MASK (0x00010000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_MSI_CAP_MSI_EN_SHIFT (0x00000010u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_MSI_CAP_MSI_EN_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_MSI_CAP_NEXT_CAP_MASK (0x0000FF00u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_MSI_CAP_NEXT_CAP_SHIFT (0x00000008u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_MSI_CAP_NEXT_CAP_RESETVAL (0x00000070u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_MSI_CAP_CAP_ID_MASK (0x000000FFu)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_MSI_CAP_CAP_ID_SHIFT (0x00000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_MSI_CAP_CAP_ID_RESETVAL (0x00000005u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_MSI_CAP_RESETVAL (0x00807005u)

/* MSI_LOW32 */

#define CSL_PCIE_CFG_SPACE_ENDPOINT_MSI_LOW32_LOW32_ADDR_MASK (0xFFFFFFFFu)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_MSI_LOW32_LOW32_ADDR_SHIFT (0x00000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_MSI_LOW32_LOW32_ADDR_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_MSI_LOW32_RESETVAL (0x00000000u)

/* MSI_UP32 */

#define CSL_PCIE_CFG_SPACE_ENDPOINT_MSI_UP32_UP32_ADDR_MASK (0xFFFFFFFCu)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_MSI_UP32_UP32_ADDR_SHIFT (0x00000002u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_MSI_UP32_UP32_ADDR_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_MSI_UP32_RESETVAL (0x00000000u)

/* MSI_DATA */

#define CSL_PCIE_CFG_SPACE_ENDPOINT_MSI_DATA_MSI_DATA_MASK (0x0000FFFFu)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_MSI_DATA_MSI_DATA_SHIFT (0x00000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_MSI_DATA_MSI_DATA_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_MSI_DATA_RESETVAL (0x00000000u)

/* PCIES_CAP */

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIES_CAP_INT_MSG_MASK (0x3E000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIES_CAP_INT_MSG_SHIFT (0x00000019u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIES_CAP_INT_MSG_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIES_CAP_SLT_IMPL_N_MASK (0x01000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIES_CAP_SLT_IMPL_N_SHIFT (0x00000018u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIES_CAP_SLT_IMPL_N_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIES_CAP_DPORT_TYPE_MASK (0x00F00000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIES_CAP_DPORT_TYPE_SHIFT (0x00000014u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIES_CAP_DPORT_TYPE_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIES_CAP_PCIE_CAP_MASK (0x000F0000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIES_CAP_PCIE_CAP_SHIFT (0x00000010u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIES_CAP_PCIE_CAP_RESETVAL (0x00000002u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIES_CAP_NEXT_CAP_MASK (0x0000FF00u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIES_CAP_NEXT_CAP_SHIFT (0x00000008u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIES_CAP_NEXT_CAP_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIES_CAP_CAP_ID_MASK (0x000000FFu)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIES_CAP_CAP_ID_SHIFT (0x00000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIES_CAP_CAP_ID_RESETVAL (0x00000010u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIES_CAP_RESETVAL (0x00020010u)

/* DEVICE_CAP */

#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEVICE_CAP_PWR_LIMIT_SCALE_MASK (0x0C000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEVICE_CAP_PWR_LIMIT_SCALE_SHIFT (0x0000001Au)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEVICE_CAP_PWR_LIMIT_SCALE_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEVICE_CAP_PWR_LIMIT_VALUE_MASK (0x03FC0000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEVICE_CAP_PWR_LIMIT_VALUE_SHIFT (0x00000012u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEVICE_CAP_PWR_LIMIT_VALUE_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEVICE_CAP_ERR_RPT_MASK (0x00008000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEVICE_CAP_ERR_RPT_SHIFT (0x0000000Fu)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEVICE_CAP_ERR_RPT_RESETVAL (0x00000001u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEVICE_CAP_L1_LATENCY_MASK (0x00000E00u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEVICE_CAP_L1_LATENCY_SHIFT (0x00000009u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEVICE_CAP_L1_LATENCY_RESETVAL (0x00000003u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEVICE_CAP_L0_LATENCY_MASK (0x000001C0u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEVICE_CAP_L0_LATENCY_SHIFT (0x00000006u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEVICE_CAP_L0_LATENCY_RESETVAL (0x00000004u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEVICE_CAP_EXT_TAG_FLD_MASK (0x00000020u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEVICE_CAP_EXT_TAG_FLD_SHIFT (0x00000005u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEVICE_CAP_EXT_TAG_FLD_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEVICE_CAP_PHANTOM_FLD_MASK (0x00000018u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEVICE_CAP_PHANTOM_FLD_SHIFT (0x00000003u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEVICE_CAP_PHANTOM_FLD_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEVICE_CAP_MAX_PAYLD_SZ_MASK (0x00000007u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEVICE_CAP_MAX_PAYLD_SZ_SHIFT (0x00000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEVICE_CAP_MAX_PAYLD_SZ_RESETVAL (0x00000001u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEVICE_CAP_RESETVAL (0x00008701u)

/* DEV_STAT_CTRL */

#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEV_STAT_CTRL_TPEND_MASK (0x00200000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEV_STAT_CTRL_TPEND_SHIFT (0x00000015u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEV_STAT_CTRL_TPEND_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEV_STAT_CTRL_AUX_PWR_MASK (0x00100000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEV_STAT_CTRL_AUX_PWR_SHIFT (0x00000014u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEV_STAT_CTRL_AUX_PWR_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEV_STAT_CTRL_UNSUP_RQ_DET_MASK (0x00080000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEV_STAT_CTRL_UNSUP_RQ_DET_SHIFT (0x00000013u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEV_STAT_CTRL_UNSUP_RQ_DET_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEV_STAT_CTRL_FATAL_ERR_MASK (0x00040000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEV_STAT_CTRL_FATAL_ERR_SHIFT (0x00000012u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEV_STAT_CTRL_FATAL_ERR_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEV_STAT_CTRL_NFATAL_ERR_MASK (0x00020000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEV_STAT_CTRL_NFATAL_ERR_SHIFT (0x00000011u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEV_STAT_CTRL_NFATAL_ERR_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEV_STAT_CTRL_CORR_ERR_MASK (0x00010000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEV_STAT_CTRL_CORR_ERR_SHIFT (0x00000010u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEV_STAT_CTRL_CORR_ERR_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEV_STAT_CTRL_MAX_REQ_SZ_MASK (0x00007000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEV_STAT_CTRL_MAX_REQ_SZ_SHIFT (0x0000000Cu)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEV_STAT_CTRL_MAX_REQ_SZ_RESETVAL (0x00000002u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEV_STAT_CTRL_NO_SNOOP_MASK (0x00000800u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEV_STAT_CTRL_NO_SNOOP_SHIFT (0x0000000Bu)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEV_STAT_CTRL_NO_SNOOP_RESETVAL (0x00000001u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEV_STAT_CTRL_AUX_PWR_PM_EN_MASK (0x00000400u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEV_STAT_CTRL_AUX_PWR_PM_EN_SHIFT (0x0000000Au)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEV_STAT_CTRL_AUX_PWR_PM_EN_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEV_STAT_CTRL_PHANTOM_EN_MASK (0x00000200u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEV_STAT_CTRL_PHANTOM_EN_SHIFT (0x00000009u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEV_STAT_CTRL_PHANTOM_EN_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEV_STAT_CTRL_XTAG_FIELD_EN_MASK (0x00000100u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEV_STAT_CTRL_XTAG_FIELD_EN_SHIFT (0x00000008u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEV_STAT_CTRL_XTAG_FIELD_EN_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEV_STAT_CTRL_MAX_PAYLOAD_MASK (0x000000E0u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEV_STAT_CTRL_MAX_PAYLOAD_SHIFT (0x00000005u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEV_STAT_CTRL_MAX_PAYLOAD_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEV_STAT_CTRL_RELAXED_MASK (0x00000010u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEV_STAT_CTRL_RELAXED_SHIFT (0x00000004u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEV_STAT_CTRL_RELAXED_RESETVAL (0x00000001u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEV_STAT_CTRL_UNSUP_REQ_REP_MASK (0x00000008u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEV_STAT_CTRL_UNSUP_REQ_REP_SHIFT (0x00000003u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEV_STAT_CTRL_UNSUP_REQ_REP_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEV_STAT_CTRL_FATAL_ERR_REP_MASK (0x00000004u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEV_STAT_CTRL_FATAL_ERR_REP_SHIFT (0x00000002u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEV_STAT_CTRL_FATAL_ERR_REP_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEV_STAT_CTRL_NFATAL_ERR_REP_MASK (0x00000002u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEV_STAT_CTRL_NFATAL_ERR_REP_SHIFT (0x00000001u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEV_STAT_CTRL_NFATAL_ERR_REP_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEV_STAT_CTRL_CORR_ERR_REP_MASK (0x00000001u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEV_STAT_CTRL_CORR_ERR_REP_SHIFT (0x00000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEV_STAT_CTRL_CORR_ERR_REP_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEV_STAT_CTRL_RESETVAL (0x00002810u)

/* LINK_CAP */

#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_CAP_PORT_NUM_MASK (0xFF000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_CAP_PORT_NUM_SHIFT (0x00000018u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_CAP_PORT_NUM_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_CAP_BW_NOTIFY_CAP_MASK (0x00200000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_CAP_BW_NOTIFY_CAP_SHIFT (0x00000015u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_CAP_BW_NOTIFY_CAP_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_CAP_DLL_REP_CAP_MASK (0x00100000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_CAP_DLL_REP_CAP_SHIFT (0x00000014u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_CAP_DLL_REP_CAP_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_CAP_DOWN_ERR_REP_CAP_MASK (0x00080000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_CAP_DOWN_ERR_REP_CAP_SHIFT (0x00000013u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_CAP_DOWN_ERR_REP_CAP_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_CAP_CLK_PWR_MGMT_MASK (0x00040000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_CAP_CLK_PWR_MGMT_SHIFT (0x00000012u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_CAP_CLK_PWR_MGMT_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_CAP_L1_EXIT_LAT_MASK (0x00038000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_CAP_L1_EXIT_LAT_SHIFT (0x0000000Fu)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_CAP_L1_EXIT_LAT_RESETVAL (0x00000006u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_CAP_LOS_EXIT_LAT_MASK (0x00007000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_CAP_LOS_EXIT_LAT_SHIFT (0x0000000Cu)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_CAP_LOS_EXIT_LAT_RESETVAL (0x00000005u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_CAP_AS_LINK_PM_MASK (0x00000C00u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_CAP_AS_LINK_PM_SHIFT (0x0000000Au)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_CAP_AS_LINK_PM_RESETVAL (0x00000001u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_CAP_MAX_LINK_WIDTH_MASK (0x000003F0u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_CAP_MAX_LINK_WIDTH_SHIFT (0x00000004u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_CAP_MAX_LINK_WIDTH_RESETVAL (0x00000002u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_CAP_MAX_LINK_SPEED_MASK (0x0000000Fu)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_CAP_MAX_LINK_SPEED_SHIFT (0x00000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_CAP_MAX_LINK_SPEED_RESETVAL (0x00000002u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_CAP_RESETVAL (0x00035422u)

/* LINK_STAT_CTRL */

#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_STAT_CTRL_LINK_BW_STATUS_MASK (0x80000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_STAT_CTRL_LINK_BW_STATUS_SHIFT (0x0000001Fu)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_STAT_CTRL_LINK_BW_STATUS_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_STAT_CTRL_LINK_BW_MGMT_STATUS_MASK (0x40000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_STAT_CTRL_LINK_BW_MGMT_STATUS_SHIFT (0x0000001Eu)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_STAT_CTRL_LINK_BW_MGMT_STATUS_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_STAT_CTRL_DLL_ACTIVE_MASK (0x20000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_STAT_CTRL_DLL_ACTIVE_SHIFT (0x0000001Du)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_STAT_CTRL_DLL_ACTIVE_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_STAT_CTRL_SLOT_CLK_CFG_MASK (0x10000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_STAT_CTRL_SLOT_CLK_CFG_SHIFT (0x0000001Cu)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_STAT_CTRL_SLOT_CLK_CFG_RESETVAL (0x00000001u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_STAT_CTRL_LINK_TRAINING_MASK (0x08000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_STAT_CTRL_LINK_TRAINING_SHIFT (0x0000001Bu)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_STAT_CTRL_LINK_TRAINING_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_STAT_CTRL_UNDEF_MASK (0x04000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_STAT_CTRL_UNDEF_SHIFT (0x0000001Au)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_STAT_CTRL_UNDEF_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_STAT_CTRL_NEGOTIATED_LINK_WD_MASK (0x03F00000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_STAT_CTRL_NEGOTIATED_LINK_WD_SHIFT (0x00000014u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_STAT_CTRL_NEGOTIATED_LINK_WD_RESETVAL (0x00000001u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_STAT_CTRL_LINK_SPEED_MASK (0x000F0000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_STAT_CTRL_LINK_SPEED_SHIFT (0x00000010u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_STAT_CTRL_LINK_SPEED_RESETVAL (0x00000001u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_STAT_CTRL_LINK_BW_INT_EN_MASK (0x00000800u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_STAT_CTRL_LINK_BW_INT_EN_SHIFT (0x0000000Bu)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_STAT_CTRL_LINK_BW_INT_EN_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_STAT_CTRL_LINK_BW_MGMT_INT_EN_MASK (0x00000400u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_STAT_CTRL_LINK_BW_MGMT_INT_EN_SHIFT (0x0000000Au)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_STAT_CTRL_LINK_BW_MGMT_INT_EN_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_STAT_CTRL_HW_AUTO_WIDTH_DIS_MASK (0x00000200u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_STAT_CTRL_HW_AUTO_WIDTH_DIS_SHIFT (0x00000009u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_STAT_CTRL_HW_AUTO_WIDTH_DIS_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_STAT_CTRL_CLK_PWR_MGMT_EN_MASK (0x00000100u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_STAT_CTRL_CLK_PWR_MGMT_EN_SHIFT (0x00000008u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_STAT_CTRL_CLK_PWR_MGMT_EN_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_STAT_CTRL_EXT_SYNC_MASK (0x00000080u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_STAT_CTRL_EXT_SYNC_SHIFT (0x00000007u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_STAT_CTRL_EXT_SYNC_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_STAT_CTRL_COMMON_CLK_CFG_MASK (0x00000040u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_STAT_CTRL_COMMON_CLK_CFG_SHIFT (0x00000006u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_STAT_CTRL_COMMON_CLK_CFG_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_STAT_CTRL_RETRAIN_LINK_MASK (0x00000020u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_STAT_CTRL_RETRAIN_LINK_SHIFT (0x00000005u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_STAT_CTRL_RETRAIN_LINK_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_STAT_CTRL_LINK_DISABLE_MASK (0x00000010u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_STAT_CTRL_LINK_DISABLE_SHIFT (0x00000004u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_STAT_CTRL_LINK_DISABLE_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_STAT_CTRL_RCB_MASK (0x00000008u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_STAT_CTRL_RCB_SHIFT (0x00000003u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_STAT_CTRL_RCB_RESETVAL (0x00000001u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_STAT_CTRL_ACTIVE_LINK_PM_MASK (0x00000003u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_STAT_CTRL_ACTIVE_LINK_PM_SHIFT (0x00000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_STAT_CTRL_ACTIVE_LINK_PM_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_STAT_CTRL_RESETVAL (0x10110008u)

/* DEV_CAP2 */

#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEV_CAP2_CMPL_TO_DIS_SUPP_MASK (0x00000010u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEV_CAP2_CMPL_TO_DIS_SUPP_SHIFT (0x00000004u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEV_CAP2_CMPL_TO_DIS_SUPP_RESETVAL (0x00000001u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEV_CAP2_CMPL_TO_EN_MASK (0x0000000Fu)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEV_CAP2_CMPL_TO_EN_SHIFT (0x00000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEV_CAP2_CMPL_TO_EN_RESETVAL (0x0000000Fu)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEV_CAP2_RESETVAL (0x0000001Fu)

/* DEV_STAT_CTRL2 */

#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEV_STAT_CTRL2_CMPL_TO_DIS_MASK (0x00000010u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEV_STAT_CTRL2_CMPL_TO_DIS_SHIFT (0x00000004u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEV_STAT_CTRL2_CMPL_TO_DIS_RESETVAL (0x00000001u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEV_STAT_CTRL2_CMPL_TO_MASK (0x0000000Fu)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEV_STAT_CTRL2_CMPL_TO_SHIFT (0x00000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEV_STAT_CTRL2_CMPL_TO_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEV_STAT_CTRL2_RESETVAL (0x00000010u)

/* LINK_CTRL2 */

#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_CTRL2_DE_EMPH_MASK (0x00010000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_CTRL2_DE_EMPH_SHIFT (0x00000010u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_CTRL2_DE_EMPH_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_CTRL2_POLL_DEEMPH_MASK (0x00001000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_CTRL2_POLL_DEEMPH_SHIFT (0x0000000Cu)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_CTRL2_POLL_DEEMPH_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_CTRL2_CMPL_SOS_MASK (0x00000800u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_CTRL2_CMPL_SOS_SHIFT (0x0000000Bu)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_CTRL2_CMPL_SOS_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_CTRL2_ENTR_MOD_COMPL_MASK (0x00000400u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_CTRL2_ENTR_MOD_COMPL_SHIFT (0x0000000Au)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_CTRL2_ENTR_MOD_COMPL_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_CTRL2_TX_MARGIN_MASK (0x00000380u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_CTRL2_TX_MARGIN_SHIFT (0x00000007u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_CTRL2_TX_MARGIN_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_CTRL2_SEL_DEEMPH_MASK (0x00000040u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_CTRL2_SEL_DEEMPH_SHIFT (0x00000006u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_CTRL2_SEL_DEEMPH_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_CTRL2_HW_AUTO_SPEED_DIS_MASK (0x00000020u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_CTRL2_HW_AUTO_SPEED_DIS_SHIFT (0x00000005u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_CTRL2_HW_AUTO_SPEED_DIS_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_CTRL2_ENTR_COMPL_MASK (0x00000010u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_CTRL2_ENTR_COMPL_SHIFT (0x00000004u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_CTRL2_ENTR_COMPL_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_CTRL2_TGT_SPEED_MASK (0x0000000Fu)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_CTRL2_TGT_SPEED_SHIFT (0x00000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_CTRL2_TGT_SPEED_RESETVAL (0x00000002u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_LINK_CTRL2_RESETVAL (0x00000002u)

/* PCIE_EXTCAP */

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_EXTCAP_NEXT_CAP_MASK (0xFFF00000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_EXTCAP_NEXT_CAP_SHIFT (0x00000014u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_EXTCAP_NEXT_CAP_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_EXTCAP_EXT_CAP_VER_MASK (0x000F0000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_EXTCAP_EXT_CAP_VER_SHIFT (0x00000010u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_EXTCAP_EXT_CAP_VER_RESETVAL (0x00000001u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_EXTCAP_EXT_CAP_ID_MASK (0x0000FFFFu)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_EXTCAP_EXT_CAP_ID_SHIFT (0x00000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_EXTCAP_EXT_CAP_ID_RESETVAL (0x00000001u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_EXTCAP_RESETVAL (0x00010001u)

/* PCIE_UNCERR */

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_UR_ERR_ST_MASK (0x00100000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_UR_ERR_ST_SHIFT (0x00000014u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_UR_ERR_ST_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_ECRC_ERR_ST_MASK (0x00080000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_ECRC_ERR_ST_SHIFT (0x00000013u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_ECRC_ERR_ST_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_MTLP_ERR_ST_MASK (0x00040000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_MTLP_ERR_ST_SHIFT (0x00000012u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_MTLP_ERR_ST_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_RCVR_OF_ST_MASK (0x00020000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_RCVR_OF_ST_SHIFT (0x00000011u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_RCVR_OF_ST_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_UCMP_ST_MASK (0x00010000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_UCMP_ST_SHIFT (0x00000010u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_UCMP_ST_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_CMPL_ABRT_ST_MASK (0x00008000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_CMPL_ABRT_ST_SHIFT (0x0000000Fu)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_CMPL_ABRT_ST_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_CMPL_TMOT_ST_MASK (0x00004000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_CMPL_TMOT_ST_SHIFT (0x0000000Eu)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_CMPL_TMOT_ST_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_FCP_ERR_ST_MASK (0x00002000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_FCP_ERR_ST_SHIFT (0x0000000Du)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_FCP_ERR_ST_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_PSND_TLP_ST_MASK (0x00001000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_PSND_TLP_ST_SHIFT (0x0000000Cu)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_PSND_TLP_ST_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_SRPS_DN_ST_MASK (0x00000020u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_SRPS_DN_ST_SHIFT (0x00000005u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_SRPS_DN_ST_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_DLP_ERR_ST_MASK (0x00000010u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_DLP_ERR_ST_SHIFT (0x00000004u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_DLP_ERR_ST_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_RESETVAL (0x00000000u)

/* PCIE_UNCERR_MASK */

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_MASK_UR_ERR_MSK_MASK (0x00100000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_MASK_UR_ERR_MSK_SHIFT (0x00000014u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_MASK_UR_ERR_MSK_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_MASK_ECRC_ERR_MSK_MASK (0x00080000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_MASK_ECRC_ERR_MSK_SHIFT (0x00000013u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_MASK_ECRC_ERR_MSK_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_MASK_MTLP_ERR_MSK_MASK (0x00040000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_MASK_MTLP_ERR_MSK_SHIFT (0x00000012u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_MASK_MTLP_ERR_MSK_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_MASK_RCVR_OF_MSK_MASK (0x00020000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_MASK_RCVR_OF_MSK_SHIFT (0x00000011u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_MASK_RCVR_OF_MSK_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_MASK_UCMP_MSK_MASK (0x00010000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_MASK_UCMP_MSK_SHIFT (0x00000010u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_MASK_UCMP_MSK_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_MASK_CMPL_ABRT_MSK_MASK (0x00008000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_MASK_CMPL_ABRT_MSK_SHIFT (0x0000000Fu)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_MASK_CMPL_ABRT_MSK_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_MASK_CMPL_TMOT_MSK_MASK (0x00004000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_MASK_CMPL_TMOT_MSK_SHIFT (0x0000000Eu)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_MASK_CMPL_TMOT_MSK_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_MASK_FCP_ERR_MSK_MASK (0x00002000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_MASK_FCP_ERR_MSK_SHIFT (0x0000000Du)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_MASK_FCP_ERR_MSK_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_MASK_PSND_TLP_MSK_MASK (0x00001000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_MASK_PSND_TLP_MSK_SHIFT (0x0000000Cu)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_MASK_PSND_TLP_MSK_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_MASK_SRPS_DN_MSK_MASK (0x00000020u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_MASK_SRPS_DN_MSK_SHIFT (0x00000005u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_MASK_SRPS_DN_MSK_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_MASK_DLP_ERR_MSK_MASK (0x00000010u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_MASK_DLP_ERR_MSK_SHIFT (0x00000004u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_MASK_DLP_ERR_MSK_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_MASK_RESETVAL (0x00000000u)

/* PCIE_UNCERR_SVRTY */

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_SVRTY_UR_ERR_SVRTY_MASK (0x00100000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_SVRTY_UR_ERR_SVRTY_SHIFT (0x00000014u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_SVRTY_UR_ERR_SVRTY_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_SVRTY_ECRC_ERR_SVRTY_MASK (0x00080000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_SVRTY_ECRC_ERR_SVRTY_SHIFT (0x00000013u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_SVRTY_ECRC_ERR_SVRTY_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_SVRTY_MTLP_ERR_SVRTY_MASK (0x00040000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_SVRTY_MTLP_ERR_SVRTY_SHIFT (0x00000012u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_SVRTY_MTLP_ERR_SVRTY_RESETVAL (0x00000001u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_SVRTY_RCVR_OF_SVRTY_MASK (0x00020000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_SVRTY_RCVR_OF_SVRTY_SHIFT (0x00000011u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_SVRTY_RCVR_OF_SVRTY_RESETVAL (0x00000001u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_SVRTY_UCMP_SVRTY_MASK (0x00010000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_SVRTY_UCMP_SVRTY_SHIFT (0x00000010u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_SVRTY_UCMP_SVRTY_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_SVRTY_CMPL_ABRT_SVRTY_MASK (0x00008000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_SVRTY_CMPL_ABRT_SVRTY_SHIFT (0x0000000Fu)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_SVRTY_CMPL_ABRT_SVRTY_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_SVRTY_CMPL_TMOT_SVRTY_MASK (0x00004000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_SVRTY_CMPL_TMOT_SVRTY_SHIFT (0x0000000Eu)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_SVRTY_CMPL_TMOT_SVRTY_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_SVRTY_FCP_ERR_SVRTY_MASK (0x00002000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_SVRTY_FCP_ERR_SVRTY_SHIFT (0x0000000Du)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_SVRTY_FCP_ERR_SVRTY_RESETVAL (0x00000001u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_SVRTY_PSND_TLP_SVRTY_MASK (0x00001000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_SVRTY_PSND_TLP_SVRTY_SHIFT (0x0000000Cu)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_SVRTY_PSND_TLP_SVRTY_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_SVRTY_SRPS_DN_SVRTY_MASK (0x00000020u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_SVRTY_SRPS_DN_SVRTY_SHIFT (0x00000005u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_SVRTY_SRPS_DN_SVRTY_RESETVAL (0x00000001u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_SVRTY_DLP_ERR_SVRTY_MASK (0x00000010u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_SVRTY_DLP_ERR_SVRTY_SHIFT (0x00000004u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_SVRTY_DLP_ERR_SVRTY_RESETVAL (0x00000001u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_UNCERR_SVRTY_RESETVAL (0x00062030u)

/* PCIE_CERR */

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_CERR_ADV_NFERR_ST_MASK (0x00002000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_CERR_ADV_NFERR_ST_SHIFT (0x0000000Du)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_CERR_ADV_NFERR_ST_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_CERR_RPLY_TMR_ST_MASK (0x00001000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_CERR_RPLY_TMR_ST_SHIFT (0x0000000Cu)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_CERR_RPLY_TMR_ST_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_CERR_RPLT_RO_ST_MASK (0x00000100u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_CERR_RPLT_RO_ST_SHIFT (0x00000008u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_CERR_RPLT_RO_ST_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_CERR_BAD_DLLP_ST_MASK (0x00000080u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_CERR_BAD_DLLP_ST_SHIFT (0x00000007u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_CERR_BAD_DLLP_ST_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_CERR_BAD_TLP_ST_MASK (0x00000040u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_CERR_BAD_TLP_ST_SHIFT (0x00000006u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_CERR_BAD_TLP_ST_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_CERR_RCVR_ERR_ST_MASK (0x00000001u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_CERR_RCVR_ERR_ST_SHIFT (0x00000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_CERR_RCVR_ERR_ST_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_CERR_RESETVAL (0x00000000u)

/* PCIE_CERR_MASK */

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_CERR_MASK_ADV_NFERR_MSK_MASK (0x00002000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_CERR_MASK_ADV_NFERR_MSK_SHIFT (0x0000000Du)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_CERR_MASK_ADV_NFERR_MSK_RESETVAL (0x00000001u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_CERR_MASK_RPLY_TMR_MSK_MASK (0x00001000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_CERR_MASK_RPLY_TMR_MSK_SHIFT (0x0000000Cu)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_CERR_MASK_RPLY_TMR_MSK_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_CERR_MASK_RPLT_RO_MSK_MASK (0x00000100u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_CERR_MASK_RPLT_RO_MSK_SHIFT (0x00000008u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_CERR_MASK_RPLT_RO_MSK_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_CERR_MASK_BAD_DLLP_MSK_MASK (0x00000080u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_CERR_MASK_BAD_DLLP_MSK_SHIFT (0x00000007u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_CERR_MASK_BAD_DLLP_MSK_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_CERR_MASK_BAD_TLP_MSK_MASK (0x00000040u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_CERR_MASK_BAD_TLP_MSK_SHIFT (0x00000006u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_CERR_MASK_BAD_TLP_MSK_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_CERR_MASK_RCVR_ERR_MSK_MASK (0x00000001u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_CERR_MASK_RCVR_ERR_MSK_SHIFT (0x00000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_CERR_MASK_RCVR_ERR_MSK_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_CERR_MASK_RESETVAL (0x00002000u)

/* PCIE_ACCR */

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_ACCR_ECRC_CHK_EN_MASK (0x00000100u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_ACCR_ECRC_CHK_EN_SHIFT (0x00000008u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_ACCR_ECRC_CHK_EN_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_ACCR_ECRC_CHK_CAP_MASK (0x00000080u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_ACCR_ECRC_CHK_CAP_SHIFT (0x00000007u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_ACCR_ECRC_CHK_CAP_RESETVAL (0x00000001u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_ACCR_ECRC_GEN_EN_MASK (0x00000040u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_ACCR_ECRC_GEN_EN_SHIFT (0x00000006u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_ACCR_ECRC_GEN_EN_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_ACCR_ECRC_GEN_CAP_MASK (0x00000020u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_ACCR_ECRC_GEN_CAP_SHIFT (0x00000005u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_ACCR_ECRC_GEN_CAP_RESETVAL (0x00000001u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_ACCR_FRST_ERR_PTR_MASK (0x0000001Fu)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_ACCR_FRST_ERR_PTR_SHIFT (0x00000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_ACCR_FRST_ERR_PTR_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PCIE_ACCR_RESETVAL (0x000000A0u)

/* HDR_LOG */

#define CSL_PCIE_CFG_SPACE_ENDPOINT_HDR_LOG_HDR_DW_MASK (0xFFFFFFFFu)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_HDR_LOG_HDR_DW_SHIFT (0x00000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_HDR_LOG_HDR_DW_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_HDR_LOG_RESETVAL (0x00000000u)

/* RC_ERR_CMD */

#define CSL_PCIE_CFG_SPACE_ENDPOINT_RC_ERR_CMD_FERR_RPT_EN_MASK (0x00000004u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_RC_ERR_CMD_FERR_RPT_EN_SHIFT (0x00000002u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_RC_ERR_CMD_FERR_RPT_EN_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_RC_ERR_CMD_NFERR_RPT_EN_MASK (0x00000002u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_RC_ERR_CMD_NFERR_RPT_EN_SHIFT (0x00000001u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_RC_ERR_CMD_NFERR_RPT_EN_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_RC_ERR_CMD_CERR_RPT_EN_MASK (0x00000001u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_RC_ERR_CMD_CERR_RPT_EN_SHIFT (0x00000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_RC_ERR_CMD_CERR_RPT_EN_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_RC_ERR_CMD_RESETVAL (0x00000000u)

/* RC_ERR_ST */

#define CSL_PCIE_CFG_SPACE_ENDPOINT_RC_ERR_ST_AER_INT_MSG_MASK (0xF8000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_RC_ERR_ST_AER_INT_MSG_SHIFT (0x0000001Bu)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_RC_ERR_ST_AER_INT_MSG_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_RC_ERR_ST_FERR_RCV_MASK (0x00000040u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_RC_ERR_ST_FERR_RCV_SHIFT (0x00000006u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_RC_ERR_ST_FERR_RCV_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_RC_ERR_ST_NFERR_MASK (0x00000020u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_RC_ERR_ST_NFERR_SHIFT (0x00000005u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_RC_ERR_ST_NFERR_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_RC_ERR_ST_UNCOR_FATAL_MASK (0x00000010u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_RC_ERR_ST_UNCOR_FATAL_SHIFT (0x00000004u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_RC_ERR_ST_UNCOR_FATAL_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_RC_ERR_ST_MULT_FNF_MASK (0x00000008u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_RC_ERR_ST_MULT_FNF_SHIFT (0x00000003u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_RC_ERR_ST_MULT_FNF_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_RC_ERR_ST_ERR_FNF_MASK (0x00000004u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_RC_ERR_ST_ERR_FNF_SHIFT (0x00000002u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_RC_ERR_ST_ERR_FNF_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_RC_ERR_ST_MULT_COR_MASK (0x00000002u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_RC_ERR_ST_MULT_COR_SHIFT (0x00000001u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_RC_ERR_ST_MULT_COR_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_RC_ERR_ST_CORR_ERR_MASK (0x00000001u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_RC_ERR_ST_CORR_ERR_SHIFT (0x00000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_RC_ERR_ST_CORR_ERR_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_RC_ERR_ST_RESETVAL (0x00000000u)

/* ERR_SRC_ID */

#define CSL_PCIE_CFG_SPACE_ENDPOINT_ERR_SRC_ID_FNF_SRC_ID_MASK (0xFFFF0000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_ERR_SRC_ID_FNF_SRC_ID_SHIFT (0x00000010u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_ERR_SRC_ID_FNF_SRC_ID_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_ERR_SRC_ID_CORR_SRC_ID_MASK (0x0000FFFFu)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_ERR_SRC_ID_CORR_SRC_ID_SHIFT (0x00000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_ERR_SRC_ID_CORR_SRC_ID_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_ERR_SRC_ID_RESETVAL (0x00000000u)

/* PL_ACKTIMER */

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PL_ACKTIMER_RPLY_LIMT_MASK (0xFFFF0000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PL_ACKTIMER_RPLY_LIMT_SHIFT (0x00000010u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PL_ACKTIMER_RPLY_LIMT_RESETVAL (0x000000C0u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PL_ACKTIMER_RND_TRP_LMT_MASK (0x0000FFFFu)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PL_ACKTIMER_RND_TRP_LMT_SHIFT (0x00000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PL_ACKTIMER_RND_TRP_LMT_RESETVAL (0x00000040u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PL_ACKTIMER_RESETVAL (0x00C00040u)

/* PL_OMSG */

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PL_OMSG_OMSG_MASK (0xFFFFFFFFu)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PL_OMSG_OMSG_SHIFT (0x00000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PL_OMSG_OMSG_RESETVAL (u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PL_OMSG_RESETVAL (0x00000000u)

/* PL_FORCE_LINK */

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PL_FORCE_LINK_LPE_CNT_MASK (0xFF000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PL_FORCE_LINK_LPE_CNT_SHIFT (0x00000018u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PL_FORCE_LINK_LPE_CNT_RESETVAL (0x00000007u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PL_FORCE_LINK_LNK_STATE_MASK (0x003F0000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PL_FORCE_LINK_LNK_STATE_SHIFT (0x00000010u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PL_FORCE_LINK_LNK_STATE_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PL_FORCE_LINK_FORCE_LINK_MASK (0x00008000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PL_FORCE_LINK_FORCE_LINK_SHIFT (0x0000000Fu)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PL_FORCE_LINK_FORCE_LINK_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PL_FORCE_LINK_LINK_NUM_MASK (0x000000FFu)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PL_FORCE_LINK_LINK_NUM_SHIFT (0x00000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PL_FORCE_LINK_LINK_NUM_RESETVAL (0x00000004u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PL_FORCE_LINK_RESETVAL (0x07000004u)

/* ACK_FREQ */

#define CSL_PCIE_CFG_SPACE_ENDPOINT_ACK_FREQ_ASPM_L1_MASK (0x40000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_ACK_FREQ_ASPM_L1_SHIFT (0x0000001Eu)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_ACK_FREQ_ASPM_L1_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_ACK_FREQ_L1_ENTRY_LATENCY_MASK (0x38000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_ACK_FREQ_L1_ENTRY_LATENCY_SHIFT (0x0000001Bu)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_ACK_FREQ_L1_ENTRY_LATENCY_RESETVAL (0x00000003u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_ACK_FREQ_L0S_ENTRY_LATENCY_MASK (0x07000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_ACK_FREQ_L0S_ENTRY_LATENCY_SHIFT (0x00000018u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_ACK_FREQ_L0S_ENTRY_LATENCY_RESETVAL (0x00000003u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_ACK_FREQ_COMM_NFTS_MASK (0x00FF0000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_ACK_FREQ_COMM_NFTS_SHIFT (0x00000010u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_ACK_FREQ_COMM_NFTS_RESETVAL (0x0000000Fu)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_ACK_FREQ_NFTS_MASK (0x0000FF00u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_ACK_FREQ_NFTS_SHIFT (0x00000008u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_ACK_FREQ_NFTS_RESETVAL (0x00000064u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_ACK_FREQ_ACK_FREQ_MASK (0x000000FFu)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_ACK_FREQ_ACK_FREQ_SHIFT (0x00000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_ACK_FREQ_ACK_FREQ_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_ACK_FREQ_RESETVAL (0x1B0F6400u)

/* PL_LINK_CTRL */

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PL_LINK_CTRL_LNK_MODE_MASK (0x003F0000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PL_LINK_CTRL_LNK_MODE_SHIFT (0x00000010u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PL_LINK_CTRL_LNK_MODE_RESETVAL (0x00000003u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PL_LINK_CTRL_LNK_RATE_MASK (0x00000F00u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PL_LINK_CTRL_LNK_RATE_SHIFT (0x00000008u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PL_LINK_CTRL_LNK_RATE_RESETVAL (0x00000001u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PL_LINK_CTRL_FLNK_MODE_MASK (0x00000080u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PL_LINK_CTRL_FLNK_MODE_SHIFT (0x00000007u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PL_LINK_CTRL_FLNK_MODE_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PL_LINK_CTRL_DLL_EN_MASK (0x00000020u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PL_LINK_CTRL_DLL_EN_SHIFT (0x00000005u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PL_LINK_CTRL_DLL_EN_RESETVAL (0x00000001u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PL_LINK_CTRL_RST_ASRT_MASK (0x00000008u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PL_LINK_CTRL_RST_ASRT_SHIFT (0x00000003u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PL_LINK_CTRL_RST_ASRT_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PL_LINK_CTRL_LPBK_EN_MASK (0x00000004u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PL_LINK_CTRL_LPBK_EN_SHIFT (0x00000002u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PL_LINK_CTRL_LPBK_EN_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PL_LINK_CTRL_SCRM_DIS_MASK (0x00000002u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PL_LINK_CTRL_SCRM_DIS_SHIFT (0x00000001u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PL_LINK_CTRL_SCRM_DIS_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PL_LINK_CTRL_OMSG_REQ_MASK (0x00000001u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PL_LINK_CTRL_OMSG_REQ_SHIFT (0x00000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PL_LINK_CTRL_OMSG_REQ_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PL_LINK_CTRL_RESETVAL (0x00030120u)

/* LANE_SKEW */

#define CSL_PCIE_CFG_SPACE_ENDPOINT_LANE_SKEW_L2L_DESKEW_MASK (0x80000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_LANE_SKEW_L2L_DESKEW_SHIFT (0x0000001Fu)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_LANE_SKEW_L2L_DESKEW_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_LANE_SKEW_ACK_DISABLE_MASK (0x02000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_LANE_SKEW_ACK_DISABLE_SHIFT (0x00000019u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_LANE_SKEW_ACK_DISABLE_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_LANE_SKEW_FC_DISABLE_MASK (0x01000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_LANE_SKEW_FC_DISABLE_SHIFT (0x00000018u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_LANE_SKEW_FC_DISABLE_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_LANE_SKEW_LANE_SKEW_MASK (0x00FFFFFFu)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_LANE_SKEW_LANE_SKEW_SHIFT (0x00000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_LANE_SKEW_LANE_SKEW_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_LANE_SKEW_RESETVAL (0x00000000u)

/* SYM_NUM */

#define CSL_PCIE_CFG_SPACE_ENDPOINT_SYM_NUM_MAX_FUNC_MASK (0xE0000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_SYM_NUM_MAX_FUNC_SHIFT (0x0000001Du)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_SYM_NUM_MAX_FUNC_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_SYM_NUM_FCWATCH_TIMER_MASK (0x1F000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_SYM_NUM_FCWATCH_TIMER_SHIFT (0x00000018u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_SYM_NUM_FCWATCH_TIMER_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_SYM_NUM_ACK_LATENCY_TIMER_MASK (0x00F80000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_SYM_NUM_ACK_LATENCY_TIMER_SHIFT (0x00000013u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_SYM_NUM_ACK_LATENCY_TIMER_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_SYM_NUM_REPLAY_TIMER_MASK (0x0007C000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_SYM_NUM_REPLAY_TIMER_SHIFT (0x0000000Eu)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_SYM_NUM_REPLAY_TIMER_RESETVAL (0x00000004u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_SYM_NUM_SKP_COUNT_MASK (0x00000700u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_SYM_NUM_SKP_COUNT_SHIFT (0x00000008u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_SYM_NUM_SKP_COUNT_RESETVAL (0x00000003u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_SYM_NUM_NUM_TS2_SYMBOLS_MASK (0x000000F0u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_SYM_NUM_NUM_TS2_SYMBOLS_SHIFT (0x00000004u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_SYM_NUM_NUM_TS2_SYMBOLS_RESETVAL (0x0000000Au)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_SYM_NUM_TS_COUNT_MASK (0x0000000Fu)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_SYM_NUM_TS_COUNT_SHIFT (0x00000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_SYM_NUM_TS_COUNT_RESETVAL (0x0000000Au)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_SYM_NUM_RESETVAL (0x000103AAu)

/* SYMTIMER_FLTMASK */

#define CSL_PCIE_CFG_SPACE_ENDPOINT_SYMTIMER_FLTMASK_F1_CFG_DROP_MASK (0x80000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_SYMTIMER_FLTMASK_F1_CFG_DROP_SHIFT (0x0000001Fu)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_SYMTIMER_FLTMASK_F1_CFG_DROP_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_SYMTIMER_FLTMASK_F1_IO_DROP_MASK (0x40000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_SYMTIMER_FLTMASK_F1_IO_DROP_SHIFT (0x0000001Eu)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_SYMTIMER_FLTMASK_F1_IO_DROP_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_SYMTIMER_FLTMASK_F1_MSG_DROP_MASK (0x20000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_SYMTIMER_FLTMASK_F1_MSG_DROP_SHIFT (0x0000001Du)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_SYMTIMER_FLTMASK_F1_MSG_DROP_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_SYMTIMER_FLTMASK_F1_CPL_ECRC_DROP_MASK (0x10000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_SYMTIMER_FLTMASK_F1_CPL_ECRC_DROP_SHIFT (0x0000001Cu)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_SYMTIMER_FLTMASK_F1_CPL_ECRC_DROP_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_SYMTIMER_FLTMASK_F1_ECRC_DROP_MASK (0x08000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_SYMTIMER_FLTMASK_F1_ECRC_DROP_SHIFT (0x0000001Bu)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_SYMTIMER_FLTMASK_F1_ECRC_DROP_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_SYMTIMER_FLTMASK_F1_CPL_LEN_TEST_MASK (0x04000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_SYMTIMER_FLTMASK_F1_CPL_LEN_TEST_SHIFT (0x0000001Au)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_SYMTIMER_FLTMASK_F1_CPL_LEN_TEST_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_SYMTIMER_FLTMASK_F1_CPL_ATTR_TEST_MASK (0x02000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_SYMTIMER_FLTMASK_F1_CPL_ATTR_TEST_SHIFT (0x00000019u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_SYMTIMER_FLTMASK_F1_CPL_ATTR_TEST_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_SYMTIMER_FLTMASK_F1_CPL_TC_TEST_MASK (0x01000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_SYMTIMER_FLTMASK_F1_CPL_TC_TEST_SHIFT (0x00000018u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_SYMTIMER_FLTMASK_F1_CPL_TC_TEST_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_SYMTIMER_FLTMASK_F1_CPL_FUNC_TEST_MASK (0x00800000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_SYMTIMER_FLTMASK_F1_CPL_FUNC_TEST_SHIFT (0x00000017u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_SYMTIMER_FLTMASK_F1_CPL_FUNC_TEST_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_SYMTIMER_FLTMASK_F1_CPL_REQID_TEST_MASK (0x00400000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_SYMTIMER_FLTMASK_F1_CPL_REQID_TEST_SHIFT (0x00000016u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_SYMTIMER_FLTMASK_F1_CPL_REQID_TEST_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_SYMTIMER_FLTMASK_F1_CPL_TAGERR_TEST_MASK (0x00200000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_SYMTIMER_FLTMASK_F1_CPL_TAGERR_TEST_SHIFT (0x00000015u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_SYMTIMER_FLTMASK_F1_CPL_TAGERR_TEST_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_SYMTIMER_FLTMASK_F1_LOCKED_RD_AS_UR_MASK (0x00100000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_SYMTIMER_FLTMASK_F1_LOCKED_RD_AS_UR_SHIFT (0x00000014u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_SYMTIMER_FLTMASK_F1_LOCKED_RD_AS_UR_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_SYMTIMER_FLTMASK_F1_CFG1_RE_AS_US_MASK (0x00080000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_SYMTIMER_FLTMASK_F1_CFG1_RE_AS_US_SHIFT (0x00000013u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_SYMTIMER_FLTMASK_F1_CFG1_RE_AS_US_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_SYMTIMER_FLTMASK_F1_UR_OUT_OF_BAR_MASK (0x00040000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_SYMTIMER_FLTMASK_F1_UR_OUT_OF_BAR_SHIFT (0x00000012u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_SYMTIMER_FLTMASK_F1_UR_OUT_OF_BAR_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_SYMTIMER_FLTMASK_F1_UR_POISON_MASK (0x00020000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_SYMTIMER_FLTMASK_F1_UR_POISON_SHIFT (0x00000011u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_SYMTIMER_FLTMASK_F1_UR_POISON_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_SYMTIMER_FLTMASK_F1_UR_FUN_MISMATCH_MASK (0x00010000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_SYMTIMER_FLTMASK_F1_UR_FUN_MISMATCH_SHIFT (0x00000010u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_SYMTIMER_FLTMASK_F1_UR_FUN_MISMATCH_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_SYMTIMER_FLTMASK_FC_WDOG_DISABLE_MASK (0x00008000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_SYMTIMER_FLTMASK_FC_WDOG_DISABLE_SHIFT (0x0000000Fu)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_SYMTIMER_FLTMASK_FC_WDOG_DISABLE_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_SYMTIMER_FLTMASK_SKP_VALUE_MASK (0x000007FFu)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_SYMTIMER_FLTMASK_SKP_VALUE_SHIFT (0x00000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_SYMTIMER_FLTMASK_SKP_VALUE_RESETVAL (0x00000500u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_SYMTIMER_FLTMASK_RESETVAL (0x00000500u)

/* FLT_MASK2 */

#define CSL_PCIE_CFG_SPACE_ENDPOINT_FLT_MASK2_FLUSH_REQ_MASK (0x00000008u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_FLT_MASK2_FLUSH_REQ_SHIFT (0x00000003u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_FLT_MASK2_FLUSH_REQ_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_FLT_MASK2_DLLP_ABORT_MASK (0x00000004u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_FLT_MASK2_DLLP_ABORT_SHIFT (0x00000002u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_FLT_MASK2_DLLP_ABORT_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_FLT_MASK2_VMSG1_DROP_MASK (0x00000002u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_FLT_MASK2_VMSG1_DROP_SHIFT (0x00000001u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_FLT_MASK2_VMSG1_DROP_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_FLT_MASK2_VMSG0_DROP_MASK (0x00000001u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_FLT_MASK2_VMSG0_DROP_SHIFT (0x00000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_FLT_MASK2_VMSG0_DROP_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_FLT_MASK2_RESETVAL (0x00000000u)

/* DEBUG0 */

#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEBUG0_TS_LINK_CTRL_MASK (0xF0000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEBUG0_TS_LINK_CTRL_SHIFT (0x0000001Cu)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEBUG0_TS_LINK_CTRL_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEBUG0_TS_LANE_K237_MASK (0x08000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEBUG0_TS_LANE_K237_SHIFT (0x0000001Bu)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEBUG0_TS_LANE_K237_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEBUG0_TS_LINK_K237_MASK (0x04000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEBUG0_TS_LINK_K237_SHIFT (0x0000001Au)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEBUG0_TS_LINK_K237_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEBUG0_RCVD_IDLE0_MASK (0x02000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEBUG0_RCVD_IDLE0_SHIFT (0x00000019u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEBUG0_RCVD_IDLE0_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEBUG0_RCVD_IDLE1_MASK (0x01000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEBUG0_RCVD_IDLE1_SHIFT (0x00000018u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEBUG0_RCVD_IDLE1_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEBUG0_PIPE_TXDATA_MASK (0x00FFFF00u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEBUG0_PIPE_TXDATA_SHIFT (0x00000008u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEBUG0_PIPE_TXDATA_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEBUG0_PIPE_TXDATAK_MASK (0x000000C0u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEBUG0_PIPE_TXDATAK_SHIFT (0x00000006u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEBUG0_PIPE_TXDATAK_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEBUG0_TXB_SKIP_TX_MASK (0x00000020u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEBUG0_TXB_SKIP_TX_SHIFT (0x00000005u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEBUG0_TXB_SKIP_TX_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEBUG0_LTSSM_STATE_MASK (0x0000001Fu)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEBUG0_LTSSM_STATE_SHIFT (0x00000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEBUG0_LTSSM_STATE_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEBUG0_RESETVAL (0x00000000u)

/* DEBUG1 */

#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEBUG1_SCRAMBLER_DISABLE_MASK (0x80000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEBUG1_SCRAMBLER_DISABLE_SHIFT (0x0000001Fu)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEBUG1_SCRAMBLER_DISABLE_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEBUG1_LINK_DISABLE_MASK (0x40000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEBUG1_LINK_DISABLE_SHIFT (0x0000001Eu)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEBUG1_LINK_DISABLE_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEBUG1_LINK_IN_TRAINING_MASK (0x20000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEBUG1_LINK_IN_TRAINING_SHIFT (0x0000001Du)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEBUG1_LINK_IN_TRAINING_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEBUG1_RCVR_REVRS_POL_EN_MASK (0x10000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEBUG1_RCVR_REVRS_POL_EN_SHIFT (0x0000001Cu)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEBUG1_RCVR_REVRS_POL_EN_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEBUG1_TRAINING_RST_N_MASK (0x08000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEBUG1_TRAINING_RST_N_SHIFT (0x0000001Bu)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEBUG1_TRAINING_RST_N_RESETVAL (0x00000001u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEBUG1_PIPE_TXDETECTRX_LB_MASK (0x00400000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEBUG1_PIPE_TXDETECTRX_LB_SHIFT (0x00000016u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEBUG1_PIPE_TXDETECTRX_LB_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEBUG1_PIPE_TXELECIDLE_MASK (0x00200000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEBUG1_PIPE_TXELECIDLE_SHIFT (0x00000015u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEBUG1_PIPE_TXELECIDLE_RESETVAL (0x00000001u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEBUG1_PIPE_TXCOMPLIANCE_MASK (0x00100000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEBUG1_PIPE_TXCOMPLIANCE_SHIFT (0x00000014u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEBUG1_PIPE_TXCOMPLIANCE_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEBUG1_APP_INIT_RST_MASK (0x00080000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEBUG1_APP_INIT_RST_SHIFT (0x00000013u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEBUG1_APP_INIT_RST_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEBUG1_RMLH_TS_LINK_NUM_MASK (0x0000FF00u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEBUG1_RMLH_TS_LINK_NUM_SHIFT (0x00000008u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEBUG1_RMLH_TS_LINK_NUM_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEBUG1_XMLH_LINK_UP_MASK (0x00000010u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEBUG1_XMLH_LINK_UP_SHIFT (0x00000004u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEBUG1_XMLH_LINK_UP_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEBUG1_RMLH_INSKIP_RCV_MASK (0x00000008u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEBUG1_RMLH_INSKIP_RCV_SHIFT (0x00000003u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEBUG1_RMLH_INSKIP_RCV_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEBUG1_RMLH_TS1_RCVD_MASK (0x00000004u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEBUG1_RMLH_TS1_RCVD_SHIFT (0x00000002u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEBUG1_RMLH_TS1_RCVD_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEBUG1_RMLH_TS2_RCVD_MASK (0x00000002u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEBUG1_RMLH_TS2_RCVD_SHIFT (0x00000001u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEBUG1_RMLH_TS2_RCVD_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEBUG1_RMLH_RCVD_LANE_REV_MASK (0x00000001u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEBUG1_RMLH_RCVD_LANE_REV_SHIFT (0x00000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEBUG1_RMLH_RCVD_LANE_REV_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_DEBUG1_RESETVAL (0x08200000u)

/* PL_GEN2 */

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PL_GEN2_DEEMPH_MASK (0x00100000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PL_GEN2_DEEMPH_SHIFT (0x00000014u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PL_GEN2_DEEMPH_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PL_GEN2_CFG_TX_CMPL_MASK (0x00080000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PL_GEN2_CFG_TX_CMPL_SHIFT (0x00000013u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PL_GEN2_CFG_TX_CMPL_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PL_GEN2_CFG_TX_SWING_MASK (0x00040000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PL_GEN2_CFG_TX_SWING_SHIFT (0x00000012u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PL_GEN2_CFG_TX_SWING_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PL_GEN2_DIR_SPD_MASK (0x00020000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PL_GEN2_DIR_SPD_SHIFT (0x00000011u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PL_GEN2_DIR_SPD_RESETVAL (0x00000000u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PL_GEN2_LN_EN_MASK (0x0001FF00u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PL_GEN2_LN_EN_SHIFT (0x00000008u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PL_GEN2_LN_EN_RESETVAL (0x00000002u)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PL_GEN2_NUM_FTS_MASK (0x000000FFu)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PL_GEN2_NUM_FTS_SHIFT (0x00000000u)
#define CSL_PCIE_CFG_SPACE_ENDPOINT_PL_GEN2_NUM_FTS_RESETVAL (0x0000000Fu)

#define CSL_PCIE_CFG_SPACE_ENDPOINT_PL_GEN2_RESETVAL (0x0000020Fu)

#endif
