/********************************************************************
* Copyright (C) 2003-2008 Texas Instruments Incorporated.
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/
#ifndef _CSLR_CPINTC_H_
#define _CSLR_CPINTC_H_

/* CSL Modification:
 *  The file has been modified from the AUTOGEN file for the following
 *  reasons:-
 *      a) Modified Registers CH_MAP_REG0-CH_MAP_REG255 to an array of bytes of CHMAP[1024]
 *      b) Modified Registers HINT_MAP_REG0-HINT_MAP_REG63 to an array of HINTMAP[64]
 *      c) Modified Registers RAW_STATUS_REG0-RAW_STATUS_REG31 to an array of RAW_STATUS_REG[32]
 *      d) Modified Registers ENA_STATUS_REG0-ENA_STATUS_REG32 to an array of ENA_STATUS_REG[32]
 *      e) Modified Registers ENABLE_REG0-ENABLE_REG31 to an array of ENABLE_REG[32]
 *      f) Modified Registers ENABLE_CLR_REG0-ENABLE_CLR_REG31 to an array of ENABLE_CLR_REG[32]
 *      g) Modified Registers PRI_HINT_REG0-PRI_HINT_REG255 to an array of PRI_HINT_REG[256]
 *      h) Modified Registers POLARITY_REG0-POLARITY_REG31 to an array of POLARITY_REG[32]
 *      i) Modified Registers TYPE_REG0-TYPE_REG31 to an array of TYPE_REG[32]
 *      j) Modified Registers DBG_SELECT_REG0-DBG_SELECT_REG63 to an array of DBG_SELECT_REG[64]
 *      k) Modified Registers SECURE_ENABLE_REG0-SECURE_ENABLE_REG31 to an array of SECURE_ENABLE_REG[32]
 *      l) Modified Registers SECURE_ENABLE_CLR_REG0-SECURE_ENABLE_CLR_REG31 to an array of SECURE_ENABLE_CLR_REG[32]
 *      m) Modified Registers NEST_LEVEL_REG0-NEST_LEVEL_REG255 to an array of NEST_LEVEL_REG[256]
 *      n) Modified Registers ENABLE_HINT_REG0-ENABLE_HINT_REG7 to an array of ENABLE_HINT_REG[8]
 *      o) Modified Registers VECTOR_ADDRESS_REG_0-VECTOR_ADDRESS_REG_1023 to an array of VECTOR_ADDRESS_REG[1024]
 *      p) Modified the header file includes to be RTSC compliant
 */

#include <ti/csl/cslr.h>
#include <ti/csl/tistdtypes.h>

/* Minimum unit = 1 byte */

/**************************************************************************\
* Register Overlay Structure
\**************************************************************************/
typedef struct  {
    volatile Uint32 REVISION_REG;
    volatile Uint32 CONTROL_REG;
    volatile Uint8 RSVD0[4];
    volatile Uint32 HOST_CONTROL_REG;
    volatile Uint32 GLOBAL_ENABLE_HINT_REG;
    volatile Uint8 RSVD1[8];
    volatile Uint32 GLB_NEST_LEVEL_REG;
    volatile Uint32 STATUS_SET_INDEX_REG;
    volatile Uint32 STATUS_CLR_INDEX_REG;
    volatile Uint32 ENABLE_SET_INDEX_REG;
    volatile Uint32 ENABLE_CLR_INDEX_REG;
    volatile Uint8 RSVD2[4];
    volatile Uint32 HINT_ENABLE_SET_INDEX_REG;
    volatile Uint32 HINT_ENABLE_CLR_INDEX_REG;
    volatile Uint8 RSVD3[28];
    volatile Uint32 VECTOR_NULL_REG;
    volatile Uint8 RSVD4[36];
    volatile Uint32 GLB_PRI_INTR_REG;
    volatile Uint32 GLB_VECTOR_ADDR_REG;
    volatile Uint8 RSVD5[8];
    volatile Uint32 GLOBAL_SECURE_ENABLE_REG;
    volatile Uint32 SECURE_PRI_INTR_REG;
    volatile Uint8 RSVD6[360];
#ifdef CSL_MODIFICATION
    volatile Uint32 RAW_STATUS_REG0;
    volatile Uint32 RAW_STATUS_REG1;
    volatile Uint32 RAW_STATUS_REG2;
    volatile Uint32 RAW_STATUS_REG3;
    volatile Uint32 RAW_STATUS_REG4;
    volatile Uint32 RAW_STATUS_REG5;
    volatile Uint32 RAW_STATUS_REG6;
    volatile Uint32 RAW_STATUS_REG7;
    volatile Uint32 RAW_STATUS_REG8;
    volatile Uint32 RAW_STATUS_REG9;
    volatile Uint32 RAW_STATUS_REG10;
    volatile Uint32 RAW_STATUS_REG11;
    volatile Uint32 RAW_STATUS_REG12;
    volatile Uint32 RAW_STATUS_REG13;
    volatile Uint32 RAW_STATUS_REG14;
    volatile Uint32 RAW_STATUS_REG15;
    volatile Uint32 RAW_STATUS_REG16;
    volatile Uint32 RAW_STATUS_REG17;
    volatile Uint32 RAW_STATUS_REG18;
    volatile Uint32 RAW_STATUS_REG19;
    volatile Uint32 RAW_STATUS_REG20;
    volatile Uint32 RAW_STATUS_REG21;
    volatile Uint32 RAW_STATUS_REG22;
    volatile Uint32 RAW_STATUS_REG23;
    volatile Uint32 RAW_STATUS_REG24;
    volatile Uint32 RAW_STATUS_REG25;
    volatile Uint32 RAW_STATUS_REG26;
    volatile Uint32 RAW_STATUS_REG27;
    volatile Uint32 RAW_STATUS_REG28;
    volatile Uint32 RAW_STATUS_REG29;
    volatile Uint32 RAW_STATUS_REG30;
    volatile Uint32 RAW_STATUS_REG31;
#else
    volatile Uint32 RAW_STATUS_REG[32];
#endif
#ifdef CSL_MODIFICATION    
    volatile Uint32 ENA_STATUS_REG0;
    volatile Uint32 ENA_STATUS_REG1;
    volatile Uint32 ENA_STATUS_REG2;
    volatile Uint32 ENA_STATUS_REG3;
    volatile Uint32 ENA_STATUS_REG4;
    volatile Uint32 ENA_STATUS_REG5;
    volatile Uint32 ENA_STATUS_REG6;
    volatile Uint32 ENA_STATUS_REG7;
    volatile Uint32 ENA_STATUS_REG8;
    volatile Uint32 ENA_STATUS_REG9;
    volatile Uint32 ENA_STATUS_REG10;
    volatile Uint32 ENA_STATUS_REG11;
    volatile Uint32 ENA_STATUS_REG12;
    volatile Uint32 ENA_STATUS_REG13;
    volatile Uint32 ENA_STATUS_REG14;
    volatile Uint32 ENA_STATUS_REG15;
    volatile Uint32 ENA_STATUS_REG16;
    volatile Uint32 ENA_STATUS_REG17;
    volatile Uint32 ENA_STATUS_REG18;
    volatile Uint32 ENA_STATUS_REG19;
    volatile Uint32 ENA_STATUS_REG20;
    volatile Uint32 ENA_STATUS_REG21;
    volatile Uint32 ENA_STATUS_REG22;
    volatile Uint32 ENA_STATUS_REG23;
    volatile Uint32 ENA_STATUS_REG24;
    volatile Uint32 ENA_STATUS_REG25;
    volatile Uint32 ENA_STATUS_REG26;
    volatile Uint32 ENA_STATUS_REG27;
    volatile Uint32 ENA_STATUS_REG28;
    volatile Uint32 ENA_STATUS_REG29;
    volatile Uint32 ENA_STATUS_REG30;
    volatile Uint32 ENA_STATUS_REG31;
#else
    volatile Uint32 ENA_STATUS_REG[32];
#endif
#ifdef CSL_MODIFICATION    
    volatile Uint32 ENABLE_REG0;
    volatile Uint32 ENABLE_REG1;
    volatile Uint32 ENABLE_REG2;
    volatile Uint32 ENABLE_REG3;
    volatile Uint32 ENABLE_REG4;
    volatile Uint32 ENABLE_REG5;
    volatile Uint32 ENABLE_REG6;
    volatile Uint32 ENABLE_REG7;
    volatile Uint32 ENABLE_REG8;
    volatile Uint32 ENABLE_REG9;
    volatile Uint32 ENABLE_REG10;
    volatile Uint32 ENABLE_REG11;
    volatile Uint32 ENABLE_REG12;
    volatile Uint32 ENABLE_REG13;
    volatile Uint32 ENABLE_REG14;
    volatile Uint32 ENABLE_REG15;
    volatile Uint32 ENABLE_REG16;
    volatile Uint32 ENABLE_REG17;
    volatile Uint32 ENABLE_REG18;
    volatile Uint32 ENABLE_REG19;
    volatile Uint32 ENABLE_REG20;
    volatile Uint32 ENABLE_REG21;
    volatile Uint32 ENABLE_REG22;
    volatile Uint32 ENABLE_REG23;
    volatile Uint32 ENABLE_REG24;
    volatile Uint32 ENABLE_REG25;
    volatile Uint32 ENABLE_REG26;
    volatile Uint32 ENABLE_REG27;
    volatile Uint32 ENABLE_REG28;
    volatile Uint32 ENABLE_REG29;
    volatile Uint32 ENABLE_REG30;
    volatile Uint32 ENABLE_REG31;
#else
    volatile Uint32 ENABLE_REG[32];
#endif
#ifdef CSL_MODIFICATION 
    volatile Uint32 ENABLE_CLR_REG0;
    volatile Uint32 ENABLE_CLR_REG1;
    volatile Uint32 ENABLE_CLR_REG2;
    volatile Uint32 ENABLE_CLR_REG3;
    volatile Uint32 ENABLE_CLR_REG4;
    volatile Uint32 ENABLE_CLR_REG5;
    volatile Uint32 ENABLE_CLR_REG6;
    volatile Uint32 ENABLE_CLR_REG7;
    volatile Uint32 ENABLE_CLR_REG8;
    volatile Uint32 ENABLE_CLR_REG9;
    volatile Uint32 ENABLE_CLR_REG10;
    volatile Uint32 ENABLE_CLR_REG11;
    volatile Uint32 ENABLE_CLR_REG12;
    volatile Uint32 ENABLE_CLR_REG13;
    volatile Uint32 ENABLE_CLR_REG14;
    volatile Uint32 ENABLE_CLR_REG15;
    volatile Uint32 ENABLE_CLR_REG16;
    volatile Uint32 ENABLE_CLR_REG17;
    volatile Uint32 ENABLE_CLR_REG18;
    volatile Uint32 ENABLE_CLR_REG19;
    volatile Uint32 ENABLE_CLR_REG20;
    volatile Uint32 ENABLE_CLR_REG21;
    volatile Uint32 ENABLE_CLR_REG22;
    volatile Uint32 ENABLE_CLR_REG23;
    volatile Uint32 ENABLE_CLR_REG24;
    volatile Uint32 ENABLE_CLR_REG25;
    volatile Uint32 ENABLE_CLR_REG26;
    volatile Uint32 ENABLE_CLR_REG27;
    volatile Uint32 ENABLE_CLR_REG28;
    volatile Uint32 ENABLE_CLR_REG29;
    volatile Uint32 ENABLE_CLR_REG30;
    volatile Uint32 ENABLE_CLR_REG31;
#else
    volatile Uint32 ENABLE_CLR_REG[32];
#endif    
#ifdef CSL_MODIFICATION
    volatile Uint32 CH_MAP_REG0;
    volatile Uint32 CH_MAP_REG1;
    volatile Uint32 CH_MAP_REG2;
    volatile Uint32 CH_MAP_REG3;
    volatile Uint32 CH_MAP_REG4;
    volatile Uint32 CH_MAP_REG5;
    volatile Uint32 CH_MAP_REG6;
    volatile Uint32 CH_MAP_REG7;
    volatile Uint32 CH_MAP_REG8;
    volatile Uint32 CH_MAP_REG9;
    volatile Uint32 CH_MAP_REG10;
    volatile Uint32 CH_MAP_REG11;
    volatile Uint32 CH_MAP_REG12;
    volatile Uint32 CH_MAP_REG13;
    volatile Uint32 CH_MAP_REG14;
    volatile Uint32 CH_MAP_REG15;
    volatile Uint32 CH_MAP_REG16;
    volatile Uint32 CH_MAP_REG17;
    volatile Uint32 CH_MAP_REG18;
    volatile Uint32 CH_MAP_REG19;
    volatile Uint32 CH_MAP_REG20;
    volatile Uint32 CH_MAP_REG21;
    volatile Uint32 CH_MAP_REG22;
    volatile Uint32 CH_MAP_REG23;
    volatile Uint32 CH_MAP_REG24;
    volatile Uint32 CH_MAP_REG25;
    volatile Uint32 CH_MAP_REG26;
    volatile Uint32 CH_MAP_REG27;
    volatile Uint32 CH_MAP_REG28;
    volatile Uint32 CH_MAP_REG29;
    volatile Uint32 CH_MAP_REG30;
    volatile Uint32 CH_MAP_REG31;
    volatile Uint32 CH_MAP_REG32;
    volatile Uint32 CH_MAP_REG33;
    volatile Uint32 CH_MAP_REG34;
    volatile Uint32 CH_MAP_REG35;
    volatile Uint32 CH_MAP_REG36;
    volatile Uint32 CH_MAP_REG37;
    volatile Uint32 CH_MAP_REG38;
    volatile Uint32 CH_MAP_REG39;
    volatile Uint32 CH_MAP_REG40;
    volatile Uint32 CH_MAP_REG41;
    volatile Uint32 CH_MAP_REG42;
    volatile Uint32 CH_MAP_REG43;
    volatile Uint32 CH_MAP_REG44;
    volatile Uint32 CH_MAP_REG45;
    volatile Uint32 CH_MAP_REG46;
    volatile Uint32 CH_MAP_REG47;
    volatile Uint32 CH_MAP_REG48;
    volatile Uint32 CH_MAP_REG49;
    volatile Uint32 CH_MAP_REG50;
    volatile Uint32 CH_MAP_REG51;
    volatile Uint32 CH_MAP_REG52;
    volatile Uint32 CH_MAP_REG53;
    volatile Uint32 CH_MAP_REG54;
    volatile Uint32 CH_MAP_REG55;
    volatile Uint32 CH_MAP_REG56;
    volatile Uint32 CH_MAP_REG57;
    volatile Uint32 CH_MAP_REG58;
    volatile Uint32 CH_MAP_REG59;
    volatile Uint32 CH_MAP_REG60;
    volatile Uint32 CH_MAP_REG61;
    volatile Uint32 CH_MAP_REG62;
    volatile Uint32 CH_MAP_REG63;
    volatile Uint32 CH_MAP_REG64;
    volatile Uint32 CH_MAP_REG65;
    volatile Uint32 CH_MAP_REG66;
    volatile Uint32 CH_MAP_REG67;
    volatile Uint32 CH_MAP_REG68;
    volatile Uint32 CH_MAP_REG69;
    volatile Uint32 CH_MAP_REG70;
    volatile Uint32 CH_MAP_REG71;
    volatile Uint32 CH_MAP_REG72;
    volatile Uint32 CH_MAP_REG73;
    volatile Uint32 CH_MAP_REG74;
    volatile Uint32 CH_MAP_REG75;
    volatile Uint32 CH_MAP_REG76;
    volatile Uint32 CH_MAP_REG77;
    volatile Uint32 CH_MAP_REG78;
    volatile Uint32 CH_MAP_REG79;
    volatile Uint32 CH_MAP_REG80;
    volatile Uint32 CH_MAP_REG81;
    volatile Uint32 CH_MAP_REG82;
    volatile Uint32 CH_MAP_REG83;
    volatile Uint32 CH_MAP_REG84;
    volatile Uint32 CH_MAP_REG85;
    volatile Uint32 CH_MAP_REG86;
    volatile Uint32 CH_MAP_REG87;
    volatile Uint32 CH_MAP_REG88;
    volatile Uint32 CH_MAP_REG89;
    volatile Uint32 CH_MAP_REG90;
    volatile Uint32 CH_MAP_REG91;
    volatile Uint32 CH_MAP_REG92;
    volatile Uint32 CH_MAP_REG93;
    volatile Uint32 CH_MAP_REG94;
    volatile Uint32 CH_MAP_REG95;
    volatile Uint32 CH_MAP_REG96;
    volatile Uint32 CH_MAP_REG97;
    volatile Uint32 CH_MAP_REG98;
    volatile Uint32 CH_MAP_REG99;
    volatile Uint32 CH_MAP_REG100;
    volatile Uint32 CH_MAP_REG101;
    volatile Uint32 CH_MAP_REG102;
    volatile Uint32 CH_MAP_REG103;
    volatile Uint32 CH_MAP_REG104;
    volatile Uint32 CH_MAP_REG105;
    volatile Uint32 CH_MAP_REG106;
    volatile Uint32 CH_MAP_REG107;
    volatile Uint32 CH_MAP_REG108;
    volatile Uint32 CH_MAP_REG109;
    volatile Uint32 CH_MAP_REG110;
    volatile Uint32 CH_MAP_REG111;
    volatile Uint32 CH_MAP_REG112;
    volatile Uint32 CH_MAP_REG113;
    volatile Uint32 CH_MAP_REG114;
    volatile Uint32 CH_MAP_REG115;
    volatile Uint32 CH_MAP_REG116;
    volatile Uint32 CH_MAP_REG117;
    volatile Uint32 CH_MAP_REG118;
    volatile Uint32 CH_MAP_REG119;
    volatile Uint32 CH_MAP_REG120;
    volatile Uint32 CH_MAP_REG121;
    volatile Uint32 CH_MAP_REG122;
    volatile Uint32 CH_MAP_REG123;
    volatile Uint32 CH_MAP_REG124;
    volatile Uint32 CH_MAP_REG125;
    volatile Uint32 CH_MAP_REG126;
    volatile Uint32 CH_MAP_REG127;
    volatile Uint32 CH_MAP_REG128;
    volatile Uint32 CH_MAP_REG129;
    volatile Uint32 CH_MAP_REG130;
    volatile Uint32 CH_MAP_REG131;
    volatile Uint32 CH_MAP_REG132;
    volatile Uint32 CH_MAP_REG133;
    volatile Uint32 CH_MAP_REG134;
    volatile Uint32 CH_MAP_REG135;
    volatile Uint32 CH_MAP_REG136;
    volatile Uint32 CH_MAP_REG137;
    volatile Uint32 CH_MAP_REG138;
    volatile Uint32 CH_MAP_REG139;
    volatile Uint32 CH_MAP_REG140;
    volatile Uint32 CH_MAP_REG141;
    volatile Uint32 CH_MAP_REG142;
    volatile Uint32 CH_MAP_REG143;
    volatile Uint32 CH_MAP_REG144;
    volatile Uint32 CH_MAP_REG145;
    volatile Uint32 CH_MAP_REG146;
    volatile Uint32 CH_MAP_REG147;
    volatile Uint32 CH_MAP_REG148;
    volatile Uint32 CH_MAP_REG149;
    volatile Uint32 CH_MAP_REG150;
    volatile Uint32 CH_MAP_REG151;
    volatile Uint32 CH_MAP_REG152;
    volatile Uint32 CH_MAP_REG153;
    volatile Uint32 CH_MAP_REG154;
    volatile Uint32 CH_MAP_REG155;
    volatile Uint32 CH_MAP_REG156;
    volatile Uint32 CH_MAP_REG157;
    volatile Uint32 CH_MAP_REG158;
    volatile Uint32 CH_MAP_REG159;
    volatile Uint32 CH_MAP_REG160;
    volatile Uint32 CH_MAP_REG161;
    volatile Uint32 CH_MAP_REG162;
    volatile Uint32 CH_MAP_REG163;
    volatile Uint32 CH_MAP_REG164;
    volatile Uint32 CH_MAP_REG165;
    volatile Uint32 CH_MAP_REG166;
    volatile Uint32 CH_MAP_REG167;
    volatile Uint32 CH_MAP_REG168;
    volatile Uint32 CH_MAP_REG169;
    volatile Uint32 CH_MAP_REG170;
    volatile Uint32 CH_MAP_REG171;
    volatile Uint32 CH_MAP_REG172;
    volatile Uint32 CH_MAP_REG173;
    volatile Uint32 CH_MAP_REG174;
    volatile Uint32 CH_MAP_REG175;
    volatile Uint32 CH_MAP_REG176;
    volatile Uint32 CH_MAP_REG177;
    volatile Uint32 CH_MAP_REG178;
    volatile Uint32 CH_MAP_REG179;
    volatile Uint32 CH_MAP_REG180;
    volatile Uint32 CH_MAP_REG181;
    volatile Uint32 CH_MAP_REG182;
    volatile Uint32 CH_MAP_REG183;
    volatile Uint32 CH_MAP_REG184;
    volatile Uint32 CH_MAP_REG185;
    volatile Uint32 CH_MAP_REG186;
    volatile Uint32 CH_MAP_REG187;
    volatile Uint32 CH_MAP_REG188;
    volatile Uint32 CH_MAP_REG189;
    volatile Uint32 CH_MAP_REG190;
    volatile Uint32 CH_MAP_REG191;
    volatile Uint32 CH_MAP_REG192;
    volatile Uint32 CH_MAP_REG193;
    volatile Uint32 CH_MAP_REG194;
    volatile Uint32 CH_MAP_REG195;
    volatile Uint32 CH_MAP_REG196;
    volatile Uint32 CH_MAP_REG197;
    volatile Uint32 CH_MAP_REG198;
    volatile Uint32 CH_MAP_REG199;
    volatile Uint32 CH_MAP_REG200;
    volatile Uint32 CH_MAP_REG201;
    volatile Uint32 CH_MAP_REG202;
    volatile Uint32 CH_MAP_REG203;
    volatile Uint32 CH_MAP_REG204;
    volatile Uint32 CH_MAP_REG205;
    volatile Uint32 CH_MAP_REG206;
    volatile Uint32 CH_MAP_REG207;
    volatile Uint32 CH_MAP_REG208;
    volatile Uint32 CH_MAP_REG209;
    volatile Uint32 CH_MAP_REG210;
    volatile Uint32 CH_MAP_REG211;
    volatile Uint32 CH_MAP_REG212;
    volatile Uint32 CH_MAP_REG213;
    volatile Uint32 CH_MAP_REG214;
    volatile Uint32 CH_MAP_REG215;
    volatile Uint32 CH_MAP_REG216;
    volatile Uint32 CH_MAP_REG217;
    volatile Uint32 CH_MAP_REG218;
    volatile Uint32 CH_MAP_REG219;
    volatile Uint32 CH_MAP_REG220;
    volatile Uint32 CH_MAP_REG221;
    volatile Uint32 CH_MAP_REG222;
    volatile Uint32 CH_MAP_REG223;
    volatile Uint32 CH_MAP_REG224;
    volatile Uint32 CH_MAP_REG225;
    volatile Uint32 CH_MAP_REG226;
    volatile Uint32 CH_MAP_REG227;
    volatile Uint32 CH_MAP_REG228;
    volatile Uint32 CH_MAP_REG229;
    volatile Uint32 CH_MAP_REG230;
    volatile Uint32 CH_MAP_REG231;
    volatile Uint32 CH_MAP_REG232;
    volatile Uint32 CH_MAP_REG233;
    volatile Uint32 CH_MAP_REG234;
    volatile Uint32 CH_MAP_REG235;
    volatile Uint32 CH_MAP_REG236;
    volatile Uint32 CH_MAP_REG237;
    volatile Uint32 CH_MAP_REG238;
    volatile Uint32 CH_MAP_REG239;
    volatile Uint32 CH_MAP_REG240;
    volatile Uint32 CH_MAP_REG241;
    volatile Uint32 CH_MAP_REG242;
    volatile Uint32 CH_MAP_REG243;
    volatile Uint32 CH_MAP_REG244;
    volatile Uint32 CH_MAP_REG245;
    volatile Uint32 CH_MAP_REG246;
    volatile Uint32 CH_MAP_REG247;
    volatile Uint32 CH_MAP_REG248;
    volatile Uint32 CH_MAP_REG249;
    volatile Uint32 CH_MAP_REG250;
    volatile Uint32 CH_MAP_REG251;
    volatile Uint32 CH_MAP_REG252;
    volatile Uint32 CH_MAP_REG253;
    volatile Uint32 CH_MAP_REG254;
    volatile Uint32 CH_MAP_REG255;
#else
    volatile Uint8  CH_MAP[1024];
#endif
#ifdef CSL_MODIFICATION    
    volatile Uint32 HINT_MAP_REG0;
    volatile Uint32 HINT_MAP_REG1;
    volatile Uint32 HINT_MAP_REG2;
    volatile Uint32 HINT_MAP_REG3;
    volatile Uint32 HINT_MAP_REG4;
    volatile Uint32 HINT_MAP_REG5;
    volatile Uint32 HINT_MAP_REG6;
    volatile Uint32 HINT_MAP_REG7;
    volatile Uint32 HINT_MAP_REG8;
    volatile Uint32 HINT_MAP_REG9;
    volatile Uint32 HINT_MAP_REG10;
    volatile Uint32 HINT_MAP_REG11;
    volatile Uint32 HINT_MAP_REG12;
    volatile Uint32 HINT_MAP_REG13;
    volatile Uint32 HINT_MAP_REG14;
    volatile Uint32 HINT_MAP_REG15;
    volatile Uint32 HINT_MAP_REG16;
    volatile Uint32 HINT_MAP_REG17;
    volatile Uint32 HINT_MAP_REG18;
    volatile Uint32 HINT_MAP_REG19;
    volatile Uint32 HINT_MAP_REG20;
    volatile Uint32 HINT_MAP_REG21;
    volatile Uint32 HINT_MAP_REG22;
    volatile Uint32 HINT_MAP_REG23;
    volatile Uint32 HINT_MAP_REG24;
    volatile Uint32 HINT_MAP_REG25;
    volatile Uint32 HINT_MAP_REG26;
    volatile Uint32 HINT_MAP_REG27;
    volatile Uint32 HINT_MAP_REG28;
    volatile Uint32 HINT_MAP_REG29;
    volatile Uint32 HINT_MAP_REG30;
    volatile Uint32 HINT_MAP_REG31;
    volatile Uint32 HINT_MAP_REG32;
    volatile Uint32 HINT_MAP_REG33;
    volatile Uint32 HINT_MAP_REG34;
    volatile Uint32 HINT_MAP_REG35;
    volatile Uint32 HINT_MAP_REG36;
    volatile Uint32 HINT_MAP_REG37;
    volatile Uint32 HINT_MAP_REG38;
    volatile Uint32 HINT_MAP_REG39;
    volatile Uint32 HINT_MAP_REG40;
    volatile Uint32 HINT_MAP_REG41;
    volatile Uint32 HINT_MAP_REG42;
    volatile Uint32 HINT_MAP_REG43;
    volatile Uint32 HINT_MAP_REG44;
    volatile Uint32 HINT_MAP_REG45;
    volatile Uint32 HINT_MAP_REG46;
    volatile Uint32 HINT_MAP_REG47;
    volatile Uint32 HINT_MAP_REG48;
    volatile Uint32 HINT_MAP_REG49;
    volatile Uint32 HINT_MAP_REG50;
    volatile Uint32 HINT_MAP_REG51;
    volatile Uint32 HINT_MAP_REG52;
    volatile Uint32 HINT_MAP_REG53;
    volatile Uint32 HINT_MAP_REG54;
    volatile Uint32 HINT_MAP_REG55;
    volatile Uint32 HINT_MAP_REG56;
    volatile Uint32 HINT_MAP_REG57;
    volatile Uint32 HINT_MAP_REG58;
    volatile Uint32 HINT_MAP_REG59;
    volatile Uint32 HINT_MAP_REG60;
    volatile Uint32 HINT_MAP_REG61;
    volatile Uint32 HINT_MAP_REG62;
    volatile Uint32 HINT_MAP_REG63;
#else
    volatile Uint32 HINT_MAP[64];
#endif
#ifdef CSL_MODIFICATION    
    volatile Uint32 PRI_HINT_REG0;
    volatile Uint32 PRI_HINT_REG1;
    volatile Uint32 PRI_HINT_REG2;
    volatile Uint32 PRI_HINT_REG3;
    volatile Uint32 PRI_HINT_REG4;
    volatile Uint32 PRI_HINT_REG5;
    volatile Uint32 PRI_HINT_REG6;
    volatile Uint32 PRI_HINT_REG7;
    volatile Uint32 PRI_HINT_REG8;
    volatile Uint32 PRI_HINT_REG9;
    volatile Uint32 PRI_HINT_REG10;
    volatile Uint32 PRI_HINT_REG11;
    volatile Uint32 PRI_HINT_REG12;
    volatile Uint32 PRI_HINT_REG13;
    volatile Uint32 PRI_HINT_REG14;
    volatile Uint32 PRI_HINT_REG15;
    volatile Uint32 PRI_HINT_REG16;
    volatile Uint32 PRI_HINT_REG17;
    volatile Uint32 PRI_HINT_REG18;
    volatile Uint32 PRI_HINT_REG19;
    volatile Uint32 PRI_HINT_REG20;
    volatile Uint32 PRI_HINT_REG21;
    volatile Uint32 PRI_HINT_REG22;
    volatile Uint32 PRI_HINT_REG23;
    volatile Uint32 PRI_HINT_REG24;
    volatile Uint32 PRI_HINT_REG25;
    volatile Uint32 PRI_HINT_REG26;
    volatile Uint32 PRI_HINT_REG27;
    volatile Uint32 PRI_HINT_REG28;
    volatile Uint32 PRI_HINT_REG29;
    volatile Uint32 PRI_HINT_REG30;
    volatile Uint32 PRI_HINT_REG31;
    volatile Uint32 PRI_HINT_REG32;
    volatile Uint32 PRI_HINT_REG33;
    volatile Uint32 PRI_HINT_REG34;
    volatile Uint32 PRI_HINT_REG35;
    volatile Uint32 PRI_HINT_REG36;
    volatile Uint32 PRI_HINT_REG37;
    volatile Uint32 PRI_HINT_REG38;
    volatile Uint32 PRI_HINT_REG39;
    volatile Uint32 PRI_HINT_REG40;
    volatile Uint32 PRI_HINT_REG41;
    volatile Uint32 PRI_HINT_REG42;
    volatile Uint32 PRI_HINT_REG43;
    volatile Uint32 PRI_HINT_REG44;
    volatile Uint32 PRI_HINT_REG45;
    volatile Uint32 PRI_HINT_REG46;
    volatile Uint32 PRI_HINT_REG47;
    volatile Uint32 PRI_HINT_REG48;
    volatile Uint32 PRI_HINT_REG49;
    volatile Uint32 PRI_HINT_REG50;
    volatile Uint32 PRI_HINT_REG51;
    volatile Uint32 PRI_HINT_REG52;
    volatile Uint32 PRI_HINT_REG53;
    volatile Uint32 PRI_HINT_REG54;
    volatile Uint32 PRI_HINT_REG55;
    volatile Uint32 PRI_HINT_REG56;
    volatile Uint32 PRI_HINT_REG57;
    volatile Uint32 PRI_HINT_REG58;
    volatile Uint32 PRI_HINT_REG59;
    volatile Uint32 PRI_HINT_REG60;
    volatile Uint32 PRI_HINT_REG61;
    volatile Uint32 PRI_HINT_REG62;
    volatile Uint32 PRI_HINT_REG63;
    volatile Uint32 PRI_HINT_REG64;
    volatile Uint32 PRI_HINT_REG65;
    volatile Uint32 PRI_HINT_REG66;
    volatile Uint32 PRI_HINT_REG67;
    volatile Uint32 PRI_HINT_REG68;
    volatile Uint32 PRI_HINT_REG69;
    volatile Uint32 PRI_HINT_REG70;
    volatile Uint32 PRI_HINT_REG71;
    volatile Uint32 PRI_HINT_REG72;
    volatile Uint32 PRI_HINT_REG73;
    volatile Uint32 PRI_HINT_REG74;
    volatile Uint32 PRI_HINT_REG75;
    volatile Uint32 PRI_HINT_REG76;
    volatile Uint32 PRI_HINT_REG77;
    volatile Uint32 PRI_HINT_REG78;
    volatile Uint32 PRI_HINT_REG79;
    volatile Uint32 PRI_HINT_REG80;
    volatile Uint32 PRI_HINT_REG81;
    volatile Uint32 PRI_HINT_REG82;
    volatile Uint32 PRI_HINT_REG83;
    volatile Uint32 PRI_HINT_REG84;
    volatile Uint32 PRI_HINT_REG85;
    volatile Uint32 PRI_HINT_REG86;
    volatile Uint32 PRI_HINT_REG87;
    volatile Uint32 PRI_HINT_REG88;
    volatile Uint32 PRI_HINT_REG89;
    volatile Uint32 PRI_HINT_REG90;
    volatile Uint32 PRI_HINT_REG91;
    volatile Uint32 PRI_HINT_REG92;
    volatile Uint32 PRI_HINT_REG93;
    volatile Uint32 PRI_HINT_REG94;
    volatile Uint32 PRI_HINT_REG95;
    volatile Uint32 PRI_HINT_REG96;
    volatile Uint32 PRI_HINT_REG97;
    volatile Uint32 PRI_HINT_REG98;
    volatile Uint32 PRI_HINT_REG99;
    volatile Uint32 PRI_HINT_REG100;
    volatile Uint32 PRI_HINT_REG101;
    volatile Uint32 PRI_HINT_REG102;
    volatile Uint32 PRI_HINT_REG103;
    volatile Uint32 PRI_HINT_REG104;
    volatile Uint32 PRI_HINT_REG105;
    volatile Uint32 PRI_HINT_REG106;
    volatile Uint32 PRI_HINT_REG107;
    volatile Uint32 PRI_HINT_REG108;
    volatile Uint32 PRI_HINT_REG109;
    volatile Uint32 PRI_HINT_REG110;
    volatile Uint32 PRI_HINT_REG111;
    volatile Uint32 PRI_HINT_REG112;
    volatile Uint32 PRI_HINT_REG113;
    volatile Uint32 PRI_HINT_REG114;
    volatile Uint32 PRI_HINT_REG115;
    volatile Uint32 PRI_HINT_REG116;
    volatile Uint32 PRI_HINT_REG117;
    volatile Uint32 PRI_HINT_REG118;
    volatile Uint32 PRI_HINT_REG119;
    volatile Uint32 PRI_HINT_REG120;
    volatile Uint32 PRI_HINT_REG121;
    volatile Uint32 PRI_HINT_REG122;
    volatile Uint32 PRI_HINT_REG123;
    volatile Uint32 PRI_HINT_REG124;
    volatile Uint32 PRI_HINT_REG125;
    volatile Uint32 PRI_HINT_REG126;
    volatile Uint32 PRI_HINT_REG127;
    volatile Uint32 PRI_HINT_REG128;
    volatile Uint32 PRI_HINT_REG129;
    volatile Uint32 PRI_HINT_REG130;
    volatile Uint32 PRI_HINT_REG131;
    volatile Uint32 PRI_HINT_REG132;
    volatile Uint32 PRI_HINT_REG133;
    volatile Uint32 PRI_HINT_REG134;
    volatile Uint32 PRI_HINT_REG135;
    volatile Uint32 PRI_HINT_REG136;
    volatile Uint32 PRI_HINT_REG137;
    volatile Uint32 PRI_HINT_REG138;
    volatile Uint32 PRI_HINT_REG139;
    volatile Uint32 PRI_HINT_REG140;
    volatile Uint32 PRI_HINT_REG141;
    volatile Uint32 PRI_HINT_REG142;
    volatile Uint32 PRI_HINT_REG143;
    volatile Uint32 PRI_HINT_REG144;
    volatile Uint32 PRI_HINT_REG145;
    volatile Uint32 PRI_HINT_REG146;
    volatile Uint32 PRI_HINT_REG147;
    volatile Uint32 PRI_HINT_REG148;
    volatile Uint32 PRI_HINT_REG149;
    volatile Uint32 PRI_HINT_REG150;
    volatile Uint32 PRI_HINT_REG151;
    volatile Uint32 PRI_HINT_REG152;
    volatile Uint32 PRI_HINT_REG153;
    volatile Uint32 PRI_HINT_REG154;
    volatile Uint32 PRI_HINT_REG155;
    volatile Uint32 PRI_HINT_REG156;
    volatile Uint32 PRI_HINT_REG157;
    volatile Uint32 PRI_HINT_REG158;
    volatile Uint32 PRI_HINT_REG159;
    volatile Uint32 PRI_HINT_REG160;
    volatile Uint32 PRI_HINT_REG161;
    volatile Uint32 PRI_HINT_REG162;
    volatile Uint32 PRI_HINT_REG163;
    volatile Uint32 PRI_HINT_REG164;
    volatile Uint32 PRI_HINT_REG165;
    volatile Uint32 PRI_HINT_REG166;
    volatile Uint32 PRI_HINT_REG167;
    volatile Uint32 PRI_HINT_REG168;
    volatile Uint32 PRI_HINT_REG169;
    volatile Uint32 PRI_HINT_REG170;
    volatile Uint32 PRI_HINT_REG171;
    volatile Uint32 PRI_HINT_REG172;
    volatile Uint32 PRI_HINT_REG173;
    volatile Uint32 PRI_HINT_REG174;
    volatile Uint32 PRI_HINT_REG175;
    volatile Uint32 PRI_HINT_REG176;
    volatile Uint32 PRI_HINT_REG177;
    volatile Uint32 PRI_HINT_REG178;
    volatile Uint32 PRI_HINT_REG179;
    volatile Uint32 PRI_HINT_REG180;
    volatile Uint32 PRI_HINT_REG181;
    volatile Uint32 PRI_HINT_REG182;
    volatile Uint32 PRI_HINT_REG183;
    volatile Uint32 PRI_HINT_REG184;
    volatile Uint32 PRI_HINT_REG185;
    volatile Uint32 PRI_HINT_REG186;
    volatile Uint32 PRI_HINT_REG187;
    volatile Uint32 PRI_HINT_REG188;
    volatile Uint32 PRI_HINT_REG189;
    volatile Uint32 PRI_HINT_REG190;
    volatile Uint32 PRI_HINT_REG191;
    volatile Uint32 PRI_HINT_REG192;
    volatile Uint32 PRI_HINT_REG193;
    volatile Uint32 PRI_HINT_REG194;
    volatile Uint32 PRI_HINT_REG195;
    volatile Uint32 PRI_HINT_REG196;
    volatile Uint32 PRI_HINT_REG197;
    volatile Uint32 PRI_HINT_REG198;
    volatile Uint32 PRI_HINT_REG199;
    volatile Uint32 PRI_HINT_REG200;
    volatile Uint32 PRI_HINT_REG201;
    volatile Uint32 PRI_HINT_REG202;
    volatile Uint32 PRI_HINT_REG203;
    volatile Uint32 PRI_HINT_REG204;
    volatile Uint32 PRI_HINT_REG205;
    volatile Uint32 PRI_HINT_REG206;
    volatile Uint32 PRI_HINT_REG207;
    volatile Uint32 PRI_HINT_REG208;
    volatile Uint32 PRI_HINT_REG209;
    volatile Uint32 PRI_HINT_REG210;
    volatile Uint32 PRI_HINT_REG211;
    volatile Uint32 PRI_HINT_REG212;
    volatile Uint32 PRI_HINT_REG213;
    volatile Uint32 PRI_HINT_REG214;
    volatile Uint32 PRI_HINT_REG215;
    volatile Uint32 PRI_HINT_REG216;
    volatile Uint32 PRI_HINT_REG217;
    volatile Uint32 PRI_HINT_REG218;
    volatile Uint32 PRI_HINT_REG219;
    volatile Uint32 PRI_HINT_REG220;
    volatile Uint32 PRI_HINT_REG221;
    volatile Uint32 PRI_HINT_REG222;
    volatile Uint32 PRI_HINT_REG223;
    volatile Uint32 PRI_HINT_REG224;
    volatile Uint32 PRI_HINT_REG225;
    volatile Uint32 PRI_HINT_REG226;
    volatile Uint32 PRI_HINT_REG227;
    volatile Uint32 PRI_HINT_REG228;
    volatile Uint32 PRI_HINT_REG229;
    volatile Uint32 PRI_HINT_REG230;
    volatile Uint32 PRI_HINT_REG231;
    volatile Uint32 PRI_HINT_REG232;
    volatile Uint32 PRI_HINT_REG233;
    volatile Uint32 PRI_HINT_REG234;
    volatile Uint32 PRI_HINT_REG235;
    volatile Uint32 PRI_HINT_REG236;
    volatile Uint32 PRI_HINT_REG237;
    volatile Uint32 PRI_HINT_REG238;
    volatile Uint32 PRI_HINT_REG239;
    volatile Uint32 PRI_HINT_REG240;
    volatile Uint32 PRI_HINT_REG241;
    volatile Uint32 PRI_HINT_REG242;
    volatile Uint32 PRI_HINT_REG243;
    volatile Uint32 PRI_HINT_REG244;
    volatile Uint32 PRI_HINT_REG245;
    volatile Uint32 PRI_HINT_REG246;
    volatile Uint32 PRI_HINT_REG247;
    volatile Uint32 PRI_HINT_REG248;
    volatile Uint32 PRI_HINT_REG249;
    volatile Uint32 PRI_HINT_REG250;
    volatile Uint32 PRI_HINT_REG251;
    volatile Uint32 PRI_HINT_REG252;
    volatile Uint32 PRI_HINT_REG253;
    volatile Uint32 PRI_HINT_REG254;
    volatile Uint32 PRI_HINT_REG255;
#else
    volatile Uint32 PRI_HINT_REG[256];
#endif
#ifdef CSL_MODIFICATION
    volatile Uint32 POLARITY_REG0;
    volatile Uint32 POLARITY_REG1;
    volatile Uint32 POLARITY_REG2;
    volatile Uint32 POLARITY_REG3;
    volatile Uint32 POLARITY_REG4;
    volatile Uint32 POLARITY_REG5;
    volatile Uint32 POLARITY_REG6;
    volatile Uint32 POLARITY_REG7;
    volatile Uint32 POLARITY_REG8;
    volatile Uint32 POLARITY_REG9;
    volatile Uint32 POLARITY_REG10;
    volatile Uint32 POLARITY_REG11;
    volatile Uint32 POLARITY_REG12;
    volatile Uint32 POLARITY_REG13;
    volatile Uint32 POLARITY_REG14;
    volatile Uint32 POLARITY_REG15;
    volatile Uint32 POLARITY_REG16;
    volatile Uint32 POLARITY_REG17;
    volatile Uint32 POLARITY_REG18;
    volatile Uint32 POLARITY_REG19;
    volatile Uint32 POLARITY_REG20;
    volatile Uint32 POLARITY_REG21;
    volatile Uint32 POLARITY_REG22;
    volatile Uint32 POLARITY_REG23;
    volatile Uint32 POLARITY_REG24;
    volatile Uint32 POLARITY_REG25;
    volatile Uint32 POLARITY_REG26;
    volatile Uint32 POLARITY_REG27;
    volatile Uint32 POLARITY_REG28;
    volatile Uint32 POLARITY_REG29;
    volatile Uint32 POLARITY_REG30;
    volatile Uint32 POLARITY_REG31;
#else
    volatile Uint32 POLARITY_REG[32];
#endif
#ifdef CSL_MODIFICATION    
    volatile Uint32 TYPE_REG0;
    volatile Uint32 TYPE_REG1;
    volatile Uint32 TYPE_REG2;
    volatile Uint32 TYPE_REG3;
    volatile Uint32 TYPE_REG4;
    volatile Uint32 TYPE_REG5;
    volatile Uint32 TYPE_REG6;
    volatile Uint32 TYPE_REG7;
    volatile Uint32 TYPE_REG8;
    volatile Uint32 TYPE_REG9;
    volatile Uint32 TYPE_REG10;
    volatile Uint32 TYPE_REG11;
    volatile Uint32 TYPE_REG12;
    volatile Uint32 TYPE_REG13;
    volatile Uint32 TYPE_REG14;
    volatile Uint32 TYPE_REG15;
    volatile Uint32 TYPE_REG16;
    volatile Uint32 TYPE_REG17;
    volatile Uint32 TYPE_REG18;
    volatile Uint32 TYPE_REG19;
    volatile Uint32 TYPE_REG20;
    volatile Uint32 TYPE_REG21;
    volatile Uint32 TYPE_REG22;
    volatile Uint32 TYPE_REG23;
    volatile Uint32 TYPE_REG24;
    volatile Uint32 TYPE_REG25;
    volatile Uint32 TYPE_REG26;
    volatile Uint32 TYPE_REG27;
    volatile Uint32 TYPE_REG28;
    volatile Uint32 TYPE_REG29;
    volatile Uint32 TYPE_REG30;
    volatile Uint32 TYPE_REG31;
#else
    volatile Uint32 TYPE_REG[32];
#endif    
    volatile Uint8 RSVD7[256];
#ifdef CSL_MODIFICATION    
    volatile Uint32 DBG_SELECT_REG0;
    volatile Uint32 DBG_SELECT_REG1;
    volatile Uint32 DBG_SELECT_REG2;
    volatile Uint32 DBG_SELECT_REG3;
    volatile Uint32 DBG_SELECT_REG4;
    volatile Uint32 DBG_SELECT_REG5;
    volatile Uint32 DBG_SELECT_REG6;
    volatile Uint32 DBG_SELECT_REG7;
    volatile Uint32 DBG_SELECT_REG8;
    volatile Uint32 DBG_SELECT_REG9;
    volatile Uint32 DBG_SELECT_REG10;
    volatile Uint32 DBG_SELECT_REG11;
    volatile Uint32 DBG_SELECT_REG12;
    volatile Uint32 DBG_SELECT_REG13;
    volatile Uint32 DBG_SELECT_REG14;
    volatile Uint32 DBG_SELECT_REG15;
    volatile Uint32 DBG_SELECT_REG16;
    volatile Uint32 DBG_SELECT_REG17;
    volatile Uint32 DBG_SELECT_REG18;
    volatile Uint32 DBG_SELECT_REG19;
    volatile Uint32 DBG_SELECT_REG20;
    volatile Uint32 DBG_SELECT_REG21;
    volatile Uint32 DBG_SELECT_REG22;
    volatile Uint32 DBG_SELECT_REG23;
    volatile Uint32 DBG_SELECT_REG24;
    volatile Uint32 DBG_SELECT_REG25;
    volatile Uint32 DBG_SELECT_REG26;
    volatile Uint32 DBG_SELECT_REG27;
    volatile Uint32 DBG_SELECT_REG28;
    volatile Uint32 DBG_SELECT_REG29;
    volatile Uint32 DBG_SELECT_REG30;
    volatile Uint32 DBG_SELECT_REG31;
    volatile Uint32 DBG_SELECT_REG32;
    volatile Uint32 DBG_SELECT_REG33;
    volatile Uint32 DBG_SELECT_REG34;
    volatile Uint32 DBG_SELECT_REG35;
    volatile Uint32 DBG_SELECT_REG36;
    volatile Uint32 DBG_SELECT_REG37;
    volatile Uint32 DBG_SELECT_REG38;
    volatile Uint32 DBG_SELECT_REG39;
    volatile Uint32 DBG_SELECT_REG40;
    volatile Uint32 DBG_SELECT_REG41;
    volatile Uint32 DBG_SELECT_REG42;
    volatile Uint32 DBG_SELECT_REG43;
    volatile Uint32 DBG_SELECT_REG44;
    volatile Uint32 DBG_SELECT_REG45;
    volatile Uint32 DBG_SELECT_REG46;
    volatile Uint32 DBG_SELECT_REG47;
    volatile Uint32 DBG_SELECT_REG48;
    volatile Uint32 DBG_SELECT_REG49;
    volatile Uint32 DBG_SELECT_REG50;
    volatile Uint32 DBG_SELECT_REG51;
    volatile Uint32 DBG_SELECT_REG52;
    volatile Uint32 DBG_SELECT_REG53;
    volatile Uint32 DBG_SELECT_REG54;
    volatile Uint32 DBG_SELECT_REG55;
    volatile Uint32 DBG_SELECT_REG56;
    volatile Uint32 DBG_SELECT_REG57;
    volatile Uint32 DBG_SELECT_REG58;
    volatile Uint32 DBG_SELECT_REG59;
    volatile Uint32 DBG_SELECT_REG60;
    volatile Uint32 DBG_SELECT_REG61;
    volatile Uint32 DBG_SELECT_REG62;
    volatile Uint32 DBG_SELECT_REG63;
#else
    volatile Uint32 DBG_SELECT_REG[64];
#endif
#ifdef CSL_MODIFICATION    
    volatile Uint32 SECURE_ENABLE_REG0;
    volatile Uint32 SECURE_ENABLE_REG1;
    volatile Uint32 SECURE_ENABLE_REG2;
    volatile Uint32 SECURE_ENABLE_REG3;
    volatile Uint32 SECURE_ENABLE_REG4;
    volatile Uint32 SECURE_ENABLE_REG5;
    volatile Uint32 SECURE_ENABLE_REG6;
    volatile Uint32 SECURE_ENABLE_REG7;
    volatile Uint32 SECURE_ENABLE_REG8;
    volatile Uint32 SECURE_ENABLE_REG9;
    volatile Uint32 SECURE_ENABLE_REG10;
    volatile Uint32 SECURE_ENABLE_REG11;
    volatile Uint32 SECURE_ENABLE_REG12;
    volatile Uint32 SECURE_ENABLE_REG13;
    volatile Uint32 SECURE_ENABLE_REG14;
    volatile Uint32 SECURE_ENABLE_REG15;
    volatile Uint32 SECURE_ENABLE_REG16;
    volatile Uint32 SECURE_ENABLE_REG17;
    volatile Uint32 SECURE_ENABLE_REG18;
    volatile Uint32 SECURE_ENABLE_REG19;
    volatile Uint32 SECURE_ENABLE_REG20;
    volatile Uint32 SECURE_ENABLE_REG21;
    volatile Uint32 SECURE_ENABLE_REG22;
    volatile Uint32 SECURE_ENABLE_REG23;
    volatile Uint32 SECURE_ENABLE_REG24;
    volatile Uint32 SECURE_ENABLE_REG25;
    volatile Uint32 SECURE_ENABLE_REG26;
    volatile Uint32 SECURE_ENABLE_REG27;
    volatile Uint32 SECURE_ENABLE_REG28;
    volatile Uint32 SECURE_ENABLE_REG29;
    volatile Uint32 SECURE_ENABLE_REG30;
    volatile Uint32 SECURE_ENABLE_REG31;
#else
    volatile Uint32 SECURE_ENABLE_REG[32];
#endif
#ifdef CSL_MODIFICATION    
    volatile Uint32 SECURE_ENABLE_CLR_REG0;
    volatile Uint32 SECURE_ENABLE_CLR_REG1;
    volatile Uint32 SECURE_ENABLE_CLR_REG2;
    volatile Uint32 SECURE_ENABLE_CLR_REG3;
    volatile Uint32 SECURE_ENABLE_CLR_REG4;
    volatile Uint32 SECURE_ENABLE_CLR_REG5;
    volatile Uint32 SECURE_ENABLE_CLR_REG6;
    volatile Uint32 SECURE_ENABLE_CLR_REG7;
    volatile Uint32 SECURE_ENABLE_CLR_REG8;
    volatile Uint32 SECURE_ENABLE_CLR_REG9;
    volatile Uint32 SECURE_ENABLE_CLR_REG10;
    volatile Uint32 SECURE_ENABLE_CLR_REG11;
    volatile Uint32 SECURE_ENABLE_CLR_REG12;
    volatile Uint32 SECURE_ENABLE_CLR_REG13;
    volatile Uint32 SECURE_ENABLE_CLR_REG14;
    volatile Uint32 SECURE_ENABLE_CLR_REG15;
    volatile Uint32 SECURE_ENABLE_CLR_REG16;
    volatile Uint32 SECURE_ENABLE_CLR_REG17;
    volatile Uint32 SECURE_ENABLE_CLR_REG18;
    volatile Uint32 SECURE_ENABLE_CLR_REG19;
    volatile Uint32 SECURE_ENABLE_CLR_REG20;
    volatile Uint32 SECURE_ENABLE_CLR_REG21;
    volatile Uint32 SECURE_ENABLE_CLR_REG22;
    volatile Uint32 SECURE_ENABLE_CLR_REG23;
    volatile Uint32 SECURE_ENABLE_CLR_REG24;
    volatile Uint32 SECURE_ENABLE_CLR_REG25;
    volatile Uint32 SECURE_ENABLE_CLR_REG26;
    volatile Uint32 SECURE_ENABLE_CLR_REG27;
    volatile Uint32 SECURE_ENABLE_CLR_REG28;
    volatile Uint32 SECURE_ENABLE_CLR_REG29;
    volatile Uint32 SECURE_ENABLE_CLR_REG30;
    volatile Uint32 SECURE_ENABLE_CLR_REG31;
#else
    volatile Uint32 SECURE_ENABLE_CLR_REG[32];
#endif
#ifdef CSL_MODIFICATION    
    volatile Uint32 NEST_LEVEL_REG0;
    volatile Uint32 NEST_LEVEL_REG1;
    volatile Uint32 NEST_LEVEL_REG2;
    volatile Uint32 NEST_LEVEL_REG3;
    volatile Uint32 NEST_LEVEL_REG4;
    volatile Uint32 NEST_LEVEL_REG5;
    volatile Uint32 NEST_LEVEL_REG6;
    volatile Uint32 NEST_LEVEL_REG7;
    volatile Uint32 NEST_LEVEL_REG8;
    volatile Uint32 NEST_LEVEL_REG9;
    volatile Uint32 NEST_LEVEL_REG10;
    volatile Uint32 NEST_LEVEL_REG11;
    volatile Uint32 NEST_LEVEL_REG12;
    volatile Uint32 NEST_LEVEL_REG13;
    volatile Uint32 NEST_LEVEL_REG14;
    volatile Uint32 NEST_LEVEL_REG15;
    volatile Uint32 NEST_LEVEL_REG16;
    volatile Uint32 NEST_LEVEL_REG17;
    volatile Uint32 NEST_LEVEL_REG18;
    volatile Uint32 NEST_LEVEL_REG19;
    volatile Uint32 NEST_LEVEL_REG20;
    volatile Uint32 NEST_LEVEL_REG21;
    volatile Uint32 NEST_LEVEL_REG22;
    volatile Uint32 NEST_LEVEL_REG23;
    volatile Uint32 NEST_LEVEL_REG24;
    volatile Uint32 NEST_LEVEL_REG25;
    volatile Uint32 NEST_LEVEL_REG26;
    volatile Uint32 NEST_LEVEL_REG27;
    volatile Uint32 NEST_LEVEL_REG28;
    volatile Uint32 NEST_LEVEL_REG29;
    volatile Uint32 NEST_LEVEL_REG30;
    volatile Uint32 NEST_LEVEL_REG31;
    volatile Uint32 NEST_LEVEL_REG32;
    volatile Uint32 NEST_LEVEL_REG33;
    volatile Uint32 NEST_LEVEL_REG34;
    volatile Uint32 NEST_LEVEL_REG35;
    volatile Uint32 NEST_LEVEL_REG36;
    volatile Uint32 NEST_LEVEL_REG37;
    volatile Uint32 NEST_LEVEL_REG38;
    volatile Uint32 NEST_LEVEL_REG39;
    volatile Uint32 NEST_LEVEL_REG40;
    volatile Uint32 NEST_LEVEL_REG41;
    volatile Uint32 NEST_LEVEL_REG42;
    volatile Uint32 NEST_LEVEL_REG43;
    volatile Uint32 NEST_LEVEL_REG44;
    volatile Uint32 NEST_LEVEL_REG45;
    volatile Uint32 NEST_LEVEL_REG46;
    volatile Uint32 NEST_LEVEL_REG47;
    volatile Uint32 NEST_LEVEL_REG48;
    volatile Uint32 NEST_LEVEL_REG49;
    volatile Uint32 NEST_LEVEL_REG50;
    volatile Uint32 NEST_LEVEL_REG51;
    volatile Uint32 NEST_LEVEL_REG52;
    volatile Uint32 NEST_LEVEL_REG53;
    volatile Uint32 NEST_LEVEL_REG54;
    volatile Uint32 NEST_LEVEL_REG55;
    volatile Uint32 NEST_LEVEL_REG56;
    volatile Uint32 NEST_LEVEL_REG57;
    volatile Uint32 NEST_LEVEL_REG58;
    volatile Uint32 NEST_LEVEL_REG59;
    volatile Uint32 NEST_LEVEL_REG60;
    volatile Uint32 NEST_LEVEL_REG61;
    volatile Uint32 NEST_LEVEL_REG62;
    volatile Uint32 NEST_LEVEL_REG63;
    volatile Uint32 NEST_LEVEL_REG64;
    volatile Uint32 NEST_LEVEL_REG65;
    volatile Uint32 NEST_LEVEL_REG66;
    volatile Uint32 NEST_LEVEL_REG67;
    volatile Uint32 NEST_LEVEL_REG68;
    volatile Uint32 NEST_LEVEL_REG69;
    volatile Uint32 NEST_LEVEL_REG70;
    volatile Uint32 NEST_LEVEL_REG71;
    volatile Uint32 NEST_LEVEL_REG72;
    volatile Uint32 NEST_LEVEL_REG73;
    volatile Uint32 NEST_LEVEL_REG74;
    volatile Uint32 NEST_LEVEL_REG75;
    volatile Uint32 NEST_LEVEL_REG76;
    volatile Uint32 NEST_LEVEL_REG77;
    volatile Uint32 NEST_LEVEL_REG78;
    volatile Uint32 NEST_LEVEL_REG79;
    volatile Uint32 NEST_LEVEL_REG80;
    volatile Uint32 NEST_LEVEL_REG81;
    volatile Uint32 NEST_LEVEL_REG82;
    volatile Uint32 NEST_LEVEL_REG83;
    volatile Uint32 NEST_LEVEL_REG84;
    volatile Uint32 NEST_LEVEL_REG85;
    volatile Uint32 NEST_LEVEL_REG86;
    volatile Uint32 NEST_LEVEL_REG87;
    volatile Uint32 NEST_LEVEL_REG88;
    volatile Uint32 NEST_LEVEL_REG89;
    volatile Uint32 NEST_LEVEL_REG90;
    volatile Uint32 NEST_LEVEL_REG91;
    volatile Uint32 NEST_LEVEL_REG92;
    volatile Uint32 NEST_LEVEL_REG93;
    volatile Uint32 NEST_LEVEL_REG94;
    volatile Uint32 NEST_LEVEL_REG95;
    volatile Uint32 NEST_LEVEL_REG96;
    volatile Uint32 NEST_LEVEL_REG97;
    volatile Uint32 NEST_LEVEL_REG98;
    volatile Uint32 NEST_LEVEL_REG99;
    volatile Uint32 NEST_LEVEL_REG100;
    volatile Uint32 NEST_LEVEL_REG101;
    volatile Uint32 NEST_LEVEL_REG102;
    volatile Uint32 NEST_LEVEL_REG103;
    volatile Uint32 NEST_LEVEL_REG104;
    volatile Uint32 NEST_LEVEL_REG105;
    volatile Uint32 NEST_LEVEL_REG106;
    volatile Uint32 NEST_LEVEL_REG107;
    volatile Uint32 NEST_LEVEL_REG108;
    volatile Uint32 NEST_LEVEL_REG109;
    volatile Uint32 NEST_LEVEL_REG110;
    volatile Uint32 NEST_LEVEL_REG111;
    volatile Uint32 NEST_LEVEL_REG112;
    volatile Uint32 NEST_LEVEL_REG113;
    volatile Uint32 NEST_LEVEL_REG114;
    volatile Uint32 NEST_LEVEL_REG115;
    volatile Uint32 NEST_LEVEL_REG116;
    volatile Uint32 NEST_LEVEL_REG117;
    volatile Uint32 NEST_LEVEL_REG118;
    volatile Uint32 NEST_LEVEL_REG119;
    volatile Uint32 NEST_LEVEL_REG120;
    volatile Uint32 NEST_LEVEL_REG121;
    volatile Uint32 NEST_LEVEL_REG122;
    volatile Uint32 NEST_LEVEL_REG123;
    volatile Uint32 NEST_LEVEL_REG124;
    volatile Uint32 NEST_LEVEL_REG125;
    volatile Uint32 NEST_LEVEL_REG126;
    volatile Uint32 NEST_LEVEL_REG127;
    volatile Uint32 NEST_LEVEL_REG128;
    volatile Uint32 NEST_LEVEL_REG129;
    volatile Uint32 NEST_LEVEL_REG130;
    volatile Uint32 NEST_LEVEL_REG131;
    volatile Uint32 NEST_LEVEL_REG132;
    volatile Uint32 NEST_LEVEL_REG133;
    volatile Uint32 NEST_LEVEL_REG134;
    volatile Uint32 NEST_LEVEL_REG135;
    volatile Uint32 NEST_LEVEL_REG136;
    volatile Uint32 NEST_LEVEL_REG137;
    volatile Uint32 NEST_LEVEL_REG138;
    volatile Uint32 NEST_LEVEL_REG139;
    volatile Uint32 NEST_LEVEL_REG140;
    volatile Uint32 NEST_LEVEL_REG141;
    volatile Uint32 NEST_LEVEL_REG142;
    volatile Uint32 NEST_LEVEL_REG143;
    volatile Uint32 NEST_LEVEL_REG144;
    volatile Uint32 NEST_LEVEL_REG145;
    volatile Uint32 NEST_LEVEL_REG146;
    volatile Uint32 NEST_LEVEL_REG147;
    volatile Uint32 NEST_LEVEL_REG148;
    volatile Uint32 NEST_LEVEL_REG149;
    volatile Uint32 NEST_LEVEL_REG150;
    volatile Uint32 NEST_LEVEL_REG151;
    volatile Uint32 NEST_LEVEL_REG152;
    volatile Uint32 NEST_LEVEL_REG153;
    volatile Uint32 NEST_LEVEL_REG154;
    volatile Uint32 NEST_LEVEL_REG155;
    volatile Uint32 NEST_LEVEL_REG156;
    volatile Uint32 NEST_LEVEL_REG157;
    volatile Uint32 NEST_LEVEL_REG158;
    volatile Uint32 NEST_LEVEL_REG159;
    volatile Uint32 NEST_LEVEL_REG160;
    volatile Uint32 NEST_LEVEL_REG161;
    volatile Uint32 NEST_LEVEL_REG162;
    volatile Uint32 NEST_LEVEL_REG163;
    volatile Uint32 NEST_LEVEL_REG164;
    volatile Uint32 NEST_LEVEL_REG165;
    volatile Uint32 NEST_LEVEL_REG166;
    volatile Uint32 NEST_LEVEL_REG167;
    volatile Uint32 NEST_LEVEL_REG168;
    volatile Uint32 NEST_LEVEL_REG169;
    volatile Uint32 NEST_LEVEL_REG170;
    volatile Uint32 NEST_LEVEL_REG171;
    volatile Uint32 NEST_LEVEL_REG172;
    volatile Uint32 NEST_LEVEL_REG173;
    volatile Uint32 NEST_LEVEL_REG174;
    volatile Uint32 NEST_LEVEL_REG175;
    volatile Uint32 NEST_LEVEL_REG176;
    volatile Uint32 NEST_LEVEL_REG177;
    volatile Uint32 NEST_LEVEL_REG178;
    volatile Uint32 NEST_LEVEL_REG179;
    volatile Uint32 NEST_LEVEL_REG180;
    volatile Uint32 NEST_LEVEL_REG181;
    volatile Uint32 NEST_LEVEL_REG182;
    volatile Uint32 NEST_LEVEL_REG183;
    volatile Uint32 NEST_LEVEL_REG184;
    volatile Uint32 NEST_LEVEL_REG185;
    volatile Uint32 NEST_LEVEL_REG186;
    volatile Uint32 NEST_LEVEL_REG187;
    volatile Uint32 NEST_LEVEL_REG188;
    volatile Uint32 NEST_LEVEL_REG189;
    volatile Uint32 NEST_LEVEL_REG190;
    volatile Uint32 NEST_LEVEL_REG191;
    volatile Uint32 NEST_LEVEL_REG192;
    volatile Uint32 NEST_LEVEL_REG193;
    volatile Uint32 NEST_LEVEL_REG194;
    volatile Uint32 NEST_LEVEL_REG195;
    volatile Uint32 NEST_LEVEL_REG196;
    volatile Uint32 NEST_LEVEL_REG197;
    volatile Uint32 NEST_LEVEL_REG198;
    volatile Uint32 NEST_LEVEL_REG199;
    volatile Uint32 NEST_LEVEL_REG200;
    volatile Uint32 NEST_LEVEL_REG201;
    volatile Uint32 NEST_LEVEL_REG202;
    volatile Uint32 NEST_LEVEL_REG203;
    volatile Uint32 NEST_LEVEL_REG204;
    volatile Uint32 NEST_LEVEL_REG205;
    volatile Uint32 NEST_LEVEL_REG206;
    volatile Uint32 NEST_LEVEL_REG207;
    volatile Uint32 NEST_LEVEL_REG208;
    volatile Uint32 NEST_LEVEL_REG209;
    volatile Uint32 NEST_LEVEL_REG210;
    volatile Uint32 NEST_LEVEL_REG211;
    volatile Uint32 NEST_LEVEL_REG212;
    volatile Uint32 NEST_LEVEL_REG213;
    volatile Uint32 NEST_LEVEL_REG214;
    volatile Uint32 NEST_LEVEL_REG215;
    volatile Uint32 NEST_LEVEL_REG216;
    volatile Uint32 NEST_LEVEL_REG217;
    volatile Uint32 NEST_LEVEL_REG218;
    volatile Uint32 NEST_LEVEL_REG219;
    volatile Uint32 NEST_LEVEL_REG220;
    volatile Uint32 NEST_LEVEL_REG221;
    volatile Uint32 NEST_LEVEL_REG222;
    volatile Uint32 NEST_LEVEL_REG223;
    volatile Uint32 NEST_LEVEL_REG224;
    volatile Uint32 NEST_LEVEL_REG225;
    volatile Uint32 NEST_LEVEL_REG226;
    volatile Uint32 NEST_LEVEL_REG227;
    volatile Uint32 NEST_LEVEL_REG228;
    volatile Uint32 NEST_LEVEL_REG229;
    volatile Uint32 NEST_LEVEL_REG230;
    volatile Uint32 NEST_LEVEL_REG231;
    volatile Uint32 NEST_LEVEL_REG232;
    volatile Uint32 NEST_LEVEL_REG233;
    volatile Uint32 NEST_LEVEL_REG234;
    volatile Uint32 NEST_LEVEL_REG235;
    volatile Uint32 NEST_LEVEL_REG236;
    volatile Uint32 NEST_LEVEL_REG237;
    volatile Uint32 NEST_LEVEL_REG238;
    volatile Uint32 NEST_LEVEL_REG239;
    volatile Uint32 NEST_LEVEL_REG240;
    volatile Uint32 NEST_LEVEL_REG241;
    volatile Uint32 NEST_LEVEL_REG242;
    volatile Uint32 NEST_LEVEL_REG243;
    volatile Uint32 NEST_LEVEL_REG244;
    volatile Uint32 NEST_LEVEL_REG245;
    volatile Uint32 NEST_LEVEL_REG246;
    volatile Uint32 NEST_LEVEL_REG247;
    volatile Uint32 NEST_LEVEL_REG248;
    volatile Uint32 NEST_LEVEL_REG249;
    volatile Uint32 NEST_LEVEL_REG250;
    volatile Uint32 NEST_LEVEL_REG251;
    volatile Uint32 NEST_LEVEL_REG252;
    volatile Uint32 NEST_LEVEL_REG253;
    volatile Uint32 NEST_LEVEL_REG254;
    volatile Uint32 NEST_LEVEL_REG255;
#else
    volatile Uint32 NEST_LEVEL_REG[256];
#endif
#ifdef CSL_MODIFICATION    
    volatile Uint32 ENABLE_HINT_REG0;
    volatile Uint32 ENABLE_HINT_REG1;
    volatile Uint32 ENABLE_HINT_REG2;
    volatile Uint32 ENABLE_HINT_REG3;
    volatile Uint32 ENABLE_HINT_REG4;
    volatile Uint32 ENABLE_HINT_REG5;
    volatile Uint32 ENABLE_HINT_REG6;
    volatile Uint32 ENABLE_HINT_REG7;
#else
    volatile Uint32 ENABLE_HINT_REG[8];
#endif    
    volatile Uint8 RSVD8[2784];
#ifdef CSL_MODIFICATION    
    volatile Uint32 VECTOR_ADDRESS_REG_0;
    volatile Uint32 VECTOR_ADDRESS_REG_1;
    volatile Uint32 VECTOR_ADDRESS_REG_2;
    volatile Uint32 VECTOR_ADDRESS_REG_3;
    volatile Uint32 VECTOR_ADDRESS_REG_4;
    volatile Uint32 VECTOR_ADDRESS_REG_5;
    volatile Uint32 VECTOR_ADDRESS_REG_6;
    volatile Uint32 VECTOR_ADDRESS_REG_7;
    volatile Uint32 VECTOR_ADDRESS_REG_8;
    volatile Uint32 VECTOR_ADDRESS_REG_9;
    volatile Uint32 VECTOR_ADDRESS_REG_10;
    volatile Uint32 VECTOR_ADDRESS_REG_11;
    volatile Uint32 VECTOR_ADDRESS_REG_12;
    volatile Uint32 VECTOR_ADDRESS_REG_13;
    volatile Uint32 VECTOR_ADDRESS_REG_14;
    volatile Uint32 VECTOR_ADDRESS_REG_15;
    volatile Uint32 VECTOR_ADDRESS_REG_16;
    volatile Uint32 VECTOR_ADDRESS_REG_17;
    volatile Uint32 VECTOR_ADDRESS_REG_18;
    volatile Uint32 VECTOR_ADDRESS_REG_19;
    volatile Uint32 VECTOR_ADDRESS_REG_20;
    volatile Uint32 VECTOR_ADDRESS_REG_21;
    volatile Uint32 VECTOR_ADDRESS_REG_22;
    volatile Uint32 VECTOR_ADDRESS_REG_23;
    volatile Uint32 VECTOR_ADDRESS_REG_24;
    volatile Uint32 VECTOR_ADDRESS_REG_25;
    volatile Uint32 VECTOR_ADDRESS_REG_26;
    volatile Uint32 VECTOR_ADDRESS_REG_27;
    volatile Uint32 VECTOR_ADDRESS_REG_28;
    volatile Uint32 VECTOR_ADDRESS_REG_29;
    volatile Uint32 VECTOR_ADDRESS_REG_30;
    volatile Uint32 VECTOR_ADDRESS_REG_31;
    volatile Uint32 VECTOR_ADDRESS_REG_32;
    volatile Uint32 VECTOR_ADDRESS_REG_33;
    volatile Uint32 VECTOR_ADDRESS_REG_34;
    volatile Uint32 VECTOR_ADDRESS_REG_35;
    volatile Uint32 VECTOR_ADDRESS_REG_36;
    volatile Uint32 VECTOR_ADDRESS_REG_37;
    volatile Uint32 VECTOR_ADDRESS_REG_38;
    volatile Uint32 VECTOR_ADDRESS_REG_39;
    volatile Uint32 VECTOR_ADDRESS_REG_40;
    volatile Uint32 VECTOR_ADDRESS_REG_41;
    volatile Uint32 VECTOR_ADDRESS_REG_42;
    volatile Uint32 VECTOR_ADDRESS_REG_43;
    volatile Uint32 VECTOR_ADDRESS_REG_44;
    volatile Uint32 VECTOR_ADDRESS_REG_45;
    volatile Uint32 VECTOR_ADDRESS_REG_46;
    volatile Uint32 VECTOR_ADDRESS_REG_47;
    volatile Uint32 VECTOR_ADDRESS_REG_48;
    volatile Uint32 VECTOR_ADDRESS_REG_49;
    volatile Uint32 VECTOR_ADDRESS_REG_50;
    volatile Uint32 VECTOR_ADDRESS_REG_51;
    volatile Uint32 VECTOR_ADDRESS_REG_52;
    volatile Uint32 VECTOR_ADDRESS_REG_53;
    volatile Uint32 VECTOR_ADDRESS_REG_54;
    volatile Uint32 VECTOR_ADDRESS_REG_55;
    volatile Uint32 VECTOR_ADDRESS_REG_56;
    volatile Uint32 VECTOR_ADDRESS_REG_57;
    volatile Uint32 VECTOR_ADDRESS_REG_58;
    volatile Uint32 VECTOR_ADDRESS_REG_59;
    volatile Uint32 VECTOR_ADDRESS_REG_60;
    volatile Uint32 VECTOR_ADDRESS_REG_61;
    volatile Uint32 VECTOR_ADDRESS_REG_62;
    volatile Uint32 VECTOR_ADDRESS_REG_63;
    volatile Uint32 VECTOR_ADDRESS_REG_64;
    volatile Uint32 VECTOR_ADDRESS_REG_65;
    volatile Uint32 VECTOR_ADDRESS_REG_66;
    volatile Uint32 VECTOR_ADDRESS_REG_67;
    volatile Uint32 VECTOR_ADDRESS_REG_68;
    volatile Uint32 VECTOR_ADDRESS_REG_69;
    volatile Uint32 VECTOR_ADDRESS_REG_70;
    volatile Uint32 VECTOR_ADDRESS_REG_71;
    volatile Uint32 VECTOR_ADDRESS_REG_72;
    volatile Uint32 VECTOR_ADDRESS_REG_73;
    volatile Uint32 VECTOR_ADDRESS_REG_74;
    volatile Uint32 VECTOR_ADDRESS_REG_75;
    volatile Uint32 VECTOR_ADDRESS_REG_76;
    volatile Uint32 VECTOR_ADDRESS_REG_77;
    volatile Uint32 VECTOR_ADDRESS_REG_78;
    volatile Uint32 VECTOR_ADDRESS_REG_79;
    volatile Uint32 VECTOR_ADDRESS_REG_80;
    volatile Uint32 VECTOR_ADDRESS_REG_81;
    volatile Uint32 VECTOR_ADDRESS_REG_82;
    volatile Uint32 VECTOR_ADDRESS_REG_83;
    volatile Uint32 VECTOR_ADDRESS_REG_84;
    volatile Uint32 VECTOR_ADDRESS_REG_85;
    volatile Uint32 VECTOR_ADDRESS_REG_86;
    volatile Uint32 VECTOR_ADDRESS_REG_87;
    volatile Uint32 VECTOR_ADDRESS_REG_88;
    volatile Uint32 VECTOR_ADDRESS_REG_89;
    volatile Uint32 VECTOR_ADDRESS_REG_90;
    volatile Uint32 VECTOR_ADDRESS_REG_91;
    volatile Uint32 VECTOR_ADDRESS_REG_92;
    volatile Uint32 VECTOR_ADDRESS_REG_93;
    volatile Uint32 VECTOR_ADDRESS_REG_94;
    volatile Uint32 VECTOR_ADDRESS_REG_95;
    volatile Uint32 VECTOR_ADDRESS_REG_96;
    volatile Uint32 VECTOR_ADDRESS_REG_97;
    volatile Uint32 VECTOR_ADDRESS_REG_98;
    volatile Uint32 VECTOR_ADDRESS_REG_99;
    volatile Uint32 VECTOR_ADDRESS_REG_100;
    volatile Uint32 VECTOR_ADDRESS_REG_101;
    volatile Uint32 VECTOR_ADDRESS_REG_102;
    volatile Uint32 VECTOR_ADDRESS_REG_103;
    volatile Uint32 VECTOR_ADDRESS_REG_104;
    volatile Uint32 VECTOR_ADDRESS_REG_105;
    volatile Uint32 VECTOR_ADDRESS_REG_106;
    volatile Uint32 VECTOR_ADDRESS_REG_107;
    volatile Uint32 VECTOR_ADDRESS_REG_108;
    volatile Uint32 VECTOR_ADDRESS_REG_109;
    volatile Uint32 VECTOR_ADDRESS_REG_110;
    volatile Uint32 VECTOR_ADDRESS_REG_111;
    volatile Uint32 VECTOR_ADDRESS_REG_112;
    volatile Uint32 VECTOR_ADDRESS_REG_113;
    volatile Uint32 VECTOR_ADDRESS_REG_114;
    volatile Uint32 VECTOR_ADDRESS_REG_115;
    volatile Uint32 VECTOR_ADDRESS_REG_116;
    volatile Uint32 VECTOR_ADDRESS_REG_117;
    volatile Uint32 VECTOR_ADDRESS_REG_118;
    volatile Uint32 VECTOR_ADDRESS_REG_119;
    volatile Uint32 VECTOR_ADDRESS_REG_120;
    volatile Uint32 VECTOR_ADDRESS_REG_121;
    volatile Uint32 VECTOR_ADDRESS_REG_122;
    volatile Uint32 VECTOR_ADDRESS_REG_123;
    volatile Uint32 VECTOR_ADDRESS_REG_124;
    volatile Uint32 VECTOR_ADDRESS_REG_125;
    volatile Uint32 VECTOR_ADDRESS_REG_126;
    volatile Uint32 VECTOR_ADDRESS_REG_127;
    volatile Uint32 VECTOR_ADDRESS_REG_128;
    volatile Uint32 VECTOR_ADDRESS_REG_129;
    volatile Uint32 VECTOR_ADDRESS_REG_130;
    volatile Uint32 VECTOR_ADDRESS_REG_131;
    volatile Uint32 VECTOR_ADDRESS_REG_132;
    volatile Uint32 VECTOR_ADDRESS_REG_133;
    volatile Uint32 VECTOR_ADDRESS_REG_134;
    volatile Uint32 VECTOR_ADDRESS_REG_135;
    volatile Uint32 VECTOR_ADDRESS_REG_136;
    volatile Uint32 VECTOR_ADDRESS_REG_137;
    volatile Uint32 VECTOR_ADDRESS_REG_138;
    volatile Uint32 VECTOR_ADDRESS_REG_139;
    volatile Uint32 VECTOR_ADDRESS_REG_140;
    volatile Uint32 VECTOR_ADDRESS_REG_141;
    volatile Uint32 VECTOR_ADDRESS_REG_142;
    volatile Uint32 VECTOR_ADDRESS_REG_143;
    volatile Uint32 VECTOR_ADDRESS_REG_144;
    volatile Uint32 VECTOR_ADDRESS_REG_145;
    volatile Uint32 VECTOR_ADDRESS_REG_146;
    volatile Uint32 VECTOR_ADDRESS_REG_147;
    volatile Uint32 VECTOR_ADDRESS_REG_148;
    volatile Uint32 VECTOR_ADDRESS_REG_149;
    volatile Uint32 VECTOR_ADDRESS_REG_150;
    volatile Uint32 VECTOR_ADDRESS_REG_151;
    volatile Uint32 VECTOR_ADDRESS_REG_152;
    volatile Uint32 VECTOR_ADDRESS_REG_153;
    volatile Uint32 VECTOR_ADDRESS_REG_154;
    volatile Uint32 VECTOR_ADDRESS_REG_155;
    volatile Uint32 VECTOR_ADDRESS_REG_156;
    volatile Uint32 VECTOR_ADDRESS_REG_157;
    volatile Uint32 VECTOR_ADDRESS_REG_158;
    volatile Uint32 VECTOR_ADDRESS_REG_159;
    volatile Uint32 VECTOR_ADDRESS_REG_160;
    volatile Uint32 VECTOR_ADDRESS_REG_161;
    volatile Uint32 VECTOR_ADDRESS_REG_162;
    volatile Uint32 VECTOR_ADDRESS_REG_163;
    volatile Uint32 VECTOR_ADDRESS_REG_164;
    volatile Uint32 VECTOR_ADDRESS_REG_165;
    volatile Uint32 VECTOR_ADDRESS_REG_166;
    volatile Uint32 VECTOR_ADDRESS_REG_167;
    volatile Uint32 VECTOR_ADDRESS_REG_168;
    volatile Uint32 VECTOR_ADDRESS_REG_169;
    volatile Uint32 VECTOR_ADDRESS_REG_170;
    volatile Uint32 VECTOR_ADDRESS_REG_171;
    volatile Uint32 VECTOR_ADDRESS_REG_172;
    volatile Uint32 VECTOR_ADDRESS_REG_173;
    volatile Uint32 VECTOR_ADDRESS_REG_174;
    volatile Uint32 VECTOR_ADDRESS_REG_175;
    volatile Uint32 VECTOR_ADDRESS_REG_176;
    volatile Uint32 VECTOR_ADDRESS_REG_177;
    volatile Uint32 VECTOR_ADDRESS_REG_178;
    volatile Uint32 VECTOR_ADDRESS_REG_179;
    volatile Uint32 VECTOR_ADDRESS_REG_180;
    volatile Uint32 VECTOR_ADDRESS_REG_181;
    volatile Uint32 VECTOR_ADDRESS_REG_182;
    volatile Uint32 VECTOR_ADDRESS_REG_183;
    volatile Uint32 VECTOR_ADDRESS_REG_184;
    volatile Uint32 VECTOR_ADDRESS_REG_185;
    volatile Uint32 VECTOR_ADDRESS_REG_186;
    volatile Uint32 VECTOR_ADDRESS_REG_187;
    volatile Uint32 VECTOR_ADDRESS_REG_188;
    volatile Uint32 VECTOR_ADDRESS_REG_189;
    volatile Uint32 VECTOR_ADDRESS_REG_190;
    volatile Uint32 VECTOR_ADDRESS_REG_191;
    volatile Uint32 VECTOR_ADDRESS_REG_192;
    volatile Uint32 VECTOR_ADDRESS_REG_193;
    volatile Uint32 VECTOR_ADDRESS_REG_194;
    volatile Uint32 VECTOR_ADDRESS_REG_195;
    volatile Uint32 VECTOR_ADDRESS_REG_196;
    volatile Uint32 VECTOR_ADDRESS_REG_197;
    volatile Uint32 VECTOR_ADDRESS_REG_198;
    volatile Uint32 VECTOR_ADDRESS_REG_199;
    volatile Uint32 VECTOR_ADDRESS_REG_200;
    volatile Uint32 VECTOR_ADDRESS_REG_201;
    volatile Uint32 VECTOR_ADDRESS_REG_202;
    volatile Uint32 VECTOR_ADDRESS_REG_203;
    volatile Uint32 VECTOR_ADDRESS_REG_204;
    volatile Uint32 VECTOR_ADDRESS_REG_205;
    volatile Uint32 VECTOR_ADDRESS_REG_206;
    volatile Uint32 VECTOR_ADDRESS_REG_207;
    volatile Uint32 VECTOR_ADDRESS_REG_208;
    volatile Uint32 VECTOR_ADDRESS_REG_209;
    volatile Uint32 VECTOR_ADDRESS_REG_210;
    volatile Uint32 VECTOR_ADDRESS_REG_211;
    volatile Uint32 VECTOR_ADDRESS_REG_212;
    volatile Uint32 VECTOR_ADDRESS_REG_213;
    volatile Uint32 VECTOR_ADDRESS_REG_214;
    volatile Uint32 VECTOR_ADDRESS_REG_215;
    volatile Uint32 VECTOR_ADDRESS_REG_216;
    volatile Uint32 VECTOR_ADDRESS_REG_217;
    volatile Uint32 VECTOR_ADDRESS_REG_218;
    volatile Uint32 VECTOR_ADDRESS_REG_219;
    volatile Uint32 VECTOR_ADDRESS_REG_220;
    volatile Uint32 VECTOR_ADDRESS_REG_221;
    volatile Uint32 VECTOR_ADDRESS_REG_222;
    volatile Uint32 VECTOR_ADDRESS_REG_223;
    volatile Uint32 VECTOR_ADDRESS_REG_224;
    volatile Uint32 VECTOR_ADDRESS_REG_225;
    volatile Uint32 VECTOR_ADDRESS_REG_226;
    volatile Uint32 VECTOR_ADDRESS_REG_227;
    volatile Uint32 VECTOR_ADDRESS_REG_228;
    volatile Uint32 VECTOR_ADDRESS_REG_229;
    volatile Uint32 VECTOR_ADDRESS_REG_230;
    volatile Uint32 VECTOR_ADDRESS_REG_231;
    volatile Uint32 VECTOR_ADDRESS_REG_232;
    volatile Uint32 VECTOR_ADDRESS_REG_233;
    volatile Uint32 VECTOR_ADDRESS_REG_234;
    volatile Uint32 VECTOR_ADDRESS_REG_235;
    volatile Uint32 VECTOR_ADDRESS_REG_236;
    volatile Uint32 VECTOR_ADDRESS_REG_237;
    volatile Uint32 VECTOR_ADDRESS_REG_238;
    volatile Uint32 VECTOR_ADDRESS_REG_239;
    volatile Uint32 VECTOR_ADDRESS_REG_240;
    volatile Uint32 VECTOR_ADDRESS_REG_241;
    volatile Uint32 VECTOR_ADDRESS_REG_242;
    volatile Uint32 VECTOR_ADDRESS_REG_243;
    volatile Uint32 VECTOR_ADDRESS_REG_244;
    volatile Uint32 VECTOR_ADDRESS_REG_245;
    volatile Uint32 VECTOR_ADDRESS_REG_246;
    volatile Uint32 VECTOR_ADDRESS_REG_247;
    volatile Uint32 VECTOR_ADDRESS_REG_248;
    volatile Uint32 VECTOR_ADDRESS_REG_249;
    volatile Uint32 VECTOR_ADDRESS_REG_250;
    volatile Uint32 VECTOR_ADDRESS_REG_251;
    volatile Uint32 VECTOR_ADDRESS_REG_252;
    volatile Uint32 VECTOR_ADDRESS_REG_253;
    volatile Uint32 VECTOR_ADDRESS_REG_254;
    volatile Uint32 VECTOR_ADDRESS_REG_255;
    volatile Uint32 VECTOR_ADDRESS_REG_256;
    volatile Uint32 VECTOR_ADDRESS_REG_257;
    volatile Uint32 VECTOR_ADDRESS_REG_258;
    volatile Uint32 VECTOR_ADDRESS_REG_259;
    volatile Uint32 VECTOR_ADDRESS_REG_260;
    volatile Uint32 VECTOR_ADDRESS_REG_261;
    volatile Uint32 VECTOR_ADDRESS_REG_262;
    volatile Uint32 VECTOR_ADDRESS_REG_263;
    volatile Uint32 VECTOR_ADDRESS_REG_264;
    volatile Uint32 VECTOR_ADDRESS_REG_265;
    volatile Uint32 VECTOR_ADDRESS_REG_266;
    volatile Uint32 VECTOR_ADDRESS_REG_267;
    volatile Uint32 VECTOR_ADDRESS_REG_268;
    volatile Uint32 VECTOR_ADDRESS_REG_269;
    volatile Uint32 VECTOR_ADDRESS_REG_270;
    volatile Uint32 VECTOR_ADDRESS_REG_271;
    volatile Uint32 VECTOR_ADDRESS_REG_272;
    volatile Uint32 VECTOR_ADDRESS_REG_273;
    volatile Uint32 VECTOR_ADDRESS_REG_274;
    volatile Uint32 VECTOR_ADDRESS_REG_275;
    volatile Uint32 VECTOR_ADDRESS_REG_276;
    volatile Uint32 VECTOR_ADDRESS_REG_277;
    volatile Uint32 VECTOR_ADDRESS_REG_278;
    volatile Uint32 VECTOR_ADDRESS_REG_279;
    volatile Uint32 VECTOR_ADDRESS_REG_280;
    volatile Uint32 VECTOR_ADDRESS_REG_281;
    volatile Uint32 VECTOR_ADDRESS_REG_282;
    volatile Uint32 VECTOR_ADDRESS_REG_283;
    volatile Uint32 VECTOR_ADDRESS_REG_284;
    volatile Uint32 VECTOR_ADDRESS_REG_285;
    volatile Uint32 VECTOR_ADDRESS_REG_286;
    volatile Uint32 VECTOR_ADDRESS_REG_287;
    volatile Uint32 VECTOR_ADDRESS_REG_288;
    volatile Uint32 VECTOR_ADDRESS_REG_289;
    volatile Uint32 VECTOR_ADDRESS_REG_290;
    volatile Uint32 VECTOR_ADDRESS_REG_291;
    volatile Uint32 VECTOR_ADDRESS_REG_292;
    volatile Uint32 VECTOR_ADDRESS_REG_293;
    volatile Uint32 VECTOR_ADDRESS_REG_294;
    volatile Uint32 VECTOR_ADDRESS_REG_295;
    volatile Uint32 VECTOR_ADDRESS_REG_296;
    volatile Uint32 VECTOR_ADDRESS_REG_297;
    volatile Uint32 VECTOR_ADDRESS_REG_298;
    volatile Uint32 VECTOR_ADDRESS_REG_299;
    volatile Uint32 VECTOR_ADDRESS_REG_300;
    volatile Uint32 VECTOR_ADDRESS_REG_301;
    volatile Uint32 VECTOR_ADDRESS_REG_302;
    volatile Uint32 VECTOR_ADDRESS_REG_303;
    volatile Uint32 VECTOR_ADDRESS_REG_304;
    volatile Uint32 VECTOR_ADDRESS_REG_305;
    volatile Uint32 VECTOR_ADDRESS_REG_306;
    volatile Uint32 VECTOR_ADDRESS_REG_307;
    volatile Uint32 VECTOR_ADDRESS_REG_308;
    volatile Uint32 VECTOR_ADDRESS_REG_309;
    volatile Uint32 VECTOR_ADDRESS_REG_310;
    volatile Uint32 VECTOR_ADDRESS_REG_311;
    volatile Uint32 VECTOR_ADDRESS_REG_312;
    volatile Uint32 VECTOR_ADDRESS_REG_313;
    volatile Uint32 VECTOR_ADDRESS_REG_314;
    volatile Uint32 VECTOR_ADDRESS_REG_315;
    volatile Uint32 VECTOR_ADDRESS_REG_316;
    volatile Uint32 VECTOR_ADDRESS_REG_317;
    volatile Uint32 VECTOR_ADDRESS_REG_318;
    volatile Uint32 VECTOR_ADDRESS_REG_319;
    volatile Uint32 VECTOR_ADDRESS_REG_320;
    volatile Uint32 VECTOR_ADDRESS_REG_321;
    volatile Uint32 VECTOR_ADDRESS_REG_322;
    volatile Uint32 VECTOR_ADDRESS_REG_323;
    volatile Uint32 VECTOR_ADDRESS_REG_324;
    volatile Uint32 VECTOR_ADDRESS_REG_325;
    volatile Uint32 VECTOR_ADDRESS_REG_326;
    volatile Uint32 VECTOR_ADDRESS_REG_327;
    volatile Uint32 VECTOR_ADDRESS_REG_328;
    volatile Uint32 VECTOR_ADDRESS_REG_329;
    volatile Uint32 VECTOR_ADDRESS_REG_330;
    volatile Uint32 VECTOR_ADDRESS_REG_331;
    volatile Uint32 VECTOR_ADDRESS_REG_332;
    volatile Uint32 VECTOR_ADDRESS_REG_333;
    volatile Uint32 VECTOR_ADDRESS_REG_334;
    volatile Uint32 VECTOR_ADDRESS_REG_335;
    volatile Uint32 VECTOR_ADDRESS_REG_336;
    volatile Uint32 VECTOR_ADDRESS_REG_337;
    volatile Uint32 VECTOR_ADDRESS_REG_338;
    volatile Uint32 VECTOR_ADDRESS_REG_339;
    volatile Uint32 VECTOR_ADDRESS_REG_340;
    volatile Uint32 VECTOR_ADDRESS_REG_341;
    volatile Uint32 VECTOR_ADDRESS_REG_342;
    volatile Uint32 VECTOR_ADDRESS_REG_343;
    volatile Uint32 VECTOR_ADDRESS_REG_344;
    volatile Uint32 VECTOR_ADDRESS_REG_345;
    volatile Uint32 VECTOR_ADDRESS_REG_346;
    volatile Uint32 VECTOR_ADDRESS_REG_347;
    volatile Uint32 VECTOR_ADDRESS_REG_348;
    volatile Uint32 VECTOR_ADDRESS_REG_349;
    volatile Uint32 VECTOR_ADDRESS_REG_350;
    volatile Uint32 VECTOR_ADDRESS_REG_351;
    volatile Uint32 VECTOR_ADDRESS_REG_352;
    volatile Uint32 VECTOR_ADDRESS_REG_353;
    volatile Uint32 VECTOR_ADDRESS_REG_354;
    volatile Uint32 VECTOR_ADDRESS_REG_355;
    volatile Uint32 VECTOR_ADDRESS_REG_356;
    volatile Uint32 VECTOR_ADDRESS_REG_357;
    volatile Uint32 VECTOR_ADDRESS_REG_358;
    volatile Uint32 VECTOR_ADDRESS_REG_359;
    volatile Uint32 VECTOR_ADDRESS_REG_360;
    volatile Uint32 VECTOR_ADDRESS_REG_361;
    volatile Uint32 VECTOR_ADDRESS_REG_362;
    volatile Uint32 VECTOR_ADDRESS_REG_363;
    volatile Uint32 VECTOR_ADDRESS_REG_364;
    volatile Uint32 VECTOR_ADDRESS_REG_365;
    volatile Uint32 VECTOR_ADDRESS_REG_366;
    volatile Uint32 VECTOR_ADDRESS_REG_367;
    volatile Uint32 VECTOR_ADDRESS_REG_368;
    volatile Uint32 VECTOR_ADDRESS_REG_369;
    volatile Uint32 VECTOR_ADDRESS_REG_370;
    volatile Uint32 VECTOR_ADDRESS_REG_371;
    volatile Uint32 VECTOR_ADDRESS_REG_372;
    volatile Uint32 VECTOR_ADDRESS_REG_373;
    volatile Uint32 VECTOR_ADDRESS_REG_374;
    volatile Uint32 VECTOR_ADDRESS_REG_375;
    volatile Uint32 VECTOR_ADDRESS_REG_376;
    volatile Uint32 VECTOR_ADDRESS_REG_377;
    volatile Uint32 VECTOR_ADDRESS_REG_378;
    volatile Uint32 VECTOR_ADDRESS_REG_379;
    volatile Uint32 VECTOR_ADDRESS_REG_380;
    volatile Uint32 VECTOR_ADDRESS_REG_381;
    volatile Uint32 VECTOR_ADDRESS_REG_382;
    volatile Uint32 VECTOR_ADDRESS_REG_383;
    volatile Uint32 VECTOR_ADDRESS_REG_384;
    volatile Uint32 VECTOR_ADDRESS_REG_385;
    volatile Uint32 VECTOR_ADDRESS_REG_386;
    volatile Uint32 VECTOR_ADDRESS_REG_387;
    volatile Uint32 VECTOR_ADDRESS_REG_388;
    volatile Uint32 VECTOR_ADDRESS_REG_389;
    volatile Uint32 VECTOR_ADDRESS_REG_390;
    volatile Uint32 VECTOR_ADDRESS_REG_391;
    volatile Uint32 VECTOR_ADDRESS_REG_392;
    volatile Uint32 VECTOR_ADDRESS_REG_393;
    volatile Uint32 VECTOR_ADDRESS_REG_394;
    volatile Uint32 VECTOR_ADDRESS_REG_395;
    volatile Uint32 VECTOR_ADDRESS_REG_396;
    volatile Uint32 VECTOR_ADDRESS_REG_397;
    volatile Uint32 VECTOR_ADDRESS_REG_398;
    volatile Uint32 VECTOR_ADDRESS_REG_399;
    volatile Uint32 VECTOR_ADDRESS_REG_400;
    volatile Uint32 VECTOR_ADDRESS_REG_401;
    volatile Uint32 VECTOR_ADDRESS_REG_402;
    volatile Uint32 VECTOR_ADDRESS_REG_403;
    volatile Uint32 VECTOR_ADDRESS_REG_404;
    volatile Uint32 VECTOR_ADDRESS_REG_405;
    volatile Uint32 VECTOR_ADDRESS_REG_406;
    volatile Uint32 VECTOR_ADDRESS_REG_407;
    volatile Uint32 VECTOR_ADDRESS_REG_408;
    volatile Uint32 VECTOR_ADDRESS_REG_409;
    volatile Uint32 VECTOR_ADDRESS_REG_410;
    volatile Uint32 VECTOR_ADDRESS_REG_411;
    volatile Uint32 VECTOR_ADDRESS_REG_412;
    volatile Uint32 VECTOR_ADDRESS_REG_413;
    volatile Uint32 VECTOR_ADDRESS_REG_414;
    volatile Uint32 VECTOR_ADDRESS_REG_415;
    volatile Uint32 VECTOR_ADDRESS_REG_416;
    volatile Uint32 VECTOR_ADDRESS_REG_417;
    volatile Uint32 VECTOR_ADDRESS_REG_418;
    volatile Uint32 VECTOR_ADDRESS_REG_419;
    volatile Uint32 VECTOR_ADDRESS_REG_420;
    volatile Uint32 VECTOR_ADDRESS_REG_421;
    volatile Uint32 VECTOR_ADDRESS_REG_422;
    volatile Uint32 VECTOR_ADDRESS_REG_423;
    volatile Uint32 VECTOR_ADDRESS_REG_424;
    volatile Uint32 VECTOR_ADDRESS_REG_425;
    volatile Uint32 VECTOR_ADDRESS_REG_426;
    volatile Uint32 VECTOR_ADDRESS_REG_427;
    volatile Uint32 VECTOR_ADDRESS_REG_428;
    volatile Uint32 VECTOR_ADDRESS_REG_429;
    volatile Uint32 VECTOR_ADDRESS_REG_430;
    volatile Uint32 VECTOR_ADDRESS_REG_431;
    volatile Uint32 VECTOR_ADDRESS_REG_432;
    volatile Uint32 VECTOR_ADDRESS_REG_433;
    volatile Uint32 VECTOR_ADDRESS_REG_434;
    volatile Uint32 VECTOR_ADDRESS_REG_435;
    volatile Uint32 VECTOR_ADDRESS_REG_436;
    volatile Uint32 VECTOR_ADDRESS_REG_437;
    volatile Uint32 VECTOR_ADDRESS_REG_438;
    volatile Uint32 VECTOR_ADDRESS_REG_439;
    volatile Uint32 VECTOR_ADDRESS_REG_440;
    volatile Uint32 VECTOR_ADDRESS_REG_441;
    volatile Uint32 VECTOR_ADDRESS_REG_442;
    volatile Uint32 VECTOR_ADDRESS_REG_443;
    volatile Uint32 VECTOR_ADDRESS_REG_444;
    volatile Uint32 VECTOR_ADDRESS_REG_445;
    volatile Uint32 VECTOR_ADDRESS_REG_446;
    volatile Uint32 VECTOR_ADDRESS_REG_447;
    volatile Uint32 VECTOR_ADDRESS_REG_448;
    volatile Uint32 VECTOR_ADDRESS_REG_449;
    volatile Uint32 VECTOR_ADDRESS_REG_450;
    volatile Uint32 VECTOR_ADDRESS_REG_451;
    volatile Uint32 VECTOR_ADDRESS_REG_452;
    volatile Uint32 VECTOR_ADDRESS_REG_453;
    volatile Uint32 VECTOR_ADDRESS_REG_454;
    volatile Uint32 VECTOR_ADDRESS_REG_455;
    volatile Uint32 VECTOR_ADDRESS_REG_456;
    volatile Uint32 VECTOR_ADDRESS_REG_457;
    volatile Uint32 VECTOR_ADDRESS_REG_458;
    volatile Uint32 VECTOR_ADDRESS_REG_459;
    volatile Uint32 VECTOR_ADDRESS_REG_460;
    volatile Uint32 VECTOR_ADDRESS_REG_461;
    volatile Uint32 VECTOR_ADDRESS_REG_462;
    volatile Uint32 VECTOR_ADDRESS_REG_463;
    volatile Uint32 VECTOR_ADDRESS_REG_464;
    volatile Uint32 VECTOR_ADDRESS_REG_465;
    volatile Uint32 VECTOR_ADDRESS_REG_466;
    volatile Uint32 VECTOR_ADDRESS_REG_467;
    volatile Uint32 VECTOR_ADDRESS_REG_468;
    volatile Uint32 VECTOR_ADDRESS_REG_469;
    volatile Uint32 VECTOR_ADDRESS_REG_470;
    volatile Uint32 VECTOR_ADDRESS_REG_471;
    volatile Uint32 VECTOR_ADDRESS_REG_472;
    volatile Uint32 VECTOR_ADDRESS_REG_473;
    volatile Uint32 VECTOR_ADDRESS_REG_474;
    volatile Uint32 VECTOR_ADDRESS_REG_475;
    volatile Uint32 VECTOR_ADDRESS_REG_476;
    volatile Uint32 VECTOR_ADDRESS_REG_477;
    volatile Uint32 VECTOR_ADDRESS_REG_478;
    volatile Uint32 VECTOR_ADDRESS_REG_479;
    volatile Uint32 VECTOR_ADDRESS_REG_480;
    volatile Uint32 VECTOR_ADDRESS_REG_481;
    volatile Uint32 VECTOR_ADDRESS_REG_482;
    volatile Uint32 VECTOR_ADDRESS_REG_483;
    volatile Uint32 VECTOR_ADDRESS_REG_484;
    volatile Uint32 VECTOR_ADDRESS_REG_485;
    volatile Uint32 VECTOR_ADDRESS_REG_486;
    volatile Uint32 VECTOR_ADDRESS_REG_487;
    volatile Uint32 VECTOR_ADDRESS_REG_488;
    volatile Uint32 VECTOR_ADDRESS_REG_489;
    volatile Uint32 VECTOR_ADDRESS_REG_490;
    volatile Uint32 VECTOR_ADDRESS_REG_491;
    volatile Uint32 VECTOR_ADDRESS_REG_492;
    volatile Uint32 VECTOR_ADDRESS_REG_493;
    volatile Uint32 VECTOR_ADDRESS_REG_494;
    volatile Uint32 VECTOR_ADDRESS_REG_495;
    volatile Uint32 VECTOR_ADDRESS_REG_496;
    volatile Uint32 VECTOR_ADDRESS_REG_497;
    volatile Uint32 VECTOR_ADDRESS_REG_498;
    volatile Uint32 VECTOR_ADDRESS_REG_499;
    volatile Uint32 VECTOR_ADDRESS_REG_500;
    volatile Uint32 VECTOR_ADDRESS_REG_501;
    volatile Uint32 VECTOR_ADDRESS_REG_502;
    volatile Uint32 VECTOR_ADDRESS_REG_503;
    volatile Uint32 VECTOR_ADDRESS_REG_504;
    volatile Uint32 VECTOR_ADDRESS_REG_505;
    volatile Uint32 VECTOR_ADDRESS_REG_506;
    volatile Uint32 VECTOR_ADDRESS_REG_507;
    volatile Uint32 VECTOR_ADDRESS_REG_508;
    volatile Uint32 VECTOR_ADDRESS_REG_509;
    volatile Uint32 VECTOR_ADDRESS_REG_510;
    volatile Uint32 VECTOR_ADDRESS_REG_511;
    volatile Uint32 VECTOR_ADDRESS_REG_512;
    volatile Uint32 VECTOR_ADDRESS_REG_513;
    volatile Uint32 VECTOR_ADDRESS_REG_514;
    volatile Uint32 VECTOR_ADDRESS_REG_515;
    volatile Uint32 VECTOR_ADDRESS_REG_516;
    volatile Uint32 VECTOR_ADDRESS_REG_517;
    volatile Uint32 VECTOR_ADDRESS_REG_518;
    volatile Uint32 VECTOR_ADDRESS_REG_519;
    volatile Uint32 VECTOR_ADDRESS_REG_520;
    volatile Uint32 VECTOR_ADDRESS_REG_521;
    volatile Uint32 VECTOR_ADDRESS_REG_522;
    volatile Uint32 VECTOR_ADDRESS_REG_523;
    volatile Uint32 VECTOR_ADDRESS_REG_524;
    volatile Uint32 VECTOR_ADDRESS_REG_525;
    volatile Uint32 VECTOR_ADDRESS_REG_526;
    volatile Uint32 VECTOR_ADDRESS_REG_527;
    volatile Uint32 VECTOR_ADDRESS_REG_528;
    volatile Uint32 VECTOR_ADDRESS_REG_529;
    volatile Uint32 VECTOR_ADDRESS_REG_530;
    volatile Uint32 VECTOR_ADDRESS_REG_531;
    volatile Uint32 VECTOR_ADDRESS_REG_532;
    volatile Uint32 VECTOR_ADDRESS_REG_533;
    volatile Uint32 VECTOR_ADDRESS_REG_534;
    volatile Uint32 VECTOR_ADDRESS_REG_535;
    volatile Uint32 VECTOR_ADDRESS_REG_536;
    volatile Uint32 VECTOR_ADDRESS_REG_537;
    volatile Uint32 VECTOR_ADDRESS_REG_538;
    volatile Uint32 VECTOR_ADDRESS_REG_539;
    volatile Uint32 VECTOR_ADDRESS_REG_540;
    volatile Uint32 VECTOR_ADDRESS_REG_541;
    volatile Uint32 VECTOR_ADDRESS_REG_542;
    volatile Uint32 VECTOR_ADDRESS_REG_543;
    volatile Uint32 VECTOR_ADDRESS_REG_544;
    volatile Uint32 VECTOR_ADDRESS_REG_545;
    volatile Uint32 VECTOR_ADDRESS_REG_546;
    volatile Uint32 VECTOR_ADDRESS_REG_547;
    volatile Uint32 VECTOR_ADDRESS_REG_548;
    volatile Uint32 VECTOR_ADDRESS_REG_549;
    volatile Uint32 VECTOR_ADDRESS_REG_550;
    volatile Uint32 VECTOR_ADDRESS_REG_551;
    volatile Uint32 VECTOR_ADDRESS_REG_552;
    volatile Uint32 VECTOR_ADDRESS_REG_553;
    volatile Uint32 VECTOR_ADDRESS_REG_554;
    volatile Uint32 VECTOR_ADDRESS_REG_555;
    volatile Uint32 VECTOR_ADDRESS_REG_556;
    volatile Uint32 VECTOR_ADDRESS_REG_557;
    volatile Uint32 VECTOR_ADDRESS_REG_558;
    volatile Uint32 VECTOR_ADDRESS_REG_559;
    volatile Uint32 VECTOR_ADDRESS_REG_560;
    volatile Uint32 VECTOR_ADDRESS_REG_561;
    volatile Uint32 VECTOR_ADDRESS_REG_562;
    volatile Uint32 VECTOR_ADDRESS_REG_563;
    volatile Uint32 VECTOR_ADDRESS_REG_564;
    volatile Uint32 VECTOR_ADDRESS_REG_565;
    volatile Uint32 VECTOR_ADDRESS_REG_566;
    volatile Uint32 VECTOR_ADDRESS_REG_567;
    volatile Uint32 VECTOR_ADDRESS_REG_568;
    volatile Uint32 VECTOR_ADDRESS_REG_569;
    volatile Uint32 VECTOR_ADDRESS_REG_570;
    volatile Uint32 VECTOR_ADDRESS_REG_571;
    volatile Uint32 VECTOR_ADDRESS_REG_572;
    volatile Uint32 VECTOR_ADDRESS_REG_573;
    volatile Uint32 VECTOR_ADDRESS_REG_574;
    volatile Uint32 VECTOR_ADDRESS_REG_575;
    volatile Uint32 VECTOR_ADDRESS_REG_576;
    volatile Uint32 VECTOR_ADDRESS_REG_577;
    volatile Uint32 VECTOR_ADDRESS_REG_578;
    volatile Uint32 VECTOR_ADDRESS_REG_579;
    volatile Uint32 VECTOR_ADDRESS_REG_580;
    volatile Uint32 VECTOR_ADDRESS_REG_581;
    volatile Uint32 VECTOR_ADDRESS_REG_582;
    volatile Uint32 VECTOR_ADDRESS_REG_583;
    volatile Uint32 VECTOR_ADDRESS_REG_584;
    volatile Uint32 VECTOR_ADDRESS_REG_585;
    volatile Uint32 VECTOR_ADDRESS_REG_586;
    volatile Uint32 VECTOR_ADDRESS_REG_587;
    volatile Uint32 VECTOR_ADDRESS_REG_588;
    volatile Uint32 VECTOR_ADDRESS_REG_589;
    volatile Uint32 VECTOR_ADDRESS_REG_590;
    volatile Uint32 VECTOR_ADDRESS_REG_591;
    volatile Uint32 VECTOR_ADDRESS_REG_592;
    volatile Uint32 VECTOR_ADDRESS_REG_593;
    volatile Uint32 VECTOR_ADDRESS_REG_594;
    volatile Uint32 VECTOR_ADDRESS_REG_595;
    volatile Uint32 VECTOR_ADDRESS_REG_596;
    volatile Uint32 VECTOR_ADDRESS_REG_597;
    volatile Uint32 VECTOR_ADDRESS_REG_598;
    volatile Uint32 VECTOR_ADDRESS_REG_599;
    volatile Uint32 VECTOR_ADDRESS_REG_600;
    volatile Uint32 VECTOR_ADDRESS_REG_601;
    volatile Uint32 VECTOR_ADDRESS_REG_602;
    volatile Uint32 VECTOR_ADDRESS_REG_603;
    volatile Uint32 VECTOR_ADDRESS_REG_604;
    volatile Uint32 VECTOR_ADDRESS_REG_605;
    volatile Uint32 VECTOR_ADDRESS_REG_606;
    volatile Uint32 VECTOR_ADDRESS_REG_607;
    volatile Uint32 VECTOR_ADDRESS_REG_608;
    volatile Uint32 VECTOR_ADDRESS_REG_609;
    volatile Uint32 VECTOR_ADDRESS_REG_610;
    volatile Uint32 VECTOR_ADDRESS_REG_611;
    volatile Uint32 VECTOR_ADDRESS_REG_612;
    volatile Uint32 VECTOR_ADDRESS_REG_613;
    volatile Uint32 VECTOR_ADDRESS_REG_614;
    volatile Uint32 VECTOR_ADDRESS_REG_615;
    volatile Uint32 VECTOR_ADDRESS_REG_616;
    volatile Uint32 VECTOR_ADDRESS_REG_617;
    volatile Uint32 VECTOR_ADDRESS_REG_618;
    volatile Uint32 VECTOR_ADDRESS_REG_619;
    volatile Uint32 VECTOR_ADDRESS_REG_620;
    volatile Uint32 VECTOR_ADDRESS_REG_621;
    volatile Uint32 VECTOR_ADDRESS_REG_622;
    volatile Uint32 VECTOR_ADDRESS_REG_623;
    volatile Uint32 VECTOR_ADDRESS_REG_624;
    volatile Uint32 VECTOR_ADDRESS_REG_625;
    volatile Uint32 VECTOR_ADDRESS_REG_626;
    volatile Uint32 VECTOR_ADDRESS_REG_627;
    volatile Uint32 VECTOR_ADDRESS_REG_628;
    volatile Uint32 VECTOR_ADDRESS_REG_629;
    volatile Uint32 VECTOR_ADDRESS_REG_630;
    volatile Uint32 VECTOR_ADDRESS_REG_631;
    volatile Uint32 VECTOR_ADDRESS_REG_632;
    volatile Uint32 VECTOR_ADDRESS_REG_633;
    volatile Uint32 VECTOR_ADDRESS_REG_634;
    volatile Uint32 VECTOR_ADDRESS_REG_635;
    volatile Uint32 VECTOR_ADDRESS_REG_636;
    volatile Uint32 VECTOR_ADDRESS_REG_637;
    volatile Uint32 VECTOR_ADDRESS_REG_638;
    volatile Uint32 VECTOR_ADDRESS_REG_639;
    volatile Uint32 VECTOR_ADDRESS_REG_640;
    volatile Uint32 VECTOR_ADDRESS_REG_641;
    volatile Uint32 VECTOR_ADDRESS_REG_642;
    volatile Uint32 VECTOR_ADDRESS_REG_643;
    volatile Uint32 VECTOR_ADDRESS_REG_644;
    volatile Uint32 VECTOR_ADDRESS_REG_645;
    volatile Uint32 VECTOR_ADDRESS_REG_646;
    volatile Uint32 VECTOR_ADDRESS_REG_647;
    volatile Uint32 VECTOR_ADDRESS_REG_648;
    volatile Uint32 VECTOR_ADDRESS_REG_649;
    volatile Uint32 VECTOR_ADDRESS_REG_650;
    volatile Uint32 VECTOR_ADDRESS_REG_651;
    volatile Uint32 VECTOR_ADDRESS_REG_652;
    volatile Uint32 VECTOR_ADDRESS_REG_653;
    volatile Uint32 VECTOR_ADDRESS_REG_654;
    volatile Uint32 VECTOR_ADDRESS_REG_655;
    volatile Uint32 VECTOR_ADDRESS_REG_656;
    volatile Uint32 VECTOR_ADDRESS_REG_657;
    volatile Uint32 VECTOR_ADDRESS_REG_658;
    volatile Uint32 VECTOR_ADDRESS_REG_659;
    volatile Uint32 VECTOR_ADDRESS_REG_660;
    volatile Uint32 VECTOR_ADDRESS_REG_661;
    volatile Uint32 VECTOR_ADDRESS_REG_662;
    volatile Uint32 VECTOR_ADDRESS_REG_663;
    volatile Uint32 VECTOR_ADDRESS_REG_664;
    volatile Uint32 VECTOR_ADDRESS_REG_665;
    volatile Uint32 VECTOR_ADDRESS_REG_666;
    volatile Uint32 VECTOR_ADDRESS_REG_667;
    volatile Uint32 VECTOR_ADDRESS_REG_668;
    volatile Uint32 VECTOR_ADDRESS_REG_669;
    volatile Uint32 VECTOR_ADDRESS_REG_670;
    volatile Uint32 VECTOR_ADDRESS_REG_671;
    volatile Uint32 VECTOR_ADDRESS_REG_672;
    volatile Uint32 VECTOR_ADDRESS_REG_673;
    volatile Uint32 VECTOR_ADDRESS_REG_674;
    volatile Uint32 VECTOR_ADDRESS_REG_675;
    volatile Uint32 VECTOR_ADDRESS_REG_676;
    volatile Uint32 VECTOR_ADDRESS_REG_677;
    volatile Uint32 VECTOR_ADDRESS_REG_678;
    volatile Uint32 VECTOR_ADDRESS_REG_679;
    volatile Uint32 VECTOR_ADDRESS_REG_680;
    volatile Uint32 VECTOR_ADDRESS_REG_681;
    volatile Uint32 VECTOR_ADDRESS_REG_682;
    volatile Uint32 VECTOR_ADDRESS_REG_683;
    volatile Uint32 VECTOR_ADDRESS_REG_684;
    volatile Uint32 VECTOR_ADDRESS_REG_685;
    volatile Uint32 VECTOR_ADDRESS_REG_686;
    volatile Uint32 VECTOR_ADDRESS_REG_687;
    volatile Uint32 VECTOR_ADDRESS_REG_688;
    volatile Uint32 VECTOR_ADDRESS_REG_689;
    volatile Uint32 VECTOR_ADDRESS_REG_690;
    volatile Uint32 VECTOR_ADDRESS_REG_691;
    volatile Uint32 VECTOR_ADDRESS_REG_692;
    volatile Uint32 VECTOR_ADDRESS_REG_693;
    volatile Uint32 VECTOR_ADDRESS_REG_694;
    volatile Uint32 VECTOR_ADDRESS_REG_695;
    volatile Uint32 VECTOR_ADDRESS_REG_696;
    volatile Uint32 VECTOR_ADDRESS_REG_697;
    volatile Uint32 VECTOR_ADDRESS_REG_698;
    volatile Uint32 VECTOR_ADDRESS_REG_699;
    volatile Uint32 VECTOR_ADDRESS_REG_700;
    volatile Uint32 VECTOR_ADDRESS_REG_701;
    volatile Uint32 VECTOR_ADDRESS_REG_702;
    volatile Uint32 VECTOR_ADDRESS_REG_703;
    volatile Uint32 VECTOR_ADDRESS_REG_704;
    volatile Uint32 VECTOR_ADDRESS_REG_705;
    volatile Uint32 VECTOR_ADDRESS_REG_706;
    volatile Uint32 VECTOR_ADDRESS_REG_707;
    volatile Uint32 VECTOR_ADDRESS_REG_708;
    volatile Uint32 VECTOR_ADDRESS_REG_709;
    volatile Uint32 VECTOR_ADDRESS_REG_710;
    volatile Uint32 VECTOR_ADDRESS_REG_711;
    volatile Uint32 VECTOR_ADDRESS_REG_712;
    volatile Uint32 VECTOR_ADDRESS_REG_713;
    volatile Uint32 VECTOR_ADDRESS_REG_714;
    volatile Uint32 VECTOR_ADDRESS_REG_715;
    volatile Uint32 VECTOR_ADDRESS_REG_716;
    volatile Uint32 VECTOR_ADDRESS_REG_717;
    volatile Uint32 VECTOR_ADDRESS_REG_718;
    volatile Uint32 VECTOR_ADDRESS_REG_719;
    volatile Uint32 VECTOR_ADDRESS_REG_720;
    volatile Uint32 VECTOR_ADDRESS_REG_721;
    volatile Uint32 VECTOR_ADDRESS_REG_722;
    volatile Uint32 VECTOR_ADDRESS_REG_723;
    volatile Uint32 VECTOR_ADDRESS_REG_724;
    volatile Uint32 VECTOR_ADDRESS_REG_725;
    volatile Uint32 VECTOR_ADDRESS_REG_726;
    volatile Uint32 VECTOR_ADDRESS_REG_727;
    volatile Uint32 VECTOR_ADDRESS_REG_728;
    volatile Uint32 VECTOR_ADDRESS_REG_729;
    volatile Uint32 VECTOR_ADDRESS_REG_730;
    volatile Uint32 VECTOR_ADDRESS_REG_731;
    volatile Uint32 VECTOR_ADDRESS_REG_732;
    volatile Uint32 VECTOR_ADDRESS_REG_733;
    volatile Uint32 VECTOR_ADDRESS_REG_734;
    volatile Uint32 VECTOR_ADDRESS_REG_735;
    volatile Uint32 VECTOR_ADDRESS_REG_736;
    volatile Uint32 VECTOR_ADDRESS_REG_737;
    volatile Uint32 VECTOR_ADDRESS_REG_738;
    volatile Uint32 VECTOR_ADDRESS_REG_739;
    volatile Uint32 VECTOR_ADDRESS_REG_740;
    volatile Uint32 VECTOR_ADDRESS_REG_741;
    volatile Uint32 VECTOR_ADDRESS_REG_742;
    volatile Uint32 VECTOR_ADDRESS_REG_743;
    volatile Uint32 VECTOR_ADDRESS_REG_744;
    volatile Uint32 VECTOR_ADDRESS_REG_745;
    volatile Uint32 VECTOR_ADDRESS_REG_746;
    volatile Uint32 VECTOR_ADDRESS_REG_747;
    volatile Uint32 VECTOR_ADDRESS_REG_748;
    volatile Uint32 VECTOR_ADDRESS_REG_749;
    volatile Uint32 VECTOR_ADDRESS_REG_750;
    volatile Uint32 VECTOR_ADDRESS_REG_751;
    volatile Uint32 VECTOR_ADDRESS_REG_752;
    volatile Uint32 VECTOR_ADDRESS_REG_753;
    volatile Uint32 VECTOR_ADDRESS_REG_754;
    volatile Uint32 VECTOR_ADDRESS_REG_755;
    volatile Uint32 VECTOR_ADDRESS_REG_756;
    volatile Uint32 VECTOR_ADDRESS_REG_757;
    volatile Uint32 VECTOR_ADDRESS_REG_758;
    volatile Uint32 VECTOR_ADDRESS_REG_759;
    volatile Uint32 VECTOR_ADDRESS_REG_760;
    volatile Uint32 VECTOR_ADDRESS_REG_761;
    volatile Uint32 VECTOR_ADDRESS_REG_762;
    volatile Uint32 VECTOR_ADDRESS_REG_763;
    volatile Uint32 VECTOR_ADDRESS_REG_764;
    volatile Uint32 VECTOR_ADDRESS_REG_765;
    volatile Uint32 VECTOR_ADDRESS_REG_766;
    volatile Uint32 VECTOR_ADDRESS_REG_767;
    volatile Uint32 VECTOR_ADDRESS_REG_768;
    volatile Uint32 VECTOR_ADDRESS_REG_769;
    volatile Uint32 VECTOR_ADDRESS_REG_770;
    volatile Uint32 VECTOR_ADDRESS_REG_771;
    volatile Uint32 VECTOR_ADDRESS_REG_772;
    volatile Uint32 VECTOR_ADDRESS_REG_773;
    volatile Uint32 VECTOR_ADDRESS_REG_774;
    volatile Uint32 VECTOR_ADDRESS_REG_775;
    volatile Uint32 VECTOR_ADDRESS_REG_776;
    volatile Uint32 VECTOR_ADDRESS_REG_777;
    volatile Uint32 VECTOR_ADDRESS_REG_778;
    volatile Uint32 VECTOR_ADDRESS_REG_779;
    volatile Uint32 VECTOR_ADDRESS_REG_780;
    volatile Uint32 VECTOR_ADDRESS_REG_781;
    volatile Uint32 VECTOR_ADDRESS_REG_782;
    volatile Uint32 VECTOR_ADDRESS_REG_783;
    volatile Uint32 VECTOR_ADDRESS_REG_784;
    volatile Uint32 VECTOR_ADDRESS_REG_785;
    volatile Uint32 VECTOR_ADDRESS_REG_786;
    volatile Uint32 VECTOR_ADDRESS_REG_787;
    volatile Uint32 VECTOR_ADDRESS_REG_788;
    volatile Uint32 VECTOR_ADDRESS_REG_789;
    volatile Uint32 VECTOR_ADDRESS_REG_790;
    volatile Uint32 VECTOR_ADDRESS_REG_791;
    volatile Uint32 VECTOR_ADDRESS_REG_792;
    volatile Uint32 VECTOR_ADDRESS_REG_793;
    volatile Uint32 VECTOR_ADDRESS_REG_794;
    volatile Uint32 VECTOR_ADDRESS_REG_795;
    volatile Uint32 VECTOR_ADDRESS_REG_796;
    volatile Uint32 VECTOR_ADDRESS_REG_797;
    volatile Uint32 VECTOR_ADDRESS_REG_798;
    volatile Uint32 VECTOR_ADDRESS_REG_799;
    volatile Uint32 VECTOR_ADDRESS_REG_800;
    volatile Uint32 VECTOR_ADDRESS_REG_801;
    volatile Uint32 VECTOR_ADDRESS_REG_802;
    volatile Uint32 VECTOR_ADDRESS_REG_803;
    volatile Uint32 VECTOR_ADDRESS_REG_804;
    volatile Uint32 VECTOR_ADDRESS_REG_805;
    volatile Uint32 VECTOR_ADDRESS_REG_806;
    volatile Uint32 VECTOR_ADDRESS_REG_807;
    volatile Uint32 VECTOR_ADDRESS_REG_808;
    volatile Uint32 VECTOR_ADDRESS_REG_809;
    volatile Uint32 VECTOR_ADDRESS_REG_810;
    volatile Uint32 VECTOR_ADDRESS_REG_811;
    volatile Uint32 VECTOR_ADDRESS_REG_812;
    volatile Uint32 VECTOR_ADDRESS_REG_813;
    volatile Uint32 VECTOR_ADDRESS_REG_814;
    volatile Uint32 VECTOR_ADDRESS_REG_815;
    volatile Uint32 VECTOR_ADDRESS_REG_816;
    volatile Uint32 VECTOR_ADDRESS_REG_817;
    volatile Uint32 VECTOR_ADDRESS_REG_818;
    volatile Uint32 VECTOR_ADDRESS_REG_819;
    volatile Uint32 VECTOR_ADDRESS_REG_820;
    volatile Uint32 VECTOR_ADDRESS_REG_821;
    volatile Uint32 VECTOR_ADDRESS_REG_822;
    volatile Uint32 VECTOR_ADDRESS_REG_823;
    volatile Uint32 VECTOR_ADDRESS_REG_824;
    volatile Uint32 VECTOR_ADDRESS_REG_825;
    volatile Uint32 VECTOR_ADDRESS_REG_826;
    volatile Uint32 VECTOR_ADDRESS_REG_827;
    volatile Uint32 VECTOR_ADDRESS_REG_828;
    volatile Uint32 VECTOR_ADDRESS_REG_829;
    volatile Uint32 VECTOR_ADDRESS_REG_830;
    volatile Uint32 VECTOR_ADDRESS_REG_831;
    volatile Uint32 VECTOR_ADDRESS_REG_832;
    volatile Uint32 VECTOR_ADDRESS_REG_833;
    volatile Uint32 VECTOR_ADDRESS_REG_834;
    volatile Uint32 VECTOR_ADDRESS_REG_835;
    volatile Uint32 VECTOR_ADDRESS_REG_836;
    volatile Uint32 VECTOR_ADDRESS_REG_837;
    volatile Uint32 VECTOR_ADDRESS_REG_838;
    volatile Uint32 VECTOR_ADDRESS_REG_839;
    volatile Uint32 VECTOR_ADDRESS_REG_840;
    volatile Uint32 VECTOR_ADDRESS_REG_841;
    volatile Uint32 VECTOR_ADDRESS_REG_842;
    volatile Uint32 VECTOR_ADDRESS_REG_843;
    volatile Uint32 VECTOR_ADDRESS_REG_844;
    volatile Uint32 VECTOR_ADDRESS_REG_845;
    volatile Uint32 VECTOR_ADDRESS_REG_846;
    volatile Uint32 VECTOR_ADDRESS_REG_847;
    volatile Uint32 VECTOR_ADDRESS_REG_848;
    volatile Uint32 VECTOR_ADDRESS_REG_849;
    volatile Uint32 VECTOR_ADDRESS_REG_850;
    volatile Uint32 VECTOR_ADDRESS_REG_851;
    volatile Uint32 VECTOR_ADDRESS_REG_852;
    volatile Uint32 VECTOR_ADDRESS_REG_853;
    volatile Uint32 VECTOR_ADDRESS_REG_854;
    volatile Uint32 VECTOR_ADDRESS_REG_855;
    volatile Uint32 VECTOR_ADDRESS_REG_856;
    volatile Uint32 VECTOR_ADDRESS_REG_857;
    volatile Uint32 VECTOR_ADDRESS_REG_858;
    volatile Uint32 VECTOR_ADDRESS_REG_859;
    volatile Uint32 VECTOR_ADDRESS_REG_860;
    volatile Uint32 VECTOR_ADDRESS_REG_861;
    volatile Uint32 VECTOR_ADDRESS_REG_862;
    volatile Uint32 VECTOR_ADDRESS_REG_863;
    volatile Uint32 VECTOR_ADDRESS_REG_864;
    volatile Uint32 VECTOR_ADDRESS_REG_865;
    volatile Uint32 VECTOR_ADDRESS_REG_866;
    volatile Uint32 VECTOR_ADDRESS_REG_867;
    volatile Uint32 VECTOR_ADDRESS_REG_868;
    volatile Uint32 VECTOR_ADDRESS_REG_869;
    volatile Uint32 VECTOR_ADDRESS_REG_870;
    volatile Uint32 VECTOR_ADDRESS_REG_871;
    volatile Uint32 VECTOR_ADDRESS_REG_872;
    volatile Uint32 VECTOR_ADDRESS_REG_873;
    volatile Uint32 VECTOR_ADDRESS_REG_874;
    volatile Uint32 VECTOR_ADDRESS_REG_875;
    volatile Uint32 VECTOR_ADDRESS_REG_876;
    volatile Uint32 VECTOR_ADDRESS_REG_877;
    volatile Uint32 VECTOR_ADDRESS_REG_878;
    volatile Uint32 VECTOR_ADDRESS_REG_879;
    volatile Uint32 VECTOR_ADDRESS_REG_880;
    volatile Uint32 VECTOR_ADDRESS_REG_881;
    volatile Uint32 VECTOR_ADDRESS_REG_882;
    volatile Uint32 VECTOR_ADDRESS_REG_883;
    volatile Uint32 VECTOR_ADDRESS_REG_884;
    volatile Uint32 VECTOR_ADDRESS_REG_885;
    volatile Uint32 VECTOR_ADDRESS_REG_886;
    volatile Uint32 VECTOR_ADDRESS_REG_887;
    volatile Uint32 VECTOR_ADDRESS_REG_888;
    volatile Uint32 VECTOR_ADDRESS_REG_889;
    volatile Uint32 VECTOR_ADDRESS_REG_890;
    volatile Uint32 VECTOR_ADDRESS_REG_891;
    volatile Uint32 VECTOR_ADDRESS_REG_892;
    volatile Uint32 VECTOR_ADDRESS_REG_893;
    volatile Uint32 VECTOR_ADDRESS_REG_894;
    volatile Uint32 VECTOR_ADDRESS_REG_895;
    volatile Uint32 VECTOR_ADDRESS_REG_896;
    volatile Uint32 VECTOR_ADDRESS_REG_897;
    volatile Uint32 VECTOR_ADDRESS_REG_898;
    volatile Uint32 VECTOR_ADDRESS_REG_899;
    volatile Uint32 VECTOR_ADDRESS_REG_900;
    volatile Uint32 VECTOR_ADDRESS_REG_901;
    volatile Uint32 VECTOR_ADDRESS_REG_902;
    volatile Uint32 VECTOR_ADDRESS_REG_903;
    volatile Uint32 VECTOR_ADDRESS_REG_904;
    volatile Uint32 VECTOR_ADDRESS_REG_905;
    volatile Uint32 VECTOR_ADDRESS_REG_906;
    volatile Uint32 VECTOR_ADDRESS_REG_907;
    volatile Uint32 VECTOR_ADDRESS_REG_908;
    volatile Uint32 VECTOR_ADDRESS_REG_909;
    volatile Uint32 VECTOR_ADDRESS_REG_910;
    volatile Uint32 VECTOR_ADDRESS_REG_911;
    volatile Uint32 VECTOR_ADDRESS_REG_912;
    volatile Uint32 VECTOR_ADDRESS_REG_913;
    volatile Uint32 VECTOR_ADDRESS_REG_914;
    volatile Uint32 VECTOR_ADDRESS_REG_915;
    volatile Uint32 VECTOR_ADDRESS_REG_916;
    volatile Uint32 VECTOR_ADDRESS_REG_917;
    volatile Uint32 VECTOR_ADDRESS_REG_918;
    volatile Uint32 VECTOR_ADDRESS_REG_919;
    volatile Uint32 VECTOR_ADDRESS_REG_920;
    volatile Uint32 VECTOR_ADDRESS_REG_921;
    volatile Uint32 VECTOR_ADDRESS_REG_922;
    volatile Uint32 VECTOR_ADDRESS_REG_923;
    volatile Uint32 VECTOR_ADDRESS_REG_924;
    volatile Uint32 VECTOR_ADDRESS_REG_925;
    volatile Uint32 VECTOR_ADDRESS_REG_926;
    volatile Uint32 VECTOR_ADDRESS_REG_927;
    volatile Uint32 VECTOR_ADDRESS_REG_928;
    volatile Uint32 VECTOR_ADDRESS_REG_929;
    volatile Uint32 VECTOR_ADDRESS_REG_930;
    volatile Uint32 VECTOR_ADDRESS_REG_931;
    volatile Uint32 VECTOR_ADDRESS_REG_932;
    volatile Uint32 VECTOR_ADDRESS_REG_933;
    volatile Uint32 VECTOR_ADDRESS_REG_934;
    volatile Uint32 VECTOR_ADDRESS_REG_935;
    volatile Uint32 VECTOR_ADDRESS_REG_936;
    volatile Uint32 VECTOR_ADDRESS_REG_937;
    volatile Uint32 VECTOR_ADDRESS_REG_938;
    volatile Uint32 VECTOR_ADDRESS_REG_939;
    volatile Uint32 VECTOR_ADDRESS_REG_940;
    volatile Uint32 VECTOR_ADDRESS_REG_941;
    volatile Uint32 VECTOR_ADDRESS_REG_942;
    volatile Uint32 VECTOR_ADDRESS_REG_943;
    volatile Uint32 VECTOR_ADDRESS_REG_944;
    volatile Uint32 VECTOR_ADDRESS_REG_945;
    volatile Uint32 VECTOR_ADDRESS_REG_946;
    volatile Uint32 VECTOR_ADDRESS_REG_947;
    volatile Uint32 VECTOR_ADDRESS_REG_948;
    volatile Uint32 VECTOR_ADDRESS_REG_949;
    volatile Uint32 VECTOR_ADDRESS_REG_950;
    volatile Uint32 VECTOR_ADDRESS_REG_951;
    volatile Uint32 VECTOR_ADDRESS_REG_952;
    volatile Uint32 VECTOR_ADDRESS_REG_953;
    volatile Uint32 VECTOR_ADDRESS_REG_954;
    volatile Uint32 VECTOR_ADDRESS_REG_955;
    volatile Uint32 VECTOR_ADDRESS_REG_956;
    volatile Uint32 VECTOR_ADDRESS_REG_957;
    volatile Uint32 VECTOR_ADDRESS_REG_958;
    volatile Uint32 VECTOR_ADDRESS_REG_959;
    volatile Uint32 VECTOR_ADDRESS_REG_960;
    volatile Uint32 VECTOR_ADDRESS_REG_961;
    volatile Uint32 VECTOR_ADDRESS_REG_962;
    volatile Uint32 VECTOR_ADDRESS_REG_963;
    volatile Uint32 VECTOR_ADDRESS_REG_964;
    volatile Uint32 VECTOR_ADDRESS_REG_965;
    volatile Uint32 VECTOR_ADDRESS_REG_966;
    volatile Uint32 VECTOR_ADDRESS_REG_967;
    volatile Uint32 VECTOR_ADDRESS_REG_968;
    volatile Uint32 VECTOR_ADDRESS_REG_969;
    volatile Uint32 VECTOR_ADDRESS_REG_970;
    volatile Uint32 VECTOR_ADDRESS_REG_971;
    volatile Uint32 VECTOR_ADDRESS_REG_972;
    volatile Uint32 VECTOR_ADDRESS_REG_973;
    volatile Uint32 VECTOR_ADDRESS_REG_974;
    volatile Uint32 VECTOR_ADDRESS_REG_975;
    volatile Uint32 VECTOR_ADDRESS_REG_976;
    volatile Uint32 VECTOR_ADDRESS_REG_977;
    volatile Uint32 VECTOR_ADDRESS_REG_978;
    volatile Uint32 VECTOR_ADDRESS_REG_979;
    volatile Uint32 VECTOR_ADDRESS_REG_980;
    volatile Uint32 VECTOR_ADDRESS_REG_981;
    volatile Uint32 VECTOR_ADDRESS_REG_982;
    volatile Uint32 VECTOR_ADDRESS_REG_983;
    volatile Uint32 VECTOR_ADDRESS_REG_984;
    volatile Uint32 VECTOR_ADDRESS_REG_985;
    volatile Uint32 VECTOR_ADDRESS_REG_986;
    volatile Uint32 VECTOR_ADDRESS_REG_987;
    volatile Uint32 VECTOR_ADDRESS_REG_988;
    volatile Uint32 VECTOR_ADDRESS_REG_989;
    volatile Uint32 VECTOR_ADDRESS_REG_990;
    volatile Uint32 VECTOR_ADDRESS_REG_991;
    volatile Uint32 VECTOR_ADDRESS_REG_992;
    volatile Uint32 VECTOR_ADDRESS_REG_993;
    volatile Uint32 VECTOR_ADDRESS_REG_994;
    volatile Uint32 VECTOR_ADDRESS_REG_995;
    volatile Uint32 VECTOR_ADDRESS_REG_996;
    volatile Uint32 VECTOR_ADDRESS_REG_997;
    volatile Uint32 VECTOR_ADDRESS_REG_998;
    volatile Uint32 VECTOR_ADDRESS_REG_999;
    volatile Uint32 VECTOR_ADDRESS_REG_1000;
    volatile Uint32 VECTOR_ADDRESS_REG_1001;
    volatile Uint32 VECTOR_ADDRESS_REG_1002;
    volatile Uint32 VECTOR_ADDRESS_REG_1003;
    volatile Uint32 VECTOR_ADDRESS_REG_1004;
    volatile Uint32 VECTOR_ADDRESS_REG_1005;
    volatile Uint32 VECTOR_ADDRESS_REG_1006;
    volatile Uint32 VECTOR_ADDRESS_REG_1007;
    volatile Uint32 VECTOR_ADDRESS_REG_1008;
    volatile Uint32 VECTOR_ADDRESS_REG_1009;
    volatile Uint32 VECTOR_ADDRESS_REG_1010;
    volatile Uint32 VECTOR_ADDRESS_REG_1011;
    volatile Uint32 VECTOR_ADDRESS_REG_1012;
    volatile Uint32 VECTOR_ADDRESS_REG_1013;
    volatile Uint32 VECTOR_ADDRESS_REG_1014;
    volatile Uint32 VECTOR_ADDRESS_REG_1015;
    volatile Uint32 VECTOR_ADDRESS_REG_1016;
    volatile Uint32 VECTOR_ADDRESS_REG_1017;
    volatile Uint32 VECTOR_ADDRESS_REG_1018;
    volatile Uint32 VECTOR_ADDRESS_REG_1019;
    volatile Uint32 VECTOR_ADDRESS_REG_1020;
    volatile Uint32 VECTOR_ADDRESS_REG_1021;
    volatile Uint32 VECTOR_ADDRESS_REG_1022;
    volatile Uint32 VECTOR_ADDRESS_REG_1023;
#else
    volatile Uint32 VECTOR_ADDRESS_REG[1024];
#endif
} CSL_CPINTCRegs;

/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* revision_reg */

#define CSL_CPINTC_REVISION_REG_REV_SCHEME_MASK (0xC0000000u)
#define CSL_CPINTC_REVISION_REG_REV_SCHEME_SHIFT (0x0000001Eu)
#define CSL_CPINTC_REVISION_REG_REV_SCHEME_RESETVAL (0x00000001u)

#define CSL_CPINTC_REVISION_REG_REV_MODULE_MASK (0x0FFF0000u)
#define CSL_CPINTC_REVISION_REG_REV_MODULE_SHIFT (0x00000010u)
#define CSL_CPINTC_REVISION_REG_REV_MODULE_RESETVAL (0x00000E82u)

#define CSL_CPINTC_REVISION_REG_REV_RTL_MASK (0x0000F800u)
#define CSL_CPINTC_REVISION_REG_REV_RTL_SHIFT (0x0000000Bu)
#define CSL_CPINTC_REVISION_REG_REV_RTL_RESETVAL (0x00000015u)

#define CSL_CPINTC_REVISION_REG_REV_MAJOR_MASK (0x00000700u)
#define CSL_CPINTC_REVISION_REG_REV_MAJOR_SHIFT (0x00000008u)
#define CSL_CPINTC_REVISION_REG_REV_MAJOR_RESETVAL (0x00000001u)

#define CSL_CPINTC_REVISION_REG_REV_CUSTOM_MASK (0x000000C0u)
#define CSL_CPINTC_REVISION_REG_REV_CUSTOM_SHIFT (0x00000006u)
#define CSL_CPINTC_REVISION_REG_REV_CUSTOM_RESETVAL (0x00000000u)

#define CSL_CPINTC_REVISION_REG_REV_MINOR_MASK (0x0000003Fu)
#define CSL_CPINTC_REVISION_REG_REV_MINOR_SHIFT (0x00000000u)
#define CSL_CPINTC_REVISION_REG_REV_MINOR_RESETVAL (0x00000000u)

#define CSL_CPINTC_REVISION_REG_RESETVAL (0x4E82A900u)

/* control_reg */

#define CSL_CPINTC_CONTROL_REG_WAKEUP_MODE_MASK (0x00000002u)
#define CSL_CPINTC_CONTROL_REG_WAKEUP_MODE_SHIFT (0x00000001u)
#define CSL_CPINTC_CONTROL_REG_WAKEUP_MODE_RESETVAL (0x00000000u)

#define CSL_CPINTC_CONTROL_REG_NEST_MODE_MASK (0x0000000Cu)
#define CSL_CPINTC_CONTROL_REG_NEST_MODE_SHIFT (0x00000002u)
#define CSL_CPINTC_CONTROL_REG_NEST_MODE_RESETVAL (0x00000000u)

#define CSL_CPINTC_CONTROL_REG_PRIORITY_HOLD_MODE_MASK (0x00000010u)
#define CSL_CPINTC_CONTROL_REG_PRIORITY_HOLD_MODE_SHIFT (0x00000004u)
#define CSL_CPINTC_CONTROL_REG_PRIORITY_HOLD_MODE_RESETVAL (0x00000000u)

#define CSL_CPINTC_CONTROL_REG_RESETVAL  (0x00000000u)

/* host_control_reg */

#define CSL_CPINTC_HOST_CONTROL_REG_HOST_CONTROL_REG_MASK (0xFFFFFFFFu)
#define CSL_CPINTC_HOST_CONTROL_REG_HOST_CONTROL_REG_SHIFT (0x00000000u)
#define CSL_CPINTC_HOST_CONTROL_REG_HOST_CONTROL_REG_RESETVAL (0x00000000u)

#define CSL_CPINTC_HOST_CONTROL_REG_RESETVAL (0x00000000u)

/* global_enable_hint_reg */

#define CSL_CPINTC_GLOBAL_ENABLE_HINT_REG_ENABLE_HINT_ANY_MASK (0x00000001u)
#define CSL_CPINTC_GLOBAL_ENABLE_HINT_REG_ENABLE_HINT_ANY_SHIFT (0x00000000u)
#define CSL_CPINTC_GLOBAL_ENABLE_HINT_REG_ENABLE_HINT_ANY_RESETVAL (0x00000000u)

#define CSL_CPINTC_GLOBAL_ENABLE_HINT_REG_RESETVAL (0x00000000u)

/* glb_nest_level_reg */

#define CSL_CPINTC_GLB_NEST_LEVEL_REG_GLB_NEST_LEVEL_MASK (0x000001FFu)
#define CSL_CPINTC_GLB_NEST_LEVEL_REG_GLB_NEST_LEVEL_SHIFT (0x00000000u)
#define CSL_CPINTC_GLB_NEST_LEVEL_REG_GLB_NEST_LEVEL_RESETVAL (0x00000100u)

#define CSL_CPINTC_GLB_NEST_LEVEL_REG_RESETVAL (0x00000100u)

/* status_set_index_reg */

#define CSL_CPINTC_STATUS_SET_INDEX_REG_STATUS_SET_INDEX_MASK (0x000003FFu)
#define CSL_CPINTC_STATUS_SET_INDEX_REG_STATUS_SET_INDEX_SHIFT (0x00000000u)
#define CSL_CPINTC_STATUS_SET_INDEX_REG_STATUS_SET_INDEX_RESETVAL (0x00000000u)

#define CSL_CPINTC_STATUS_SET_INDEX_REG_RESETVAL (0x00000000u)

/* status_clr_index_reg */

#define CSL_CPINTC_STATUS_CLR_INDEX_REG_STATUS_CLR_INDEX_MASK (0x000003FFu)
#define CSL_CPINTC_STATUS_CLR_INDEX_REG_STATUS_CLR_INDEX_SHIFT (0x00000000u)
#define CSL_CPINTC_STATUS_CLR_INDEX_REG_STATUS_CLR_INDEX_RESETVAL (0x00000000u)

#define CSL_CPINTC_STATUS_CLR_INDEX_REG_RESETVAL (0x00000000u)

/* enable_set_index_reg */

#define CSL_CPINTC_ENABLE_SET_INDEX_REG_ENABLE_SET_INDEX_MASK (0x000003FFu)
#define CSL_CPINTC_ENABLE_SET_INDEX_REG_ENABLE_SET_INDEX_SHIFT (0x00000000u)
#define CSL_CPINTC_ENABLE_SET_INDEX_REG_ENABLE_SET_INDEX_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_SET_INDEX_REG_RESETVAL (0x00000000u)

/* enable_clr_index_reg */

#define CSL_CPINTC_ENABLE_CLR_INDEX_REG_ENABLE_CLR_INDEX_MASK (0x000003FFu)
#define CSL_CPINTC_ENABLE_CLR_INDEX_REG_ENABLE_CLR_INDEX_SHIFT (0x00000000u)
#define CSL_CPINTC_ENABLE_CLR_INDEX_REG_ENABLE_CLR_INDEX_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_INDEX_REG_RESETVAL (0x00000000u)

/* hint_enable_set_index_reg */

#define CSL_CPINTC_HINT_ENABLE_SET_INDEX_REG_HINT_ENABLE_SET_INDEX_MASK (0x000000FFu)
#define CSL_CPINTC_HINT_ENABLE_SET_INDEX_REG_HINT_ENABLE_SET_INDEX_SHIFT (0x00000000u)
#define CSL_CPINTC_HINT_ENABLE_SET_INDEX_REG_HINT_ENABLE_SET_INDEX_RESETVAL (0x00000000u)

#define CSL_CPINTC_HINT_ENABLE_SET_INDEX_REG_RESETVAL (0x00000000u)

/* hint_enable_clr_index_reg */

#define CSL_CPINTC_HINT_ENABLE_CLR_INDEX_REG_HINT_ENABLE_CLR_INDEX_MASK (0x000000FFu)
#define CSL_CPINTC_HINT_ENABLE_CLR_INDEX_REG_HINT_ENABLE_CLR_INDEX_SHIFT (0x00000000u)
#define CSL_CPINTC_HINT_ENABLE_CLR_INDEX_REG_HINT_ENABLE_CLR_INDEX_RESETVAL (0x00000000u)

#define CSL_CPINTC_HINT_ENABLE_CLR_INDEX_REG_RESETVAL (0x00000000u)

/* vector_null_reg */

#define CSL_CPINTC_VECTOR_NULL_REG_VECTOR_NULL_ADDR_MASK (0xFFFFFFFFu)
#define CSL_CPINTC_VECTOR_NULL_REG_VECTOR_NULL_ADDR_SHIFT (0x00000000u)
#define CSL_CPINTC_VECTOR_NULL_REG_VECTOR_NULL_ADDR_RESETVAL (0x00000000u)

#define CSL_CPINTC_VECTOR_NULL_REG_RESETVAL (0x00000000u)

/* glb_pri_intr_reg */

#define CSL_CPINTC_GLB_PRI_INTR_REG_GLB_PRI_INTR_MASK (0x000003FFu)
#define CSL_CPINTC_GLB_PRI_INTR_REG_GLB_PRI_INTR_SHIFT (0x00000000u)
#define CSL_CPINTC_GLB_PRI_INTR_REG_GLB_PRI_INTR_RESETVAL (0x00000000u)

#define CSL_CPINTC_GLB_PRI_INTR_REG_GLB_NONE_MASK (0x80000000u)
#define CSL_CPINTC_GLB_PRI_INTR_REG_GLB_NONE_SHIFT (0x0000001Fu)
#define CSL_CPINTC_GLB_PRI_INTR_REG_GLB_NONE_RESETVAL (0x00000001u)

#define CSL_CPINTC_GLB_PRI_INTR_REG_RESETVAL (0x80000000u)

/* glb_vector_addr_reg */

#define CSL_CPINTC_GLB_VECTOR_ADDR_REG_GLB_VECTOR_ADDR_MASK (0xFFFFFFFFu)
#define CSL_CPINTC_GLB_VECTOR_ADDR_REG_GLB_VECTOR_ADDR_SHIFT (0x00000000u)
#define CSL_CPINTC_GLB_VECTOR_ADDR_REG_GLB_VECTOR_ADDR_RESETVAL (0x00000000u)

#define CSL_CPINTC_GLB_VECTOR_ADDR_REG_RESETVAL (0x00000000u)

/* global_secure_enable_reg */

#define CSL_CPINTC_GLOBAL_SECURE_ENABLE_REG_SEC_ENABLE_ANY_MASK (0x00000001u)
#define CSL_CPINTC_GLOBAL_SECURE_ENABLE_REG_SEC_ENABLE_ANY_SHIFT (0x00000000u)
#define CSL_CPINTC_GLOBAL_SECURE_ENABLE_REG_SEC_ENABLE_ANY_RESETVAL (0x00000000u)

#define CSL_CPINTC_GLOBAL_SECURE_ENABLE_REG_SECURE_ADV_EN_MASK (0x00000002u)
#define CSL_CPINTC_GLOBAL_SECURE_ENABLE_REG_SECURE_ADV_EN_SHIFT (0x00000001u)
#define CSL_CPINTC_GLOBAL_SECURE_ENABLE_REG_SECURE_ADV_EN_RESETVAL (0x00000000u)

#define CSL_CPINTC_GLOBAL_SECURE_ENABLE_REG_RESETVAL (0x00000000u)

/* secure_pri_intr_reg */

#define CSL_CPINTC_SECURE_PRI_INTR_REG_SEC_PRI_INTR_MASK (0x000003FFu)
#define CSL_CPINTC_SECURE_PRI_INTR_REG_SEC_PRI_INTR_SHIFT (0x00000000u)
#define CSL_CPINTC_SECURE_PRI_INTR_REG_SEC_PRI_INTR_RESETVAL (0x00000000u)

#define CSL_CPINTC_SECURE_PRI_INTR_REG_SEC_PRI_NONE_MASK (0x80000000u)
#define CSL_CPINTC_SECURE_PRI_INTR_REG_SEC_PRI_NONE_SHIFT (0x0000001Fu)
#define CSL_CPINTC_SECURE_PRI_INTR_REG_SEC_PRI_NONE_RESETVAL (0x00000000u)

#define CSL_CPINTC_SECURE_PRI_INTR_REG_RESETVAL (0x00000000u)

/* raw_status_reg0 */

#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_0_MASK (0x00000001u)
#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_0_SHIFT (0x00000000u)
#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_0_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_1_MASK (0x00000002u)
#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_1_SHIFT (0x00000001u)
#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_1_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_2_MASK (0x00000004u)
#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_2_SHIFT (0x00000002u)
#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_2_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_3_MASK (0x00000008u)
#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_3_SHIFT (0x00000003u)
#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_3_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_4_MASK (0x00000010u)
#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_4_SHIFT (0x00000004u)
#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_4_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_5_MASK (0x00000020u)
#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_5_SHIFT (0x00000005u)
#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_5_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_6_MASK (0x00000040u)
#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_6_SHIFT (0x00000006u)
#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_6_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_7_MASK (0x00000080u)
#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_7_SHIFT (0x00000007u)
#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_7_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_8_MASK (0x00000100u)
#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_8_SHIFT (0x00000008u)
#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_8_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_9_MASK (0x00000200u)
#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_9_SHIFT (0x00000009u)
#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_9_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_10_MASK (0x00000400u)
#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_10_SHIFT (0x0000000Au)
#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_10_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_11_MASK (0x00000800u)
#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_11_SHIFT (0x0000000Bu)
#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_11_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_12_MASK (0x00001000u)
#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_12_SHIFT (0x0000000Cu)
#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_12_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_13_MASK (0x00002000u)
#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_13_SHIFT (0x0000000Du)
#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_13_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_14_MASK (0x00004000u)
#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_14_SHIFT (0x0000000Eu)
#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_14_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_15_MASK (0x00008000u)
#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_15_SHIFT (0x0000000Fu)
#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_15_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_16_MASK (0x00010000u)
#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_16_SHIFT (0x00000010u)
#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_16_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_17_MASK (0x00020000u)
#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_17_SHIFT (0x00000011u)
#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_17_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_18_MASK (0x00040000u)
#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_18_SHIFT (0x00000012u)
#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_18_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_19_MASK (0x00080000u)
#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_19_SHIFT (0x00000013u)
#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_19_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_20_MASK (0x00100000u)
#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_20_SHIFT (0x00000014u)
#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_20_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_21_MASK (0x00200000u)
#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_21_SHIFT (0x00000015u)
#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_21_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_22_MASK (0x00400000u)
#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_22_SHIFT (0x00000016u)
#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_22_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_23_MASK (0x00800000u)
#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_23_SHIFT (0x00000017u)
#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_23_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_24_MASK (0x01000000u)
#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_24_SHIFT (0x00000018u)
#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_24_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_25_MASK (0x02000000u)
#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_25_SHIFT (0x00000019u)
#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_25_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_26_MASK (0x04000000u)
#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_26_SHIFT (0x0000001Au)
#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_26_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_27_MASK (0x08000000u)
#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_27_SHIFT (0x0000001Bu)
#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_27_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_28_MASK (0x10000000u)
#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_28_SHIFT (0x0000001Cu)
#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_28_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_29_MASK (0x20000000u)
#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_29_SHIFT (0x0000001Du)
#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_29_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_30_MASK (0x40000000u)
#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_30_SHIFT (0x0000001Eu)
#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_30_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_31_MASK (0x80000000u)
#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_31_SHIFT (0x0000001Fu)
#define CSL_CPINTC_RAW_STATUS_REG0_RAW_STATUS_31_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG0_RESETVAL (0x00000000u)

/* raw_status_reg1 */

#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_32_MASK (0x00000001u)
#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_32_SHIFT (0x00000000u)
#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_32_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_33_MASK (0x00000002u)
#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_33_SHIFT (0x00000001u)
#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_33_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_34_MASK (0x00000004u)
#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_34_SHIFT (0x00000002u)
#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_34_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_35_MASK (0x00000008u)
#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_35_SHIFT (0x00000003u)
#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_35_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_36_MASK (0x00000010u)
#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_36_SHIFT (0x00000004u)
#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_36_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_37_MASK (0x00000020u)
#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_37_SHIFT (0x00000005u)
#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_37_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_38_MASK (0x00000040u)
#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_38_SHIFT (0x00000006u)
#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_38_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_39_MASK (0x00000080u)
#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_39_SHIFT (0x00000007u)
#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_39_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_40_MASK (0x00000100u)
#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_40_SHIFT (0x00000008u)
#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_40_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_41_MASK (0x00000200u)
#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_41_SHIFT (0x00000009u)
#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_41_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_42_MASK (0x00000400u)
#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_42_SHIFT (0x0000000Au)
#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_42_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_43_MASK (0x00000800u)
#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_43_SHIFT (0x0000000Bu)
#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_43_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_44_MASK (0x00001000u)
#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_44_SHIFT (0x0000000Cu)
#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_44_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_45_MASK (0x00002000u)
#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_45_SHIFT (0x0000000Du)
#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_45_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_46_MASK (0x00004000u)
#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_46_SHIFT (0x0000000Eu)
#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_46_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_47_MASK (0x00008000u)
#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_47_SHIFT (0x0000000Fu)
#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_47_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_48_MASK (0x00010000u)
#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_48_SHIFT (0x00000010u)
#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_48_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_49_MASK (0x00020000u)
#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_49_SHIFT (0x00000011u)
#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_49_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_50_MASK (0x00040000u)
#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_50_SHIFT (0x00000012u)
#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_50_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_51_MASK (0x00080000u)
#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_51_SHIFT (0x00000013u)
#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_51_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_52_MASK (0x00100000u)
#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_52_SHIFT (0x00000014u)
#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_52_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_53_MASK (0x00200000u)
#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_53_SHIFT (0x00000015u)
#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_53_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_54_MASK (0x00400000u)
#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_54_SHIFT (0x00000016u)
#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_54_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_55_MASK (0x00800000u)
#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_55_SHIFT (0x00000017u)
#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_55_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_56_MASK (0x01000000u)
#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_56_SHIFT (0x00000018u)
#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_56_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_57_MASK (0x02000000u)
#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_57_SHIFT (0x00000019u)
#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_57_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_58_MASK (0x04000000u)
#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_58_SHIFT (0x0000001Au)
#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_58_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_59_MASK (0x08000000u)
#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_59_SHIFT (0x0000001Bu)
#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_59_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_60_MASK (0x10000000u)
#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_60_SHIFT (0x0000001Cu)
#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_60_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_61_MASK (0x20000000u)
#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_61_SHIFT (0x0000001Du)
#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_61_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_62_MASK (0x40000000u)
#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_62_SHIFT (0x0000001Eu)
#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_62_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_63_MASK (0x80000000u)
#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_63_SHIFT (0x0000001Fu)
#define CSL_CPINTC_RAW_STATUS_REG1_RAW_STATUS_63_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG1_RESETVAL (0x00000000u)

/* raw_status_reg2 */

#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_64_MASK (0x00000001u)
#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_64_SHIFT (0x00000000u)
#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_64_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_65_MASK (0x00000002u)
#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_65_SHIFT (0x00000001u)
#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_65_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_66_MASK (0x00000004u)
#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_66_SHIFT (0x00000002u)
#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_66_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_67_MASK (0x00000008u)
#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_67_SHIFT (0x00000003u)
#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_67_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_68_MASK (0x00000010u)
#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_68_SHIFT (0x00000004u)
#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_68_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_69_MASK (0x00000020u)
#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_69_SHIFT (0x00000005u)
#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_69_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_70_MASK (0x00000040u)
#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_70_SHIFT (0x00000006u)
#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_70_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_71_MASK (0x00000080u)
#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_71_SHIFT (0x00000007u)
#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_71_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_72_MASK (0x00000100u)
#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_72_SHIFT (0x00000008u)
#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_72_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_73_MASK (0x00000200u)
#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_73_SHIFT (0x00000009u)
#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_73_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_74_MASK (0x00000400u)
#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_74_SHIFT (0x0000000Au)
#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_74_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_75_MASK (0x00000800u)
#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_75_SHIFT (0x0000000Bu)
#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_75_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_76_MASK (0x00001000u)
#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_76_SHIFT (0x0000000Cu)
#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_76_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_77_MASK (0x00002000u)
#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_77_SHIFT (0x0000000Du)
#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_77_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_78_MASK (0x00004000u)
#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_78_SHIFT (0x0000000Eu)
#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_78_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_79_MASK (0x00008000u)
#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_79_SHIFT (0x0000000Fu)
#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_79_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_80_MASK (0x00010000u)
#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_80_SHIFT (0x00000010u)
#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_80_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_81_MASK (0x00020000u)
#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_81_SHIFT (0x00000011u)
#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_81_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_82_MASK (0x00040000u)
#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_82_SHIFT (0x00000012u)
#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_82_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_83_MASK (0x00080000u)
#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_83_SHIFT (0x00000013u)
#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_83_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_84_MASK (0x00100000u)
#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_84_SHIFT (0x00000014u)
#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_84_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_85_MASK (0x00200000u)
#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_85_SHIFT (0x00000015u)
#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_85_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_86_MASK (0x00400000u)
#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_86_SHIFT (0x00000016u)
#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_86_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_87_MASK (0x00800000u)
#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_87_SHIFT (0x00000017u)
#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_87_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_88_MASK (0x01000000u)
#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_88_SHIFT (0x00000018u)
#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_88_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_89_MASK (0x02000000u)
#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_89_SHIFT (0x00000019u)
#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_89_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_90_MASK (0x04000000u)
#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_90_SHIFT (0x0000001Au)
#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_90_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_91_MASK (0x08000000u)
#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_91_SHIFT (0x0000001Bu)
#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_91_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_92_MASK (0x10000000u)
#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_92_SHIFT (0x0000001Cu)
#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_92_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_93_MASK (0x20000000u)
#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_93_SHIFT (0x0000001Du)
#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_93_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_94_MASK (0x40000000u)
#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_94_SHIFT (0x0000001Eu)
#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_94_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_95_MASK (0x80000000u)
#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_95_SHIFT (0x0000001Fu)
#define CSL_CPINTC_RAW_STATUS_REG2_RAW_STATUS_95_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG2_RESETVAL (0x00000000u)

/* raw_status_reg3 */

#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_96_MASK (0x00000001u)
#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_96_SHIFT (0x00000000u)
#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_96_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_97_MASK (0x00000002u)
#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_97_SHIFT (0x00000001u)
#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_97_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_98_MASK (0x00000004u)
#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_98_SHIFT (0x00000002u)
#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_98_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_99_MASK (0x00000008u)
#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_99_SHIFT (0x00000003u)
#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_99_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_100_MASK (0x00000010u)
#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_100_SHIFT (0x00000004u)
#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_100_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_101_MASK (0x00000020u)
#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_101_SHIFT (0x00000005u)
#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_101_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_102_MASK (0x00000040u)
#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_102_SHIFT (0x00000006u)
#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_102_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_103_MASK (0x00000080u)
#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_103_SHIFT (0x00000007u)
#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_103_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_104_MASK (0x00000100u)
#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_104_SHIFT (0x00000008u)
#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_104_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_105_MASK (0x00000200u)
#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_105_SHIFT (0x00000009u)
#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_105_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_106_MASK (0x00000400u)
#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_106_SHIFT (0x0000000Au)
#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_106_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_107_MASK (0x00000800u)
#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_107_SHIFT (0x0000000Bu)
#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_107_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_108_MASK (0x00001000u)
#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_108_SHIFT (0x0000000Cu)
#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_108_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_109_MASK (0x00002000u)
#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_109_SHIFT (0x0000000Du)
#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_109_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_110_MASK (0x00004000u)
#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_110_SHIFT (0x0000000Eu)
#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_110_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_111_MASK (0x00008000u)
#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_111_SHIFT (0x0000000Fu)
#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_111_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_112_MASK (0x00010000u)
#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_112_SHIFT (0x00000010u)
#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_112_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_113_MASK (0x00020000u)
#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_113_SHIFT (0x00000011u)
#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_113_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_114_MASK (0x00040000u)
#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_114_SHIFT (0x00000012u)
#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_114_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_115_MASK (0x00080000u)
#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_115_SHIFT (0x00000013u)
#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_115_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_116_MASK (0x00100000u)
#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_116_SHIFT (0x00000014u)
#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_116_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_117_MASK (0x00200000u)
#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_117_SHIFT (0x00000015u)
#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_117_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_118_MASK (0x00400000u)
#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_118_SHIFT (0x00000016u)
#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_118_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_119_MASK (0x00800000u)
#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_119_SHIFT (0x00000017u)
#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_119_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_120_MASK (0x01000000u)
#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_120_SHIFT (0x00000018u)
#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_120_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_121_MASK (0x02000000u)
#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_121_SHIFT (0x00000019u)
#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_121_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_122_MASK (0x04000000u)
#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_122_SHIFT (0x0000001Au)
#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_122_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_123_MASK (0x08000000u)
#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_123_SHIFT (0x0000001Bu)
#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_123_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_124_MASK (0x10000000u)
#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_124_SHIFT (0x0000001Cu)
#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_124_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_125_MASK (0x20000000u)
#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_125_SHIFT (0x0000001Du)
#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_125_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_126_MASK (0x40000000u)
#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_126_SHIFT (0x0000001Eu)
#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_126_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_127_MASK (0x80000000u)
#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_127_SHIFT (0x0000001Fu)
#define CSL_CPINTC_RAW_STATUS_REG3_RAW_STATUS_127_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG3_RESETVAL (0x00000000u)

/* raw_status_reg4 */

#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_128_MASK (0x00000001u)
#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_128_SHIFT (0x00000000u)
#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_128_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_129_MASK (0x00000002u)
#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_129_SHIFT (0x00000001u)
#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_129_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_130_MASK (0x00000004u)
#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_130_SHIFT (0x00000002u)
#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_130_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_131_MASK (0x00000008u)
#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_131_SHIFT (0x00000003u)
#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_131_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_132_MASK (0x00000010u)
#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_132_SHIFT (0x00000004u)
#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_132_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_133_MASK (0x00000020u)
#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_133_SHIFT (0x00000005u)
#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_133_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_134_MASK (0x00000040u)
#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_134_SHIFT (0x00000006u)
#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_134_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_135_MASK (0x00000080u)
#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_135_SHIFT (0x00000007u)
#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_135_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_136_MASK (0x00000100u)
#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_136_SHIFT (0x00000008u)
#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_136_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_137_MASK (0x00000200u)
#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_137_SHIFT (0x00000009u)
#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_137_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_138_MASK (0x00000400u)
#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_138_SHIFT (0x0000000Au)
#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_138_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_139_MASK (0x00000800u)
#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_139_SHIFT (0x0000000Bu)
#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_139_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_140_MASK (0x00001000u)
#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_140_SHIFT (0x0000000Cu)
#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_140_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_141_MASK (0x00002000u)
#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_141_SHIFT (0x0000000Du)
#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_141_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_142_MASK (0x00004000u)
#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_142_SHIFT (0x0000000Eu)
#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_142_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_143_MASK (0x00008000u)
#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_143_SHIFT (0x0000000Fu)
#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_143_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_144_MASK (0x00010000u)
#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_144_SHIFT (0x00000010u)
#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_144_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_145_MASK (0x00020000u)
#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_145_SHIFT (0x00000011u)
#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_145_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_146_MASK (0x00040000u)
#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_146_SHIFT (0x00000012u)
#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_146_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_147_MASK (0x00080000u)
#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_147_SHIFT (0x00000013u)
#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_147_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_148_MASK (0x00100000u)
#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_148_SHIFT (0x00000014u)
#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_148_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_149_MASK (0x00200000u)
#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_149_SHIFT (0x00000015u)
#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_149_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_150_MASK (0x00400000u)
#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_150_SHIFT (0x00000016u)
#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_150_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_151_MASK (0x00800000u)
#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_151_SHIFT (0x00000017u)
#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_151_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_152_MASK (0x01000000u)
#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_152_SHIFT (0x00000018u)
#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_152_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_153_MASK (0x02000000u)
#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_153_SHIFT (0x00000019u)
#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_153_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_154_MASK (0x04000000u)
#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_154_SHIFT (0x0000001Au)
#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_154_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_155_MASK (0x08000000u)
#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_155_SHIFT (0x0000001Bu)
#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_155_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_156_MASK (0x10000000u)
#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_156_SHIFT (0x0000001Cu)
#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_156_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_157_MASK (0x20000000u)
#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_157_SHIFT (0x0000001Du)
#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_157_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_158_MASK (0x40000000u)
#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_158_SHIFT (0x0000001Eu)
#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_158_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_159_MASK (0x80000000u)
#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_159_SHIFT (0x0000001Fu)
#define CSL_CPINTC_RAW_STATUS_REG4_RAW_STATUS_159_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG4_RESETVAL (0x00000000u)

/* raw_status_reg5 */

#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_160_MASK (0x00000001u)
#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_160_SHIFT (0x00000000u)
#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_160_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_161_MASK (0x00000002u)
#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_161_SHIFT (0x00000001u)
#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_161_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_162_MASK (0x00000004u)
#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_162_SHIFT (0x00000002u)
#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_162_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_163_MASK (0x00000008u)
#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_163_SHIFT (0x00000003u)
#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_163_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_164_MASK (0x00000010u)
#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_164_SHIFT (0x00000004u)
#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_164_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_165_MASK (0x00000020u)
#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_165_SHIFT (0x00000005u)
#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_165_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_166_MASK (0x00000040u)
#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_166_SHIFT (0x00000006u)
#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_166_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_167_MASK (0x00000080u)
#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_167_SHIFT (0x00000007u)
#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_167_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_168_MASK (0x00000100u)
#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_168_SHIFT (0x00000008u)
#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_168_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_169_MASK (0x00000200u)
#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_169_SHIFT (0x00000009u)
#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_169_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_170_MASK (0x00000400u)
#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_170_SHIFT (0x0000000Au)
#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_170_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_171_MASK (0x00000800u)
#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_171_SHIFT (0x0000000Bu)
#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_171_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_172_MASK (0x00001000u)
#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_172_SHIFT (0x0000000Cu)
#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_172_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_173_MASK (0x00002000u)
#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_173_SHIFT (0x0000000Du)
#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_173_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_174_MASK (0x00004000u)
#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_174_SHIFT (0x0000000Eu)
#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_174_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_175_MASK (0x00008000u)
#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_175_SHIFT (0x0000000Fu)
#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_175_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_176_MASK (0x00010000u)
#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_176_SHIFT (0x00000010u)
#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_176_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_177_MASK (0x00020000u)
#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_177_SHIFT (0x00000011u)
#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_177_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_178_MASK (0x00040000u)
#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_178_SHIFT (0x00000012u)
#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_178_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_179_MASK (0x00080000u)
#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_179_SHIFT (0x00000013u)
#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_179_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_180_MASK (0x00100000u)
#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_180_SHIFT (0x00000014u)
#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_180_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_181_MASK (0x00200000u)
#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_181_SHIFT (0x00000015u)
#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_181_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_182_MASK (0x00400000u)
#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_182_SHIFT (0x00000016u)
#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_182_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_183_MASK (0x00800000u)
#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_183_SHIFT (0x00000017u)
#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_183_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_184_MASK (0x01000000u)
#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_184_SHIFT (0x00000018u)
#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_184_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_185_MASK (0x02000000u)
#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_185_SHIFT (0x00000019u)
#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_185_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_186_MASK (0x04000000u)
#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_186_SHIFT (0x0000001Au)
#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_186_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_187_MASK (0x08000000u)
#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_187_SHIFT (0x0000001Bu)
#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_187_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_188_MASK (0x10000000u)
#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_188_SHIFT (0x0000001Cu)
#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_188_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_189_MASK (0x20000000u)
#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_189_SHIFT (0x0000001Du)
#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_189_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_190_MASK (0x40000000u)
#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_190_SHIFT (0x0000001Eu)
#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_190_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_191_MASK (0x80000000u)
#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_191_SHIFT (0x0000001Fu)
#define CSL_CPINTC_RAW_STATUS_REG5_RAW_STATUS_191_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG5_RESETVAL (0x00000000u)

/* raw_status_reg6 */

#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_192_MASK (0x00000001u)
#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_192_SHIFT (0x00000000u)
#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_192_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_193_MASK (0x00000002u)
#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_193_SHIFT (0x00000001u)
#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_193_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_194_MASK (0x00000004u)
#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_194_SHIFT (0x00000002u)
#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_194_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_195_MASK (0x00000008u)
#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_195_SHIFT (0x00000003u)
#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_195_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_196_MASK (0x00000010u)
#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_196_SHIFT (0x00000004u)
#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_196_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_197_MASK (0x00000020u)
#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_197_SHIFT (0x00000005u)
#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_197_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_198_MASK (0x00000040u)
#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_198_SHIFT (0x00000006u)
#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_198_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_199_MASK (0x00000080u)
#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_199_SHIFT (0x00000007u)
#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_199_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_200_MASK (0x00000100u)
#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_200_SHIFT (0x00000008u)
#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_200_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_201_MASK (0x00000200u)
#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_201_SHIFT (0x00000009u)
#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_201_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_202_MASK (0x00000400u)
#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_202_SHIFT (0x0000000Au)
#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_202_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_203_MASK (0x00000800u)
#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_203_SHIFT (0x0000000Bu)
#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_203_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_204_MASK (0x00001000u)
#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_204_SHIFT (0x0000000Cu)
#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_204_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_205_MASK (0x00002000u)
#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_205_SHIFT (0x0000000Du)
#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_205_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_206_MASK (0x00004000u)
#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_206_SHIFT (0x0000000Eu)
#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_206_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_207_MASK (0x00008000u)
#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_207_SHIFT (0x0000000Fu)
#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_207_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_208_MASK (0x00010000u)
#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_208_SHIFT (0x00000010u)
#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_208_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_209_MASK (0x00020000u)
#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_209_SHIFT (0x00000011u)
#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_209_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_210_MASK (0x00040000u)
#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_210_SHIFT (0x00000012u)
#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_210_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_211_MASK (0x00080000u)
#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_211_SHIFT (0x00000013u)
#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_211_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_212_MASK (0x00100000u)
#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_212_SHIFT (0x00000014u)
#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_212_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_213_MASK (0x00200000u)
#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_213_SHIFT (0x00000015u)
#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_213_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_214_MASK (0x00400000u)
#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_214_SHIFT (0x00000016u)
#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_214_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_215_MASK (0x00800000u)
#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_215_SHIFT (0x00000017u)
#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_215_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_216_MASK (0x01000000u)
#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_216_SHIFT (0x00000018u)
#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_216_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_217_MASK (0x02000000u)
#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_217_SHIFT (0x00000019u)
#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_217_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_218_MASK (0x04000000u)
#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_218_SHIFT (0x0000001Au)
#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_218_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_219_MASK (0x08000000u)
#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_219_SHIFT (0x0000001Bu)
#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_219_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_220_MASK (0x10000000u)
#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_220_SHIFT (0x0000001Cu)
#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_220_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_221_MASK (0x20000000u)
#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_221_SHIFT (0x0000001Du)
#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_221_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_222_MASK (0x40000000u)
#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_222_SHIFT (0x0000001Eu)
#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_222_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_223_MASK (0x80000000u)
#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_223_SHIFT (0x0000001Fu)
#define CSL_CPINTC_RAW_STATUS_REG6_RAW_STATUS_223_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG6_RESETVAL (0x00000000u)

/* raw_status_reg7 */

#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_224_MASK (0x00000001u)
#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_224_SHIFT (0x00000000u)
#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_224_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_225_MASK (0x00000002u)
#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_225_SHIFT (0x00000001u)
#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_225_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_226_MASK (0x00000004u)
#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_226_SHIFT (0x00000002u)
#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_226_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_227_MASK (0x00000008u)
#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_227_SHIFT (0x00000003u)
#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_227_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_228_MASK (0x00000010u)
#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_228_SHIFT (0x00000004u)
#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_228_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_229_MASK (0x00000020u)
#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_229_SHIFT (0x00000005u)
#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_229_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_230_MASK (0x00000040u)
#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_230_SHIFT (0x00000006u)
#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_230_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_231_MASK (0x00000080u)
#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_231_SHIFT (0x00000007u)
#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_231_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_232_MASK (0x00000100u)
#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_232_SHIFT (0x00000008u)
#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_232_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_233_MASK (0x00000200u)
#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_233_SHIFT (0x00000009u)
#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_233_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_234_MASK (0x00000400u)
#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_234_SHIFT (0x0000000Au)
#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_234_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_235_MASK (0x00000800u)
#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_235_SHIFT (0x0000000Bu)
#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_235_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_236_MASK (0x00001000u)
#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_236_SHIFT (0x0000000Cu)
#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_236_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_237_MASK (0x00002000u)
#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_237_SHIFT (0x0000000Du)
#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_237_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_238_MASK (0x00004000u)
#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_238_SHIFT (0x0000000Eu)
#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_238_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_239_MASK (0x00008000u)
#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_239_SHIFT (0x0000000Fu)
#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_239_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_240_MASK (0x00010000u)
#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_240_SHIFT (0x00000010u)
#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_240_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_241_MASK (0x00020000u)
#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_241_SHIFT (0x00000011u)
#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_241_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_242_MASK (0x00040000u)
#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_242_SHIFT (0x00000012u)
#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_242_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_243_MASK (0x00080000u)
#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_243_SHIFT (0x00000013u)
#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_243_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_244_MASK (0x00100000u)
#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_244_SHIFT (0x00000014u)
#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_244_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_245_MASK (0x00200000u)
#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_245_SHIFT (0x00000015u)
#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_245_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_246_MASK (0x00400000u)
#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_246_SHIFT (0x00000016u)
#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_246_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_247_MASK (0x00800000u)
#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_247_SHIFT (0x00000017u)
#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_247_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_248_MASK (0x01000000u)
#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_248_SHIFT (0x00000018u)
#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_248_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_249_MASK (0x02000000u)
#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_249_SHIFT (0x00000019u)
#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_249_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_250_MASK (0x04000000u)
#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_250_SHIFT (0x0000001Au)
#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_250_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_251_MASK (0x08000000u)
#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_251_SHIFT (0x0000001Bu)
#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_251_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_252_MASK (0x10000000u)
#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_252_SHIFT (0x0000001Cu)
#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_252_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_253_MASK (0x20000000u)
#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_253_SHIFT (0x0000001Du)
#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_253_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_254_MASK (0x40000000u)
#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_254_SHIFT (0x0000001Eu)
#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_254_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_255_MASK (0x80000000u)
#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_255_SHIFT (0x0000001Fu)
#define CSL_CPINTC_RAW_STATUS_REG7_RAW_STATUS_255_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG7_RESETVAL (0x00000000u)

/* raw_status_reg8 */

#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_256_MASK (0x00000001u)
#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_256_SHIFT (0x00000000u)
#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_256_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_257_MASK (0x00000002u)
#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_257_SHIFT (0x00000001u)
#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_257_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_258_MASK (0x00000004u)
#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_258_SHIFT (0x00000002u)
#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_258_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_259_MASK (0x00000008u)
#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_259_SHIFT (0x00000003u)
#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_259_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_260_MASK (0x00000010u)
#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_260_SHIFT (0x00000004u)
#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_260_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_261_MASK (0x00000020u)
#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_261_SHIFT (0x00000005u)
#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_261_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_262_MASK (0x00000040u)
#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_262_SHIFT (0x00000006u)
#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_262_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_263_MASK (0x00000080u)
#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_263_SHIFT (0x00000007u)
#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_263_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_264_MASK (0x00000100u)
#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_264_SHIFT (0x00000008u)
#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_264_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_265_MASK (0x00000200u)
#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_265_SHIFT (0x00000009u)
#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_265_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_266_MASK (0x00000400u)
#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_266_SHIFT (0x0000000Au)
#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_266_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_267_MASK (0x00000800u)
#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_267_SHIFT (0x0000000Bu)
#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_267_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_268_MASK (0x00001000u)
#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_268_SHIFT (0x0000000Cu)
#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_268_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_269_MASK (0x00002000u)
#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_269_SHIFT (0x0000000Du)
#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_269_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_270_MASK (0x00004000u)
#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_270_SHIFT (0x0000000Eu)
#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_270_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_271_MASK (0x00008000u)
#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_271_SHIFT (0x0000000Fu)
#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_271_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_272_MASK (0x00010000u)
#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_272_SHIFT (0x00000010u)
#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_272_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_273_MASK (0x00020000u)
#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_273_SHIFT (0x00000011u)
#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_273_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_274_MASK (0x00040000u)
#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_274_SHIFT (0x00000012u)
#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_274_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_275_MASK (0x00080000u)
#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_275_SHIFT (0x00000013u)
#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_275_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_276_MASK (0x00100000u)
#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_276_SHIFT (0x00000014u)
#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_276_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_277_MASK (0x00200000u)
#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_277_SHIFT (0x00000015u)
#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_277_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_278_MASK (0x00400000u)
#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_278_SHIFT (0x00000016u)
#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_278_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_279_MASK (0x00800000u)
#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_279_SHIFT (0x00000017u)
#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_279_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_280_MASK (0x01000000u)
#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_280_SHIFT (0x00000018u)
#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_280_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_281_MASK (0x02000000u)
#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_281_SHIFT (0x00000019u)
#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_281_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_282_MASK (0x04000000u)
#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_282_SHIFT (0x0000001Au)
#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_282_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_283_MASK (0x08000000u)
#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_283_SHIFT (0x0000001Bu)
#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_283_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_284_MASK (0x10000000u)
#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_284_SHIFT (0x0000001Cu)
#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_284_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_285_MASK (0x20000000u)
#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_285_SHIFT (0x0000001Du)
#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_285_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_286_MASK (0x40000000u)
#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_286_SHIFT (0x0000001Eu)
#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_286_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_287_MASK (0x80000000u)
#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_287_SHIFT (0x0000001Fu)
#define CSL_CPINTC_RAW_STATUS_REG8_RAW_STATUS_287_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG8_RESETVAL (0x00000000u)

/* raw_status_reg9 */

#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_288_MASK (0x00000001u)
#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_288_SHIFT (0x00000000u)
#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_288_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_289_MASK (0x00000002u)
#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_289_SHIFT (0x00000001u)
#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_289_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_290_MASK (0x00000004u)
#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_290_SHIFT (0x00000002u)
#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_290_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_291_MASK (0x00000008u)
#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_291_SHIFT (0x00000003u)
#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_291_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_292_MASK (0x00000010u)
#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_292_SHIFT (0x00000004u)
#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_292_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_293_MASK (0x00000020u)
#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_293_SHIFT (0x00000005u)
#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_293_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_294_MASK (0x00000040u)
#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_294_SHIFT (0x00000006u)
#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_294_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_295_MASK (0x00000080u)
#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_295_SHIFT (0x00000007u)
#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_295_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_296_MASK (0x00000100u)
#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_296_SHIFT (0x00000008u)
#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_296_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_297_MASK (0x00000200u)
#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_297_SHIFT (0x00000009u)
#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_297_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_298_MASK (0x00000400u)
#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_298_SHIFT (0x0000000Au)
#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_298_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_299_MASK (0x00000800u)
#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_299_SHIFT (0x0000000Bu)
#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_299_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_300_MASK (0x00001000u)
#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_300_SHIFT (0x0000000Cu)
#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_300_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_301_MASK (0x00002000u)
#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_301_SHIFT (0x0000000Du)
#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_301_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_302_MASK (0x00004000u)
#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_302_SHIFT (0x0000000Eu)
#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_302_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_303_MASK (0x00008000u)
#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_303_SHIFT (0x0000000Fu)
#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_303_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_304_MASK (0x00010000u)
#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_304_SHIFT (0x00000010u)
#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_304_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_305_MASK (0x00020000u)
#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_305_SHIFT (0x00000011u)
#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_305_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_306_MASK (0x00040000u)
#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_306_SHIFT (0x00000012u)
#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_306_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_307_MASK (0x00080000u)
#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_307_SHIFT (0x00000013u)
#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_307_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_308_MASK (0x00100000u)
#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_308_SHIFT (0x00000014u)
#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_308_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_309_MASK (0x00200000u)
#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_309_SHIFT (0x00000015u)
#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_309_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_310_MASK (0x00400000u)
#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_310_SHIFT (0x00000016u)
#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_310_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_311_MASK (0x00800000u)
#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_311_SHIFT (0x00000017u)
#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_311_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_312_MASK (0x01000000u)
#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_312_SHIFT (0x00000018u)
#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_312_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_313_MASK (0x02000000u)
#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_313_SHIFT (0x00000019u)
#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_313_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_314_MASK (0x04000000u)
#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_314_SHIFT (0x0000001Au)
#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_314_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_315_MASK (0x08000000u)
#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_315_SHIFT (0x0000001Bu)
#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_315_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_316_MASK (0x10000000u)
#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_316_SHIFT (0x0000001Cu)
#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_316_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_317_MASK (0x20000000u)
#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_317_SHIFT (0x0000001Du)
#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_317_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_318_MASK (0x40000000u)
#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_318_SHIFT (0x0000001Eu)
#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_318_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_319_MASK (0x80000000u)
#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_319_SHIFT (0x0000001Fu)
#define CSL_CPINTC_RAW_STATUS_REG9_RAW_STATUS_319_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG9_RESETVAL (0x00000000u)

/* raw_status_reg10 */

#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_320_MASK (0x00000001u)
#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_320_SHIFT (0x00000000u)
#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_320_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_321_MASK (0x00000002u)
#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_321_SHIFT (0x00000001u)
#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_321_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_322_MASK (0x00000004u)
#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_322_SHIFT (0x00000002u)
#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_322_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_323_MASK (0x00000008u)
#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_323_SHIFT (0x00000003u)
#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_323_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_324_MASK (0x00000010u)
#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_324_SHIFT (0x00000004u)
#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_324_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_325_MASK (0x00000020u)
#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_325_SHIFT (0x00000005u)
#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_325_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_326_MASK (0x00000040u)
#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_326_SHIFT (0x00000006u)
#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_326_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_327_MASK (0x00000080u)
#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_327_SHIFT (0x00000007u)
#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_327_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_328_MASK (0x00000100u)
#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_328_SHIFT (0x00000008u)
#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_328_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_329_MASK (0x00000200u)
#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_329_SHIFT (0x00000009u)
#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_329_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_330_MASK (0x00000400u)
#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_330_SHIFT (0x0000000Au)
#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_330_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_331_MASK (0x00000800u)
#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_331_SHIFT (0x0000000Bu)
#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_331_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_332_MASK (0x00001000u)
#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_332_SHIFT (0x0000000Cu)
#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_332_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_333_MASK (0x00002000u)
#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_333_SHIFT (0x0000000Du)
#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_333_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_334_MASK (0x00004000u)
#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_334_SHIFT (0x0000000Eu)
#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_334_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_335_MASK (0x00008000u)
#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_335_SHIFT (0x0000000Fu)
#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_335_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_336_MASK (0x00010000u)
#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_336_SHIFT (0x00000010u)
#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_336_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_337_MASK (0x00020000u)
#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_337_SHIFT (0x00000011u)
#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_337_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_338_MASK (0x00040000u)
#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_338_SHIFT (0x00000012u)
#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_338_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_339_MASK (0x00080000u)
#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_339_SHIFT (0x00000013u)
#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_339_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_340_MASK (0x00100000u)
#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_340_SHIFT (0x00000014u)
#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_340_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_341_MASK (0x00200000u)
#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_341_SHIFT (0x00000015u)
#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_341_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_342_MASK (0x00400000u)
#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_342_SHIFT (0x00000016u)
#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_342_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_343_MASK (0x00800000u)
#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_343_SHIFT (0x00000017u)
#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_343_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_344_MASK (0x01000000u)
#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_344_SHIFT (0x00000018u)
#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_344_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_345_MASK (0x02000000u)
#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_345_SHIFT (0x00000019u)
#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_345_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_346_MASK (0x04000000u)
#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_346_SHIFT (0x0000001Au)
#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_346_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_347_MASK (0x08000000u)
#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_347_SHIFT (0x0000001Bu)
#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_347_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_348_MASK (0x10000000u)
#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_348_SHIFT (0x0000001Cu)
#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_348_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_349_MASK (0x20000000u)
#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_349_SHIFT (0x0000001Du)
#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_349_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_350_MASK (0x40000000u)
#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_350_SHIFT (0x0000001Eu)
#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_350_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_351_MASK (0x80000000u)
#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_351_SHIFT (0x0000001Fu)
#define CSL_CPINTC_RAW_STATUS_REG10_RAW_STATUS_351_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG10_RESETVAL (0x00000000u)

/* raw_status_reg11 */

#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_352_MASK (0x00000001u)
#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_352_SHIFT (0x00000000u)
#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_352_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_353_MASK (0x00000002u)
#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_353_SHIFT (0x00000001u)
#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_353_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_354_MASK (0x00000004u)
#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_354_SHIFT (0x00000002u)
#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_354_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_355_MASK (0x00000008u)
#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_355_SHIFT (0x00000003u)
#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_355_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_356_MASK (0x00000010u)
#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_356_SHIFT (0x00000004u)
#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_356_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_357_MASK (0x00000020u)
#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_357_SHIFT (0x00000005u)
#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_357_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_358_MASK (0x00000040u)
#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_358_SHIFT (0x00000006u)
#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_358_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_359_MASK (0x00000080u)
#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_359_SHIFT (0x00000007u)
#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_359_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_360_MASK (0x00000100u)
#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_360_SHIFT (0x00000008u)
#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_360_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_361_MASK (0x00000200u)
#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_361_SHIFT (0x00000009u)
#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_361_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_362_MASK (0x00000400u)
#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_362_SHIFT (0x0000000Au)
#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_362_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_363_MASK (0x00000800u)
#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_363_SHIFT (0x0000000Bu)
#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_363_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_364_MASK (0x00001000u)
#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_364_SHIFT (0x0000000Cu)
#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_364_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_365_MASK (0x00002000u)
#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_365_SHIFT (0x0000000Du)
#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_365_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_366_MASK (0x00004000u)
#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_366_SHIFT (0x0000000Eu)
#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_366_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_367_MASK (0x00008000u)
#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_367_SHIFT (0x0000000Fu)
#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_367_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_368_MASK (0x00010000u)
#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_368_SHIFT (0x00000010u)
#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_368_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_369_MASK (0x00020000u)
#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_369_SHIFT (0x00000011u)
#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_369_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_370_MASK (0x00040000u)
#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_370_SHIFT (0x00000012u)
#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_370_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_371_MASK (0x00080000u)
#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_371_SHIFT (0x00000013u)
#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_371_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_372_MASK (0x00100000u)
#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_372_SHIFT (0x00000014u)
#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_372_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_373_MASK (0x00200000u)
#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_373_SHIFT (0x00000015u)
#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_373_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_374_MASK (0x00400000u)
#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_374_SHIFT (0x00000016u)
#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_374_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_375_MASK (0x00800000u)
#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_375_SHIFT (0x00000017u)
#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_375_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_376_MASK (0x01000000u)
#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_376_SHIFT (0x00000018u)
#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_376_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_377_MASK (0x02000000u)
#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_377_SHIFT (0x00000019u)
#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_377_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_378_MASK (0x04000000u)
#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_378_SHIFT (0x0000001Au)
#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_378_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_379_MASK (0x08000000u)
#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_379_SHIFT (0x0000001Bu)
#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_379_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_380_MASK (0x10000000u)
#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_380_SHIFT (0x0000001Cu)
#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_380_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_381_MASK (0x20000000u)
#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_381_SHIFT (0x0000001Du)
#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_381_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_382_MASK (0x40000000u)
#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_382_SHIFT (0x0000001Eu)
#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_382_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_383_MASK (0x80000000u)
#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_383_SHIFT (0x0000001Fu)
#define CSL_CPINTC_RAW_STATUS_REG11_RAW_STATUS_383_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG11_RESETVAL (0x00000000u)

/* raw_status_reg12 */

#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_384_MASK (0x00000001u)
#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_384_SHIFT (0x00000000u)
#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_384_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_385_MASK (0x00000002u)
#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_385_SHIFT (0x00000001u)
#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_385_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_386_MASK (0x00000004u)
#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_386_SHIFT (0x00000002u)
#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_386_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_387_MASK (0x00000008u)
#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_387_SHIFT (0x00000003u)
#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_387_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_388_MASK (0x00000010u)
#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_388_SHIFT (0x00000004u)
#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_388_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_389_MASK (0x00000020u)
#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_389_SHIFT (0x00000005u)
#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_389_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_390_MASK (0x00000040u)
#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_390_SHIFT (0x00000006u)
#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_390_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_391_MASK (0x00000080u)
#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_391_SHIFT (0x00000007u)
#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_391_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_392_MASK (0x00000100u)
#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_392_SHIFT (0x00000008u)
#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_392_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_393_MASK (0x00000200u)
#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_393_SHIFT (0x00000009u)
#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_393_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_394_MASK (0x00000400u)
#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_394_SHIFT (0x0000000Au)
#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_394_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_395_MASK (0x00000800u)
#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_395_SHIFT (0x0000000Bu)
#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_395_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_396_MASK (0x00001000u)
#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_396_SHIFT (0x0000000Cu)
#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_396_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_397_MASK (0x00002000u)
#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_397_SHIFT (0x0000000Du)
#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_397_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_398_MASK (0x00004000u)
#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_398_SHIFT (0x0000000Eu)
#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_398_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_399_MASK (0x00008000u)
#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_399_SHIFT (0x0000000Fu)
#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_399_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_400_MASK (0x00010000u)
#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_400_SHIFT (0x00000010u)
#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_400_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_401_MASK (0x00020000u)
#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_401_SHIFT (0x00000011u)
#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_401_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_402_MASK (0x00040000u)
#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_402_SHIFT (0x00000012u)
#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_402_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_403_MASK (0x00080000u)
#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_403_SHIFT (0x00000013u)
#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_403_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_404_MASK (0x00100000u)
#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_404_SHIFT (0x00000014u)
#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_404_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_405_MASK (0x00200000u)
#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_405_SHIFT (0x00000015u)
#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_405_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_406_MASK (0x00400000u)
#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_406_SHIFT (0x00000016u)
#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_406_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_407_MASK (0x00800000u)
#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_407_SHIFT (0x00000017u)
#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_407_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_408_MASK (0x01000000u)
#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_408_SHIFT (0x00000018u)
#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_408_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_409_MASK (0x02000000u)
#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_409_SHIFT (0x00000019u)
#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_409_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_410_MASK (0x04000000u)
#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_410_SHIFT (0x0000001Au)
#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_410_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_411_MASK (0x08000000u)
#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_411_SHIFT (0x0000001Bu)
#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_411_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_412_MASK (0x10000000u)
#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_412_SHIFT (0x0000001Cu)
#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_412_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_413_MASK (0x20000000u)
#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_413_SHIFT (0x0000001Du)
#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_413_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_414_MASK (0x40000000u)
#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_414_SHIFT (0x0000001Eu)
#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_414_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_415_MASK (0x80000000u)
#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_415_SHIFT (0x0000001Fu)
#define CSL_CPINTC_RAW_STATUS_REG12_RAW_STATUS_415_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG12_RESETVAL (0x00000000u)

/* raw_status_reg13 */

#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_416_MASK (0x00000001u)
#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_416_SHIFT (0x00000000u)
#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_416_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_417_MASK (0x00000002u)
#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_417_SHIFT (0x00000001u)
#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_417_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_418_MASK (0x00000004u)
#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_418_SHIFT (0x00000002u)
#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_418_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_419_MASK (0x00000008u)
#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_419_SHIFT (0x00000003u)
#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_419_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_420_MASK (0x00000010u)
#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_420_SHIFT (0x00000004u)
#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_420_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_421_MASK (0x00000020u)
#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_421_SHIFT (0x00000005u)
#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_421_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_422_MASK (0x00000040u)
#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_422_SHIFT (0x00000006u)
#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_422_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_423_MASK (0x00000080u)
#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_423_SHIFT (0x00000007u)
#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_423_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_424_MASK (0x00000100u)
#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_424_SHIFT (0x00000008u)
#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_424_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_425_MASK (0x00000200u)
#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_425_SHIFT (0x00000009u)
#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_425_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_426_MASK (0x00000400u)
#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_426_SHIFT (0x0000000Au)
#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_426_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_427_MASK (0x00000800u)
#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_427_SHIFT (0x0000000Bu)
#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_427_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_428_MASK (0x00001000u)
#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_428_SHIFT (0x0000000Cu)
#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_428_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_429_MASK (0x00002000u)
#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_429_SHIFT (0x0000000Du)
#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_429_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_430_MASK (0x00004000u)
#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_430_SHIFT (0x0000000Eu)
#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_430_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_431_MASK (0x00008000u)
#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_431_SHIFT (0x0000000Fu)
#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_431_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_432_MASK (0x00010000u)
#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_432_SHIFT (0x00000010u)
#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_432_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_433_MASK (0x00020000u)
#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_433_SHIFT (0x00000011u)
#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_433_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_434_MASK (0x00040000u)
#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_434_SHIFT (0x00000012u)
#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_434_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_435_MASK (0x00080000u)
#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_435_SHIFT (0x00000013u)
#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_435_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_436_MASK (0x00100000u)
#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_436_SHIFT (0x00000014u)
#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_436_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_437_MASK (0x00200000u)
#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_437_SHIFT (0x00000015u)
#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_437_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_438_MASK (0x00400000u)
#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_438_SHIFT (0x00000016u)
#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_438_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_439_MASK (0x00800000u)
#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_439_SHIFT (0x00000017u)
#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_439_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_440_MASK (0x01000000u)
#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_440_SHIFT (0x00000018u)
#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_440_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_441_MASK (0x02000000u)
#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_441_SHIFT (0x00000019u)
#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_441_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_442_MASK (0x04000000u)
#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_442_SHIFT (0x0000001Au)
#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_442_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_443_MASK (0x08000000u)
#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_443_SHIFT (0x0000001Bu)
#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_443_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_444_MASK (0x10000000u)
#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_444_SHIFT (0x0000001Cu)
#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_444_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_445_MASK (0x20000000u)
#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_445_SHIFT (0x0000001Du)
#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_445_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_446_MASK (0x40000000u)
#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_446_SHIFT (0x0000001Eu)
#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_446_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_447_MASK (0x80000000u)
#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_447_SHIFT (0x0000001Fu)
#define CSL_CPINTC_RAW_STATUS_REG13_RAW_STATUS_447_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG13_RESETVAL (0x00000000u)

/* raw_status_reg14 */

#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_448_MASK (0x00000001u)
#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_448_SHIFT (0x00000000u)
#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_448_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_449_MASK (0x00000002u)
#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_449_SHIFT (0x00000001u)
#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_449_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_450_MASK (0x00000004u)
#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_450_SHIFT (0x00000002u)
#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_450_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_451_MASK (0x00000008u)
#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_451_SHIFT (0x00000003u)
#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_451_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_452_MASK (0x00000010u)
#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_452_SHIFT (0x00000004u)
#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_452_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_453_MASK (0x00000020u)
#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_453_SHIFT (0x00000005u)
#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_453_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_454_MASK (0x00000040u)
#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_454_SHIFT (0x00000006u)
#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_454_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_455_MASK (0x00000080u)
#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_455_SHIFT (0x00000007u)
#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_455_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_456_MASK (0x00000100u)
#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_456_SHIFT (0x00000008u)
#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_456_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_457_MASK (0x00000200u)
#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_457_SHIFT (0x00000009u)
#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_457_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_458_MASK (0x00000400u)
#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_458_SHIFT (0x0000000Au)
#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_458_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_459_MASK (0x00000800u)
#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_459_SHIFT (0x0000000Bu)
#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_459_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_460_MASK (0x00001000u)
#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_460_SHIFT (0x0000000Cu)
#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_460_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_461_MASK (0x00002000u)
#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_461_SHIFT (0x0000000Du)
#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_461_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_462_MASK (0x00004000u)
#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_462_SHIFT (0x0000000Eu)
#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_462_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_463_MASK (0x00008000u)
#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_463_SHIFT (0x0000000Fu)
#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_463_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_464_MASK (0x00010000u)
#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_464_SHIFT (0x00000010u)
#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_464_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_465_MASK (0x00020000u)
#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_465_SHIFT (0x00000011u)
#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_465_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_466_MASK (0x00040000u)
#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_466_SHIFT (0x00000012u)
#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_466_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_467_MASK (0x00080000u)
#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_467_SHIFT (0x00000013u)
#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_467_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_468_MASK (0x00100000u)
#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_468_SHIFT (0x00000014u)
#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_468_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_469_MASK (0x00200000u)
#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_469_SHIFT (0x00000015u)
#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_469_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_470_MASK (0x00400000u)
#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_470_SHIFT (0x00000016u)
#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_470_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_471_MASK (0x00800000u)
#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_471_SHIFT (0x00000017u)
#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_471_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_472_MASK (0x01000000u)
#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_472_SHIFT (0x00000018u)
#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_472_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_473_MASK (0x02000000u)
#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_473_SHIFT (0x00000019u)
#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_473_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_474_MASK (0x04000000u)
#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_474_SHIFT (0x0000001Au)
#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_474_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_475_MASK (0x08000000u)
#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_475_SHIFT (0x0000001Bu)
#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_475_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_476_MASK (0x10000000u)
#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_476_SHIFT (0x0000001Cu)
#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_476_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_477_MASK (0x20000000u)
#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_477_SHIFT (0x0000001Du)
#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_477_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_478_MASK (0x40000000u)
#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_478_SHIFT (0x0000001Eu)
#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_478_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_479_MASK (0x80000000u)
#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_479_SHIFT (0x0000001Fu)
#define CSL_CPINTC_RAW_STATUS_REG14_RAW_STATUS_479_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG14_RESETVAL (0x00000000u)

/* raw_status_reg15 */

#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_480_MASK (0x00000001u)
#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_480_SHIFT (0x00000000u)
#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_480_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_481_MASK (0x00000002u)
#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_481_SHIFT (0x00000001u)
#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_481_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_482_MASK (0x00000004u)
#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_482_SHIFT (0x00000002u)
#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_482_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_483_MASK (0x00000008u)
#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_483_SHIFT (0x00000003u)
#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_483_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_484_MASK (0x00000010u)
#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_484_SHIFT (0x00000004u)
#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_484_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_485_MASK (0x00000020u)
#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_485_SHIFT (0x00000005u)
#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_485_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_486_MASK (0x00000040u)
#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_486_SHIFT (0x00000006u)
#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_486_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_487_MASK (0x00000080u)
#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_487_SHIFT (0x00000007u)
#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_487_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_488_MASK (0x00000100u)
#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_488_SHIFT (0x00000008u)
#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_488_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_489_MASK (0x00000200u)
#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_489_SHIFT (0x00000009u)
#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_489_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_490_MASK (0x00000400u)
#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_490_SHIFT (0x0000000Au)
#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_490_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_491_MASK (0x00000800u)
#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_491_SHIFT (0x0000000Bu)
#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_491_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_492_MASK (0x00001000u)
#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_492_SHIFT (0x0000000Cu)
#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_492_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_493_MASK (0x00002000u)
#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_493_SHIFT (0x0000000Du)
#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_493_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_494_MASK (0x00004000u)
#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_494_SHIFT (0x0000000Eu)
#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_494_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_495_MASK (0x00008000u)
#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_495_SHIFT (0x0000000Fu)
#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_495_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_496_MASK (0x00010000u)
#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_496_SHIFT (0x00000010u)
#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_496_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_497_MASK (0x00020000u)
#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_497_SHIFT (0x00000011u)
#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_497_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_498_MASK (0x00040000u)
#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_498_SHIFT (0x00000012u)
#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_498_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_499_MASK (0x00080000u)
#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_499_SHIFT (0x00000013u)
#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_499_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_500_MASK (0x00100000u)
#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_500_SHIFT (0x00000014u)
#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_500_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_501_MASK (0x00200000u)
#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_501_SHIFT (0x00000015u)
#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_501_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_502_MASK (0x00400000u)
#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_502_SHIFT (0x00000016u)
#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_502_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_503_MASK (0x00800000u)
#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_503_SHIFT (0x00000017u)
#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_503_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_504_MASK (0x01000000u)
#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_504_SHIFT (0x00000018u)
#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_504_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_505_MASK (0x02000000u)
#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_505_SHIFT (0x00000019u)
#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_505_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_506_MASK (0x04000000u)
#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_506_SHIFT (0x0000001Au)
#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_506_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_507_MASK (0x08000000u)
#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_507_SHIFT (0x0000001Bu)
#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_507_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_508_MASK (0x10000000u)
#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_508_SHIFT (0x0000001Cu)
#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_508_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_509_MASK (0x20000000u)
#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_509_SHIFT (0x0000001Du)
#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_509_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_510_MASK (0x40000000u)
#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_510_SHIFT (0x0000001Eu)
#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_510_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_511_MASK (0x80000000u)
#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_511_SHIFT (0x0000001Fu)
#define CSL_CPINTC_RAW_STATUS_REG15_RAW_STATUS_511_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG15_RESETVAL (0x00000000u)

/* raw_status_reg16 */

#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_512_MASK (0x00000001u)
#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_512_SHIFT (0x00000000u)
#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_512_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_513_MASK (0x00000002u)
#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_513_SHIFT (0x00000001u)
#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_513_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_514_MASK (0x00000004u)
#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_514_SHIFT (0x00000002u)
#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_514_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_515_MASK (0x00000008u)
#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_515_SHIFT (0x00000003u)
#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_515_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_516_MASK (0x00000010u)
#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_516_SHIFT (0x00000004u)
#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_516_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_517_MASK (0x00000020u)
#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_517_SHIFT (0x00000005u)
#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_517_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_518_MASK (0x00000040u)
#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_518_SHIFT (0x00000006u)
#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_518_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_519_MASK (0x00000080u)
#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_519_SHIFT (0x00000007u)
#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_519_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_520_MASK (0x00000100u)
#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_520_SHIFT (0x00000008u)
#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_520_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_521_MASK (0x00000200u)
#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_521_SHIFT (0x00000009u)
#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_521_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_522_MASK (0x00000400u)
#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_522_SHIFT (0x0000000Au)
#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_522_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_523_MASK (0x00000800u)
#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_523_SHIFT (0x0000000Bu)
#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_523_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_524_MASK (0x00001000u)
#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_524_SHIFT (0x0000000Cu)
#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_524_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_525_MASK (0x00002000u)
#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_525_SHIFT (0x0000000Du)
#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_525_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_526_MASK (0x00004000u)
#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_526_SHIFT (0x0000000Eu)
#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_526_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_527_MASK (0x00008000u)
#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_527_SHIFT (0x0000000Fu)
#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_527_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_528_MASK (0x00010000u)
#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_528_SHIFT (0x00000010u)
#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_528_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_529_MASK (0x00020000u)
#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_529_SHIFT (0x00000011u)
#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_529_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_530_MASK (0x00040000u)
#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_530_SHIFT (0x00000012u)
#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_530_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_531_MASK (0x00080000u)
#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_531_SHIFT (0x00000013u)
#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_531_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_532_MASK (0x00100000u)
#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_532_SHIFT (0x00000014u)
#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_532_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_533_MASK (0x00200000u)
#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_533_SHIFT (0x00000015u)
#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_533_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_534_MASK (0x00400000u)
#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_534_SHIFT (0x00000016u)
#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_534_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_535_MASK (0x00800000u)
#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_535_SHIFT (0x00000017u)
#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_535_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_536_MASK (0x01000000u)
#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_536_SHIFT (0x00000018u)
#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_536_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_537_MASK (0x02000000u)
#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_537_SHIFT (0x00000019u)
#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_537_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_538_MASK (0x04000000u)
#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_538_SHIFT (0x0000001Au)
#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_538_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_539_MASK (0x08000000u)
#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_539_SHIFT (0x0000001Bu)
#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_539_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_540_MASK (0x10000000u)
#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_540_SHIFT (0x0000001Cu)
#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_540_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_541_MASK (0x20000000u)
#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_541_SHIFT (0x0000001Du)
#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_541_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_542_MASK (0x40000000u)
#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_542_SHIFT (0x0000001Eu)
#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_542_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_543_MASK (0x80000000u)
#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_543_SHIFT (0x0000001Fu)
#define CSL_CPINTC_RAW_STATUS_REG16_RAW_STATUS_543_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG16_RESETVAL (0x00000000u)

/* raw_status_reg17 */

#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_544_MASK (0x00000001u)
#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_544_SHIFT (0x00000000u)
#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_544_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_545_MASK (0x00000002u)
#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_545_SHIFT (0x00000001u)
#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_545_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_546_MASK (0x00000004u)
#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_546_SHIFT (0x00000002u)
#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_546_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_547_MASK (0x00000008u)
#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_547_SHIFT (0x00000003u)
#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_547_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_548_MASK (0x00000010u)
#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_548_SHIFT (0x00000004u)
#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_548_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_549_MASK (0x00000020u)
#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_549_SHIFT (0x00000005u)
#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_549_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_550_MASK (0x00000040u)
#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_550_SHIFT (0x00000006u)
#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_550_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_551_MASK (0x00000080u)
#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_551_SHIFT (0x00000007u)
#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_551_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_552_MASK (0x00000100u)
#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_552_SHIFT (0x00000008u)
#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_552_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_553_MASK (0x00000200u)
#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_553_SHIFT (0x00000009u)
#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_553_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_554_MASK (0x00000400u)
#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_554_SHIFT (0x0000000Au)
#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_554_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_555_MASK (0x00000800u)
#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_555_SHIFT (0x0000000Bu)
#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_555_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_556_MASK (0x00001000u)
#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_556_SHIFT (0x0000000Cu)
#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_556_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_557_MASK (0x00002000u)
#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_557_SHIFT (0x0000000Du)
#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_557_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_558_MASK (0x00004000u)
#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_558_SHIFT (0x0000000Eu)
#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_558_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_559_MASK (0x00008000u)
#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_559_SHIFT (0x0000000Fu)
#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_559_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_560_MASK (0x00010000u)
#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_560_SHIFT (0x00000010u)
#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_560_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_561_MASK (0x00020000u)
#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_561_SHIFT (0x00000011u)
#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_561_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_562_MASK (0x00040000u)
#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_562_SHIFT (0x00000012u)
#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_562_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_563_MASK (0x00080000u)
#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_563_SHIFT (0x00000013u)
#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_563_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_564_MASK (0x00100000u)
#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_564_SHIFT (0x00000014u)
#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_564_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_565_MASK (0x00200000u)
#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_565_SHIFT (0x00000015u)
#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_565_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_566_MASK (0x00400000u)
#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_566_SHIFT (0x00000016u)
#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_566_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_567_MASK (0x00800000u)
#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_567_SHIFT (0x00000017u)
#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_567_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_568_MASK (0x01000000u)
#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_568_SHIFT (0x00000018u)
#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_568_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_569_MASK (0x02000000u)
#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_569_SHIFT (0x00000019u)
#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_569_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_570_MASK (0x04000000u)
#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_570_SHIFT (0x0000001Au)
#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_570_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_571_MASK (0x08000000u)
#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_571_SHIFT (0x0000001Bu)
#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_571_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_572_MASK (0x10000000u)
#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_572_SHIFT (0x0000001Cu)
#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_572_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_573_MASK (0x20000000u)
#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_573_SHIFT (0x0000001Du)
#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_573_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_574_MASK (0x40000000u)
#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_574_SHIFT (0x0000001Eu)
#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_574_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_575_MASK (0x80000000u)
#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_575_SHIFT (0x0000001Fu)
#define CSL_CPINTC_RAW_STATUS_REG17_RAW_STATUS_575_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG17_RESETVAL (0x00000000u)

/* raw_status_reg18 */

#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_576_MASK (0x00000001u)
#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_576_SHIFT (0x00000000u)
#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_576_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_577_MASK (0x00000002u)
#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_577_SHIFT (0x00000001u)
#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_577_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_578_MASK (0x00000004u)
#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_578_SHIFT (0x00000002u)
#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_578_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_579_MASK (0x00000008u)
#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_579_SHIFT (0x00000003u)
#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_579_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_580_MASK (0x00000010u)
#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_580_SHIFT (0x00000004u)
#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_580_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_581_MASK (0x00000020u)
#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_581_SHIFT (0x00000005u)
#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_581_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_582_MASK (0x00000040u)
#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_582_SHIFT (0x00000006u)
#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_582_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_583_MASK (0x00000080u)
#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_583_SHIFT (0x00000007u)
#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_583_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_584_MASK (0x00000100u)
#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_584_SHIFT (0x00000008u)
#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_584_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_585_MASK (0x00000200u)
#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_585_SHIFT (0x00000009u)
#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_585_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_586_MASK (0x00000400u)
#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_586_SHIFT (0x0000000Au)
#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_586_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_587_MASK (0x00000800u)
#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_587_SHIFT (0x0000000Bu)
#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_587_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_588_MASK (0x00001000u)
#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_588_SHIFT (0x0000000Cu)
#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_588_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_589_MASK (0x00002000u)
#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_589_SHIFT (0x0000000Du)
#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_589_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_590_MASK (0x00004000u)
#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_590_SHIFT (0x0000000Eu)
#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_590_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_591_MASK (0x00008000u)
#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_591_SHIFT (0x0000000Fu)
#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_591_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_592_MASK (0x00010000u)
#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_592_SHIFT (0x00000010u)
#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_592_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_593_MASK (0x00020000u)
#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_593_SHIFT (0x00000011u)
#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_593_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_594_MASK (0x00040000u)
#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_594_SHIFT (0x00000012u)
#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_594_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_595_MASK (0x00080000u)
#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_595_SHIFT (0x00000013u)
#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_595_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_596_MASK (0x00100000u)
#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_596_SHIFT (0x00000014u)
#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_596_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_597_MASK (0x00200000u)
#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_597_SHIFT (0x00000015u)
#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_597_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_598_MASK (0x00400000u)
#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_598_SHIFT (0x00000016u)
#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_598_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_599_MASK (0x00800000u)
#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_599_SHIFT (0x00000017u)
#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_599_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_600_MASK (0x01000000u)
#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_600_SHIFT (0x00000018u)
#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_600_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_601_MASK (0x02000000u)
#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_601_SHIFT (0x00000019u)
#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_601_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_602_MASK (0x04000000u)
#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_602_SHIFT (0x0000001Au)
#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_602_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_603_MASK (0x08000000u)
#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_603_SHIFT (0x0000001Bu)
#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_603_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_604_MASK (0x10000000u)
#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_604_SHIFT (0x0000001Cu)
#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_604_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_605_MASK (0x20000000u)
#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_605_SHIFT (0x0000001Du)
#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_605_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_606_MASK (0x40000000u)
#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_606_SHIFT (0x0000001Eu)
#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_606_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_607_MASK (0x80000000u)
#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_607_SHIFT (0x0000001Fu)
#define CSL_CPINTC_RAW_STATUS_REG18_RAW_STATUS_607_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG18_RESETVAL (0x00000000u)

/* raw_status_reg19 */

#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_608_MASK (0x00000001u)
#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_608_SHIFT (0x00000000u)
#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_608_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_609_MASK (0x00000002u)
#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_609_SHIFT (0x00000001u)
#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_609_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_610_MASK (0x00000004u)
#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_610_SHIFT (0x00000002u)
#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_610_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_611_MASK (0x00000008u)
#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_611_SHIFT (0x00000003u)
#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_611_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_612_MASK (0x00000010u)
#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_612_SHIFT (0x00000004u)
#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_612_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_613_MASK (0x00000020u)
#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_613_SHIFT (0x00000005u)
#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_613_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_614_MASK (0x00000040u)
#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_614_SHIFT (0x00000006u)
#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_614_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_615_MASK (0x00000080u)
#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_615_SHIFT (0x00000007u)
#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_615_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_616_MASK (0x00000100u)
#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_616_SHIFT (0x00000008u)
#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_616_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_617_MASK (0x00000200u)
#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_617_SHIFT (0x00000009u)
#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_617_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_618_MASK (0x00000400u)
#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_618_SHIFT (0x0000000Au)
#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_618_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_619_MASK (0x00000800u)
#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_619_SHIFT (0x0000000Bu)
#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_619_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_620_MASK (0x00001000u)
#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_620_SHIFT (0x0000000Cu)
#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_620_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_621_MASK (0x00002000u)
#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_621_SHIFT (0x0000000Du)
#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_621_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_622_MASK (0x00004000u)
#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_622_SHIFT (0x0000000Eu)
#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_622_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_623_MASK (0x00008000u)
#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_623_SHIFT (0x0000000Fu)
#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_623_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_624_MASK (0x00010000u)
#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_624_SHIFT (0x00000010u)
#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_624_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_625_MASK (0x00020000u)
#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_625_SHIFT (0x00000011u)
#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_625_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_626_MASK (0x00040000u)
#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_626_SHIFT (0x00000012u)
#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_626_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_627_MASK (0x00080000u)
#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_627_SHIFT (0x00000013u)
#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_627_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_628_MASK (0x00100000u)
#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_628_SHIFT (0x00000014u)
#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_628_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_629_MASK (0x00200000u)
#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_629_SHIFT (0x00000015u)
#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_629_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_630_MASK (0x00400000u)
#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_630_SHIFT (0x00000016u)
#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_630_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_631_MASK (0x00800000u)
#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_631_SHIFT (0x00000017u)
#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_631_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_632_MASK (0x01000000u)
#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_632_SHIFT (0x00000018u)
#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_632_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_633_MASK (0x02000000u)
#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_633_SHIFT (0x00000019u)
#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_633_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_634_MASK (0x04000000u)
#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_634_SHIFT (0x0000001Au)
#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_634_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_635_MASK (0x08000000u)
#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_635_SHIFT (0x0000001Bu)
#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_635_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_636_MASK (0x10000000u)
#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_636_SHIFT (0x0000001Cu)
#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_636_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_637_MASK (0x20000000u)
#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_637_SHIFT (0x0000001Du)
#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_637_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_638_MASK (0x40000000u)
#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_638_SHIFT (0x0000001Eu)
#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_638_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_639_MASK (0x80000000u)
#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_639_SHIFT (0x0000001Fu)
#define CSL_CPINTC_RAW_STATUS_REG19_RAW_STATUS_639_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG19_RESETVAL (0x00000000u)

/* raw_status_reg20 */

#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_640_MASK (0x00000001u)
#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_640_SHIFT (0x00000000u)
#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_640_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_641_MASK (0x00000002u)
#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_641_SHIFT (0x00000001u)
#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_641_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_642_MASK (0x00000004u)
#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_642_SHIFT (0x00000002u)
#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_642_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_643_MASK (0x00000008u)
#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_643_SHIFT (0x00000003u)
#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_643_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_644_MASK (0x00000010u)
#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_644_SHIFT (0x00000004u)
#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_644_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_645_MASK (0x00000020u)
#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_645_SHIFT (0x00000005u)
#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_645_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_646_MASK (0x00000040u)
#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_646_SHIFT (0x00000006u)
#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_646_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_647_MASK (0x00000080u)
#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_647_SHIFT (0x00000007u)
#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_647_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_648_MASK (0x00000100u)
#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_648_SHIFT (0x00000008u)
#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_648_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_649_MASK (0x00000200u)
#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_649_SHIFT (0x00000009u)
#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_649_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_650_MASK (0x00000400u)
#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_650_SHIFT (0x0000000Au)
#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_650_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_651_MASK (0x00000800u)
#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_651_SHIFT (0x0000000Bu)
#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_651_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_652_MASK (0x00001000u)
#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_652_SHIFT (0x0000000Cu)
#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_652_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_653_MASK (0x00002000u)
#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_653_SHIFT (0x0000000Du)
#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_653_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_654_MASK (0x00004000u)
#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_654_SHIFT (0x0000000Eu)
#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_654_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_655_MASK (0x00008000u)
#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_655_SHIFT (0x0000000Fu)
#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_655_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_656_MASK (0x00010000u)
#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_656_SHIFT (0x00000010u)
#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_656_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_657_MASK (0x00020000u)
#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_657_SHIFT (0x00000011u)
#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_657_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_658_MASK (0x00040000u)
#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_658_SHIFT (0x00000012u)
#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_658_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_659_MASK (0x00080000u)
#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_659_SHIFT (0x00000013u)
#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_659_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_660_MASK (0x00100000u)
#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_660_SHIFT (0x00000014u)
#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_660_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_661_MASK (0x00200000u)
#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_661_SHIFT (0x00000015u)
#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_661_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_662_MASK (0x00400000u)
#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_662_SHIFT (0x00000016u)
#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_662_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_663_MASK (0x00800000u)
#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_663_SHIFT (0x00000017u)
#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_663_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_664_MASK (0x01000000u)
#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_664_SHIFT (0x00000018u)
#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_664_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_665_MASK (0x02000000u)
#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_665_SHIFT (0x00000019u)
#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_665_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_666_MASK (0x04000000u)
#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_666_SHIFT (0x0000001Au)
#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_666_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_667_MASK (0x08000000u)
#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_667_SHIFT (0x0000001Bu)
#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_667_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_668_MASK (0x10000000u)
#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_668_SHIFT (0x0000001Cu)
#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_668_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_669_MASK (0x20000000u)
#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_669_SHIFT (0x0000001Du)
#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_669_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_670_MASK (0x40000000u)
#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_670_SHIFT (0x0000001Eu)
#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_670_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_671_MASK (0x80000000u)
#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_671_SHIFT (0x0000001Fu)
#define CSL_CPINTC_RAW_STATUS_REG20_RAW_STATUS_671_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG20_RESETVAL (0x00000000u)

/* raw_status_reg21 */

#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_672_MASK (0x00000001u)
#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_672_SHIFT (0x00000000u)
#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_672_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_673_MASK (0x00000002u)
#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_673_SHIFT (0x00000001u)
#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_673_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_674_MASK (0x00000004u)
#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_674_SHIFT (0x00000002u)
#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_674_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_675_MASK (0x00000008u)
#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_675_SHIFT (0x00000003u)
#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_675_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_676_MASK (0x00000010u)
#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_676_SHIFT (0x00000004u)
#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_676_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_677_MASK (0x00000020u)
#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_677_SHIFT (0x00000005u)
#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_677_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_678_MASK (0x00000040u)
#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_678_SHIFT (0x00000006u)
#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_678_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_679_MASK (0x00000080u)
#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_679_SHIFT (0x00000007u)
#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_679_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_680_MASK (0x00000100u)
#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_680_SHIFT (0x00000008u)
#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_680_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_681_MASK (0x00000200u)
#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_681_SHIFT (0x00000009u)
#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_681_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_682_MASK (0x00000400u)
#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_682_SHIFT (0x0000000Au)
#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_682_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_683_MASK (0x00000800u)
#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_683_SHIFT (0x0000000Bu)
#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_683_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_684_MASK (0x00001000u)
#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_684_SHIFT (0x0000000Cu)
#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_684_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_685_MASK (0x00002000u)
#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_685_SHIFT (0x0000000Du)
#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_685_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_686_MASK (0x00004000u)
#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_686_SHIFT (0x0000000Eu)
#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_686_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_687_MASK (0x00008000u)
#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_687_SHIFT (0x0000000Fu)
#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_687_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_688_MASK (0x00010000u)
#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_688_SHIFT (0x00000010u)
#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_688_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_689_MASK (0x00020000u)
#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_689_SHIFT (0x00000011u)
#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_689_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_690_MASK (0x00040000u)
#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_690_SHIFT (0x00000012u)
#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_690_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_691_MASK (0x00080000u)
#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_691_SHIFT (0x00000013u)
#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_691_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_692_MASK (0x00100000u)
#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_692_SHIFT (0x00000014u)
#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_692_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_693_MASK (0x00200000u)
#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_693_SHIFT (0x00000015u)
#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_693_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_694_MASK (0x00400000u)
#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_694_SHIFT (0x00000016u)
#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_694_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_695_MASK (0x00800000u)
#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_695_SHIFT (0x00000017u)
#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_695_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_696_MASK (0x01000000u)
#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_696_SHIFT (0x00000018u)
#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_696_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_697_MASK (0x02000000u)
#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_697_SHIFT (0x00000019u)
#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_697_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_698_MASK (0x04000000u)
#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_698_SHIFT (0x0000001Au)
#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_698_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_699_MASK (0x08000000u)
#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_699_SHIFT (0x0000001Bu)
#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_699_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_700_MASK (0x10000000u)
#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_700_SHIFT (0x0000001Cu)
#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_700_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_701_MASK (0x20000000u)
#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_701_SHIFT (0x0000001Du)
#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_701_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_702_MASK (0x40000000u)
#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_702_SHIFT (0x0000001Eu)
#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_702_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_703_MASK (0x80000000u)
#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_703_SHIFT (0x0000001Fu)
#define CSL_CPINTC_RAW_STATUS_REG21_RAW_STATUS_703_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG21_RESETVAL (0x00000000u)

/* raw_status_reg22 */

#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_704_MASK (0x00000001u)
#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_704_SHIFT (0x00000000u)
#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_704_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_705_MASK (0x00000002u)
#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_705_SHIFT (0x00000001u)
#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_705_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_706_MASK (0x00000004u)
#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_706_SHIFT (0x00000002u)
#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_706_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_707_MASK (0x00000008u)
#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_707_SHIFT (0x00000003u)
#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_707_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_708_MASK (0x00000010u)
#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_708_SHIFT (0x00000004u)
#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_708_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_709_MASK (0x00000020u)
#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_709_SHIFT (0x00000005u)
#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_709_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_710_MASK (0x00000040u)
#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_710_SHIFT (0x00000006u)
#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_710_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_711_MASK (0x00000080u)
#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_711_SHIFT (0x00000007u)
#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_711_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_712_MASK (0x00000100u)
#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_712_SHIFT (0x00000008u)
#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_712_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_713_MASK (0x00000200u)
#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_713_SHIFT (0x00000009u)
#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_713_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_714_MASK (0x00000400u)
#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_714_SHIFT (0x0000000Au)
#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_714_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_715_MASK (0x00000800u)
#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_715_SHIFT (0x0000000Bu)
#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_715_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_716_MASK (0x00001000u)
#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_716_SHIFT (0x0000000Cu)
#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_716_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_717_MASK (0x00002000u)
#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_717_SHIFT (0x0000000Du)
#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_717_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_718_MASK (0x00004000u)
#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_718_SHIFT (0x0000000Eu)
#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_718_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_719_MASK (0x00008000u)
#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_719_SHIFT (0x0000000Fu)
#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_719_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_720_MASK (0x00010000u)
#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_720_SHIFT (0x00000010u)
#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_720_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_721_MASK (0x00020000u)
#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_721_SHIFT (0x00000011u)
#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_721_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_722_MASK (0x00040000u)
#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_722_SHIFT (0x00000012u)
#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_722_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_723_MASK (0x00080000u)
#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_723_SHIFT (0x00000013u)
#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_723_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_724_MASK (0x00100000u)
#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_724_SHIFT (0x00000014u)
#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_724_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_725_MASK (0x00200000u)
#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_725_SHIFT (0x00000015u)
#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_725_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_726_MASK (0x00400000u)
#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_726_SHIFT (0x00000016u)
#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_726_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_727_MASK (0x00800000u)
#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_727_SHIFT (0x00000017u)
#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_727_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_728_MASK (0x01000000u)
#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_728_SHIFT (0x00000018u)
#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_728_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_729_MASK (0x02000000u)
#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_729_SHIFT (0x00000019u)
#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_729_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_730_MASK (0x04000000u)
#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_730_SHIFT (0x0000001Au)
#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_730_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_731_MASK (0x08000000u)
#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_731_SHIFT (0x0000001Bu)
#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_731_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_732_MASK (0x10000000u)
#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_732_SHIFT (0x0000001Cu)
#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_732_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_733_MASK (0x20000000u)
#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_733_SHIFT (0x0000001Du)
#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_733_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_734_MASK (0x40000000u)
#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_734_SHIFT (0x0000001Eu)
#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_734_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_735_MASK (0x80000000u)
#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_735_SHIFT (0x0000001Fu)
#define CSL_CPINTC_RAW_STATUS_REG22_RAW_STATUS_735_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG22_RESETVAL (0x00000000u)

/* raw_status_reg23 */

#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_736_MASK (0x00000001u)
#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_736_SHIFT (0x00000000u)
#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_736_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_737_MASK (0x00000002u)
#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_737_SHIFT (0x00000001u)
#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_737_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_738_MASK (0x00000004u)
#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_738_SHIFT (0x00000002u)
#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_738_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_739_MASK (0x00000008u)
#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_739_SHIFT (0x00000003u)
#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_739_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_740_MASK (0x00000010u)
#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_740_SHIFT (0x00000004u)
#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_740_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_741_MASK (0x00000020u)
#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_741_SHIFT (0x00000005u)
#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_741_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_742_MASK (0x00000040u)
#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_742_SHIFT (0x00000006u)
#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_742_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_743_MASK (0x00000080u)
#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_743_SHIFT (0x00000007u)
#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_743_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_744_MASK (0x00000100u)
#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_744_SHIFT (0x00000008u)
#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_744_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_745_MASK (0x00000200u)
#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_745_SHIFT (0x00000009u)
#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_745_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_746_MASK (0x00000400u)
#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_746_SHIFT (0x0000000Au)
#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_746_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_747_MASK (0x00000800u)
#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_747_SHIFT (0x0000000Bu)
#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_747_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_748_MASK (0x00001000u)
#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_748_SHIFT (0x0000000Cu)
#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_748_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_749_MASK (0x00002000u)
#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_749_SHIFT (0x0000000Du)
#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_749_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_750_MASK (0x00004000u)
#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_750_SHIFT (0x0000000Eu)
#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_750_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_751_MASK (0x00008000u)
#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_751_SHIFT (0x0000000Fu)
#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_751_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_752_MASK (0x00010000u)
#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_752_SHIFT (0x00000010u)
#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_752_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_753_MASK (0x00020000u)
#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_753_SHIFT (0x00000011u)
#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_753_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_754_MASK (0x00040000u)
#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_754_SHIFT (0x00000012u)
#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_754_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_755_MASK (0x00080000u)
#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_755_SHIFT (0x00000013u)
#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_755_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_756_MASK (0x00100000u)
#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_756_SHIFT (0x00000014u)
#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_756_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_757_MASK (0x00200000u)
#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_757_SHIFT (0x00000015u)
#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_757_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_758_MASK (0x00400000u)
#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_758_SHIFT (0x00000016u)
#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_758_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_759_MASK (0x00800000u)
#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_759_SHIFT (0x00000017u)
#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_759_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_760_MASK (0x01000000u)
#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_760_SHIFT (0x00000018u)
#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_760_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_761_MASK (0x02000000u)
#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_761_SHIFT (0x00000019u)
#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_761_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_762_MASK (0x04000000u)
#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_762_SHIFT (0x0000001Au)
#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_762_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_763_MASK (0x08000000u)
#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_763_SHIFT (0x0000001Bu)
#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_763_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_764_MASK (0x10000000u)
#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_764_SHIFT (0x0000001Cu)
#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_764_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_765_MASK (0x20000000u)
#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_765_SHIFT (0x0000001Du)
#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_765_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_766_MASK (0x40000000u)
#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_766_SHIFT (0x0000001Eu)
#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_766_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_767_MASK (0x80000000u)
#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_767_SHIFT (0x0000001Fu)
#define CSL_CPINTC_RAW_STATUS_REG23_RAW_STATUS_767_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG23_RESETVAL (0x00000000u)

/* raw_status_reg24 */

#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_768_MASK (0x00000001u)
#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_768_SHIFT (0x00000000u)
#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_768_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_769_MASK (0x00000002u)
#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_769_SHIFT (0x00000001u)
#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_769_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_770_MASK (0x00000004u)
#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_770_SHIFT (0x00000002u)
#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_770_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_771_MASK (0x00000008u)
#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_771_SHIFT (0x00000003u)
#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_771_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_772_MASK (0x00000010u)
#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_772_SHIFT (0x00000004u)
#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_772_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_773_MASK (0x00000020u)
#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_773_SHIFT (0x00000005u)
#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_773_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_774_MASK (0x00000040u)
#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_774_SHIFT (0x00000006u)
#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_774_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_775_MASK (0x00000080u)
#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_775_SHIFT (0x00000007u)
#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_775_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_776_MASK (0x00000100u)
#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_776_SHIFT (0x00000008u)
#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_776_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_777_MASK (0x00000200u)
#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_777_SHIFT (0x00000009u)
#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_777_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_778_MASK (0x00000400u)
#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_778_SHIFT (0x0000000Au)
#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_778_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_779_MASK (0x00000800u)
#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_779_SHIFT (0x0000000Bu)
#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_779_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_780_MASK (0x00001000u)
#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_780_SHIFT (0x0000000Cu)
#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_780_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_781_MASK (0x00002000u)
#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_781_SHIFT (0x0000000Du)
#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_781_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_782_MASK (0x00004000u)
#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_782_SHIFT (0x0000000Eu)
#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_782_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_783_MASK (0x00008000u)
#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_783_SHIFT (0x0000000Fu)
#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_783_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_784_MASK (0x00010000u)
#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_784_SHIFT (0x00000010u)
#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_784_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_785_MASK (0x00020000u)
#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_785_SHIFT (0x00000011u)
#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_785_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_786_MASK (0x00040000u)
#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_786_SHIFT (0x00000012u)
#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_786_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_787_MASK (0x00080000u)
#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_787_SHIFT (0x00000013u)
#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_787_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_788_MASK (0x00100000u)
#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_788_SHIFT (0x00000014u)
#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_788_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_789_MASK (0x00200000u)
#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_789_SHIFT (0x00000015u)
#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_789_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_790_MASK (0x00400000u)
#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_790_SHIFT (0x00000016u)
#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_790_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_791_MASK (0x00800000u)
#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_791_SHIFT (0x00000017u)
#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_791_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_792_MASK (0x01000000u)
#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_792_SHIFT (0x00000018u)
#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_792_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_793_MASK (0x02000000u)
#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_793_SHIFT (0x00000019u)
#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_793_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_794_MASK (0x04000000u)
#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_794_SHIFT (0x0000001Au)
#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_794_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_795_MASK (0x08000000u)
#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_795_SHIFT (0x0000001Bu)
#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_795_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_796_MASK (0x10000000u)
#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_796_SHIFT (0x0000001Cu)
#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_796_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_797_MASK (0x20000000u)
#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_797_SHIFT (0x0000001Du)
#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_797_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_798_MASK (0x40000000u)
#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_798_SHIFT (0x0000001Eu)
#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_798_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_799_MASK (0x80000000u)
#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_799_SHIFT (0x0000001Fu)
#define CSL_CPINTC_RAW_STATUS_REG24_RAW_STATUS_799_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG24_RESETVAL (0x00000000u)

/* raw_status_reg25 */

#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_800_MASK (0x00000001u)
#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_800_SHIFT (0x00000000u)
#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_800_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_801_MASK (0x00000002u)
#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_801_SHIFT (0x00000001u)
#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_801_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_802_MASK (0x00000004u)
#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_802_SHIFT (0x00000002u)
#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_802_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_803_MASK (0x00000008u)
#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_803_SHIFT (0x00000003u)
#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_803_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_804_MASK (0x00000010u)
#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_804_SHIFT (0x00000004u)
#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_804_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_805_MASK (0x00000020u)
#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_805_SHIFT (0x00000005u)
#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_805_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_806_MASK (0x00000040u)
#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_806_SHIFT (0x00000006u)
#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_806_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_807_MASK (0x00000080u)
#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_807_SHIFT (0x00000007u)
#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_807_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_808_MASK (0x00000100u)
#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_808_SHIFT (0x00000008u)
#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_808_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_809_MASK (0x00000200u)
#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_809_SHIFT (0x00000009u)
#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_809_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_810_MASK (0x00000400u)
#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_810_SHIFT (0x0000000Au)
#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_810_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_811_MASK (0x00000800u)
#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_811_SHIFT (0x0000000Bu)
#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_811_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_812_MASK (0x00001000u)
#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_812_SHIFT (0x0000000Cu)
#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_812_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_813_MASK (0x00002000u)
#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_813_SHIFT (0x0000000Du)
#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_813_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_814_MASK (0x00004000u)
#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_814_SHIFT (0x0000000Eu)
#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_814_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_815_MASK (0x00008000u)
#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_815_SHIFT (0x0000000Fu)
#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_815_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_816_MASK (0x00010000u)
#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_816_SHIFT (0x00000010u)
#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_816_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_817_MASK (0x00020000u)
#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_817_SHIFT (0x00000011u)
#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_817_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_818_MASK (0x00040000u)
#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_818_SHIFT (0x00000012u)
#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_818_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_819_MASK (0x00080000u)
#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_819_SHIFT (0x00000013u)
#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_819_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_820_MASK (0x00100000u)
#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_820_SHIFT (0x00000014u)
#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_820_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_821_MASK (0x00200000u)
#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_821_SHIFT (0x00000015u)
#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_821_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_822_MASK (0x00400000u)
#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_822_SHIFT (0x00000016u)
#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_822_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_823_MASK (0x00800000u)
#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_823_SHIFT (0x00000017u)
#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_823_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_824_MASK (0x01000000u)
#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_824_SHIFT (0x00000018u)
#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_824_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_825_MASK (0x02000000u)
#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_825_SHIFT (0x00000019u)
#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_825_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_826_MASK (0x04000000u)
#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_826_SHIFT (0x0000001Au)
#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_826_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_827_MASK (0x08000000u)
#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_827_SHIFT (0x0000001Bu)
#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_827_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_828_MASK (0x10000000u)
#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_828_SHIFT (0x0000001Cu)
#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_828_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_829_MASK (0x20000000u)
#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_829_SHIFT (0x0000001Du)
#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_829_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_830_MASK (0x40000000u)
#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_830_SHIFT (0x0000001Eu)
#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_830_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_831_MASK (0x80000000u)
#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_831_SHIFT (0x0000001Fu)
#define CSL_CPINTC_RAW_STATUS_REG25_RAW_STATUS_831_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG25_RESETVAL (0x00000000u)

/* raw_status_reg26 */

#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_832_MASK (0x00000001u)
#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_832_SHIFT (0x00000000u)
#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_832_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_833_MASK (0x00000002u)
#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_833_SHIFT (0x00000001u)
#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_833_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_834_MASK (0x00000004u)
#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_834_SHIFT (0x00000002u)
#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_834_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_835_MASK (0x00000008u)
#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_835_SHIFT (0x00000003u)
#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_835_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_836_MASK (0x00000010u)
#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_836_SHIFT (0x00000004u)
#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_836_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_837_MASK (0x00000020u)
#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_837_SHIFT (0x00000005u)
#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_837_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_838_MASK (0x00000040u)
#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_838_SHIFT (0x00000006u)
#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_838_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_839_MASK (0x00000080u)
#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_839_SHIFT (0x00000007u)
#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_839_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_840_MASK (0x00000100u)
#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_840_SHIFT (0x00000008u)
#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_840_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_841_MASK (0x00000200u)
#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_841_SHIFT (0x00000009u)
#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_841_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_842_MASK (0x00000400u)
#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_842_SHIFT (0x0000000Au)
#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_842_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_843_MASK (0x00000800u)
#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_843_SHIFT (0x0000000Bu)
#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_843_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_844_MASK (0x00001000u)
#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_844_SHIFT (0x0000000Cu)
#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_844_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_845_MASK (0x00002000u)
#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_845_SHIFT (0x0000000Du)
#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_845_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_846_MASK (0x00004000u)
#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_846_SHIFT (0x0000000Eu)
#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_846_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_847_MASK (0x00008000u)
#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_847_SHIFT (0x0000000Fu)
#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_847_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_848_MASK (0x00010000u)
#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_848_SHIFT (0x00000010u)
#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_848_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_849_MASK (0x00020000u)
#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_849_SHIFT (0x00000011u)
#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_849_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_850_MASK (0x00040000u)
#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_850_SHIFT (0x00000012u)
#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_850_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_851_MASK (0x00080000u)
#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_851_SHIFT (0x00000013u)
#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_851_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_852_MASK (0x00100000u)
#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_852_SHIFT (0x00000014u)
#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_852_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_853_MASK (0x00200000u)
#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_853_SHIFT (0x00000015u)
#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_853_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_854_MASK (0x00400000u)
#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_854_SHIFT (0x00000016u)
#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_854_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_855_MASK (0x00800000u)
#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_855_SHIFT (0x00000017u)
#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_855_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_856_MASK (0x01000000u)
#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_856_SHIFT (0x00000018u)
#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_856_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_857_MASK (0x02000000u)
#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_857_SHIFT (0x00000019u)
#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_857_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_858_MASK (0x04000000u)
#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_858_SHIFT (0x0000001Au)
#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_858_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_859_MASK (0x08000000u)
#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_859_SHIFT (0x0000001Bu)
#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_859_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_860_MASK (0x10000000u)
#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_860_SHIFT (0x0000001Cu)
#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_860_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_861_MASK (0x20000000u)
#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_861_SHIFT (0x0000001Du)
#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_861_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_862_MASK (0x40000000u)
#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_862_SHIFT (0x0000001Eu)
#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_862_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_863_MASK (0x80000000u)
#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_863_SHIFT (0x0000001Fu)
#define CSL_CPINTC_RAW_STATUS_REG26_RAW_STATUS_863_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG26_RESETVAL (0x00000000u)

/* raw_status_reg27 */

#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_864_MASK (0x00000001u)
#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_864_SHIFT (0x00000000u)
#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_864_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_865_MASK (0x00000002u)
#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_865_SHIFT (0x00000001u)
#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_865_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_866_MASK (0x00000004u)
#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_866_SHIFT (0x00000002u)
#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_866_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_867_MASK (0x00000008u)
#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_867_SHIFT (0x00000003u)
#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_867_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_868_MASK (0x00000010u)
#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_868_SHIFT (0x00000004u)
#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_868_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_869_MASK (0x00000020u)
#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_869_SHIFT (0x00000005u)
#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_869_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_870_MASK (0x00000040u)
#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_870_SHIFT (0x00000006u)
#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_870_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_871_MASK (0x00000080u)
#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_871_SHIFT (0x00000007u)
#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_871_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_872_MASK (0x00000100u)
#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_872_SHIFT (0x00000008u)
#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_872_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_873_MASK (0x00000200u)
#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_873_SHIFT (0x00000009u)
#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_873_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_874_MASK (0x00000400u)
#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_874_SHIFT (0x0000000Au)
#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_874_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_875_MASK (0x00000800u)
#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_875_SHIFT (0x0000000Bu)
#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_875_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_876_MASK (0x00001000u)
#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_876_SHIFT (0x0000000Cu)
#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_876_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_877_MASK (0x00002000u)
#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_877_SHIFT (0x0000000Du)
#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_877_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_878_MASK (0x00004000u)
#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_878_SHIFT (0x0000000Eu)
#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_878_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_879_MASK (0x00008000u)
#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_879_SHIFT (0x0000000Fu)
#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_879_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_880_MASK (0x00010000u)
#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_880_SHIFT (0x00000010u)
#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_880_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_881_MASK (0x00020000u)
#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_881_SHIFT (0x00000011u)
#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_881_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_882_MASK (0x00040000u)
#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_882_SHIFT (0x00000012u)
#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_882_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_883_MASK (0x00080000u)
#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_883_SHIFT (0x00000013u)
#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_883_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_884_MASK (0x00100000u)
#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_884_SHIFT (0x00000014u)
#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_884_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_885_MASK (0x00200000u)
#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_885_SHIFT (0x00000015u)
#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_885_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_886_MASK (0x00400000u)
#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_886_SHIFT (0x00000016u)
#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_886_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_887_MASK (0x00800000u)
#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_887_SHIFT (0x00000017u)
#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_887_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_888_MASK (0x01000000u)
#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_888_SHIFT (0x00000018u)
#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_888_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_889_MASK (0x02000000u)
#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_889_SHIFT (0x00000019u)
#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_889_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_890_MASK (0x04000000u)
#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_890_SHIFT (0x0000001Au)
#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_890_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_891_MASK (0x08000000u)
#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_891_SHIFT (0x0000001Bu)
#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_891_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_892_MASK (0x10000000u)
#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_892_SHIFT (0x0000001Cu)
#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_892_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_893_MASK (0x20000000u)
#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_893_SHIFT (0x0000001Du)
#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_893_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_894_MASK (0x40000000u)
#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_894_SHIFT (0x0000001Eu)
#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_894_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_895_MASK (0x80000000u)
#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_895_SHIFT (0x0000001Fu)
#define CSL_CPINTC_RAW_STATUS_REG27_RAW_STATUS_895_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG27_RESETVAL (0x00000000u)

/* raw_status_reg28 */

#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_896_MASK (0x00000001u)
#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_896_SHIFT (0x00000000u)
#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_896_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_897_MASK (0x00000002u)
#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_897_SHIFT (0x00000001u)
#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_897_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_898_MASK (0x00000004u)
#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_898_SHIFT (0x00000002u)
#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_898_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_899_MASK (0x00000008u)
#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_899_SHIFT (0x00000003u)
#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_899_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_900_MASK (0x00000010u)
#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_900_SHIFT (0x00000004u)
#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_900_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_901_MASK (0x00000020u)
#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_901_SHIFT (0x00000005u)
#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_901_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_902_MASK (0x00000040u)
#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_902_SHIFT (0x00000006u)
#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_902_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_903_MASK (0x00000080u)
#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_903_SHIFT (0x00000007u)
#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_903_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_904_MASK (0x00000100u)
#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_904_SHIFT (0x00000008u)
#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_904_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_905_MASK (0x00000200u)
#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_905_SHIFT (0x00000009u)
#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_905_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_906_MASK (0x00000400u)
#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_906_SHIFT (0x0000000Au)
#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_906_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_907_MASK (0x00000800u)
#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_907_SHIFT (0x0000000Bu)
#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_907_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_908_MASK (0x00001000u)
#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_908_SHIFT (0x0000000Cu)
#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_908_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_909_MASK (0x00002000u)
#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_909_SHIFT (0x0000000Du)
#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_909_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_910_MASK (0x00004000u)
#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_910_SHIFT (0x0000000Eu)
#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_910_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_911_MASK (0x00008000u)
#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_911_SHIFT (0x0000000Fu)
#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_911_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_912_MASK (0x00010000u)
#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_912_SHIFT (0x00000010u)
#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_912_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_913_MASK (0x00020000u)
#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_913_SHIFT (0x00000011u)
#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_913_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_914_MASK (0x00040000u)
#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_914_SHIFT (0x00000012u)
#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_914_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_915_MASK (0x00080000u)
#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_915_SHIFT (0x00000013u)
#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_915_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_916_MASK (0x00100000u)
#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_916_SHIFT (0x00000014u)
#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_916_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_917_MASK (0x00200000u)
#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_917_SHIFT (0x00000015u)
#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_917_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_918_MASK (0x00400000u)
#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_918_SHIFT (0x00000016u)
#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_918_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_919_MASK (0x00800000u)
#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_919_SHIFT (0x00000017u)
#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_919_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_920_MASK (0x01000000u)
#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_920_SHIFT (0x00000018u)
#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_920_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_921_MASK (0x02000000u)
#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_921_SHIFT (0x00000019u)
#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_921_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_922_MASK (0x04000000u)
#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_922_SHIFT (0x0000001Au)
#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_922_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_923_MASK (0x08000000u)
#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_923_SHIFT (0x0000001Bu)
#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_923_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_924_MASK (0x10000000u)
#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_924_SHIFT (0x0000001Cu)
#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_924_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_925_MASK (0x20000000u)
#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_925_SHIFT (0x0000001Du)
#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_925_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_926_MASK (0x40000000u)
#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_926_SHIFT (0x0000001Eu)
#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_926_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_927_MASK (0x80000000u)
#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_927_SHIFT (0x0000001Fu)
#define CSL_CPINTC_RAW_STATUS_REG28_RAW_STATUS_927_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG28_RESETVAL (0x00000000u)

/* raw_status_reg29 */

#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_928_MASK (0x00000001u)
#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_928_SHIFT (0x00000000u)
#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_928_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_929_MASK (0x00000002u)
#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_929_SHIFT (0x00000001u)
#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_929_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_930_MASK (0x00000004u)
#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_930_SHIFT (0x00000002u)
#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_930_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_931_MASK (0x00000008u)
#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_931_SHIFT (0x00000003u)
#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_931_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_932_MASK (0x00000010u)
#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_932_SHIFT (0x00000004u)
#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_932_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_933_MASK (0x00000020u)
#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_933_SHIFT (0x00000005u)
#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_933_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_934_MASK (0x00000040u)
#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_934_SHIFT (0x00000006u)
#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_934_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_935_MASK (0x00000080u)
#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_935_SHIFT (0x00000007u)
#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_935_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_936_MASK (0x00000100u)
#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_936_SHIFT (0x00000008u)
#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_936_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_937_MASK (0x00000200u)
#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_937_SHIFT (0x00000009u)
#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_937_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_938_MASK (0x00000400u)
#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_938_SHIFT (0x0000000Au)
#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_938_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_939_MASK (0x00000800u)
#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_939_SHIFT (0x0000000Bu)
#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_939_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_940_MASK (0x00001000u)
#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_940_SHIFT (0x0000000Cu)
#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_940_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_941_MASK (0x00002000u)
#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_941_SHIFT (0x0000000Du)
#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_941_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_942_MASK (0x00004000u)
#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_942_SHIFT (0x0000000Eu)
#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_942_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_943_MASK (0x00008000u)
#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_943_SHIFT (0x0000000Fu)
#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_943_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_944_MASK (0x00010000u)
#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_944_SHIFT (0x00000010u)
#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_944_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_945_MASK (0x00020000u)
#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_945_SHIFT (0x00000011u)
#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_945_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_946_MASK (0x00040000u)
#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_946_SHIFT (0x00000012u)
#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_946_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_947_MASK (0x00080000u)
#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_947_SHIFT (0x00000013u)
#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_947_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_948_MASK (0x00100000u)
#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_948_SHIFT (0x00000014u)
#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_948_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_949_MASK (0x00200000u)
#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_949_SHIFT (0x00000015u)
#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_949_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_950_MASK (0x00400000u)
#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_950_SHIFT (0x00000016u)
#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_950_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_951_MASK (0x00800000u)
#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_951_SHIFT (0x00000017u)
#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_951_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_952_MASK (0x01000000u)
#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_952_SHIFT (0x00000018u)
#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_952_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_953_MASK (0x02000000u)
#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_953_SHIFT (0x00000019u)
#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_953_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_954_MASK (0x04000000u)
#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_954_SHIFT (0x0000001Au)
#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_954_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_955_MASK (0x08000000u)
#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_955_SHIFT (0x0000001Bu)
#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_955_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_956_MASK (0x10000000u)
#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_956_SHIFT (0x0000001Cu)
#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_956_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_957_MASK (0x20000000u)
#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_957_SHIFT (0x0000001Du)
#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_957_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_958_MASK (0x40000000u)
#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_958_SHIFT (0x0000001Eu)
#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_958_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_959_MASK (0x80000000u)
#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_959_SHIFT (0x0000001Fu)
#define CSL_CPINTC_RAW_STATUS_REG29_RAW_STATUS_959_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG29_RESETVAL (0x00000000u)

/* raw_status_reg30 */

#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_960_MASK (0x00000001u)
#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_960_SHIFT (0x00000000u)
#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_960_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_961_MASK (0x00000002u)
#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_961_SHIFT (0x00000001u)
#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_961_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_962_MASK (0x00000004u)
#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_962_SHIFT (0x00000002u)
#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_962_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_963_MASK (0x00000008u)
#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_963_SHIFT (0x00000003u)
#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_963_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_964_MASK (0x00000010u)
#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_964_SHIFT (0x00000004u)
#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_964_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_965_MASK (0x00000020u)
#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_965_SHIFT (0x00000005u)
#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_965_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_966_MASK (0x00000040u)
#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_966_SHIFT (0x00000006u)
#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_966_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_967_MASK (0x00000080u)
#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_967_SHIFT (0x00000007u)
#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_967_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_968_MASK (0x00000100u)
#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_968_SHIFT (0x00000008u)
#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_968_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_969_MASK (0x00000200u)
#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_969_SHIFT (0x00000009u)
#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_969_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_970_MASK (0x00000400u)
#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_970_SHIFT (0x0000000Au)
#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_970_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_971_MASK (0x00000800u)
#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_971_SHIFT (0x0000000Bu)
#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_971_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_972_MASK (0x00001000u)
#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_972_SHIFT (0x0000000Cu)
#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_972_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_973_MASK (0x00002000u)
#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_973_SHIFT (0x0000000Du)
#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_973_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_974_MASK (0x00004000u)
#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_974_SHIFT (0x0000000Eu)
#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_974_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_975_MASK (0x00008000u)
#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_975_SHIFT (0x0000000Fu)
#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_975_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_976_MASK (0x00010000u)
#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_976_SHIFT (0x00000010u)
#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_976_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_977_MASK (0x00020000u)
#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_977_SHIFT (0x00000011u)
#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_977_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_978_MASK (0x00040000u)
#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_978_SHIFT (0x00000012u)
#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_978_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_979_MASK (0x00080000u)
#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_979_SHIFT (0x00000013u)
#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_979_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_980_MASK (0x00100000u)
#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_980_SHIFT (0x00000014u)
#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_980_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_981_MASK (0x00200000u)
#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_981_SHIFT (0x00000015u)
#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_981_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_982_MASK (0x00400000u)
#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_982_SHIFT (0x00000016u)
#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_982_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_983_MASK (0x00800000u)
#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_983_SHIFT (0x00000017u)
#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_983_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_984_MASK (0x01000000u)
#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_984_SHIFT (0x00000018u)
#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_984_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_985_MASK (0x02000000u)
#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_985_SHIFT (0x00000019u)
#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_985_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_986_MASK (0x04000000u)
#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_986_SHIFT (0x0000001Au)
#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_986_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_987_MASK (0x08000000u)
#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_987_SHIFT (0x0000001Bu)
#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_987_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_988_MASK (0x10000000u)
#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_988_SHIFT (0x0000001Cu)
#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_988_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_989_MASK (0x20000000u)
#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_989_SHIFT (0x0000001Du)
#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_989_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_990_MASK (0x40000000u)
#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_990_SHIFT (0x0000001Eu)
#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_990_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_991_MASK (0x80000000u)
#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_991_SHIFT (0x0000001Fu)
#define CSL_CPINTC_RAW_STATUS_REG30_RAW_STATUS_991_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG30_RESETVAL (0x00000000u)

/* raw_status_reg31 */

#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_992_MASK (0x00000001u)
#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_992_SHIFT (0x00000000u)
#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_992_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_993_MASK (0x00000002u)
#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_993_SHIFT (0x00000001u)
#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_993_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_994_MASK (0x00000004u)
#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_994_SHIFT (0x00000002u)
#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_994_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_995_MASK (0x00000008u)
#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_995_SHIFT (0x00000003u)
#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_995_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_996_MASK (0x00000010u)
#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_996_SHIFT (0x00000004u)
#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_996_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_997_MASK (0x00000020u)
#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_997_SHIFT (0x00000005u)
#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_997_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_998_MASK (0x00000040u)
#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_998_SHIFT (0x00000006u)
#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_998_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_999_MASK (0x00000080u)
#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_999_SHIFT (0x00000007u)
#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_999_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_1000_MASK (0x00000100u)
#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_1000_SHIFT (0x00000008u)
#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_1000_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_1001_MASK (0x00000200u)
#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_1001_SHIFT (0x00000009u)
#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_1001_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_1002_MASK (0x00000400u)
#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_1002_SHIFT (0x0000000Au)
#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_1002_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_1003_MASK (0x00000800u)
#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_1003_SHIFT (0x0000000Bu)
#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_1003_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_1004_MASK (0x00001000u)
#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_1004_SHIFT (0x0000000Cu)
#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_1004_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_1005_MASK (0x00002000u)
#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_1005_SHIFT (0x0000000Du)
#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_1005_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_1006_MASK (0x00004000u)
#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_1006_SHIFT (0x0000000Eu)
#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_1006_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_1007_MASK (0x00008000u)
#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_1007_SHIFT (0x0000000Fu)
#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_1007_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_1008_MASK (0x00010000u)
#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_1008_SHIFT (0x00000010u)
#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_1008_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_1009_MASK (0x00020000u)
#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_1009_SHIFT (0x00000011u)
#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_1009_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_1010_MASK (0x00040000u)
#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_1010_SHIFT (0x00000012u)
#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_1010_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_1011_MASK (0x00080000u)
#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_1011_SHIFT (0x00000013u)
#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_1011_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_1012_MASK (0x00100000u)
#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_1012_SHIFT (0x00000014u)
#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_1012_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_1013_MASK (0x00200000u)
#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_1013_SHIFT (0x00000015u)
#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_1013_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_1014_MASK (0x00400000u)
#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_1014_SHIFT (0x00000016u)
#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_1014_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_1015_MASK (0x00800000u)
#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_1015_SHIFT (0x00000017u)
#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_1015_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_1016_MASK (0x01000000u)
#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_1016_SHIFT (0x00000018u)
#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_1016_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_1017_MASK (0x02000000u)
#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_1017_SHIFT (0x00000019u)
#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_1017_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_1018_MASK (0x04000000u)
#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_1018_SHIFT (0x0000001Au)
#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_1018_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_1019_MASK (0x08000000u)
#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_1019_SHIFT (0x0000001Bu)
#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_1019_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_1020_MASK (0x10000000u)
#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_1020_SHIFT (0x0000001Cu)
#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_1020_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_1021_MASK (0x20000000u)
#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_1021_SHIFT (0x0000001Du)
#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_1021_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_1022_MASK (0x40000000u)
#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_1022_SHIFT (0x0000001Eu)
#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_1022_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_1023_MASK (0x80000000u)
#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_1023_SHIFT (0x0000001Fu)
#define CSL_CPINTC_RAW_STATUS_REG31_RAW_STATUS_1023_RESETVAL (0x00000000u)

#define CSL_CPINTC_RAW_STATUS_REG31_RESETVAL (0x00000000u)

/* ena_status_reg0 */

#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_0_MASK (0x00000001u)
#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_0_SHIFT (0x00000000u)
#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_0_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_1_MASK (0x00000002u)
#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_1_SHIFT (0x00000001u)
#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_1_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_2_MASK (0x00000004u)
#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_2_SHIFT (0x00000002u)
#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_2_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_3_MASK (0x00000008u)
#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_3_SHIFT (0x00000003u)
#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_3_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_4_MASK (0x00000010u)
#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_4_SHIFT (0x00000004u)
#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_4_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_5_MASK (0x00000020u)
#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_5_SHIFT (0x00000005u)
#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_5_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_6_MASK (0x00000040u)
#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_6_SHIFT (0x00000006u)
#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_6_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_7_MASK (0x00000080u)
#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_7_SHIFT (0x00000007u)
#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_7_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_8_MASK (0x00000100u)
#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_8_SHIFT (0x00000008u)
#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_8_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_9_MASK (0x00000200u)
#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_9_SHIFT (0x00000009u)
#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_9_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_10_MASK (0x00000400u)
#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_10_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_10_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_11_MASK (0x00000800u)
#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_11_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_11_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_12_MASK (0x00001000u)
#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_12_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_12_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_13_MASK (0x00002000u)
#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_13_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_13_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_14_MASK (0x00004000u)
#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_14_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_14_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_15_MASK (0x00008000u)
#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_15_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_15_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_16_MASK (0x00010000u)
#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_16_SHIFT (0x00000010u)
#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_16_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_17_MASK (0x00020000u)
#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_17_SHIFT (0x00000011u)
#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_17_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_18_MASK (0x00040000u)
#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_18_SHIFT (0x00000012u)
#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_18_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_19_MASK (0x00080000u)
#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_19_SHIFT (0x00000013u)
#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_19_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_20_MASK (0x00100000u)
#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_20_SHIFT (0x00000014u)
#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_20_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_21_MASK (0x00200000u)
#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_21_SHIFT (0x00000015u)
#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_21_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_22_MASK (0x00400000u)
#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_22_SHIFT (0x00000016u)
#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_22_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_23_MASK (0x00800000u)
#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_23_SHIFT (0x00000017u)
#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_23_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_24_MASK (0x01000000u)
#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_24_SHIFT (0x00000018u)
#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_24_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_25_MASK (0x02000000u)
#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_25_SHIFT (0x00000019u)
#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_25_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_26_MASK (0x04000000u)
#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_26_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_26_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_27_MASK (0x08000000u)
#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_27_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_27_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_28_MASK (0x10000000u)
#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_28_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_28_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_29_MASK (0x20000000u)
#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_29_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_29_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_30_MASK (0x40000000u)
#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_30_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_30_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_31_MASK (0x80000000u)
#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_31_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENA_STATUS_REG0_ENA_STATUS_31_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG0_RESETVAL (0x00000000u)

/* ena_status_reg1 */

#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_32_MASK (0x00000001u)
#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_32_SHIFT (0x00000000u)
#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_32_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_33_MASK (0x00000002u)
#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_33_SHIFT (0x00000001u)
#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_33_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_34_MASK (0x00000004u)
#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_34_SHIFT (0x00000002u)
#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_34_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_35_MASK (0x00000008u)
#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_35_SHIFT (0x00000003u)
#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_35_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_36_MASK (0x00000010u)
#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_36_SHIFT (0x00000004u)
#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_36_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_37_MASK (0x00000020u)
#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_37_SHIFT (0x00000005u)
#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_37_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_38_MASK (0x00000040u)
#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_38_SHIFT (0x00000006u)
#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_38_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_39_MASK (0x00000080u)
#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_39_SHIFT (0x00000007u)
#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_39_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_40_MASK (0x00000100u)
#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_40_SHIFT (0x00000008u)
#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_40_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_41_MASK (0x00000200u)
#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_41_SHIFT (0x00000009u)
#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_41_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_42_MASK (0x00000400u)
#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_42_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_42_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_43_MASK (0x00000800u)
#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_43_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_43_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_44_MASK (0x00001000u)
#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_44_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_44_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_45_MASK (0x00002000u)
#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_45_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_45_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_46_MASK (0x00004000u)
#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_46_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_46_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_47_MASK (0x00008000u)
#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_47_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_47_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_48_MASK (0x00010000u)
#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_48_SHIFT (0x00000010u)
#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_48_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_49_MASK (0x00020000u)
#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_49_SHIFT (0x00000011u)
#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_49_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_50_MASK (0x00040000u)
#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_50_SHIFT (0x00000012u)
#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_50_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_51_MASK (0x00080000u)
#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_51_SHIFT (0x00000013u)
#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_51_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_52_MASK (0x00100000u)
#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_52_SHIFT (0x00000014u)
#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_52_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_53_MASK (0x00200000u)
#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_53_SHIFT (0x00000015u)
#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_53_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_54_MASK (0x00400000u)
#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_54_SHIFT (0x00000016u)
#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_54_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_55_MASK (0x00800000u)
#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_55_SHIFT (0x00000017u)
#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_55_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_56_MASK (0x01000000u)
#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_56_SHIFT (0x00000018u)
#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_56_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_57_MASK (0x02000000u)
#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_57_SHIFT (0x00000019u)
#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_57_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_58_MASK (0x04000000u)
#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_58_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_58_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_59_MASK (0x08000000u)
#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_59_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_59_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_60_MASK (0x10000000u)
#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_60_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_60_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_61_MASK (0x20000000u)
#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_61_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_61_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_62_MASK (0x40000000u)
#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_62_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_62_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_63_MASK (0x80000000u)
#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_63_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENA_STATUS_REG1_ENA_STATUS_63_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG1_RESETVAL (0x00000000u)

/* ena_status_reg2 */

#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_64_MASK (0x00000001u)
#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_64_SHIFT (0x00000000u)
#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_64_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_65_MASK (0x00000002u)
#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_65_SHIFT (0x00000001u)
#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_65_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_66_MASK (0x00000004u)
#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_66_SHIFT (0x00000002u)
#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_66_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_67_MASK (0x00000008u)
#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_67_SHIFT (0x00000003u)
#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_67_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_68_MASK (0x00000010u)
#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_68_SHIFT (0x00000004u)
#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_68_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_69_MASK (0x00000020u)
#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_69_SHIFT (0x00000005u)
#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_69_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_70_MASK (0x00000040u)
#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_70_SHIFT (0x00000006u)
#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_70_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_71_MASK (0x00000080u)
#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_71_SHIFT (0x00000007u)
#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_71_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_72_MASK (0x00000100u)
#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_72_SHIFT (0x00000008u)
#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_72_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_73_MASK (0x00000200u)
#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_73_SHIFT (0x00000009u)
#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_73_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_74_MASK (0x00000400u)
#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_74_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_74_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_75_MASK (0x00000800u)
#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_75_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_75_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_76_MASK (0x00001000u)
#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_76_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_76_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_77_MASK (0x00002000u)
#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_77_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_77_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_78_MASK (0x00004000u)
#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_78_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_78_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_79_MASK (0x00008000u)
#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_79_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_79_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_80_MASK (0x00010000u)
#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_80_SHIFT (0x00000010u)
#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_80_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_81_MASK (0x00020000u)
#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_81_SHIFT (0x00000011u)
#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_81_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_82_MASK (0x00040000u)
#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_82_SHIFT (0x00000012u)
#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_82_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_83_MASK (0x00080000u)
#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_83_SHIFT (0x00000013u)
#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_83_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_84_MASK (0x00100000u)
#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_84_SHIFT (0x00000014u)
#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_84_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_85_MASK (0x00200000u)
#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_85_SHIFT (0x00000015u)
#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_85_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_86_MASK (0x00400000u)
#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_86_SHIFT (0x00000016u)
#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_86_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_87_MASK (0x00800000u)
#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_87_SHIFT (0x00000017u)
#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_87_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_88_MASK (0x01000000u)
#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_88_SHIFT (0x00000018u)
#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_88_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_89_MASK (0x02000000u)
#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_89_SHIFT (0x00000019u)
#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_89_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_90_MASK (0x04000000u)
#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_90_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_90_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_91_MASK (0x08000000u)
#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_91_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_91_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_92_MASK (0x10000000u)
#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_92_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_92_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_93_MASK (0x20000000u)
#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_93_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_93_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_94_MASK (0x40000000u)
#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_94_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_94_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_95_MASK (0x80000000u)
#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_95_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENA_STATUS_REG2_ENA_STATUS_95_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG2_RESETVAL (0x00000000u)

/* ena_status_reg3 */

#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_96_MASK (0x00000001u)
#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_96_SHIFT (0x00000000u)
#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_96_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_97_MASK (0x00000002u)
#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_97_SHIFT (0x00000001u)
#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_97_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_98_MASK (0x00000004u)
#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_98_SHIFT (0x00000002u)
#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_98_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_99_MASK (0x00000008u)
#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_99_SHIFT (0x00000003u)
#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_99_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_100_MASK (0x00000010u)
#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_100_SHIFT (0x00000004u)
#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_100_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_101_MASK (0x00000020u)
#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_101_SHIFT (0x00000005u)
#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_101_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_102_MASK (0x00000040u)
#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_102_SHIFT (0x00000006u)
#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_102_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_103_MASK (0x00000080u)
#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_103_SHIFT (0x00000007u)
#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_103_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_104_MASK (0x00000100u)
#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_104_SHIFT (0x00000008u)
#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_104_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_105_MASK (0x00000200u)
#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_105_SHIFT (0x00000009u)
#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_105_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_106_MASK (0x00000400u)
#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_106_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_106_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_107_MASK (0x00000800u)
#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_107_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_107_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_108_MASK (0x00001000u)
#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_108_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_108_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_109_MASK (0x00002000u)
#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_109_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_109_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_110_MASK (0x00004000u)
#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_110_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_110_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_111_MASK (0x00008000u)
#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_111_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_111_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_112_MASK (0x00010000u)
#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_112_SHIFT (0x00000010u)
#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_112_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_113_MASK (0x00020000u)
#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_113_SHIFT (0x00000011u)
#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_113_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_114_MASK (0x00040000u)
#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_114_SHIFT (0x00000012u)
#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_114_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_115_MASK (0x00080000u)
#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_115_SHIFT (0x00000013u)
#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_115_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_116_MASK (0x00100000u)
#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_116_SHIFT (0x00000014u)
#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_116_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_117_MASK (0x00200000u)
#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_117_SHIFT (0x00000015u)
#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_117_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_118_MASK (0x00400000u)
#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_118_SHIFT (0x00000016u)
#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_118_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_119_MASK (0x00800000u)
#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_119_SHIFT (0x00000017u)
#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_119_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_120_MASK (0x01000000u)
#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_120_SHIFT (0x00000018u)
#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_120_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_121_MASK (0x02000000u)
#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_121_SHIFT (0x00000019u)
#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_121_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_122_MASK (0x04000000u)
#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_122_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_122_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_123_MASK (0x08000000u)
#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_123_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_123_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_124_MASK (0x10000000u)
#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_124_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_124_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_125_MASK (0x20000000u)
#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_125_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_125_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_126_MASK (0x40000000u)
#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_126_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_126_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_127_MASK (0x80000000u)
#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_127_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENA_STATUS_REG3_ENA_STATUS_127_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG3_RESETVAL (0x00000000u)

/* ena_status_reg4 */

#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_128_MASK (0x00000001u)
#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_128_SHIFT (0x00000000u)
#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_128_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_129_MASK (0x00000002u)
#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_129_SHIFT (0x00000001u)
#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_129_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_130_MASK (0x00000004u)
#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_130_SHIFT (0x00000002u)
#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_130_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_131_MASK (0x00000008u)
#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_131_SHIFT (0x00000003u)
#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_131_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_132_MASK (0x00000010u)
#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_132_SHIFT (0x00000004u)
#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_132_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_133_MASK (0x00000020u)
#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_133_SHIFT (0x00000005u)
#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_133_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_134_MASK (0x00000040u)
#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_134_SHIFT (0x00000006u)
#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_134_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_135_MASK (0x00000080u)
#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_135_SHIFT (0x00000007u)
#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_135_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_136_MASK (0x00000100u)
#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_136_SHIFT (0x00000008u)
#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_136_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_137_MASK (0x00000200u)
#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_137_SHIFT (0x00000009u)
#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_137_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_138_MASK (0x00000400u)
#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_138_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_138_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_139_MASK (0x00000800u)
#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_139_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_139_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_140_MASK (0x00001000u)
#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_140_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_140_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_141_MASK (0x00002000u)
#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_141_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_141_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_142_MASK (0x00004000u)
#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_142_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_142_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_143_MASK (0x00008000u)
#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_143_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_143_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_144_MASK (0x00010000u)
#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_144_SHIFT (0x00000010u)
#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_144_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_145_MASK (0x00020000u)
#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_145_SHIFT (0x00000011u)
#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_145_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_146_MASK (0x00040000u)
#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_146_SHIFT (0x00000012u)
#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_146_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_147_MASK (0x00080000u)
#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_147_SHIFT (0x00000013u)
#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_147_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_148_MASK (0x00100000u)
#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_148_SHIFT (0x00000014u)
#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_148_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_149_MASK (0x00200000u)
#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_149_SHIFT (0x00000015u)
#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_149_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_150_MASK (0x00400000u)
#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_150_SHIFT (0x00000016u)
#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_150_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_151_MASK (0x00800000u)
#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_151_SHIFT (0x00000017u)
#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_151_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_152_MASK (0x01000000u)
#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_152_SHIFT (0x00000018u)
#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_152_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_153_MASK (0x02000000u)
#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_153_SHIFT (0x00000019u)
#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_153_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_154_MASK (0x04000000u)
#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_154_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_154_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_155_MASK (0x08000000u)
#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_155_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_155_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_156_MASK (0x10000000u)
#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_156_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_156_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_157_MASK (0x20000000u)
#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_157_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_157_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_158_MASK (0x40000000u)
#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_158_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_158_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_159_MASK (0x80000000u)
#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_159_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENA_STATUS_REG4_ENA_STATUS_159_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG4_RESETVAL (0x00000000u)

/* ena_status_reg5 */

#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_160_MASK (0x00000001u)
#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_160_SHIFT (0x00000000u)
#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_160_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_161_MASK (0x00000002u)
#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_161_SHIFT (0x00000001u)
#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_161_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_162_MASK (0x00000004u)
#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_162_SHIFT (0x00000002u)
#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_162_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_163_MASK (0x00000008u)
#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_163_SHIFT (0x00000003u)
#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_163_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_164_MASK (0x00000010u)
#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_164_SHIFT (0x00000004u)
#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_164_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_165_MASK (0x00000020u)
#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_165_SHIFT (0x00000005u)
#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_165_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_166_MASK (0x00000040u)
#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_166_SHIFT (0x00000006u)
#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_166_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_167_MASK (0x00000080u)
#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_167_SHIFT (0x00000007u)
#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_167_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_168_MASK (0x00000100u)
#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_168_SHIFT (0x00000008u)
#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_168_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_169_MASK (0x00000200u)
#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_169_SHIFT (0x00000009u)
#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_169_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_170_MASK (0x00000400u)
#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_170_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_170_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_171_MASK (0x00000800u)
#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_171_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_171_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_172_MASK (0x00001000u)
#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_172_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_172_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_173_MASK (0x00002000u)
#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_173_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_173_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_174_MASK (0x00004000u)
#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_174_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_174_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_175_MASK (0x00008000u)
#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_175_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_175_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_176_MASK (0x00010000u)
#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_176_SHIFT (0x00000010u)
#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_176_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_177_MASK (0x00020000u)
#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_177_SHIFT (0x00000011u)
#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_177_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_178_MASK (0x00040000u)
#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_178_SHIFT (0x00000012u)
#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_178_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_179_MASK (0x00080000u)
#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_179_SHIFT (0x00000013u)
#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_179_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_180_MASK (0x00100000u)
#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_180_SHIFT (0x00000014u)
#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_180_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_181_MASK (0x00200000u)
#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_181_SHIFT (0x00000015u)
#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_181_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_182_MASK (0x00400000u)
#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_182_SHIFT (0x00000016u)
#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_182_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_183_MASK (0x00800000u)
#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_183_SHIFT (0x00000017u)
#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_183_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_184_MASK (0x01000000u)
#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_184_SHIFT (0x00000018u)
#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_184_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_185_MASK (0x02000000u)
#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_185_SHIFT (0x00000019u)
#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_185_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_186_MASK (0x04000000u)
#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_186_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_186_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_187_MASK (0x08000000u)
#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_187_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_187_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_188_MASK (0x10000000u)
#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_188_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_188_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_189_MASK (0x20000000u)
#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_189_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_189_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_190_MASK (0x40000000u)
#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_190_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_190_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_191_MASK (0x80000000u)
#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_191_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENA_STATUS_REG5_ENA_STATUS_191_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG5_RESETVAL (0x00000000u)

/* ena_status_reg6 */

#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_192_MASK (0x00000001u)
#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_192_SHIFT (0x00000000u)
#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_192_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_193_MASK (0x00000002u)
#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_193_SHIFT (0x00000001u)
#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_193_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_194_MASK (0x00000004u)
#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_194_SHIFT (0x00000002u)
#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_194_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_195_MASK (0x00000008u)
#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_195_SHIFT (0x00000003u)
#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_195_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_196_MASK (0x00000010u)
#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_196_SHIFT (0x00000004u)
#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_196_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_197_MASK (0x00000020u)
#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_197_SHIFT (0x00000005u)
#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_197_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_198_MASK (0x00000040u)
#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_198_SHIFT (0x00000006u)
#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_198_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_199_MASK (0x00000080u)
#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_199_SHIFT (0x00000007u)
#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_199_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_200_MASK (0x00000100u)
#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_200_SHIFT (0x00000008u)
#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_200_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_201_MASK (0x00000200u)
#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_201_SHIFT (0x00000009u)
#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_201_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_202_MASK (0x00000400u)
#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_202_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_202_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_203_MASK (0x00000800u)
#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_203_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_203_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_204_MASK (0x00001000u)
#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_204_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_204_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_205_MASK (0x00002000u)
#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_205_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_205_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_206_MASK (0x00004000u)
#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_206_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_206_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_207_MASK (0x00008000u)
#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_207_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_207_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_208_MASK (0x00010000u)
#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_208_SHIFT (0x00000010u)
#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_208_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_209_MASK (0x00020000u)
#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_209_SHIFT (0x00000011u)
#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_209_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_210_MASK (0x00040000u)
#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_210_SHIFT (0x00000012u)
#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_210_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_211_MASK (0x00080000u)
#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_211_SHIFT (0x00000013u)
#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_211_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_212_MASK (0x00100000u)
#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_212_SHIFT (0x00000014u)
#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_212_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_213_MASK (0x00200000u)
#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_213_SHIFT (0x00000015u)
#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_213_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_214_MASK (0x00400000u)
#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_214_SHIFT (0x00000016u)
#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_214_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_215_MASK (0x00800000u)
#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_215_SHIFT (0x00000017u)
#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_215_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_216_MASK (0x01000000u)
#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_216_SHIFT (0x00000018u)
#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_216_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_217_MASK (0x02000000u)
#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_217_SHIFT (0x00000019u)
#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_217_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_218_MASK (0x04000000u)
#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_218_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_218_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_219_MASK (0x08000000u)
#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_219_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_219_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_220_MASK (0x10000000u)
#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_220_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_220_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_221_MASK (0x20000000u)
#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_221_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_221_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_222_MASK (0x40000000u)
#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_222_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_222_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_223_MASK (0x80000000u)
#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_223_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENA_STATUS_REG6_ENA_STATUS_223_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG6_RESETVAL (0x00000000u)

/* ena_status_reg7 */

#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_224_MASK (0x00000001u)
#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_224_SHIFT (0x00000000u)
#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_224_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_225_MASK (0x00000002u)
#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_225_SHIFT (0x00000001u)
#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_225_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_226_MASK (0x00000004u)
#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_226_SHIFT (0x00000002u)
#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_226_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_227_MASK (0x00000008u)
#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_227_SHIFT (0x00000003u)
#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_227_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_228_MASK (0x00000010u)
#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_228_SHIFT (0x00000004u)
#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_228_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_229_MASK (0x00000020u)
#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_229_SHIFT (0x00000005u)
#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_229_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_230_MASK (0x00000040u)
#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_230_SHIFT (0x00000006u)
#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_230_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_231_MASK (0x00000080u)
#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_231_SHIFT (0x00000007u)
#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_231_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_232_MASK (0x00000100u)
#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_232_SHIFT (0x00000008u)
#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_232_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_233_MASK (0x00000200u)
#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_233_SHIFT (0x00000009u)
#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_233_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_234_MASK (0x00000400u)
#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_234_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_234_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_235_MASK (0x00000800u)
#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_235_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_235_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_236_MASK (0x00001000u)
#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_236_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_236_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_237_MASK (0x00002000u)
#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_237_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_237_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_238_MASK (0x00004000u)
#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_238_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_238_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_239_MASK (0x00008000u)
#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_239_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_239_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_240_MASK (0x00010000u)
#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_240_SHIFT (0x00000010u)
#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_240_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_241_MASK (0x00020000u)
#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_241_SHIFT (0x00000011u)
#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_241_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_242_MASK (0x00040000u)
#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_242_SHIFT (0x00000012u)
#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_242_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_243_MASK (0x00080000u)
#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_243_SHIFT (0x00000013u)
#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_243_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_244_MASK (0x00100000u)
#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_244_SHIFT (0x00000014u)
#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_244_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_245_MASK (0x00200000u)
#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_245_SHIFT (0x00000015u)
#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_245_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_246_MASK (0x00400000u)
#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_246_SHIFT (0x00000016u)
#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_246_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_247_MASK (0x00800000u)
#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_247_SHIFT (0x00000017u)
#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_247_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_248_MASK (0x01000000u)
#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_248_SHIFT (0x00000018u)
#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_248_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_249_MASK (0x02000000u)
#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_249_SHIFT (0x00000019u)
#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_249_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_250_MASK (0x04000000u)
#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_250_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_250_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_251_MASK (0x08000000u)
#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_251_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_251_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_252_MASK (0x10000000u)
#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_252_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_252_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_253_MASK (0x20000000u)
#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_253_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_253_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_254_MASK (0x40000000u)
#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_254_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_254_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_255_MASK (0x80000000u)
#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_255_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENA_STATUS_REG7_ENA_STATUS_255_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG7_RESETVAL (0x00000000u)

/* ena_status_reg8 */

#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_256_MASK (0x00000001u)
#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_256_SHIFT (0x00000000u)
#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_256_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_257_MASK (0x00000002u)
#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_257_SHIFT (0x00000001u)
#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_257_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_258_MASK (0x00000004u)
#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_258_SHIFT (0x00000002u)
#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_258_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_259_MASK (0x00000008u)
#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_259_SHIFT (0x00000003u)
#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_259_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_260_MASK (0x00000010u)
#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_260_SHIFT (0x00000004u)
#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_260_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_261_MASK (0x00000020u)
#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_261_SHIFT (0x00000005u)
#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_261_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_262_MASK (0x00000040u)
#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_262_SHIFT (0x00000006u)
#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_262_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_263_MASK (0x00000080u)
#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_263_SHIFT (0x00000007u)
#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_263_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_264_MASK (0x00000100u)
#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_264_SHIFT (0x00000008u)
#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_264_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_265_MASK (0x00000200u)
#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_265_SHIFT (0x00000009u)
#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_265_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_266_MASK (0x00000400u)
#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_266_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_266_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_267_MASK (0x00000800u)
#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_267_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_267_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_268_MASK (0x00001000u)
#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_268_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_268_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_269_MASK (0x00002000u)
#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_269_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_269_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_270_MASK (0x00004000u)
#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_270_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_270_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_271_MASK (0x00008000u)
#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_271_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_271_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_272_MASK (0x00010000u)
#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_272_SHIFT (0x00000010u)
#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_272_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_273_MASK (0x00020000u)
#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_273_SHIFT (0x00000011u)
#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_273_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_274_MASK (0x00040000u)
#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_274_SHIFT (0x00000012u)
#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_274_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_275_MASK (0x00080000u)
#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_275_SHIFT (0x00000013u)
#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_275_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_276_MASK (0x00100000u)
#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_276_SHIFT (0x00000014u)
#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_276_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_277_MASK (0x00200000u)
#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_277_SHIFT (0x00000015u)
#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_277_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_278_MASK (0x00400000u)
#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_278_SHIFT (0x00000016u)
#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_278_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_279_MASK (0x00800000u)
#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_279_SHIFT (0x00000017u)
#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_279_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_280_MASK (0x01000000u)
#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_280_SHIFT (0x00000018u)
#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_280_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_281_MASK (0x02000000u)
#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_281_SHIFT (0x00000019u)
#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_281_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_282_MASK (0x04000000u)
#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_282_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_282_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_283_MASK (0x08000000u)
#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_283_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_283_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_284_MASK (0x10000000u)
#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_284_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_284_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_285_MASK (0x20000000u)
#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_285_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_285_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_286_MASK (0x40000000u)
#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_286_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_286_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_287_MASK (0x80000000u)
#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_287_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENA_STATUS_REG8_ENA_STATUS_287_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG8_RESETVAL (0x00000000u)

/* ena_status_reg9 */

#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_288_MASK (0x00000001u)
#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_288_SHIFT (0x00000000u)
#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_288_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_289_MASK (0x00000002u)
#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_289_SHIFT (0x00000001u)
#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_289_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_290_MASK (0x00000004u)
#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_290_SHIFT (0x00000002u)
#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_290_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_291_MASK (0x00000008u)
#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_291_SHIFT (0x00000003u)
#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_291_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_292_MASK (0x00000010u)
#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_292_SHIFT (0x00000004u)
#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_292_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_293_MASK (0x00000020u)
#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_293_SHIFT (0x00000005u)
#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_293_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_294_MASK (0x00000040u)
#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_294_SHIFT (0x00000006u)
#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_294_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_295_MASK (0x00000080u)
#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_295_SHIFT (0x00000007u)
#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_295_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_296_MASK (0x00000100u)
#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_296_SHIFT (0x00000008u)
#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_296_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_297_MASK (0x00000200u)
#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_297_SHIFT (0x00000009u)
#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_297_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_298_MASK (0x00000400u)
#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_298_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_298_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_299_MASK (0x00000800u)
#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_299_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_299_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_300_MASK (0x00001000u)
#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_300_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_300_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_301_MASK (0x00002000u)
#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_301_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_301_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_302_MASK (0x00004000u)
#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_302_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_302_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_303_MASK (0x00008000u)
#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_303_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_303_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_304_MASK (0x00010000u)
#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_304_SHIFT (0x00000010u)
#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_304_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_305_MASK (0x00020000u)
#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_305_SHIFT (0x00000011u)
#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_305_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_306_MASK (0x00040000u)
#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_306_SHIFT (0x00000012u)
#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_306_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_307_MASK (0x00080000u)
#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_307_SHIFT (0x00000013u)
#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_307_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_308_MASK (0x00100000u)
#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_308_SHIFT (0x00000014u)
#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_308_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_309_MASK (0x00200000u)
#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_309_SHIFT (0x00000015u)
#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_309_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_310_MASK (0x00400000u)
#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_310_SHIFT (0x00000016u)
#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_310_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_311_MASK (0x00800000u)
#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_311_SHIFT (0x00000017u)
#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_311_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_312_MASK (0x01000000u)
#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_312_SHIFT (0x00000018u)
#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_312_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_313_MASK (0x02000000u)
#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_313_SHIFT (0x00000019u)
#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_313_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_314_MASK (0x04000000u)
#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_314_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_314_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_315_MASK (0x08000000u)
#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_315_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_315_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_316_MASK (0x10000000u)
#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_316_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_316_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_317_MASK (0x20000000u)
#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_317_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_317_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_318_MASK (0x40000000u)
#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_318_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_318_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_319_MASK (0x80000000u)
#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_319_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENA_STATUS_REG9_ENA_STATUS_319_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG9_RESETVAL (0x00000000u)

/* ena_status_reg10 */

#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_320_MASK (0x00000001u)
#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_320_SHIFT (0x00000000u)
#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_320_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_321_MASK (0x00000002u)
#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_321_SHIFT (0x00000001u)
#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_321_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_322_MASK (0x00000004u)
#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_322_SHIFT (0x00000002u)
#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_322_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_323_MASK (0x00000008u)
#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_323_SHIFT (0x00000003u)
#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_323_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_324_MASK (0x00000010u)
#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_324_SHIFT (0x00000004u)
#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_324_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_325_MASK (0x00000020u)
#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_325_SHIFT (0x00000005u)
#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_325_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_326_MASK (0x00000040u)
#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_326_SHIFT (0x00000006u)
#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_326_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_327_MASK (0x00000080u)
#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_327_SHIFT (0x00000007u)
#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_327_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_328_MASK (0x00000100u)
#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_328_SHIFT (0x00000008u)
#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_328_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_329_MASK (0x00000200u)
#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_329_SHIFT (0x00000009u)
#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_329_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_330_MASK (0x00000400u)
#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_330_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_330_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_331_MASK (0x00000800u)
#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_331_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_331_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_332_MASK (0x00001000u)
#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_332_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_332_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_333_MASK (0x00002000u)
#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_333_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_333_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_334_MASK (0x00004000u)
#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_334_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_334_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_335_MASK (0x00008000u)
#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_335_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_335_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_336_MASK (0x00010000u)
#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_336_SHIFT (0x00000010u)
#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_336_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_337_MASK (0x00020000u)
#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_337_SHIFT (0x00000011u)
#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_337_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_338_MASK (0x00040000u)
#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_338_SHIFT (0x00000012u)
#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_338_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_339_MASK (0x00080000u)
#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_339_SHIFT (0x00000013u)
#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_339_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_340_MASK (0x00100000u)
#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_340_SHIFT (0x00000014u)
#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_340_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_341_MASK (0x00200000u)
#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_341_SHIFT (0x00000015u)
#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_341_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_342_MASK (0x00400000u)
#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_342_SHIFT (0x00000016u)
#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_342_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_343_MASK (0x00800000u)
#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_343_SHIFT (0x00000017u)
#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_343_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_344_MASK (0x01000000u)
#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_344_SHIFT (0x00000018u)
#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_344_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_345_MASK (0x02000000u)
#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_345_SHIFT (0x00000019u)
#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_345_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_346_MASK (0x04000000u)
#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_346_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_346_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_347_MASK (0x08000000u)
#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_347_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_347_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_348_MASK (0x10000000u)
#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_348_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_348_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_349_MASK (0x20000000u)
#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_349_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_349_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_350_MASK (0x40000000u)
#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_350_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_350_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_351_MASK (0x80000000u)
#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_351_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENA_STATUS_REG10_ENA_STATUS_351_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG10_RESETVAL (0x00000000u)

/* ena_status_reg11 */

#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_352_MASK (0x00000001u)
#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_352_SHIFT (0x00000000u)
#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_352_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_353_MASK (0x00000002u)
#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_353_SHIFT (0x00000001u)
#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_353_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_354_MASK (0x00000004u)
#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_354_SHIFT (0x00000002u)
#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_354_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_355_MASK (0x00000008u)
#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_355_SHIFT (0x00000003u)
#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_355_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_356_MASK (0x00000010u)
#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_356_SHIFT (0x00000004u)
#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_356_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_357_MASK (0x00000020u)
#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_357_SHIFT (0x00000005u)
#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_357_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_358_MASK (0x00000040u)
#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_358_SHIFT (0x00000006u)
#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_358_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_359_MASK (0x00000080u)
#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_359_SHIFT (0x00000007u)
#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_359_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_360_MASK (0x00000100u)
#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_360_SHIFT (0x00000008u)
#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_360_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_361_MASK (0x00000200u)
#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_361_SHIFT (0x00000009u)
#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_361_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_362_MASK (0x00000400u)
#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_362_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_362_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_363_MASK (0x00000800u)
#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_363_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_363_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_364_MASK (0x00001000u)
#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_364_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_364_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_365_MASK (0x00002000u)
#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_365_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_365_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_366_MASK (0x00004000u)
#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_366_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_366_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_367_MASK (0x00008000u)
#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_367_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_367_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_368_MASK (0x00010000u)
#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_368_SHIFT (0x00000010u)
#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_368_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_369_MASK (0x00020000u)
#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_369_SHIFT (0x00000011u)
#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_369_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_370_MASK (0x00040000u)
#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_370_SHIFT (0x00000012u)
#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_370_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_371_MASK (0x00080000u)
#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_371_SHIFT (0x00000013u)
#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_371_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_372_MASK (0x00100000u)
#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_372_SHIFT (0x00000014u)
#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_372_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_373_MASK (0x00200000u)
#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_373_SHIFT (0x00000015u)
#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_373_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_374_MASK (0x00400000u)
#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_374_SHIFT (0x00000016u)
#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_374_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_375_MASK (0x00800000u)
#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_375_SHIFT (0x00000017u)
#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_375_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_376_MASK (0x01000000u)
#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_376_SHIFT (0x00000018u)
#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_376_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_377_MASK (0x02000000u)
#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_377_SHIFT (0x00000019u)
#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_377_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_378_MASK (0x04000000u)
#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_378_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_378_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_379_MASK (0x08000000u)
#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_379_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_379_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_380_MASK (0x10000000u)
#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_380_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_380_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_381_MASK (0x20000000u)
#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_381_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_381_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_382_MASK (0x40000000u)
#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_382_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_382_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_383_MASK (0x80000000u)
#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_383_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENA_STATUS_REG11_ENA_STATUS_383_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG11_RESETVAL (0x00000000u)

/* ena_status_reg12 */

#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_384_MASK (0x00000001u)
#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_384_SHIFT (0x00000000u)
#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_384_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_385_MASK (0x00000002u)
#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_385_SHIFT (0x00000001u)
#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_385_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_386_MASK (0x00000004u)
#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_386_SHIFT (0x00000002u)
#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_386_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_387_MASK (0x00000008u)
#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_387_SHIFT (0x00000003u)
#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_387_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_388_MASK (0x00000010u)
#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_388_SHIFT (0x00000004u)
#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_388_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_389_MASK (0x00000020u)
#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_389_SHIFT (0x00000005u)
#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_389_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_390_MASK (0x00000040u)
#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_390_SHIFT (0x00000006u)
#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_390_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_391_MASK (0x00000080u)
#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_391_SHIFT (0x00000007u)
#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_391_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_392_MASK (0x00000100u)
#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_392_SHIFT (0x00000008u)
#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_392_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_393_MASK (0x00000200u)
#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_393_SHIFT (0x00000009u)
#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_393_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_394_MASK (0x00000400u)
#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_394_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_394_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_395_MASK (0x00000800u)
#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_395_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_395_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_396_MASK (0x00001000u)
#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_396_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_396_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_397_MASK (0x00002000u)
#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_397_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_397_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_398_MASK (0x00004000u)
#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_398_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_398_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_399_MASK (0x00008000u)
#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_399_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_399_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_400_MASK (0x00010000u)
#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_400_SHIFT (0x00000010u)
#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_400_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_401_MASK (0x00020000u)
#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_401_SHIFT (0x00000011u)
#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_401_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_402_MASK (0x00040000u)
#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_402_SHIFT (0x00000012u)
#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_402_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_403_MASK (0x00080000u)
#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_403_SHIFT (0x00000013u)
#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_403_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_404_MASK (0x00100000u)
#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_404_SHIFT (0x00000014u)
#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_404_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_405_MASK (0x00200000u)
#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_405_SHIFT (0x00000015u)
#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_405_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_406_MASK (0x00400000u)
#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_406_SHIFT (0x00000016u)
#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_406_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_407_MASK (0x00800000u)
#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_407_SHIFT (0x00000017u)
#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_407_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_408_MASK (0x01000000u)
#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_408_SHIFT (0x00000018u)
#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_408_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_409_MASK (0x02000000u)
#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_409_SHIFT (0x00000019u)
#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_409_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_410_MASK (0x04000000u)
#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_410_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_410_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_411_MASK (0x08000000u)
#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_411_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_411_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_412_MASK (0x10000000u)
#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_412_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_412_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_413_MASK (0x20000000u)
#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_413_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_413_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_414_MASK (0x40000000u)
#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_414_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_414_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_415_MASK (0x80000000u)
#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_415_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENA_STATUS_REG12_ENA_STATUS_415_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG12_RESETVAL (0x00000000u)

/* ena_status_reg13 */

#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_416_MASK (0x00000001u)
#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_416_SHIFT (0x00000000u)
#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_416_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_417_MASK (0x00000002u)
#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_417_SHIFT (0x00000001u)
#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_417_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_418_MASK (0x00000004u)
#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_418_SHIFT (0x00000002u)
#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_418_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_419_MASK (0x00000008u)
#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_419_SHIFT (0x00000003u)
#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_419_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_420_MASK (0x00000010u)
#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_420_SHIFT (0x00000004u)
#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_420_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_421_MASK (0x00000020u)
#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_421_SHIFT (0x00000005u)
#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_421_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_422_MASK (0x00000040u)
#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_422_SHIFT (0x00000006u)
#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_422_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_423_MASK (0x00000080u)
#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_423_SHIFT (0x00000007u)
#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_423_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_424_MASK (0x00000100u)
#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_424_SHIFT (0x00000008u)
#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_424_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_425_MASK (0x00000200u)
#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_425_SHIFT (0x00000009u)
#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_425_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_426_MASK (0x00000400u)
#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_426_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_426_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_427_MASK (0x00000800u)
#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_427_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_427_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_428_MASK (0x00001000u)
#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_428_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_428_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_429_MASK (0x00002000u)
#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_429_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_429_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_430_MASK (0x00004000u)
#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_430_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_430_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_431_MASK (0x00008000u)
#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_431_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_431_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_432_MASK (0x00010000u)
#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_432_SHIFT (0x00000010u)
#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_432_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_433_MASK (0x00020000u)
#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_433_SHIFT (0x00000011u)
#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_433_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_434_MASK (0x00040000u)
#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_434_SHIFT (0x00000012u)
#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_434_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_435_MASK (0x00080000u)
#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_435_SHIFT (0x00000013u)
#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_435_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_436_MASK (0x00100000u)
#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_436_SHIFT (0x00000014u)
#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_436_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_437_MASK (0x00200000u)
#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_437_SHIFT (0x00000015u)
#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_437_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_438_MASK (0x00400000u)
#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_438_SHIFT (0x00000016u)
#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_438_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_439_MASK (0x00800000u)
#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_439_SHIFT (0x00000017u)
#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_439_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_440_MASK (0x01000000u)
#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_440_SHIFT (0x00000018u)
#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_440_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_441_MASK (0x02000000u)
#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_441_SHIFT (0x00000019u)
#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_441_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_442_MASK (0x04000000u)
#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_442_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_442_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_443_MASK (0x08000000u)
#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_443_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_443_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_444_MASK (0x10000000u)
#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_444_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_444_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_445_MASK (0x20000000u)
#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_445_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_445_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_446_MASK (0x40000000u)
#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_446_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_446_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_447_MASK (0x80000000u)
#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_447_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENA_STATUS_REG13_ENA_STATUS_447_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG13_RESETVAL (0x00000000u)

/* ena_status_reg14 */

#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_448_MASK (0x00000001u)
#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_448_SHIFT (0x00000000u)
#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_448_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_449_MASK (0x00000002u)
#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_449_SHIFT (0x00000001u)
#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_449_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_450_MASK (0x00000004u)
#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_450_SHIFT (0x00000002u)
#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_450_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_451_MASK (0x00000008u)
#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_451_SHIFT (0x00000003u)
#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_451_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_452_MASK (0x00000010u)
#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_452_SHIFT (0x00000004u)
#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_452_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_453_MASK (0x00000020u)
#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_453_SHIFT (0x00000005u)
#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_453_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_454_MASK (0x00000040u)
#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_454_SHIFT (0x00000006u)
#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_454_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_455_MASK (0x00000080u)
#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_455_SHIFT (0x00000007u)
#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_455_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_456_MASK (0x00000100u)
#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_456_SHIFT (0x00000008u)
#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_456_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_457_MASK (0x00000200u)
#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_457_SHIFT (0x00000009u)
#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_457_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_458_MASK (0x00000400u)
#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_458_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_458_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_459_MASK (0x00000800u)
#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_459_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_459_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_460_MASK (0x00001000u)
#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_460_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_460_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_461_MASK (0x00002000u)
#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_461_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_461_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_462_MASK (0x00004000u)
#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_462_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_462_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_463_MASK (0x00008000u)
#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_463_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_463_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_464_MASK (0x00010000u)
#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_464_SHIFT (0x00000010u)
#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_464_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_465_MASK (0x00020000u)
#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_465_SHIFT (0x00000011u)
#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_465_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_466_MASK (0x00040000u)
#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_466_SHIFT (0x00000012u)
#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_466_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_467_MASK (0x00080000u)
#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_467_SHIFT (0x00000013u)
#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_467_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_468_MASK (0x00100000u)
#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_468_SHIFT (0x00000014u)
#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_468_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_469_MASK (0x00200000u)
#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_469_SHIFT (0x00000015u)
#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_469_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_470_MASK (0x00400000u)
#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_470_SHIFT (0x00000016u)
#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_470_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_471_MASK (0x00800000u)
#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_471_SHIFT (0x00000017u)
#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_471_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_472_MASK (0x01000000u)
#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_472_SHIFT (0x00000018u)
#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_472_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_473_MASK (0x02000000u)
#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_473_SHIFT (0x00000019u)
#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_473_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_474_MASK (0x04000000u)
#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_474_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_474_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_475_MASK (0x08000000u)
#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_475_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_475_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_476_MASK (0x10000000u)
#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_476_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_476_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_477_MASK (0x20000000u)
#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_477_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_477_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_478_MASK (0x40000000u)
#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_478_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_478_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_479_MASK (0x80000000u)
#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_479_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENA_STATUS_REG14_ENA_STATUS_479_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG14_RESETVAL (0x00000000u)

/* ena_status_reg15 */

#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_480_MASK (0x00000001u)
#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_480_SHIFT (0x00000000u)
#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_480_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_481_MASK (0x00000002u)
#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_481_SHIFT (0x00000001u)
#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_481_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_482_MASK (0x00000004u)
#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_482_SHIFT (0x00000002u)
#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_482_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_483_MASK (0x00000008u)
#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_483_SHIFT (0x00000003u)
#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_483_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_484_MASK (0x00000010u)
#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_484_SHIFT (0x00000004u)
#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_484_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_485_MASK (0x00000020u)
#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_485_SHIFT (0x00000005u)
#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_485_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_486_MASK (0x00000040u)
#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_486_SHIFT (0x00000006u)
#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_486_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_487_MASK (0x00000080u)
#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_487_SHIFT (0x00000007u)
#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_487_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_488_MASK (0x00000100u)
#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_488_SHIFT (0x00000008u)
#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_488_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_489_MASK (0x00000200u)
#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_489_SHIFT (0x00000009u)
#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_489_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_490_MASK (0x00000400u)
#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_490_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_490_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_491_MASK (0x00000800u)
#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_491_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_491_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_492_MASK (0x00001000u)
#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_492_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_492_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_493_MASK (0x00002000u)
#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_493_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_493_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_494_MASK (0x00004000u)
#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_494_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_494_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_495_MASK (0x00008000u)
#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_495_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_495_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_496_MASK (0x00010000u)
#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_496_SHIFT (0x00000010u)
#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_496_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_497_MASK (0x00020000u)
#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_497_SHIFT (0x00000011u)
#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_497_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_498_MASK (0x00040000u)
#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_498_SHIFT (0x00000012u)
#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_498_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_499_MASK (0x00080000u)
#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_499_SHIFT (0x00000013u)
#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_499_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_500_MASK (0x00100000u)
#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_500_SHIFT (0x00000014u)
#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_500_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_501_MASK (0x00200000u)
#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_501_SHIFT (0x00000015u)
#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_501_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_502_MASK (0x00400000u)
#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_502_SHIFT (0x00000016u)
#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_502_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_503_MASK (0x00800000u)
#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_503_SHIFT (0x00000017u)
#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_503_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_504_MASK (0x01000000u)
#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_504_SHIFT (0x00000018u)
#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_504_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_505_MASK (0x02000000u)
#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_505_SHIFT (0x00000019u)
#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_505_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_506_MASK (0x04000000u)
#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_506_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_506_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_507_MASK (0x08000000u)
#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_507_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_507_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_508_MASK (0x10000000u)
#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_508_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_508_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_509_MASK (0x20000000u)
#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_509_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_509_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_510_MASK (0x40000000u)
#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_510_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_510_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_511_MASK (0x80000000u)
#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_511_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENA_STATUS_REG15_ENA_STATUS_511_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG15_RESETVAL (0x00000000u)

/* ena_status_reg16 */

#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_512_MASK (0x00000001u)
#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_512_SHIFT (0x00000000u)
#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_512_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_513_MASK (0x00000002u)
#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_513_SHIFT (0x00000001u)
#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_513_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_514_MASK (0x00000004u)
#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_514_SHIFT (0x00000002u)
#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_514_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_515_MASK (0x00000008u)
#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_515_SHIFT (0x00000003u)
#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_515_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_516_MASK (0x00000010u)
#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_516_SHIFT (0x00000004u)
#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_516_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_517_MASK (0x00000020u)
#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_517_SHIFT (0x00000005u)
#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_517_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_518_MASK (0x00000040u)
#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_518_SHIFT (0x00000006u)
#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_518_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_519_MASK (0x00000080u)
#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_519_SHIFT (0x00000007u)
#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_519_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_520_MASK (0x00000100u)
#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_520_SHIFT (0x00000008u)
#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_520_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_521_MASK (0x00000200u)
#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_521_SHIFT (0x00000009u)
#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_521_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_522_MASK (0x00000400u)
#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_522_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_522_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_523_MASK (0x00000800u)
#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_523_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_523_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_524_MASK (0x00001000u)
#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_524_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_524_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_525_MASK (0x00002000u)
#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_525_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_525_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_526_MASK (0x00004000u)
#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_526_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_526_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_527_MASK (0x00008000u)
#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_527_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_527_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_528_MASK (0x00010000u)
#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_528_SHIFT (0x00000010u)
#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_528_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_529_MASK (0x00020000u)
#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_529_SHIFT (0x00000011u)
#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_529_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_530_MASK (0x00040000u)
#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_530_SHIFT (0x00000012u)
#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_530_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_531_MASK (0x00080000u)
#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_531_SHIFT (0x00000013u)
#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_531_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_532_MASK (0x00100000u)
#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_532_SHIFT (0x00000014u)
#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_532_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_533_MASK (0x00200000u)
#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_533_SHIFT (0x00000015u)
#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_533_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_534_MASK (0x00400000u)
#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_534_SHIFT (0x00000016u)
#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_534_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_535_MASK (0x00800000u)
#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_535_SHIFT (0x00000017u)
#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_535_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_536_MASK (0x01000000u)
#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_536_SHIFT (0x00000018u)
#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_536_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_537_MASK (0x02000000u)
#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_537_SHIFT (0x00000019u)
#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_537_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_538_MASK (0x04000000u)
#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_538_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_538_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_539_MASK (0x08000000u)
#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_539_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_539_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_540_MASK (0x10000000u)
#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_540_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_540_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_541_MASK (0x20000000u)
#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_541_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_541_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_542_MASK (0x40000000u)
#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_542_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_542_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_543_MASK (0x80000000u)
#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_543_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENA_STATUS_REG16_ENA_STATUS_543_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG16_RESETVAL (0x00000000u)

/* ena_status_reg17 */

#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_544_MASK (0x00000001u)
#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_544_SHIFT (0x00000000u)
#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_544_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_545_MASK (0x00000002u)
#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_545_SHIFT (0x00000001u)
#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_545_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_546_MASK (0x00000004u)
#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_546_SHIFT (0x00000002u)
#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_546_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_547_MASK (0x00000008u)
#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_547_SHIFT (0x00000003u)
#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_547_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_548_MASK (0x00000010u)
#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_548_SHIFT (0x00000004u)
#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_548_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_549_MASK (0x00000020u)
#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_549_SHIFT (0x00000005u)
#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_549_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_550_MASK (0x00000040u)
#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_550_SHIFT (0x00000006u)
#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_550_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_551_MASK (0x00000080u)
#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_551_SHIFT (0x00000007u)
#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_551_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_552_MASK (0x00000100u)
#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_552_SHIFT (0x00000008u)
#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_552_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_553_MASK (0x00000200u)
#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_553_SHIFT (0x00000009u)
#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_553_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_554_MASK (0x00000400u)
#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_554_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_554_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_555_MASK (0x00000800u)
#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_555_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_555_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_556_MASK (0x00001000u)
#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_556_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_556_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_557_MASK (0x00002000u)
#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_557_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_557_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_558_MASK (0x00004000u)
#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_558_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_558_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_559_MASK (0x00008000u)
#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_559_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_559_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_560_MASK (0x00010000u)
#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_560_SHIFT (0x00000010u)
#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_560_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_561_MASK (0x00020000u)
#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_561_SHIFT (0x00000011u)
#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_561_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_562_MASK (0x00040000u)
#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_562_SHIFT (0x00000012u)
#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_562_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_563_MASK (0x00080000u)
#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_563_SHIFT (0x00000013u)
#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_563_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_564_MASK (0x00100000u)
#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_564_SHIFT (0x00000014u)
#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_564_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_565_MASK (0x00200000u)
#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_565_SHIFT (0x00000015u)
#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_565_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_566_MASK (0x00400000u)
#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_566_SHIFT (0x00000016u)
#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_566_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_567_MASK (0x00800000u)
#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_567_SHIFT (0x00000017u)
#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_567_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_568_MASK (0x01000000u)
#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_568_SHIFT (0x00000018u)
#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_568_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_569_MASK (0x02000000u)
#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_569_SHIFT (0x00000019u)
#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_569_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_570_MASK (0x04000000u)
#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_570_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_570_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_571_MASK (0x08000000u)
#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_571_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_571_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_572_MASK (0x10000000u)
#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_572_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_572_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_573_MASK (0x20000000u)
#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_573_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_573_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_574_MASK (0x40000000u)
#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_574_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_574_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_575_MASK (0x80000000u)
#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_575_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENA_STATUS_REG17_ENA_STATUS_575_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG17_RESETVAL (0x00000000u)

/* ena_status_reg18 */

#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_576_MASK (0x00000001u)
#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_576_SHIFT (0x00000000u)
#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_576_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_577_MASK (0x00000002u)
#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_577_SHIFT (0x00000001u)
#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_577_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_578_MASK (0x00000004u)
#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_578_SHIFT (0x00000002u)
#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_578_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_579_MASK (0x00000008u)
#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_579_SHIFT (0x00000003u)
#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_579_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_580_MASK (0x00000010u)
#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_580_SHIFT (0x00000004u)
#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_580_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_581_MASK (0x00000020u)
#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_581_SHIFT (0x00000005u)
#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_581_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_582_MASK (0x00000040u)
#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_582_SHIFT (0x00000006u)
#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_582_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_583_MASK (0x00000080u)
#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_583_SHIFT (0x00000007u)
#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_583_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_584_MASK (0x00000100u)
#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_584_SHIFT (0x00000008u)
#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_584_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_585_MASK (0x00000200u)
#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_585_SHIFT (0x00000009u)
#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_585_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_586_MASK (0x00000400u)
#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_586_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_586_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_587_MASK (0x00000800u)
#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_587_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_587_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_588_MASK (0x00001000u)
#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_588_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_588_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_589_MASK (0x00002000u)
#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_589_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_589_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_590_MASK (0x00004000u)
#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_590_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_590_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_591_MASK (0x00008000u)
#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_591_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_591_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_592_MASK (0x00010000u)
#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_592_SHIFT (0x00000010u)
#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_592_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_593_MASK (0x00020000u)
#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_593_SHIFT (0x00000011u)
#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_593_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_594_MASK (0x00040000u)
#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_594_SHIFT (0x00000012u)
#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_594_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_595_MASK (0x00080000u)
#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_595_SHIFT (0x00000013u)
#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_595_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_596_MASK (0x00100000u)
#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_596_SHIFT (0x00000014u)
#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_596_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_597_MASK (0x00200000u)
#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_597_SHIFT (0x00000015u)
#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_597_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_598_MASK (0x00400000u)
#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_598_SHIFT (0x00000016u)
#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_598_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_599_MASK (0x00800000u)
#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_599_SHIFT (0x00000017u)
#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_599_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_600_MASK (0x01000000u)
#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_600_SHIFT (0x00000018u)
#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_600_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_601_MASK (0x02000000u)
#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_601_SHIFT (0x00000019u)
#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_601_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_602_MASK (0x04000000u)
#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_602_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_602_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_603_MASK (0x08000000u)
#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_603_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_603_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_604_MASK (0x10000000u)
#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_604_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_604_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_605_MASK (0x20000000u)
#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_605_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_605_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_606_MASK (0x40000000u)
#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_606_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_606_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_607_MASK (0x80000000u)
#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_607_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENA_STATUS_REG18_ENA_STATUS_607_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG18_RESETVAL (0x00000000u)

/* ena_status_reg19 */

#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_608_MASK (0x00000001u)
#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_608_SHIFT (0x00000000u)
#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_608_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_609_MASK (0x00000002u)
#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_609_SHIFT (0x00000001u)
#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_609_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_610_MASK (0x00000004u)
#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_610_SHIFT (0x00000002u)
#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_610_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_611_MASK (0x00000008u)
#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_611_SHIFT (0x00000003u)
#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_611_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_612_MASK (0x00000010u)
#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_612_SHIFT (0x00000004u)
#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_612_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_613_MASK (0x00000020u)
#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_613_SHIFT (0x00000005u)
#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_613_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_614_MASK (0x00000040u)
#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_614_SHIFT (0x00000006u)
#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_614_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_615_MASK (0x00000080u)
#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_615_SHIFT (0x00000007u)
#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_615_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_616_MASK (0x00000100u)
#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_616_SHIFT (0x00000008u)
#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_616_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_617_MASK (0x00000200u)
#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_617_SHIFT (0x00000009u)
#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_617_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_618_MASK (0x00000400u)
#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_618_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_618_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_619_MASK (0x00000800u)
#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_619_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_619_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_620_MASK (0x00001000u)
#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_620_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_620_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_621_MASK (0x00002000u)
#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_621_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_621_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_622_MASK (0x00004000u)
#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_622_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_622_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_623_MASK (0x00008000u)
#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_623_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_623_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_624_MASK (0x00010000u)
#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_624_SHIFT (0x00000010u)
#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_624_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_625_MASK (0x00020000u)
#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_625_SHIFT (0x00000011u)
#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_625_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_626_MASK (0x00040000u)
#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_626_SHIFT (0x00000012u)
#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_626_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_627_MASK (0x00080000u)
#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_627_SHIFT (0x00000013u)
#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_627_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_628_MASK (0x00100000u)
#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_628_SHIFT (0x00000014u)
#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_628_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_629_MASK (0x00200000u)
#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_629_SHIFT (0x00000015u)
#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_629_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_630_MASK (0x00400000u)
#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_630_SHIFT (0x00000016u)
#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_630_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_631_MASK (0x00800000u)
#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_631_SHIFT (0x00000017u)
#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_631_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_632_MASK (0x01000000u)
#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_632_SHIFT (0x00000018u)
#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_632_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_633_MASK (0x02000000u)
#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_633_SHIFT (0x00000019u)
#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_633_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_634_MASK (0x04000000u)
#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_634_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_634_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_635_MASK (0x08000000u)
#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_635_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_635_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_636_MASK (0x10000000u)
#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_636_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_636_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_637_MASK (0x20000000u)
#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_637_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_637_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_638_MASK (0x40000000u)
#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_638_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_638_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_639_MASK (0x80000000u)
#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_639_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENA_STATUS_REG19_ENA_STATUS_639_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG19_RESETVAL (0x00000000u)

/* ena_status_reg20 */

#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_640_MASK (0x00000001u)
#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_640_SHIFT (0x00000000u)
#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_640_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_641_MASK (0x00000002u)
#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_641_SHIFT (0x00000001u)
#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_641_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_642_MASK (0x00000004u)
#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_642_SHIFT (0x00000002u)
#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_642_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_643_MASK (0x00000008u)
#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_643_SHIFT (0x00000003u)
#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_643_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_644_MASK (0x00000010u)
#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_644_SHIFT (0x00000004u)
#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_644_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_645_MASK (0x00000020u)
#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_645_SHIFT (0x00000005u)
#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_645_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_646_MASK (0x00000040u)
#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_646_SHIFT (0x00000006u)
#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_646_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_647_MASK (0x00000080u)
#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_647_SHIFT (0x00000007u)
#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_647_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_648_MASK (0x00000100u)
#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_648_SHIFT (0x00000008u)
#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_648_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_649_MASK (0x00000200u)
#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_649_SHIFT (0x00000009u)
#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_649_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_650_MASK (0x00000400u)
#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_650_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_650_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_651_MASK (0x00000800u)
#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_651_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_651_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_652_MASK (0x00001000u)
#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_652_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_652_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_653_MASK (0x00002000u)
#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_653_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_653_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_654_MASK (0x00004000u)
#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_654_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_654_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_655_MASK (0x00008000u)
#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_655_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_655_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_656_MASK (0x00010000u)
#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_656_SHIFT (0x00000010u)
#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_656_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_657_MASK (0x00020000u)
#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_657_SHIFT (0x00000011u)
#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_657_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_658_MASK (0x00040000u)
#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_658_SHIFT (0x00000012u)
#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_658_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_659_MASK (0x00080000u)
#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_659_SHIFT (0x00000013u)
#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_659_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_660_MASK (0x00100000u)
#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_660_SHIFT (0x00000014u)
#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_660_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_661_MASK (0x00200000u)
#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_661_SHIFT (0x00000015u)
#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_661_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_662_MASK (0x00400000u)
#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_662_SHIFT (0x00000016u)
#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_662_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_663_MASK (0x00800000u)
#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_663_SHIFT (0x00000017u)
#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_663_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_664_MASK (0x01000000u)
#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_664_SHIFT (0x00000018u)
#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_664_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_665_MASK (0x02000000u)
#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_665_SHIFT (0x00000019u)
#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_665_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_666_MASK (0x04000000u)
#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_666_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_666_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_667_MASK (0x08000000u)
#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_667_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_667_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_668_MASK (0x10000000u)
#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_668_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_668_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_669_MASK (0x20000000u)
#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_669_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_669_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_670_MASK (0x40000000u)
#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_670_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_670_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_671_MASK (0x80000000u)
#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_671_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENA_STATUS_REG20_ENA_STATUS_671_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG20_RESETVAL (0x00000000u)

/* ena_status_reg21 */

#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_672_MASK (0x00000001u)
#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_672_SHIFT (0x00000000u)
#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_672_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_673_MASK (0x00000002u)
#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_673_SHIFT (0x00000001u)
#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_673_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_674_MASK (0x00000004u)
#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_674_SHIFT (0x00000002u)
#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_674_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_675_MASK (0x00000008u)
#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_675_SHIFT (0x00000003u)
#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_675_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_676_MASK (0x00000010u)
#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_676_SHIFT (0x00000004u)
#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_676_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_677_MASK (0x00000020u)
#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_677_SHIFT (0x00000005u)
#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_677_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_678_MASK (0x00000040u)
#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_678_SHIFT (0x00000006u)
#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_678_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_679_MASK (0x00000080u)
#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_679_SHIFT (0x00000007u)
#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_679_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_680_MASK (0x00000100u)
#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_680_SHIFT (0x00000008u)
#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_680_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_681_MASK (0x00000200u)
#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_681_SHIFT (0x00000009u)
#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_681_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_682_MASK (0x00000400u)
#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_682_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_682_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_683_MASK (0x00000800u)
#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_683_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_683_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_684_MASK (0x00001000u)
#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_684_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_684_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_685_MASK (0x00002000u)
#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_685_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_685_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_686_MASK (0x00004000u)
#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_686_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_686_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_687_MASK (0x00008000u)
#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_687_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_687_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_688_MASK (0x00010000u)
#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_688_SHIFT (0x00000010u)
#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_688_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_689_MASK (0x00020000u)
#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_689_SHIFT (0x00000011u)
#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_689_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_690_MASK (0x00040000u)
#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_690_SHIFT (0x00000012u)
#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_690_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_691_MASK (0x00080000u)
#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_691_SHIFT (0x00000013u)
#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_691_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_692_MASK (0x00100000u)
#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_692_SHIFT (0x00000014u)
#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_692_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_693_MASK (0x00200000u)
#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_693_SHIFT (0x00000015u)
#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_693_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_694_MASK (0x00400000u)
#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_694_SHIFT (0x00000016u)
#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_694_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_695_MASK (0x00800000u)
#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_695_SHIFT (0x00000017u)
#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_695_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_696_MASK (0x01000000u)
#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_696_SHIFT (0x00000018u)
#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_696_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_697_MASK (0x02000000u)
#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_697_SHIFT (0x00000019u)
#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_697_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_698_MASK (0x04000000u)
#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_698_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_698_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_699_MASK (0x08000000u)
#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_699_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_699_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_700_MASK (0x10000000u)
#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_700_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_700_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_701_MASK (0x20000000u)
#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_701_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_701_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_702_MASK (0x40000000u)
#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_702_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_702_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_703_MASK (0x80000000u)
#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_703_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENA_STATUS_REG21_ENA_STATUS_703_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG21_RESETVAL (0x00000000u)

/* ena_status_reg22 */

#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_704_MASK (0x00000001u)
#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_704_SHIFT (0x00000000u)
#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_704_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_705_MASK (0x00000002u)
#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_705_SHIFT (0x00000001u)
#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_705_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_706_MASK (0x00000004u)
#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_706_SHIFT (0x00000002u)
#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_706_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_707_MASK (0x00000008u)
#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_707_SHIFT (0x00000003u)
#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_707_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_708_MASK (0x00000010u)
#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_708_SHIFT (0x00000004u)
#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_708_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_709_MASK (0x00000020u)
#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_709_SHIFT (0x00000005u)
#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_709_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_710_MASK (0x00000040u)
#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_710_SHIFT (0x00000006u)
#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_710_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_711_MASK (0x00000080u)
#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_711_SHIFT (0x00000007u)
#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_711_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_712_MASK (0x00000100u)
#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_712_SHIFT (0x00000008u)
#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_712_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_713_MASK (0x00000200u)
#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_713_SHIFT (0x00000009u)
#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_713_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_714_MASK (0x00000400u)
#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_714_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_714_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_715_MASK (0x00000800u)
#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_715_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_715_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_716_MASK (0x00001000u)
#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_716_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_716_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_717_MASK (0x00002000u)
#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_717_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_717_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_718_MASK (0x00004000u)
#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_718_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_718_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_719_MASK (0x00008000u)
#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_719_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_719_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_720_MASK (0x00010000u)
#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_720_SHIFT (0x00000010u)
#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_720_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_721_MASK (0x00020000u)
#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_721_SHIFT (0x00000011u)
#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_721_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_722_MASK (0x00040000u)
#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_722_SHIFT (0x00000012u)
#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_722_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_723_MASK (0x00080000u)
#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_723_SHIFT (0x00000013u)
#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_723_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_724_MASK (0x00100000u)
#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_724_SHIFT (0x00000014u)
#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_724_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_725_MASK (0x00200000u)
#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_725_SHIFT (0x00000015u)
#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_725_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_726_MASK (0x00400000u)
#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_726_SHIFT (0x00000016u)
#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_726_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_727_MASK (0x00800000u)
#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_727_SHIFT (0x00000017u)
#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_727_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_728_MASK (0x01000000u)
#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_728_SHIFT (0x00000018u)
#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_728_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_729_MASK (0x02000000u)
#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_729_SHIFT (0x00000019u)
#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_729_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_730_MASK (0x04000000u)
#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_730_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_730_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_731_MASK (0x08000000u)
#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_731_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_731_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_732_MASK (0x10000000u)
#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_732_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_732_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_733_MASK (0x20000000u)
#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_733_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_733_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_734_MASK (0x40000000u)
#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_734_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_734_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_735_MASK (0x80000000u)
#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_735_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENA_STATUS_REG22_ENA_STATUS_735_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG22_RESETVAL (0x00000000u)

/* ena_status_reg23 */

#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_736_MASK (0x00000001u)
#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_736_SHIFT (0x00000000u)
#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_736_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_737_MASK (0x00000002u)
#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_737_SHIFT (0x00000001u)
#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_737_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_738_MASK (0x00000004u)
#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_738_SHIFT (0x00000002u)
#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_738_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_739_MASK (0x00000008u)
#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_739_SHIFT (0x00000003u)
#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_739_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_740_MASK (0x00000010u)
#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_740_SHIFT (0x00000004u)
#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_740_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_741_MASK (0x00000020u)
#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_741_SHIFT (0x00000005u)
#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_741_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_742_MASK (0x00000040u)
#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_742_SHIFT (0x00000006u)
#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_742_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_743_MASK (0x00000080u)
#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_743_SHIFT (0x00000007u)
#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_743_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_744_MASK (0x00000100u)
#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_744_SHIFT (0x00000008u)
#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_744_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_745_MASK (0x00000200u)
#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_745_SHIFT (0x00000009u)
#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_745_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_746_MASK (0x00000400u)
#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_746_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_746_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_747_MASK (0x00000800u)
#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_747_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_747_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_748_MASK (0x00001000u)
#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_748_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_748_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_749_MASK (0x00002000u)
#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_749_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_749_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_750_MASK (0x00004000u)
#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_750_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_750_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_751_MASK (0x00008000u)
#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_751_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_751_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_752_MASK (0x00010000u)
#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_752_SHIFT (0x00000010u)
#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_752_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_753_MASK (0x00020000u)
#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_753_SHIFT (0x00000011u)
#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_753_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_754_MASK (0x00040000u)
#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_754_SHIFT (0x00000012u)
#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_754_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_755_MASK (0x00080000u)
#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_755_SHIFT (0x00000013u)
#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_755_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_756_MASK (0x00100000u)
#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_756_SHIFT (0x00000014u)
#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_756_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_757_MASK (0x00200000u)
#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_757_SHIFT (0x00000015u)
#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_757_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_758_MASK (0x00400000u)
#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_758_SHIFT (0x00000016u)
#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_758_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_759_MASK (0x00800000u)
#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_759_SHIFT (0x00000017u)
#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_759_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_760_MASK (0x01000000u)
#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_760_SHIFT (0x00000018u)
#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_760_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_761_MASK (0x02000000u)
#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_761_SHIFT (0x00000019u)
#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_761_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_762_MASK (0x04000000u)
#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_762_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_762_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_763_MASK (0x08000000u)
#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_763_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_763_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_764_MASK (0x10000000u)
#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_764_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_764_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_765_MASK (0x20000000u)
#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_765_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_765_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_766_MASK (0x40000000u)
#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_766_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_766_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_767_MASK (0x80000000u)
#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_767_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENA_STATUS_REG23_ENA_STATUS_767_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG23_RESETVAL (0x00000000u)

/* ena_status_reg24 */

#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_768_MASK (0x00000001u)
#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_768_SHIFT (0x00000000u)
#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_768_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_769_MASK (0x00000002u)
#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_769_SHIFT (0x00000001u)
#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_769_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_770_MASK (0x00000004u)
#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_770_SHIFT (0x00000002u)
#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_770_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_771_MASK (0x00000008u)
#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_771_SHIFT (0x00000003u)
#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_771_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_772_MASK (0x00000010u)
#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_772_SHIFT (0x00000004u)
#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_772_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_773_MASK (0x00000020u)
#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_773_SHIFT (0x00000005u)
#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_773_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_774_MASK (0x00000040u)
#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_774_SHIFT (0x00000006u)
#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_774_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_775_MASK (0x00000080u)
#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_775_SHIFT (0x00000007u)
#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_775_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_776_MASK (0x00000100u)
#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_776_SHIFT (0x00000008u)
#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_776_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_777_MASK (0x00000200u)
#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_777_SHIFT (0x00000009u)
#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_777_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_778_MASK (0x00000400u)
#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_778_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_778_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_779_MASK (0x00000800u)
#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_779_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_779_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_780_MASK (0x00001000u)
#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_780_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_780_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_781_MASK (0x00002000u)
#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_781_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_781_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_782_MASK (0x00004000u)
#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_782_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_782_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_783_MASK (0x00008000u)
#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_783_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_783_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_784_MASK (0x00010000u)
#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_784_SHIFT (0x00000010u)
#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_784_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_785_MASK (0x00020000u)
#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_785_SHIFT (0x00000011u)
#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_785_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_786_MASK (0x00040000u)
#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_786_SHIFT (0x00000012u)
#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_786_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_787_MASK (0x00080000u)
#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_787_SHIFT (0x00000013u)
#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_787_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_788_MASK (0x00100000u)
#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_788_SHIFT (0x00000014u)
#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_788_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_789_MASK (0x00200000u)
#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_789_SHIFT (0x00000015u)
#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_789_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_790_MASK (0x00400000u)
#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_790_SHIFT (0x00000016u)
#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_790_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_791_MASK (0x00800000u)
#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_791_SHIFT (0x00000017u)
#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_791_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_792_MASK (0x01000000u)
#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_792_SHIFT (0x00000018u)
#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_792_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_793_MASK (0x02000000u)
#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_793_SHIFT (0x00000019u)
#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_793_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_794_MASK (0x04000000u)
#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_794_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_794_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_795_MASK (0x08000000u)
#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_795_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_795_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_796_MASK (0x10000000u)
#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_796_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_796_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_797_MASK (0x20000000u)
#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_797_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_797_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_798_MASK (0x40000000u)
#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_798_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_798_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_799_MASK (0x80000000u)
#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_799_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENA_STATUS_REG24_ENA_STATUS_799_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG24_RESETVAL (0x00000000u)

/* ena_status_reg25 */

#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_800_MASK (0x00000001u)
#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_800_SHIFT (0x00000000u)
#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_800_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_801_MASK (0x00000002u)
#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_801_SHIFT (0x00000001u)
#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_801_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_802_MASK (0x00000004u)
#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_802_SHIFT (0x00000002u)
#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_802_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_803_MASK (0x00000008u)
#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_803_SHIFT (0x00000003u)
#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_803_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_804_MASK (0x00000010u)
#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_804_SHIFT (0x00000004u)
#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_804_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_805_MASK (0x00000020u)
#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_805_SHIFT (0x00000005u)
#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_805_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_806_MASK (0x00000040u)
#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_806_SHIFT (0x00000006u)
#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_806_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_807_MASK (0x00000080u)
#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_807_SHIFT (0x00000007u)
#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_807_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_808_MASK (0x00000100u)
#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_808_SHIFT (0x00000008u)
#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_808_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_809_MASK (0x00000200u)
#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_809_SHIFT (0x00000009u)
#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_809_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_810_MASK (0x00000400u)
#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_810_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_810_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_811_MASK (0x00000800u)
#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_811_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_811_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_812_MASK (0x00001000u)
#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_812_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_812_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_813_MASK (0x00002000u)
#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_813_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_813_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_814_MASK (0x00004000u)
#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_814_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_814_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_815_MASK (0x00008000u)
#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_815_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_815_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_816_MASK (0x00010000u)
#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_816_SHIFT (0x00000010u)
#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_816_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_817_MASK (0x00020000u)
#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_817_SHIFT (0x00000011u)
#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_817_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_818_MASK (0x00040000u)
#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_818_SHIFT (0x00000012u)
#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_818_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_819_MASK (0x00080000u)
#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_819_SHIFT (0x00000013u)
#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_819_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_820_MASK (0x00100000u)
#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_820_SHIFT (0x00000014u)
#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_820_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_821_MASK (0x00200000u)
#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_821_SHIFT (0x00000015u)
#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_821_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_822_MASK (0x00400000u)
#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_822_SHIFT (0x00000016u)
#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_822_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_823_MASK (0x00800000u)
#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_823_SHIFT (0x00000017u)
#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_823_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_824_MASK (0x01000000u)
#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_824_SHIFT (0x00000018u)
#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_824_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_825_MASK (0x02000000u)
#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_825_SHIFT (0x00000019u)
#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_825_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_826_MASK (0x04000000u)
#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_826_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_826_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_827_MASK (0x08000000u)
#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_827_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_827_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_828_MASK (0x10000000u)
#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_828_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_828_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_829_MASK (0x20000000u)
#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_829_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_829_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_830_MASK (0x40000000u)
#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_830_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_830_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_831_MASK (0x80000000u)
#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_831_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENA_STATUS_REG25_ENA_STATUS_831_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG25_RESETVAL (0x00000000u)

/* ena_status_reg26 */

#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_832_MASK (0x00000001u)
#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_832_SHIFT (0x00000000u)
#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_832_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_833_MASK (0x00000002u)
#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_833_SHIFT (0x00000001u)
#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_833_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_834_MASK (0x00000004u)
#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_834_SHIFT (0x00000002u)
#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_834_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_835_MASK (0x00000008u)
#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_835_SHIFT (0x00000003u)
#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_835_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_836_MASK (0x00000010u)
#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_836_SHIFT (0x00000004u)
#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_836_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_837_MASK (0x00000020u)
#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_837_SHIFT (0x00000005u)
#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_837_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_838_MASK (0x00000040u)
#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_838_SHIFT (0x00000006u)
#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_838_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_839_MASK (0x00000080u)
#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_839_SHIFT (0x00000007u)
#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_839_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_840_MASK (0x00000100u)
#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_840_SHIFT (0x00000008u)
#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_840_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_841_MASK (0x00000200u)
#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_841_SHIFT (0x00000009u)
#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_841_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_842_MASK (0x00000400u)
#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_842_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_842_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_843_MASK (0x00000800u)
#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_843_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_843_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_844_MASK (0x00001000u)
#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_844_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_844_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_845_MASK (0x00002000u)
#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_845_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_845_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_846_MASK (0x00004000u)
#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_846_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_846_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_847_MASK (0x00008000u)
#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_847_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_847_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_848_MASK (0x00010000u)
#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_848_SHIFT (0x00000010u)
#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_848_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_849_MASK (0x00020000u)
#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_849_SHIFT (0x00000011u)
#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_849_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_850_MASK (0x00040000u)
#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_850_SHIFT (0x00000012u)
#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_850_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_851_MASK (0x00080000u)
#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_851_SHIFT (0x00000013u)
#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_851_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_852_MASK (0x00100000u)
#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_852_SHIFT (0x00000014u)
#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_852_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_853_MASK (0x00200000u)
#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_853_SHIFT (0x00000015u)
#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_853_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_854_MASK (0x00400000u)
#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_854_SHIFT (0x00000016u)
#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_854_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_855_MASK (0x00800000u)
#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_855_SHIFT (0x00000017u)
#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_855_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_856_MASK (0x01000000u)
#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_856_SHIFT (0x00000018u)
#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_856_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_857_MASK (0x02000000u)
#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_857_SHIFT (0x00000019u)
#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_857_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_858_MASK (0x04000000u)
#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_858_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_858_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_859_MASK (0x08000000u)
#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_859_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_859_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_860_MASK (0x10000000u)
#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_860_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_860_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_861_MASK (0x20000000u)
#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_861_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_861_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_862_MASK (0x40000000u)
#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_862_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_862_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_863_MASK (0x80000000u)
#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_863_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENA_STATUS_REG26_ENA_STATUS_863_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG26_RESETVAL (0x00000000u)

/* ena_status_reg27 */

#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_864_MASK (0x00000001u)
#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_864_SHIFT (0x00000000u)
#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_864_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_865_MASK (0x00000002u)
#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_865_SHIFT (0x00000001u)
#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_865_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_866_MASK (0x00000004u)
#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_866_SHIFT (0x00000002u)
#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_866_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_867_MASK (0x00000008u)
#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_867_SHIFT (0x00000003u)
#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_867_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_868_MASK (0x00000010u)
#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_868_SHIFT (0x00000004u)
#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_868_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_869_MASK (0x00000020u)
#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_869_SHIFT (0x00000005u)
#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_869_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_870_MASK (0x00000040u)
#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_870_SHIFT (0x00000006u)
#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_870_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_871_MASK (0x00000080u)
#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_871_SHIFT (0x00000007u)
#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_871_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_872_MASK (0x00000100u)
#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_872_SHIFT (0x00000008u)
#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_872_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_873_MASK (0x00000200u)
#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_873_SHIFT (0x00000009u)
#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_873_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_874_MASK (0x00000400u)
#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_874_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_874_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_875_MASK (0x00000800u)
#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_875_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_875_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_876_MASK (0x00001000u)
#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_876_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_876_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_877_MASK (0x00002000u)
#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_877_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_877_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_878_MASK (0x00004000u)
#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_878_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_878_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_879_MASK (0x00008000u)
#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_879_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_879_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_880_MASK (0x00010000u)
#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_880_SHIFT (0x00000010u)
#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_880_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_881_MASK (0x00020000u)
#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_881_SHIFT (0x00000011u)
#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_881_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_882_MASK (0x00040000u)
#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_882_SHIFT (0x00000012u)
#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_882_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_883_MASK (0x00080000u)
#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_883_SHIFT (0x00000013u)
#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_883_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_884_MASK (0x00100000u)
#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_884_SHIFT (0x00000014u)
#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_884_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_885_MASK (0x00200000u)
#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_885_SHIFT (0x00000015u)
#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_885_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_886_MASK (0x00400000u)
#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_886_SHIFT (0x00000016u)
#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_886_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_887_MASK (0x00800000u)
#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_887_SHIFT (0x00000017u)
#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_887_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_888_MASK (0x01000000u)
#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_888_SHIFT (0x00000018u)
#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_888_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_889_MASK (0x02000000u)
#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_889_SHIFT (0x00000019u)
#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_889_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_890_MASK (0x04000000u)
#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_890_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_890_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_891_MASK (0x08000000u)
#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_891_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_891_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_892_MASK (0x10000000u)
#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_892_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_892_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_893_MASK (0x20000000u)
#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_893_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_893_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_894_MASK (0x40000000u)
#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_894_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_894_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_895_MASK (0x80000000u)
#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_895_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENA_STATUS_REG27_ENA_STATUS_895_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG27_RESETVAL (0x00000000u)

/* ena_status_reg28 */

#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_896_MASK (0x00000001u)
#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_896_SHIFT (0x00000000u)
#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_896_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_897_MASK (0x00000002u)
#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_897_SHIFT (0x00000001u)
#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_897_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_898_MASK (0x00000004u)
#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_898_SHIFT (0x00000002u)
#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_898_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_899_MASK (0x00000008u)
#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_899_SHIFT (0x00000003u)
#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_899_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_900_MASK (0x00000010u)
#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_900_SHIFT (0x00000004u)
#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_900_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_901_MASK (0x00000020u)
#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_901_SHIFT (0x00000005u)
#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_901_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_902_MASK (0x00000040u)
#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_902_SHIFT (0x00000006u)
#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_902_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_903_MASK (0x00000080u)
#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_903_SHIFT (0x00000007u)
#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_903_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_904_MASK (0x00000100u)
#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_904_SHIFT (0x00000008u)
#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_904_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_905_MASK (0x00000200u)
#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_905_SHIFT (0x00000009u)
#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_905_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_906_MASK (0x00000400u)
#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_906_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_906_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_907_MASK (0x00000800u)
#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_907_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_907_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_908_MASK (0x00001000u)
#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_908_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_908_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_909_MASK (0x00002000u)
#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_909_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_909_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_910_MASK (0x00004000u)
#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_910_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_910_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_911_MASK (0x00008000u)
#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_911_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_911_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_912_MASK (0x00010000u)
#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_912_SHIFT (0x00000010u)
#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_912_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_913_MASK (0x00020000u)
#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_913_SHIFT (0x00000011u)
#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_913_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_914_MASK (0x00040000u)
#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_914_SHIFT (0x00000012u)
#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_914_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_915_MASK (0x00080000u)
#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_915_SHIFT (0x00000013u)
#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_915_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_916_MASK (0x00100000u)
#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_916_SHIFT (0x00000014u)
#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_916_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_917_MASK (0x00200000u)
#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_917_SHIFT (0x00000015u)
#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_917_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_918_MASK (0x00400000u)
#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_918_SHIFT (0x00000016u)
#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_918_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_919_MASK (0x00800000u)
#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_919_SHIFT (0x00000017u)
#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_919_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_920_MASK (0x01000000u)
#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_920_SHIFT (0x00000018u)
#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_920_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_921_MASK (0x02000000u)
#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_921_SHIFT (0x00000019u)
#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_921_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_922_MASK (0x04000000u)
#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_922_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_922_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_923_MASK (0x08000000u)
#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_923_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_923_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_924_MASK (0x10000000u)
#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_924_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_924_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_925_MASK (0x20000000u)
#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_925_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_925_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_926_MASK (0x40000000u)
#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_926_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_926_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_927_MASK (0x80000000u)
#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_927_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENA_STATUS_REG28_ENA_STATUS_927_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG28_RESETVAL (0x00000000u)

/* ena_status_reg29 */

#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_928_MASK (0x00000001u)
#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_928_SHIFT (0x00000000u)
#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_928_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_929_MASK (0x00000002u)
#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_929_SHIFT (0x00000001u)
#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_929_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_930_MASK (0x00000004u)
#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_930_SHIFT (0x00000002u)
#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_930_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_931_MASK (0x00000008u)
#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_931_SHIFT (0x00000003u)
#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_931_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_932_MASK (0x00000010u)
#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_932_SHIFT (0x00000004u)
#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_932_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_933_MASK (0x00000020u)
#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_933_SHIFT (0x00000005u)
#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_933_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_934_MASK (0x00000040u)
#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_934_SHIFT (0x00000006u)
#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_934_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_935_MASK (0x00000080u)
#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_935_SHIFT (0x00000007u)
#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_935_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_936_MASK (0x00000100u)
#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_936_SHIFT (0x00000008u)
#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_936_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_937_MASK (0x00000200u)
#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_937_SHIFT (0x00000009u)
#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_937_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_938_MASK (0x00000400u)
#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_938_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_938_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_939_MASK (0x00000800u)
#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_939_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_939_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_940_MASK (0x00001000u)
#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_940_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_940_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_941_MASK (0x00002000u)
#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_941_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_941_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_942_MASK (0x00004000u)
#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_942_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_942_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_943_MASK (0x00008000u)
#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_943_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_943_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_944_MASK (0x00010000u)
#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_944_SHIFT (0x00000010u)
#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_944_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_945_MASK (0x00020000u)
#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_945_SHIFT (0x00000011u)
#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_945_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_946_MASK (0x00040000u)
#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_946_SHIFT (0x00000012u)
#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_946_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_947_MASK (0x00080000u)
#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_947_SHIFT (0x00000013u)
#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_947_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_948_MASK (0x00100000u)
#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_948_SHIFT (0x00000014u)
#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_948_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_949_MASK (0x00200000u)
#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_949_SHIFT (0x00000015u)
#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_949_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_950_MASK (0x00400000u)
#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_950_SHIFT (0x00000016u)
#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_950_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_951_MASK (0x00800000u)
#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_951_SHIFT (0x00000017u)
#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_951_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_952_MASK (0x01000000u)
#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_952_SHIFT (0x00000018u)
#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_952_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_953_MASK (0x02000000u)
#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_953_SHIFT (0x00000019u)
#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_953_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_954_MASK (0x04000000u)
#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_954_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_954_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_955_MASK (0x08000000u)
#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_955_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_955_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_956_MASK (0x10000000u)
#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_956_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_956_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_957_MASK (0x20000000u)
#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_957_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_957_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_958_MASK (0x40000000u)
#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_958_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_958_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_959_MASK (0x80000000u)
#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_959_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENA_STATUS_REG29_ENA_STATUS_959_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG29_RESETVAL (0x00000000u)

/* ena_status_reg30 */

#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_960_MASK (0x00000001u)
#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_960_SHIFT (0x00000000u)
#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_960_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_961_MASK (0x00000002u)
#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_961_SHIFT (0x00000001u)
#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_961_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_962_MASK (0x00000004u)
#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_962_SHIFT (0x00000002u)
#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_962_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_963_MASK (0x00000008u)
#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_963_SHIFT (0x00000003u)
#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_963_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_964_MASK (0x00000010u)
#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_964_SHIFT (0x00000004u)
#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_964_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_965_MASK (0x00000020u)
#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_965_SHIFT (0x00000005u)
#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_965_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_966_MASK (0x00000040u)
#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_966_SHIFT (0x00000006u)
#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_966_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_967_MASK (0x00000080u)
#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_967_SHIFT (0x00000007u)
#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_967_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_968_MASK (0x00000100u)
#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_968_SHIFT (0x00000008u)
#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_968_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_969_MASK (0x00000200u)
#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_969_SHIFT (0x00000009u)
#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_969_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_970_MASK (0x00000400u)
#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_970_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_970_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_971_MASK (0x00000800u)
#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_971_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_971_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_972_MASK (0x00001000u)
#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_972_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_972_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_973_MASK (0x00002000u)
#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_973_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_973_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_974_MASK (0x00004000u)
#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_974_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_974_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_975_MASK (0x00008000u)
#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_975_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_975_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_976_MASK (0x00010000u)
#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_976_SHIFT (0x00000010u)
#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_976_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_977_MASK (0x00020000u)
#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_977_SHIFT (0x00000011u)
#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_977_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_978_MASK (0x00040000u)
#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_978_SHIFT (0x00000012u)
#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_978_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_979_MASK (0x00080000u)
#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_979_SHIFT (0x00000013u)
#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_979_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_980_MASK (0x00100000u)
#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_980_SHIFT (0x00000014u)
#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_980_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_981_MASK (0x00200000u)
#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_981_SHIFT (0x00000015u)
#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_981_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_982_MASK (0x00400000u)
#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_982_SHIFT (0x00000016u)
#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_982_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_983_MASK (0x00800000u)
#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_983_SHIFT (0x00000017u)
#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_983_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_984_MASK (0x01000000u)
#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_984_SHIFT (0x00000018u)
#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_984_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_985_MASK (0x02000000u)
#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_985_SHIFT (0x00000019u)
#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_985_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_986_MASK (0x04000000u)
#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_986_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_986_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_987_MASK (0x08000000u)
#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_987_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_987_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_988_MASK (0x10000000u)
#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_988_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_988_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_989_MASK (0x20000000u)
#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_989_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_989_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_990_MASK (0x40000000u)
#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_990_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_990_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_991_MASK (0x80000000u)
#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_991_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENA_STATUS_REG30_ENA_STATUS_991_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG30_RESETVAL (0x00000000u)

/* ena_status_reg31 */

#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_992_MASK (0x00000001u)
#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_992_SHIFT (0x00000000u)
#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_992_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_993_MASK (0x00000002u)
#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_993_SHIFT (0x00000001u)
#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_993_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_994_MASK (0x00000004u)
#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_994_SHIFT (0x00000002u)
#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_994_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_995_MASK (0x00000008u)
#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_995_SHIFT (0x00000003u)
#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_995_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_996_MASK (0x00000010u)
#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_996_SHIFT (0x00000004u)
#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_996_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_997_MASK (0x00000020u)
#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_997_SHIFT (0x00000005u)
#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_997_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_998_MASK (0x00000040u)
#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_998_SHIFT (0x00000006u)
#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_998_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_999_MASK (0x00000080u)
#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_999_SHIFT (0x00000007u)
#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_999_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_1000_MASK (0x00000100u)
#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_1000_SHIFT (0x00000008u)
#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_1000_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_1001_MASK (0x00000200u)
#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_1001_SHIFT (0x00000009u)
#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_1001_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_1002_MASK (0x00000400u)
#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_1002_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_1002_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_1003_MASK (0x00000800u)
#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_1003_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_1003_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_1004_MASK (0x00001000u)
#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_1004_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_1004_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_1005_MASK (0x00002000u)
#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_1005_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_1005_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_1006_MASK (0x00004000u)
#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_1006_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_1006_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_1007_MASK (0x00008000u)
#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_1007_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_1007_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_1008_MASK (0x00010000u)
#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_1008_SHIFT (0x00000010u)
#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_1008_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_1009_MASK (0x00020000u)
#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_1009_SHIFT (0x00000011u)
#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_1009_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_1010_MASK (0x00040000u)
#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_1010_SHIFT (0x00000012u)
#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_1010_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_1011_MASK (0x00080000u)
#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_1011_SHIFT (0x00000013u)
#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_1011_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_1012_MASK (0x00100000u)
#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_1012_SHIFT (0x00000014u)
#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_1012_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_1013_MASK (0x00200000u)
#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_1013_SHIFT (0x00000015u)
#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_1013_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_1014_MASK (0x00400000u)
#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_1014_SHIFT (0x00000016u)
#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_1014_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_1015_MASK (0x00800000u)
#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_1015_SHIFT (0x00000017u)
#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_1015_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_1016_MASK (0x01000000u)
#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_1016_SHIFT (0x00000018u)
#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_1016_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_1017_MASK (0x02000000u)
#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_1017_SHIFT (0x00000019u)
#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_1017_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_1018_MASK (0x04000000u)
#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_1018_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_1018_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_1019_MASK (0x08000000u)
#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_1019_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_1019_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_1020_MASK (0x10000000u)
#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_1020_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_1020_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_1021_MASK (0x20000000u)
#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_1021_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_1021_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_1022_MASK (0x40000000u)
#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_1022_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_1022_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_1023_MASK (0x80000000u)
#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_1023_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENA_STATUS_REG31_ENA_STATUS_1023_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENA_STATUS_REG31_RESETVAL (0x00000000u)

/* enable_reg0 */

#define CSL_CPINTC_ENABLE_REG0_ENABLE_0_MASK (0x00000001u)
#define CSL_CPINTC_ENABLE_REG0_ENABLE_0_SHIFT (0x00000000u)
#define CSL_CPINTC_ENABLE_REG0_ENABLE_0_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG0_ENABLE_1_MASK (0x00000002u)
#define CSL_CPINTC_ENABLE_REG0_ENABLE_1_SHIFT (0x00000001u)
#define CSL_CPINTC_ENABLE_REG0_ENABLE_1_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG0_ENABLE_2_MASK (0x00000004u)
#define CSL_CPINTC_ENABLE_REG0_ENABLE_2_SHIFT (0x00000002u)
#define CSL_CPINTC_ENABLE_REG0_ENABLE_2_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG0_ENABLE_3_MASK (0x00000008u)
#define CSL_CPINTC_ENABLE_REG0_ENABLE_3_SHIFT (0x00000003u)
#define CSL_CPINTC_ENABLE_REG0_ENABLE_3_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG0_ENABLE_4_MASK (0x00000010u)
#define CSL_CPINTC_ENABLE_REG0_ENABLE_4_SHIFT (0x00000004u)
#define CSL_CPINTC_ENABLE_REG0_ENABLE_4_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG0_ENABLE_5_MASK (0x00000020u)
#define CSL_CPINTC_ENABLE_REG0_ENABLE_5_SHIFT (0x00000005u)
#define CSL_CPINTC_ENABLE_REG0_ENABLE_5_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG0_ENABLE_6_MASK (0x00000040u)
#define CSL_CPINTC_ENABLE_REG0_ENABLE_6_SHIFT (0x00000006u)
#define CSL_CPINTC_ENABLE_REG0_ENABLE_6_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG0_ENABLE_7_MASK (0x00000080u)
#define CSL_CPINTC_ENABLE_REG0_ENABLE_7_SHIFT (0x00000007u)
#define CSL_CPINTC_ENABLE_REG0_ENABLE_7_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG0_ENABLE_8_MASK (0x00000100u)
#define CSL_CPINTC_ENABLE_REG0_ENABLE_8_SHIFT (0x00000008u)
#define CSL_CPINTC_ENABLE_REG0_ENABLE_8_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG0_ENABLE_9_MASK (0x00000200u)
#define CSL_CPINTC_ENABLE_REG0_ENABLE_9_SHIFT (0x00000009u)
#define CSL_CPINTC_ENABLE_REG0_ENABLE_9_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG0_ENABLE_10_MASK (0x00000400u)
#define CSL_CPINTC_ENABLE_REG0_ENABLE_10_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENABLE_REG0_ENABLE_10_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG0_ENABLE_11_MASK (0x00000800u)
#define CSL_CPINTC_ENABLE_REG0_ENABLE_11_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENABLE_REG0_ENABLE_11_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG0_ENABLE_12_MASK (0x00001000u)
#define CSL_CPINTC_ENABLE_REG0_ENABLE_12_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENABLE_REG0_ENABLE_12_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG0_ENABLE_13_MASK (0x00002000u)
#define CSL_CPINTC_ENABLE_REG0_ENABLE_13_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENABLE_REG0_ENABLE_13_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG0_ENABLE_14_MASK (0x00004000u)
#define CSL_CPINTC_ENABLE_REG0_ENABLE_14_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENABLE_REG0_ENABLE_14_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG0_ENABLE_15_MASK (0x00008000u)
#define CSL_CPINTC_ENABLE_REG0_ENABLE_15_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENABLE_REG0_ENABLE_15_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG0_ENABLE_16_MASK (0x00010000u)
#define CSL_CPINTC_ENABLE_REG0_ENABLE_16_SHIFT (0x00000010u)
#define CSL_CPINTC_ENABLE_REG0_ENABLE_16_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG0_ENABLE_17_MASK (0x00020000u)
#define CSL_CPINTC_ENABLE_REG0_ENABLE_17_SHIFT (0x00000011u)
#define CSL_CPINTC_ENABLE_REG0_ENABLE_17_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG0_ENABLE_18_MASK (0x00040000u)
#define CSL_CPINTC_ENABLE_REG0_ENABLE_18_SHIFT (0x00000012u)
#define CSL_CPINTC_ENABLE_REG0_ENABLE_18_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG0_ENABLE_19_MASK (0x00080000u)
#define CSL_CPINTC_ENABLE_REG0_ENABLE_19_SHIFT (0x00000013u)
#define CSL_CPINTC_ENABLE_REG0_ENABLE_19_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG0_ENABLE_20_MASK (0x00100000u)
#define CSL_CPINTC_ENABLE_REG0_ENABLE_20_SHIFT (0x00000014u)
#define CSL_CPINTC_ENABLE_REG0_ENABLE_20_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG0_ENABLE_21_MASK (0x00200000u)
#define CSL_CPINTC_ENABLE_REG0_ENABLE_21_SHIFT (0x00000015u)
#define CSL_CPINTC_ENABLE_REG0_ENABLE_21_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG0_ENABLE_22_MASK (0x00400000u)
#define CSL_CPINTC_ENABLE_REG0_ENABLE_22_SHIFT (0x00000016u)
#define CSL_CPINTC_ENABLE_REG0_ENABLE_22_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG0_ENABLE_23_MASK (0x00800000u)
#define CSL_CPINTC_ENABLE_REG0_ENABLE_23_SHIFT (0x00000017u)
#define CSL_CPINTC_ENABLE_REG0_ENABLE_23_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG0_ENABLE_24_MASK (0x01000000u)
#define CSL_CPINTC_ENABLE_REG0_ENABLE_24_SHIFT (0x00000018u)
#define CSL_CPINTC_ENABLE_REG0_ENABLE_24_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG0_ENABLE_25_MASK (0x02000000u)
#define CSL_CPINTC_ENABLE_REG0_ENABLE_25_SHIFT (0x00000019u)
#define CSL_CPINTC_ENABLE_REG0_ENABLE_25_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG0_ENABLE_26_MASK (0x04000000u)
#define CSL_CPINTC_ENABLE_REG0_ENABLE_26_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENABLE_REG0_ENABLE_26_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG0_ENABLE_27_MASK (0x08000000u)
#define CSL_CPINTC_ENABLE_REG0_ENABLE_27_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENABLE_REG0_ENABLE_27_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG0_ENABLE_28_MASK (0x10000000u)
#define CSL_CPINTC_ENABLE_REG0_ENABLE_28_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENABLE_REG0_ENABLE_28_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG0_ENABLE_29_MASK (0x20000000u)
#define CSL_CPINTC_ENABLE_REG0_ENABLE_29_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENABLE_REG0_ENABLE_29_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG0_ENABLE_30_MASK (0x40000000u)
#define CSL_CPINTC_ENABLE_REG0_ENABLE_30_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENABLE_REG0_ENABLE_30_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG0_ENABLE_31_MASK (0x80000000u)
#define CSL_CPINTC_ENABLE_REG0_ENABLE_31_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENABLE_REG0_ENABLE_31_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG0_RESETVAL  (0x00000000u)

/* enable_reg1 */

#define CSL_CPINTC_ENABLE_REG1_ENABLE_32_MASK (0x00000001u)
#define CSL_CPINTC_ENABLE_REG1_ENABLE_32_SHIFT (0x00000000u)
#define CSL_CPINTC_ENABLE_REG1_ENABLE_32_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG1_ENABLE_33_MASK (0x00000002u)
#define CSL_CPINTC_ENABLE_REG1_ENABLE_33_SHIFT (0x00000001u)
#define CSL_CPINTC_ENABLE_REG1_ENABLE_33_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG1_ENABLE_34_MASK (0x00000004u)
#define CSL_CPINTC_ENABLE_REG1_ENABLE_34_SHIFT (0x00000002u)
#define CSL_CPINTC_ENABLE_REG1_ENABLE_34_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG1_ENABLE_35_MASK (0x00000008u)
#define CSL_CPINTC_ENABLE_REG1_ENABLE_35_SHIFT (0x00000003u)
#define CSL_CPINTC_ENABLE_REG1_ENABLE_35_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG1_ENABLE_36_MASK (0x00000010u)
#define CSL_CPINTC_ENABLE_REG1_ENABLE_36_SHIFT (0x00000004u)
#define CSL_CPINTC_ENABLE_REG1_ENABLE_36_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG1_ENABLE_37_MASK (0x00000020u)
#define CSL_CPINTC_ENABLE_REG1_ENABLE_37_SHIFT (0x00000005u)
#define CSL_CPINTC_ENABLE_REG1_ENABLE_37_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG1_ENABLE_38_MASK (0x00000040u)
#define CSL_CPINTC_ENABLE_REG1_ENABLE_38_SHIFT (0x00000006u)
#define CSL_CPINTC_ENABLE_REG1_ENABLE_38_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG1_ENABLE_39_MASK (0x00000080u)
#define CSL_CPINTC_ENABLE_REG1_ENABLE_39_SHIFT (0x00000007u)
#define CSL_CPINTC_ENABLE_REG1_ENABLE_39_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG1_ENABLE_40_MASK (0x00000100u)
#define CSL_CPINTC_ENABLE_REG1_ENABLE_40_SHIFT (0x00000008u)
#define CSL_CPINTC_ENABLE_REG1_ENABLE_40_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG1_ENABLE_41_MASK (0x00000200u)
#define CSL_CPINTC_ENABLE_REG1_ENABLE_41_SHIFT (0x00000009u)
#define CSL_CPINTC_ENABLE_REG1_ENABLE_41_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG1_ENABLE_42_MASK (0x00000400u)
#define CSL_CPINTC_ENABLE_REG1_ENABLE_42_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENABLE_REG1_ENABLE_42_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG1_ENABLE_43_MASK (0x00000800u)
#define CSL_CPINTC_ENABLE_REG1_ENABLE_43_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENABLE_REG1_ENABLE_43_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG1_ENABLE_44_MASK (0x00001000u)
#define CSL_CPINTC_ENABLE_REG1_ENABLE_44_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENABLE_REG1_ENABLE_44_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG1_ENABLE_45_MASK (0x00002000u)
#define CSL_CPINTC_ENABLE_REG1_ENABLE_45_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENABLE_REG1_ENABLE_45_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG1_ENABLE_46_MASK (0x00004000u)
#define CSL_CPINTC_ENABLE_REG1_ENABLE_46_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENABLE_REG1_ENABLE_46_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG1_ENABLE_47_MASK (0x00008000u)
#define CSL_CPINTC_ENABLE_REG1_ENABLE_47_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENABLE_REG1_ENABLE_47_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG1_ENABLE_48_MASK (0x00010000u)
#define CSL_CPINTC_ENABLE_REG1_ENABLE_48_SHIFT (0x00000010u)
#define CSL_CPINTC_ENABLE_REG1_ENABLE_48_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG1_ENABLE_49_MASK (0x00020000u)
#define CSL_CPINTC_ENABLE_REG1_ENABLE_49_SHIFT (0x00000011u)
#define CSL_CPINTC_ENABLE_REG1_ENABLE_49_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG1_ENABLE_50_MASK (0x00040000u)
#define CSL_CPINTC_ENABLE_REG1_ENABLE_50_SHIFT (0x00000012u)
#define CSL_CPINTC_ENABLE_REG1_ENABLE_50_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG1_ENABLE_51_MASK (0x00080000u)
#define CSL_CPINTC_ENABLE_REG1_ENABLE_51_SHIFT (0x00000013u)
#define CSL_CPINTC_ENABLE_REG1_ENABLE_51_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG1_ENABLE_52_MASK (0x00100000u)
#define CSL_CPINTC_ENABLE_REG1_ENABLE_52_SHIFT (0x00000014u)
#define CSL_CPINTC_ENABLE_REG1_ENABLE_52_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG1_ENABLE_53_MASK (0x00200000u)
#define CSL_CPINTC_ENABLE_REG1_ENABLE_53_SHIFT (0x00000015u)
#define CSL_CPINTC_ENABLE_REG1_ENABLE_53_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG1_ENABLE_54_MASK (0x00400000u)
#define CSL_CPINTC_ENABLE_REG1_ENABLE_54_SHIFT (0x00000016u)
#define CSL_CPINTC_ENABLE_REG1_ENABLE_54_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG1_ENABLE_55_MASK (0x00800000u)
#define CSL_CPINTC_ENABLE_REG1_ENABLE_55_SHIFT (0x00000017u)
#define CSL_CPINTC_ENABLE_REG1_ENABLE_55_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG1_ENABLE_56_MASK (0x01000000u)
#define CSL_CPINTC_ENABLE_REG1_ENABLE_56_SHIFT (0x00000018u)
#define CSL_CPINTC_ENABLE_REG1_ENABLE_56_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG1_ENABLE_57_MASK (0x02000000u)
#define CSL_CPINTC_ENABLE_REG1_ENABLE_57_SHIFT (0x00000019u)
#define CSL_CPINTC_ENABLE_REG1_ENABLE_57_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG1_ENABLE_58_MASK (0x04000000u)
#define CSL_CPINTC_ENABLE_REG1_ENABLE_58_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENABLE_REG1_ENABLE_58_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG1_ENABLE_59_MASK (0x08000000u)
#define CSL_CPINTC_ENABLE_REG1_ENABLE_59_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENABLE_REG1_ENABLE_59_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG1_ENABLE_60_MASK (0x10000000u)
#define CSL_CPINTC_ENABLE_REG1_ENABLE_60_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENABLE_REG1_ENABLE_60_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG1_ENABLE_61_MASK (0x20000000u)
#define CSL_CPINTC_ENABLE_REG1_ENABLE_61_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENABLE_REG1_ENABLE_61_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG1_ENABLE_62_MASK (0x40000000u)
#define CSL_CPINTC_ENABLE_REG1_ENABLE_62_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENABLE_REG1_ENABLE_62_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG1_ENABLE_63_MASK (0x80000000u)
#define CSL_CPINTC_ENABLE_REG1_ENABLE_63_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENABLE_REG1_ENABLE_63_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG1_RESETVAL  (0x00000000u)

/* enable_reg2 */

#define CSL_CPINTC_ENABLE_REG2_ENABLE_64_MASK (0x00000001u)
#define CSL_CPINTC_ENABLE_REG2_ENABLE_64_SHIFT (0x00000000u)
#define CSL_CPINTC_ENABLE_REG2_ENABLE_64_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG2_ENABLE_65_MASK (0x00000002u)
#define CSL_CPINTC_ENABLE_REG2_ENABLE_65_SHIFT (0x00000001u)
#define CSL_CPINTC_ENABLE_REG2_ENABLE_65_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG2_ENABLE_66_MASK (0x00000004u)
#define CSL_CPINTC_ENABLE_REG2_ENABLE_66_SHIFT (0x00000002u)
#define CSL_CPINTC_ENABLE_REG2_ENABLE_66_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG2_ENABLE_67_MASK (0x00000008u)
#define CSL_CPINTC_ENABLE_REG2_ENABLE_67_SHIFT (0x00000003u)
#define CSL_CPINTC_ENABLE_REG2_ENABLE_67_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG2_ENABLE_68_MASK (0x00000010u)
#define CSL_CPINTC_ENABLE_REG2_ENABLE_68_SHIFT (0x00000004u)
#define CSL_CPINTC_ENABLE_REG2_ENABLE_68_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG2_ENABLE_69_MASK (0x00000020u)
#define CSL_CPINTC_ENABLE_REG2_ENABLE_69_SHIFT (0x00000005u)
#define CSL_CPINTC_ENABLE_REG2_ENABLE_69_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG2_ENABLE_70_MASK (0x00000040u)
#define CSL_CPINTC_ENABLE_REG2_ENABLE_70_SHIFT (0x00000006u)
#define CSL_CPINTC_ENABLE_REG2_ENABLE_70_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG2_ENABLE_71_MASK (0x00000080u)
#define CSL_CPINTC_ENABLE_REG2_ENABLE_71_SHIFT (0x00000007u)
#define CSL_CPINTC_ENABLE_REG2_ENABLE_71_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG2_ENABLE_72_MASK (0x00000100u)
#define CSL_CPINTC_ENABLE_REG2_ENABLE_72_SHIFT (0x00000008u)
#define CSL_CPINTC_ENABLE_REG2_ENABLE_72_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG2_ENABLE_73_MASK (0x00000200u)
#define CSL_CPINTC_ENABLE_REG2_ENABLE_73_SHIFT (0x00000009u)
#define CSL_CPINTC_ENABLE_REG2_ENABLE_73_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG2_ENABLE_74_MASK (0x00000400u)
#define CSL_CPINTC_ENABLE_REG2_ENABLE_74_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENABLE_REG2_ENABLE_74_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG2_ENABLE_75_MASK (0x00000800u)
#define CSL_CPINTC_ENABLE_REG2_ENABLE_75_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENABLE_REG2_ENABLE_75_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG2_ENABLE_76_MASK (0x00001000u)
#define CSL_CPINTC_ENABLE_REG2_ENABLE_76_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENABLE_REG2_ENABLE_76_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG2_ENABLE_77_MASK (0x00002000u)
#define CSL_CPINTC_ENABLE_REG2_ENABLE_77_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENABLE_REG2_ENABLE_77_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG2_ENABLE_78_MASK (0x00004000u)
#define CSL_CPINTC_ENABLE_REG2_ENABLE_78_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENABLE_REG2_ENABLE_78_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG2_ENABLE_79_MASK (0x00008000u)
#define CSL_CPINTC_ENABLE_REG2_ENABLE_79_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENABLE_REG2_ENABLE_79_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG2_ENABLE_80_MASK (0x00010000u)
#define CSL_CPINTC_ENABLE_REG2_ENABLE_80_SHIFT (0x00000010u)
#define CSL_CPINTC_ENABLE_REG2_ENABLE_80_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG2_ENABLE_81_MASK (0x00020000u)
#define CSL_CPINTC_ENABLE_REG2_ENABLE_81_SHIFT (0x00000011u)
#define CSL_CPINTC_ENABLE_REG2_ENABLE_81_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG2_ENABLE_82_MASK (0x00040000u)
#define CSL_CPINTC_ENABLE_REG2_ENABLE_82_SHIFT (0x00000012u)
#define CSL_CPINTC_ENABLE_REG2_ENABLE_82_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG2_ENABLE_83_MASK (0x00080000u)
#define CSL_CPINTC_ENABLE_REG2_ENABLE_83_SHIFT (0x00000013u)
#define CSL_CPINTC_ENABLE_REG2_ENABLE_83_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG2_ENABLE_84_MASK (0x00100000u)
#define CSL_CPINTC_ENABLE_REG2_ENABLE_84_SHIFT (0x00000014u)
#define CSL_CPINTC_ENABLE_REG2_ENABLE_84_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG2_ENABLE_85_MASK (0x00200000u)
#define CSL_CPINTC_ENABLE_REG2_ENABLE_85_SHIFT (0x00000015u)
#define CSL_CPINTC_ENABLE_REG2_ENABLE_85_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG2_ENABLE_86_MASK (0x00400000u)
#define CSL_CPINTC_ENABLE_REG2_ENABLE_86_SHIFT (0x00000016u)
#define CSL_CPINTC_ENABLE_REG2_ENABLE_86_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG2_ENABLE_87_MASK (0x00800000u)
#define CSL_CPINTC_ENABLE_REG2_ENABLE_87_SHIFT (0x00000017u)
#define CSL_CPINTC_ENABLE_REG2_ENABLE_87_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG2_ENABLE_88_MASK (0x01000000u)
#define CSL_CPINTC_ENABLE_REG2_ENABLE_88_SHIFT (0x00000018u)
#define CSL_CPINTC_ENABLE_REG2_ENABLE_88_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG2_ENABLE_89_MASK (0x02000000u)
#define CSL_CPINTC_ENABLE_REG2_ENABLE_89_SHIFT (0x00000019u)
#define CSL_CPINTC_ENABLE_REG2_ENABLE_89_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG2_ENABLE_90_MASK (0x04000000u)
#define CSL_CPINTC_ENABLE_REG2_ENABLE_90_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENABLE_REG2_ENABLE_90_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG2_ENABLE_91_MASK (0x08000000u)
#define CSL_CPINTC_ENABLE_REG2_ENABLE_91_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENABLE_REG2_ENABLE_91_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG2_ENABLE_92_MASK (0x10000000u)
#define CSL_CPINTC_ENABLE_REG2_ENABLE_92_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENABLE_REG2_ENABLE_92_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG2_ENABLE_93_MASK (0x20000000u)
#define CSL_CPINTC_ENABLE_REG2_ENABLE_93_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENABLE_REG2_ENABLE_93_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG2_ENABLE_94_MASK (0x40000000u)
#define CSL_CPINTC_ENABLE_REG2_ENABLE_94_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENABLE_REG2_ENABLE_94_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG2_ENABLE_95_MASK (0x80000000u)
#define CSL_CPINTC_ENABLE_REG2_ENABLE_95_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENABLE_REG2_ENABLE_95_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG2_RESETVAL  (0x00000000u)

/* enable_reg3 */

#define CSL_CPINTC_ENABLE_REG3_ENABLE_96_MASK (0x00000001u)
#define CSL_CPINTC_ENABLE_REG3_ENABLE_96_SHIFT (0x00000000u)
#define CSL_CPINTC_ENABLE_REG3_ENABLE_96_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG3_ENABLE_97_MASK (0x00000002u)
#define CSL_CPINTC_ENABLE_REG3_ENABLE_97_SHIFT (0x00000001u)
#define CSL_CPINTC_ENABLE_REG3_ENABLE_97_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG3_ENABLE_98_MASK (0x00000004u)
#define CSL_CPINTC_ENABLE_REG3_ENABLE_98_SHIFT (0x00000002u)
#define CSL_CPINTC_ENABLE_REG3_ENABLE_98_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG3_ENABLE_99_MASK (0x00000008u)
#define CSL_CPINTC_ENABLE_REG3_ENABLE_99_SHIFT (0x00000003u)
#define CSL_CPINTC_ENABLE_REG3_ENABLE_99_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG3_ENABLE_100_MASK (0x00000010u)
#define CSL_CPINTC_ENABLE_REG3_ENABLE_100_SHIFT (0x00000004u)
#define CSL_CPINTC_ENABLE_REG3_ENABLE_100_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG3_ENABLE_101_MASK (0x00000020u)
#define CSL_CPINTC_ENABLE_REG3_ENABLE_101_SHIFT (0x00000005u)
#define CSL_CPINTC_ENABLE_REG3_ENABLE_101_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG3_ENABLE_102_MASK (0x00000040u)
#define CSL_CPINTC_ENABLE_REG3_ENABLE_102_SHIFT (0x00000006u)
#define CSL_CPINTC_ENABLE_REG3_ENABLE_102_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG3_ENABLE_103_MASK (0x00000080u)
#define CSL_CPINTC_ENABLE_REG3_ENABLE_103_SHIFT (0x00000007u)
#define CSL_CPINTC_ENABLE_REG3_ENABLE_103_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG3_ENABLE_104_MASK (0x00000100u)
#define CSL_CPINTC_ENABLE_REG3_ENABLE_104_SHIFT (0x00000008u)
#define CSL_CPINTC_ENABLE_REG3_ENABLE_104_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG3_ENABLE_105_MASK (0x00000200u)
#define CSL_CPINTC_ENABLE_REG3_ENABLE_105_SHIFT (0x00000009u)
#define CSL_CPINTC_ENABLE_REG3_ENABLE_105_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG3_ENABLE_106_MASK (0x00000400u)
#define CSL_CPINTC_ENABLE_REG3_ENABLE_106_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENABLE_REG3_ENABLE_106_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG3_ENABLE_107_MASK (0x00000800u)
#define CSL_CPINTC_ENABLE_REG3_ENABLE_107_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENABLE_REG3_ENABLE_107_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG3_ENABLE_108_MASK (0x00001000u)
#define CSL_CPINTC_ENABLE_REG3_ENABLE_108_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENABLE_REG3_ENABLE_108_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG3_ENABLE_109_MASK (0x00002000u)
#define CSL_CPINTC_ENABLE_REG3_ENABLE_109_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENABLE_REG3_ENABLE_109_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG3_ENABLE_110_MASK (0x00004000u)
#define CSL_CPINTC_ENABLE_REG3_ENABLE_110_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENABLE_REG3_ENABLE_110_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG3_ENABLE_111_MASK (0x00008000u)
#define CSL_CPINTC_ENABLE_REG3_ENABLE_111_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENABLE_REG3_ENABLE_111_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG3_ENABLE_112_MASK (0x00010000u)
#define CSL_CPINTC_ENABLE_REG3_ENABLE_112_SHIFT (0x00000010u)
#define CSL_CPINTC_ENABLE_REG3_ENABLE_112_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG3_ENABLE_113_MASK (0x00020000u)
#define CSL_CPINTC_ENABLE_REG3_ENABLE_113_SHIFT (0x00000011u)
#define CSL_CPINTC_ENABLE_REG3_ENABLE_113_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG3_ENABLE_114_MASK (0x00040000u)
#define CSL_CPINTC_ENABLE_REG3_ENABLE_114_SHIFT (0x00000012u)
#define CSL_CPINTC_ENABLE_REG3_ENABLE_114_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG3_ENABLE_115_MASK (0x00080000u)
#define CSL_CPINTC_ENABLE_REG3_ENABLE_115_SHIFT (0x00000013u)
#define CSL_CPINTC_ENABLE_REG3_ENABLE_115_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG3_ENABLE_116_MASK (0x00100000u)
#define CSL_CPINTC_ENABLE_REG3_ENABLE_116_SHIFT (0x00000014u)
#define CSL_CPINTC_ENABLE_REG3_ENABLE_116_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG3_ENABLE_117_MASK (0x00200000u)
#define CSL_CPINTC_ENABLE_REG3_ENABLE_117_SHIFT (0x00000015u)
#define CSL_CPINTC_ENABLE_REG3_ENABLE_117_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG3_ENABLE_118_MASK (0x00400000u)
#define CSL_CPINTC_ENABLE_REG3_ENABLE_118_SHIFT (0x00000016u)
#define CSL_CPINTC_ENABLE_REG3_ENABLE_118_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG3_ENABLE_119_MASK (0x00800000u)
#define CSL_CPINTC_ENABLE_REG3_ENABLE_119_SHIFT (0x00000017u)
#define CSL_CPINTC_ENABLE_REG3_ENABLE_119_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG3_ENABLE_120_MASK (0x01000000u)
#define CSL_CPINTC_ENABLE_REG3_ENABLE_120_SHIFT (0x00000018u)
#define CSL_CPINTC_ENABLE_REG3_ENABLE_120_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG3_ENABLE_121_MASK (0x02000000u)
#define CSL_CPINTC_ENABLE_REG3_ENABLE_121_SHIFT (0x00000019u)
#define CSL_CPINTC_ENABLE_REG3_ENABLE_121_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG3_ENABLE_122_MASK (0x04000000u)
#define CSL_CPINTC_ENABLE_REG3_ENABLE_122_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENABLE_REG3_ENABLE_122_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG3_ENABLE_123_MASK (0x08000000u)
#define CSL_CPINTC_ENABLE_REG3_ENABLE_123_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENABLE_REG3_ENABLE_123_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG3_ENABLE_124_MASK (0x10000000u)
#define CSL_CPINTC_ENABLE_REG3_ENABLE_124_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENABLE_REG3_ENABLE_124_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG3_ENABLE_125_MASK (0x20000000u)
#define CSL_CPINTC_ENABLE_REG3_ENABLE_125_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENABLE_REG3_ENABLE_125_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG3_ENABLE_126_MASK (0x40000000u)
#define CSL_CPINTC_ENABLE_REG3_ENABLE_126_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENABLE_REG3_ENABLE_126_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG3_ENABLE_127_MASK (0x80000000u)
#define CSL_CPINTC_ENABLE_REG3_ENABLE_127_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENABLE_REG3_ENABLE_127_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG3_RESETVAL  (0x00000000u)

/* enable_reg4 */

#define CSL_CPINTC_ENABLE_REG4_ENABLE_128_MASK (0x00000001u)
#define CSL_CPINTC_ENABLE_REG4_ENABLE_128_SHIFT (0x00000000u)
#define CSL_CPINTC_ENABLE_REG4_ENABLE_128_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG4_ENABLE_129_MASK (0x00000002u)
#define CSL_CPINTC_ENABLE_REG4_ENABLE_129_SHIFT (0x00000001u)
#define CSL_CPINTC_ENABLE_REG4_ENABLE_129_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG4_ENABLE_130_MASK (0x00000004u)
#define CSL_CPINTC_ENABLE_REG4_ENABLE_130_SHIFT (0x00000002u)
#define CSL_CPINTC_ENABLE_REG4_ENABLE_130_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG4_ENABLE_131_MASK (0x00000008u)
#define CSL_CPINTC_ENABLE_REG4_ENABLE_131_SHIFT (0x00000003u)
#define CSL_CPINTC_ENABLE_REG4_ENABLE_131_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG4_ENABLE_132_MASK (0x00000010u)
#define CSL_CPINTC_ENABLE_REG4_ENABLE_132_SHIFT (0x00000004u)
#define CSL_CPINTC_ENABLE_REG4_ENABLE_132_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG4_ENABLE_133_MASK (0x00000020u)
#define CSL_CPINTC_ENABLE_REG4_ENABLE_133_SHIFT (0x00000005u)
#define CSL_CPINTC_ENABLE_REG4_ENABLE_133_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG4_ENABLE_134_MASK (0x00000040u)
#define CSL_CPINTC_ENABLE_REG4_ENABLE_134_SHIFT (0x00000006u)
#define CSL_CPINTC_ENABLE_REG4_ENABLE_134_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG4_ENABLE_135_MASK (0x00000080u)
#define CSL_CPINTC_ENABLE_REG4_ENABLE_135_SHIFT (0x00000007u)
#define CSL_CPINTC_ENABLE_REG4_ENABLE_135_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG4_ENABLE_136_MASK (0x00000100u)
#define CSL_CPINTC_ENABLE_REG4_ENABLE_136_SHIFT (0x00000008u)
#define CSL_CPINTC_ENABLE_REG4_ENABLE_136_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG4_ENABLE_137_MASK (0x00000200u)
#define CSL_CPINTC_ENABLE_REG4_ENABLE_137_SHIFT (0x00000009u)
#define CSL_CPINTC_ENABLE_REG4_ENABLE_137_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG4_ENABLE_138_MASK (0x00000400u)
#define CSL_CPINTC_ENABLE_REG4_ENABLE_138_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENABLE_REG4_ENABLE_138_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG4_ENABLE_139_MASK (0x00000800u)
#define CSL_CPINTC_ENABLE_REG4_ENABLE_139_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENABLE_REG4_ENABLE_139_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG4_ENABLE_140_MASK (0x00001000u)
#define CSL_CPINTC_ENABLE_REG4_ENABLE_140_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENABLE_REG4_ENABLE_140_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG4_ENABLE_141_MASK (0x00002000u)
#define CSL_CPINTC_ENABLE_REG4_ENABLE_141_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENABLE_REG4_ENABLE_141_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG4_ENABLE_142_MASK (0x00004000u)
#define CSL_CPINTC_ENABLE_REG4_ENABLE_142_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENABLE_REG4_ENABLE_142_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG4_ENABLE_143_MASK (0x00008000u)
#define CSL_CPINTC_ENABLE_REG4_ENABLE_143_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENABLE_REG4_ENABLE_143_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG4_ENABLE_144_MASK (0x00010000u)
#define CSL_CPINTC_ENABLE_REG4_ENABLE_144_SHIFT (0x00000010u)
#define CSL_CPINTC_ENABLE_REG4_ENABLE_144_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG4_ENABLE_145_MASK (0x00020000u)
#define CSL_CPINTC_ENABLE_REG4_ENABLE_145_SHIFT (0x00000011u)
#define CSL_CPINTC_ENABLE_REG4_ENABLE_145_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG4_ENABLE_146_MASK (0x00040000u)
#define CSL_CPINTC_ENABLE_REG4_ENABLE_146_SHIFT (0x00000012u)
#define CSL_CPINTC_ENABLE_REG4_ENABLE_146_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG4_ENABLE_147_MASK (0x00080000u)
#define CSL_CPINTC_ENABLE_REG4_ENABLE_147_SHIFT (0x00000013u)
#define CSL_CPINTC_ENABLE_REG4_ENABLE_147_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG4_ENABLE_148_MASK (0x00100000u)
#define CSL_CPINTC_ENABLE_REG4_ENABLE_148_SHIFT (0x00000014u)
#define CSL_CPINTC_ENABLE_REG4_ENABLE_148_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG4_ENABLE_149_MASK (0x00200000u)
#define CSL_CPINTC_ENABLE_REG4_ENABLE_149_SHIFT (0x00000015u)
#define CSL_CPINTC_ENABLE_REG4_ENABLE_149_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG4_ENABLE_150_MASK (0x00400000u)
#define CSL_CPINTC_ENABLE_REG4_ENABLE_150_SHIFT (0x00000016u)
#define CSL_CPINTC_ENABLE_REG4_ENABLE_150_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG4_ENABLE_151_MASK (0x00800000u)
#define CSL_CPINTC_ENABLE_REG4_ENABLE_151_SHIFT (0x00000017u)
#define CSL_CPINTC_ENABLE_REG4_ENABLE_151_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG4_ENABLE_152_MASK (0x01000000u)
#define CSL_CPINTC_ENABLE_REG4_ENABLE_152_SHIFT (0x00000018u)
#define CSL_CPINTC_ENABLE_REG4_ENABLE_152_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG4_ENABLE_153_MASK (0x02000000u)
#define CSL_CPINTC_ENABLE_REG4_ENABLE_153_SHIFT (0x00000019u)
#define CSL_CPINTC_ENABLE_REG4_ENABLE_153_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG4_ENABLE_154_MASK (0x04000000u)
#define CSL_CPINTC_ENABLE_REG4_ENABLE_154_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENABLE_REG4_ENABLE_154_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG4_ENABLE_155_MASK (0x08000000u)
#define CSL_CPINTC_ENABLE_REG4_ENABLE_155_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENABLE_REG4_ENABLE_155_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG4_ENABLE_156_MASK (0x10000000u)
#define CSL_CPINTC_ENABLE_REG4_ENABLE_156_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENABLE_REG4_ENABLE_156_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG4_ENABLE_157_MASK (0x20000000u)
#define CSL_CPINTC_ENABLE_REG4_ENABLE_157_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENABLE_REG4_ENABLE_157_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG4_ENABLE_158_MASK (0x40000000u)
#define CSL_CPINTC_ENABLE_REG4_ENABLE_158_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENABLE_REG4_ENABLE_158_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG4_ENABLE_159_MASK (0x80000000u)
#define CSL_CPINTC_ENABLE_REG4_ENABLE_159_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENABLE_REG4_ENABLE_159_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG4_RESETVAL  (0x00000000u)

/* enable_reg5 */

#define CSL_CPINTC_ENABLE_REG5_ENABLE_160_MASK (0x00000001u)
#define CSL_CPINTC_ENABLE_REG5_ENABLE_160_SHIFT (0x00000000u)
#define CSL_CPINTC_ENABLE_REG5_ENABLE_160_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG5_ENABLE_161_MASK (0x00000002u)
#define CSL_CPINTC_ENABLE_REG5_ENABLE_161_SHIFT (0x00000001u)
#define CSL_CPINTC_ENABLE_REG5_ENABLE_161_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG5_ENABLE_162_MASK (0x00000004u)
#define CSL_CPINTC_ENABLE_REG5_ENABLE_162_SHIFT (0x00000002u)
#define CSL_CPINTC_ENABLE_REG5_ENABLE_162_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG5_ENABLE_163_MASK (0x00000008u)
#define CSL_CPINTC_ENABLE_REG5_ENABLE_163_SHIFT (0x00000003u)
#define CSL_CPINTC_ENABLE_REG5_ENABLE_163_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG5_ENABLE_164_MASK (0x00000010u)
#define CSL_CPINTC_ENABLE_REG5_ENABLE_164_SHIFT (0x00000004u)
#define CSL_CPINTC_ENABLE_REG5_ENABLE_164_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG5_ENABLE_165_MASK (0x00000020u)
#define CSL_CPINTC_ENABLE_REG5_ENABLE_165_SHIFT (0x00000005u)
#define CSL_CPINTC_ENABLE_REG5_ENABLE_165_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG5_ENABLE_166_MASK (0x00000040u)
#define CSL_CPINTC_ENABLE_REG5_ENABLE_166_SHIFT (0x00000006u)
#define CSL_CPINTC_ENABLE_REG5_ENABLE_166_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG5_ENABLE_167_MASK (0x00000080u)
#define CSL_CPINTC_ENABLE_REG5_ENABLE_167_SHIFT (0x00000007u)
#define CSL_CPINTC_ENABLE_REG5_ENABLE_167_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG5_ENABLE_168_MASK (0x00000100u)
#define CSL_CPINTC_ENABLE_REG5_ENABLE_168_SHIFT (0x00000008u)
#define CSL_CPINTC_ENABLE_REG5_ENABLE_168_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG5_ENABLE_169_MASK (0x00000200u)
#define CSL_CPINTC_ENABLE_REG5_ENABLE_169_SHIFT (0x00000009u)
#define CSL_CPINTC_ENABLE_REG5_ENABLE_169_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG5_ENABLE_170_MASK (0x00000400u)
#define CSL_CPINTC_ENABLE_REG5_ENABLE_170_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENABLE_REG5_ENABLE_170_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG5_ENABLE_171_MASK (0x00000800u)
#define CSL_CPINTC_ENABLE_REG5_ENABLE_171_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENABLE_REG5_ENABLE_171_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG5_ENABLE_172_MASK (0x00001000u)
#define CSL_CPINTC_ENABLE_REG5_ENABLE_172_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENABLE_REG5_ENABLE_172_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG5_ENABLE_173_MASK (0x00002000u)
#define CSL_CPINTC_ENABLE_REG5_ENABLE_173_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENABLE_REG5_ENABLE_173_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG5_ENABLE_174_MASK (0x00004000u)
#define CSL_CPINTC_ENABLE_REG5_ENABLE_174_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENABLE_REG5_ENABLE_174_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG5_ENABLE_175_MASK (0x00008000u)
#define CSL_CPINTC_ENABLE_REG5_ENABLE_175_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENABLE_REG5_ENABLE_175_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG5_ENABLE_176_MASK (0x00010000u)
#define CSL_CPINTC_ENABLE_REG5_ENABLE_176_SHIFT (0x00000010u)
#define CSL_CPINTC_ENABLE_REG5_ENABLE_176_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG5_ENABLE_177_MASK (0x00020000u)
#define CSL_CPINTC_ENABLE_REG5_ENABLE_177_SHIFT (0x00000011u)
#define CSL_CPINTC_ENABLE_REG5_ENABLE_177_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG5_ENABLE_178_MASK (0x00040000u)
#define CSL_CPINTC_ENABLE_REG5_ENABLE_178_SHIFT (0x00000012u)
#define CSL_CPINTC_ENABLE_REG5_ENABLE_178_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG5_ENABLE_179_MASK (0x00080000u)
#define CSL_CPINTC_ENABLE_REG5_ENABLE_179_SHIFT (0x00000013u)
#define CSL_CPINTC_ENABLE_REG5_ENABLE_179_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG5_ENABLE_180_MASK (0x00100000u)
#define CSL_CPINTC_ENABLE_REG5_ENABLE_180_SHIFT (0x00000014u)
#define CSL_CPINTC_ENABLE_REG5_ENABLE_180_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG5_ENABLE_181_MASK (0x00200000u)
#define CSL_CPINTC_ENABLE_REG5_ENABLE_181_SHIFT (0x00000015u)
#define CSL_CPINTC_ENABLE_REG5_ENABLE_181_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG5_ENABLE_182_MASK (0x00400000u)
#define CSL_CPINTC_ENABLE_REG5_ENABLE_182_SHIFT (0x00000016u)
#define CSL_CPINTC_ENABLE_REG5_ENABLE_182_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG5_ENABLE_183_MASK (0x00800000u)
#define CSL_CPINTC_ENABLE_REG5_ENABLE_183_SHIFT (0x00000017u)
#define CSL_CPINTC_ENABLE_REG5_ENABLE_183_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG5_ENABLE_184_MASK (0x01000000u)
#define CSL_CPINTC_ENABLE_REG5_ENABLE_184_SHIFT (0x00000018u)
#define CSL_CPINTC_ENABLE_REG5_ENABLE_184_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG5_ENABLE_185_MASK (0x02000000u)
#define CSL_CPINTC_ENABLE_REG5_ENABLE_185_SHIFT (0x00000019u)
#define CSL_CPINTC_ENABLE_REG5_ENABLE_185_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG5_ENABLE_186_MASK (0x04000000u)
#define CSL_CPINTC_ENABLE_REG5_ENABLE_186_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENABLE_REG5_ENABLE_186_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG5_ENABLE_187_MASK (0x08000000u)
#define CSL_CPINTC_ENABLE_REG5_ENABLE_187_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENABLE_REG5_ENABLE_187_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG5_ENABLE_188_MASK (0x10000000u)
#define CSL_CPINTC_ENABLE_REG5_ENABLE_188_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENABLE_REG5_ENABLE_188_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG5_ENABLE_189_MASK (0x20000000u)
#define CSL_CPINTC_ENABLE_REG5_ENABLE_189_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENABLE_REG5_ENABLE_189_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG5_ENABLE_190_MASK (0x40000000u)
#define CSL_CPINTC_ENABLE_REG5_ENABLE_190_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENABLE_REG5_ENABLE_190_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG5_ENABLE_191_MASK (0x80000000u)
#define CSL_CPINTC_ENABLE_REG5_ENABLE_191_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENABLE_REG5_ENABLE_191_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG5_RESETVAL  (0x00000000u)

/* enable_reg6 */

#define CSL_CPINTC_ENABLE_REG6_ENABLE_192_MASK (0x00000001u)
#define CSL_CPINTC_ENABLE_REG6_ENABLE_192_SHIFT (0x00000000u)
#define CSL_CPINTC_ENABLE_REG6_ENABLE_192_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG6_ENABLE_193_MASK (0x00000002u)
#define CSL_CPINTC_ENABLE_REG6_ENABLE_193_SHIFT (0x00000001u)
#define CSL_CPINTC_ENABLE_REG6_ENABLE_193_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG6_ENABLE_194_MASK (0x00000004u)
#define CSL_CPINTC_ENABLE_REG6_ENABLE_194_SHIFT (0x00000002u)
#define CSL_CPINTC_ENABLE_REG6_ENABLE_194_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG6_ENABLE_195_MASK (0x00000008u)
#define CSL_CPINTC_ENABLE_REG6_ENABLE_195_SHIFT (0x00000003u)
#define CSL_CPINTC_ENABLE_REG6_ENABLE_195_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG6_ENABLE_196_MASK (0x00000010u)
#define CSL_CPINTC_ENABLE_REG6_ENABLE_196_SHIFT (0x00000004u)
#define CSL_CPINTC_ENABLE_REG6_ENABLE_196_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG6_ENABLE_197_MASK (0x00000020u)
#define CSL_CPINTC_ENABLE_REG6_ENABLE_197_SHIFT (0x00000005u)
#define CSL_CPINTC_ENABLE_REG6_ENABLE_197_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG6_ENABLE_198_MASK (0x00000040u)
#define CSL_CPINTC_ENABLE_REG6_ENABLE_198_SHIFT (0x00000006u)
#define CSL_CPINTC_ENABLE_REG6_ENABLE_198_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG6_ENABLE_199_MASK (0x00000080u)
#define CSL_CPINTC_ENABLE_REG6_ENABLE_199_SHIFT (0x00000007u)
#define CSL_CPINTC_ENABLE_REG6_ENABLE_199_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG6_ENABLE_200_MASK (0x00000100u)
#define CSL_CPINTC_ENABLE_REG6_ENABLE_200_SHIFT (0x00000008u)
#define CSL_CPINTC_ENABLE_REG6_ENABLE_200_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG6_ENABLE_201_MASK (0x00000200u)
#define CSL_CPINTC_ENABLE_REG6_ENABLE_201_SHIFT (0x00000009u)
#define CSL_CPINTC_ENABLE_REG6_ENABLE_201_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG6_ENABLE_202_MASK (0x00000400u)
#define CSL_CPINTC_ENABLE_REG6_ENABLE_202_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENABLE_REG6_ENABLE_202_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG6_ENABLE_203_MASK (0x00000800u)
#define CSL_CPINTC_ENABLE_REG6_ENABLE_203_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENABLE_REG6_ENABLE_203_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG6_ENABLE_204_MASK (0x00001000u)
#define CSL_CPINTC_ENABLE_REG6_ENABLE_204_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENABLE_REG6_ENABLE_204_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG6_ENABLE_205_MASK (0x00002000u)
#define CSL_CPINTC_ENABLE_REG6_ENABLE_205_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENABLE_REG6_ENABLE_205_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG6_ENABLE_206_MASK (0x00004000u)
#define CSL_CPINTC_ENABLE_REG6_ENABLE_206_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENABLE_REG6_ENABLE_206_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG6_ENABLE_207_MASK (0x00008000u)
#define CSL_CPINTC_ENABLE_REG6_ENABLE_207_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENABLE_REG6_ENABLE_207_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG6_ENABLE_208_MASK (0x00010000u)
#define CSL_CPINTC_ENABLE_REG6_ENABLE_208_SHIFT (0x00000010u)
#define CSL_CPINTC_ENABLE_REG6_ENABLE_208_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG6_ENABLE_209_MASK (0x00020000u)
#define CSL_CPINTC_ENABLE_REG6_ENABLE_209_SHIFT (0x00000011u)
#define CSL_CPINTC_ENABLE_REG6_ENABLE_209_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG6_ENABLE_210_MASK (0x00040000u)
#define CSL_CPINTC_ENABLE_REG6_ENABLE_210_SHIFT (0x00000012u)
#define CSL_CPINTC_ENABLE_REG6_ENABLE_210_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG6_ENABLE_211_MASK (0x00080000u)
#define CSL_CPINTC_ENABLE_REG6_ENABLE_211_SHIFT (0x00000013u)
#define CSL_CPINTC_ENABLE_REG6_ENABLE_211_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG6_ENABLE_212_MASK (0x00100000u)
#define CSL_CPINTC_ENABLE_REG6_ENABLE_212_SHIFT (0x00000014u)
#define CSL_CPINTC_ENABLE_REG6_ENABLE_212_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG6_ENABLE_213_MASK (0x00200000u)
#define CSL_CPINTC_ENABLE_REG6_ENABLE_213_SHIFT (0x00000015u)
#define CSL_CPINTC_ENABLE_REG6_ENABLE_213_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG6_ENABLE_214_MASK (0x00400000u)
#define CSL_CPINTC_ENABLE_REG6_ENABLE_214_SHIFT (0x00000016u)
#define CSL_CPINTC_ENABLE_REG6_ENABLE_214_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG6_ENABLE_215_MASK (0x00800000u)
#define CSL_CPINTC_ENABLE_REG6_ENABLE_215_SHIFT (0x00000017u)
#define CSL_CPINTC_ENABLE_REG6_ENABLE_215_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG6_ENABLE_216_MASK (0x01000000u)
#define CSL_CPINTC_ENABLE_REG6_ENABLE_216_SHIFT (0x00000018u)
#define CSL_CPINTC_ENABLE_REG6_ENABLE_216_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG6_ENABLE_217_MASK (0x02000000u)
#define CSL_CPINTC_ENABLE_REG6_ENABLE_217_SHIFT (0x00000019u)
#define CSL_CPINTC_ENABLE_REG6_ENABLE_217_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG6_ENABLE_218_MASK (0x04000000u)
#define CSL_CPINTC_ENABLE_REG6_ENABLE_218_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENABLE_REG6_ENABLE_218_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG6_ENABLE_219_MASK (0x08000000u)
#define CSL_CPINTC_ENABLE_REG6_ENABLE_219_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENABLE_REG6_ENABLE_219_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG6_ENABLE_220_MASK (0x10000000u)
#define CSL_CPINTC_ENABLE_REG6_ENABLE_220_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENABLE_REG6_ENABLE_220_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG6_ENABLE_221_MASK (0x20000000u)
#define CSL_CPINTC_ENABLE_REG6_ENABLE_221_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENABLE_REG6_ENABLE_221_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG6_ENABLE_222_MASK (0x40000000u)
#define CSL_CPINTC_ENABLE_REG6_ENABLE_222_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENABLE_REG6_ENABLE_222_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG6_ENABLE_223_MASK (0x80000000u)
#define CSL_CPINTC_ENABLE_REG6_ENABLE_223_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENABLE_REG6_ENABLE_223_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG6_RESETVAL  (0x00000000u)

/* enable_reg7 */

#define CSL_CPINTC_ENABLE_REG7_ENABLE_224_MASK (0x00000001u)
#define CSL_CPINTC_ENABLE_REG7_ENABLE_224_SHIFT (0x00000000u)
#define CSL_CPINTC_ENABLE_REG7_ENABLE_224_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG7_ENABLE_225_MASK (0x00000002u)
#define CSL_CPINTC_ENABLE_REG7_ENABLE_225_SHIFT (0x00000001u)
#define CSL_CPINTC_ENABLE_REG7_ENABLE_225_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG7_ENABLE_226_MASK (0x00000004u)
#define CSL_CPINTC_ENABLE_REG7_ENABLE_226_SHIFT (0x00000002u)
#define CSL_CPINTC_ENABLE_REG7_ENABLE_226_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG7_ENABLE_227_MASK (0x00000008u)
#define CSL_CPINTC_ENABLE_REG7_ENABLE_227_SHIFT (0x00000003u)
#define CSL_CPINTC_ENABLE_REG7_ENABLE_227_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG7_ENABLE_228_MASK (0x00000010u)
#define CSL_CPINTC_ENABLE_REG7_ENABLE_228_SHIFT (0x00000004u)
#define CSL_CPINTC_ENABLE_REG7_ENABLE_228_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG7_ENABLE_229_MASK (0x00000020u)
#define CSL_CPINTC_ENABLE_REG7_ENABLE_229_SHIFT (0x00000005u)
#define CSL_CPINTC_ENABLE_REG7_ENABLE_229_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG7_ENABLE_230_MASK (0x00000040u)
#define CSL_CPINTC_ENABLE_REG7_ENABLE_230_SHIFT (0x00000006u)
#define CSL_CPINTC_ENABLE_REG7_ENABLE_230_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG7_ENABLE_231_MASK (0x00000080u)
#define CSL_CPINTC_ENABLE_REG7_ENABLE_231_SHIFT (0x00000007u)
#define CSL_CPINTC_ENABLE_REG7_ENABLE_231_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG7_ENABLE_232_MASK (0x00000100u)
#define CSL_CPINTC_ENABLE_REG7_ENABLE_232_SHIFT (0x00000008u)
#define CSL_CPINTC_ENABLE_REG7_ENABLE_232_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG7_ENABLE_233_MASK (0x00000200u)
#define CSL_CPINTC_ENABLE_REG7_ENABLE_233_SHIFT (0x00000009u)
#define CSL_CPINTC_ENABLE_REG7_ENABLE_233_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG7_ENABLE_234_MASK (0x00000400u)
#define CSL_CPINTC_ENABLE_REG7_ENABLE_234_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENABLE_REG7_ENABLE_234_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG7_ENABLE_235_MASK (0x00000800u)
#define CSL_CPINTC_ENABLE_REG7_ENABLE_235_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENABLE_REG7_ENABLE_235_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG7_ENABLE_236_MASK (0x00001000u)
#define CSL_CPINTC_ENABLE_REG7_ENABLE_236_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENABLE_REG7_ENABLE_236_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG7_ENABLE_237_MASK (0x00002000u)
#define CSL_CPINTC_ENABLE_REG7_ENABLE_237_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENABLE_REG7_ENABLE_237_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG7_ENABLE_238_MASK (0x00004000u)
#define CSL_CPINTC_ENABLE_REG7_ENABLE_238_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENABLE_REG7_ENABLE_238_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG7_ENABLE_239_MASK (0x00008000u)
#define CSL_CPINTC_ENABLE_REG7_ENABLE_239_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENABLE_REG7_ENABLE_239_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG7_ENABLE_240_MASK (0x00010000u)
#define CSL_CPINTC_ENABLE_REG7_ENABLE_240_SHIFT (0x00000010u)
#define CSL_CPINTC_ENABLE_REG7_ENABLE_240_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG7_ENABLE_241_MASK (0x00020000u)
#define CSL_CPINTC_ENABLE_REG7_ENABLE_241_SHIFT (0x00000011u)
#define CSL_CPINTC_ENABLE_REG7_ENABLE_241_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG7_ENABLE_242_MASK (0x00040000u)
#define CSL_CPINTC_ENABLE_REG7_ENABLE_242_SHIFT (0x00000012u)
#define CSL_CPINTC_ENABLE_REG7_ENABLE_242_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG7_ENABLE_243_MASK (0x00080000u)
#define CSL_CPINTC_ENABLE_REG7_ENABLE_243_SHIFT (0x00000013u)
#define CSL_CPINTC_ENABLE_REG7_ENABLE_243_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG7_ENABLE_244_MASK (0x00100000u)
#define CSL_CPINTC_ENABLE_REG7_ENABLE_244_SHIFT (0x00000014u)
#define CSL_CPINTC_ENABLE_REG7_ENABLE_244_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG7_ENABLE_245_MASK (0x00200000u)
#define CSL_CPINTC_ENABLE_REG7_ENABLE_245_SHIFT (0x00000015u)
#define CSL_CPINTC_ENABLE_REG7_ENABLE_245_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG7_ENABLE_246_MASK (0x00400000u)
#define CSL_CPINTC_ENABLE_REG7_ENABLE_246_SHIFT (0x00000016u)
#define CSL_CPINTC_ENABLE_REG7_ENABLE_246_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG7_ENABLE_247_MASK (0x00800000u)
#define CSL_CPINTC_ENABLE_REG7_ENABLE_247_SHIFT (0x00000017u)
#define CSL_CPINTC_ENABLE_REG7_ENABLE_247_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG7_ENABLE_248_MASK (0x01000000u)
#define CSL_CPINTC_ENABLE_REG7_ENABLE_248_SHIFT (0x00000018u)
#define CSL_CPINTC_ENABLE_REG7_ENABLE_248_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG7_ENABLE_249_MASK (0x02000000u)
#define CSL_CPINTC_ENABLE_REG7_ENABLE_249_SHIFT (0x00000019u)
#define CSL_CPINTC_ENABLE_REG7_ENABLE_249_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG7_ENABLE_250_MASK (0x04000000u)
#define CSL_CPINTC_ENABLE_REG7_ENABLE_250_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENABLE_REG7_ENABLE_250_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG7_ENABLE_251_MASK (0x08000000u)
#define CSL_CPINTC_ENABLE_REG7_ENABLE_251_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENABLE_REG7_ENABLE_251_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG7_ENABLE_252_MASK (0x10000000u)
#define CSL_CPINTC_ENABLE_REG7_ENABLE_252_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENABLE_REG7_ENABLE_252_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG7_ENABLE_253_MASK (0x20000000u)
#define CSL_CPINTC_ENABLE_REG7_ENABLE_253_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENABLE_REG7_ENABLE_253_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG7_ENABLE_254_MASK (0x40000000u)
#define CSL_CPINTC_ENABLE_REG7_ENABLE_254_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENABLE_REG7_ENABLE_254_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG7_ENABLE_255_MASK (0x80000000u)
#define CSL_CPINTC_ENABLE_REG7_ENABLE_255_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENABLE_REG7_ENABLE_255_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG7_RESETVAL  (0x00000000u)

/* enable_reg8 */

#define CSL_CPINTC_ENABLE_REG8_ENABLE_256_MASK (0x00000001u)
#define CSL_CPINTC_ENABLE_REG8_ENABLE_256_SHIFT (0x00000000u)
#define CSL_CPINTC_ENABLE_REG8_ENABLE_256_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG8_ENABLE_257_MASK (0x00000002u)
#define CSL_CPINTC_ENABLE_REG8_ENABLE_257_SHIFT (0x00000001u)
#define CSL_CPINTC_ENABLE_REG8_ENABLE_257_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG8_ENABLE_258_MASK (0x00000004u)
#define CSL_CPINTC_ENABLE_REG8_ENABLE_258_SHIFT (0x00000002u)
#define CSL_CPINTC_ENABLE_REG8_ENABLE_258_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG8_ENABLE_259_MASK (0x00000008u)
#define CSL_CPINTC_ENABLE_REG8_ENABLE_259_SHIFT (0x00000003u)
#define CSL_CPINTC_ENABLE_REG8_ENABLE_259_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG8_ENABLE_260_MASK (0x00000010u)
#define CSL_CPINTC_ENABLE_REG8_ENABLE_260_SHIFT (0x00000004u)
#define CSL_CPINTC_ENABLE_REG8_ENABLE_260_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG8_ENABLE_261_MASK (0x00000020u)
#define CSL_CPINTC_ENABLE_REG8_ENABLE_261_SHIFT (0x00000005u)
#define CSL_CPINTC_ENABLE_REG8_ENABLE_261_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG8_ENABLE_262_MASK (0x00000040u)
#define CSL_CPINTC_ENABLE_REG8_ENABLE_262_SHIFT (0x00000006u)
#define CSL_CPINTC_ENABLE_REG8_ENABLE_262_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG8_ENABLE_263_MASK (0x00000080u)
#define CSL_CPINTC_ENABLE_REG8_ENABLE_263_SHIFT (0x00000007u)
#define CSL_CPINTC_ENABLE_REG8_ENABLE_263_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG8_ENABLE_264_MASK (0x00000100u)
#define CSL_CPINTC_ENABLE_REG8_ENABLE_264_SHIFT (0x00000008u)
#define CSL_CPINTC_ENABLE_REG8_ENABLE_264_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG8_ENABLE_265_MASK (0x00000200u)
#define CSL_CPINTC_ENABLE_REG8_ENABLE_265_SHIFT (0x00000009u)
#define CSL_CPINTC_ENABLE_REG8_ENABLE_265_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG8_ENABLE_266_MASK (0x00000400u)
#define CSL_CPINTC_ENABLE_REG8_ENABLE_266_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENABLE_REG8_ENABLE_266_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG8_ENABLE_267_MASK (0x00000800u)
#define CSL_CPINTC_ENABLE_REG8_ENABLE_267_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENABLE_REG8_ENABLE_267_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG8_ENABLE_268_MASK (0x00001000u)
#define CSL_CPINTC_ENABLE_REG8_ENABLE_268_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENABLE_REG8_ENABLE_268_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG8_ENABLE_269_MASK (0x00002000u)
#define CSL_CPINTC_ENABLE_REG8_ENABLE_269_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENABLE_REG8_ENABLE_269_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG8_ENABLE_270_MASK (0x00004000u)
#define CSL_CPINTC_ENABLE_REG8_ENABLE_270_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENABLE_REG8_ENABLE_270_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG8_ENABLE_271_MASK (0x00008000u)
#define CSL_CPINTC_ENABLE_REG8_ENABLE_271_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENABLE_REG8_ENABLE_271_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG8_ENABLE_272_MASK (0x00010000u)
#define CSL_CPINTC_ENABLE_REG8_ENABLE_272_SHIFT (0x00000010u)
#define CSL_CPINTC_ENABLE_REG8_ENABLE_272_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG8_ENABLE_273_MASK (0x00020000u)
#define CSL_CPINTC_ENABLE_REG8_ENABLE_273_SHIFT (0x00000011u)
#define CSL_CPINTC_ENABLE_REG8_ENABLE_273_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG8_ENABLE_274_MASK (0x00040000u)
#define CSL_CPINTC_ENABLE_REG8_ENABLE_274_SHIFT (0x00000012u)
#define CSL_CPINTC_ENABLE_REG8_ENABLE_274_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG8_ENABLE_275_MASK (0x00080000u)
#define CSL_CPINTC_ENABLE_REG8_ENABLE_275_SHIFT (0x00000013u)
#define CSL_CPINTC_ENABLE_REG8_ENABLE_275_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG8_ENABLE_276_MASK (0x00100000u)
#define CSL_CPINTC_ENABLE_REG8_ENABLE_276_SHIFT (0x00000014u)
#define CSL_CPINTC_ENABLE_REG8_ENABLE_276_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG8_ENABLE_277_MASK (0x00200000u)
#define CSL_CPINTC_ENABLE_REG8_ENABLE_277_SHIFT (0x00000015u)
#define CSL_CPINTC_ENABLE_REG8_ENABLE_277_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG8_ENABLE_278_MASK (0x00400000u)
#define CSL_CPINTC_ENABLE_REG8_ENABLE_278_SHIFT (0x00000016u)
#define CSL_CPINTC_ENABLE_REG8_ENABLE_278_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG8_ENABLE_279_MASK (0x00800000u)
#define CSL_CPINTC_ENABLE_REG8_ENABLE_279_SHIFT (0x00000017u)
#define CSL_CPINTC_ENABLE_REG8_ENABLE_279_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG8_ENABLE_280_MASK (0x01000000u)
#define CSL_CPINTC_ENABLE_REG8_ENABLE_280_SHIFT (0x00000018u)
#define CSL_CPINTC_ENABLE_REG8_ENABLE_280_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG8_ENABLE_281_MASK (0x02000000u)
#define CSL_CPINTC_ENABLE_REG8_ENABLE_281_SHIFT (0x00000019u)
#define CSL_CPINTC_ENABLE_REG8_ENABLE_281_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG8_ENABLE_282_MASK (0x04000000u)
#define CSL_CPINTC_ENABLE_REG8_ENABLE_282_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENABLE_REG8_ENABLE_282_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG8_ENABLE_283_MASK (0x08000000u)
#define CSL_CPINTC_ENABLE_REG8_ENABLE_283_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENABLE_REG8_ENABLE_283_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG8_ENABLE_284_MASK (0x10000000u)
#define CSL_CPINTC_ENABLE_REG8_ENABLE_284_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENABLE_REG8_ENABLE_284_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG8_ENABLE_285_MASK (0x20000000u)
#define CSL_CPINTC_ENABLE_REG8_ENABLE_285_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENABLE_REG8_ENABLE_285_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG8_ENABLE_286_MASK (0x40000000u)
#define CSL_CPINTC_ENABLE_REG8_ENABLE_286_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENABLE_REG8_ENABLE_286_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG8_ENABLE_287_MASK (0x80000000u)
#define CSL_CPINTC_ENABLE_REG8_ENABLE_287_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENABLE_REG8_ENABLE_287_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG8_RESETVAL  (0x00000000u)

/* enable_reg9 */

#define CSL_CPINTC_ENABLE_REG9_ENABLE_288_MASK (0x00000001u)
#define CSL_CPINTC_ENABLE_REG9_ENABLE_288_SHIFT (0x00000000u)
#define CSL_CPINTC_ENABLE_REG9_ENABLE_288_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG9_ENABLE_289_MASK (0x00000002u)
#define CSL_CPINTC_ENABLE_REG9_ENABLE_289_SHIFT (0x00000001u)
#define CSL_CPINTC_ENABLE_REG9_ENABLE_289_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG9_ENABLE_290_MASK (0x00000004u)
#define CSL_CPINTC_ENABLE_REG9_ENABLE_290_SHIFT (0x00000002u)
#define CSL_CPINTC_ENABLE_REG9_ENABLE_290_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG9_ENABLE_291_MASK (0x00000008u)
#define CSL_CPINTC_ENABLE_REG9_ENABLE_291_SHIFT (0x00000003u)
#define CSL_CPINTC_ENABLE_REG9_ENABLE_291_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG9_ENABLE_292_MASK (0x00000010u)
#define CSL_CPINTC_ENABLE_REG9_ENABLE_292_SHIFT (0x00000004u)
#define CSL_CPINTC_ENABLE_REG9_ENABLE_292_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG9_ENABLE_293_MASK (0x00000020u)
#define CSL_CPINTC_ENABLE_REG9_ENABLE_293_SHIFT (0x00000005u)
#define CSL_CPINTC_ENABLE_REG9_ENABLE_293_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG9_ENABLE_294_MASK (0x00000040u)
#define CSL_CPINTC_ENABLE_REG9_ENABLE_294_SHIFT (0x00000006u)
#define CSL_CPINTC_ENABLE_REG9_ENABLE_294_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG9_ENABLE_295_MASK (0x00000080u)
#define CSL_CPINTC_ENABLE_REG9_ENABLE_295_SHIFT (0x00000007u)
#define CSL_CPINTC_ENABLE_REG9_ENABLE_295_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG9_ENABLE_296_MASK (0x00000100u)
#define CSL_CPINTC_ENABLE_REG9_ENABLE_296_SHIFT (0x00000008u)
#define CSL_CPINTC_ENABLE_REG9_ENABLE_296_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG9_ENABLE_297_MASK (0x00000200u)
#define CSL_CPINTC_ENABLE_REG9_ENABLE_297_SHIFT (0x00000009u)
#define CSL_CPINTC_ENABLE_REG9_ENABLE_297_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG9_ENABLE_298_MASK (0x00000400u)
#define CSL_CPINTC_ENABLE_REG9_ENABLE_298_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENABLE_REG9_ENABLE_298_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG9_ENABLE_299_MASK (0x00000800u)
#define CSL_CPINTC_ENABLE_REG9_ENABLE_299_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENABLE_REG9_ENABLE_299_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG9_ENABLE_300_MASK (0x00001000u)
#define CSL_CPINTC_ENABLE_REG9_ENABLE_300_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENABLE_REG9_ENABLE_300_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG9_ENABLE_301_MASK (0x00002000u)
#define CSL_CPINTC_ENABLE_REG9_ENABLE_301_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENABLE_REG9_ENABLE_301_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG9_ENABLE_302_MASK (0x00004000u)
#define CSL_CPINTC_ENABLE_REG9_ENABLE_302_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENABLE_REG9_ENABLE_302_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG9_ENABLE_303_MASK (0x00008000u)
#define CSL_CPINTC_ENABLE_REG9_ENABLE_303_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENABLE_REG9_ENABLE_303_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG9_ENABLE_304_MASK (0x00010000u)
#define CSL_CPINTC_ENABLE_REG9_ENABLE_304_SHIFT (0x00000010u)
#define CSL_CPINTC_ENABLE_REG9_ENABLE_304_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG9_ENABLE_305_MASK (0x00020000u)
#define CSL_CPINTC_ENABLE_REG9_ENABLE_305_SHIFT (0x00000011u)
#define CSL_CPINTC_ENABLE_REG9_ENABLE_305_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG9_ENABLE_306_MASK (0x00040000u)
#define CSL_CPINTC_ENABLE_REG9_ENABLE_306_SHIFT (0x00000012u)
#define CSL_CPINTC_ENABLE_REG9_ENABLE_306_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG9_ENABLE_307_MASK (0x00080000u)
#define CSL_CPINTC_ENABLE_REG9_ENABLE_307_SHIFT (0x00000013u)
#define CSL_CPINTC_ENABLE_REG9_ENABLE_307_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG9_ENABLE_308_MASK (0x00100000u)
#define CSL_CPINTC_ENABLE_REG9_ENABLE_308_SHIFT (0x00000014u)
#define CSL_CPINTC_ENABLE_REG9_ENABLE_308_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG9_ENABLE_309_MASK (0x00200000u)
#define CSL_CPINTC_ENABLE_REG9_ENABLE_309_SHIFT (0x00000015u)
#define CSL_CPINTC_ENABLE_REG9_ENABLE_309_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG9_ENABLE_310_MASK (0x00400000u)
#define CSL_CPINTC_ENABLE_REG9_ENABLE_310_SHIFT (0x00000016u)
#define CSL_CPINTC_ENABLE_REG9_ENABLE_310_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG9_ENABLE_311_MASK (0x00800000u)
#define CSL_CPINTC_ENABLE_REG9_ENABLE_311_SHIFT (0x00000017u)
#define CSL_CPINTC_ENABLE_REG9_ENABLE_311_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG9_ENABLE_312_MASK (0x01000000u)
#define CSL_CPINTC_ENABLE_REG9_ENABLE_312_SHIFT (0x00000018u)
#define CSL_CPINTC_ENABLE_REG9_ENABLE_312_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG9_ENABLE_313_MASK (0x02000000u)
#define CSL_CPINTC_ENABLE_REG9_ENABLE_313_SHIFT (0x00000019u)
#define CSL_CPINTC_ENABLE_REG9_ENABLE_313_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG9_ENABLE_314_MASK (0x04000000u)
#define CSL_CPINTC_ENABLE_REG9_ENABLE_314_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENABLE_REG9_ENABLE_314_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG9_ENABLE_315_MASK (0x08000000u)
#define CSL_CPINTC_ENABLE_REG9_ENABLE_315_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENABLE_REG9_ENABLE_315_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG9_ENABLE_316_MASK (0x10000000u)
#define CSL_CPINTC_ENABLE_REG9_ENABLE_316_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENABLE_REG9_ENABLE_316_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG9_ENABLE_317_MASK (0x20000000u)
#define CSL_CPINTC_ENABLE_REG9_ENABLE_317_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENABLE_REG9_ENABLE_317_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG9_ENABLE_318_MASK (0x40000000u)
#define CSL_CPINTC_ENABLE_REG9_ENABLE_318_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENABLE_REG9_ENABLE_318_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG9_ENABLE_319_MASK (0x80000000u)
#define CSL_CPINTC_ENABLE_REG9_ENABLE_319_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENABLE_REG9_ENABLE_319_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG9_RESETVAL  (0x00000000u)

/* enable_reg10 */

#define CSL_CPINTC_ENABLE_REG10_ENABLE_320_MASK (0x00000001u)
#define CSL_CPINTC_ENABLE_REG10_ENABLE_320_SHIFT (0x00000000u)
#define CSL_CPINTC_ENABLE_REG10_ENABLE_320_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG10_ENABLE_321_MASK (0x00000002u)
#define CSL_CPINTC_ENABLE_REG10_ENABLE_321_SHIFT (0x00000001u)
#define CSL_CPINTC_ENABLE_REG10_ENABLE_321_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG10_ENABLE_322_MASK (0x00000004u)
#define CSL_CPINTC_ENABLE_REG10_ENABLE_322_SHIFT (0x00000002u)
#define CSL_CPINTC_ENABLE_REG10_ENABLE_322_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG10_ENABLE_323_MASK (0x00000008u)
#define CSL_CPINTC_ENABLE_REG10_ENABLE_323_SHIFT (0x00000003u)
#define CSL_CPINTC_ENABLE_REG10_ENABLE_323_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG10_ENABLE_324_MASK (0x00000010u)
#define CSL_CPINTC_ENABLE_REG10_ENABLE_324_SHIFT (0x00000004u)
#define CSL_CPINTC_ENABLE_REG10_ENABLE_324_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG10_ENABLE_325_MASK (0x00000020u)
#define CSL_CPINTC_ENABLE_REG10_ENABLE_325_SHIFT (0x00000005u)
#define CSL_CPINTC_ENABLE_REG10_ENABLE_325_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG10_ENABLE_326_MASK (0x00000040u)
#define CSL_CPINTC_ENABLE_REG10_ENABLE_326_SHIFT (0x00000006u)
#define CSL_CPINTC_ENABLE_REG10_ENABLE_326_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG10_ENABLE_327_MASK (0x00000080u)
#define CSL_CPINTC_ENABLE_REG10_ENABLE_327_SHIFT (0x00000007u)
#define CSL_CPINTC_ENABLE_REG10_ENABLE_327_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG10_ENABLE_328_MASK (0x00000100u)
#define CSL_CPINTC_ENABLE_REG10_ENABLE_328_SHIFT (0x00000008u)
#define CSL_CPINTC_ENABLE_REG10_ENABLE_328_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG10_ENABLE_329_MASK (0x00000200u)
#define CSL_CPINTC_ENABLE_REG10_ENABLE_329_SHIFT (0x00000009u)
#define CSL_CPINTC_ENABLE_REG10_ENABLE_329_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG10_ENABLE_330_MASK (0x00000400u)
#define CSL_CPINTC_ENABLE_REG10_ENABLE_330_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENABLE_REG10_ENABLE_330_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG10_ENABLE_331_MASK (0x00000800u)
#define CSL_CPINTC_ENABLE_REG10_ENABLE_331_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENABLE_REG10_ENABLE_331_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG10_ENABLE_332_MASK (0x00001000u)
#define CSL_CPINTC_ENABLE_REG10_ENABLE_332_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENABLE_REG10_ENABLE_332_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG10_ENABLE_333_MASK (0x00002000u)
#define CSL_CPINTC_ENABLE_REG10_ENABLE_333_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENABLE_REG10_ENABLE_333_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG10_ENABLE_334_MASK (0x00004000u)
#define CSL_CPINTC_ENABLE_REG10_ENABLE_334_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENABLE_REG10_ENABLE_334_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG10_ENABLE_335_MASK (0x00008000u)
#define CSL_CPINTC_ENABLE_REG10_ENABLE_335_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENABLE_REG10_ENABLE_335_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG10_ENABLE_336_MASK (0x00010000u)
#define CSL_CPINTC_ENABLE_REG10_ENABLE_336_SHIFT (0x00000010u)
#define CSL_CPINTC_ENABLE_REG10_ENABLE_336_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG10_ENABLE_337_MASK (0x00020000u)
#define CSL_CPINTC_ENABLE_REG10_ENABLE_337_SHIFT (0x00000011u)
#define CSL_CPINTC_ENABLE_REG10_ENABLE_337_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG10_ENABLE_338_MASK (0x00040000u)
#define CSL_CPINTC_ENABLE_REG10_ENABLE_338_SHIFT (0x00000012u)
#define CSL_CPINTC_ENABLE_REG10_ENABLE_338_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG10_ENABLE_339_MASK (0x00080000u)
#define CSL_CPINTC_ENABLE_REG10_ENABLE_339_SHIFT (0x00000013u)
#define CSL_CPINTC_ENABLE_REG10_ENABLE_339_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG10_ENABLE_340_MASK (0x00100000u)
#define CSL_CPINTC_ENABLE_REG10_ENABLE_340_SHIFT (0x00000014u)
#define CSL_CPINTC_ENABLE_REG10_ENABLE_340_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG10_ENABLE_341_MASK (0x00200000u)
#define CSL_CPINTC_ENABLE_REG10_ENABLE_341_SHIFT (0x00000015u)
#define CSL_CPINTC_ENABLE_REG10_ENABLE_341_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG10_ENABLE_342_MASK (0x00400000u)
#define CSL_CPINTC_ENABLE_REG10_ENABLE_342_SHIFT (0x00000016u)
#define CSL_CPINTC_ENABLE_REG10_ENABLE_342_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG10_ENABLE_343_MASK (0x00800000u)
#define CSL_CPINTC_ENABLE_REG10_ENABLE_343_SHIFT (0x00000017u)
#define CSL_CPINTC_ENABLE_REG10_ENABLE_343_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG10_ENABLE_344_MASK (0x01000000u)
#define CSL_CPINTC_ENABLE_REG10_ENABLE_344_SHIFT (0x00000018u)
#define CSL_CPINTC_ENABLE_REG10_ENABLE_344_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG10_ENABLE_345_MASK (0x02000000u)
#define CSL_CPINTC_ENABLE_REG10_ENABLE_345_SHIFT (0x00000019u)
#define CSL_CPINTC_ENABLE_REG10_ENABLE_345_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG10_ENABLE_346_MASK (0x04000000u)
#define CSL_CPINTC_ENABLE_REG10_ENABLE_346_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENABLE_REG10_ENABLE_346_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG10_ENABLE_347_MASK (0x08000000u)
#define CSL_CPINTC_ENABLE_REG10_ENABLE_347_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENABLE_REG10_ENABLE_347_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG10_ENABLE_348_MASK (0x10000000u)
#define CSL_CPINTC_ENABLE_REG10_ENABLE_348_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENABLE_REG10_ENABLE_348_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG10_ENABLE_349_MASK (0x20000000u)
#define CSL_CPINTC_ENABLE_REG10_ENABLE_349_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENABLE_REG10_ENABLE_349_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG10_ENABLE_350_MASK (0x40000000u)
#define CSL_CPINTC_ENABLE_REG10_ENABLE_350_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENABLE_REG10_ENABLE_350_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG10_ENABLE_351_MASK (0x80000000u)
#define CSL_CPINTC_ENABLE_REG10_ENABLE_351_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENABLE_REG10_ENABLE_351_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG10_RESETVAL (0x00000000u)

/* enable_reg11 */

#define CSL_CPINTC_ENABLE_REG11_ENABLE_352_MASK (0x00000001u)
#define CSL_CPINTC_ENABLE_REG11_ENABLE_352_SHIFT (0x00000000u)
#define CSL_CPINTC_ENABLE_REG11_ENABLE_352_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG11_ENABLE_353_MASK (0x00000002u)
#define CSL_CPINTC_ENABLE_REG11_ENABLE_353_SHIFT (0x00000001u)
#define CSL_CPINTC_ENABLE_REG11_ENABLE_353_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG11_ENABLE_354_MASK (0x00000004u)
#define CSL_CPINTC_ENABLE_REG11_ENABLE_354_SHIFT (0x00000002u)
#define CSL_CPINTC_ENABLE_REG11_ENABLE_354_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG11_ENABLE_355_MASK (0x00000008u)
#define CSL_CPINTC_ENABLE_REG11_ENABLE_355_SHIFT (0x00000003u)
#define CSL_CPINTC_ENABLE_REG11_ENABLE_355_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG11_ENABLE_356_MASK (0x00000010u)
#define CSL_CPINTC_ENABLE_REG11_ENABLE_356_SHIFT (0x00000004u)
#define CSL_CPINTC_ENABLE_REG11_ENABLE_356_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG11_ENABLE_357_MASK (0x00000020u)
#define CSL_CPINTC_ENABLE_REG11_ENABLE_357_SHIFT (0x00000005u)
#define CSL_CPINTC_ENABLE_REG11_ENABLE_357_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG11_ENABLE_358_MASK (0x00000040u)
#define CSL_CPINTC_ENABLE_REG11_ENABLE_358_SHIFT (0x00000006u)
#define CSL_CPINTC_ENABLE_REG11_ENABLE_358_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG11_ENABLE_359_MASK (0x00000080u)
#define CSL_CPINTC_ENABLE_REG11_ENABLE_359_SHIFT (0x00000007u)
#define CSL_CPINTC_ENABLE_REG11_ENABLE_359_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG11_ENABLE_360_MASK (0x00000100u)
#define CSL_CPINTC_ENABLE_REG11_ENABLE_360_SHIFT (0x00000008u)
#define CSL_CPINTC_ENABLE_REG11_ENABLE_360_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG11_ENABLE_361_MASK (0x00000200u)
#define CSL_CPINTC_ENABLE_REG11_ENABLE_361_SHIFT (0x00000009u)
#define CSL_CPINTC_ENABLE_REG11_ENABLE_361_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG11_ENABLE_362_MASK (0x00000400u)
#define CSL_CPINTC_ENABLE_REG11_ENABLE_362_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENABLE_REG11_ENABLE_362_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG11_ENABLE_363_MASK (0x00000800u)
#define CSL_CPINTC_ENABLE_REG11_ENABLE_363_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENABLE_REG11_ENABLE_363_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG11_ENABLE_364_MASK (0x00001000u)
#define CSL_CPINTC_ENABLE_REG11_ENABLE_364_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENABLE_REG11_ENABLE_364_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG11_ENABLE_365_MASK (0x00002000u)
#define CSL_CPINTC_ENABLE_REG11_ENABLE_365_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENABLE_REG11_ENABLE_365_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG11_ENABLE_366_MASK (0x00004000u)
#define CSL_CPINTC_ENABLE_REG11_ENABLE_366_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENABLE_REG11_ENABLE_366_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG11_ENABLE_367_MASK (0x00008000u)
#define CSL_CPINTC_ENABLE_REG11_ENABLE_367_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENABLE_REG11_ENABLE_367_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG11_ENABLE_368_MASK (0x00010000u)
#define CSL_CPINTC_ENABLE_REG11_ENABLE_368_SHIFT (0x00000010u)
#define CSL_CPINTC_ENABLE_REG11_ENABLE_368_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG11_ENABLE_369_MASK (0x00020000u)
#define CSL_CPINTC_ENABLE_REG11_ENABLE_369_SHIFT (0x00000011u)
#define CSL_CPINTC_ENABLE_REG11_ENABLE_369_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG11_ENABLE_370_MASK (0x00040000u)
#define CSL_CPINTC_ENABLE_REG11_ENABLE_370_SHIFT (0x00000012u)
#define CSL_CPINTC_ENABLE_REG11_ENABLE_370_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG11_ENABLE_371_MASK (0x00080000u)
#define CSL_CPINTC_ENABLE_REG11_ENABLE_371_SHIFT (0x00000013u)
#define CSL_CPINTC_ENABLE_REG11_ENABLE_371_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG11_ENABLE_372_MASK (0x00100000u)
#define CSL_CPINTC_ENABLE_REG11_ENABLE_372_SHIFT (0x00000014u)
#define CSL_CPINTC_ENABLE_REG11_ENABLE_372_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG11_ENABLE_373_MASK (0x00200000u)
#define CSL_CPINTC_ENABLE_REG11_ENABLE_373_SHIFT (0x00000015u)
#define CSL_CPINTC_ENABLE_REG11_ENABLE_373_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG11_ENABLE_374_MASK (0x00400000u)
#define CSL_CPINTC_ENABLE_REG11_ENABLE_374_SHIFT (0x00000016u)
#define CSL_CPINTC_ENABLE_REG11_ENABLE_374_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG11_ENABLE_375_MASK (0x00800000u)
#define CSL_CPINTC_ENABLE_REG11_ENABLE_375_SHIFT (0x00000017u)
#define CSL_CPINTC_ENABLE_REG11_ENABLE_375_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG11_ENABLE_376_MASK (0x01000000u)
#define CSL_CPINTC_ENABLE_REG11_ENABLE_376_SHIFT (0x00000018u)
#define CSL_CPINTC_ENABLE_REG11_ENABLE_376_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG11_ENABLE_377_MASK (0x02000000u)
#define CSL_CPINTC_ENABLE_REG11_ENABLE_377_SHIFT (0x00000019u)
#define CSL_CPINTC_ENABLE_REG11_ENABLE_377_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG11_ENABLE_378_MASK (0x04000000u)
#define CSL_CPINTC_ENABLE_REG11_ENABLE_378_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENABLE_REG11_ENABLE_378_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG11_ENABLE_379_MASK (0x08000000u)
#define CSL_CPINTC_ENABLE_REG11_ENABLE_379_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENABLE_REG11_ENABLE_379_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG11_ENABLE_380_MASK (0x10000000u)
#define CSL_CPINTC_ENABLE_REG11_ENABLE_380_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENABLE_REG11_ENABLE_380_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG11_ENABLE_381_MASK (0x20000000u)
#define CSL_CPINTC_ENABLE_REG11_ENABLE_381_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENABLE_REG11_ENABLE_381_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG11_ENABLE_382_MASK (0x40000000u)
#define CSL_CPINTC_ENABLE_REG11_ENABLE_382_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENABLE_REG11_ENABLE_382_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG11_ENABLE_383_MASK (0x80000000u)
#define CSL_CPINTC_ENABLE_REG11_ENABLE_383_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENABLE_REG11_ENABLE_383_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG11_RESETVAL (0x00000000u)

/* enable_reg12 */

#define CSL_CPINTC_ENABLE_REG12_ENABLE_384_MASK (0x00000001u)
#define CSL_CPINTC_ENABLE_REG12_ENABLE_384_SHIFT (0x00000000u)
#define CSL_CPINTC_ENABLE_REG12_ENABLE_384_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG12_ENABLE_385_MASK (0x00000002u)
#define CSL_CPINTC_ENABLE_REG12_ENABLE_385_SHIFT (0x00000001u)
#define CSL_CPINTC_ENABLE_REG12_ENABLE_385_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG12_ENABLE_386_MASK (0x00000004u)
#define CSL_CPINTC_ENABLE_REG12_ENABLE_386_SHIFT (0x00000002u)
#define CSL_CPINTC_ENABLE_REG12_ENABLE_386_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG12_ENABLE_387_MASK (0x00000008u)
#define CSL_CPINTC_ENABLE_REG12_ENABLE_387_SHIFT (0x00000003u)
#define CSL_CPINTC_ENABLE_REG12_ENABLE_387_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG12_ENABLE_388_MASK (0x00000010u)
#define CSL_CPINTC_ENABLE_REG12_ENABLE_388_SHIFT (0x00000004u)
#define CSL_CPINTC_ENABLE_REG12_ENABLE_388_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG12_ENABLE_389_MASK (0x00000020u)
#define CSL_CPINTC_ENABLE_REG12_ENABLE_389_SHIFT (0x00000005u)
#define CSL_CPINTC_ENABLE_REG12_ENABLE_389_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG12_ENABLE_390_MASK (0x00000040u)
#define CSL_CPINTC_ENABLE_REG12_ENABLE_390_SHIFT (0x00000006u)
#define CSL_CPINTC_ENABLE_REG12_ENABLE_390_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG12_ENABLE_391_MASK (0x00000080u)
#define CSL_CPINTC_ENABLE_REG12_ENABLE_391_SHIFT (0x00000007u)
#define CSL_CPINTC_ENABLE_REG12_ENABLE_391_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG12_ENABLE_392_MASK (0x00000100u)
#define CSL_CPINTC_ENABLE_REG12_ENABLE_392_SHIFT (0x00000008u)
#define CSL_CPINTC_ENABLE_REG12_ENABLE_392_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG12_ENABLE_393_MASK (0x00000200u)
#define CSL_CPINTC_ENABLE_REG12_ENABLE_393_SHIFT (0x00000009u)
#define CSL_CPINTC_ENABLE_REG12_ENABLE_393_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG12_ENABLE_394_MASK (0x00000400u)
#define CSL_CPINTC_ENABLE_REG12_ENABLE_394_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENABLE_REG12_ENABLE_394_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG12_ENABLE_395_MASK (0x00000800u)
#define CSL_CPINTC_ENABLE_REG12_ENABLE_395_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENABLE_REG12_ENABLE_395_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG12_ENABLE_396_MASK (0x00001000u)
#define CSL_CPINTC_ENABLE_REG12_ENABLE_396_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENABLE_REG12_ENABLE_396_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG12_ENABLE_397_MASK (0x00002000u)
#define CSL_CPINTC_ENABLE_REG12_ENABLE_397_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENABLE_REG12_ENABLE_397_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG12_ENABLE_398_MASK (0x00004000u)
#define CSL_CPINTC_ENABLE_REG12_ENABLE_398_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENABLE_REG12_ENABLE_398_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG12_ENABLE_399_MASK (0x00008000u)
#define CSL_CPINTC_ENABLE_REG12_ENABLE_399_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENABLE_REG12_ENABLE_399_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG12_ENABLE_400_MASK (0x00010000u)
#define CSL_CPINTC_ENABLE_REG12_ENABLE_400_SHIFT (0x00000010u)
#define CSL_CPINTC_ENABLE_REG12_ENABLE_400_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG12_ENABLE_401_MASK (0x00020000u)
#define CSL_CPINTC_ENABLE_REG12_ENABLE_401_SHIFT (0x00000011u)
#define CSL_CPINTC_ENABLE_REG12_ENABLE_401_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG12_ENABLE_402_MASK (0x00040000u)
#define CSL_CPINTC_ENABLE_REG12_ENABLE_402_SHIFT (0x00000012u)
#define CSL_CPINTC_ENABLE_REG12_ENABLE_402_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG12_ENABLE_403_MASK (0x00080000u)
#define CSL_CPINTC_ENABLE_REG12_ENABLE_403_SHIFT (0x00000013u)
#define CSL_CPINTC_ENABLE_REG12_ENABLE_403_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG12_ENABLE_404_MASK (0x00100000u)
#define CSL_CPINTC_ENABLE_REG12_ENABLE_404_SHIFT (0x00000014u)
#define CSL_CPINTC_ENABLE_REG12_ENABLE_404_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG12_ENABLE_405_MASK (0x00200000u)
#define CSL_CPINTC_ENABLE_REG12_ENABLE_405_SHIFT (0x00000015u)
#define CSL_CPINTC_ENABLE_REG12_ENABLE_405_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG12_ENABLE_406_MASK (0x00400000u)
#define CSL_CPINTC_ENABLE_REG12_ENABLE_406_SHIFT (0x00000016u)
#define CSL_CPINTC_ENABLE_REG12_ENABLE_406_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG12_ENABLE_407_MASK (0x00800000u)
#define CSL_CPINTC_ENABLE_REG12_ENABLE_407_SHIFT (0x00000017u)
#define CSL_CPINTC_ENABLE_REG12_ENABLE_407_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG12_ENABLE_408_MASK (0x01000000u)
#define CSL_CPINTC_ENABLE_REG12_ENABLE_408_SHIFT (0x00000018u)
#define CSL_CPINTC_ENABLE_REG12_ENABLE_408_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG12_ENABLE_409_MASK (0x02000000u)
#define CSL_CPINTC_ENABLE_REG12_ENABLE_409_SHIFT (0x00000019u)
#define CSL_CPINTC_ENABLE_REG12_ENABLE_409_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG12_ENABLE_410_MASK (0x04000000u)
#define CSL_CPINTC_ENABLE_REG12_ENABLE_410_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENABLE_REG12_ENABLE_410_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG12_ENABLE_411_MASK (0x08000000u)
#define CSL_CPINTC_ENABLE_REG12_ENABLE_411_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENABLE_REG12_ENABLE_411_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG12_ENABLE_412_MASK (0x10000000u)
#define CSL_CPINTC_ENABLE_REG12_ENABLE_412_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENABLE_REG12_ENABLE_412_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG12_ENABLE_413_MASK (0x20000000u)
#define CSL_CPINTC_ENABLE_REG12_ENABLE_413_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENABLE_REG12_ENABLE_413_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG12_ENABLE_414_MASK (0x40000000u)
#define CSL_CPINTC_ENABLE_REG12_ENABLE_414_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENABLE_REG12_ENABLE_414_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG12_ENABLE_415_MASK (0x80000000u)
#define CSL_CPINTC_ENABLE_REG12_ENABLE_415_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENABLE_REG12_ENABLE_415_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG12_RESETVAL (0x00000000u)

/* enable_reg13 */

#define CSL_CPINTC_ENABLE_REG13_ENABLE_416_MASK (0x00000001u)
#define CSL_CPINTC_ENABLE_REG13_ENABLE_416_SHIFT (0x00000000u)
#define CSL_CPINTC_ENABLE_REG13_ENABLE_416_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG13_ENABLE_417_MASK (0x00000002u)
#define CSL_CPINTC_ENABLE_REG13_ENABLE_417_SHIFT (0x00000001u)
#define CSL_CPINTC_ENABLE_REG13_ENABLE_417_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG13_ENABLE_418_MASK (0x00000004u)
#define CSL_CPINTC_ENABLE_REG13_ENABLE_418_SHIFT (0x00000002u)
#define CSL_CPINTC_ENABLE_REG13_ENABLE_418_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG13_ENABLE_419_MASK (0x00000008u)
#define CSL_CPINTC_ENABLE_REG13_ENABLE_419_SHIFT (0x00000003u)
#define CSL_CPINTC_ENABLE_REG13_ENABLE_419_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG13_ENABLE_420_MASK (0x00000010u)
#define CSL_CPINTC_ENABLE_REG13_ENABLE_420_SHIFT (0x00000004u)
#define CSL_CPINTC_ENABLE_REG13_ENABLE_420_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG13_ENABLE_421_MASK (0x00000020u)
#define CSL_CPINTC_ENABLE_REG13_ENABLE_421_SHIFT (0x00000005u)
#define CSL_CPINTC_ENABLE_REG13_ENABLE_421_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG13_ENABLE_422_MASK (0x00000040u)
#define CSL_CPINTC_ENABLE_REG13_ENABLE_422_SHIFT (0x00000006u)
#define CSL_CPINTC_ENABLE_REG13_ENABLE_422_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG13_ENABLE_423_MASK (0x00000080u)
#define CSL_CPINTC_ENABLE_REG13_ENABLE_423_SHIFT (0x00000007u)
#define CSL_CPINTC_ENABLE_REG13_ENABLE_423_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG13_ENABLE_424_MASK (0x00000100u)
#define CSL_CPINTC_ENABLE_REG13_ENABLE_424_SHIFT (0x00000008u)
#define CSL_CPINTC_ENABLE_REG13_ENABLE_424_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG13_ENABLE_425_MASK (0x00000200u)
#define CSL_CPINTC_ENABLE_REG13_ENABLE_425_SHIFT (0x00000009u)
#define CSL_CPINTC_ENABLE_REG13_ENABLE_425_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG13_ENABLE_426_MASK (0x00000400u)
#define CSL_CPINTC_ENABLE_REG13_ENABLE_426_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENABLE_REG13_ENABLE_426_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG13_ENABLE_427_MASK (0x00000800u)
#define CSL_CPINTC_ENABLE_REG13_ENABLE_427_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENABLE_REG13_ENABLE_427_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG13_ENABLE_428_MASK (0x00001000u)
#define CSL_CPINTC_ENABLE_REG13_ENABLE_428_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENABLE_REG13_ENABLE_428_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG13_ENABLE_429_MASK (0x00002000u)
#define CSL_CPINTC_ENABLE_REG13_ENABLE_429_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENABLE_REG13_ENABLE_429_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG13_ENABLE_430_MASK (0x00004000u)
#define CSL_CPINTC_ENABLE_REG13_ENABLE_430_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENABLE_REG13_ENABLE_430_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG13_ENABLE_431_MASK (0x00008000u)
#define CSL_CPINTC_ENABLE_REG13_ENABLE_431_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENABLE_REG13_ENABLE_431_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG13_ENABLE_432_MASK (0x00010000u)
#define CSL_CPINTC_ENABLE_REG13_ENABLE_432_SHIFT (0x00000010u)
#define CSL_CPINTC_ENABLE_REG13_ENABLE_432_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG13_ENABLE_433_MASK (0x00020000u)
#define CSL_CPINTC_ENABLE_REG13_ENABLE_433_SHIFT (0x00000011u)
#define CSL_CPINTC_ENABLE_REG13_ENABLE_433_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG13_ENABLE_434_MASK (0x00040000u)
#define CSL_CPINTC_ENABLE_REG13_ENABLE_434_SHIFT (0x00000012u)
#define CSL_CPINTC_ENABLE_REG13_ENABLE_434_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG13_ENABLE_435_MASK (0x00080000u)
#define CSL_CPINTC_ENABLE_REG13_ENABLE_435_SHIFT (0x00000013u)
#define CSL_CPINTC_ENABLE_REG13_ENABLE_435_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG13_ENABLE_436_MASK (0x00100000u)
#define CSL_CPINTC_ENABLE_REG13_ENABLE_436_SHIFT (0x00000014u)
#define CSL_CPINTC_ENABLE_REG13_ENABLE_436_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG13_ENABLE_437_MASK (0x00200000u)
#define CSL_CPINTC_ENABLE_REG13_ENABLE_437_SHIFT (0x00000015u)
#define CSL_CPINTC_ENABLE_REG13_ENABLE_437_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG13_ENABLE_438_MASK (0x00400000u)
#define CSL_CPINTC_ENABLE_REG13_ENABLE_438_SHIFT (0x00000016u)
#define CSL_CPINTC_ENABLE_REG13_ENABLE_438_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG13_ENABLE_439_MASK (0x00800000u)
#define CSL_CPINTC_ENABLE_REG13_ENABLE_439_SHIFT (0x00000017u)
#define CSL_CPINTC_ENABLE_REG13_ENABLE_439_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG13_ENABLE_440_MASK (0x01000000u)
#define CSL_CPINTC_ENABLE_REG13_ENABLE_440_SHIFT (0x00000018u)
#define CSL_CPINTC_ENABLE_REG13_ENABLE_440_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG13_ENABLE_441_MASK (0x02000000u)
#define CSL_CPINTC_ENABLE_REG13_ENABLE_441_SHIFT (0x00000019u)
#define CSL_CPINTC_ENABLE_REG13_ENABLE_441_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG13_ENABLE_442_MASK (0x04000000u)
#define CSL_CPINTC_ENABLE_REG13_ENABLE_442_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENABLE_REG13_ENABLE_442_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG13_ENABLE_443_MASK (0x08000000u)
#define CSL_CPINTC_ENABLE_REG13_ENABLE_443_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENABLE_REG13_ENABLE_443_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG13_ENABLE_444_MASK (0x10000000u)
#define CSL_CPINTC_ENABLE_REG13_ENABLE_444_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENABLE_REG13_ENABLE_444_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG13_ENABLE_445_MASK (0x20000000u)
#define CSL_CPINTC_ENABLE_REG13_ENABLE_445_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENABLE_REG13_ENABLE_445_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG13_ENABLE_446_MASK (0x40000000u)
#define CSL_CPINTC_ENABLE_REG13_ENABLE_446_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENABLE_REG13_ENABLE_446_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG13_ENABLE_447_MASK (0x80000000u)
#define CSL_CPINTC_ENABLE_REG13_ENABLE_447_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENABLE_REG13_ENABLE_447_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG13_RESETVAL (0x00000000u)

/* enable_reg14 */

#define CSL_CPINTC_ENABLE_REG14_ENABLE_448_MASK (0x00000001u)
#define CSL_CPINTC_ENABLE_REG14_ENABLE_448_SHIFT (0x00000000u)
#define CSL_CPINTC_ENABLE_REG14_ENABLE_448_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG14_ENABLE_449_MASK (0x00000002u)
#define CSL_CPINTC_ENABLE_REG14_ENABLE_449_SHIFT (0x00000001u)
#define CSL_CPINTC_ENABLE_REG14_ENABLE_449_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG14_ENABLE_450_MASK (0x00000004u)
#define CSL_CPINTC_ENABLE_REG14_ENABLE_450_SHIFT (0x00000002u)
#define CSL_CPINTC_ENABLE_REG14_ENABLE_450_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG14_ENABLE_451_MASK (0x00000008u)
#define CSL_CPINTC_ENABLE_REG14_ENABLE_451_SHIFT (0x00000003u)
#define CSL_CPINTC_ENABLE_REG14_ENABLE_451_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG14_ENABLE_452_MASK (0x00000010u)
#define CSL_CPINTC_ENABLE_REG14_ENABLE_452_SHIFT (0x00000004u)
#define CSL_CPINTC_ENABLE_REG14_ENABLE_452_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG14_ENABLE_453_MASK (0x00000020u)
#define CSL_CPINTC_ENABLE_REG14_ENABLE_453_SHIFT (0x00000005u)
#define CSL_CPINTC_ENABLE_REG14_ENABLE_453_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG14_ENABLE_454_MASK (0x00000040u)
#define CSL_CPINTC_ENABLE_REG14_ENABLE_454_SHIFT (0x00000006u)
#define CSL_CPINTC_ENABLE_REG14_ENABLE_454_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG14_ENABLE_455_MASK (0x00000080u)
#define CSL_CPINTC_ENABLE_REG14_ENABLE_455_SHIFT (0x00000007u)
#define CSL_CPINTC_ENABLE_REG14_ENABLE_455_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG14_ENABLE_456_MASK (0x00000100u)
#define CSL_CPINTC_ENABLE_REG14_ENABLE_456_SHIFT (0x00000008u)
#define CSL_CPINTC_ENABLE_REG14_ENABLE_456_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG14_ENABLE_457_MASK (0x00000200u)
#define CSL_CPINTC_ENABLE_REG14_ENABLE_457_SHIFT (0x00000009u)
#define CSL_CPINTC_ENABLE_REG14_ENABLE_457_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG14_ENABLE_458_MASK (0x00000400u)
#define CSL_CPINTC_ENABLE_REG14_ENABLE_458_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENABLE_REG14_ENABLE_458_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG14_ENABLE_459_MASK (0x00000800u)
#define CSL_CPINTC_ENABLE_REG14_ENABLE_459_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENABLE_REG14_ENABLE_459_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG14_ENABLE_460_MASK (0x00001000u)
#define CSL_CPINTC_ENABLE_REG14_ENABLE_460_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENABLE_REG14_ENABLE_460_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG14_ENABLE_461_MASK (0x00002000u)
#define CSL_CPINTC_ENABLE_REG14_ENABLE_461_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENABLE_REG14_ENABLE_461_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG14_ENABLE_462_MASK (0x00004000u)
#define CSL_CPINTC_ENABLE_REG14_ENABLE_462_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENABLE_REG14_ENABLE_462_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG14_ENABLE_463_MASK (0x00008000u)
#define CSL_CPINTC_ENABLE_REG14_ENABLE_463_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENABLE_REG14_ENABLE_463_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG14_ENABLE_464_MASK (0x00010000u)
#define CSL_CPINTC_ENABLE_REG14_ENABLE_464_SHIFT (0x00000010u)
#define CSL_CPINTC_ENABLE_REG14_ENABLE_464_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG14_ENABLE_465_MASK (0x00020000u)
#define CSL_CPINTC_ENABLE_REG14_ENABLE_465_SHIFT (0x00000011u)
#define CSL_CPINTC_ENABLE_REG14_ENABLE_465_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG14_ENABLE_466_MASK (0x00040000u)
#define CSL_CPINTC_ENABLE_REG14_ENABLE_466_SHIFT (0x00000012u)
#define CSL_CPINTC_ENABLE_REG14_ENABLE_466_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG14_ENABLE_467_MASK (0x00080000u)
#define CSL_CPINTC_ENABLE_REG14_ENABLE_467_SHIFT (0x00000013u)
#define CSL_CPINTC_ENABLE_REG14_ENABLE_467_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG14_ENABLE_468_MASK (0x00100000u)
#define CSL_CPINTC_ENABLE_REG14_ENABLE_468_SHIFT (0x00000014u)
#define CSL_CPINTC_ENABLE_REG14_ENABLE_468_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG14_ENABLE_469_MASK (0x00200000u)
#define CSL_CPINTC_ENABLE_REG14_ENABLE_469_SHIFT (0x00000015u)
#define CSL_CPINTC_ENABLE_REG14_ENABLE_469_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG14_ENABLE_470_MASK (0x00400000u)
#define CSL_CPINTC_ENABLE_REG14_ENABLE_470_SHIFT (0x00000016u)
#define CSL_CPINTC_ENABLE_REG14_ENABLE_470_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG14_ENABLE_471_MASK (0x00800000u)
#define CSL_CPINTC_ENABLE_REG14_ENABLE_471_SHIFT (0x00000017u)
#define CSL_CPINTC_ENABLE_REG14_ENABLE_471_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG14_ENABLE_472_MASK (0x01000000u)
#define CSL_CPINTC_ENABLE_REG14_ENABLE_472_SHIFT (0x00000018u)
#define CSL_CPINTC_ENABLE_REG14_ENABLE_472_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG14_ENABLE_473_MASK (0x02000000u)
#define CSL_CPINTC_ENABLE_REG14_ENABLE_473_SHIFT (0x00000019u)
#define CSL_CPINTC_ENABLE_REG14_ENABLE_473_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG14_ENABLE_474_MASK (0x04000000u)
#define CSL_CPINTC_ENABLE_REG14_ENABLE_474_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENABLE_REG14_ENABLE_474_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG14_ENABLE_475_MASK (0x08000000u)
#define CSL_CPINTC_ENABLE_REG14_ENABLE_475_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENABLE_REG14_ENABLE_475_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG14_ENABLE_476_MASK (0x10000000u)
#define CSL_CPINTC_ENABLE_REG14_ENABLE_476_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENABLE_REG14_ENABLE_476_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG14_ENABLE_477_MASK (0x20000000u)
#define CSL_CPINTC_ENABLE_REG14_ENABLE_477_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENABLE_REG14_ENABLE_477_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG14_ENABLE_478_MASK (0x40000000u)
#define CSL_CPINTC_ENABLE_REG14_ENABLE_478_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENABLE_REG14_ENABLE_478_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG14_ENABLE_479_MASK (0x80000000u)
#define CSL_CPINTC_ENABLE_REG14_ENABLE_479_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENABLE_REG14_ENABLE_479_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG14_RESETVAL (0x00000000u)

/* enable_reg15 */

#define CSL_CPINTC_ENABLE_REG15_ENABLE_480_MASK (0x00000001u)
#define CSL_CPINTC_ENABLE_REG15_ENABLE_480_SHIFT (0x00000000u)
#define CSL_CPINTC_ENABLE_REG15_ENABLE_480_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG15_ENABLE_481_MASK (0x00000002u)
#define CSL_CPINTC_ENABLE_REG15_ENABLE_481_SHIFT (0x00000001u)
#define CSL_CPINTC_ENABLE_REG15_ENABLE_481_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG15_ENABLE_482_MASK (0x00000004u)
#define CSL_CPINTC_ENABLE_REG15_ENABLE_482_SHIFT (0x00000002u)
#define CSL_CPINTC_ENABLE_REG15_ENABLE_482_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG15_ENABLE_483_MASK (0x00000008u)
#define CSL_CPINTC_ENABLE_REG15_ENABLE_483_SHIFT (0x00000003u)
#define CSL_CPINTC_ENABLE_REG15_ENABLE_483_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG15_ENABLE_484_MASK (0x00000010u)
#define CSL_CPINTC_ENABLE_REG15_ENABLE_484_SHIFT (0x00000004u)
#define CSL_CPINTC_ENABLE_REG15_ENABLE_484_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG15_ENABLE_485_MASK (0x00000020u)
#define CSL_CPINTC_ENABLE_REG15_ENABLE_485_SHIFT (0x00000005u)
#define CSL_CPINTC_ENABLE_REG15_ENABLE_485_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG15_ENABLE_486_MASK (0x00000040u)
#define CSL_CPINTC_ENABLE_REG15_ENABLE_486_SHIFT (0x00000006u)
#define CSL_CPINTC_ENABLE_REG15_ENABLE_486_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG15_ENABLE_487_MASK (0x00000080u)
#define CSL_CPINTC_ENABLE_REG15_ENABLE_487_SHIFT (0x00000007u)
#define CSL_CPINTC_ENABLE_REG15_ENABLE_487_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG15_ENABLE_488_MASK (0x00000100u)
#define CSL_CPINTC_ENABLE_REG15_ENABLE_488_SHIFT (0x00000008u)
#define CSL_CPINTC_ENABLE_REG15_ENABLE_488_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG15_ENABLE_489_MASK (0x00000200u)
#define CSL_CPINTC_ENABLE_REG15_ENABLE_489_SHIFT (0x00000009u)
#define CSL_CPINTC_ENABLE_REG15_ENABLE_489_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG15_ENABLE_490_MASK (0x00000400u)
#define CSL_CPINTC_ENABLE_REG15_ENABLE_490_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENABLE_REG15_ENABLE_490_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG15_ENABLE_491_MASK (0x00000800u)
#define CSL_CPINTC_ENABLE_REG15_ENABLE_491_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENABLE_REG15_ENABLE_491_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG15_ENABLE_492_MASK (0x00001000u)
#define CSL_CPINTC_ENABLE_REG15_ENABLE_492_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENABLE_REG15_ENABLE_492_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG15_ENABLE_493_MASK (0x00002000u)
#define CSL_CPINTC_ENABLE_REG15_ENABLE_493_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENABLE_REG15_ENABLE_493_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG15_ENABLE_494_MASK (0x00004000u)
#define CSL_CPINTC_ENABLE_REG15_ENABLE_494_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENABLE_REG15_ENABLE_494_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG15_ENABLE_495_MASK (0x00008000u)
#define CSL_CPINTC_ENABLE_REG15_ENABLE_495_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENABLE_REG15_ENABLE_495_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG15_ENABLE_496_MASK (0x00010000u)
#define CSL_CPINTC_ENABLE_REG15_ENABLE_496_SHIFT (0x00000010u)
#define CSL_CPINTC_ENABLE_REG15_ENABLE_496_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG15_ENABLE_497_MASK (0x00020000u)
#define CSL_CPINTC_ENABLE_REG15_ENABLE_497_SHIFT (0x00000011u)
#define CSL_CPINTC_ENABLE_REG15_ENABLE_497_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG15_ENABLE_498_MASK (0x00040000u)
#define CSL_CPINTC_ENABLE_REG15_ENABLE_498_SHIFT (0x00000012u)
#define CSL_CPINTC_ENABLE_REG15_ENABLE_498_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG15_ENABLE_499_MASK (0x00080000u)
#define CSL_CPINTC_ENABLE_REG15_ENABLE_499_SHIFT (0x00000013u)
#define CSL_CPINTC_ENABLE_REG15_ENABLE_499_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG15_ENABLE_500_MASK (0x00100000u)
#define CSL_CPINTC_ENABLE_REG15_ENABLE_500_SHIFT (0x00000014u)
#define CSL_CPINTC_ENABLE_REG15_ENABLE_500_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG15_ENABLE_501_MASK (0x00200000u)
#define CSL_CPINTC_ENABLE_REG15_ENABLE_501_SHIFT (0x00000015u)
#define CSL_CPINTC_ENABLE_REG15_ENABLE_501_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG15_ENABLE_502_MASK (0x00400000u)
#define CSL_CPINTC_ENABLE_REG15_ENABLE_502_SHIFT (0x00000016u)
#define CSL_CPINTC_ENABLE_REG15_ENABLE_502_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG15_ENABLE_503_MASK (0x00800000u)
#define CSL_CPINTC_ENABLE_REG15_ENABLE_503_SHIFT (0x00000017u)
#define CSL_CPINTC_ENABLE_REG15_ENABLE_503_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG15_ENABLE_504_MASK (0x01000000u)
#define CSL_CPINTC_ENABLE_REG15_ENABLE_504_SHIFT (0x00000018u)
#define CSL_CPINTC_ENABLE_REG15_ENABLE_504_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG15_ENABLE_505_MASK (0x02000000u)
#define CSL_CPINTC_ENABLE_REG15_ENABLE_505_SHIFT (0x00000019u)
#define CSL_CPINTC_ENABLE_REG15_ENABLE_505_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG15_ENABLE_506_MASK (0x04000000u)
#define CSL_CPINTC_ENABLE_REG15_ENABLE_506_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENABLE_REG15_ENABLE_506_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG15_ENABLE_507_MASK (0x08000000u)
#define CSL_CPINTC_ENABLE_REG15_ENABLE_507_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENABLE_REG15_ENABLE_507_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG15_ENABLE_508_MASK (0x10000000u)
#define CSL_CPINTC_ENABLE_REG15_ENABLE_508_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENABLE_REG15_ENABLE_508_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG15_ENABLE_509_MASK (0x20000000u)
#define CSL_CPINTC_ENABLE_REG15_ENABLE_509_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENABLE_REG15_ENABLE_509_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG15_ENABLE_510_MASK (0x40000000u)
#define CSL_CPINTC_ENABLE_REG15_ENABLE_510_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENABLE_REG15_ENABLE_510_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG15_ENABLE_511_MASK (0x80000000u)
#define CSL_CPINTC_ENABLE_REG15_ENABLE_511_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENABLE_REG15_ENABLE_511_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG15_RESETVAL (0x00000000u)

/* enable_reg16 */

#define CSL_CPINTC_ENABLE_REG16_ENABLE_512_MASK (0x00000001u)
#define CSL_CPINTC_ENABLE_REG16_ENABLE_512_SHIFT (0x00000000u)
#define CSL_CPINTC_ENABLE_REG16_ENABLE_512_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG16_ENABLE_513_MASK (0x00000002u)
#define CSL_CPINTC_ENABLE_REG16_ENABLE_513_SHIFT (0x00000001u)
#define CSL_CPINTC_ENABLE_REG16_ENABLE_513_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG16_ENABLE_514_MASK (0x00000004u)
#define CSL_CPINTC_ENABLE_REG16_ENABLE_514_SHIFT (0x00000002u)
#define CSL_CPINTC_ENABLE_REG16_ENABLE_514_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG16_ENABLE_515_MASK (0x00000008u)
#define CSL_CPINTC_ENABLE_REG16_ENABLE_515_SHIFT (0x00000003u)
#define CSL_CPINTC_ENABLE_REG16_ENABLE_515_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG16_ENABLE_516_MASK (0x00000010u)
#define CSL_CPINTC_ENABLE_REG16_ENABLE_516_SHIFT (0x00000004u)
#define CSL_CPINTC_ENABLE_REG16_ENABLE_516_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG16_ENABLE_517_MASK (0x00000020u)
#define CSL_CPINTC_ENABLE_REG16_ENABLE_517_SHIFT (0x00000005u)
#define CSL_CPINTC_ENABLE_REG16_ENABLE_517_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG16_ENABLE_518_MASK (0x00000040u)
#define CSL_CPINTC_ENABLE_REG16_ENABLE_518_SHIFT (0x00000006u)
#define CSL_CPINTC_ENABLE_REG16_ENABLE_518_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG16_ENABLE_519_MASK (0x00000080u)
#define CSL_CPINTC_ENABLE_REG16_ENABLE_519_SHIFT (0x00000007u)
#define CSL_CPINTC_ENABLE_REG16_ENABLE_519_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG16_ENABLE_520_MASK (0x00000100u)
#define CSL_CPINTC_ENABLE_REG16_ENABLE_520_SHIFT (0x00000008u)
#define CSL_CPINTC_ENABLE_REG16_ENABLE_520_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG16_ENABLE_521_MASK (0x00000200u)
#define CSL_CPINTC_ENABLE_REG16_ENABLE_521_SHIFT (0x00000009u)
#define CSL_CPINTC_ENABLE_REG16_ENABLE_521_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG16_ENABLE_522_MASK (0x00000400u)
#define CSL_CPINTC_ENABLE_REG16_ENABLE_522_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENABLE_REG16_ENABLE_522_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG16_ENABLE_523_MASK (0x00000800u)
#define CSL_CPINTC_ENABLE_REG16_ENABLE_523_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENABLE_REG16_ENABLE_523_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG16_ENABLE_524_MASK (0x00001000u)
#define CSL_CPINTC_ENABLE_REG16_ENABLE_524_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENABLE_REG16_ENABLE_524_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG16_ENABLE_525_MASK (0x00002000u)
#define CSL_CPINTC_ENABLE_REG16_ENABLE_525_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENABLE_REG16_ENABLE_525_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG16_ENABLE_526_MASK (0x00004000u)
#define CSL_CPINTC_ENABLE_REG16_ENABLE_526_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENABLE_REG16_ENABLE_526_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG16_ENABLE_527_MASK (0x00008000u)
#define CSL_CPINTC_ENABLE_REG16_ENABLE_527_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENABLE_REG16_ENABLE_527_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG16_ENABLE_528_MASK (0x00010000u)
#define CSL_CPINTC_ENABLE_REG16_ENABLE_528_SHIFT (0x00000010u)
#define CSL_CPINTC_ENABLE_REG16_ENABLE_528_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG16_ENABLE_529_MASK (0x00020000u)
#define CSL_CPINTC_ENABLE_REG16_ENABLE_529_SHIFT (0x00000011u)
#define CSL_CPINTC_ENABLE_REG16_ENABLE_529_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG16_ENABLE_530_MASK (0x00040000u)
#define CSL_CPINTC_ENABLE_REG16_ENABLE_530_SHIFT (0x00000012u)
#define CSL_CPINTC_ENABLE_REG16_ENABLE_530_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG16_ENABLE_531_MASK (0x00080000u)
#define CSL_CPINTC_ENABLE_REG16_ENABLE_531_SHIFT (0x00000013u)
#define CSL_CPINTC_ENABLE_REG16_ENABLE_531_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG16_ENABLE_532_MASK (0x00100000u)
#define CSL_CPINTC_ENABLE_REG16_ENABLE_532_SHIFT (0x00000014u)
#define CSL_CPINTC_ENABLE_REG16_ENABLE_532_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG16_ENABLE_533_MASK (0x00200000u)
#define CSL_CPINTC_ENABLE_REG16_ENABLE_533_SHIFT (0x00000015u)
#define CSL_CPINTC_ENABLE_REG16_ENABLE_533_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG16_ENABLE_534_MASK (0x00400000u)
#define CSL_CPINTC_ENABLE_REG16_ENABLE_534_SHIFT (0x00000016u)
#define CSL_CPINTC_ENABLE_REG16_ENABLE_534_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG16_ENABLE_535_MASK (0x00800000u)
#define CSL_CPINTC_ENABLE_REG16_ENABLE_535_SHIFT (0x00000017u)
#define CSL_CPINTC_ENABLE_REG16_ENABLE_535_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG16_ENABLE_536_MASK (0x01000000u)
#define CSL_CPINTC_ENABLE_REG16_ENABLE_536_SHIFT (0x00000018u)
#define CSL_CPINTC_ENABLE_REG16_ENABLE_536_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG16_ENABLE_537_MASK (0x02000000u)
#define CSL_CPINTC_ENABLE_REG16_ENABLE_537_SHIFT (0x00000019u)
#define CSL_CPINTC_ENABLE_REG16_ENABLE_537_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG16_ENABLE_538_MASK (0x04000000u)
#define CSL_CPINTC_ENABLE_REG16_ENABLE_538_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENABLE_REG16_ENABLE_538_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG16_ENABLE_539_MASK (0x08000000u)
#define CSL_CPINTC_ENABLE_REG16_ENABLE_539_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENABLE_REG16_ENABLE_539_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG16_ENABLE_540_MASK (0x10000000u)
#define CSL_CPINTC_ENABLE_REG16_ENABLE_540_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENABLE_REG16_ENABLE_540_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG16_ENABLE_541_MASK (0x20000000u)
#define CSL_CPINTC_ENABLE_REG16_ENABLE_541_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENABLE_REG16_ENABLE_541_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG16_ENABLE_542_MASK (0x40000000u)
#define CSL_CPINTC_ENABLE_REG16_ENABLE_542_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENABLE_REG16_ENABLE_542_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG16_ENABLE_543_MASK (0x80000000u)
#define CSL_CPINTC_ENABLE_REG16_ENABLE_543_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENABLE_REG16_ENABLE_543_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG16_RESETVAL (0x00000000u)

/* enable_reg17 */

#define CSL_CPINTC_ENABLE_REG17_ENABLE_544_MASK (0x00000001u)
#define CSL_CPINTC_ENABLE_REG17_ENABLE_544_SHIFT (0x00000000u)
#define CSL_CPINTC_ENABLE_REG17_ENABLE_544_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG17_ENABLE_545_MASK (0x00000002u)
#define CSL_CPINTC_ENABLE_REG17_ENABLE_545_SHIFT (0x00000001u)
#define CSL_CPINTC_ENABLE_REG17_ENABLE_545_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG17_ENABLE_546_MASK (0x00000004u)
#define CSL_CPINTC_ENABLE_REG17_ENABLE_546_SHIFT (0x00000002u)
#define CSL_CPINTC_ENABLE_REG17_ENABLE_546_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG17_ENABLE_547_MASK (0x00000008u)
#define CSL_CPINTC_ENABLE_REG17_ENABLE_547_SHIFT (0x00000003u)
#define CSL_CPINTC_ENABLE_REG17_ENABLE_547_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG17_ENABLE_548_MASK (0x00000010u)
#define CSL_CPINTC_ENABLE_REG17_ENABLE_548_SHIFT (0x00000004u)
#define CSL_CPINTC_ENABLE_REG17_ENABLE_548_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG17_ENABLE_549_MASK (0x00000020u)
#define CSL_CPINTC_ENABLE_REG17_ENABLE_549_SHIFT (0x00000005u)
#define CSL_CPINTC_ENABLE_REG17_ENABLE_549_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG17_ENABLE_550_MASK (0x00000040u)
#define CSL_CPINTC_ENABLE_REG17_ENABLE_550_SHIFT (0x00000006u)
#define CSL_CPINTC_ENABLE_REG17_ENABLE_550_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG17_ENABLE_551_MASK (0x00000080u)
#define CSL_CPINTC_ENABLE_REG17_ENABLE_551_SHIFT (0x00000007u)
#define CSL_CPINTC_ENABLE_REG17_ENABLE_551_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG17_ENABLE_552_MASK (0x00000100u)
#define CSL_CPINTC_ENABLE_REG17_ENABLE_552_SHIFT (0x00000008u)
#define CSL_CPINTC_ENABLE_REG17_ENABLE_552_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG17_ENABLE_553_MASK (0x00000200u)
#define CSL_CPINTC_ENABLE_REG17_ENABLE_553_SHIFT (0x00000009u)
#define CSL_CPINTC_ENABLE_REG17_ENABLE_553_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG17_ENABLE_554_MASK (0x00000400u)
#define CSL_CPINTC_ENABLE_REG17_ENABLE_554_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENABLE_REG17_ENABLE_554_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG17_ENABLE_555_MASK (0x00000800u)
#define CSL_CPINTC_ENABLE_REG17_ENABLE_555_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENABLE_REG17_ENABLE_555_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG17_ENABLE_556_MASK (0x00001000u)
#define CSL_CPINTC_ENABLE_REG17_ENABLE_556_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENABLE_REG17_ENABLE_556_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG17_ENABLE_557_MASK (0x00002000u)
#define CSL_CPINTC_ENABLE_REG17_ENABLE_557_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENABLE_REG17_ENABLE_557_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG17_ENABLE_558_MASK (0x00004000u)
#define CSL_CPINTC_ENABLE_REG17_ENABLE_558_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENABLE_REG17_ENABLE_558_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG17_ENABLE_559_MASK (0x00008000u)
#define CSL_CPINTC_ENABLE_REG17_ENABLE_559_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENABLE_REG17_ENABLE_559_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG17_ENABLE_560_MASK (0x00010000u)
#define CSL_CPINTC_ENABLE_REG17_ENABLE_560_SHIFT (0x00000010u)
#define CSL_CPINTC_ENABLE_REG17_ENABLE_560_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG17_ENABLE_561_MASK (0x00020000u)
#define CSL_CPINTC_ENABLE_REG17_ENABLE_561_SHIFT (0x00000011u)
#define CSL_CPINTC_ENABLE_REG17_ENABLE_561_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG17_ENABLE_562_MASK (0x00040000u)
#define CSL_CPINTC_ENABLE_REG17_ENABLE_562_SHIFT (0x00000012u)
#define CSL_CPINTC_ENABLE_REG17_ENABLE_562_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG17_ENABLE_563_MASK (0x00080000u)
#define CSL_CPINTC_ENABLE_REG17_ENABLE_563_SHIFT (0x00000013u)
#define CSL_CPINTC_ENABLE_REG17_ENABLE_563_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG17_ENABLE_564_MASK (0x00100000u)
#define CSL_CPINTC_ENABLE_REG17_ENABLE_564_SHIFT (0x00000014u)
#define CSL_CPINTC_ENABLE_REG17_ENABLE_564_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG17_ENABLE_565_MASK (0x00200000u)
#define CSL_CPINTC_ENABLE_REG17_ENABLE_565_SHIFT (0x00000015u)
#define CSL_CPINTC_ENABLE_REG17_ENABLE_565_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG17_ENABLE_566_MASK (0x00400000u)
#define CSL_CPINTC_ENABLE_REG17_ENABLE_566_SHIFT (0x00000016u)
#define CSL_CPINTC_ENABLE_REG17_ENABLE_566_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG17_ENABLE_567_MASK (0x00800000u)
#define CSL_CPINTC_ENABLE_REG17_ENABLE_567_SHIFT (0x00000017u)
#define CSL_CPINTC_ENABLE_REG17_ENABLE_567_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG17_ENABLE_568_MASK (0x01000000u)
#define CSL_CPINTC_ENABLE_REG17_ENABLE_568_SHIFT (0x00000018u)
#define CSL_CPINTC_ENABLE_REG17_ENABLE_568_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG17_ENABLE_569_MASK (0x02000000u)
#define CSL_CPINTC_ENABLE_REG17_ENABLE_569_SHIFT (0x00000019u)
#define CSL_CPINTC_ENABLE_REG17_ENABLE_569_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG17_ENABLE_570_MASK (0x04000000u)
#define CSL_CPINTC_ENABLE_REG17_ENABLE_570_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENABLE_REG17_ENABLE_570_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG17_ENABLE_571_MASK (0x08000000u)
#define CSL_CPINTC_ENABLE_REG17_ENABLE_571_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENABLE_REG17_ENABLE_571_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG17_ENABLE_572_MASK (0x10000000u)
#define CSL_CPINTC_ENABLE_REG17_ENABLE_572_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENABLE_REG17_ENABLE_572_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG17_ENABLE_573_MASK (0x20000000u)
#define CSL_CPINTC_ENABLE_REG17_ENABLE_573_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENABLE_REG17_ENABLE_573_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG17_ENABLE_574_MASK (0x40000000u)
#define CSL_CPINTC_ENABLE_REG17_ENABLE_574_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENABLE_REG17_ENABLE_574_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG17_ENABLE_575_MASK (0x80000000u)
#define CSL_CPINTC_ENABLE_REG17_ENABLE_575_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENABLE_REG17_ENABLE_575_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG17_RESETVAL (0x00000000u)

/* enable_reg18 */

#define CSL_CPINTC_ENABLE_REG18_ENABLE_576_MASK (0x00000001u)
#define CSL_CPINTC_ENABLE_REG18_ENABLE_576_SHIFT (0x00000000u)
#define CSL_CPINTC_ENABLE_REG18_ENABLE_576_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG18_ENABLE_577_MASK (0x00000002u)
#define CSL_CPINTC_ENABLE_REG18_ENABLE_577_SHIFT (0x00000001u)
#define CSL_CPINTC_ENABLE_REG18_ENABLE_577_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG18_ENABLE_578_MASK (0x00000004u)
#define CSL_CPINTC_ENABLE_REG18_ENABLE_578_SHIFT (0x00000002u)
#define CSL_CPINTC_ENABLE_REG18_ENABLE_578_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG18_ENABLE_579_MASK (0x00000008u)
#define CSL_CPINTC_ENABLE_REG18_ENABLE_579_SHIFT (0x00000003u)
#define CSL_CPINTC_ENABLE_REG18_ENABLE_579_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG18_ENABLE_580_MASK (0x00000010u)
#define CSL_CPINTC_ENABLE_REG18_ENABLE_580_SHIFT (0x00000004u)
#define CSL_CPINTC_ENABLE_REG18_ENABLE_580_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG18_ENABLE_581_MASK (0x00000020u)
#define CSL_CPINTC_ENABLE_REG18_ENABLE_581_SHIFT (0x00000005u)
#define CSL_CPINTC_ENABLE_REG18_ENABLE_581_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG18_ENABLE_582_MASK (0x00000040u)
#define CSL_CPINTC_ENABLE_REG18_ENABLE_582_SHIFT (0x00000006u)
#define CSL_CPINTC_ENABLE_REG18_ENABLE_582_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG18_ENABLE_583_MASK (0x00000080u)
#define CSL_CPINTC_ENABLE_REG18_ENABLE_583_SHIFT (0x00000007u)
#define CSL_CPINTC_ENABLE_REG18_ENABLE_583_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG18_ENABLE_584_MASK (0x00000100u)
#define CSL_CPINTC_ENABLE_REG18_ENABLE_584_SHIFT (0x00000008u)
#define CSL_CPINTC_ENABLE_REG18_ENABLE_584_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG18_ENABLE_585_MASK (0x00000200u)
#define CSL_CPINTC_ENABLE_REG18_ENABLE_585_SHIFT (0x00000009u)
#define CSL_CPINTC_ENABLE_REG18_ENABLE_585_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG18_ENABLE_586_MASK (0x00000400u)
#define CSL_CPINTC_ENABLE_REG18_ENABLE_586_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENABLE_REG18_ENABLE_586_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG18_ENABLE_587_MASK (0x00000800u)
#define CSL_CPINTC_ENABLE_REG18_ENABLE_587_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENABLE_REG18_ENABLE_587_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG18_ENABLE_588_MASK (0x00001000u)
#define CSL_CPINTC_ENABLE_REG18_ENABLE_588_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENABLE_REG18_ENABLE_588_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG18_ENABLE_589_MASK (0x00002000u)
#define CSL_CPINTC_ENABLE_REG18_ENABLE_589_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENABLE_REG18_ENABLE_589_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG18_ENABLE_590_MASK (0x00004000u)
#define CSL_CPINTC_ENABLE_REG18_ENABLE_590_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENABLE_REG18_ENABLE_590_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG18_ENABLE_591_MASK (0x00008000u)
#define CSL_CPINTC_ENABLE_REG18_ENABLE_591_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENABLE_REG18_ENABLE_591_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG18_ENABLE_592_MASK (0x00010000u)
#define CSL_CPINTC_ENABLE_REG18_ENABLE_592_SHIFT (0x00000010u)
#define CSL_CPINTC_ENABLE_REG18_ENABLE_592_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG18_ENABLE_593_MASK (0x00020000u)
#define CSL_CPINTC_ENABLE_REG18_ENABLE_593_SHIFT (0x00000011u)
#define CSL_CPINTC_ENABLE_REG18_ENABLE_593_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG18_ENABLE_594_MASK (0x00040000u)
#define CSL_CPINTC_ENABLE_REG18_ENABLE_594_SHIFT (0x00000012u)
#define CSL_CPINTC_ENABLE_REG18_ENABLE_594_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG18_ENABLE_595_MASK (0x00080000u)
#define CSL_CPINTC_ENABLE_REG18_ENABLE_595_SHIFT (0x00000013u)
#define CSL_CPINTC_ENABLE_REG18_ENABLE_595_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG18_ENABLE_596_MASK (0x00100000u)
#define CSL_CPINTC_ENABLE_REG18_ENABLE_596_SHIFT (0x00000014u)
#define CSL_CPINTC_ENABLE_REG18_ENABLE_596_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG18_ENABLE_597_MASK (0x00200000u)
#define CSL_CPINTC_ENABLE_REG18_ENABLE_597_SHIFT (0x00000015u)
#define CSL_CPINTC_ENABLE_REG18_ENABLE_597_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG18_ENABLE_598_MASK (0x00400000u)
#define CSL_CPINTC_ENABLE_REG18_ENABLE_598_SHIFT (0x00000016u)
#define CSL_CPINTC_ENABLE_REG18_ENABLE_598_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG18_ENABLE_599_MASK (0x00800000u)
#define CSL_CPINTC_ENABLE_REG18_ENABLE_599_SHIFT (0x00000017u)
#define CSL_CPINTC_ENABLE_REG18_ENABLE_599_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG18_ENABLE_600_MASK (0x01000000u)
#define CSL_CPINTC_ENABLE_REG18_ENABLE_600_SHIFT (0x00000018u)
#define CSL_CPINTC_ENABLE_REG18_ENABLE_600_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG18_ENABLE_601_MASK (0x02000000u)
#define CSL_CPINTC_ENABLE_REG18_ENABLE_601_SHIFT (0x00000019u)
#define CSL_CPINTC_ENABLE_REG18_ENABLE_601_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG18_ENABLE_602_MASK (0x04000000u)
#define CSL_CPINTC_ENABLE_REG18_ENABLE_602_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENABLE_REG18_ENABLE_602_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG18_ENABLE_603_MASK (0x08000000u)
#define CSL_CPINTC_ENABLE_REG18_ENABLE_603_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENABLE_REG18_ENABLE_603_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG18_ENABLE_604_MASK (0x10000000u)
#define CSL_CPINTC_ENABLE_REG18_ENABLE_604_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENABLE_REG18_ENABLE_604_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG18_ENABLE_605_MASK (0x20000000u)
#define CSL_CPINTC_ENABLE_REG18_ENABLE_605_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENABLE_REG18_ENABLE_605_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG18_ENABLE_606_MASK (0x40000000u)
#define CSL_CPINTC_ENABLE_REG18_ENABLE_606_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENABLE_REG18_ENABLE_606_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG18_ENABLE_607_MASK (0x80000000u)
#define CSL_CPINTC_ENABLE_REG18_ENABLE_607_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENABLE_REG18_ENABLE_607_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG18_RESETVAL (0x00000000u)

/* enable_reg19 */

#define CSL_CPINTC_ENABLE_REG19_ENABLE_608_MASK (0x00000001u)
#define CSL_CPINTC_ENABLE_REG19_ENABLE_608_SHIFT (0x00000000u)
#define CSL_CPINTC_ENABLE_REG19_ENABLE_608_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG19_ENABLE_609_MASK (0x00000002u)
#define CSL_CPINTC_ENABLE_REG19_ENABLE_609_SHIFT (0x00000001u)
#define CSL_CPINTC_ENABLE_REG19_ENABLE_609_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG19_ENABLE_610_MASK (0x00000004u)
#define CSL_CPINTC_ENABLE_REG19_ENABLE_610_SHIFT (0x00000002u)
#define CSL_CPINTC_ENABLE_REG19_ENABLE_610_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG19_ENABLE_611_MASK (0x00000008u)
#define CSL_CPINTC_ENABLE_REG19_ENABLE_611_SHIFT (0x00000003u)
#define CSL_CPINTC_ENABLE_REG19_ENABLE_611_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG19_ENABLE_612_MASK (0x00000010u)
#define CSL_CPINTC_ENABLE_REG19_ENABLE_612_SHIFT (0x00000004u)
#define CSL_CPINTC_ENABLE_REG19_ENABLE_612_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG19_ENABLE_613_MASK (0x00000020u)
#define CSL_CPINTC_ENABLE_REG19_ENABLE_613_SHIFT (0x00000005u)
#define CSL_CPINTC_ENABLE_REG19_ENABLE_613_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG19_ENABLE_614_MASK (0x00000040u)
#define CSL_CPINTC_ENABLE_REG19_ENABLE_614_SHIFT (0x00000006u)
#define CSL_CPINTC_ENABLE_REG19_ENABLE_614_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG19_ENABLE_615_MASK (0x00000080u)
#define CSL_CPINTC_ENABLE_REG19_ENABLE_615_SHIFT (0x00000007u)
#define CSL_CPINTC_ENABLE_REG19_ENABLE_615_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG19_ENABLE_616_MASK (0x00000100u)
#define CSL_CPINTC_ENABLE_REG19_ENABLE_616_SHIFT (0x00000008u)
#define CSL_CPINTC_ENABLE_REG19_ENABLE_616_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG19_ENABLE_617_MASK (0x00000200u)
#define CSL_CPINTC_ENABLE_REG19_ENABLE_617_SHIFT (0x00000009u)
#define CSL_CPINTC_ENABLE_REG19_ENABLE_617_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG19_ENABLE_618_MASK (0x00000400u)
#define CSL_CPINTC_ENABLE_REG19_ENABLE_618_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENABLE_REG19_ENABLE_618_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG19_ENABLE_619_MASK (0x00000800u)
#define CSL_CPINTC_ENABLE_REG19_ENABLE_619_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENABLE_REG19_ENABLE_619_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG19_ENABLE_620_MASK (0x00001000u)
#define CSL_CPINTC_ENABLE_REG19_ENABLE_620_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENABLE_REG19_ENABLE_620_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG19_ENABLE_621_MASK (0x00002000u)
#define CSL_CPINTC_ENABLE_REG19_ENABLE_621_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENABLE_REG19_ENABLE_621_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG19_ENABLE_622_MASK (0x00004000u)
#define CSL_CPINTC_ENABLE_REG19_ENABLE_622_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENABLE_REG19_ENABLE_622_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG19_ENABLE_623_MASK (0x00008000u)
#define CSL_CPINTC_ENABLE_REG19_ENABLE_623_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENABLE_REG19_ENABLE_623_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG19_ENABLE_624_MASK (0x00010000u)
#define CSL_CPINTC_ENABLE_REG19_ENABLE_624_SHIFT (0x00000010u)
#define CSL_CPINTC_ENABLE_REG19_ENABLE_624_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG19_ENABLE_625_MASK (0x00020000u)
#define CSL_CPINTC_ENABLE_REG19_ENABLE_625_SHIFT (0x00000011u)
#define CSL_CPINTC_ENABLE_REG19_ENABLE_625_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG19_ENABLE_626_MASK (0x00040000u)
#define CSL_CPINTC_ENABLE_REG19_ENABLE_626_SHIFT (0x00000012u)
#define CSL_CPINTC_ENABLE_REG19_ENABLE_626_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG19_ENABLE_627_MASK (0x00080000u)
#define CSL_CPINTC_ENABLE_REG19_ENABLE_627_SHIFT (0x00000013u)
#define CSL_CPINTC_ENABLE_REG19_ENABLE_627_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG19_ENABLE_628_MASK (0x00100000u)
#define CSL_CPINTC_ENABLE_REG19_ENABLE_628_SHIFT (0x00000014u)
#define CSL_CPINTC_ENABLE_REG19_ENABLE_628_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG19_ENABLE_629_MASK (0x00200000u)
#define CSL_CPINTC_ENABLE_REG19_ENABLE_629_SHIFT (0x00000015u)
#define CSL_CPINTC_ENABLE_REG19_ENABLE_629_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG19_ENABLE_630_MASK (0x00400000u)
#define CSL_CPINTC_ENABLE_REG19_ENABLE_630_SHIFT (0x00000016u)
#define CSL_CPINTC_ENABLE_REG19_ENABLE_630_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG19_ENABLE_631_MASK (0x00800000u)
#define CSL_CPINTC_ENABLE_REG19_ENABLE_631_SHIFT (0x00000017u)
#define CSL_CPINTC_ENABLE_REG19_ENABLE_631_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG19_ENABLE_632_MASK (0x01000000u)
#define CSL_CPINTC_ENABLE_REG19_ENABLE_632_SHIFT (0x00000018u)
#define CSL_CPINTC_ENABLE_REG19_ENABLE_632_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG19_ENABLE_633_MASK (0x02000000u)
#define CSL_CPINTC_ENABLE_REG19_ENABLE_633_SHIFT (0x00000019u)
#define CSL_CPINTC_ENABLE_REG19_ENABLE_633_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG19_ENABLE_634_MASK (0x04000000u)
#define CSL_CPINTC_ENABLE_REG19_ENABLE_634_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENABLE_REG19_ENABLE_634_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG19_ENABLE_635_MASK (0x08000000u)
#define CSL_CPINTC_ENABLE_REG19_ENABLE_635_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENABLE_REG19_ENABLE_635_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG19_ENABLE_636_MASK (0x10000000u)
#define CSL_CPINTC_ENABLE_REG19_ENABLE_636_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENABLE_REG19_ENABLE_636_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG19_ENABLE_637_MASK (0x20000000u)
#define CSL_CPINTC_ENABLE_REG19_ENABLE_637_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENABLE_REG19_ENABLE_637_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG19_ENABLE_638_MASK (0x40000000u)
#define CSL_CPINTC_ENABLE_REG19_ENABLE_638_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENABLE_REG19_ENABLE_638_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG19_ENABLE_639_MASK (0x80000000u)
#define CSL_CPINTC_ENABLE_REG19_ENABLE_639_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENABLE_REG19_ENABLE_639_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG19_RESETVAL (0x00000000u)

/* enable_reg20 */

#define CSL_CPINTC_ENABLE_REG20_ENABLE_640_MASK (0x00000001u)
#define CSL_CPINTC_ENABLE_REG20_ENABLE_640_SHIFT (0x00000000u)
#define CSL_CPINTC_ENABLE_REG20_ENABLE_640_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG20_ENABLE_641_MASK (0x00000002u)
#define CSL_CPINTC_ENABLE_REG20_ENABLE_641_SHIFT (0x00000001u)
#define CSL_CPINTC_ENABLE_REG20_ENABLE_641_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG20_ENABLE_642_MASK (0x00000004u)
#define CSL_CPINTC_ENABLE_REG20_ENABLE_642_SHIFT (0x00000002u)
#define CSL_CPINTC_ENABLE_REG20_ENABLE_642_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG20_ENABLE_643_MASK (0x00000008u)
#define CSL_CPINTC_ENABLE_REG20_ENABLE_643_SHIFT (0x00000003u)
#define CSL_CPINTC_ENABLE_REG20_ENABLE_643_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG20_ENABLE_644_MASK (0x00000010u)
#define CSL_CPINTC_ENABLE_REG20_ENABLE_644_SHIFT (0x00000004u)
#define CSL_CPINTC_ENABLE_REG20_ENABLE_644_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG20_ENABLE_645_MASK (0x00000020u)
#define CSL_CPINTC_ENABLE_REG20_ENABLE_645_SHIFT (0x00000005u)
#define CSL_CPINTC_ENABLE_REG20_ENABLE_645_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG20_ENABLE_646_MASK (0x00000040u)
#define CSL_CPINTC_ENABLE_REG20_ENABLE_646_SHIFT (0x00000006u)
#define CSL_CPINTC_ENABLE_REG20_ENABLE_646_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG20_ENABLE_647_MASK (0x00000080u)
#define CSL_CPINTC_ENABLE_REG20_ENABLE_647_SHIFT (0x00000007u)
#define CSL_CPINTC_ENABLE_REG20_ENABLE_647_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG20_ENABLE_648_MASK (0x00000100u)
#define CSL_CPINTC_ENABLE_REG20_ENABLE_648_SHIFT (0x00000008u)
#define CSL_CPINTC_ENABLE_REG20_ENABLE_648_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG20_ENABLE_649_MASK (0x00000200u)
#define CSL_CPINTC_ENABLE_REG20_ENABLE_649_SHIFT (0x00000009u)
#define CSL_CPINTC_ENABLE_REG20_ENABLE_649_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG20_ENABLE_650_MASK (0x00000400u)
#define CSL_CPINTC_ENABLE_REG20_ENABLE_650_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENABLE_REG20_ENABLE_650_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG20_ENABLE_651_MASK (0x00000800u)
#define CSL_CPINTC_ENABLE_REG20_ENABLE_651_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENABLE_REG20_ENABLE_651_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG20_ENABLE_652_MASK (0x00001000u)
#define CSL_CPINTC_ENABLE_REG20_ENABLE_652_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENABLE_REG20_ENABLE_652_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG20_ENABLE_653_MASK (0x00002000u)
#define CSL_CPINTC_ENABLE_REG20_ENABLE_653_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENABLE_REG20_ENABLE_653_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG20_ENABLE_654_MASK (0x00004000u)
#define CSL_CPINTC_ENABLE_REG20_ENABLE_654_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENABLE_REG20_ENABLE_654_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG20_ENABLE_655_MASK (0x00008000u)
#define CSL_CPINTC_ENABLE_REG20_ENABLE_655_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENABLE_REG20_ENABLE_655_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG20_ENABLE_656_MASK (0x00010000u)
#define CSL_CPINTC_ENABLE_REG20_ENABLE_656_SHIFT (0x00000010u)
#define CSL_CPINTC_ENABLE_REG20_ENABLE_656_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG20_ENABLE_657_MASK (0x00020000u)
#define CSL_CPINTC_ENABLE_REG20_ENABLE_657_SHIFT (0x00000011u)
#define CSL_CPINTC_ENABLE_REG20_ENABLE_657_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG20_ENABLE_658_MASK (0x00040000u)
#define CSL_CPINTC_ENABLE_REG20_ENABLE_658_SHIFT (0x00000012u)
#define CSL_CPINTC_ENABLE_REG20_ENABLE_658_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG20_ENABLE_659_MASK (0x00080000u)
#define CSL_CPINTC_ENABLE_REG20_ENABLE_659_SHIFT (0x00000013u)
#define CSL_CPINTC_ENABLE_REG20_ENABLE_659_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG20_ENABLE_660_MASK (0x00100000u)
#define CSL_CPINTC_ENABLE_REG20_ENABLE_660_SHIFT (0x00000014u)
#define CSL_CPINTC_ENABLE_REG20_ENABLE_660_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG20_ENABLE_661_MASK (0x00200000u)
#define CSL_CPINTC_ENABLE_REG20_ENABLE_661_SHIFT (0x00000015u)
#define CSL_CPINTC_ENABLE_REG20_ENABLE_661_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG20_ENABLE_662_MASK (0x00400000u)
#define CSL_CPINTC_ENABLE_REG20_ENABLE_662_SHIFT (0x00000016u)
#define CSL_CPINTC_ENABLE_REG20_ENABLE_662_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG20_ENABLE_663_MASK (0x00800000u)
#define CSL_CPINTC_ENABLE_REG20_ENABLE_663_SHIFT (0x00000017u)
#define CSL_CPINTC_ENABLE_REG20_ENABLE_663_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG20_ENABLE_664_MASK (0x01000000u)
#define CSL_CPINTC_ENABLE_REG20_ENABLE_664_SHIFT (0x00000018u)
#define CSL_CPINTC_ENABLE_REG20_ENABLE_664_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG20_ENABLE_665_MASK (0x02000000u)
#define CSL_CPINTC_ENABLE_REG20_ENABLE_665_SHIFT (0x00000019u)
#define CSL_CPINTC_ENABLE_REG20_ENABLE_665_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG20_ENABLE_666_MASK (0x04000000u)
#define CSL_CPINTC_ENABLE_REG20_ENABLE_666_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENABLE_REG20_ENABLE_666_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG20_ENABLE_667_MASK (0x08000000u)
#define CSL_CPINTC_ENABLE_REG20_ENABLE_667_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENABLE_REG20_ENABLE_667_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG20_ENABLE_668_MASK (0x10000000u)
#define CSL_CPINTC_ENABLE_REG20_ENABLE_668_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENABLE_REG20_ENABLE_668_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG20_ENABLE_669_MASK (0x20000000u)
#define CSL_CPINTC_ENABLE_REG20_ENABLE_669_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENABLE_REG20_ENABLE_669_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG20_ENABLE_670_MASK (0x40000000u)
#define CSL_CPINTC_ENABLE_REG20_ENABLE_670_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENABLE_REG20_ENABLE_670_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG20_ENABLE_671_MASK (0x80000000u)
#define CSL_CPINTC_ENABLE_REG20_ENABLE_671_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENABLE_REG20_ENABLE_671_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG20_RESETVAL (0x00000000u)

/* enable_reg21 */

#define CSL_CPINTC_ENABLE_REG21_ENABLE_672_MASK (0x00000001u)
#define CSL_CPINTC_ENABLE_REG21_ENABLE_672_SHIFT (0x00000000u)
#define CSL_CPINTC_ENABLE_REG21_ENABLE_672_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG21_ENABLE_673_MASK (0x00000002u)
#define CSL_CPINTC_ENABLE_REG21_ENABLE_673_SHIFT (0x00000001u)
#define CSL_CPINTC_ENABLE_REG21_ENABLE_673_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG21_ENABLE_674_MASK (0x00000004u)
#define CSL_CPINTC_ENABLE_REG21_ENABLE_674_SHIFT (0x00000002u)
#define CSL_CPINTC_ENABLE_REG21_ENABLE_674_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG21_ENABLE_675_MASK (0x00000008u)
#define CSL_CPINTC_ENABLE_REG21_ENABLE_675_SHIFT (0x00000003u)
#define CSL_CPINTC_ENABLE_REG21_ENABLE_675_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG21_ENABLE_676_MASK (0x00000010u)
#define CSL_CPINTC_ENABLE_REG21_ENABLE_676_SHIFT (0x00000004u)
#define CSL_CPINTC_ENABLE_REG21_ENABLE_676_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG21_ENABLE_677_MASK (0x00000020u)
#define CSL_CPINTC_ENABLE_REG21_ENABLE_677_SHIFT (0x00000005u)
#define CSL_CPINTC_ENABLE_REG21_ENABLE_677_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG21_ENABLE_678_MASK (0x00000040u)
#define CSL_CPINTC_ENABLE_REG21_ENABLE_678_SHIFT (0x00000006u)
#define CSL_CPINTC_ENABLE_REG21_ENABLE_678_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG21_ENABLE_679_MASK (0x00000080u)
#define CSL_CPINTC_ENABLE_REG21_ENABLE_679_SHIFT (0x00000007u)
#define CSL_CPINTC_ENABLE_REG21_ENABLE_679_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG21_ENABLE_680_MASK (0x00000100u)
#define CSL_CPINTC_ENABLE_REG21_ENABLE_680_SHIFT (0x00000008u)
#define CSL_CPINTC_ENABLE_REG21_ENABLE_680_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG21_ENABLE_681_MASK (0x00000200u)
#define CSL_CPINTC_ENABLE_REG21_ENABLE_681_SHIFT (0x00000009u)
#define CSL_CPINTC_ENABLE_REG21_ENABLE_681_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG21_ENABLE_682_MASK (0x00000400u)
#define CSL_CPINTC_ENABLE_REG21_ENABLE_682_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENABLE_REG21_ENABLE_682_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG21_ENABLE_683_MASK (0x00000800u)
#define CSL_CPINTC_ENABLE_REG21_ENABLE_683_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENABLE_REG21_ENABLE_683_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG21_ENABLE_684_MASK (0x00001000u)
#define CSL_CPINTC_ENABLE_REG21_ENABLE_684_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENABLE_REG21_ENABLE_684_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG21_ENABLE_685_MASK (0x00002000u)
#define CSL_CPINTC_ENABLE_REG21_ENABLE_685_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENABLE_REG21_ENABLE_685_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG21_ENABLE_686_MASK (0x00004000u)
#define CSL_CPINTC_ENABLE_REG21_ENABLE_686_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENABLE_REG21_ENABLE_686_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG21_ENABLE_687_MASK (0x00008000u)
#define CSL_CPINTC_ENABLE_REG21_ENABLE_687_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENABLE_REG21_ENABLE_687_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG21_ENABLE_688_MASK (0x00010000u)
#define CSL_CPINTC_ENABLE_REG21_ENABLE_688_SHIFT (0x00000010u)
#define CSL_CPINTC_ENABLE_REG21_ENABLE_688_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG21_ENABLE_689_MASK (0x00020000u)
#define CSL_CPINTC_ENABLE_REG21_ENABLE_689_SHIFT (0x00000011u)
#define CSL_CPINTC_ENABLE_REG21_ENABLE_689_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG21_ENABLE_690_MASK (0x00040000u)
#define CSL_CPINTC_ENABLE_REG21_ENABLE_690_SHIFT (0x00000012u)
#define CSL_CPINTC_ENABLE_REG21_ENABLE_690_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG21_ENABLE_691_MASK (0x00080000u)
#define CSL_CPINTC_ENABLE_REG21_ENABLE_691_SHIFT (0x00000013u)
#define CSL_CPINTC_ENABLE_REG21_ENABLE_691_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG21_ENABLE_692_MASK (0x00100000u)
#define CSL_CPINTC_ENABLE_REG21_ENABLE_692_SHIFT (0x00000014u)
#define CSL_CPINTC_ENABLE_REG21_ENABLE_692_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG21_ENABLE_693_MASK (0x00200000u)
#define CSL_CPINTC_ENABLE_REG21_ENABLE_693_SHIFT (0x00000015u)
#define CSL_CPINTC_ENABLE_REG21_ENABLE_693_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG21_ENABLE_694_MASK (0x00400000u)
#define CSL_CPINTC_ENABLE_REG21_ENABLE_694_SHIFT (0x00000016u)
#define CSL_CPINTC_ENABLE_REG21_ENABLE_694_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG21_ENABLE_695_MASK (0x00800000u)
#define CSL_CPINTC_ENABLE_REG21_ENABLE_695_SHIFT (0x00000017u)
#define CSL_CPINTC_ENABLE_REG21_ENABLE_695_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG21_ENABLE_696_MASK (0x01000000u)
#define CSL_CPINTC_ENABLE_REG21_ENABLE_696_SHIFT (0x00000018u)
#define CSL_CPINTC_ENABLE_REG21_ENABLE_696_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG21_ENABLE_697_MASK (0x02000000u)
#define CSL_CPINTC_ENABLE_REG21_ENABLE_697_SHIFT (0x00000019u)
#define CSL_CPINTC_ENABLE_REG21_ENABLE_697_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG21_ENABLE_698_MASK (0x04000000u)
#define CSL_CPINTC_ENABLE_REG21_ENABLE_698_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENABLE_REG21_ENABLE_698_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG21_ENABLE_699_MASK (0x08000000u)
#define CSL_CPINTC_ENABLE_REG21_ENABLE_699_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENABLE_REG21_ENABLE_699_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG21_ENABLE_700_MASK (0x10000000u)
#define CSL_CPINTC_ENABLE_REG21_ENABLE_700_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENABLE_REG21_ENABLE_700_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG21_ENABLE_701_MASK (0x20000000u)
#define CSL_CPINTC_ENABLE_REG21_ENABLE_701_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENABLE_REG21_ENABLE_701_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG21_ENABLE_702_MASK (0x40000000u)
#define CSL_CPINTC_ENABLE_REG21_ENABLE_702_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENABLE_REG21_ENABLE_702_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG21_ENABLE_703_MASK (0x80000000u)
#define CSL_CPINTC_ENABLE_REG21_ENABLE_703_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENABLE_REG21_ENABLE_703_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG21_RESETVAL (0x00000000u)

/* enable_reg22 */

#define CSL_CPINTC_ENABLE_REG22_ENABLE_704_MASK (0x00000001u)
#define CSL_CPINTC_ENABLE_REG22_ENABLE_704_SHIFT (0x00000000u)
#define CSL_CPINTC_ENABLE_REG22_ENABLE_704_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG22_ENABLE_705_MASK (0x00000002u)
#define CSL_CPINTC_ENABLE_REG22_ENABLE_705_SHIFT (0x00000001u)
#define CSL_CPINTC_ENABLE_REG22_ENABLE_705_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG22_ENABLE_706_MASK (0x00000004u)
#define CSL_CPINTC_ENABLE_REG22_ENABLE_706_SHIFT (0x00000002u)
#define CSL_CPINTC_ENABLE_REG22_ENABLE_706_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG22_ENABLE_707_MASK (0x00000008u)
#define CSL_CPINTC_ENABLE_REG22_ENABLE_707_SHIFT (0x00000003u)
#define CSL_CPINTC_ENABLE_REG22_ENABLE_707_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG22_ENABLE_708_MASK (0x00000010u)
#define CSL_CPINTC_ENABLE_REG22_ENABLE_708_SHIFT (0x00000004u)
#define CSL_CPINTC_ENABLE_REG22_ENABLE_708_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG22_ENABLE_709_MASK (0x00000020u)
#define CSL_CPINTC_ENABLE_REG22_ENABLE_709_SHIFT (0x00000005u)
#define CSL_CPINTC_ENABLE_REG22_ENABLE_709_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG22_ENABLE_710_MASK (0x00000040u)
#define CSL_CPINTC_ENABLE_REG22_ENABLE_710_SHIFT (0x00000006u)
#define CSL_CPINTC_ENABLE_REG22_ENABLE_710_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG22_ENABLE_711_MASK (0x00000080u)
#define CSL_CPINTC_ENABLE_REG22_ENABLE_711_SHIFT (0x00000007u)
#define CSL_CPINTC_ENABLE_REG22_ENABLE_711_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG22_ENABLE_712_MASK (0x00000100u)
#define CSL_CPINTC_ENABLE_REG22_ENABLE_712_SHIFT (0x00000008u)
#define CSL_CPINTC_ENABLE_REG22_ENABLE_712_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG22_ENABLE_713_MASK (0x00000200u)
#define CSL_CPINTC_ENABLE_REG22_ENABLE_713_SHIFT (0x00000009u)
#define CSL_CPINTC_ENABLE_REG22_ENABLE_713_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG22_ENABLE_714_MASK (0x00000400u)
#define CSL_CPINTC_ENABLE_REG22_ENABLE_714_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENABLE_REG22_ENABLE_714_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG22_ENABLE_715_MASK (0x00000800u)
#define CSL_CPINTC_ENABLE_REG22_ENABLE_715_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENABLE_REG22_ENABLE_715_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG22_ENABLE_716_MASK (0x00001000u)
#define CSL_CPINTC_ENABLE_REG22_ENABLE_716_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENABLE_REG22_ENABLE_716_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG22_ENABLE_717_MASK (0x00002000u)
#define CSL_CPINTC_ENABLE_REG22_ENABLE_717_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENABLE_REG22_ENABLE_717_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG22_ENABLE_718_MASK (0x00004000u)
#define CSL_CPINTC_ENABLE_REG22_ENABLE_718_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENABLE_REG22_ENABLE_718_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG22_ENABLE_719_MASK (0x00008000u)
#define CSL_CPINTC_ENABLE_REG22_ENABLE_719_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENABLE_REG22_ENABLE_719_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG22_ENABLE_720_MASK (0x00010000u)
#define CSL_CPINTC_ENABLE_REG22_ENABLE_720_SHIFT (0x00000010u)
#define CSL_CPINTC_ENABLE_REG22_ENABLE_720_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG22_ENABLE_721_MASK (0x00020000u)
#define CSL_CPINTC_ENABLE_REG22_ENABLE_721_SHIFT (0x00000011u)
#define CSL_CPINTC_ENABLE_REG22_ENABLE_721_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG22_ENABLE_722_MASK (0x00040000u)
#define CSL_CPINTC_ENABLE_REG22_ENABLE_722_SHIFT (0x00000012u)
#define CSL_CPINTC_ENABLE_REG22_ENABLE_722_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG22_ENABLE_723_MASK (0x00080000u)
#define CSL_CPINTC_ENABLE_REG22_ENABLE_723_SHIFT (0x00000013u)
#define CSL_CPINTC_ENABLE_REG22_ENABLE_723_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG22_ENABLE_724_MASK (0x00100000u)
#define CSL_CPINTC_ENABLE_REG22_ENABLE_724_SHIFT (0x00000014u)
#define CSL_CPINTC_ENABLE_REG22_ENABLE_724_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG22_ENABLE_725_MASK (0x00200000u)
#define CSL_CPINTC_ENABLE_REG22_ENABLE_725_SHIFT (0x00000015u)
#define CSL_CPINTC_ENABLE_REG22_ENABLE_725_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG22_ENABLE_726_MASK (0x00400000u)
#define CSL_CPINTC_ENABLE_REG22_ENABLE_726_SHIFT (0x00000016u)
#define CSL_CPINTC_ENABLE_REG22_ENABLE_726_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG22_ENABLE_727_MASK (0x00800000u)
#define CSL_CPINTC_ENABLE_REG22_ENABLE_727_SHIFT (0x00000017u)
#define CSL_CPINTC_ENABLE_REG22_ENABLE_727_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG22_ENABLE_728_MASK (0x01000000u)
#define CSL_CPINTC_ENABLE_REG22_ENABLE_728_SHIFT (0x00000018u)
#define CSL_CPINTC_ENABLE_REG22_ENABLE_728_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG22_ENABLE_729_MASK (0x02000000u)
#define CSL_CPINTC_ENABLE_REG22_ENABLE_729_SHIFT (0x00000019u)
#define CSL_CPINTC_ENABLE_REG22_ENABLE_729_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG22_ENABLE_730_MASK (0x04000000u)
#define CSL_CPINTC_ENABLE_REG22_ENABLE_730_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENABLE_REG22_ENABLE_730_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG22_ENABLE_731_MASK (0x08000000u)
#define CSL_CPINTC_ENABLE_REG22_ENABLE_731_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENABLE_REG22_ENABLE_731_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG22_ENABLE_732_MASK (0x10000000u)
#define CSL_CPINTC_ENABLE_REG22_ENABLE_732_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENABLE_REG22_ENABLE_732_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG22_ENABLE_733_MASK (0x20000000u)
#define CSL_CPINTC_ENABLE_REG22_ENABLE_733_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENABLE_REG22_ENABLE_733_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG22_ENABLE_734_MASK (0x40000000u)
#define CSL_CPINTC_ENABLE_REG22_ENABLE_734_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENABLE_REG22_ENABLE_734_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG22_ENABLE_735_MASK (0x80000000u)
#define CSL_CPINTC_ENABLE_REG22_ENABLE_735_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENABLE_REG22_ENABLE_735_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG22_RESETVAL (0x00000000u)

/* enable_reg23 */

#define CSL_CPINTC_ENABLE_REG23_ENABLE_736_MASK (0x00000001u)
#define CSL_CPINTC_ENABLE_REG23_ENABLE_736_SHIFT (0x00000000u)
#define CSL_CPINTC_ENABLE_REG23_ENABLE_736_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG23_ENABLE_737_MASK (0x00000002u)
#define CSL_CPINTC_ENABLE_REG23_ENABLE_737_SHIFT (0x00000001u)
#define CSL_CPINTC_ENABLE_REG23_ENABLE_737_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG23_ENABLE_738_MASK (0x00000004u)
#define CSL_CPINTC_ENABLE_REG23_ENABLE_738_SHIFT (0x00000002u)
#define CSL_CPINTC_ENABLE_REG23_ENABLE_738_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG23_ENABLE_739_MASK (0x00000008u)
#define CSL_CPINTC_ENABLE_REG23_ENABLE_739_SHIFT (0x00000003u)
#define CSL_CPINTC_ENABLE_REG23_ENABLE_739_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG23_ENABLE_740_MASK (0x00000010u)
#define CSL_CPINTC_ENABLE_REG23_ENABLE_740_SHIFT (0x00000004u)
#define CSL_CPINTC_ENABLE_REG23_ENABLE_740_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG23_ENABLE_741_MASK (0x00000020u)
#define CSL_CPINTC_ENABLE_REG23_ENABLE_741_SHIFT (0x00000005u)
#define CSL_CPINTC_ENABLE_REG23_ENABLE_741_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG23_ENABLE_742_MASK (0x00000040u)
#define CSL_CPINTC_ENABLE_REG23_ENABLE_742_SHIFT (0x00000006u)
#define CSL_CPINTC_ENABLE_REG23_ENABLE_742_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG23_ENABLE_743_MASK (0x00000080u)
#define CSL_CPINTC_ENABLE_REG23_ENABLE_743_SHIFT (0x00000007u)
#define CSL_CPINTC_ENABLE_REG23_ENABLE_743_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG23_ENABLE_744_MASK (0x00000100u)
#define CSL_CPINTC_ENABLE_REG23_ENABLE_744_SHIFT (0x00000008u)
#define CSL_CPINTC_ENABLE_REG23_ENABLE_744_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG23_ENABLE_745_MASK (0x00000200u)
#define CSL_CPINTC_ENABLE_REG23_ENABLE_745_SHIFT (0x00000009u)
#define CSL_CPINTC_ENABLE_REG23_ENABLE_745_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG23_ENABLE_746_MASK (0x00000400u)
#define CSL_CPINTC_ENABLE_REG23_ENABLE_746_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENABLE_REG23_ENABLE_746_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG23_ENABLE_747_MASK (0x00000800u)
#define CSL_CPINTC_ENABLE_REG23_ENABLE_747_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENABLE_REG23_ENABLE_747_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG23_ENABLE_748_MASK (0x00001000u)
#define CSL_CPINTC_ENABLE_REG23_ENABLE_748_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENABLE_REG23_ENABLE_748_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG23_ENABLE_749_MASK (0x00002000u)
#define CSL_CPINTC_ENABLE_REG23_ENABLE_749_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENABLE_REG23_ENABLE_749_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG23_ENABLE_750_MASK (0x00004000u)
#define CSL_CPINTC_ENABLE_REG23_ENABLE_750_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENABLE_REG23_ENABLE_750_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG23_ENABLE_751_MASK (0x00008000u)
#define CSL_CPINTC_ENABLE_REG23_ENABLE_751_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENABLE_REG23_ENABLE_751_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG23_ENABLE_752_MASK (0x00010000u)
#define CSL_CPINTC_ENABLE_REG23_ENABLE_752_SHIFT (0x00000010u)
#define CSL_CPINTC_ENABLE_REG23_ENABLE_752_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG23_ENABLE_753_MASK (0x00020000u)
#define CSL_CPINTC_ENABLE_REG23_ENABLE_753_SHIFT (0x00000011u)
#define CSL_CPINTC_ENABLE_REG23_ENABLE_753_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG23_ENABLE_754_MASK (0x00040000u)
#define CSL_CPINTC_ENABLE_REG23_ENABLE_754_SHIFT (0x00000012u)
#define CSL_CPINTC_ENABLE_REG23_ENABLE_754_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG23_ENABLE_755_MASK (0x00080000u)
#define CSL_CPINTC_ENABLE_REG23_ENABLE_755_SHIFT (0x00000013u)
#define CSL_CPINTC_ENABLE_REG23_ENABLE_755_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG23_ENABLE_756_MASK (0x00100000u)
#define CSL_CPINTC_ENABLE_REG23_ENABLE_756_SHIFT (0x00000014u)
#define CSL_CPINTC_ENABLE_REG23_ENABLE_756_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG23_ENABLE_757_MASK (0x00200000u)
#define CSL_CPINTC_ENABLE_REG23_ENABLE_757_SHIFT (0x00000015u)
#define CSL_CPINTC_ENABLE_REG23_ENABLE_757_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG23_ENABLE_758_MASK (0x00400000u)
#define CSL_CPINTC_ENABLE_REG23_ENABLE_758_SHIFT (0x00000016u)
#define CSL_CPINTC_ENABLE_REG23_ENABLE_758_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG23_ENABLE_759_MASK (0x00800000u)
#define CSL_CPINTC_ENABLE_REG23_ENABLE_759_SHIFT (0x00000017u)
#define CSL_CPINTC_ENABLE_REG23_ENABLE_759_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG23_ENABLE_760_MASK (0x01000000u)
#define CSL_CPINTC_ENABLE_REG23_ENABLE_760_SHIFT (0x00000018u)
#define CSL_CPINTC_ENABLE_REG23_ENABLE_760_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG23_ENABLE_761_MASK (0x02000000u)
#define CSL_CPINTC_ENABLE_REG23_ENABLE_761_SHIFT (0x00000019u)
#define CSL_CPINTC_ENABLE_REG23_ENABLE_761_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG23_ENABLE_762_MASK (0x04000000u)
#define CSL_CPINTC_ENABLE_REG23_ENABLE_762_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENABLE_REG23_ENABLE_762_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG23_ENABLE_763_MASK (0x08000000u)
#define CSL_CPINTC_ENABLE_REG23_ENABLE_763_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENABLE_REG23_ENABLE_763_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG23_ENABLE_764_MASK (0x10000000u)
#define CSL_CPINTC_ENABLE_REG23_ENABLE_764_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENABLE_REG23_ENABLE_764_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG23_ENABLE_765_MASK (0x20000000u)
#define CSL_CPINTC_ENABLE_REG23_ENABLE_765_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENABLE_REG23_ENABLE_765_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG23_ENABLE_766_MASK (0x40000000u)
#define CSL_CPINTC_ENABLE_REG23_ENABLE_766_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENABLE_REG23_ENABLE_766_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG23_ENABLE_767_MASK (0x80000000u)
#define CSL_CPINTC_ENABLE_REG23_ENABLE_767_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENABLE_REG23_ENABLE_767_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG23_RESETVAL (0x00000000u)

/* enable_reg24 */

#define CSL_CPINTC_ENABLE_REG24_ENABLE_768_MASK (0x00000001u)
#define CSL_CPINTC_ENABLE_REG24_ENABLE_768_SHIFT (0x00000000u)
#define CSL_CPINTC_ENABLE_REG24_ENABLE_768_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG24_ENABLE_769_MASK (0x00000002u)
#define CSL_CPINTC_ENABLE_REG24_ENABLE_769_SHIFT (0x00000001u)
#define CSL_CPINTC_ENABLE_REG24_ENABLE_769_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG24_ENABLE_770_MASK (0x00000004u)
#define CSL_CPINTC_ENABLE_REG24_ENABLE_770_SHIFT (0x00000002u)
#define CSL_CPINTC_ENABLE_REG24_ENABLE_770_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG24_ENABLE_771_MASK (0x00000008u)
#define CSL_CPINTC_ENABLE_REG24_ENABLE_771_SHIFT (0x00000003u)
#define CSL_CPINTC_ENABLE_REG24_ENABLE_771_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG24_ENABLE_772_MASK (0x00000010u)
#define CSL_CPINTC_ENABLE_REG24_ENABLE_772_SHIFT (0x00000004u)
#define CSL_CPINTC_ENABLE_REG24_ENABLE_772_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG24_ENABLE_773_MASK (0x00000020u)
#define CSL_CPINTC_ENABLE_REG24_ENABLE_773_SHIFT (0x00000005u)
#define CSL_CPINTC_ENABLE_REG24_ENABLE_773_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG24_ENABLE_774_MASK (0x00000040u)
#define CSL_CPINTC_ENABLE_REG24_ENABLE_774_SHIFT (0x00000006u)
#define CSL_CPINTC_ENABLE_REG24_ENABLE_774_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG24_ENABLE_775_MASK (0x00000080u)
#define CSL_CPINTC_ENABLE_REG24_ENABLE_775_SHIFT (0x00000007u)
#define CSL_CPINTC_ENABLE_REG24_ENABLE_775_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG24_ENABLE_776_MASK (0x00000100u)
#define CSL_CPINTC_ENABLE_REG24_ENABLE_776_SHIFT (0x00000008u)
#define CSL_CPINTC_ENABLE_REG24_ENABLE_776_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG24_ENABLE_777_MASK (0x00000200u)
#define CSL_CPINTC_ENABLE_REG24_ENABLE_777_SHIFT (0x00000009u)
#define CSL_CPINTC_ENABLE_REG24_ENABLE_777_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG24_ENABLE_778_MASK (0x00000400u)
#define CSL_CPINTC_ENABLE_REG24_ENABLE_778_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENABLE_REG24_ENABLE_778_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG24_ENABLE_779_MASK (0x00000800u)
#define CSL_CPINTC_ENABLE_REG24_ENABLE_779_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENABLE_REG24_ENABLE_779_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG24_ENABLE_780_MASK (0x00001000u)
#define CSL_CPINTC_ENABLE_REG24_ENABLE_780_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENABLE_REG24_ENABLE_780_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG24_ENABLE_781_MASK (0x00002000u)
#define CSL_CPINTC_ENABLE_REG24_ENABLE_781_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENABLE_REG24_ENABLE_781_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG24_ENABLE_782_MASK (0x00004000u)
#define CSL_CPINTC_ENABLE_REG24_ENABLE_782_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENABLE_REG24_ENABLE_782_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG24_ENABLE_783_MASK (0x00008000u)
#define CSL_CPINTC_ENABLE_REG24_ENABLE_783_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENABLE_REG24_ENABLE_783_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG24_ENABLE_784_MASK (0x00010000u)
#define CSL_CPINTC_ENABLE_REG24_ENABLE_784_SHIFT (0x00000010u)
#define CSL_CPINTC_ENABLE_REG24_ENABLE_784_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG24_ENABLE_785_MASK (0x00020000u)
#define CSL_CPINTC_ENABLE_REG24_ENABLE_785_SHIFT (0x00000011u)
#define CSL_CPINTC_ENABLE_REG24_ENABLE_785_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG24_ENABLE_786_MASK (0x00040000u)
#define CSL_CPINTC_ENABLE_REG24_ENABLE_786_SHIFT (0x00000012u)
#define CSL_CPINTC_ENABLE_REG24_ENABLE_786_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG24_ENABLE_787_MASK (0x00080000u)
#define CSL_CPINTC_ENABLE_REG24_ENABLE_787_SHIFT (0x00000013u)
#define CSL_CPINTC_ENABLE_REG24_ENABLE_787_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG24_ENABLE_788_MASK (0x00100000u)
#define CSL_CPINTC_ENABLE_REG24_ENABLE_788_SHIFT (0x00000014u)
#define CSL_CPINTC_ENABLE_REG24_ENABLE_788_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG24_ENABLE_789_MASK (0x00200000u)
#define CSL_CPINTC_ENABLE_REG24_ENABLE_789_SHIFT (0x00000015u)
#define CSL_CPINTC_ENABLE_REG24_ENABLE_789_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG24_ENABLE_790_MASK (0x00400000u)
#define CSL_CPINTC_ENABLE_REG24_ENABLE_790_SHIFT (0x00000016u)
#define CSL_CPINTC_ENABLE_REG24_ENABLE_790_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG24_ENABLE_791_MASK (0x00800000u)
#define CSL_CPINTC_ENABLE_REG24_ENABLE_791_SHIFT (0x00000017u)
#define CSL_CPINTC_ENABLE_REG24_ENABLE_791_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG24_ENABLE_792_MASK (0x01000000u)
#define CSL_CPINTC_ENABLE_REG24_ENABLE_792_SHIFT (0x00000018u)
#define CSL_CPINTC_ENABLE_REG24_ENABLE_792_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG24_ENABLE_793_MASK (0x02000000u)
#define CSL_CPINTC_ENABLE_REG24_ENABLE_793_SHIFT (0x00000019u)
#define CSL_CPINTC_ENABLE_REG24_ENABLE_793_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG24_ENABLE_794_MASK (0x04000000u)
#define CSL_CPINTC_ENABLE_REG24_ENABLE_794_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENABLE_REG24_ENABLE_794_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG24_ENABLE_795_MASK (0x08000000u)
#define CSL_CPINTC_ENABLE_REG24_ENABLE_795_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENABLE_REG24_ENABLE_795_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG24_ENABLE_796_MASK (0x10000000u)
#define CSL_CPINTC_ENABLE_REG24_ENABLE_796_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENABLE_REG24_ENABLE_796_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG24_ENABLE_797_MASK (0x20000000u)
#define CSL_CPINTC_ENABLE_REG24_ENABLE_797_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENABLE_REG24_ENABLE_797_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG24_ENABLE_798_MASK (0x40000000u)
#define CSL_CPINTC_ENABLE_REG24_ENABLE_798_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENABLE_REG24_ENABLE_798_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG24_ENABLE_799_MASK (0x80000000u)
#define CSL_CPINTC_ENABLE_REG24_ENABLE_799_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENABLE_REG24_ENABLE_799_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG24_RESETVAL (0x00000000u)

/* enable_reg25 */

#define CSL_CPINTC_ENABLE_REG25_ENABLE_800_MASK (0x00000001u)
#define CSL_CPINTC_ENABLE_REG25_ENABLE_800_SHIFT (0x00000000u)
#define CSL_CPINTC_ENABLE_REG25_ENABLE_800_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG25_ENABLE_801_MASK (0x00000002u)
#define CSL_CPINTC_ENABLE_REG25_ENABLE_801_SHIFT (0x00000001u)
#define CSL_CPINTC_ENABLE_REG25_ENABLE_801_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG25_ENABLE_802_MASK (0x00000004u)
#define CSL_CPINTC_ENABLE_REG25_ENABLE_802_SHIFT (0x00000002u)
#define CSL_CPINTC_ENABLE_REG25_ENABLE_802_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG25_ENABLE_803_MASK (0x00000008u)
#define CSL_CPINTC_ENABLE_REG25_ENABLE_803_SHIFT (0x00000003u)
#define CSL_CPINTC_ENABLE_REG25_ENABLE_803_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG25_ENABLE_804_MASK (0x00000010u)
#define CSL_CPINTC_ENABLE_REG25_ENABLE_804_SHIFT (0x00000004u)
#define CSL_CPINTC_ENABLE_REG25_ENABLE_804_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG25_ENABLE_805_MASK (0x00000020u)
#define CSL_CPINTC_ENABLE_REG25_ENABLE_805_SHIFT (0x00000005u)
#define CSL_CPINTC_ENABLE_REG25_ENABLE_805_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG25_ENABLE_806_MASK (0x00000040u)
#define CSL_CPINTC_ENABLE_REG25_ENABLE_806_SHIFT (0x00000006u)
#define CSL_CPINTC_ENABLE_REG25_ENABLE_806_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG25_ENABLE_807_MASK (0x00000080u)
#define CSL_CPINTC_ENABLE_REG25_ENABLE_807_SHIFT (0x00000007u)
#define CSL_CPINTC_ENABLE_REG25_ENABLE_807_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG25_ENABLE_808_MASK (0x00000100u)
#define CSL_CPINTC_ENABLE_REG25_ENABLE_808_SHIFT (0x00000008u)
#define CSL_CPINTC_ENABLE_REG25_ENABLE_808_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG25_ENABLE_809_MASK (0x00000200u)
#define CSL_CPINTC_ENABLE_REG25_ENABLE_809_SHIFT (0x00000009u)
#define CSL_CPINTC_ENABLE_REG25_ENABLE_809_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG25_ENABLE_810_MASK (0x00000400u)
#define CSL_CPINTC_ENABLE_REG25_ENABLE_810_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENABLE_REG25_ENABLE_810_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG25_ENABLE_811_MASK (0x00000800u)
#define CSL_CPINTC_ENABLE_REG25_ENABLE_811_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENABLE_REG25_ENABLE_811_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG25_ENABLE_812_MASK (0x00001000u)
#define CSL_CPINTC_ENABLE_REG25_ENABLE_812_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENABLE_REG25_ENABLE_812_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG25_ENABLE_813_MASK (0x00002000u)
#define CSL_CPINTC_ENABLE_REG25_ENABLE_813_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENABLE_REG25_ENABLE_813_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG25_ENABLE_814_MASK (0x00004000u)
#define CSL_CPINTC_ENABLE_REG25_ENABLE_814_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENABLE_REG25_ENABLE_814_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG25_ENABLE_815_MASK (0x00008000u)
#define CSL_CPINTC_ENABLE_REG25_ENABLE_815_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENABLE_REG25_ENABLE_815_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG25_ENABLE_816_MASK (0x00010000u)
#define CSL_CPINTC_ENABLE_REG25_ENABLE_816_SHIFT (0x00000010u)
#define CSL_CPINTC_ENABLE_REG25_ENABLE_816_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG25_ENABLE_817_MASK (0x00020000u)
#define CSL_CPINTC_ENABLE_REG25_ENABLE_817_SHIFT (0x00000011u)
#define CSL_CPINTC_ENABLE_REG25_ENABLE_817_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG25_ENABLE_818_MASK (0x00040000u)
#define CSL_CPINTC_ENABLE_REG25_ENABLE_818_SHIFT (0x00000012u)
#define CSL_CPINTC_ENABLE_REG25_ENABLE_818_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG25_ENABLE_819_MASK (0x00080000u)
#define CSL_CPINTC_ENABLE_REG25_ENABLE_819_SHIFT (0x00000013u)
#define CSL_CPINTC_ENABLE_REG25_ENABLE_819_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG25_ENABLE_820_MASK (0x00100000u)
#define CSL_CPINTC_ENABLE_REG25_ENABLE_820_SHIFT (0x00000014u)
#define CSL_CPINTC_ENABLE_REG25_ENABLE_820_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG25_ENABLE_821_MASK (0x00200000u)
#define CSL_CPINTC_ENABLE_REG25_ENABLE_821_SHIFT (0x00000015u)
#define CSL_CPINTC_ENABLE_REG25_ENABLE_821_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG25_ENABLE_822_MASK (0x00400000u)
#define CSL_CPINTC_ENABLE_REG25_ENABLE_822_SHIFT (0x00000016u)
#define CSL_CPINTC_ENABLE_REG25_ENABLE_822_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG25_ENABLE_823_MASK (0x00800000u)
#define CSL_CPINTC_ENABLE_REG25_ENABLE_823_SHIFT (0x00000017u)
#define CSL_CPINTC_ENABLE_REG25_ENABLE_823_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG25_ENABLE_824_MASK (0x01000000u)
#define CSL_CPINTC_ENABLE_REG25_ENABLE_824_SHIFT (0x00000018u)
#define CSL_CPINTC_ENABLE_REG25_ENABLE_824_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG25_ENABLE_825_MASK (0x02000000u)
#define CSL_CPINTC_ENABLE_REG25_ENABLE_825_SHIFT (0x00000019u)
#define CSL_CPINTC_ENABLE_REG25_ENABLE_825_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG25_ENABLE_826_MASK (0x04000000u)
#define CSL_CPINTC_ENABLE_REG25_ENABLE_826_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENABLE_REG25_ENABLE_826_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG25_ENABLE_827_MASK (0x08000000u)
#define CSL_CPINTC_ENABLE_REG25_ENABLE_827_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENABLE_REG25_ENABLE_827_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG25_ENABLE_828_MASK (0x10000000u)
#define CSL_CPINTC_ENABLE_REG25_ENABLE_828_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENABLE_REG25_ENABLE_828_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG25_ENABLE_829_MASK (0x20000000u)
#define CSL_CPINTC_ENABLE_REG25_ENABLE_829_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENABLE_REG25_ENABLE_829_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG25_ENABLE_830_MASK (0x40000000u)
#define CSL_CPINTC_ENABLE_REG25_ENABLE_830_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENABLE_REG25_ENABLE_830_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG25_ENABLE_831_MASK (0x80000000u)
#define CSL_CPINTC_ENABLE_REG25_ENABLE_831_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENABLE_REG25_ENABLE_831_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG25_RESETVAL (0x00000000u)

/* enable_reg26 */

#define CSL_CPINTC_ENABLE_REG26_ENABLE_832_MASK (0x00000001u)
#define CSL_CPINTC_ENABLE_REG26_ENABLE_832_SHIFT (0x00000000u)
#define CSL_CPINTC_ENABLE_REG26_ENABLE_832_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG26_ENABLE_833_MASK (0x00000002u)
#define CSL_CPINTC_ENABLE_REG26_ENABLE_833_SHIFT (0x00000001u)
#define CSL_CPINTC_ENABLE_REG26_ENABLE_833_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG26_ENABLE_834_MASK (0x00000004u)
#define CSL_CPINTC_ENABLE_REG26_ENABLE_834_SHIFT (0x00000002u)
#define CSL_CPINTC_ENABLE_REG26_ENABLE_834_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG26_ENABLE_835_MASK (0x00000008u)
#define CSL_CPINTC_ENABLE_REG26_ENABLE_835_SHIFT (0x00000003u)
#define CSL_CPINTC_ENABLE_REG26_ENABLE_835_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG26_ENABLE_836_MASK (0x00000010u)
#define CSL_CPINTC_ENABLE_REG26_ENABLE_836_SHIFT (0x00000004u)
#define CSL_CPINTC_ENABLE_REG26_ENABLE_836_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG26_ENABLE_837_MASK (0x00000020u)
#define CSL_CPINTC_ENABLE_REG26_ENABLE_837_SHIFT (0x00000005u)
#define CSL_CPINTC_ENABLE_REG26_ENABLE_837_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG26_ENABLE_838_MASK (0x00000040u)
#define CSL_CPINTC_ENABLE_REG26_ENABLE_838_SHIFT (0x00000006u)
#define CSL_CPINTC_ENABLE_REG26_ENABLE_838_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG26_ENABLE_839_MASK (0x00000080u)
#define CSL_CPINTC_ENABLE_REG26_ENABLE_839_SHIFT (0x00000007u)
#define CSL_CPINTC_ENABLE_REG26_ENABLE_839_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG26_ENABLE_840_MASK (0x00000100u)
#define CSL_CPINTC_ENABLE_REG26_ENABLE_840_SHIFT (0x00000008u)
#define CSL_CPINTC_ENABLE_REG26_ENABLE_840_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG26_ENABLE_841_MASK (0x00000200u)
#define CSL_CPINTC_ENABLE_REG26_ENABLE_841_SHIFT (0x00000009u)
#define CSL_CPINTC_ENABLE_REG26_ENABLE_841_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG26_ENABLE_842_MASK (0x00000400u)
#define CSL_CPINTC_ENABLE_REG26_ENABLE_842_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENABLE_REG26_ENABLE_842_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG26_ENABLE_843_MASK (0x00000800u)
#define CSL_CPINTC_ENABLE_REG26_ENABLE_843_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENABLE_REG26_ENABLE_843_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG26_ENABLE_844_MASK (0x00001000u)
#define CSL_CPINTC_ENABLE_REG26_ENABLE_844_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENABLE_REG26_ENABLE_844_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG26_ENABLE_845_MASK (0x00002000u)
#define CSL_CPINTC_ENABLE_REG26_ENABLE_845_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENABLE_REG26_ENABLE_845_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG26_ENABLE_846_MASK (0x00004000u)
#define CSL_CPINTC_ENABLE_REG26_ENABLE_846_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENABLE_REG26_ENABLE_846_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG26_ENABLE_847_MASK (0x00008000u)
#define CSL_CPINTC_ENABLE_REG26_ENABLE_847_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENABLE_REG26_ENABLE_847_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG26_ENABLE_848_MASK (0x00010000u)
#define CSL_CPINTC_ENABLE_REG26_ENABLE_848_SHIFT (0x00000010u)
#define CSL_CPINTC_ENABLE_REG26_ENABLE_848_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG26_ENABLE_849_MASK (0x00020000u)
#define CSL_CPINTC_ENABLE_REG26_ENABLE_849_SHIFT (0x00000011u)
#define CSL_CPINTC_ENABLE_REG26_ENABLE_849_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG26_ENABLE_850_MASK (0x00040000u)
#define CSL_CPINTC_ENABLE_REG26_ENABLE_850_SHIFT (0x00000012u)
#define CSL_CPINTC_ENABLE_REG26_ENABLE_850_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG26_ENABLE_851_MASK (0x00080000u)
#define CSL_CPINTC_ENABLE_REG26_ENABLE_851_SHIFT (0x00000013u)
#define CSL_CPINTC_ENABLE_REG26_ENABLE_851_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG26_ENABLE_852_MASK (0x00100000u)
#define CSL_CPINTC_ENABLE_REG26_ENABLE_852_SHIFT (0x00000014u)
#define CSL_CPINTC_ENABLE_REG26_ENABLE_852_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG26_ENABLE_853_MASK (0x00200000u)
#define CSL_CPINTC_ENABLE_REG26_ENABLE_853_SHIFT (0x00000015u)
#define CSL_CPINTC_ENABLE_REG26_ENABLE_853_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG26_ENABLE_854_MASK (0x00400000u)
#define CSL_CPINTC_ENABLE_REG26_ENABLE_854_SHIFT (0x00000016u)
#define CSL_CPINTC_ENABLE_REG26_ENABLE_854_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG26_ENABLE_855_MASK (0x00800000u)
#define CSL_CPINTC_ENABLE_REG26_ENABLE_855_SHIFT (0x00000017u)
#define CSL_CPINTC_ENABLE_REG26_ENABLE_855_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG26_ENABLE_856_MASK (0x01000000u)
#define CSL_CPINTC_ENABLE_REG26_ENABLE_856_SHIFT (0x00000018u)
#define CSL_CPINTC_ENABLE_REG26_ENABLE_856_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG26_ENABLE_857_MASK (0x02000000u)
#define CSL_CPINTC_ENABLE_REG26_ENABLE_857_SHIFT (0x00000019u)
#define CSL_CPINTC_ENABLE_REG26_ENABLE_857_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG26_ENABLE_858_MASK (0x04000000u)
#define CSL_CPINTC_ENABLE_REG26_ENABLE_858_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENABLE_REG26_ENABLE_858_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG26_ENABLE_859_MASK (0x08000000u)
#define CSL_CPINTC_ENABLE_REG26_ENABLE_859_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENABLE_REG26_ENABLE_859_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG26_ENABLE_860_MASK (0x10000000u)
#define CSL_CPINTC_ENABLE_REG26_ENABLE_860_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENABLE_REG26_ENABLE_860_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG26_ENABLE_861_MASK (0x20000000u)
#define CSL_CPINTC_ENABLE_REG26_ENABLE_861_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENABLE_REG26_ENABLE_861_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG26_ENABLE_862_MASK (0x40000000u)
#define CSL_CPINTC_ENABLE_REG26_ENABLE_862_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENABLE_REG26_ENABLE_862_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG26_ENABLE_863_MASK (0x80000000u)
#define CSL_CPINTC_ENABLE_REG26_ENABLE_863_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENABLE_REG26_ENABLE_863_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG26_RESETVAL (0x00000000u)

/* enable_reg27 */

#define CSL_CPINTC_ENABLE_REG27_ENABLE_864_MASK (0x00000001u)
#define CSL_CPINTC_ENABLE_REG27_ENABLE_864_SHIFT (0x00000000u)
#define CSL_CPINTC_ENABLE_REG27_ENABLE_864_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG27_ENABLE_865_MASK (0x00000002u)
#define CSL_CPINTC_ENABLE_REG27_ENABLE_865_SHIFT (0x00000001u)
#define CSL_CPINTC_ENABLE_REG27_ENABLE_865_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG27_ENABLE_866_MASK (0x00000004u)
#define CSL_CPINTC_ENABLE_REG27_ENABLE_866_SHIFT (0x00000002u)
#define CSL_CPINTC_ENABLE_REG27_ENABLE_866_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG27_ENABLE_867_MASK (0x00000008u)
#define CSL_CPINTC_ENABLE_REG27_ENABLE_867_SHIFT (0x00000003u)
#define CSL_CPINTC_ENABLE_REG27_ENABLE_867_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG27_ENABLE_868_MASK (0x00000010u)
#define CSL_CPINTC_ENABLE_REG27_ENABLE_868_SHIFT (0x00000004u)
#define CSL_CPINTC_ENABLE_REG27_ENABLE_868_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG27_ENABLE_869_MASK (0x00000020u)
#define CSL_CPINTC_ENABLE_REG27_ENABLE_869_SHIFT (0x00000005u)
#define CSL_CPINTC_ENABLE_REG27_ENABLE_869_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG27_ENABLE_870_MASK (0x00000040u)
#define CSL_CPINTC_ENABLE_REG27_ENABLE_870_SHIFT (0x00000006u)
#define CSL_CPINTC_ENABLE_REG27_ENABLE_870_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG27_ENABLE_871_MASK (0x00000080u)
#define CSL_CPINTC_ENABLE_REG27_ENABLE_871_SHIFT (0x00000007u)
#define CSL_CPINTC_ENABLE_REG27_ENABLE_871_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG27_ENABLE_872_MASK (0x00000100u)
#define CSL_CPINTC_ENABLE_REG27_ENABLE_872_SHIFT (0x00000008u)
#define CSL_CPINTC_ENABLE_REG27_ENABLE_872_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG27_ENABLE_873_MASK (0x00000200u)
#define CSL_CPINTC_ENABLE_REG27_ENABLE_873_SHIFT (0x00000009u)
#define CSL_CPINTC_ENABLE_REG27_ENABLE_873_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG27_ENABLE_874_MASK (0x00000400u)
#define CSL_CPINTC_ENABLE_REG27_ENABLE_874_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENABLE_REG27_ENABLE_874_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG27_ENABLE_875_MASK (0x00000800u)
#define CSL_CPINTC_ENABLE_REG27_ENABLE_875_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENABLE_REG27_ENABLE_875_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG27_ENABLE_876_MASK (0x00001000u)
#define CSL_CPINTC_ENABLE_REG27_ENABLE_876_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENABLE_REG27_ENABLE_876_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG27_ENABLE_877_MASK (0x00002000u)
#define CSL_CPINTC_ENABLE_REG27_ENABLE_877_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENABLE_REG27_ENABLE_877_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG27_ENABLE_878_MASK (0x00004000u)
#define CSL_CPINTC_ENABLE_REG27_ENABLE_878_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENABLE_REG27_ENABLE_878_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG27_ENABLE_879_MASK (0x00008000u)
#define CSL_CPINTC_ENABLE_REG27_ENABLE_879_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENABLE_REG27_ENABLE_879_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG27_ENABLE_880_MASK (0x00010000u)
#define CSL_CPINTC_ENABLE_REG27_ENABLE_880_SHIFT (0x00000010u)
#define CSL_CPINTC_ENABLE_REG27_ENABLE_880_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG27_ENABLE_881_MASK (0x00020000u)
#define CSL_CPINTC_ENABLE_REG27_ENABLE_881_SHIFT (0x00000011u)
#define CSL_CPINTC_ENABLE_REG27_ENABLE_881_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG27_ENABLE_882_MASK (0x00040000u)
#define CSL_CPINTC_ENABLE_REG27_ENABLE_882_SHIFT (0x00000012u)
#define CSL_CPINTC_ENABLE_REG27_ENABLE_882_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG27_ENABLE_883_MASK (0x00080000u)
#define CSL_CPINTC_ENABLE_REG27_ENABLE_883_SHIFT (0x00000013u)
#define CSL_CPINTC_ENABLE_REG27_ENABLE_883_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG27_ENABLE_884_MASK (0x00100000u)
#define CSL_CPINTC_ENABLE_REG27_ENABLE_884_SHIFT (0x00000014u)
#define CSL_CPINTC_ENABLE_REG27_ENABLE_884_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG27_ENABLE_885_MASK (0x00200000u)
#define CSL_CPINTC_ENABLE_REG27_ENABLE_885_SHIFT (0x00000015u)
#define CSL_CPINTC_ENABLE_REG27_ENABLE_885_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG27_ENABLE_886_MASK (0x00400000u)
#define CSL_CPINTC_ENABLE_REG27_ENABLE_886_SHIFT (0x00000016u)
#define CSL_CPINTC_ENABLE_REG27_ENABLE_886_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG27_ENABLE_887_MASK (0x00800000u)
#define CSL_CPINTC_ENABLE_REG27_ENABLE_887_SHIFT (0x00000017u)
#define CSL_CPINTC_ENABLE_REG27_ENABLE_887_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG27_ENABLE_888_MASK (0x01000000u)
#define CSL_CPINTC_ENABLE_REG27_ENABLE_888_SHIFT (0x00000018u)
#define CSL_CPINTC_ENABLE_REG27_ENABLE_888_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG27_ENABLE_889_MASK (0x02000000u)
#define CSL_CPINTC_ENABLE_REG27_ENABLE_889_SHIFT (0x00000019u)
#define CSL_CPINTC_ENABLE_REG27_ENABLE_889_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG27_ENABLE_890_MASK (0x04000000u)
#define CSL_CPINTC_ENABLE_REG27_ENABLE_890_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENABLE_REG27_ENABLE_890_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG27_ENABLE_891_MASK (0x08000000u)
#define CSL_CPINTC_ENABLE_REG27_ENABLE_891_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENABLE_REG27_ENABLE_891_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG27_ENABLE_892_MASK (0x10000000u)
#define CSL_CPINTC_ENABLE_REG27_ENABLE_892_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENABLE_REG27_ENABLE_892_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG27_ENABLE_893_MASK (0x20000000u)
#define CSL_CPINTC_ENABLE_REG27_ENABLE_893_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENABLE_REG27_ENABLE_893_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG27_ENABLE_894_MASK (0x40000000u)
#define CSL_CPINTC_ENABLE_REG27_ENABLE_894_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENABLE_REG27_ENABLE_894_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG27_ENABLE_895_MASK (0x80000000u)
#define CSL_CPINTC_ENABLE_REG27_ENABLE_895_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENABLE_REG27_ENABLE_895_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG27_RESETVAL (0x00000000u)

/* enable_reg28 */

#define CSL_CPINTC_ENABLE_REG28_ENABLE_896_MASK (0x00000001u)
#define CSL_CPINTC_ENABLE_REG28_ENABLE_896_SHIFT (0x00000000u)
#define CSL_CPINTC_ENABLE_REG28_ENABLE_896_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG28_ENABLE_897_MASK (0x00000002u)
#define CSL_CPINTC_ENABLE_REG28_ENABLE_897_SHIFT (0x00000001u)
#define CSL_CPINTC_ENABLE_REG28_ENABLE_897_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG28_ENABLE_898_MASK (0x00000004u)
#define CSL_CPINTC_ENABLE_REG28_ENABLE_898_SHIFT (0x00000002u)
#define CSL_CPINTC_ENABLE_REG28_ENABLE_898_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG28_ENABLE_899_MASK (0x00000008u)
#define CSL_CPINTC_ENABLE_REG28_ENABLE_899_SHIFT (0x00000003u)
#define CSL_CPINTC_ENABLE_REG28_ENABLE_899_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG28_ENABLE_900_MASK (0x00000010u)
#define CSL_CPINTC_ENABLE_REG28_ENABLE_900_SHIFT (0x00000004u)
#define CSL_CPINTC_ENABLE_REG28_ENABLE_900_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG28_ENABLE_901_MASK (0x00000020u)
#define CSL_CPINTC_ENABLE_REG28_ENABLE_901_SHIFT (0x00000005u)
#define CSL_CPINTC_ENABLE_REG28_ENABLE_901_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG28_ENABLE_902_MASK (0x00000040u)
#define CSL_CPINTC_ENABLE_REG28_ENABLE_902_SHIFT (0x00000006u)
#define CSL_CPINTC_ENABLE_REG28_ENABLE_902_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG28_ENABLE_903_MASK (0x00000080u)
#define CSL_CPINTC_ENABLE_REG28_ENABLE_903_SHIFT (0x00000007u)
#define CSL_CPINTC_ENABLE_REG28_ENABLE_903_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG28_ENABLE_904_MASK (0x00000100u)
#define CSL_CPINTC_ENABLE_REG28_ENABLE_904_SHIFT (0x00000008u)
#define CSL_CPINTC_ENABLE_REG28_ENABLE_904_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG28_ENABLE_905_MASK (0x00000200u)
#define CSL_CPINTC_ENABLE_REG28_ENABLE_905_SHIFT (0x00000009u)
#define CSL_CPINTC_ENABLE_REG28_ENABLE_905_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG28_ENABLE_906_MASK (0x00000400u)
#define CSL_CPINTC_ENABLE_REG28_ENABLE_906_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENABLE_REG28_ENABLE_906_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG28_ENABLE_907_MASK (0x00000800u)
#define CSL_CPINTC_ENABLE_REG28_ENABLE_907_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENABLE_REG28_ENABLE_907_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG28_ENABLE_908_MASK (0x00001000u)
#define CSL_CPINTC_ENABLE_REG28_ENABLE_908_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENABLE_REG28_ENABLE_908_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG28_ENABLE_909_MASK (0x00002000u)
#define CSL_CPINTC_ENABLE_REG28_ENABLE_909_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENABLE_REG28_ENABLE_909_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG28_ENABLE_910_MASK (0x00004000u)
#define CSL_CPINTC_ENABLE_REG28_ENABLE_910_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENABLE_REG28_ENABLE_910_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG28_ENABLE_911_MASK (0x00008000u)
#define CSL_CPINTC_ENABLE_REG28_ENABLE_911_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENABLE_REG28_ENABLE_911_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG28_ENABLE_912_MASK (0x00010000u)
#define CSL_CPINTC_ENABLE_REG28_ENABLE_912_SHIFT (0x00000010u)
#define CSL_CPINTC_ENABLE_REG28_ENABLE_912_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG28_ENABLE_913_MASK (0x00020000u)
#define CSL_CPINTC_ENABLE_REG28_ENABLE_913_SHIFT (0x00000011u)
#define CSL_CPINTC_ENABLE_REG28_ENABLE_913_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG28_ENABLE_914_MASK (0x00040000u)
#define CSL_CPINTC_ENABLE_REG28_ENABLE_914_SHIFT (0x00000012u)
#define CSL_CPINTC_ENABLE_REG28_ENABLE_914_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG28_ENABLE_915_MASK (0x00080000u)
#define CSL_CPINTC_ENABLE_REG28_ENABLE_915_SHIFT (0x00000013u)
#define CSL_CPINTC_ENABLE_REG28_ENABLE_915_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG28_ENABLE_916_MASK (0x00100000u)
#define CSL_CPINTC_ENABLE_REG28_ENABLE_916_SHIFT (0x00000014u)
#define CSL_CPINTC_ENABLE_REG28_ENABLE_916_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG28_ENABLE_917_MASK (0x00200000u)
#define CSL_CPINTC_ENABLE_REG28_ENABLE_917_SHIFT (0x00000015u)
#define CSL_CPINTC_ENABLE_REG28_ENABLE_917_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG28_ENABLE_918_MASK (0x00400000u)
#define CSL_CPINTC_ENABLE_REG28_ENABLE_918_SHIFT (0x00000016u)
#define CSL_CPINTC_ENABLE_REG28_ENABLE_918_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG28_ENABLE_919_MASK (0x00800000u)
#define CSL_CPINTC_ENABLE_REG28_ENABLE_919_SHIFT (0x00000017u)
#define CSL_CPINTC_ENABLE_REG28_ENABLE_919_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG28_ENABLE_920_MASK (0x01000000u)
#define CSL_CPINTC_ENABLE_REG28_ENABLE_920_SHIFT (0x00000018u)
#define CSL_CPINTC_ENABLE_REG28_ENABLE_920_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG28_ENABLE_921_MASK (0x02000000u)
#define CSL_CPINTC_ENABLE_REG28_ENABLE_921_SHIFT (0x00000019u)
#define CSL_CPINTC_ENABLE_REG28_ENABLE_921_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG28_ENABLE_922_MASK (0x04000000u)
#define CSL_CPINTC_ENABLE_REG28_ENABLE_922_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENABLE_REG28_ENABLE_922_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG28_ENABLE_923_MASK (0x08000000u)
#define CSL_CPINTC_ENABLE_REG28_ENABLE_923_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENABLE_REG28_ENABLE_923_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG28_ENABLE_924_MASK (0x10000000u)
#define CSL_CPINTC_ENABLE_REG28_ENABLE_924_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENABLE_REG28_ENABLE_924_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG28_ENABLE_925_MASK (0x20000000u)
#define CSL_CPINTC_ENABLE_REG28_ENABLE_925_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENABLE_REG28_ENABLE_925_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG28_ENABLE_926_MASK (0x40000000u)
#define CSL_CPINTC_ENABLE_REG28_ENABLE_926_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENABLE_REG28_ENABLE_926_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG28_ENABLE_927_MASK (0x80000000u)
#define CSL_CPINTC_ENABLE_REG28_ENABLE_927_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENABLE_REG28_ENABLE_927_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG28_RESETVAL (0x00000000u)

/* enable_reg29 */

#define CSL_CPINTC_ENABLE_REG29_ENABLE_928_MASK (0x00000001u)
#define CSL_CPINTC_ENABLE_REG29_ENABLE_928_SHIFT (0x00000000u)
#define CSL_CPINTC_ENABLE_REG29_ENABLE_928_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG29_ENABLE_929_MASK (0x00000002u)
#define CSL_CPINTC_ENABLE_REG29_ENABLE_929_SHIFT (0x00000001u)
#define CSL_CPINTC_ENABLE_REG29_ENABLE_929_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG29_ENABLE_930_MASK (0x00000004u)
#define CSL_CPINTC_ENABLE_REG29_ENABLE_930_SHIFT (0x00000002u)
#define CSL_CPINTC_ENABLE_REG29_ENABLE_930_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG29_ENABLE_931_MASK (0x00000008u)
#define CSL_CPINTC_ENABLE_REG29_ENABLE_931_SHIFT (0x00000003u)
#define CSL_CPINTC_ENABLE_REG29_ENABLE_931_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG29_ENABLE_932_MASK (0x00000010u)
#define CSL_CPINTC_ENABLE_REG29_ENABLE_932_SHIFT (0x00000004u)
#define CSL_CPINTC_ENABLE_REG29_ENABLE_932_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG29_ENABLE_933_MASK (0x00000020u)
#define CSL_CPINTC_ENABLE_REG29_ENABLE_933_SHIFT (0x00000005u)
#define CSL_CPINTC_ENABLE_REG29_ENABLE_933_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG29_ENABLE_934_MASK (0x00000040u)
#define CSL_CPINTC_ENABLE_REG29_ENABLE_934_SHIFT (0x00000006u)
#define CSL_CPINTC_ENABLE_REG29_ENABLE_934_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG29_ENABLE_935_MASK (0x00000080u)
#define CSL_CPINTC_ENABLE_REG29_ENABLE_935_SHIFT (0x00000007u)
#define CSL_CPINTC_ENABLE_REG29_ENABLE_935_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG29_ENABLE_936_MASK (0x00000100u)
#define CSL_CPINTC_ENABLE_REG29_ENABLE_936_SHIFT (0x00000008u)
#define CSL_CPINTC_ENABLE_REG29_ENABLE_936_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG29_ENABLE_937_MASK (0x00000200u)
#define CSL_CPINTC_ENABLE_REG29_ENABLE_937_SHIFT (0x00000009u)
#define CSL_CPINTC_ENABLE_REG29_ENABLE_937_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG29_ENABLE_938_MASK (0x00000400u)
#define CSL_CPINTC_ENABLE_REG29_ENABLE_938_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENABLE_REG29_ENABLE_938_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG29_ENABLE_939_MASK (0x00000800u)
#define CSL_CPINTC_ENABLE_REG29_ENABLE_939_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENABLE_REG29_ENABLE_939_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG29_ENABLE_940_MASK (0x00001000u)
#define CSL_CPINTC_ENABLE_REG29_ENABLE_940_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENABLE_REG29_ENABLE_940_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG29_ENABLE_941_MASK (0x00002000u)
#define CSL_CPINTC_ENABLE_REG29_ENABLE_941_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENABLE_REG29_ENABLE_941_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG29_ENABLE_942_MASK (0x00004000u)
#define CSL_CPINTC_ENABLE_REG29_ENABLE_942_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENABLE_REG29_ENABLE_942_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG29_ENABLE_943_MASK (0x00008000u)
#define CSL_CPINTC_ENABLE_REG29_ENABLE_943_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENABLE_REG29_ENABLE_943_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG29_ENABLE_944_MASK (0x00010000u)
#define CSL_CPINTC_ENABLE_REG29_ENABLE_944_SHIFT (0x00000010u)
#define CSL_CPINTC_ENABLE_REG29_ENABLE_944_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG29_ENABLE_945_MASK (0x00020000u)
#define CSL_CPINTC_ENABLE_REG29_ENABLE_945_SHIFT (0x00000011u)
#define CSL_CPINTC_ENABLE_REG29_ENABLE_945_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG29_ENABLE_946_MASK (0x00040000u)
#define CSL_CPINTC_ENABLE_REG29_ENABLE_946_SHIFT (0x00000012u)
#define CSL_CPINTC_ENABLE_REG29_ENABLE_946_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG29_ENABLE_947_MASK (0x00080000u)
#define CSL_CPINTC_ENABLE_REG29_ENABLE_947_SHIFT (0x00000013u)
#define CSL_CPINTC_ENABLE_REG29_ENABLE_947_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG29_ENABLE_948_MASK (0x00100000u)
#define CSL_CPINTC_ENABLE_REG29_ENABLE_948_SHIFT (0x00000014u)
#define CSL_CPINTC_ENABLE_REG29_ENABLE_948_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG29_ENABLE_949_MASK (0x00200000u)
#define CSL_CPINTC_ENABLE_REG29_ENABLE_949_SHIFT (0x00000015u)
#define CSL_CPINTC_ENABLE_REG29_ENABLE_949_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG29_ENABLE_950_MASK (0x00400000u)
#define CSL_CPINTC_ENABLE_REG29_ENABLE_950_SHIFT (0x00000016u)
#define CSL_CPINTC_ENABLE_REG29_ENABLE_950_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG29_ENABLE_951_MASK (0x00800000u)
#define CSL_CPINTC_ENABLE_REG29_ENABLE_951_SHIFT (0x00000017u)
#define CSL_CPINTC_ENABLE_REG29_ENABLE_951_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG29_ENABLE_952_MASK (0x01000000u)
#define CSL_CPINTC_ENABLE_REG29_ENABLE_952_SHIFT (0x00000018u)
#define CSL_CPINTC_ENABLE_REG29_ENABLE_952_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG29_ENABLE_953_MASK (0x02000000u)
#define CSL_CPINTC_ENABLE_REG29_ENABLE_953_SHIFT (0x00000019u)
#define CSL_CPINTC_ENABLE_REG29_ENABLE_953_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG29_ENABLE_954_MASK (0x04000000u)
#define CSL_CPINTC_ENABLE_REG29_ENABLE_954_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENABLE_REG29_ENABLE_954_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG29_ENABLE_955_MASK (0x08000000u)
#define CSL_CPINTC_ENABLE_REG29_ENABLE_955_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENABLE_REG29_ENABLE_955_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG29_ENABLE_956_MASK (0x10000000u)
#define CSL_CPINTC_ENABLE_REG29_ENABLE_956_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENABLE_REG29_ENABLE_956_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG29_ENABLE_957_MASK (0x20000000u)
#define CSL_CPINTC_ENABLE_REG29_ENABLE_957_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENABLE_REG29_ENABLE_957_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG29_ENABLE_958_MASK (0x40000000u)
#define CSL_CPINTC_ENABLE_REG29_ENABLE_958_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENABLE_REG29_ENABLE_958_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG29_ENABLE_959_MASK (0x80000000u)
#define CSL_CPINTC_ENABLE_REG29_ENABLE_959_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENABLE_REG29_ENABLE_959_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG29_RESETVAL (0x00000000u)

/* enable_reg30 */

#define CSL_CPINTC_ENABLE_REG30_ENABLE_960_MASK (0x00000001u)
#define CSL_CPINTC_ENABLE_REG30_ENABLE_960_SHIFT (0x00000000u)
#define CSL_CPINTC_ENABLE_REG30_ENABLE_960_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG30_ENABLE_961_MASK (0x00000002u)
#define CSL_CPINTC_ENABLE_REG30_ENABLE_961_SHIFT (0x00000001u)
#define CSL_CPINTC_ENABLE_REG30_ENABLE_961_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG30_ENABLE_962_MASK (0x00000004u)
#define CSL_CPINTC_ENABLE_REG30_ENABLE_962_SHIFT (0x00000002u)
#define CSL_CPINTC_ENABLE_REG30_ENABLE_962_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG30_ENABLE_963_MASK (0x00000008u)
#define CSL_CPINTC_ENABLE_REG30_ENABLE_963_SHIFT (0x00000003u)
#define CSL_CPINTC_ENABLE_REG30_ENABLE_963_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG30_ENABLE_964_MASK (0x00000010u)
#define CSL_CPINTC_ENABLE_REG30_ENABLE_964_SHIFT (0x00000004u)
#define CSL_CPINTC_ENABLE_REG30_ENABLE_964_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG30_ENABLE_965_MASK (0x00000020u)
#define CSL_CPINTC_ENABLE_REG30_ENABLE_965_SHIFT (0x00000005u)
#define CSL_CPINTC_ENABLE_REG30_ENABLE_965_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG30_ENABLE_966_MASK (0x00000040u)
#define CSL_CPINTC_ENABLE_REG30_ENABLE_966_SHIFT (0x00000006u)
#define CSL_CPINTC_ENABLE_REG30_ENABLE_966_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG30_ENABLE_967_MASK (0x00000080u)
#define CSL_CPINTC_ENABLE_REG30_ENABLE_967_SHIFT (0x00000007u)
#define CSL_CPINTC_ENABLE_REG30_ENABLE_967_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG30_ENABLE_968_MASK (0x00000100u)
#define CSL_CPINTC_ENABLE_REG30_ENABLE_968_SHIFT (0x00000008u)
#define CSL_CPINTC_ENABLE_REG30_ENABLE_968_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG30_ENABLE_969_MASK (0x00000200u)
#define CSL_CPINTC_ENABLE_REG30_ENABLE_969_SHIFT (0x00000009u)
#define CSL_CPINTC_ENABLE_REG30_ENABLE_969_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG30_ENABLE_970_MASK (0x00000400u)
#define CSL_CPINTC_ENABLE_REG30_ENABLE_970_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENABLE_REG30_ENABLE_970_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG30_ENABLE_971_MASK (0x00000800u)
#define CSL_CPINTC_ENABLE_REG30_ENABLE_971_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENABLE_REG30_ENABLE_971_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG30_ENABLE_972_MASK (0x00001000u)
#define CSL_CPINTC_ENABLE_REG30_ENABLE_972_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENABLE_REG30_ENABLE_972_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG30_ENABLE_973_MASK (0x00002000u)
#define CSL_CPINTC_ENABLE_REG30_ENABLE_973_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENABLE_REG30_ENABLE_973_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG30_ENABLE_974_MASK (0x00004000u)
#define CSL_CPINTC_ENABLE_REG30_ENABLE_974_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENABLE_REG30_ENABLE_974_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG30_ENABLE_975_MASK (0x00008000u)
#define CSL_CPINTC_ENABLE_REG30_ENABLE_975_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENABLE_REG30_ENABLE_975_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG30_ENABLE_976_MASK (0x00010000u)
#define CSL_CPINTC_ENABLE_REG30_ENABLE_976_SHIFT (0x00000010u)
#define CSL_CPINTC_ENABLE_REG30_ENABLE_976_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG30_ENABLE_977_MASK (0x00020000u)
#define CSL_CPINTC_ENABLE_REG30_ENABLE_977_SHIFT (0x00000011u)
#define CSL_CPINTC_ENABLE_REG30_ENABLE_977_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG30_ENABLE_978_MASK (0x00040000u)
#define CSL_CPINTC_ENABLE_REG30_ENABLE_978_SHIFT (0x00000012u)
#define CSL_CPINTC_ENABLE_REG30_ENABLE_978_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG30_ENABLE_979_MASK (0x00080000u)
#define CSL_CPINTC_ENABLE_REG30_ENABLE_979_SHIFT (0x00000013u)
#define CSL_CPINTC_ENABLE_REG30_ENABLE_979_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG30_ENABLE_980_MASK (0x00100000u)
#define CSL_CPINTC_ENABLE_REG30_ENABLE_980_SHIFT (0x00000014u)
#define CSL_CPINTC_ENABLE_REG30_ENABLE_980_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG30_ENABLE_981_MASK (0x00200000u)
#define CSL_CPINTC_ENABLE_REG30_ENABLE_981_SHIFT (0x00000015u)
#define CSL_CPINTC_ENABLE_REG30_ENABLE_981_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG30_ENABLE_982_MASK (0x00400000u)
#define CSL_CPINTC_ENABLE_REG30_ENABLE_982_SHIFT (0x00000016u)
#define CSL_CPINTC_ENABLE_REG30_ENABLE_982_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG30_ENABLE_983_MASK (0x00800000u)
#define CSL_CPINTC_ENABLE_REG30_ENABLE_983_SHIFT (0x00000017u)
#define CSL_CPINTC_ENABLE_REG30_ENABLE_983_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG30_ENABLE_984_MASK (0x01000000u)
#define CSL_CPINTC_ENABLE_REG30_ENABLE_984_SHIFT (0x00000018u)
#define CSL_CPINTC_ENABLE_REG30_ENABLE_984_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG30_ENABLE_985_MASK (0x02000000u)
#define CSL_CPINTC_ENABLE_REG30_ENABLE_985_SHIFT (0x00000019u)
#define CSL_CPINTC_ENABLE_REG30_ENABLE_985_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG30_ENABLE_986_MASK (0x04000000u)
#define CSL_CPINTC_ENABLE_REG30_ENABLE_986_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENABLE_REG30_ENABLE_986_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG30_ENABLE_987_MASK (0x08000000u)
#define CSL_CPINTC_ENABLE_REG30_ENABLE_987_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENABLE_REG30_ENABLE_987_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG30_ENABLE_988_MASK (0x10000000u)
#define CSL_CPINTC_ENABLE_REG30_ENABLE_988_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENABLE_REG30_ENABLE_988_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG30_ENABLE_989_MASK (0x20000000u)
#define CSL_CPINTC_ENABLE_REG30_ENABLE_989_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENABLE_REG30_ENABLE_989_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG30_ENABLE_990_MASK (0x40000000u)
#define CSL_CPINTC_ENABLE_REG30_ENABLE_990_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENABLE_REG30_ENABLE_990_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG30_ENABLE_991_MASK (0x80000000u)
#define CSL_CPINTC_ENABLE_REG30_ENABLE_991_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENABLE_REG30_ENABLE_991_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG30_RESETVAL (0x00000000u)

/* enable_reg31 */

#define CSL_CPINTC_ENABLE_REG31_ENABLE_992_MASK (0x00000001u)
#define CSL_CPINTC_ENABLE_REG31_ENABLE_992_SHIFT (0x00000000u)
#define CSL_CPINTC_ENABLE_REG31_ENABLE_992_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG31_ENABLE_993_MASK (0x00000002u)
#define CSL_CPINTC_ENABLE_REG31_ENABLE_993_SHIFT (0x00000001u)
#define CSL_CPINTC_ENABLE_REG31_ENABLE_993_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG31_ENABLE_994_MASK (0x00000004u)
#define CSL_CPINTC_ENABLE_REG31_ENABLE_994_SHIFT (0x00000002u)
#define CSL_CPINTC_ENABLE_REG31_ENABLE_994_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG31_ENABLE_995_MASK (0x00000008u)
#define CSL_CPINTC_ENABLE_REG31_ENABLE_995_SHIFT (0x00000003u)
#define CSL_CPINTC_ENABLE_REG31_ENABLE_995_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG31_ENABLE_996_MASK (0x00000010u)
#define CSL_CPINTC_ENABLE_REG31_ENABLE_996_SHIFT (0x00000004u)
#define CSL_CPINTC_ENABLE_REG31_ENABLE_996_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG31_ENABLE_997_MASK (0x00000020u)
#define CSL_CPINTC_ENABLE_REG31_ENABLE_997_SHIFT (0x00000005u)
#define CSL_CPINTC_ENABLE_REG31_ENABLE_997_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG31_ENABLE_998_MASK (0x00000040u)
#define CSL_CPINTC_ENABLE_REG31_ENABLE_998_SHIFT (0x00000006u)
#define CSL_CPINTC_ENABLE_REG31_ENABLE_998_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG31_ENABLE_999_MASK (0x00000080u)
#define CSL_CPINTC_ENABLE_REG31_ENABLE_999_SHIFT (0x00000007u)
#define CSL_CPINTC_ENABLE_REG31_ENABLE_999_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG31_ENABLE_1000_MASK (0x00000100u)
#define CSL_CPINTC_ENABLE_REG31_ENABLE_1000_SHIFT (0x00000008u)
#define CSL_CPINTC_ENABLE_REG31_ENABLE_1000_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG31_ENABLE_1001_MASK (0x00000200u)
#define CSL_CPINTC_ENABLE_REG31_ENABLE_1001_SHIFT (0x00000009u)
#define CSL_CPINTC_ENABLE_REG31_ENABLE_1001_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG31_ENABLE_1002_MASK (0x00000400u)
#define CSL_CPINTC_ENABLE_REG31_ENABLE_1002_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENABLE_REG31_ENABLE_1002_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG31_ENABLE_1003_MASK (0x00000800u)
#define CSL_CPINTC_ENABLE_REG31_ENABLE_1003_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENABLE_REG31_ENABLE_1003_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG31_ENABLE_1004_MASK (0x00001000u)
#define CSL_CPINTC_ENABLE_REG31_ENABLE_1004_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENABLE_REG31_ENABLE_1004_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG31_ENABLE_1005_MASK (0x00002000u)
#define CSL_CPINTC_ENABLE_REG31_ENABLE_1005_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENABLE_REG31_ENABLE_1005_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG31_ENABLE_1006_MASK (0x00004000u)
#define CSL_CPINTC_ENABLE_REG31_ENABLE_1006_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENABLE_REG31_ENABLE_1006_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG31_ENABLE_1007_MASK (0x00008000u)
#define CSL_CPINTC_ENABLE_REG31_ENABLE_1007_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENABLE_REG31_ENABLE_1007_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG31_ENABLE_1008_MASK (0x00010000u)
#define CSL_CPINTC_ENABLE_REG31_ENABLE_1008_SHIFT (0x00000010u)
#define CSL_CPINTC_ENABLE_REG31_ENABLE_1008_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG31_ENABLE_1009_MASK (0x00020000u)
#define CSL_CPINTC_ENABLE_REG31_ENABLE_1009_SHIFT (0x00000011u)
#define CSL_CPINTC_ENABLE_REG31_ENABLE_1009_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG31_ENABLE_1010_MASK (0x00040000u)
#define CSL_CPINTC_ENABLE_REG31_ENABLE_1010_SHIFT (0x00000012u)
#define CSL_CPINTC_ENABLE_REG31_ENABLE_1010_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG31_ENABLE_1011_MASK (0x00080000u)
#define CSL_CPINTC_ENABLE_REG31_ENABLE_1011_SHIFT (0x00000013u)
#define CSL_CPINTC_ENABLE_REG31_ENABLE_1011_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG31_ENABLE_1012_MASK (0x00100000u)
#define CSL_CPINTC_ENABLE_REG31_ENABLE_1012_SHIFT (0x00000014u)
#define CSL_CPINTC_ENABLE_REG31_ENABLE_1012_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG31_ENABLE_1013_MASK (0x00200000u)
#define CSL_CPINTC_ENABLE_REG31_ENABLE_1013_SHIFT (0x00000015u)
#define CSL_CPINTC_ENABLE_REG31_ENABLE_1013_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG31_ENABLE_1014_MASK (0x00400000u)
#define CSL_CPINTC_ENABLE_REG31_ENABLE_1014_SHIFT (0x00000016u)
#define CSL_CPINTC_ENABLE_REG31_ENABLE_1014_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG31_ENABLE_1015_MASK (0x00800000u)
#define CSL_CPINTC_ENABLE_REG31_ENABLE_1015_SHIFT (0x00000017u)
#define CSL_CPINTC_ENABLE_REG31_ENABLE_1015_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG31_ENABLE_1016_MASK (0x01000000u)
#define CSL_CPINTC_ENABLE_REG31_ENABLE_1016_SHIFT (0x00000018u)
#define CSL_CPINTC_ENABLE_REG31_ENABLE_1016_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG31_ENABLE_1017_MASK (0x02000000u)
#define CSL_CPINTC_ENABLE_REG31_ENABLE_1017_SHIFT (0x00000019u)
#define CSL_CPINTC_ENABLE_REG31_ENABLE_1017_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG31_ENABLE_1018_MASK (0x04000000u)
#define CSL_CPINTC_ENABLE_REG31_ENABLE_1018_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENABLE_REG31_ENABLE_1018_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG31_ENABLE_1019_MASK (0x08000000u)
#define CSL_CPINTC_ENABLE_REG31_ENABLE_1019_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENABLE_REG31_ENABLE_1019_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG31_ENABLE_1020_MASK (0x10000000u)
#define CSL_CPINTC_ENABLE_REG31_ENABLE_1020_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENABLE_REG31_ENABLE_1020_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG31_ENABLE_1021_MASK (0x20000000u)
#define CSL_CPINTC_ENABLE_REG31_ENABLE_1021_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENABLE_REG31_ENABLE_1021_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG31_ENABLE_1022_MASK (0x40000000u)
#define CSL_CPINTC_ENABLE_REG31_ENABLE_1022_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENABLE_REG31_ENABLE_1022_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG31_ENABLE_1023_MASK (0x80000000u)
#define CSL_CPINTC_ENABLE_REG31_ENABLE_1023_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENABLE_REG31_ENABLE_1023_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_REG31_RESETVAL (0x00000000u)

/* enable_clr_reg0 */

#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_0_CLR_MASK (0x00000001u)
#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_0_CLR_SHIFT (0x00000000u)
#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_0_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_1_CLR_MASK (0x00000002u)
#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_1_CLR_SHIFT (0x00000001u)
#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_1_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_2_CLR_MASK (0x00000004u)
#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_2_CLR_SHIFT (0x00000002u)
#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_2_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_3_CLR_MASK (0x00000008u)
#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_3_CLR_SHIFT (0x00000003u)
#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_3_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_4_CLR_MASK (0x00000010u)
#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_4_CLR_SHIFT (0x00000004u)
#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_4_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_5_CLR_MASK (0x00000020u)
#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_5_CLR_SHIFT (0x00000005u)
#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_5_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_6_CLR_MASK (0x00000040u)
#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_6_CLR_SHIFT (0x00000006u)
#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_6_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_7_CLR_MASK (0x00000080u)
#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_7_CLR_SHIFT (0x00000007u)
#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_7_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_8_CLR_MASK (0x00000100u)
#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_8_CLR_SHIFT (0x00000008u)
#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_8_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_9_CLR_MASK (0x00000200u)
#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_9_CLR_SHIFT (0x00000009u)
#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_9_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_10_CLR_MASK (0x00000400u)
#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_10_CLR_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_10_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_11_CLR_MASK (0x00000800u)
#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_11_CLR_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_11_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_12_CLR_MASK (0x00001000u)
#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_12_CLR_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_12_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_13_CLR_MASK (0x00002000u)
#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_13_CLR_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_13_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_14_CLR_MASK (0x00004000u)
#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_14_CLR_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_14_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_15_CLR_MASK (0x00008000u)
#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_15_CLR_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_15_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_16_CLR_MASK (0x00010000u)
#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_16_CLR_SHIFT (0x00000010u)
#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_16_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_17_CLR_MASK (0x00020000u)
#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_17_CLR_SHIFT (0x00000011u)
#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_17_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_18_CLR_MASK (0x00040000u)
#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_18_CLR_SHIFT (0x00000012u)
#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_18_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_19_CLR_MASK (0x00080000u)
#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_19_CLR_SHIFT (0x00000013u)
#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_19_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_20_CLR_MASK (0x00100000u)
#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_20_CLR_SHIFT (0x00000014u)
#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_20_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_21_CLR_MASK (0x00200000u)
#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_21_CLR_SHIFT (0x00000015u)
#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_21_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_22_CLR_MASK (0x00400000u)
#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_22_CLR_SHIFT (0x00000016u)
#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_22_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_23_CLR_MASK (0x00800000u)
#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_23_CLR_SHIFT (0x00000017u)
#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_23_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_24_CLR_MASK (0x01000000u)
#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_24_CLR_SHIFT (0x00000018u)
#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_24_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_25_CLR_MASK (0x02000000u)
#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_25_CLR_SHIFT (0x00000019u)
#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_25_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_26_CLR_MASK (0x04000000u)
#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_26_CLR_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_26_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_27_CLR_MASK (0x08000000u)
#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_27_CLR_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_27_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_28_CLR_MASK (0x10000000u)
#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_28_CLR_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_28_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_29_CLR_MASK (0x20000000u)
#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_29_CLR_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_29_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_30_CLR_MASK (0x40000000u)
#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_30_CLR_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_30_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_31_CLR_MASK (0x80000000u)
#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_31_CLR_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENABLE_CLR_REG0_ENABLE_31_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG0_RESETVAL (0x00000000u)

/* enable_clr_reg1 */

#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_32_CLR_MASK (0x00000001u)
#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_32_CLR_SHIFT (0x00000000u)
#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_32_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_33_CLR_MASK (0x00000002u)
#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_33_CLR_SHIFT (0x00000001u)
#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_33_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_34_CLR_MASK (0x00000004u)
#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_34_CLR_SHIFT (0x00000002u)
#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_34_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_35_CLR_MASK (0x00000008u)
#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_35_CLR_SHIFT (0x00000003u)
#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_35_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_36_CLR_MASK (0x00000010u)
#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_36_CLR_SHIFT (0x00000004u)
#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_36_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_37_CLR_MASK (0x00000020u)
#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_37_CLR_SHIFT (0x00000005u)
#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_37_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_38_CLR_MASK (0x00000040u)
#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_38_CLR_SHIFT (0x00000006u)
#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_38_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_39_CLR_MASK (0x00000080u)
#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_39_CLR_SHIFT (0x00000007u)
#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_39_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_40_CLR_MASK (0x00000100u)
#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_40_CLR_SHIFT (0x00000008u)
#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_40_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_41_CLR_MASK (0x00000200u)
#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_41_CLR_SHIFT (0x00000009u)
#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_41_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_42_CLR_MASK (0x00000400u)
#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_42_CLR_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_42_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_43_CLR_MASK (0x00000800u)
#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_43_CLR_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_43_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_44_CLR_MASK (0x00001000u)
#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_44_CLR_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_44_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_45_CLR_MASK (0x00002000u)
#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_45_CLR_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_45_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_46_CLR_MASK (0x00004000u)
#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_46_CLR_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_46_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_47_CLR_MASK (0x00008000u)
#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_47_CLR_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_47_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_48_CLR_MASK (0x00010000u)
#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_48_CLR_SHIFT (0x00000010u)
#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_48_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_49_CLR_MASK (0x00020000u)
#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_49_CLR_SHIFT (0x00000011u)
#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_49_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_50_CLR_MASK (0x00040000u)
#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_50_CLR_SHIFT (0x00000012u)
#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_50_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_51_CLR_MASK (0x00080000u)
#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_51_CLR_SHIFT (0x00000013u)
#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_51_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_52_CLR_MASK (0x00100000u)
#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_52_CLR_SHIFT (0x00000014u)
#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_52_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_53_CLR_MASK (0x00200000u)
#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_53_CLR_SHIFT (0x00000015u)
#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_53_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_54_CLR_MASK (0x00400000u)
#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_54_CLR_SHIFT (0x00000016u)
#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_54_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_55_CLR_MASK (0x00800000u)
#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_55_CLR_SHIFT (0x00000017u)
#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_55_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_56_CLR_MASK (0x01000000u)
#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_56_CLR_SHIFT (0x00000018u)
#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_56_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_57_CLR_MASK (0x02000000u)
#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_57_CLR_SHIFT (0x00000019u)
#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_57_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_58_CLR_MASK (0x04000000u)
#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_58_CLR_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_58_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_59_CLR_MASK (0x08000000u)
#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_59_CLR_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_59_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_60_CLR_MASK (0x10000000u)
#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_60_CLR_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_60_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_61_CLR_MASK (0x20000000u)
#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_61_CLR_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_61_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_62_CLR_MASK (0x40000000u)
#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_62_CLR_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_62_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_63_CLR_MASK (0x80000000u)
#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_63_CLR_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENABLE_CLR_REG1_ENABLE_63_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG1_RESETVAL (0x00000000u)

/* enable_clr_reg2 */

#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_64_CLR_MASK (0x00000001u)
#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_64_CLR_SHIFT (0x00000000u)
#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_64_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_65_CLR_MASK (0x00000002u)
#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_65_CLR_SHIFT (0x00000001u)
#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_65_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_66_CLR_MASK (0x00000004u)
#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_66_CLR_SHIFT (0x00000002u)
#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_66_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_67_CLR_MASK (0x00000008u)
#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_67_CLR_SHIFT (0x00000003u)
#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_67_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_68_CLR_MASK (0x00000010u)
#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_68_CLR_SHIFT (0x00000004u)
#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_68_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_69_CLR_MASK (0x00000020u)
#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_69_CLR_SHIFT (0x00000005u)
#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_69_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_70_CLR_MASK (0x00000040u)
#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_70_CLR_SHIFT (0x00000006u)
#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_70_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_71_CLR_MASK (0x00000080u)
#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_71_CLR_SHIFT (0x00000007u)
#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_71_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_72_CLR_MASK (0x00000100u)
#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_72_CLR_SHIFT (0x00000008u)
#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_72_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_73_CLR_MASK (0x00000200u)
#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_73_CLR_SHIFT (0x00000009u)
#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_73_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_74_CLR_MASK (0x00000400u)
#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_74_CLR_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_74_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_75_CLR_MASK (0x00000800u)
#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_75_CLR_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_75_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_76_CLR_MASK (0x00001000u)
#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_76_CLR_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_76_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_77_CLR_MASK (0x00002000u)
#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_77_CLR_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_77_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_78_CLR_MASK (0x00004000u)
#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_78_CLR_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_78_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_79_CLR_MASK (0x00008000u)
#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_79_CLR_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_79_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_80_CLR_MASK (0x00010000u)
#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_80_CLR_SHIFT (0x00000010u)
#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_80_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_81_CLR_MASK (0x00020000u)
#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_81_CLR_SHIFT (0x00000011u)
#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_81_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_82_CLR_MASK (0x00040000u)
#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_82_CLR_SHIFT (0x00000012u)
#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_82_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_83_CLR_MASK (0x00080000u)
#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_83_CLR_SHIFT (0x00000013u)
#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_83_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_84_CLR_MASK (0x00100000u)
#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_84_CLR_SHIFT (0x00000014u)
#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_84_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_85_CLR_MASK (0x00200000u)
#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_85_CLR_SHIFT (0x00000015u)
#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_85_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_86_CLR_MASK (0x00400000u)
#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_86_CLR_SHIFT (0x00000016u)
#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_86_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_87_CLR_MASK (0x00800000u)
#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_87_CLR_SHIFT (0x00000017u)
#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_87_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_88_CLR_MASK (0x01000000u)
#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_88_CLR_SHIFT (0x00000018u)
#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_88_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_89_CLR_MASK (0x02000000u)
#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_89_CLR_SHIFT (0x00000019u)
#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_89_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_90_CLR_MASK (0x04000000u)
#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_90_CLR_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_90_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_91_CLR_MASK (0x08000000u)
#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_91_CLR_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_91_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_92_CLR_MASK (0x10000000u)
#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_92_CLR_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_92_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_93_CLR_MASK (0x20000000u)
#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_93_CLR_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_93_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_94_CLR_MASK (0x40000000u)
#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_94_CLR_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_94_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_95_CLR_MASK (0x80000000u)
#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_95_CLR_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENABLE_CLR_REG2_ENABLE_95_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG2_RESETVAL (0x00000000u)

/* enable_clr_reg3 */

#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_96_CLR_MASK (0x00000001u)
#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_96_CLR_SHIFT (0x00000000u)
#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_96_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_97_CLR_MASK (0x00000002u)
#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_97_CLR_SHIFT (0x00000001u)
#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_97_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_98_CLR_MASK (0x00000004u)
#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_98_CLR_SHIFT (0x00000002u)
#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_98_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_99_CLR_MASK (0x00000008u)
#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_99_CLR_SHIFT (0x00000003u)
#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_99_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_100_CLR_MASK (0x00000010u)
#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_100_CLR_SHIFT (0x00000004u)
#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_100_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_101_CLR_MASK (0x00000020u)
#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_101_CLR_SHIFT (0x00000005u)
#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_101_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_102_CLR_MASK (0x00000040u)
#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_102_CLR_SHIFT (0x00000006u)
#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_102_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_103_CLR_MASK (0x00000080u)
#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_103_CLR_SHIFT (0x00000007u)
#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_103_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_104_CLR_MASK (0x00000100u)
#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_104_CLR_SHIFT (0x00000008u)
#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_104_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_105_CLR_MASK (0x00000200u)
#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_105_CLR_SHIFT (0x00000009u)
#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_105_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_106_CLR_MASK (0x00000400u)
#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_106_CLR_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_106_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_107_CLR_MASK (0x00000800u)
#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_107_CLR_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_107_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_108_CLR_MASK (0x00001000u)
#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_108_CLR_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_108_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_109_CLR_MASK (0x00002000u)
#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_109_CLR_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_109_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_110_CLR_MASK (0x00004000u)
#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_110_CLR_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_110_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_111_CLR_MASK (0x00008000u)
#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_111_CLR_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_111_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_112_CLR_MASK (0x00010000u)
#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_112_CLR_SHIFT (0x00000010u)
#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_112_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_113_CLR_MASK (0x00020000u)
#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_113_CLR_SHIFT (0x00000011u)
#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_113_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_114_CLR_MASK (0x00040000u)
#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_114_CLR_SHIFT (0x00000012u)
#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_114_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_115_CLR_MASK (0x00080000u)
#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_115_CLR_SHIFT (0x00000013u)
#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_115_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_116_CLR_MASK (0x00100000u)
#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_116_CLR_SHIFT (0x00000014u)
#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_116_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_117_CLR_MASK (0x00200000u)
#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_117_CLR_SHIFT (0x00000015u)
#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_117_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_118_CLR_MASK (0x00400000u)
#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_118_CLR_SHIFT (0x00000016u)
#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_118_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_119_CLR_MASK (0x00800000u)
#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_119_CLR_SHIFT (0x00000017u)
#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_119_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_120_CLR_MASK (0x01000000u)
#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_120_CLR_SHIFT (0x00000018u)
#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_120_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_121_CLR_MASK (0x02000000u)
#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_121_CLR_SHIFT (0x00000019u)
#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_121_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_122_CLR_MASK (0x04000000u)
#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_122_CLR_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_122_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_123_CLR_MASK (0x08000000u)
#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_123_CLR_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_123_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_124_CLR_MASK (0x10000000u)
#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_124_CLR_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_124_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_125_CLR_MASK (0x20000000u)
#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_125_CLR_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_125_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_126_CLR_MASK (0x40000000u)
#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_126_CLR_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_126_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_127_CLR_MASK (0x80000000u)
#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_127_CLR_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENABLE_CLR_REG3_ENABLE_127_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG3_RESETVAL (0x00000000u)

/* enable_clr_reg4 */

#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_128_CLR_MASK (0x00000001u)
#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_128_CLR_SHIFT (0x00000000u)
#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_128_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_129_CLR_MASK (0x00000002u)
#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_129_CLR_SHIFT (0x00000001u)
#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_129_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_130_CLR_MASK (0x00000004u)
#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_130_CLR_SHIFT (0x00000002u)
#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_130_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_131_CLR_MASK (0x00000008u)
#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_131_CLR_SHIFT (0x00000003u)
#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_131_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_132_CLR_MASK (0x00000010u)
#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_132_CLR_SHIFT (0x00000004u)
#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_132_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_133_CLR_MASK (0x00000020u)
#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_133_CLR_SHIFT (0x00000005u)
#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_133_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_134_CLR_MASK (0x00000040u)
#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_134_CLR_SHIFT (0x00000006u)
#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_134_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_135_CLR_MASK (0x00000080u)
#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_135_CLR_SHIFT (0x00000007u)
#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_135_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_136_CLR_MASK (0x00000100u)
#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_136_CLR_SHIFT (0x00000008u)
#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_136_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_137_CLR_MASK (0x00000200u)
#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_137_CLR_SHIFT (0x00000009u)
#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_137_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_138_CLR_MASK (0x00000400u)
#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_138_CLR_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_138_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_139_CLR_MASK (0x00000800u)
#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_139_CLR_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_139_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_140_CLR_MASK (0x00001000u)
#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_140_CLR_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_140_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_141_CLR_MASK (0x00002000u)
#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_141_CLR_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_141_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_142_CLR_MASK (0x00004000u)
#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_142_CLR_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_142_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_143_CLR_MASK (0x00008000u)
#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_143_CLR_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_143_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_144_CLR_MASK (0x00010000u)
#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_144_CLR_SHIFT (0x00000010u)
#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_144_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_145_CLR_MASK (0x00020000u)
#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_145_CLR_SHIFT (0x00000011u)
#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_145_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_146_CLR_MASK (0x00040000u)
#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_146_CLR_SHIFT (0x00000012u)
#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_146_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_147_CLR_MASK (0x00080000u)
#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_147_CLR_SHIFT (0x00000013u)
#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_147_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_148_CLR_MASK (0x00100000u)
#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_148_CLR_SHIFT (0x00000014u)
#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_148_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_149_CLR_MASK (0x00200000u)
#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_149_CLR_SHIFT (0x00000015u)
#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_149_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_150_CLR_MASK (0x00400000u)
#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_150_CLR_SHIFT (0x00000016u)
#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_150_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_151_CLR_MASK (0x00800000u)
#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_151_CLR_SHIFT (0x00000017u)
#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_151_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_152_CLR_MASK (0x01000000u)
#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_152_CLR_SHIFT (0x00000018u)
#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_152_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_153_CLR_MASK (0x02000000u)
#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_153_CLR_SHIFT (0x00000019u)
#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_153_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_154_CLR_MASK (0x04000000u)
#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_154_CLR_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_154_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_155_CLR_MASK (0x08000000u)
#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_155_CLR_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_155_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_156_CLR_MASK (0x10000000u)
#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_156_CLR_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_156_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_157_CLR_MASK (0x20000000u)
#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_157_CLR_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_157_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_158_CLR_MASK (0x40000000u)
#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_158_CLR_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_158_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_159_CLR_MASK (0x80000000u)
#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_159_CLR_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENABLE_CLR_REG4_ENABLE_159_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG4_RESETVAL (0x00000000u)

/* enable_clr_reg5 */

#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_160_CLR_MASK (0x00000001u)
#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_160_CLR_SHIFT (0x00000000u)
#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_160_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_161_CLR_MASK (0x00000002u)
#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_161_CLR_SHIFT (0x00000001u)
#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_161_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_162_CLR_MASK (0x00000004u)
#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_162_CLR_SHIFT (0x00000002u)
#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_162_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_163_CLR_MASK (0x00000008u)
#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_163_CLR_SHIFT (0x00000003u)
#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_163_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_164_CLR_MASK (0x00000010u)
#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_164_CLR_SHIFT (0x00000004u)
#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_164_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_165_CLR_MASK (0x00000020u)
#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_165_CLR_SHIFT (0x00000005u)
#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_165_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_166_CLR_MASK (0x00000040u)
#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_166_CLR_SHIFT (0x00000006u)
#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_166_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_167_CLR_MASK (0x00000080u)
#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_167_CLR_SHIFT (0x00000007u)
#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_167_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_168_CLR_MASK (0x00000100u)
#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_168_CLR_SHIFT (0x00000008u)
#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_168_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_169_CLR_MASK (0x00000200u)
#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_169_CLR_SHIFT (0x00000009u)
#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_169_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_170_CLR_MASK (0x00000400u)
#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_170_CLR_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_170_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_171_CLR_MASK (0x00000800u)
#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_171_CLR_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_171_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_172_CLR_MASK (0x00001000u)
#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_172_CLR_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_172_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_173_CLR_MASK (0x00002000u)
#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_173_CLR_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_173_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_174_CLR_MASK (0x00004000u)
#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_174_CLR_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_174_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_175_CLR_MASK (0x00008000u)
#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_175_CLR_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_175_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_176_CLR_MASK (0x00010000u)
#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_176_CLR_SHIFT (0x00000010u)
#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_176_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_177_CLR_MASK (0x00020000u)
#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_177_CLR_SHIFT (0x00000011u)
#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_177_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_178_CLR_MASK (0x00040000u)
#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_178_CLR_SHIFT (0x00000012u)
#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_178_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_179_CLR_MASK (0x00080000u)
#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_179_CLR_SHIFT (0x00000013u)
#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_179_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_180_CLR_MASK (0x00100000u)
#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_180_CLR_SHIFT (0x00000014u)
#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_180_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_181_CLR_MASK (0x00200000u)
#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_181_CLR_SHIFT (0x00000015u)
#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_181_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_182_CLR_MASK (0x00400000u)
#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_182_CLR_SHIFT (0x00000016u)
#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_182_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_183_CLR_MASK (0x00800000u)
#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_183_CLR_SHIFT (0x00000017u)
#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_183_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_184_CLR_MASK (0x01000000u)
#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_184_CLR_SHIFT (0x00000018u)
#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_184_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_185_CLR_MASK (0x02000000u)
#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_185_CLR_SHIFT (0x00000019u)
#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_185_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_186_CLR_MASK (0x04000000u)
#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_186_CLR_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_186_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_187_CLR_MASK (0x08000000u)
#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_187_CLR_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_187_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_188_CLR_MASK (0x10000000u)
#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_188_CLR_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_188_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_189_CLR_MASK (0x20000000u)
#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_189_CLR_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_189_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_190_CLR_MASK (0x40000000u)
#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_190_CLR_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_190_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_191_CLR_MASK (0x80000000u)
#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_191_CLR_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENABLE_CLR_REG5_ENABLE_191_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG5_RESETVAL (0x00000000u)

/* enable_clr_reg6 */

#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_192_CLR_MASK (0x00000001u)
#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_192_CLR_SHIFT (0x00000000u)
#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_192_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_193_CLR_MASK (0x00000002u)
#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_193_CLR_SHIFT (0x00000001u)
#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_193_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_194_CLR_MASK (0x00000004u)
#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_194_CLR_SHIFT (0x00000002u)
#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_194_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_195_CLR_MASK (0x00000008u)
#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_195_CLR_SHIFT (0x00000003u)
#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_195_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_196_CLR_MASK (0x00000010u)
#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_196_CLR_SHIFT (0x00000004u)
#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_196_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_197_CLR_MASK (0x00000020u)
#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_197_CLR_SHIFT (0x00000005u)
#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_197_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_198_CLR_MASK (0x00000040u)
#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_198_CLR_SHIFT (0x00000006u)
#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_198_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_199_CLR_MASK (0x00000080u)
#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_199_CLR_SHIFT (0x00000007u)
#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_199_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_200_CLR_MASK (0x00000100u)
#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_200_CLR_SHIFT (0x00000008u)
#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_200_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_201_CLR_MASK (0x00000200u)
#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_201_CLR_SHIFT (0x00000009u)
#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_201_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_202_CLR_MASK (0x00000400u)
#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_202_CLR_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_202_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_203_CLR_MASK (0x00000800u)
#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_203_CLR_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_203_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_204_CLR_MASK (0x00001000u)
#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_204_CLR_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_204_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_205_CLR_MASK (0x00002000u)
#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_205_CLR_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_205_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_206_CLR_MASK (0x00004000u)
#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_206_CLR_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_206_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_207_CLR_MASK (0x00008000u)
#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_207_CLR_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_207_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_208_CLR_MASK (0x00010000u)
#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_208_CLR_SHIFT (0x00000010u)
#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_208_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_209_CLR_MASK (0x00020000u)
#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_209_CLR_SHIFT (0x00000011u)
#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_209_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_210_CLR_MASK (0x00040000u)
#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_210_CLR_SHIFT (0x00000012u)
#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_210_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_211_CLR_MASK (0x00080000u)
#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_211_CLR_SHIFT (0x00000013u)
#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_211_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_212_CLR_MASK (0x00100000u)
#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_212_CLR_SHIFT (0x00000014u)
#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_212_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_213_CLR_MASK (0x00200000u)
#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_213_CLR_SHIFT (0x00000015u)
#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_213_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_214_CLR_MASK (0x00400000u)
#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_214_CLR_SHIFT (0x00000016u)
#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_214_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_215_CLR_MASK (0x00800000u)
#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_215_CLR_SHIFT (0x00000017u)
#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_215_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_216_CLR_MASK (0x01000000u)
#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_216_CLR_SHIFT (0x00000018u)
#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_216_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_217_CLR_MASK (0x02000000u)
#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_217_CLR_SHIFT (0x00000019u)
#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_217_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_218_CLR_MASK (0x04000000u)
#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_218_CLR_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_218_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_219_CLR_MASK (0x08000000u)
#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_219_CLR_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_219_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_220_CLR_MASK (0x10000000u)
#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_220_CLR_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_220_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_221_CLR_MASK (0x20000000u)
#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_221_CLR_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_221_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_222_CLR_MASK (0x40000000u)
#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_222_CLR_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_222_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_223_CLR_MASK (0x80000000u)
#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_223_CLR_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENABLE_CLR_REG6_ENABLE_223_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG6_RESETVAL (0x00000000u)

/* enable_clr_reg7 */

#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_224_CLR_MASK (0x00000001u)
#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_224_CLR_SHIFT (0x00000000u)
#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_224_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_225_CLR_MASK (0x00000002u)
#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_225_CLR_SHIFT (0x00000001u)
#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_225_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_226_CLR_MASK (0x00000004u)
#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_226_CLR_SHIFT (0x00000002u)
#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_226_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_227_CLR_MASK (0x00000008u)
#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_227_CLR_SHIFT (0x00000003u)
#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_227_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_228_CLR_MASK (0x00000010u)
#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_228_CLR_SHIFT (0x00000004u)
#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_228_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_229_CLR_MASK (0x00000020u)
#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_229_CLR_SHIFT (0x00000005u)
#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_229_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_230_CLR_MASK (0x00000040u)
#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_230_CLR_SHIFT (0x00000006u)
#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_230_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_231_CLR_MASK (0x00000080u)
#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_231_CLR_SHIFT (0x00000007u)
#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_231_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_232_CLR_MASK (0x00000100u)
#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_232_CLR_SHIFT (0x00000008u)
#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_232_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_233_CLR_MASK (0x00000200u)
#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_233_CLR_SHIFT (0x00000009u)
#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_233_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_234_CLR_MASK (0x00000400u)
#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_234_CLR_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_234_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_235_CLR_MASK (0x00000800u)
#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_235_CLR_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_235_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_236_CLR_MASK (0x00001000u)
#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_236_CLR_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_236_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_237_CLR_MASK (0x00002000u)
#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_237_CLR_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_237_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_238_CLR_MASK (0x00004000u)
#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_238_CLR_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_238_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_239_CLR_MASK (0x00008000u)
#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_239_CLR_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_239_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_240_CLR_MASK (0x00010000u)
#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_240_CLR_SHIFT (0x00000010u)
#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_240_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_241_CLR_MASK (0x00020000u)
#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_241_CLR_SHIFT (0x00000011u)
#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_241_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_242_CLR_MASK (0x00040000u)
#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_242_CLR_SHIFT (0x00000012u)
#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_242_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_243_CLR_MASK (0x00080000u)
#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_243_CLR_SHIFT (0x00000013u)
#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_243_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_244_CLR_MASK (0x00100000u)
#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_244_CLR_SHIFT (0x00000014u)
#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_244_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_245_CLR_MASK (0x00200000u)
#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_245_CLR_SHIFT (0x00000015u)
#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_245_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_246_CLR_MASK (0x00400000u)
#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_246_CLR_SHIFT (0x00000016u)
#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_246_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_247_CLR_MASK (0x00800000u)
#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_247_CLR_SHIFT (0x00000017u)
#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_247_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_248_CLR_MASK (0x01000000u)
#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_248_CLR_SHIFT (0x00000018u)
#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_248_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_249_CLR_MASK (0x02000000u)
#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_249_CLR_SHIFT (0x00000019u)
#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_249_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_250_CLR_MASK (0x04000000u)
#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_250_CLR_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_250_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_251_CLR_MASK (0x08000000u)
#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_251_CLR_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_251_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_252_CLR_MASK (0x10000000u)
#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_252_CLR_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_252_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_253_CLR_MASK (0x20000000u)
#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_253_CLR_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_253_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_254_CLR_MASK (0x40000000u)
#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_254_CLR_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_254_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_255_CLR_MASK (0x80000000u)
#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_255_CLR_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENABLE_CLR_REG7_ENABLE_255_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG7_RESETVAL (0x00000000u)

/* enable_clr_reg8 */

#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_256_CLR_MASK (0x00000001u)
#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_256_CLR_SHIFT (0x00000000u)
#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_256_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_257_CLR_MASK (0x00000002u)
#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_257_CLR_SHIFT (0x00000001u)
#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_257_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_258_CLR_MASK (0x00000004u)
#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_258_CLR_SHIFT (0x00000002u)
#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_258_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_259_CLR_MASK (0x00000008u)
#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_259_CLR_SHIFT (0x00000003u)
#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_259_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_260_CLR_MASK (0x00000010u)
#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_260_CLR_SHIFT (0x00000004u)
#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_260_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_261_CLR_MASK (0x00000020u)
#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_261_CLR_SHIFT (0x00000005u)
#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_261_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_262_CLR_MASK (0x00000040u)
#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_262_CLR_SHIFT (0x00000006u)
#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_262_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_263_CLR_MASK (0x00000080u)
#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_263_CLR_SHIFT (0x00000007u)
#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_263_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_264_CLR_MASK (0x00000100u)
#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_264_CLR_SHIFT (0x00000008u)
#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_264_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_265_CLR_MASK (0x00000200u)
#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_265_CLR_SHIFT (0x00000009u)
#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_265_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_266_CLR_MASK (0x00000400u)
#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_266_CLR_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_266_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_267_CLR_MASK (0x00000800u)
#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_267_CLR_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_267_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_268_CLR_MASK (0x00001000u)
#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_268_CLR_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_268_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_269_CLR_MASK (0x00002000u)
#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_269_CLR_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_269_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_270_CLR_MASK (0x00004000u)
#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_270_CLR_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_270_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_271_CLR_MASK (0x00008000u)
#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_271_CLR_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_271_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_272_CLR_MASK (0x00010000u)
#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_272_CLR_SHIFT (0x00000010u)
#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_272_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_273_CLR_MASK (0x00020000u)
#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_273_CLR_SHIFT (0x00000011u)
#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_273_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_274_CLR_MASK (0x00040000u)
#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_274_CLR_SHIFT (0x00000012u)
#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_274_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_275_CLR_MASK (0x00080000u)
#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_275_CLR_SHIFT (0x00000013u)
#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_275_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_276_CLR_MASK (0x00100000u)
#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_276_CLR_SHIFT (0x00000014u)
#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_276_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_277_CLR_MASK (0x00200000u)
#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_277_CLR_SHIFT (0x00000015u)
#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_277_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_278_CLR_MASK (0x00400000u)
#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_278_CLR_SHIFT (0x00000016u)
#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_278_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_279_CLR_MASK (0x00800000u)
#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_279_CLR_SHIFT (0x00000017u)
#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_279_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_280_CLR_MASK (0x01000000u)
#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_280_CLR_SHIFT (0x00000018u)
#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_280_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_281_CLR_MASK (0x02000000u)
#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_281_CLR_SHIFT (0x00000019u)
#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_281_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_282_CLR_MASK (0x04000000u)
#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_282_CLR_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_282_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_283_CLR_MASK (0x08000000u)
#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_283_CLR_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_283_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_284_CLR_MASK (0x10000000u)
#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_284_CLR_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_284_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_285_CLR_MASK (0x20000000u)
#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_285_CLR_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_285_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_286_CLR_MASK (0x40000000u)
#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_286_CLR_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_286_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_287_CLR_MASK (0x80000000u)
#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_287_CLR_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENABLE_CLR_REG8_ENABLE_287_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG8_RESETVAL (0x00000000u)

/* enable_clr_reg9 */

#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_288_CLR_MASK (0x00000001u)
#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_288_CLR_SHIFT (0x00000000u)
#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_288_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_289_CLR_MASK (0x00000002u)
#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_289_CLR_SHIFT (0x00000001u)
#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_289_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_290_CLR_MASK (0x00000004u)
#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_290_CLR_SHIFT (0x00000002u)
#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_290_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_291_CLR_MASK (0x00000008u)
#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_291_CLR_SHIFT (0x00000003u)
#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_291_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_292_CLR_MASK (0x00000010u)
#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_292_CLR_SHIFT (0x00000004u)
#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_292_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_293_CLR_MASK (0x00000020u)
#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_293_CLR_SHIFT (0x00000005u)
#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_293_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_294_CLR_MASK (0x00000040u)
#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_294_CLR_SHIFT (0x00000006u)
#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_294_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_295_CLR_MASK (0x00000080u)
#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_295_CLR_SHIFT (0x00000007u)
#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_295_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_296_CLR_MASK (0x00000100u)
#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_296_CLR_SHIFT (0x00000008u)
#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_296_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_297_CLR_MASK (0x00000200u)
#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_297_CLR_SHIFT (0x00000009u)
#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_297_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_298_CLR_MASK (0x00000400u)
#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_298_CLR_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_298_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_299_CLR_MASK (0x00000800u)
#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_299_CLR_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_299_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_300_CLR_MASK (0x00001000u)
#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_300_CLR_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_300_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_301_CLR_MASK (0x00002000u)
#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_301_CLR_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_301_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_302_CLR_MASK (0x00004000u)
#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_302_CLR_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_302_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_303_CLR_MASK (0x00008000u)
#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_303_CLR_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_303_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_304_CLR_MASK (0x00010000u)
#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_304_CLR_SHIFT (0x00000010u)
#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_304_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_305_CLR_MASK (0x00020000u)
#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_305_CLR_SHIFT (0x00000011u)
#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_305_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_306_CLR_MASK (0x00040000u)
#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_306_CLR_SHIFT (0x00000012u)
#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_306_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_307_CLR_MASK (0x00080000u)
#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_307_CLR_SHIFT (0x00000013u)
#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_307_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_308_CLR_MASK (0x00100000u)
#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_308_CLR_SHIFT (0x00000014u)
#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_308_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_309_CLR_MASK (0x00200000u)
#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_309_CLR_SHIFT (0x00000015u)
#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_309_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_310_CLR_MASK (0x00400000u)
#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_310_CLR_SHIFT (0x00000016u)
#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_310_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_311_CLR_MASK (0x00800000u)
#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_311_CLR_SHIFT (0x00000017u)
#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_311_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_312_CLR_MASK (0x01000000u)
#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_312_CLR_SHIFT (0x00000018u)
#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_312_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_313_CLR_MASK (0x02000000u)
#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_313_CLR_SHIFT (0x00000019u)
#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_313_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_314_CLR_MASK (0x04000000u)
#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_314_CLR_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_314_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_315_CLR_MASK (0x08000000u)
#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_315_CLR_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_315_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_316_CLR_MASK (0x10000000u)
#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_316_CLR_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_316_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_317_CLR_MASK (0x20000000u)
#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_317_CLR_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_317_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_318_CLR_MASK (0x40000000u)
#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_318_CLR_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_318_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_319_CLR_MASK (0x80000000u)
#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_319_CLR_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENABLE_CLR_REG9_ENABLE_319_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG9_RESETVAL (0x00000000u)

/* enable_clr_reg10 */

#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_320_CLR_MASK (0x00000001u)
#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_320_CLR_SHIFT (0x00000000u)
#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_320_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_321_CLR_MASK (0x00000002u)
#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_321_CLR_SHIFT (0x00000001u)
#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_321_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_322_CLR_MASK (0x00000004u)
#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_322_CLR_SHIFT (0x00000002u)
#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_322_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_323_CLR_MASK (0x00000008u)
#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_323_CLR_SHIFT (0x00000003u)
#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_323_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_324_CLR_MASK (0x00000010u)
#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_324_CLR_SHIFT (0x00000004u)
#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_324_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_325_CLR_MASK (0x00000020u)
#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_325_CLR_SHIFT (0x00000005u)
#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_325_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_326_CLR_MASK (0x00000040u)
#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_326_CLR_SHIFT (0x00000006u)
#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_326_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_327_CLR_MASK (0x00000080u)
#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_327_CLR_SHIFT (0x00000007u)
#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_327_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_328_CLR_MASK (0x00000100u)
#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_328_CLR_SHIFT (0x00000008u)
#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_328_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_329_CLR_MASK (0x00000200u)
#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_329_CLR_SHIFT (0x00000009u)
#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_329_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_330_CLR_MASK (0x00000400u)
#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_330_CLR_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_330_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_331_CLR_MASK (0x00000800u)
#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_331_CLR_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_331_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_332_CLR_MASK (0x00001000u)
#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_332_CLR_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_332_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_333_CLR_MASK (0x00002000u)
#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_333_CLR_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_333_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_334_CLR_MASK (0x00004000u)
#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_334_CLR_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_334_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_335_CLR_MASK (0x00008000u)
#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_335_CLR_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_335_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_336_CLR_MASK (0x00010000u)
#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_336_CLR_SHIFT (0x00000010u)
#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_336_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_337_CLR_MASK (0x00020000u)
#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_337_CLR_SHIFT (0x00000011u)
#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_337_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_338_CLR_MASK (0x00040000u)
#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_338_CLR_SHIFT (0x00000012u)
#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_338_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_339_CLR_MASK (0x00080000u)
#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_339_CLR_SHIFT (0x00000013u)
#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_339_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_340_CLR_MASK (0x00100000u)
#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_340_CLR_SHIFT (0x00000014u)
#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_340_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_341_CLR_MASK (0x00200000u)
#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_341_CLR_SHIFT (0x00000015u)
#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_341_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_342_CLR_MASK (0x00400000u)
#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_342_CLR_SHIFT (0x00000016u)
#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_342_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_343_CLR_MASK (0x00800000u)
#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_343_CLR_SHIFT (0x00000017u)
#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_343_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_344_CLR_MASK (0x01000000u)
#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_344_CLR_SHIFT (0x00000018u)
#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_344_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_345_CLR_MASK (0x02000000u)
#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_345_CLR_SHIFT (0x00000019u)
#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_345_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_346_CLR_MASK (0x04000000u)
#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_346_CLR_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_346_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_347_CLR_MASK (0x08000000u)
#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_347_CLR_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_347_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_348_CLR_MASK (0x10000000u)
#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_348_CLR_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_348_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_349_CLR_MASK (0x20000000u)
#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_349_CLR_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_349_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_350_CLR_MASK (0x40000000u)
#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_350_CLR_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_350_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_351_CLR_MASK (0x80000000u)
#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_351_CLR_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENABLE_CLR_REG10_ENABLE_351_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG10_RESETVAL (0x00000000u)

/* enable_clr_reg11 */

#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_352_CLR_MASK (0x00000001u)
#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_352_CLR_SHIFT (0x00000000u)
#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_352_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_353_CLR_MASK (0x00000002u)
#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_353_CLR_SHIFT (0x00000001u)
#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_353_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_354_CLR_MASK (0x00000004u)
#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_354_CLR_SHIFT (0x00000002u)
#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_354_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_355_CLR_MASK (0x00000008u)
#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_355_CLR_SHIFT (0x00000003u)
#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_355_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_356_CLR_MASK (0x00000010u)
#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_356_CLR_SHIFT (0x00000004u)
#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_356_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_357_CLR_MASK (0x00000020u)
#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_357_CLR_SHIFT (0x00000005u)
#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_357_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_358_CLR_MASK (0x00000040u)
#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_358_CLR_SHIFT (0x00000006u)
#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_358_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_359_CLR_MASK (0x00000080u)
#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_359_CLR_SHIFT (0x00000007u)
#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_359_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_360_CLR_MASK (0x00000100u)
#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_360_CLR_SHIFT (0x00000008u)
#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_360_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_361_CLR_MASK (0x00000200u)
#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_361_CLR_SHIFT (0x00000009u)
#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_361_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_362_CLR_MASK (0x00000400u)
#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_362_CLR_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_362_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_363_CLR_MASK (0x00000800u)
#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_363_CLR_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_363_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_364_CLR_MASK (0x00001000u)
#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_364_CLR_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_364_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_365_CLR_MASK (0x00002000u)
#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_365_CLR_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_365_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_366_CLR_MASK (0x00004000u)
#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_366_CLR_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_366_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_367_CLR_MASK (0x00008000u)
#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_367_CLR_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_367_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_368_CLR_MASK (0x00010000u)
#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_368_CLR_SHIFT (0x00000010u)
#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_368_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_369_CLR_MASK (0x00020000u)
#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_369_CLR_SHIFT (0x00000011u)
#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_369_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_370_CLR_MASK (0x00040000u)
#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_370_CLR_SHIFT (0x00000012u)
#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_370_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_371_CLR_MASK (0x00080000u)
#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_371_CLR_SHIFT (0x00000013u)
#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_371_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_372_CLR_MASK (0x00100000u)
#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_372_CLR_SHIFT (0x00000014u)
#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_372_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_373_CLR_MASK (0x00200000u)
#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_373_CLR_SHIFT (0x00000015u)
#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_373_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_374_CLR_MASK (0x00400000u)
#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_374_CLR_SHIFT (0x00000016u)
#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_374_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_375_CLR_MASK (0x00800000u)
#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_375_CLR_SHIFT (0x00000017u)
#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_375_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_376_CLR_MASK (0x01000000u)
#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_376_CLR_SHIFT (0x00000018u)
#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_376_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_377_CLR_MASK (0x02000000u)
#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_377_CLR_SHIFT (0x00000019u)
#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_377_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_378_CLR_MASK (0x04000000u)
#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_378_CLR_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_378_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_379_CLR_MASK (0x08000000u)
#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_379_CLR_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_379_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_380_CLR_MASK (0x10000000u)
#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_380_CLR_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_380_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_381_CLR_MASK (0x20000000u)
#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_381_CLR_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_381_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_382_CLR_MASK (0x40000000u)
#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_382_CLR_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_382_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_383_CLR_MASK (0x80000000u)
#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_383_CLR_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENABLE_CLR_REG11_ENABLE_383_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG11_RESETVAL (0x00000000u)

/* enable_clr_reg12 */

#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_384_CLR_MASK (0x00000001u)
#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_384_CLR_SHIFT (0x00000000u)
#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_384_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_385_CLR_MASK (0x00000002u)
#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_385_CLR_SHIFT (0x00000001u)
#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_385_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_386_CLR_MASK (0x00000004u)
#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_386_CLR_SHIFT (0x00000002u)
#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_386_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_387_CLR_MASK (0x00000008u)
#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_387_CLR_SHIFT (0x00000003u)
#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_387_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_388_CLR_MASK (0x00000010u)
#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_388_CLR_SHIFT (0x00000004u)
#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_388_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_389_CLR_MASK (0x00000020u)
#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_389_CLR_SHIFT (0x00000005u)
#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_389_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_390_CLR_MASK (0x00000040u)
#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_390_CLR_SHIFT (0x00000006u)
#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_390_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_391_CLR_MASK (0x00000080u)
#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_391_CLR_SHIFT (0x00000007u)
#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_391_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_392_CLR_MASK (0x00000100u)
#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_392_CLR_SHIFT (0x00000008u)
#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_392_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_393_CLR_MASK (0x00000200u)
#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_393_CLR_SHIFT (0x00000009u)
#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_393_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_394_CLR_MASK (0x00000400u)
#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_394_CLR_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_394_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_395_CLR_MASK (0x00000800u)
#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_395_CLR_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_395_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_396_CLR_MASK (0x00001000u)
#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_396_CLR_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_396_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_397_CLR_MASK (0x00002000u)
#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_397_CLR_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_397_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_398_CLR_MASK (0x00004000u)
#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_398_CLR_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_398_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_399_CLR_MASK (0x00008000u)
#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_399_CLR_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_399_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_400_CLR_MASK (0x00010000u)
#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_400_CLR_SHIFT (0x00000010u)
#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_400_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_401_CLR_MASK (0x00020000u)
#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_401_CLR_SHIFT (0x00000011u)
#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_401_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_402_CLR_MASK (0x00040000u)
#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_402_CLR_SHIFT (0x00000012u)
#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_402_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_403_CLR_MASK (0x00080000u)
#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_403_CLR_SHIFT (0x00000013u)
#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_403_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_404_CLR_MASK (0x00100000u)
#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_404_CLR_SHIFT (0x00000014u)
#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_404_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_405_CLR_MASK (0x00200000u)
#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_405_CLR_SHIFT (0x00000015u)
#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_405_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_406_CLR_MASK (0x00400000u)
#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_406_CLR_SHIFT (0x00000016u)
#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_406_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_407_CLR_MASK (0x00800000u)
#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_407_CLR_SHIFT (0x00000017u)
#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_407_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_408_CLR_MASK (0x01000000u)
#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_408_CLR_SHIFT (0x00000018u)
#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_408_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_409_CLR_MASK (0x02000000u)
#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_409_CLR_SHIFT (0x00000019u)
#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_409_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_410_CLR_MASK (0x04000000u)
#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_410_CLR_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_410_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_411_CLR_MASK (0x08000000u)
#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_411_CLR_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_411_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_412_CLR_MASK (0x10000000u)
#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_412_CLR_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_412_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_413_CLR_MASK (0x20000000u)
#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_413_CLR_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_413_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_414_CLR_MASK (0x40000000u)
#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_414_CLR_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_414_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_415_CLR_MASK (0x80000000u)
#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_415_CLR_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENABLE_CLR_REG12_ENABLE_415_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG12_RESETVAL (0x00000000u)

/* enable_clr_reg13 */

#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_416_CLR_MASK (0x00000001u)
#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_416_CLR_SHIFT (0x00000000u)
#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_416_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_417_CLR_MASK (0x00000002u)
#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_417_CLR_SHIFT (0x00000001u)
#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_417_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_418_CLR_MASK (0x00000004u)
#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_418_CLR_SHIFT (0x00000002u)
#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_418_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_419_CLR_MASK (0x00000008u)
#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_419_CLR_SHIFT (0x00000003u)
#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_419_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_420_CLR_MASK (0x00000010u)
#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_420_CLR_SHIFT (0x00000004u)
#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_420_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_421_CLR_MASK (0x00000020u)
#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_421_CLR_SHIFT (0x00000005u)
#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_421_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_422_CLR_MASK (0x00000040u)
#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_422_CLR_SHIFT (0x00000006u)
#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_422_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_423_CLR_MASK (0x00000080u)
#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_423_CLR_SHIFT (0x00000007u)
#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_423_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_424_CLR_MASK (0x00000100u)
#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_424_CLR_SHIFT (0x00000008u)
#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_424_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_425_CLR_MASK (0x00000200u)
#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_425_CLR_SHIFT (0x00000009u)
#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_425_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_426_CLR_MASK (0x00000400u)
#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_426_CLR_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_426_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_427_CLR_MASK (0x00000800u)
#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_427_CLR_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_427_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_428_CLR_MASK (0x00001000u)
#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_428_CLR_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_428_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_429_CLR_MASK (0x00002000u)
#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_429_CLR_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_429_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_430_CLR_MASK (0x00004000u)
#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_430_CLR_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_430_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_431_CLR_MASK (0x00008000u)
#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_431_CLR_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_431_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_432_CLR_MASK (0x00010000u)
#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_432_CLR_SHIFT (0x00000010u)
#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_432_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_433_CLR_MASK (0x00020000u)
#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_433_CLR_SHIFT (0x00000011u)
#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_433_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_434_CLR_MASK (0x00040000u)
#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_434_CLR_SHIFT (0x00000012u)
#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_434_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_435_CLR_MASK (0x00080000u)
#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_435_CLR_SHIFT (0x00000013u)
#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_435_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_436_CLR_MASK (0x00100000u)
#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_436_CLR_SHIFT (0x00000014u)
#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_436_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_437_CLR_MASK (0x00200000u)
#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_437_CLR_SHIFT (0x00000015u)
#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_437_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_438_CLR_MASK (0x00400000u)
#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_438_CLR_SHIFT (0x00000016u)
#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_438_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_439_CLR_MASK (0x00800000u)
#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_439_CLR_SHIFT (0x00000017u)
#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_439_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_440_CLR_MASK (0x01000000u)
#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_440_CLR_SHIFT (0x00000018u)
#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_440_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_441_CLR_MASK (0x02000000u)
#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_441_CLR_SHIFT (0x00000019u)
#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_441_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_442_CLR_MASK (0x04000000u)
#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_442_CLR_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_442_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_443_CLR_MASK (0x08000000u)
#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_443_CLR_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_443_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_444_CLR_MASK (0x10000000u)
#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_444_CLR_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_444_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_445_CLR_MASK (0x20000000u)
#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_445_CLR_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_445_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_446_CLR_MASK (0x40000000u)
#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_446_CLR_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_446_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_447_CLR_MASK (0x80000000u)
#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_447_CLR_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENABLE_CLR_REG13_ENABLE_447_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG13_RESETVAL (0x00000000u)

/* enable_clr_reg14 */

#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_448_CLR_MASK (0x00000001u)
#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_448_CLR_SHIFT (0x00000000u)
#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_448_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_449_CLR_MASK (0x00000002u)
#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_449_CLR_SHIFT (0x00000001u)
#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_449_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_450_CLR_MASK (0x00000004u)
#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_450_CLR_SHIFT (0x00000002u)
#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_450_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_451_CLR_MASK (0x00000008u)
#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_451_CLR_SHIFT (0x00000003u)
#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_451_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_452_CLR_MASK (0x00000010u)
#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_452_CLR_SHIFT (0x00000004u)
#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_452_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_453_CLR_MASK (0x00000020u)
#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_453_CLR_SHIFT (0x00000005u)
#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_453_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_454_CLR_MASK (0x00000040u)
#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_454_CLR_SHIFT (0x00000006u)
#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_454_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_455_CLR_MASK (0x00000080u)
#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_455_CLR_SHIFT (0x00000007u)
#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_455_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_456_CLR_MASK (0x00000100u)
#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_456_CLR_SHIFT (0x00000008u)
#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_456_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_457_CLR_MASK (0x00000200u)
#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_457_CLR_SHIFT (0x00000009u)
#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_457_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_458_CLR_MASK (0x00000400u)
#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_458_CLR_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_458_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_459_CLR_MASK (0x00000800u)
#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_459_CLR_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_459_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_460_CLR_MASK (0x00001000u)
#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_460_CLR_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_460_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_461_CLR_MASK (0x00002000u)
#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_461_CLR_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_461_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_462_CLR_MASK (0x00004000u)
#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_462_CLR_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_462_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_463_CLR_MASK (0x00008000u)
#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_463_CLR_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_463_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_464_CLR_MASK (0x00010000u)
#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_464_CLR_SHIFT (0x00000010u)
#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_464_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_465_CLR_MASK (0x00020000u)
#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_465_CLR_SHIFT (0x00000011u)
#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_465_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_466_CLR_MASK (0x00040000u)
#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_466_CLR_SHIFT (0x00000012u)
#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_466_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_467_CLR_MASK (0x00080000u)
#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_467_CLR_SHIFT (0x00000013u)
#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_467_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_468_CLR_MASK (0x00100000u)
#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_468_CLR_SHIFT (0x00000014u)
#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_468_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_469_CLR_MASK (0x00200000u)
#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_469_CLR_SHIFT (0x00000015u)
#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_469_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_470_CLR_MASK (0x00400000u)
#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_470_CLR_SHIFT (0x00000016u)
#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_470_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_471_CLR_MASK (0x00800000u)
#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_471_CLR_SHIFT (0x00000017u)
#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_471_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_472_CLR_MASK (0x01000000u)
#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_472_CLR_SHIFT (0x00000018u)
#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_472_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_473_CLR_MASK (0x02000000u)
#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_473_CLR_SHIFT (0x00000019u)
#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_473_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_474_CLR_MASK (0x04000000u)
#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_474_CLR_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_474_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_475_CLR_MASK (0x08000000u)
#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_475_CLR_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_475_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_476_CLR_MASK (0x10000000u)
#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_476_CLR_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_476_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_477_CLR_MASK (0x20000000u)
#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_477_CLR_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_477_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_478_CLR_MASK (0x40000000u)
#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_478_CLR_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_478_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_479_CLR_MASK (0x80000000u)
#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_479_CLR_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENABLE_CLR_REG14_ENABLE_479_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG14_RESETVAL (0x00000000u)

/* enable_clr_reg15 */

#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_480_CLR_MASK (0x00000001u)
#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_480_CLR_SHIFT (0x00000000u)
#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_480_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_481_CLR_MASK (0x00000002u)
#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_481_CLR_SHIFT (0x00000001u)
#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_481_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_482_CLR_MASK (0x00000004u)
#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_482_CLR_SHIFT (0x00000002u)
#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_482_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_483_CLR_MASK (0x00000008u)
#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_483_CLR_SHIFT (0x00000003u)
#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_483_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_484_CLR_MASK (0x00000010u)
#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_484_CLR_SHIFT (0x00000004u)
#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_484_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_485_CLR_MASK (0x00000020u)
#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_485_CLR_SHIFT (0x00000005u)
#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_485_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_486_CLR_MASK (0x00000040u)
#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_486_CLR_SHIFT (0x00000006u)
#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_486_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_487_CLR_MASK (0x00000080u)
#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_487_CLR_SHIFT (0x00000007u)
#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_487_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_488_CLR_MASK (0x00000100u)
#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_488_CLR_SHIFT (0x00000008u)
#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_488_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_489_CLR_MASK (0x00000200u)
#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_489_CLR_SHIFT (0x00000009u)
#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_489_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_490_CLR_MASK (0x00000400u)
#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_490_CLR_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_490_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_491_CLR_MASK (0x00000800u)
#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_491_CLR_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_491_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_492_CLR_MASK (0x00001000u)
#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_492_CLR_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_492_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_493_CLR_MASK (0x00002000u)
#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_493_CLR_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_493_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_494_CLR_MASK (0x00004000u)
#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_494_CLR_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_494_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_495_CLR_MASK (0x00008000u)
#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_495_CLR_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_495_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_496_CLR_MASK (0x00010000u)
#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_496_CLR_SHIFT (0x00000010u)
#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_496_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_497_CLR_MASK (0x00020000u)
#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_497_CLR_SHIFT (0x00000011u)
#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_497_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_498_CLR_MASK (0x00040000u)
#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_498_CLR_SHIFT (0x00000012u)
#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_498_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_499_CLR_MASK (0x00080000u)
#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_499_CLR_SHIFT (0x00000013u)
#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_499_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_500_CLR_MASK (0x00100000u)
#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_500_CLR_SHIFT (0x00000014u)
#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_500_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_501_CLR_MASK (0x00200000u)
#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_501_CLR_SHIFT (0x00000015u)
#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_501_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_502_CLR_MASK (0x00400000u)
#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_502_CLR_SHIFT (0x00000016u)
#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_502_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_503_CLR_MASK (0x00800000u)
#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_503_CLR_SHIFT (0x00000017u)
#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_503_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_504_CLR_MASK (0x01000000u)
#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_504_CLR_SHIFT (0x00000018u)
#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_504_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_505_CLR_MASK (0x02000000u)
#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_505_CLR_SHIFT (0x00000019u)
#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_505_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_506_CLR_MASK (0x04000000u)
#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_506_CLR_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_506_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_507_CLR_MASK (0x08000000u)
#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_507_CLR_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_507_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_508_CLR_MASK (0x10000000u)
#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_508_CLR_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_508_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_509_CLR_MASK (0x20000000u)
#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_509_CLR_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_509_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_510_CLR_MASK (0x40000000u)
#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_510_CLR_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_510_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_511_CLR_MASK (0x80000000u)
#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_511_CLR_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENABLE_CLR_REG15_ENABLE_511_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG15_RESETVAL (0x00000000u)

/* enable_clr_reg16 */

#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_512_CLR_MASK (0x00000001u)
#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_512_CLR_SHIFT (0x00000000u)
#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_512_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_513_CLR_MASK (0x00000002u)
#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_513_CLR_SHIFT (0x00000001u)
#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_513_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_514_CLR_MASK (0x00000004u)
#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_514_CLR_SHIFT (0x00000002u)
#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_514_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_515_CLR_MASK (0x00000008u)
#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_515_CLR_SHIFT (0x00000003u)
#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_515_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_516_CLR_MASK (0x00000010u)
#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_516_CLR_SHIFT (0x00000004u)
#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_516_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_517_CLR_MASK (0x00000020u)
#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_517_CLR_SHIFT (0x00000005u)
#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_517_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_518_CLR_MASK (0x00000040u)
#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_518_CLR_SHIFT (0x00000006u)
#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_518_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_519_CLR_MASK (0x00000080u)
#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_519_CLR_SHIFT (0x00000007u)
#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_519_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_520_CLR_MASK (0x00000100u)
#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_520_CLR_SHIFT (0x00000008u)
#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_520_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_521_CLR_MASK (0x00000200u)
#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_521_CLR_SHIFT (0x00000009u)
#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_521_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_522_CLR_MASK (0x00000400u)
#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_522_CLR_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_522_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_523_CLR_MASK (0x00000800u)
#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_523_CLR_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_523_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_524_CLR_MASK (0x00001000u)
#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_524_CLR_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_524_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_525_CLR_MASK (0x00002000u)
#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_525_CLR_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_525_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_526_CLR_MASK (0x00004000u)
#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_526_CLR_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_526_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_527_CLR_MASK (0x00008000u)
#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_527_CLR_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_527_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_528_CLR_MASK (0x00010000u)
#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_528_CLR_SHIFT (0x00000010u)
#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_528_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_529_CLR_MASK (0x00020000u)
#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_529_CLR_SHIFT (0x00000011u)
#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_529_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_530_CLR_MASK (0x00040000u)
#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_530_CLR_SHIFT (0x00000012u)
#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_530_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_531_CLR_MASK (0x00080000u)
#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_531_CLR_SHIFT (0x00000013u)
#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_531_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_532_CLR_MASK (0x00100000u)
#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_532_CLR_SHIFT (0x00000014u)
#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_532_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_533_CLR_MASK (0x00200000u)
#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_533_CLR_SHIFT (0x00000015u)
#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_533_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_534_CLR_MASK (0x00400000u)
#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_534_CLR_SHIFT (0x00000016u)
#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_534_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_535_CLR_MASK (0x00800000u)
#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_535_CLR_SHIFT (0x00000017u)
#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_535_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_536_CLR_MASK (0x01000000u)
#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_536_CLR_SHIFT (0x00000018u)
#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_536_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_537_CLR_MASK (0x02000000u)
#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_537_CLR_SHIFT (0x00000019u)
#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_537_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_538_CLR_MASK (0x04000000u)
#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_538_CLR_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_538_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_539_CLR_MASK (0x08000000u)
#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_539_CLR_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_539_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_540_CLR_MASK (0x10000000u)
#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_540_CLR_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_540_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_541_CLR_MASK (0x20000000u)
#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_541_CLR_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_541_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_542_CLR_MASK (0x40000000u)
#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_542_CLR_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_542_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_543_CLR_MASK (0x80000000u)
#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_543_CLR_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENABLE_CLR_REG16_ENABLE_543_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG16_RESETVAL (0x00000000u)

/* enable_clr_reg17 */

#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_544_CLR_MASK (0x00000001u)
#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_544_CLR_SHIFT (0x00000000u)
#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_544_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_545_CLR_MASK (0x00000002u)
#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_545_CLR_SHIFT (0x00000001u)
#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_545_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_546_CLR_MASK (0x00000004u)
#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_546_CLR_SHIFT (0x00000002u)
#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_546_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_547_CLR_MASK (0x00000008u)
#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_547_CLR_SHIFT (0x00000003u)
#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_547_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_548_CLR_MASK (0x00000010u)
#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_548_CLR_SHIFT (0x00000004u)
#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_548_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_549_CLR_MASK (0x00000020u)
#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_549_CLR_SHIFT (0x00000005u)
#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_549_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_550_CLR_MASK (0x00000040u)
#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_550_CLR_SHIFT (0x00000006u)
#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_550_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_551_CLR_MASK (0x00000080u)
#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_551_CLR_SHIFT (0x00000007u)
#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_551_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_552_CLR_MASK (0x00000100u)
#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_552_CLR_SHIFT (0x00000008u)
#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_552_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_553_CLR_MASK (0x00000200u)
#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_553_CLR_SHIFT (0x00000009u)
#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_553_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_554_CLR_MASK (0x00000400u)
#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_554_CLR_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_554_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_555_CLR_MASK (0x00000800u)
#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_555_CLR_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_555_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_556_CLR_MASK (0x00001000u)
#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_556_CLR_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_556_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_557_CLR_MASK (0x00002000u)
#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_557_CLR_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_557_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_558_CLR_MASK (0x00004000u)
#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_558_CLR_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_558_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_559_CLR_MASK (0x00008000u)
#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_559_CLR_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_559_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_560_CLR_MASK (0x00010000u)
#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_560_CLR_SHIFT (0x00000010u)
#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_560_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_561_CLR_MASK (0x00020000u)
#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_561_CLR_SHIFT (0x00000011u)
#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_561_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_562_CLR_MASK (0x00040000u)
#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_562_CLR_SHIFT (0x00000012u)
#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_562_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_563_CLR_MASK (0x00080000u)
#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_563_CLR_SHIFT (0x00000013u)
#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_563_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_564_CLR_MASK (0x00100000u)
#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_564_CLR_SHIFT (0x00000014u)
#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_564_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_565_CLR_MASK (0x00200000u)
#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_565_CLR_SHIFT (0x00000015u)
#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_565_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_566_CLR_MASK (0x00400000u)
#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_566_CLR_SHIFT (0x00000016u)
#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_566_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_567_CLR_MASK (0x00800000u)
#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_567_CLR_SHIFT (0x00000017u)
#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_567_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_568_CLR_MASK (0x01000000u)
#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_568_CLR_SHIFT (0x00000018u)
#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_568_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_569_CLR_MASK (0x02000000u)
#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_569_CLR_SHIFT (0x00000019u)
#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_569_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_570_CLR_MASK (0x04000000u)
#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_570_CLR_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_570_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_571_CLR_MASK (0x08000000u)
#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_571_CLR_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_571_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_572_CLR_MASK (0x10000000u)
#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_572_CLR_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_572_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_573_CLR_MASK (0x20000000u)
#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_573_CLR_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_573_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_574_CLR_MASK (0x40000000u)
#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_574_CLR_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_574_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_575_CLR_MASK (0x80000000u)
#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_575_CLR_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENABLE_CLR_REG17_ENABLE_575_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG17_RESETVAL (0x00000000u)

/* enable_clr_reg18 */

#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_576_CLR_MASK (0x00000001u)
#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_576_CLR_SHIFT (0x00000000u)
#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_576_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_577_CLR_MASK (0x00000002u)
#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_577_CLR_SHIFT (0x00000001u)
#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_577_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_578_CLR_MASK (0x00000004u)
#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_578_CLR_SHIFT (0x00000002u)
#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_578_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_579_CLR_MASK (0x00000008u)
#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_579_CLR_SHIFT (0x00000003u)
#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_579_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_580_CLR_MASK (0x00000010u)
#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_580_CLR_SHIFT (0x00000004u)
#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_580_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_581_CLR_MASK (0x00000020u)
#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_581_CLR_SHIFT (0x00000005u)
#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_581_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_582_CLR_MASK (0x00000040u)
#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_582_CLR_SHIFT (0x00000006u)
#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_582_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_583_CLR_MASK (0x00000080u)
#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_583_CLR_SHIFT (0x00000007u)
#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_583_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_584_CLR_MASK (0x00000100u)
#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_584_CLR_SHIFT (0x00000008u)
#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_584_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_585_CLR_MASK (0x00000200u)
#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_585_CLR_SHIFT (0x00000009u)
#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_585_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_586_CLR_MASK (0x00000400u)
#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_586_CLR_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_586_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_587_CLR_MASK (0x00000800u)
#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_587_CLR_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_587_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_588_CLR_MASK (0x00001000u)
#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_588_CLR_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_588_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_589_CLR_MASK (0x00002000u)
#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_589_CLR_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_589_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_590_CLR_MASK (0x00004000u)
#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_590_CLR_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_590_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_591_CLR_MASK (0x00008000u)
#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_591_CLR_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_591_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_592_CLR_MASK (0x00010000u)
#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_592_CLR_SHIFT (0x00000010u)
#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_592_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_593_CLR_MASK (0x00020000u)
#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_593_CLR_SHIFT (0x00000011u)
#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_593_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_594_CLR_MASK (0x00040000u)
#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_594_CLR_SHIFT (0x00000012u)
#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_594_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_595_CLR_MASK (0x00080000u)
#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_595_CLR_SHIFT (0x00000013u)
#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_595_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_596_CLR_MASK (0x00100000u)
#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_596_CLR_SHIFT (0x00000014u)
#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_596_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_597_CLR_MASK (0x00200000u)
#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_597_CLR_SHIFT (0x00000015u)
#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_597_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_598_CLR_MASK (0x00400000u)
#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_598_CLR_SHIFT (0x00000016u)
#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_598_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_599_CLR_MASK (0x00800000u)
#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_599_CLR_SHIFT (0x00000017u)
#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_599_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_600_CLR_MASK (0x01000000u)
#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_600_CLR_SHIFT (0x00000018u)
#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_600_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_601_CLR_MASK (0x02000000u)
#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_601_CLR_SHIFT (0x00000019u)
#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_601_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_602_CLR_MASK (0x04000000u)
#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_602_CLR_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_602_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_603_CLR_MASK (0x08000000u)
#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_603_CLR_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_603_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_604_CLR_MASK (0x10000000u)
#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_604_CLR_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_604_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_605_CLR_MASK (0x20000000u)
#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_605_CLR_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_605_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_606_CLR_MASK (0x40000000u)
#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_606_CLR_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_606_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_607_CLR_MASK (0x80000000u)
#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_607_CLR_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENABLE_CLR_REG18_ENABLE_607_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG18_RESETVAL (0x00000000u)

/* enable_clr_reg19 */

#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_608_CLR_MASK (0x00000001u)
#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_608_CLR_SHIFT (0x00000000u)
#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_608_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_609_CLR_MASK (0x00000002u)
#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_609_CLR_SHIFT (0x00000001u)
#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_609_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_610_CLR_MASK (0x00000004u)
#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_610_CLR_SHIFT (0x00000002u)
#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_610_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_611_CLR_MASK (0x00000008u)
#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_611_CLR_SHIFT (0x00000003u)
#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_611_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_612_CLR_MASK (0x00000010u)
#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_612_CLR_SHIFT (0x00000004u)
#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_612_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_613_CLR_MASK (0x00000020u)
#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_613_CLR_SHIFT (0x00000005u)
#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_613_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_614_CLR_MASK (0x00000040u)
#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_614_CLR_SHIFT (0x00000006u)
#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_614_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_615_CLR_MASK (0x00000080u)
#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_615_CLR_SHIFT (0x00000007u)
#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_615_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_616_CLR_MASK (0x00000100u)
#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_616_CLR_SHIFT (0x00000008u)
#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_616_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_617_CLR_MASK (0x00000200u)
#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_617_CLR_SHIFT (0x00000009u)
#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_617_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_618_CLR_MASK (0x00000400u)
#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_618_CLR_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_618_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_619_CLR_MASK (0x00000800u)
#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_619_CLR_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_619_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_620_CLR_MASK (0x00001000u)
#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_620_CLR_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_620_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_621_CLR_MASK (0x00002000u)
#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_621_CLR_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_621_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_622_CLR_MASK (0x00004000u)
#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_622_CLR_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_622_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_623_CLR_MASK (0x00008000u)
#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_623_CLR_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_623_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_624_CLR_MASK (0x00010000u)
#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_624_CLR_SHIFT (0x00000010u)
#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_624_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_625_CLR_MASK (0x00020000u)
#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_625_CLR_SHIFT (0x00000011u)
#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_625_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_626_CLR_MASK (0x00040000u)
#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_626_CLR_SHIFT (0x00000012u)
#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_626_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_627_CLR_MASK (0x00080000u)
#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_627_CLR_SHIFT (0x00000013u)
#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_627_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_628_CLR_MASK (0x00100000u)
#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_628_CLR_SHIFT (0x00000014u)
#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_628_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_629_CLR_MASK (0x00200000u)
#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_629_CLR_SHIFT (0x00000015u)
#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_629_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_630_CLR_MASK (0x00400000u)
#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_630_CLR_SHIFT (0x00000016u)
#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_630_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_631_CLR_MASK (0x00800000u)
#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_631_CLR_SHIFT (0x00000017u)
#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_631_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_632_CLR_MASK (0x01000000u)
#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_632_CLR_SHIFT (0x00000018u)
#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_632_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_633_CLR_MASK (0x02000000u)
#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_633_CLR_SHIFT (0x00000019u)
#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_633_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_634_CLR_MASK (0x04000000u)
#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_634_CLR_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_634_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_635_CLR_MASK (0x08000000u)
#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_635_CLR_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_635_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_636_CLR_MASK (0x10000000u)
#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_636_CLR_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_636_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_637_CLR_MASK (0x20000000u)
#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_637_CLR_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_637_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_638_CLR_MASK (0x40000000u)
#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_638_CLR_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_638_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_639_CLR_MASK (0x80000000u)
#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_639_CLR_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENABLE_CLR_REG19_ENABLE_639_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG19_RESETVAL (0x00000000u)

/* enable_clr_reg20 */

#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_640_CLR_MASK (0x00000001u)
#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_640_CLR_SHIFT (0x00000000u)
#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_640_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_641_CLR_MASK (0x00000002u)
#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_641_CLR_SHIFT (0x00000001u)
#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_641_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_642_CLR_MASK (0x00000004u)
#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_642_CLR_SHIFT (0x00000002u)
#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_642_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_643_CLR_MASK (0x00000008u)
#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_643_CLR_SHIFT (0x00000003u)
#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_643_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_644_CLR_MASK (0x00000010u)
#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_644_CLR_SHIFT (0x00000004u)
#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_644_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_645_CLR_MASK (0x00000020u)
#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_645_CLR_SHIFT (0x00000005u)
#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_645_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_646_CLR_MASK (0x00000040u)
#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_646_CLR_SHIFT (0x00000006u)
#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_646_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_647_CLR_MASK (0x00000080u)
#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_647_CLR_SHIFT (0x00000007u)
#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_647_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_648_CLR_MASK (0x00000100u)
#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_648_CLR_SHIFT (0x00000008u)
#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_648_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_649_CLR_MASK (0x00000200u)
#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_649_CLR_SHIFT (0x00000009u)
#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_649_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_650_CLR_MASK (0x00000400u)
#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_650_CLR_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_650_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_651_CLR_MASK (0x00000800u)
#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_651_CLR_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_651_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_652_CLR_MASK (0x00001000u)
#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_652_CLR_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_652_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_653_CLR_MASK (0x00002000u)
#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_653_CLR_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_653_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_654_CLR_MASK (0x00004000u)
#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_654_CLR_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_654_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_655_CLR_MASK (0x00008000u)
#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_655_CLR_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_655_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_656_CLR_MASK (0x00010000u)
#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_656_CLR_SHIFT (0x00000010u)
#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_656_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_657_CLR_MASK (0x00020000u)
#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_657_CLR_SHIFT (0x00000011u)
#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_657_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_658_CLR_MASK (0x00040000u)
#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_658_CLR_SHIFT (0x00000012u)
#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_658_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_659_CLR_MASK (0x00080000u)
#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_659_CLR_SHIFT (0x00000013u)
#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_659_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_660_CLR_MASK (0x00100000u)
#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_660_CLR_SHIFT (0x00000014u)
#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_660_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_661_CLR_MASK (0x00200000u)
#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_661_CLR_SHIFT (0x00000015u)
#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_661_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_662_CLR_MASK (0x00400000u)
#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_662_CLR_SHIFT (0x00000016u)
#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_662_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_663_CLR_MASK (0x00800000u)
#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_663_CLR_SHIFT (0x00000017u)
#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_663_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_664_CLR_MASK (0x01000000u)
#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_664_CLR_SHIFT (0x00000018u)
#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_664_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_665_CLR_MASK (0x02000000u)
#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_665_CLR_SHIFT (0x00000019u)
#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_665_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_666_CLR_MASK (0x04000000u)
#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_666_CLR_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_666_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_667_CLR_MASK (0x08000000u)
#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_667_CLR_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_667_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_668_CLR_MASK (0x10000000u)
#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_668_CLR_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_668_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_669_CLR_MASK (0x20000000u)
#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_669_CLR_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_669_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_670_CLR_MASK (0x40000000u)
#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_670_CLR_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_670_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_671_CLR_MASK (0x80000000u)
#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_671_CLR_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENABLE_CLR_REG20_ENABLE_671_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG20_RESETVAL (0x00000000u)

/* enable_clr_reg21 */

#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_672_CLR_MASK (0x00000001u)
#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_672_CLR_SHIFT (0x00000000u)
#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_672_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_673_CLR_MASK (0x00000002u)
#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_673_CLR_SHIFT (0x00000001u)
#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_673_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_674_CLR_MASK (0x00000004u)
#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_674_CLR_SHIFT (0x00000002u)
#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_674_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_675_CLR_MASK (0x00000008u)
#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_675_CLR_SHIFT (0x00000003u)
#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_675_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_676_CLR_MASK (0x00000010u)
#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_676_CLR_SHIFT (0x00000004u)
#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_676_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_677_CLR_MASK (0x00000020u)
#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_677_CLR_SHIFT (0x00000005u)
#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_677_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_678_CLR_MASK (0x00000040u)
#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_678_CLR_SHIFT (0x00000006u)
#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_678_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_679_CLR_MASK (0x00000080u)
#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_679_CLR_SHIFT (0x00000007u)
#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_679_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_680_CLR_MASK (0x00000100u)
#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_680_CLR_SHIFT (0x00000008u)
#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_680_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_681_CLR_MASK (0x00000200u)
#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_681_CLR_SHIFT (0x00000009u)
#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_681_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_682_CLR_MASK (0x00000400u)
#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_682_CLR_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_682_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_683_CLR_MASK (0x00000800u)
#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_683_CLR_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_683_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_684_CLR_MASK (0x00001000u)
#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_684_CLR_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_684_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_685_CLR_MASK (0x00002000u)
#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_685_CLR_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_685_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_686_CLR_MASK (0x00004000u)
#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_686_CLR_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_686_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_687_CLR_MASK (0x00008000u)
#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_687_CLR_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_687_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_688_CLR_MASK (0x00010000u)
#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_688_CLR_SHIFT (0x00000010u)
#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_688_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_689_CLR_MASK (0x00020000u)
#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_689_CLR_SHIFT (0x00000011u)
#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_689_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_690_CLR_MASK (0x00040000u)
#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_690_CLR_SHIFT (0x00000012u)
#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_690_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_691_CLR_MASK (0x00080000u)
#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_691_CLR_SHIFT (0x00000013u)
#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_691_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_692_CLR_MASK (0x00100000u)
#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_692_CLR_SHIFT (0x00000014u)
#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_692_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_693_CLR_MASK (0x00200000u)
#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_693_CLR_SHIFT (0x00000015u)
#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_693_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_694_CLR_MASK (0x00400000u)
#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_694_CLR_SHIFT (0x00000016u)
#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_694_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_695_CLR_MASK (0x00800000u)
#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_695_CLR_SHIFT (0x00000017u)
#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_695_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_696_CLR_MASK (0x01000000u)
#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_696_CLR_SHIFT (0x00000018u)
#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_696_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_697_CLR_MASK (0x02000000u)
#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_697_CLR_SHIFT (0x00000019u)
#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_697_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_698_CLR_MASK (0x04000000u)
#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_698_CLR_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_698_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_699_CLR_MASK (0x08000000u)
#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_699_CLR_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_699_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_700_CLR_MASK (0x10000000u)
#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_700_CLR_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_700_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_701_CLR_MASK (0x20000000u)
#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_701_CLR_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_701_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_702_CLR_MASK (0x40000000u)
#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_702_CLR_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_702_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_703_CLR_MASK (0x80000000u)
#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_703_CLR_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENABLE_CLR_REG21_ENABLE_703_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG21_RESETVAL (0x00000000u)

/* enable_clr_reg22 */

#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_704_CLR_MASK (0x00000001u)
#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_704_CLR_SHIFT (0x00000000u)
#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_704_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_705_CLR_MASK (0x00000002u)
#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_705_CLR_SHIFT (0x00000001u)
#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_705_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_706_CLR_MASK (0x00000004u)
#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_706_CLR_SHIFT (0x00000002u)
#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_706_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_707_CLR_MASK (0x00000008u)
#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_707_CLR_SHIFT (0x00000003u)
#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_707_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_708_CLR_MASK (0x00000010u)
#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_708_CLR_SHIFT (0x00000004u)
#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_708_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_709_CLR_MASK (0x00000020u)
#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_709_CLR_SHIFT (0x00000005u)
#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_709_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_710_CLR_MASK (0x00000040u)
#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_710_CLR_SHIFT (0x00000006u)
#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_710_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_711_CLR_MASK (0x00000080u)
#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_711_CLR_SHIFT (0x00000007u)
#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_711_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_712_CLR_MASK (0x00000100u)
#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_712_CLR_SHIFT (0x00000008u)
#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_712_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_713_CLR_MASK (0x00000200u)
#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_713_CLR_SHIFT (0x00000009u)
#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_713_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_714_CLR_MASK (0x00000400u)
#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_714_CLR_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_714_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_715_CLR_MASK (0x00000800u)
#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_715_CLR_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_715_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_716_CLR_MASK (0x00001000u)
#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_716_CLR_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_716_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_717_CLR_MASK (0x00002000u)
#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_717_CLR_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_717_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_718_CLR_MASK (0x00004000u)
#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_718_CLR_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_718_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_719_CLR_MASK (0x00008000u)
#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_719_CLR_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_719_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_720_CLR_MASK (0x00010000u)
#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_720_CLR_SHIFT (0x00000010u)
#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_720_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_721_CLR_MASK (0x00020000u)
#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_721_CLR_SHIFT (0x00000011u)
#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_721_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_722_CLR_MASK (0x00040000u)
#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_722_CLR_SHIFT (0x00000012u)
#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_722_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_723_CLR_MASK (0x00080000u)
#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_723_CLR_SHIFT (0x00000013u)
#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_723_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_724_CLR_MASK (0x00100000u)
#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_724_CLR_SHIFT (0x00000014u)
#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_724_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_725_CLR_MASK (0x00200000u)
#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_725_CLR_SHIFT (0x00000015u)
#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_725_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_726_CLR_MASK (0x00400000u)
#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_726_CLR_SHIFT (0x00000016u)
#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_726_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_727_CLR_MASK (0x00800000u)
#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_727_CLR_SHIFT (0x00000017u)
#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_727_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_728_CLR_MASK (0x01000000u)
#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_728_CLR_SHIFT (0x00000018u)
#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_728_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_729_CLR_MASK (0x02000000u)
#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_729_CLR_SHIFT (0x00000019u)
#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_729_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_730_CLR_MASK (0x04000000u)
#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_730_CLR_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_730_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_731_CLR_MASK (0x08000000u)
#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_731_CLR_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_731_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_732_CLR_MASK (0x10000000u)
#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_732_CLR_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_732_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_733_CLR_MASK (0x20000000u)
#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_733_CLR_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_733_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_734_CLR_MASK (0x40000000u)
#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_734_CLR_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_734_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_735_CLR_MASK (0x80000000u)
#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_735_CLR_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENABLE_CLR_REG22_ENABLE_735_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG22_RESETVAL (0x00000000u)

/* enable_clr_reg23 */

#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_736_CLR_MASK (0x00000001u)
#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_736_CLR_SHIFT (0x00000000u)
#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_736_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_737_CLR_MASK (0x00000002u)
#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_737_CLR_SHIFT (0x00000001u)
#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_737_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_738_CLR_MASK (0x00000004u)
#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_738_CLR_SHIFT (0x00000002u)
#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_738_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_739_CLR_MASK (0x00000008u)
#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_739_CLR_SHIFT (0x00000003u)
#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_739_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_740_CLR_MASK (0x00000010u)
#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_740_CLR_SHIFT (0x00000004u)
#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_740_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_741_CLR_MASK (0x00000020u)
#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_741_CLR_SHIFT (0x00000005u)
#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_741_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_742_CLR_MASK (0x00000040u)
#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_742_CLR_SHIFT (0x00000006u)
#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_742_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_743_CLR_MASK (0x00000080u)
#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_743_CLR_SHIFT (0x00000007u)
#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_743_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_744_CLR_MASK (0x00000100u)
#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_744_CLR_SHIFT (0x00000008u)
#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_744_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_745_CLR_MASK (0x00000200u)
#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_745_CLR_SHIFT (0x00000009u)
#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_745_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_746_CLR_MASK (0x00000400u)
#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_746_CLR_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_746_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_747_CLR_MASK (0x00000800u)
#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_747_CLR_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_747_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_748_CLR_MASK (0x00001000u)
#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_748_CLR_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_748_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_749_CLR_MASK (0x00002000u)
#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_749_CLR_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_749_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_750_CLR_MASK (0x00004000u)
#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_750_CLR_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_750_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_751_CLR_MASK (0x00008000u)
#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_751_CLR_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_751_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_752_CLR_MASK (0x00010000u)
#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_752_CLR_SHIFT (0x00000010u)
#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_752_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_753_CLR_MASK (0x00020000u)
#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_753_CLR_SHIFT (0x00000011u)
#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_753_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_754_CLR_MASK (0x00040000u)
#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_754_CLR_SHIFT (0x00000012u)
#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_754_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_755_CLR_MASK (0x00080000u)
#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_755_CLR_SHIFT (0x00000013u)
#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_755_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_756_CLR_MASK (0x00100000u)
#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_756_CLR_SHIFT (0x00000014u)
#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_756_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_757_CLR_MASK (0x00200000u)
#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_757_CLR_SHIFT (0x00000015u)
#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_757_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_758_CLR_MASK (0x00400000u)
#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_758_CLR_SHIFT (0x00000016u)
#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_758_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_759_CLR_MASK (0x00800000u)
#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_759_CLR_SHIFT (0x00000017u)
#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_759_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_760_CLR_MASK (0x01000000u)
#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_760_CLR_SHIFT (0x00000018u)
#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_760_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_761_CLR_MASK (0x02000000u)
#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_761_CLR_SHIFT (0x00000019u)
#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_761_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_762_CLR_MASK (0x04000000u)
#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_762_CLR_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_762_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_763_CLR_MASK (0x08000000u)
#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_763_CLR_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_763_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_764_CLR_MASK (0x10000000u)
#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_764_CLR_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_764_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_765_CLR_MASK (0x20000000u)
#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_765_CLR_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_765_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_766_CLR_MASK (0x40000000u)
#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_766_CLR_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_766_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_767_CLR_MASK (0x80000000u)
#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_767_CLR_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENABLE_CLR_REG23_ENABLE_767_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG23_RESETVAL (0x00000000u)

/* enable_clr_reg24 */

#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_768_CLR_MASK (0x00000001u)
#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_768_CLR_SHIFT (0x00000000u)
#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_768_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_769_CLR_MASK (0x00000002u)
#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_769_CLR_SHIFT (0x00000001u)
#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_769_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_770_CLR_MASK (0x00000004u)
#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_770_CLR_SHIFT (0x00000002u)
#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_770_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_771_CLR_MASK (0x00000008u)
#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_771_CLR_SHIFT (0x00000003u)
#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_771_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_772_CLR_MASK (0x00000010u)
#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_772_CLR_SHIFT (0x00000004u)
#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_772_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_773_CLR_MASK (0x00000020u)
#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_773_CLR_SHIFT (0x00000005u)
#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_773_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_774_CLR_MASK (0x00000040u)
#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_774_CLR_SHIFT (0x00000006u)
#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_774_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_775_CLR_MASK (0x00000080u)
#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_775_CLR_SHIFT (0x00000007u)
#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_775_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_776_CLR_MASK (0x00000100u)
#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_776_CLR_SHIFT (0x00000008u)
#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_776_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_777_CLR_MASK (0x00000200u)
#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_777_CLR_SHIFT (0x00000009u)
#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_777_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_778_CLR_MASK (0x00000400u)
#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_778_CLR_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_778_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_779_CLR_MASK (0x00000800u)
#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_779_CLR_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_779_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_780_CLR_MASK (0x00001000u)
#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_780_CLR_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_780_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_781_CLR_MASK (0x00002000u)
#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_781_CLR_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_781_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_782_CLR_MASK (0x00004000u)
#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_782_CLR_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_782_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_783_CLR_MASK (0x00008000u)
#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_783_CLR_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_783_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_784_CLR_MASK (0x00010000u)
#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_784_CLR_SHIFT (0x00000010u)
#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_784_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_785_CLR_MASK (0x00020000u)
#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_785_CLR_SHIFT (0x00000011u)
#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_785_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_786_CLR_MASK (0x00040000u)
#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_786_CLR_SHIFT (0x00000012u)
#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_786_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_787_CLR_MASK (0x00080000u)
#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_787_CLR_SHIFT (0x00000013u)
#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_787_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_788_CLR_MASK (0x00100000u)
#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_788_CLR_SHIFT (0x00000014u)
#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_788_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_789_CLR_MASK (0x00200000u)
#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_789_CLR_SHIFT (0x00000015u)
#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_789_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_790_CLR_MASK (0x00400000u)
#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_790_CLR_SHIFT (0x00000016u)
#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_790_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_791_CLR_MASK (0x00800000u)
#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_791_CLR_SHIFT (0x00000017u)
#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_791_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_792_CLR_MASK (0x01000000u)
#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_792_CLR_SHIFT (0x00000018u)
#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_792_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_793_CLR_MASK (0x02000000u)
#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_793_CLR_SHIFT (0x00000019u)
#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_793_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_794_CLR_MASK (0x04000000u)
#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_794_CLR_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_794_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_795_CLR_MASK (0x08000000u)
#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_795_CLR_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_795_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_796_CLR_MASK (0x10000000u)
#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_796_CLR_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_796_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_797_CLR_MASK (0x20000000u)
#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_797_CLR_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_797_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_798_CLR_MASK (0x40000000u)
#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_798_CLR_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_798_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_799_CLR_MASK (0x80000000u)
#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_799_CLR_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENABLE_CLR_REG24_ENABLE_799_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG24_RESETVAL (0x00000000u)

/* enable_clr_reg25 */

#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_800_CLR_MASK (0x00000001u)
#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_800_CLR_SHIFT (0x00000000u)
#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_800_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_801_CLR_MASK (0x00000002u)
#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_801_CLR_SHIFT (0x00000001u)
#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_801_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_802_CLR_MASK (0x00000004u)
#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_802_CLR_SHIFT (0x00000002u)
#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_802_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_803_CLR_MASK (0x00000008u)
#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_803_CLR_SHIFT (0x00000003u)
#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_803_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_804_CLR_MASK (0x00000010u)
#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_804_CLR_SHIFT (0x00000004u)
#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_804_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_805_CLR_MASK (0x00000020u)
#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_805_CLR_SHIFT (0x00000005u)
#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_805_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_806_CLR_MASK (0x00000040u)
#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_806_CLR_SHIFT (0x00000006u)
#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_806_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_807_CLR_MASK (0x00000080u)
#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_807_CLR_SHIFT (0x00000007u)
#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_807_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_808_CLR_MASK (0x00000100u)
#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_808_CLR_SHIFT (0x00000008u)
#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_808_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_809_CLR_MASK (0x00000200u)
#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_809_CLR_SHIFT (0x00000009u)
#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_809_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_810_CLR_MASK (0x00000400u)
#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_810_CLR_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_810_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_811_CLR_MASK (0x00000800u)
#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_811_CLR_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_811_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_812_CLR_MASK (0x00001000u)
#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_812_CLR_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_812_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_813_CLR_MASK (0x00002000u)
#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_813_CLR_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_813_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_814_CLR_MASK (0x00004000u)
#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_814_CLR_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_814_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_815_CLR_MASK (0x00008000u)
#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_815_CLR_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_815_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_816_CLR_MASK (0x00010000u)
#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_816_CLR_SHIFT (0x00000010u)
#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_816_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_817_CLR_MASK (0x00020000u)
#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_817_CLR_SHIFT (0x00000011u)
#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_817_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_818_CLR_MASK (0x00040000u)
#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_818_CLR_SHIFT (0x00000012u)
#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_818_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_819_CLR_MASK (0x00080000u)
#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_819_CLR_SHIFT (0x00000013u)
#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_819_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_820_CLR_MASK (0x00100000u)
#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_820_CLR_SHIFT (0x00000014u)
#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_820_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_821_CLR_MASK (0x00200000u)
#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_821_CLR_SHIFT (0x00000015u)
#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_821_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_822_CLR_MASK (0x00400000u)
#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_822_CLR_SHIFT (0x00000016u)
#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_822_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_823_CLR_MASK (0x00800000u)
#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_823_CLR_SHIFT (0x00000017u)
#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_823_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_824_CLR_MASK (0x01000000u)
#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_824_CLR_SHIFT (0x00000018u)
#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_824_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_825_CLR_MASK (0x02000000u)
#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_825_CLR_SHIFT (0x00000019u)
#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_825_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_826_CLR_MASK (0x04000000u)
#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_826_CLR_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_826_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_827_CLR_MASK (0x08000000u)
#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_827_CLR_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_827_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_828_CLR_MASK (0x10000000u)
#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_828_CLR_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_828_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_829_CLR_MASK (0x20000000u)
#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_829_CLR_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_829_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_830_CLR_MASK (0x40000000u)
#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_830_CLR_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_830_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_831_CLR_MASK (0x80000000u)
#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_831_CLR_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENABLE_CLR_REG25_ENABLE_831_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG25_RESETVAL (0x00000000u)

/* enable_clr_reg26 */

#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_832_CLR_MASK (0x00000001u)
#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_832_CLR_SHIFT (0x00000000u)
#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_832_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_833_CLR_MASK (0x00000002u)
#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_833_CLR_SHIFT (0x00000001u)
#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_833_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_834_CLR_MASK (0x00000004u)
#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_834_CLR_SHIFT (0x00000002u)
#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_834_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_835_CLR_MASK (0x00000008u)
#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_835_CLR_SHIFT (0x00000003u)
#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_835_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_836_CLR_MASK (0x00000010u)
#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_836_CLR_SHIFT (0x00000004u)
#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_836_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_837_CLR_MASK (0x00000020u)
#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_837_CLR_SHIFT (0x00000005u)
#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_837_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_838_CLR_MASK (0x00000040u)
#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_838_CLR_SHIFT (0x00000006u)
#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_838_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_839_CLR_MASK (0x00000080u)
#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_839_CLR_SHIFT (0x00000007u)
#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_839_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_840_CLR_MASK (0x00000100u)
#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_840_CLR_SHIFT (0x00000008u)
#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_840_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_841_CLR_MASK (0x00000200u)
#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_841_CLR_SHIFT (0x00000009u)
#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_841_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_842_CLR_MASK (0x00000400u)
#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_842_CLR_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_842_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_843_CLR_MASK (0x00000800u)
#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_843_CLR_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_843_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_844_CLR_MASK (0x00001000u)
#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_844_CLR_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_844_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_845_CLR_MASK (0x00002000u)
#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_845_CLR_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_845_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_846_CLR_MASK (0x00004000u)
#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_846_CLR_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_846_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_847_CLR_MASK (0x00008000u)
#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_847_CLR_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_847_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_848_CLR_MASK (0x00010000u)
#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_848_CLR_SHIFT (0x00000010u)
#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_848_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_849_CLR_MASK (0x00020000u)
#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_849_CLR_SHIFT (0x00000011u)
#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_849_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_850_CLR_MASK (0x00040000u)
#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_850_CLR_SHIFT (0x00000012u)
#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_850_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_851_CLR_MASK (0x00080000u)
#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_851_CLR_SHIFT (0x00000013u)
#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_851_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_852_CLR_MASK (0x00100000u)
#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_852_CLR_SHIFT (0x00000014u)
#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_852_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_853_CLR_MASK (0x00200000u)
#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_853_CLR_SHIFT (0x00000015u)
#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_853_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_854_CLR_MASK (0x00400000u)
#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_854_CLR_SHIFT (0x00000016u)
#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_854_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_855_CLR_MASK (0x00800000u)
#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_855_CLR_SHIFT (0x00000017u)
#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_855_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_856_CLR_MASK (0x01000000u)
#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_856_CLR_SHIFT (0x00000018u)
#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_856_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_857_CLR_MASK (0x02000000u)
#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_857_CLR_SHIFT (0x00000019u)
#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_857_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_858_CLR_MASK (0x04000000u)
#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_858_CLR_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_858_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_859_CLR_MASK (0x08000000u)
#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_859_CLR_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_859_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_860_CLR_MASK (0x10000000u)
#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_860_CLR_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_860_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_861_CLR_MASK (0x20000000u)
#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_861_CLR_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_861_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_862_CLR_MASK (0x40000000u)
#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_862_CLR_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_862_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_863_CLR_MASK (0x80000000u)
#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_863_CLR_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENABLE_CLR_REG26_ENABLE_863_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG26_RESETVAL (0x00000000u)

/* enable_clr_reg27 */

#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_864_CLR_MASK (0x00000001u)
#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_864_CLR_SHIFT (0x00000000u)
#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_864_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_865_CLR_MASK (0x00000002u)
#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_865_CLR_SHIFT (0x00000001u)
#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_865_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_866_CLR_MASK (0x00000004u)
#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_866_CLR_SHIFT (0x00000002u)
#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_866_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_867_CLR_MASK (0x00000008u)
#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_867_CLR_SHIFT (0x00000003u)
#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_867_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_868_CLR_MASK (0x00000010u)
#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_868_CLR_SHIFT (0x00000004u)
#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_868_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_869_CLR_MASK (0x00000020u)
#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_869_CLR_SHIFT (0x00000005u)
#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_869_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_870_CLR_MASK (0x00000040u)
#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_870_CLR_SHIFT (0x00000006u)
#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_870_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_871_CLR_MASK (0x00000080u)
#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_871_CLR_SHIFT (0x00000007u)
#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_871_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_872_CLR_MASK (0x00000100u)
#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_872_CLR_SHIFT (0x00000008u)
#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_872_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_873_CLR_MASK (0x00000200u)
#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_873_CLR_SHIFT (0x00000009u)
#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_873_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_874_CLR_MASK (0x00000400u)
#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_874_CLR_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_874_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_875_CLR_MASK (0x00000800u)
#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_875_CLR_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_875_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_876_CLR_MASK (0x00001000u)
#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_876_CLR_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_876_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_877_CLR_MASK (0x00002000u)
#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_877_CLR_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_877_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_878_CLR_MASK (0x00004000u)
#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_878_CLR_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_878_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_879_CLR_MASK (0x00008000u)
#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_879_CLR_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_879_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_880_CLR_MASK (0x00010000u)
#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_880_CLR_SHIFT (0x00000010u)
#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_880_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_881_CLR_MASK (0x00020000u)
#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_881_CLR_SHIFT (0x00000011u)
#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_881_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_882_CLR_MASK (0x00040000u)
#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_882_CLR_SHIFT (0x00000012u)
#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_882_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_883_CLR_MASK (0x00080000u)
#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_883_CLR_SHIFT (0x00000013u)
#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_883_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_884_CLR_MASK (0x00100000u)
#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_884_CLR_SHIFT (0x00000014u)
#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_884_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_885_CLR_MASK (0x00200000u)
#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_885_CLR_SHIFT (0x00000015u)
#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_885_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_886_CLR_MASK (0x00400000u)
#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_886_CLR_SHIFT (0x00000016u)
#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_886_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_887_CLR_MASK (0x00800000u)
#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_887_CLR_SHIFT (0x00000017u)
#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_887_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_888_CLR_MASK (0x01000000u)
#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_888_CLR_SHIFT (0x00000018u)
#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_888_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_889_CLR_MASK (0x02000000u)
#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_889_CLR_SHIFT (0x00000019u)
#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_889_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_890_CLR_MASK (0x04000000u)
#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_890_CLR_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_890_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_891_CLR_MASK (0x08000000u)
#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_891_CLR_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_891_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_892_CLR_MASK (0x10000000u)
#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_892_CLR_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_892_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_893_CLR_MASK (0x20000000u)
#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_893_CLR_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_893_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_894_CLR_MASK (0x40000000u)
#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_894_CLR_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_894_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_895_CLR_MASK (0x80000000u)
#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_895_CLR_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENABLE_CLR_REG27_ENABLE_895_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG27_RESETVAL (0x00000000u)

/* enable_clr_reg28 */

#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_896_CLR_MASK (0x00000001u)
#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_896_CLR_SHIFT (0x00000000u)
#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_896_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_897_CLR_MASK (0x00000002u)
#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_897_CLR_SHIFT (0x00000001u)
#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_897_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_898_CLR_MASK (0x00000004u)
#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_898_CLR_SHIFT (0x00000002u)
#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_898_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_899_CLR_MASK (0x00000008u)
#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_899_CLR_SHIFT (0x00000003u)
#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_899_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_900_CLR_MASK (0x00000010u)
#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_900_CLR_SHIFT (0x00000004u)
#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_900_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_901_CLR_MASK (0x00000020u)
#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_901_CLR_SHIFT (0x00000005u)
#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_901_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_902_CLR_MASK (0x00000040u)
#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_902_CLR_SHIFT (0x00000006u)
#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_902_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_903_CLR_MASK (0x00000080u)
#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_903_CLR_SHIFT (0x00000007u)
#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_903_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_904_CLR_MASK (0x00000100u)
#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_904_CLR_SHIFT (0x00000008u)
#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_904_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_905_CLR_MASK (0x00000200u)
#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_905_CLR_SHIFT (0x00000009u)
#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_905_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_906_CLR_MASK (0x00000400u)
#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_906_CLR_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_906_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_907_CLR_MASK (0x00000800u)
#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_907_CLR_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_907_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_908_CLR_MASK (0x00001000u)
#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_908_CLR_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_908_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_909_CLR_MASK (0x00002000u)
#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_909_CLR_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_909_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_910_CLR_MASK (0x00004000u)
#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_910_CLR_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_910_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_911_CLR_MASK (0x00008000u)
#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_911_CLR_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_911_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_912_CLR_MASK (0x00010000u)
#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_912_CLR_SHIFT (0x00000010u)
#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_912_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_913_CLR_MASK (0x00020000u)
#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_913_CLR_SHIFT (0x00000011u)
#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_913_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_914_CLR_MASK (0x00040000u)
#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_914_CLR_SHIFT (0x00000012u)
#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_914_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_915_CLR_MASK (0x00080000u)
#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_915_CLR_SHIFT (0x00000013u)
#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_915_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_916_CLR_MASK (0x00100000u)
#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_916_CLR_SHIFT (0x00000014u)
#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_916_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_917_CLR_MASK (0x00200000u)
#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_917_CLR_SHIFT (0x00000015u)
#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_917_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_918_CLR_MASK (0x00400000u)
#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_918_CLR_SHIFT (0x00000016u)
#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_918_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_919_CLR_MASK (0x00800000u)
#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_919_CLR_SHIFT (0x00000017u)
#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_919_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_920_CLR_MASK (0x01000000u)
#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_920_CLR_SHIFT (0x00000018u)
#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_920_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_921_CLR_MASK (0x02000000u)
#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_921_CLR_SHIFT (0x00000019u)
#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_921_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_922_CLR_MASK (0x04000000u)
#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_922_CLR_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_922_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_923_CLR_MASK (0x08000000u)
#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_923_CLR_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_923_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_924_CLR_MASK (0x10000000u)
#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_924_CLR_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_924_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_925_CLR_MASK (0x20000000u)
#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_925_CLR_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_925_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_926_CLR_MASK (0x40000000u)
#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_926_CLR_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_926_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_927_CLR_MASK (0x80000000u)
#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_927_CLR_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENABLE_CLR_REG28_ENABLE_927_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG28_RESETVAL (0x00000000u)

/* enable_clr_reg29 */

#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_928_CLR_MASK (0x00000001u)
#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_928_CLR_SHIFT (0x00000000u)
#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_928_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_929_CLR_MASK (0x00000002u)
#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_929_CLR_SHIFT (0x00000001u)
#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_929_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_930_CLR_MASK (0x00000004u)
#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_930_CLR_SHIFT (0x00000002u)
#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_930_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_931_CLR_MASK (0x00000008u)
#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_931_CLR_SHIFT (0x00000003u)
#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_931_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_932_CLR_MASK (0x00000010u)
#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_932_CLR_SHIFT (0x00000004u)
#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_932_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_933_CLR_MASK (0x00000020u)
#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_933_CLR_SHIFT (0x00000005u)
#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_933_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_934_CLR_MASK (0x00000040u)
#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_934_CLR_SHIFT (0x00000006u)
#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_934_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_935_CLR_MASK (0x00000080u)
#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_935_CLR_SHIFT (0x00000007u)
#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_935_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_936_CLR_MASK (0x00000100u)
#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_936_CLR_SHIFT (0x00000008u)
#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_936_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_937_CLR_MASK (0x00000200u)
#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_937_CLR_SHIFT (0x00000009u)
#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_937_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_938_CLR_MASK (0x00000400u)
#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_938_CLR_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_938_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_939_CLR_MASK (0x00000800u)
#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_939_CLR_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_939_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_940_CLR_MASK (0x00001000u)
#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_940_CLR_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_940_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_941_CLR_MASK (0x00002000u)
#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_941_CLR_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_941_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_942_CLR_MASK (0x00004000u)
#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_942_CLR_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_942_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_943_CLR_MASK (0x00008000u)
#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_943_CLR_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_943_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_944_CLR_MASK (0x00010000u)
#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_944_CLR_SHIFT (0x00000010u)
#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_944_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_945_CLR_MASK (0x00020000u)
#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_945_CLR_SHIFT (0x00000011u)
#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_945_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_946_CLR_MASK (0x00040000u)
#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_946_CLR_SHIFT (0x00000012u)
#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_946_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_947_CLR_MASK (0x00080000u)
#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_947_CLR_SHIFT (0x00000013u)
#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_947_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_948_CLR_MASK (0x00100000u)
#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_948_CLR_SHIFT (0x00000014u)
#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_948_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_949_CLR_MASK (0x00200000u)
#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_949_CLR_SHIFT (0x00000015u)
#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_949_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_950_CLR_MASK (0x00400000u)
#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_950_CLR_SHIFT (0x00000016u)
#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_950_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_951_CLR_MASK (0x00800000u)
#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_951_CLR_SHIFT (0x00000017u)
#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_951_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_952_CLR_MASK (0x01000000u)
#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_952_CLR_SHIFT (0x00000018u)
#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_952_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_953_CLR_MASK (0x02000000u)
#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_953_CLR_SHIFT (0x00000019u)
#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_953_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_954_CLR_MASK (0x04000000u)
#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_954_CLR_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_954_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_955_CLR_MASK (0x08000000u)
#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_955_CLR_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_955_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_956_CLR_MASK (0x10000000u)
#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_956_CLR_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_956_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_957_CLR_MASK (0x20000000u)
#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_957_CLR_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_957_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_958_CLR_MASK (0x40000000u)
#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_958_CLR_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_958_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_959_CLR_MASK (0x80000000u)
#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_959_CLR_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENABLE_CLR_REG29_ENABLE_959_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG29_RESETVAL (0x00000000u)

/* enable_clr_reg30 */

#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_960_CLR_MASK (0x00000001u)
#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_960_CLR_SHIFT (0x00000000u)
#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_960_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_961_CLR_MASK (0x00000002u)
#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_961_CLR_SHIFT (0x00000001u)
#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_961_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_962_CLR_MASK (0x00000004u)
#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_962_CLR_SHIFT (0x00000002u)
#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_962_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_963_CLR_MASK (0x00000008u)
#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_963_CLR_SHIFT (0x00000003u)
#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_963_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_964_CLR_MASK (0x00000010u)
#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_964_CLR_SHIFT (0x00000004u)
#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_964_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_965_CLR_MASK (0x00000020u)
#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_965_CLR_SHIFT (0x00000005u)
#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_965_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_966_CLR_MASK (0x00000040u)
#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_966_CLR_SHIFT (0x00000006u)
#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_966_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_967_CLR_MASK (0x00000080u)
#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_967_CLR_SHIFT (0x00000007u)
#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_967_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_968_CLR_MASK (0x00000100u)
#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_968_CLR_SHIFT (0x00000008u)
#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_968_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_969_CLR_MASK (0x00000200u)
#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_969_CLR_SHIFT (0x00000009u)
#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_969_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_970_CLR_MASK (0x00000400u)
#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_970_CLR_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_970_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_971_CLR_MASK (0x00000800u)
#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_971_CLR_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_971_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_972_CLR_MASK (0x00001000u)
#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_972_CLR_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_972_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_973_CLR_MASK (0x00002000u)
#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_973_CLR_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_973_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_974_CLR_MASK (0x00004000u)
#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_974_CLR_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_974_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_975_CLR_MASK (0x00008000u)
#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_975_CLR_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_975_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_976_CLR_MASK (0x00010000u)
#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_976_CLR_SHIFT (0x00000010u)
#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_976_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_977_CLR_MASK (0x00020000u)
#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_977_CLR_SHIFT (0x00000011u)
#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_977_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_978_CLR_MASK (0x00040000u)
#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_978_CLR_SHIFT (0x00000012u)
#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_978_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_979_CLR_MASK (0x00080000u)
#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_979_CLR_SHIFT (0x00000013u)
#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_979_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_980_CLR_MASK (0x00100000u)
#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_980_CLR_SHIFT (0x00000014u)
#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_980_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_981_CLR_MASK (0x00200000u)
#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_981_CLR_SHIFT (0x00000015u)
#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_981_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_982_CLR_MASK (0x00400000u)
#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_982_CLR_SHIFT (0x00000016u)
#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_982_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_983_CLR_MASK (0x00800000u)
#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_983_CLR_SHIFT (0x00000017u)
#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_983_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_984_CLR_MASK (0x01000000u)
#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_984_CLR_SHIFT (0x00000018u)
#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_984_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_985_CLR_MASK (0x02000000u)
#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_985_CLR_SHIFT (0x00000019u)
#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_985_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_986_CLR_MASK (0x04000000u)
#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_986_CLR_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_986_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_987_CLR_MASK (0x08000000u)
#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_987_CLR_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_987_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_988_CLR_MASK (0x10000000u)
#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_988_CLR_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_988_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_989_CLR_MASK (0x20000000u)
#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_989_CLR_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_989_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_990_CLR_MASK (0x40000000u)
#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_990_CLR_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_990_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_991_CLR_MASK (0x80000000u)
#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_991_CLR_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENABLE_CLR_REG30_ENABLE_991_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG30_RESETVAL (0x00000000u)

/* enable_clr_reg31 */

#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_992_CLR_MASK (0x00000001u)
#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_992_CLR_SHIFT (0x00000000u)
#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_992_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_993_CLR_MASK (0x00000002u)
#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_993_CLR_SHIFT (0x00000001u)
#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_993_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_994_CLR_MASK (0x00000004u)
#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_994_CLR_SHIFT (0x00000002u)
#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_994_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_995_CLR_MASK (0x00000008u)
#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_995_CLR_SHIFT (0x00000003u)
#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_995_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_996_CLR_MASK (0x00000010u)
#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_996_CLR_SHIFT (0x00000004u)
#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_996_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_997_CLR_MASK (0x00000020u)
#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_997_CLR_SHIFT (0x00000005u)
#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_997_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_998_CLR_MASK (0x00000040u)
#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_998_CLR_SHIFT (0x00000006u)
#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_998_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_999_CLR_MASK (0x00000080u)
#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_999_CLR_SHIFT (0x00000007u)
#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_999_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_1000_CLR_MASK (0x00000100u)
#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_1000_CLR_SHIFT (0x00000008u)
#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_1000_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_1001_CLR_MASK (0x00000200u)
#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_1001_CLR_SHIFT (0x00000009u)
#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_1001_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_1002_CLR_MASK (0x00000400u)
#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_1002_CLR_SHIFT (0x0000000Au)
#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_1002_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_1003_CLR_MASK (0x00000800u)
#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_1003_CLR_SHIFT (0x0000000Bu)
#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_1003_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_1004_CLR_MASK (0x00001000u)
#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_1004_CLR_SHIFT (0x0000000Cu)
#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_1004_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_1005_CLR_MASK (0x00002000u)
#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_1005_CLR_SHIFT (0x0000000Du)
#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_1005_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_1006_CLR_MASK (0x00004000u)
#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_1006_CLR_SHIFT (0x0000000Eu)
#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_1006_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_1007_CLR_MASK (0x00008000u)
#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_1007_CLR_SHIFT (0x0000000Fu)
#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_1007_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_1008_CLR_MASK (0x00010000u)
#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_1008_CLR_SHIFT (0x00000010u)
#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_1008_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_1009_CLR_MASK (0x00020000u)
#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_1009_CLR_SHIFT (0x00000011u)
#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_1009_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_1010_CLR_MASK (0x00040000u)
#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_1010_CLR_SHIFT (0x00000012u)
#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_1010_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_1011_CLR_MASK (0x00080000u)
#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_1011_CLR_SHIFT (0x00000013u)
#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_1011_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_1012_CLR_MASK (0x00100000u)
#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_1012_CLR_SHIFT (0x00000014u)
#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_1012_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_1013_CLR_MASK (0x00200000u)
#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_1013_CLR_SHIFT (0x00000015u)
#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_1013_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_1014_CLR_MASK (0x00400000u)
#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_1014_CLR_SHIFT (0x00000016u)
#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_1014_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_1015_CLR_MASK (0x00800000u)
#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_1015_CLR_SHIFT (0x00000017u)
#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_1015_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_1016_CLR_MASK (0x01000000u)
#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_1016_CLR_SHIFT (0x00000018u)
#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_1016_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_1017_CLR_MASK (0x02000000u)
#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_1017_CLR_SHIFT (0x00000019u)
#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_1017_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_1018_CLR_MASK (0x04000000u)
#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_1018_CLR_SHIFT (0x0000001Au)
#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_1018_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_1019_CLR_MASK (0x08000000u)
#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_1019_CLR_SHIFT (0x0000001Bu)
#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_1019_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_1020_CLR_MASK (0x10000000u)
#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_1020_CLR_SHIFT (0x0000001Cu)
#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_1020_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_1021_CLR_MASK (0x20000000u)
#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_1021_CLR_SHIFT (0x0000001Du)
#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_1021_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_1022_CLR_MASK (0x40000000u)
#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_1022_CLR_SHIFT (0x0000001Eu)
#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_1022_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_1023_CLR_MASK (0x80000000u)
#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_1023_CLR_SHIFT (0x0000001Fu)
#define CSL_CPINTC_ENABLE_CLR_REG31_ENABLE_1023_CLR_RESETVAL (0x00000000u)

#define CSL_CPINTC_ENABLE_CLR_REG31_RESETVAL (0x00000000u)

/* ch_map_reg0 */

#define CSL_CPINTC_CH_MAP_REG0_CH_MAP_0_MASK (0x000000FFu)
#define CSL_CPINTC_CH_MAP_REG0_CH_MAP_0_SHIFT (0x00000000u)
#define CSL_CPINTC_CH_MAP_REG0_CH_MAP_0_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG0_CH_MAP_1_MASK (0x0000FF00u)
#define CSL_CPINTC_CH_MAP_REG0_CH_MAP_1_SHIFT (0x00000008u)
#define CSL_CPINTC_CH_MAP_REG0_CH_MAP_1_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG0_CH_MAP_2_MASK (0x00FF0000u)
#define CSL_CPINTC_CH_MAP_REG0_CH_MAP_2_SHIFT (0x00000010u)
#define CSL_CPINTC_CH_MAP_REG0_CH_MAP_2_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG0_CH_MAP_3_MASK (0xFF000000u)
#define CSL_CPINTC_CH_MAP_REG0_CH_MAP_3_SHIFT (0x00000018u)
#define CSL_CPINTC_CH_MAP_REG0_CH_MAP_3_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG0_RESETVAL  (0x00000000u)

/* ch_map_reg1 */

#define CSL_CPINTC_CH_MAP_REG1_CH_MAP_4_MASK (0x000000FFu)
#define CSL_CPINTC_CH_MAP_REG1_CH_MAP_4_SHIFT (0x00000000u)
#define CSL_CPINTC_CH_MAP_REG1_CH_MAP_4_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG1_CH_MAP_5_MASK (0x0000FF00u)
#define CSL_CPINTC_CH_MAP_REG1_CH_MAP_5_SHIFT (0x00000008u)
#define CSL_CPINTC_CH_MAP_REG1_CH_MAP_5_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG1_CH_MAP_6_MASK (0x00FF0000u)
#define CSL_CPINTC_CH_MAP_REG1_CH_MAP_6_SHIFT (0x00000010u)
#define CSL_CPINTC_CH_MAP_REG1_CH_MAP_6_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG1_CH_MAP_7_MASK (0xFF000000u)
#define CSL_CPINTC_CH_MAP_REG1_CH_MAP_7_SHIFT (0x00000018u)
#define CSL_CPINTC_CH_MAP_REG1_CH_MAP_7_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG1_RESETVAL  (0x00000000u)

/* ch_map_reg2 */

#define CSL_CPINTC_CH_MAP_REG2_CH_MAP_8_MASK (0x000000FFu)
#define CSL_CPINTC_CH_MAP_REG2_CH_MAP_8_SHIFT (0x00000000u)
#define CSL_CPINTC_CH_MAP_REG2_CH_MAP_8_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG2_CH_MAP_9_MASK (0x0000FF00u)
#define CSL_CPINTC_CH_MAP_REG2_CH_MAP_9_SHIFT (0x00000008u)
#define CSL_CPINTC_CH_MAP_REG2_CH_MAP_9_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG2_CH_MAP_10_MASK (0x00FF0000u)
#define CSL_CPINTC_CH_MAP_REG2_CH_MAP_10_SHIFT (0x00000010u)
#define CSL_CPINTC_CH_MAP_REG2_CH_MAP_10_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG2_CH_MAP_11_MASK (0xFF000000u)
#define CSL_CPINTC_CH_MAP_REG2_CH_MAP_11_SHIFT (0x00000018u)
#define CSL_CPINTC_CH_MAP_REG2_CH_MAP_11_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG2_RESETVAL  (0x00000000u)

/* ch_map_reg3 */

#define CSL_CPINTC_CH_MAP_REG3_CH_MAP_12_MASK (0x000000FFu)
#define CSL_CPINTC_CH_MAP_REG3_CH_MAP_12_SHIFT (0x00000000u)
#define CSL_CPINTC_CH_MAP_REG3_CH_MAP_12_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG3_CH_MAP_13_MASK (0x0000FF00u)
#define CSL_CPINTC_CH_MAP_REG3_CH_MAP_13_SHIFT (0x00000008u)
#define CSL_CPINTC_CH_MAP_REG3_CH_MAP_13_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG3_CH_MAP_14_MASK (0x00FF0000u)
#define CSL_CPINTC_CH_MAP_REG3_CH_MAP_14_SHIFT (0x00000010u)
#define CSL_CPINTC_CH_MAP_REG3_CH_MAP_14_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG3_CH_MAP_15_MASK (0xFF000000u)
#define CSL_CPINTC_CH_MAP_REG3_CH_MAP_15_SHIFT (0x00000018u)
#define CSL_CPINTC_CH_MAP_REG3_CH_MAP_15_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG3_RESETVAL  (0x00000000u)

/* ch_map_reg4 */

#define CSL_CPINTC_CH_MAP_REG4_CH_MAP_16_MASK (0x000000FFu)
#define CSL_CPINTC_CH_MAP_REG4_CH_MAP_16_SHIFT (0x00000000u)
#define CSL_CPINTC_CH_MAP_REG4_CH_MAP_16_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG4_CH_MAP_17_MASK (0x0000FF00u)
#define CSL_CPINTC_CH_MAP_REG4_CH_MAP_17_SHIFT (0x00000008u)
#define CSL_CPINTC_CH_MAP_REG4_CH_MAP_17_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG4_CH_MAP_18_MASK (0x00FF0000u)
#define CSL_CPINTC_CH_MAP_REG4_CH_MAP_18_SHIFT (0x00000010u)
#define CSL_CPINTC_CH_MAP_REG4_CH_MAP_18_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG4_CH_MAP_19_MASK (0xFF000000u)
#define CSL_CPINTC_CH_MAP_REG4_CH_MAP_19_SHIFT (0x00000018u)
#define CSL_CPINTC_CH_MAP_REG4_CH_MAP_19_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG4_RESETVAL  (0x00000000u)

/* ch_map_reg5 */

#define CSL_CPINTC_CH_MAP_REG5_CH_MAP_20_MASK (0x000000FFu)
#define CSL_CPINTC_CH_MAP_REG5_CH_MAP_20_SHIFT (0x00000000u)
#define CSL_CPINTC_CH_MAP_REG5_CH_MAP_20_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG5_CH_MAP_21_MASK (0x0000FF00u)
#define CSL_CPINTC_CH_MAP_REG5_CH_MAP_21_SHIFT (0x00000008u)
#define CSL_CPINTC_CH_MAP_REG5_CH_MAP_21_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG5_CH_MAP_22_MASK (0x00FF0000u)
#define CSL_CPINTC_CH_MAP_REG5_CH_MAP_22_SHIFT (0x00000010u)
#define CSL_CPINTC_CH_MAP_REG5_CH_MAP_22_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG5_CH_MAP_23_MASK (0xFF000000u)
#define CSL_CPINTC_CH_MAP_REG5_CH_MAP_23_SHIFT (0x00000018u)
#define CSL_CPINTC_CH_MAP_REG5_CH_MAP_23_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG5_RESETVAL  (0x00000000u)

/* ch_map_reg6 */

#define CSL_CPINTC_CH_MAP_REG6_CH_MAP_24_MASK (0x000000FFu)
#define CSL_CPINTC_CH_MAP_REG6_CH_MAP_24_SHIFT (0x00000000u)
#define CSL_CPINTC_CH_MAP_REG6_CH_MAP_24_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG6_CH_MAP_25_MASK (0x0000FF00u)
#define CSL_CPINTC_CH_MAP_REG6_CH_MAP_25_SHIFT (0x00000008u)
#define CSL_CPINTC_CH_MAP_REG6_CH_MAP_25_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG6_CH_MAP_26_MASK (0x00FF0000u)
#define CSL_CPINTC_CH_MAP_REG6_CH_MAP_26_SHIFT (0x00000010u)
#define CSL_CPINTC_CH_MAP_REG6_CH_MAP_26_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG6_CH_MAP_27_MASK (0xFF000000u)
#define CSL_CPINTC_CH_MAP_REG6_CH_MAP_27_SHIFT (0x00000018u)
#define CSL_CPINTC_CH_MAP_REG6_CH_MAP_27_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG6_RESETVAL  (0x00000000u)

/* ch_map_reg7 */

#define CSL_CPINTC_CH_MAP_REG7_CH_MAP_28_MASK (0x000000FFu)
#define CSL_CPINTC_CH_MAP_REG7_CH_MAP_28_SHIFT (0x00000000u)
#define CSL_CPINTC_CH_MAP_REG7_CH_MAP_28_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG7_CH_MAP_29_MASK (0x0000FF00u)
#define CSL_CPINTC_CH_MAP_REG7_CH_MAP_29_SHIFT (0x00000008u)
#define CSL_CPINTC_CH_MAP_REG7_CH_MAP_29_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG7_CH_MAP_30_MASK (0x00FF0000u)
#define CSL_CPINTC_CH_MAP_REG7_CH_MAP_30_SHIFT (0x00000010u)
#define CSL_CPINTC_CH_MAP_REG7_CH_MAP_30_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG7_CH_MAP_31_MASK (0xFF000000u)
#define CSL_CPINTC_CH_MAP_REG7_CH_MAP_31_SHIFT (0x00000018u)
#define CSL_CPINTC_CH_MAP_REG7_CH_MAP_31_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG7_RESETVAL  (0x00000000u)

/* ch_map_reg8 */

#define CSL_CPINTC_CH_MAP_REG8_CH_MAP_32_MASK (0x000000FFu)
#define CSL_CPINTC_CH_MAP_REG8_CH_MAP_32_SHIFT (0x00000000u)
#define CSL_CPINTC_CH_MAP_REG8_CH_MAP_32_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG8_CH_MAP_33_MASK (0x0000FF00u)
#define CSL_CPINTC_CH_MAP_REG8_CH_MAP_33_SHIFT (0x00000008u)
#define CSL_CPINTC_CH_MAP_REG8_CH_MAP_33_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG8_CH_MAP_34_MASK (0x00FF0000u)
#define CSL_CPINTC_CH_MAP_REG8_CH_MAP_34_SHIFT (0x00000010u)
#define CSL_CPINTC_CH_MAP_REG8_CH_MAP_34_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG8_CH_MAP_35_MASK (0xFF000000u)
#define CSL_CPINTC_CH_MAP_REG8_CH_MAP_35_SHIFT (0x00000018u)
#define CSL_CPINTC_CH_MAP_REG8_CH_MAP_35_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG8_RESETVAL  (0x00000000u)

/* ch_map_reg9 */

#define CSL_CPINTC_CH_MAP_REG9_CH_MAP_36_MASK (0x000000FFu)
#define CSL_CPINTC_CH_MAP_REG9_CH_MAP_36_SHIFT (0x00000000u)
#define CSL_CPINTC_CH_MAP_REG9_CH_MAP_36_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG9_CH_MAP_37_MASK (0x0000FF00u)
#define CSL_CPINTC_CH_MAP_REG9_CH_MAP_37_SHIFT (0x00000008u)
#define CSL_CPINTC_CH_MAP_REG9_CH_MAP_37_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG9_CH_MAP_38_MASK (0x00FF0000u)
#define CSL_CPINTC_CH_MAP_REG9_CH_MAP_38_SHIFT (0x00000010u)
#define CSL_CPINTC_CH_MAP_REG9_CH_MAP_38_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG9_CH_MAP_39_MASK (0xFF000000u)
#define CSL_CPINTC_CH_MAP_REG9_CH_MAP_39_SHIFT (0x00000018u)
#define CSL_CPINTC_CH_MAP_REG9_CH_MAP_39_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG9_RESETVAL  (0x00000000u)

/* ch_map_reg10 */

#define CSL_CPINTC_CH_MAP_REG10_CH_MAP_40_MASK (0x000000FFu)
#define CSL_CPINTC_CH_MAP_REG10_CH_MAP_40_SHIFT (0x00000000u)
#define CSL_CPINTC_CH_MAP_REG10_CH_MAP_40_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG10_CH_MAP_41_MASK (0x0000FF00u)
#define CSL_CPINTC_CH_MAP_REG10_CH_MAP_41_SHIFT (0x00000008u)
#define CSL_CPINTC_CH_MAP_REG10_CH_MAP_41_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG10_CH_MAP_42_MASK (0x00FF0000u)
#define CSL_CPINTC_CH_MAP_REG10_CH_MAP_42_SHIFT (0x00000010u)
#define CSL_CPINTC_CH_MAP_REG10_CH_MAP_42_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG10_CH_MAP_43_MASK (0xFF000000u)
#define CSL_CPINTC_CH_MAP_REG10_CH_MAP_43_SHIFT (0x00000018u)
#define CSL_CPINTC_CH_MAP_REG10_CH_MAP_43_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG10_RESETVAL (0x00000000u)

/* ch_map_reg11 */

#define CSL_CPINTC_CH_MAP_REG11_CH_MAP_44_MASK (0x000000FFu)
#define CSL_CPINTC_CH_MAP_REG11_CH_MAP_44_SHIFT (0x00000000u)
#define CSL_CPINTC_CH_MAP_REG11_CH_MAP_44_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG11_CH_MAP_45_MASK (0x0000FF00u)
#define CSL_CPINTC_CH_MAP_REG11_CH_MAP_45_SHIFT (0x00000008u)
#define CSL_CPINTC_CH_MAP_REG11_CH_MAP_45_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG11_CH_MAP_46_MASK (0x00FF0000u)
#define CSL_CPINTC_CH_MAP_REG11_CH_MAP_46_SHIFT (0x00000010u)
#define CSL_CPINTC_CH_MAP_REG11_CH_MAP_46_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG11_CH_MAP_47_MASK (0xFF000000u)
#define CSL_CPINTC_CH_MAP_REG11_CH_MAP_47_SHIFT (0x00000018u)
#define CSL_CPINTC_CH_MAP_REG11_CH_MAP_47_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG11_RESETVAL (0x00000000u)

/* ch_map_reg12 */

#define CSL_CPINTC_CH_MAP_REG12_CH_MAP_48_MASK (0x000000FFu)
#define CSL_CPINTC_CH_MAP_REG12_CH_MAP_48_SHIFT (0x00000000u)
#define CSL_CPINTC_CH_MAP_REG12_CH_MAP_48_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG12_CH_MAP_49_MASK (0x0000FF00u)
#define CSL_CPINTC_CH_MAP_REG12_CH_MAP_49_SHIFT (0x00000008u)
#define CSL_CPINTC_CH_MAP_REG12_CH_MAP_49_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG12_CH_MAP_50_MASK (0x00FF0000u)
#define CSL_CPINTC_CH_MAP_REG12_CH_MAP_50_SHIFT (0x00000010u)
#define CSL_CPINTC_CH_MAP_REG12_CH_MAP_50_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG12_CH_MAP_51_MASK (0xFF000000u)
#define CSL_CPINTC_CH_MAP_REG12_CH_MAP_51_SHIFT (0x00000018u)
#define CSL_CPINTC_CH_MAP_REG12_CH_MAP_51_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG12_RESETVAL (0x00000000u)

/* ch_map_reg13 */

#define CSL_CPINTC_CH_MAP_REG13_CH_MAP_52_MASK (0x000000FFu)
#define CSL_CPINTC_CH_MAP_REG13_CH_MAP_52_SHIFT (0x00000000u)
#define CSL_CPINTC_CH_MAP_REG13_CH_MAP_52_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG13_CH_MAP_53_MASK (0x0000FF00u)
#define CSL_CPINTC_CH_MAP_REG13_CH_MAP_53_SHIFT (0x00000008u)
#define CSL_CPINTC_CH_MAP_REG13_CH_MAP_53_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG13_CH_MAP_54_MASK (0x00FF0000u)
#define CSL_CPINTC_CH_MAP_REG13_CH_MAP_54_SHIFT (0x00000010u)
#define CSL_CPINTC_CH_MAP_REG13_CH_MAP_54_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG13_CH_MAP_55_MASK (0xFF000000u)
#define CSL_CPINTC_CH_MAP_REG13_CH_MAP_55_SHIFT (0x00000018u)
#define CSL_CPINTC_CH_MAP_REG13_CH_MAP_55_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG13_RESETVAL (0x00000000u)

/* ch_map_reg14 */

#define CSL_CPINTC_CH_MAP_REG14_CH_MAP_56_MASK (0x000000FFu)
#define CSL_CPINTC_CH_MAP_REG14_CH_MAP_56_SHIFT (0x00000000u)
#define CSL_CPINTC_CH_MAP_REG14_CH_MAP_56_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG14_CH_MAP_57_MASK (0x0000FF00u)
#define CSL_CPINTC_CH_MAP_REG14_CH_MAP_57_SHIFT (0x00000008u)
#define CSL_CPINTC_CH_MAP_REG14_CH_MAP_57_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG14_CH_MAP_58_MASK (0x00FF0000u)
#define CSL_CPINTC_CH_MAP_REG14_CH_MAP_58_SHIFT (0x00000010u)
#define CSL_CPINTC_CH_MAP_REG14_CH_MAP_58_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG14_CH_MAP_59_MASK (0xFF000000u)
#define CSL_CPINTC_CH_MAP_REG14_CH_MAP_59_SHIFT (0x00000018u)
#define CSL_CPINTC_CH_MAP_REG14_CH_MAP_59_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG14_RESETVAL (0x00000000u)

/* ch_map_reg15 */

#define CSL_CPINTC_CH_MAP_REG15_CH_MAP_60_MASK (0x000000FFu)
#define CSL_CPINTC_CH_MAP_REG15_CH_MAP_60_SHIFT (0x00000000u)
#define CSL_CPINTC_CH_MAP_REG15_CH_MAP_60_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG15_CH_MAP_61_MASK (0x0000FF00u)
#define CSL_CPINTC_CH_MAP_REG15_CH_MAP_61_SHIFT (0x00000008u)
#define CSL_CPINTC_CH_MAP_REG15_CH_MAP_61_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG15_CH_MAP_62_MASK (0x00FF0000u)
#define CSL_CPINTC_CH_MAP_REG15_CH_MAP_62_SHIFT (0x00000010u)
#define CSL_CPINTC_CH_MAP_REG15_CH_MAP_62_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG15_CH_MAP_63_MASK (0xFF000000u)
#define CSL_CPINTC_CH_MAP_REG15_CH_MAP_63_SHIFT (0x00000018u)
#define CSL_CPINTC_CH_MAP_REG15_CH_MAP_63_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG15_RESETVAL (0x00000000u)

/* ch_map_reg16 */

#define CSL_CPINTC_CH_MAP_REG16_CH_MAP_64_MASK (0x000000FFu)
#define CSL_CPINTC_CH_MAP_REG16_CH_MAP_64_SHIFT (0x00000000u)
#define CSL_CPINTC_CH_MAP_REG16_CH_MAP_64_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG16_CH_MAP_65_MASK (0x0000FF00u)
#define CSL_CPINTC_CH_MAP_REG16_CH_MAP_65_SHIFT (0x00000008u)
#define CSL_CPINTC_CH_MAP_REG16_CH_MAP_65_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG16_CH_MAP_66_MASK (0x00FF0000u)
#define CSL_CPINTC_CH_MAP_REG16_CH_MAP_66_SHIFT (0x00000010u)
#define CSL_CPINTC_CH_MAP_REG16_CH_MAP_66_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG16_CH_MAP_67_MASK (0xFF000000u)
#define CSL_CPINTC_CH_MAP_REG16_CH_MAP_67_SHIFT (0x00000018u)
#define CSL_CPINTC_CH_MAP_REG16_CH_MAP_67_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG16_RESETVAL (0x00000000u)

/* ch_map_reg17 */

#define CSL_CPINTC_CH_MAP_REG17_CH_MAP_68_MASK (0x000000FFu)
#define CSL_CPINTC_CH_MAP_REG17_CH_MAP_68_SHIFT (0x00000000u)
#define CSL_CPINTC_CH_MAP_REG17_CH_MAP_68_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG17_CH_MAP_69_MASK (0x0000FF00u)
#define CSL_CPINTC_CH_MAP_REG17_CH_MAP_69_SHIFT (0x00000008u)
#define CSL_CPINTC_CH_MAP_REG17_CH_MAP_69_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG17_CH_MAP_70_MASK (0x00FF0000u)
#define CSL_CPINTC_CH_MAP_REG17_CH_MAP_70_SHIFT (0x00000010u)
#define CSL_CPINTC_CH_MAP_REG17_CH_MAP_70_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG17_CH_MAP_71_MASK (0xFF000000u)
#define CSL_CPINTC_CH_MAP_REG17_CH_MAP_71_SHIFT (0x00000018u)
#define CSL_CPINTC_CH_MAP_REG17_CH_MAP_71_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG17_RESETVAL (0x00000000u)

/* ch_map_reg18 */

#define CSL_CPINTC_CH_MAP_REG18_CH_MAP_72_MASK (0x000000FFu)
#define CSL_CPINTC_CH_MAP_REG18_CH_MAP_72_SHIFT (0x00000000u)
#define CSL_CPINTC_CH_MAP_REG18_CH_MAP_72_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG18_CH_MAP_73_MASK (0x0000FF00u)
#define CSL_CPINTC_CH_MAP_REG18_CH_MAP_73_SHIFT (0x00000008u)
#define CSL_CPINTC_CH_MAP_REG18_CH_MAP_73_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG18_CH_MAP_74_MASK (0x00FF0000u)
#define CSL_CPINTC_CH_MAP_REG18_CH_MAP_74_SHIFT (0x00000010u)
#define CSL_CPINTC_CH_MAP_REG18_CH_MAP_74_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG18_CH_MAP_75_MASK (0xFF000000u)
#define CSL_CPINTC_CH_MAP_REG18_CH_MAP_75_SHIFT (0x00000018u)
#define CSL_CPINTC_CH_MAP_REG18_CH_MAP_75_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG18_RESETVAL (0x00000000u)

/* ch_map_reg19 */

#define CSL_CPINTC_CH_MAP_REG19_CH_MAP_76_MASK (0x000000FFu)
#define CSL_CPINTC_CH_MAP_REG19_CH_MAP_76_SHIFT (0x00000000u)
#define CSL_CPINTC_CH_MAP_REG19_CH_MAP_76_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG19_CH_MAP_77_MASK (0x0000FF00u)
#define CSL_CPINTC_CH_MAP_REG19_CH_MAP_77_SHIFT (0x00000008u)
#define CSL_CPINTC_CH_MAP_REG19_CH_MAP_77_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG19_CH_MAP_78_MASK (0x00FF0000u)
#define CSL_CPINTC_CH_MAP_REG19_CH_MAP_78_SHIFT (0x00000010u)
#define CSL_CPINTC_CH_MAP_REG19_CH_MAP_78_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG19_CH_MAP_79_MASK (0xFF000000u)
#define CSL_CPINTC_CH_MAP_REG19_CH_MAP_79_SHIFT (0x00000018u)
#define CSL_CPINTC_CH_MAP_REG19_CH_MAP_79_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG19_RESETVAL (0x00000000u)

/* ch_map_reg20 */

#define CSL_CPINTC_CH_MAP_REG20_CH_MAP_80_MASK (0x000000FFu)
#define CSL_CPINTC_CH_MAP_REG20_CH_MAP_80_SHIFT (0x00000000u)
#define CSL_CPINTC_CH_MAP_REG20_CH_MAP_80_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG20_CH_MAP_81_MASK (0x0000FF00u)
#define CSL_CPINTC_CH_MAP_REG20_CH_MAP_81_SHIFT (0x00000008u)
#define CSL_CPINTC_CH_MAP_REG20_CH_MAP_81_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG20_CH_MAP_82_MASK (0x00FF0000u)
#define CSL_CPINTC_CH_MAP_REG20_CH_MAP_82_SHIFT (0x00000010u)
#define CSL_CPINTC_CH_MAP_REG20_CH_MAP_82_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG20_CH_MAP_83_MASK (0xFF000000u)
#define CSL_CPINTC_CH_MAP_REG20_CH_MAP_83_SHIFT (0x00000018u)
#define CSL_CPINTC_CH_MAP_REG20_CH_MAP_83_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG20_RESETVAL (0x00000000u)

/* ch_map_reg21 */

#define CSL_CPINTC_CH_MAP_REG21_CH_MAP_84_MASK (0x000000FFu)
#define CSL_CPINTC_CH_MAP_REG21_CH_MAP_84_SHIFT (0x00000000u)
#define CSL_CPINTC_CH_MAP_REG21_CH_MAP_84_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG21_CH_MAP_85_MASK (0x0000FF00u)
#define CSL_CPINTC_CH_MAP_REG21_CH_MAP_85_SHIFT (0x00000008u)
#define CSL_CPINTC_CH_MAP_REG21_CH_MAP_85_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG21_CH_MAP_86_MASK (0x00FF0000u)
#define CSL_CPINTC_CH_MAP_REG21_CH_MAP_86_SHIFT (0x00000010u)
#define CSL_CPINTC_CH_MAP_REG21_CH_MAP_86_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG21_CH_MAP_87_MASK (0xFF000000u)
#define CSL_CPINTC_CH_MAP_REG21_CH_MAP_87_SHIFT (0x00000018u)
#define CSL_CPINTC_CH_MAP_REG21_CH_MAP_87_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG21_RESETVAL (0x00000000u)

/* ch_map_reg22 */

#define CSL_CPINTC_CH_MAP_REG22_CH_MAP_88_MASK (0x000000FFu)
#define CSL_CPINTC_CH_MAP_REG22_CH_MAP_88_SHIFT (0x00000000u)
#define CSL_CPINTC_CH_MAP_REG22_CH_MAP_88_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG22_CH_MAP_89_MASK (0x0000FF00u)
#define CSL_CPINTC_CH_MAP_REG22_CH_MAP_89_SHIFT (0x00000008u)
#define CSL_CPINTC_CH_MAP_REG22_CH_MAP_89_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG22_CH_MAP_90_MASK (0x00FF0000u)
#define CSL_CPINTC_CH_MAP_REG22_CH_MAP_90_SHIFT (0x00000010u)
#define CSL_CPINTC_CH_MAP_REG22_CH_MAP_90_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG22_CH_MAP_91_MASK (0xFF000000u)
#define CSL_CPINTC_CH_MAP_REG22_CH_MAP_91_SHIFT (0x00000018u)
#define CSL_CPINTC_CH_MAP_REG22_CH_MAP_91_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG22_RESETVAL (0x00000000u)

/* ch_map_reg23 */

#define CSL_CPINTC_CH_MAP_REG23_CH_MAP_92_MASK (0x000000FFu)
#define CSL_CPINTC_CH_MAP_REG23_CH_MAP_92_SHIFT (0x00000000u)
#define CSL_CPINTC_CH_MAP_REG23_CH_MAP_92_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG23_CH_MAP_93_MASK (0x0000FF00u)
#define CSL_CPINTC_CH_MAP_REG23_CH_MAP_93_SHIFT (0x00000008u)
#define CSL_CPINTC_CH_MAP_REG23_CH_MAP_93_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG23_CH_MAP_94_MASK (0x00FF0000u)
#define CSL_CPINTC_CH_MAP_REG23_CH_MAP_94_SHIFT (0x00000010u)
#define CSL_CPINTC_CH_MAP_REG23_CH_MAP_94_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG23_CH_MAP_95_MASK (0xFF000000u)
#define CSL_CPINTC_CH_MAP_REG23_CH_MAP_95_SHIFT (0x00000018u)
#define CSL_CPINTC_CH_MAP_REG23_CH_MAP_95_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG23_RESETVAL (0x00000000u)

/* ch_map_reg24 */

#define CSL_CPINTC_CH_MAP_REG24_CH_MAP_96_MASK (0x000000FFu)
#define CSL_CPINTC_CH_MAP_REG24_CH_MAP_96_SHIFT (0x00000000u)
#define CSL_CPINTC_CH_MAP_REG24_CH_MAP_96_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG24_CH_MAP_97_MASK (0x0000FF00u)
#define CSL_CPINTC_CH_MAP_REG24_CH_MAP_97_SHIFT (0x00000008u)
#define CSL_CPINTC_CH_MAP_REG24_CH_MAP_97_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG24_CH_MAP_98_MASK (0x00FF0000u)
#define CSL_CPINTC_CH_MAP_REG24_CH_MAP_98_SHIFT (0x00000010u)
#define CSL_CPINTC_CH_MAP_REG24_CH_MAP_98_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG24_CH_MAP_99_MASK (0xFF000000u)
#define CSL_CPINTC_CH_MAP_REG24_CH_MAP_99_SHIFT (0x00000018u)
#define CSL_CPINTC_CH_MAP_REG24_CH_MAP_99_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG24_RESETVAL (0x00000000u)

/* ch_map_reg25 */

#define CSL_CPINTC_CH_MAP_REG25_CH_MAP_100_MASK (0x000000FFu)
#define CSL_CPINTC_CH_MAP_REG25_CH_MAP_100_SHIFT (0x00000000u)
#define CSL_CPINTC_CH_MAP_REG25_CH_MAP_100_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG25_CH_MAP_101_MASK (0x0000FF00u)
#define CSL_CPINTC_CH_MAP_REG25_CH_MAP_101_SHIFT (0x00000008u)
#define CSL_CPINTC_CH_MAP_REG25_CH_MAP_101_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG25_CH_MAP_102_MASK (0x00FF0000u)
#define CSL_CPINTC_CH_MAP_REG25_CH_MAP_102_SHIFT (0x00000010u)
#define CSL_CPINTC_CH_MAP_REG25_CH_MAP_102_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG25_CH_MAP_103_MASK (0xFF000000u)
#define CSL_CPINTC_CH_MAP_REG25_CH_MAP_103_SHIFT (0x00000018u)
#define CSL_CPINTC_CH_MAP_REG25_CH_MAP_103_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG25_RESETVAL (0x00000000u)

/* ch_map_reg26 */

#define CSL_CPINTC_CH_MAP_REG26_CH_MAP_104_MASK (0x000000FFu)
#define CSL_CPINTC_CH_MAP_REG26_CH_MAP_104_SHIFT (0x00000000u)
#define CSL_CPINTC_CH_MAP_REG26_CH_MAP_104_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG26_CH_MAP_105_MASK (0x0000FF00u)
#define CSL_CPINTC_CH_MAP_REG26_CH_MAP_105_SHIFT (0x00000008u)
#define CSL_CPINTC_CH_MAP_REG26_CH_MAP_105_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG26_CH_MAP_106_MASK (0x00FF0000u)
#define CSL_CPINTC_CH_MAP_REG26_CH_MAP_106_SHIFT (0x00000010u)
#define CSL_CPINTC_CH_MAP_REG26_CH_MAP_106_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG26_CH_MAP_107_MASK (0xFF000000u)
#define CSL_CPINTC_CH_MAP_REG26_CH_MAP_107_SHIFT (0x00000018u)
#define CSL_CPINTC_CH_MAP_REG26_CH_MAP_107_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG26_RESETVAL (0x00000000u)

/* ch_map_reg27 */

#define CSL_CPINTC_CH_MAP_REG27_CH_MAP_108_MASK (0x000000FFu)
#define CSL_CPINTC_CH_MAP_REG27_CH_MAP_108_SHIFT (0x00000000u)
#define CSL_CPINTC_CH_MAP_REG27_CH_MAP_108_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG27_CH_MAP_109_MASK (0x0000FF00u)
#define CSL_CPINTC_CH_MAP_REG27_CH_MAP_109_SHIFT (0x00000008u)
#define CSL_CPINTC_CH_MAP_REG27_CH_MAP_109_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG27_CH_MAP_110_MASK (0x00FF0000u)
#define CSL_CPINTC_CH_MAP_REG27_CH_MAP_110_SHIFT (0x00000010u)
#define CSL_CPINTC_CH_MAP_REG27_CH_MAP_110_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG27_CH_MAP_111_MASK (0xFF000000u)
#define CSL_CPINTC_CH_MAP_REG27_CH_MAP_111_SHIFT (0x00000018u)
#define CSL_CPINTC_CH_MAP_REG27_CH_MAP_111_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG27_RESETVAL (0x00000000u)

/* ch_map_reg28 */

#define CSL_CPINTC_CH_MAP_REG28_CH_MAP_112_MASK (0x000000FFu)
#define CSL_CPINTC_CH_MAP_REG28_CH_MAP_112_SHIFT (0x00000000u)
#define CSL_CPINTC_CH_MAP_REG28_CH_MAP_112_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG28_CH_MAP_113_MASK (0x0000FF00u)
#define CSL_CPINTC_CH_MAP_REG28_CH_MAP_113_SHIFT (0x00000008u)
#define CSL_CPINTC_CH_MAP_REG28_CH_MAP_113_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG28_CH_MAP_114_MASK (0x00FF0000u)
#define CSL_CPINTC_CH_MAP_REG28_CH_MAP_114_SHIFT (0x00000010u)
#define CSL_CPINTC_CH_MAP_REG28_CH_MAP_114_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG28_CH_MAP_115_MASK (0xFF000000u)
#define CSL_CPINTC_CH_MAP_REG28_CH_MAP_115_SHIFT (0x00000018u)
#define CSL_CPINTC_CH_MAP_REG28_CH_MAP_115_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG28_RESETVAL (0x00000000u)

/* ch_map_reg29 */

#define CSL_CPINTC_CH_MAP_REG29_CH_MAP_116_MASK (0x000000FFu)
#define CSL_CPINTC_CH_MAP_REG29_CH_MAP_116_SHIFT (0x00000000u)
#define CSL_CPINTC_CH_MAP_REG29_CH_MAP_116_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG29_CH_MAP_117_MASK (0x0000FF00u)
#define CSL_CPINTC_CH_MAP_REG29_CH_MAP_117_SHIFT (0x00000008u)
#define CSL_CPINTC_CH_MAP_REG29_CH_MAP_117_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG29_CH_MAP_118_MASK (0x00FF0000u)
#define CSL_CPINTC_CH_MAP_REG29_CH_MAP_118_SHIFT (0x00000010u)
#define CSL_CPINTC_CH_MAP_REG29_CH_MAP_118_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG29_CH_MAP_119_MASK (0xFF000000u)
#define CSL_CPINTC_CH_MAP_REG29_CH_MAP_119_SHIFT (0x00000018u)
#define CSL_CPINTC_CH_MAP_REG29_CH_MAP_119_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG29_RESETVAL (0x00000000u)

/* ch_map_reg30 */

#define CSL_CPINTC_CH_MAP_REG30_CH_MAP_120_MASK (0x000000FFu)
#define CSL_CPINTC_CH_MAP_REG30_CH_MAP_120_SHIFT (0x00000000u)
#define CSL_CPINTC_CH_MAP_REG30_CH_MAP_120_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG30_CH_MAP_121_MASK (0x0000FF00u)
#define CSL_CPINTC_CH_MAP_REG30_CH_MAP_121_SHIFT (0x00000008u)
#define CSL_CPINTC_CH_MAP_REG30_CH_MAP_121_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG30_CH_MAP_122_MASK (0x00FF0000u)
#define CSL_CPINTC_CH_MAP_REG30_CH_MAP_122_SHIFT (0x00000010u)
#define CSL_CPINTC_CH_MAP_REG30_CH_MAP_122_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG30_CH_MAP_123_MASK (0xFF000000u)
#define CSL_CPINTC_CH_MAP_REG30_CH_MAP_123_SHIFT (0x00000018u)
#define CSL_CPINTC_CH_MAP_REG30_CH_MAP_123_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG30_RESETVAL (0x00000000u)

/* ch_map_reg31 */

#define CSL_CPINTC_CH_MAP_REG31_CH_MAP_124_MASK (0x000000FFu)
#define CSL_CPINTC_CH_MAP_REG31_CH_MAP_124_SHIFT (0x00000000u)
#define CSL_CPINTC_CH_MAP_REG31_CH_MAP_124_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG31_CH_MAP_125_MASK (0x0000FF00u)
#define CSL_CPINTC_CH_MAP_REG31_CH_MAP_125_SHIFT (0x00000008u)
#define CSL_CPINTC_CH_MAP_REG31_CH_MAP_125_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG31_CH_MAP_126_MASK (0x00FF0000u)
#define CSL_CPINTC_CH_MAP_REG31_CH_MAP_126_SHIFT (0x00000010u)
#define CSL_CPINTC_CH_MAP_REG31_CH_MAP_126_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG31_CH_MAP_127_MASK (0xFF000000u)
#define CSL_CPINTC_CH_MAP_REG31_CH_MAP_127_SHIFT (0x00000018u)
#define CSL_CPINTC_CH_MAP_REG31_CH_MAP_127_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG31_RESETVAL (0x00000000u)

/* ch_map_reg32 */

#define CSL_CPINTC_CH_MAP_REG32_CH_MAP_128_MASK (0x000000FFu)
#define CSL_CPINTC_CH_MAP_REG32_CH_MAP_128_SHIFT (0x00000000u)
#define CSL_CPINTC_CH_MAP_REG32_CH_MAP_128_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG32_CH_MAP_129_MASK (0x0000FF00u)
#define CSL_CPINTC_CH_MAP_REG32_CH_MAP_129_SHIFT (0x00000008u)
#define CSL_CPINTC_CH_MAP_REG32_CH_MAP_129_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG32_CH_MAP_130_MASK (0x00FF0000u)
#define CSL_CPINTC_CH_MAP_REG32_CH_MAP_130_SHIFT (0x00000010u)
#define CSL_CPINTC_CH_MAP_REG32_CH_MAP_130_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG32_CH_MAP_131_MASK (0xFF000000u)
#define CSL_CPINTC_CH_MAP_REG32_CH_MAP_131_SHIFT (0x00000018u)
#define CSL_CPINTC_CH_MAP_REG32_CH_MAP_131_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG32_RESETVAL (0x00000000u)

/* ch_map_reg33 */

#define CSL_CPINTC_CH_MAP_REG33_CH_MAP_132_MASK (0x000000FFu)
#define CSL_CPINTC_CH_MAP_REG33_CH_MAP_132_SHIFT (0x00000000u)
#define CSL_CPINTC_CH_MAP_REG33_CH_MAP_132_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG33_CH_MAP_133_MASK (0x0000FF00u)
#define CSL_CPINTC_CH_MAP_REG33_CH_MAP_133_SHIFT (0x00000008u)
#define CSL_CPINTC_CH_MAP_REG33_CH_MAP_133_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG33_CH_MAP_134_MASK (0x00FF0000u)
#define CSL_CPINTC_CH_MAP_REG33_CH_MAP_134_SHIFT (0x00000010u)
#define CSL_CPINTC_CH_MAP_REG33_CH_MAP_134_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG33_CH_MAP_135_MASK (0xFF000000u)
#define CSL_CPINTC_CH_MAP_REG33_CH_MAP_135_SHIFT (0x00000018u)
#define CSL_CPINTC_CH_MAP_REG33_CH_MAP_135_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG33_RESETVAL (0x00000000u)

/* ch_map_reg34 */

#define CSL_CPINTC_CH_MAP_REG34_CH_MAP_136_MASK (0x000000FFu)
#define CSL_CPINTC_CH_MAP_REG34_CH_MAP_136_SHIFT (0x00000000u)
#define CSL_CPINTC_CH_MAP_REG34_CH_MAP_136_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG34_CH_MAP_137_MASK (0x0000FF00u)
#define CSL_CPINTC_CH_MAP_REG34_CH_MAP_137_SHIFT (0x00000008u)
#define CSL_CPINTC_CH_MAP_REG34_CH_MAP_137_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG34_CH_MAP_138_MASK (0x00FF0000u)
#define CSL_CPINTC_CH_MAP_REG34_CH_MAP_138_SHIFT (0x00000010u)
#define CSL_CPINTC_CH_MAP_REG34_CH_MAP_138_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG34_CH_MAP_139_MASK (0xFF000000u)
#define CSL_CPINTC_CH_MAP_REG34_CH_MAP_139_SHIFT (0x00000018u)
#define CSL_CPINTC_CH_MAP_REG34_CH_MAP_139_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG34_RESETVAL (0x00000000u)

/* ch_map_reg35 */

#define CSL_CPINTC_CH_MAP_REG35_CH_MAP_140_MASK (0x000000FFu)
#define CSL_CPINTC_CH_MAP_REG35_CH_MAP_140_SHIFT (0x00000000u)
#define CSL_CPINTC_CH_MAP_REG35_CH_MAP_140_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG35_CH_MAP_141_MASK (0x0000FF00u)
#define CSL_CPINTC_CH_MAP_REG35_CH_MAP_141_SHIFT (0x00000008u)
#define CSL_CPINTC_CH_MAP_REG35_CH_MAP_141_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG35_CH_MAP_142_MASK (0x00FF0000u)
#define CSL_CPINTC_CH_MAP_REG35_CH_MAP_142_SHIFT (0x00000010u)
#define CSL_CPINTC_CH_MAP_REG35_CH_MAP_142_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG35_CH_MAP_143_MASK (0xFF000000u)
#define CSL_CPINTC_CH_MAP_REG35_CH_MAP_143_SHIFT (0x00000018u)
#define CSL_CPINTC_CH_MAP_REG35_CH_MAP_143_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG35_RESETVAL (0x00000000u)

/* ch_map_reg36 */

#define CSL_CPINTC_CH_MAP_REG36_CH_MAP_144_MASK (0x000000FFu)
#define CSL_CPINTC_CH_MAP_REG36_CH_MAP_144_SHIFT (0x00000000u)
#define CSL_CPINTC_CH_MAP_REG36_CH_MAP_144_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG36_CH_MAP_145_MASK (0x0000FF00u)
#define CSL_CPINTC_CH_MAP_REG36_CH_MAP_145_SHIFT (0x00000008u)
#define CSL_CPINTC_CH_MAP_REG36_CH_MAP_145_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG36_CH_MAP_146_MASK (0x00FF0000u)
#define CSL_CPINTC_CH_MAP_REG36_CH_MAP_146_SHIFT (0x00000010u)
#define CSL_CPINTC_CH_MAP_REG36_CH_MAP_146_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG36_CH_MAP_147_MASK (0xFF000000u)
#define CSL_CPINTC_CH_MAP_REG36_CH_MAP_147_SHIFT (0x00000018u)
#define CSL_CPINTC_CH_MAP_REG36_CH_MAP_147_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG36_RESETVAL (0x00000000u)

/* ch_map_reg37 */

#define CSL_CPINTC_CH_MAP_REG37_CH_MAP_148_MASK (0x000000FFu)
#define CSL_CPINTC_CH_MAP_REG37_CH_MAP_148_SHIFT (0x00000000u)
#define CSL_CPINTC_CH_MAP_REG37_CH_MAP_148_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG37_CH_MAP_149_MASK (0x0000FF00u)
#define CSL_CPINTC_CH_MAP_REG37_CH_MAP_149_SHIFT (0x00000008u)
#define CSL_CPINTC_CH_MAP_REG37_CH_MAP_149_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG37_CH_MAP_150_MASK (0x00FF0000u)
#define CSL_CPINTC_CH_MAP_REG37_CH_MAP_150_SHIFT (0x00000010u)
#define CSL_CPINTC_CH_MAP_REG37_CH_MAP_150_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG37_CH_MAP_151_MASK (0xFF000000u)
#define CSL_CPINTC_CH_MAP_REG37_CH_MAP_151_SHIFT (0x00000018u)
#define CSL_CPINTC_CH_MAP_REG37_CH_MAP_151_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG37_RESETVAL (0x00000000u)

/* ch_map_reg38 */

#define CSL_CPINTC_CH_MAP_REG38_CH_MAP_152_MASK (0x000000FFu)
#define CSL_CPINTC_CH_MAP_REG38_CH_MAP_152_SHIFT (0x00000000u)
#define CSL_CPINTC_CH_MAP_REG38_CH_MAP_152_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG38_CH_MAP_153_MASK (0x0000FF00u)
#define CSL_CPINTC_CH_MAP_REG38_CH_MAP_153_SHIFT (0x00000008u)
#define CSL_CPINTC_CH_MAP_REG38_CH_MAP_153_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG38_CH_MAP_154_MASK (0x00FF0000u)
#define CSL_CPINTC_CH_MAP_REG38_CH_MAP_154_SHIFT (0x00000010u)
#define CSL_CPINTC_CH_MAP_REG38_CH_MAP_154_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG38_CH_MAP_155_MASK (0xFF000000u)
#define CSL_CPINTC_CH_MAP_REG38_CH_MAP_155_SHIFT (0x00000018u)
#define CSL_CPINTC_CH_MAP_REG38_CH_MAP_155_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG38_RESETVAL (0x00000000u)

/* ch_map_reg39 */

#define CSL_CPINTC_CH_MAP_REG39_CH_MAP_156_MASK (0x000000FFu)
#define CSL_CPINTC_CH_MAP_REG39_CH_MAP_156_SHIFT (0x00000000u)
#define CSL_CPINTC_CH_MAP_REG39_CH_MAP_156_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG39_CH_MAP_157_MASK (0x0000FF00u)
#define CSL_CPINTC_CH_MAP_REG39_CH_MAP_157_SHIFT (0x00000008u)
#define CSL_CPINTC_CH_MAP_REG39_CH_MAP_157_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG39_CH_MAP_158_MASK (0x00FF0000u)
#define CSL_CPINTC_CH_MAP_REG39_CH_MAP_158_SHIFT (0x00000010u)
#define CSL_CPINTC_CH_MAP_REG39_CH_MAP_158_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG39_CH_MAP_159_MASK (0xFF000000u)
#define CSL_CPINTC_CH_MAP_REG39_CH_MAP_159_SHIFT (0x00000018u)
#define CSL_CPINTC_CH_MAP_REG39_CH_MAP_159_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG39_RESETVAL (0x00000000u)

/* ch_map_reg40 */

#define CSL_CPINTC_CH_MAP_REG40_CH_MAP_160_MASK (0x000000FFu)
#define CSL_CPINTC_CH_MAP_REG40_CH_MAP_160_SHIFT (0x00000000u)
#define CSL_CPINTC_CH_MAP_REG40_CH_MAP_160_RESETVAL (0x00000000u)

#define CSL_CPINTC_CH_MAP_REG40_CH_MAP_161_MA