/********************************************************************
* Copyright (C) 2003-2010 Texas Instruments Incorporated.
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/
#ifndef _CSLR_CP_TRACER_H_
#define _CSLR_CP_TRACER_H_

#include <ti/csl/cslr.h>
#include <ti/csl/tistdtypes.h>

/* Minimum unit = 1 byte */

/**************************************************************************\
* Register Overlay Structure
\**************************************************************************/
typedef struct  {
    volatile Uint32 REVISION_REG;
    volatile Uint32 TRANS_QUAL_REG;
    volatile Uint32 CTRL_AND_STATUS_REG;
    volatile Uint32 SLDG_TIME_WINDOW_REG;
    volatile Uint32 MSTID_SELA_TH0_REG;
    volatile Uint32 MSTID_SELB_TH0_REG;
    volatile Uint32 MSTID_SELC_TH0_REG;
    volatile Uint32 MSTID_SELD_TH0_REG;
    volatile Uint32 MSTID_SELA_TH1_REG;
    volatile Uint32 MSTID_SELB_TH1_REG;
    volatile Uint32 MSTID_SELC_TH1_REG;
    volatile Uint32 MSTID_SELD_TH1_REG;
    volatile Uint32 END_ADDRESS_REG;
    volatile Uint32 START_ADDRESS_REG;
    volatile Uint32 ACCESS_STATUS_REG;
    volatile Uint32 ACCESS_STATUS_PACING_REG;
    volatile Uint32 ADDRESS_MASK_REG;
    volatile Uint32 DEST_ADDRESS_REG;
    volatile Uint32 MSG_PRIO_REG;
    volatile Uint32 OWNERSHIP_REG;
    volatile Uint32 THROUGHPUT0_REG;
    volatile Uint32 THROUGHPUT1_REG;
    volatile Uint32 ACC_WAIT_TIME_REG;
    volatile Uint32 NUM_GRANT_REG;
    volatile Uint32 INTR_RAW_STATUS_REG;
    volatile Uint32 INTR_MASKED_STATUS_REG;
    volatile Uint32 INTR_MASK_SET_REG;
    volatile Uint32 INTR_MASK_CLEAR_REG;
    volatile Uint32 EOI_REG;
} CSL_Cp_tracerRegs;

/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* revision_reg */

#define CSL_CP_TRACER_REVISION_REG_REV_MINOR_MASK (0x0000003Fu)
#define CSL_CP_TRACER_REVISION_REG_REV_MINOR_SHIFT (0x00000000u)
#define CSL_CP_TRACER_REVISION_REG_REV_MINOR_RESETVAL (0x00000002u)

#define CSL_CP_TRACER_REVISION_REG_REV_CUSTOM_MASK (0x000000C0u)
#define CSL_CP_TRACER_REVISION_REG_REV_CUSTOM_SHIFT (0x00000006u)
#define CSL_CP_TRACER_REVISION_REG_REV_CUSTOM_RESETVAL (0x00000000u)

#define CSL_CP_TRACER_REVISION_REG_REV_MAJOR_MASK (0x00000700u)
#define CSL_CP_TRACER_REVISION_REG_REV_MAJOR_SHIFT (0x00000008u)
#define CSL_CP_TRACER_REVISION_REG_REV_MAJOR_RESETVAL (0x00000001u)

#define CSL_CP_TRACER_REVISION_REG_REV_RTL_MASK (0x0000F800u)
#define CSL_CP_TRACER_REVISION_REG_REV_RTL_SHIFT (0x0000000Bu)
#define CSL_CP_TRACER_REVISION_REG_REV_RTL_RESETVAL (0x00000001u)

#define CSL_CP_TRACER_REVISION_REG_REV_MODULE_MASK (0x0FFF0000u)
#define CSL_CP_TRACER_REVISION_REG_REV_MODULE_SHIFT (0x00000010u)
#define CSL_CP_TRACER_REVISION_REG_REV_MODULE_RESETVAL (0x00000E89u)

#define CSL_CP_TRACER_REVISION_REG_REV_SCHEME_MASK (0xC0000000u)
#define CSL_CP_TRACER_REVISION_REG_REV_SCHEME_SHIFT (0x0000001Eu)
#define CSL_CP_TRACER_REVISION_REG_REV_SCHEME_RESETVAL (0x00000001u)

#define CSL_CP_TRACER_REVISION_REG_RESETVAL (0x4E890902u)

/* trans_qual_reg */

#define CSL_CP_TRACER_TRANS_QUAL_REG_QUALIF_TRACE_MASK (0x00000003u)
#define CSL_CP_TRACER_TRANS_QUAL_REG_QUALIF_TRACE_SHIFT (0x00000000u)
#define CSL_CP_TRACER_TRANS_QUAL_REG_QUALIF_TRACE_RESETVAL (0x00000000u)

#define CSL_CP_TRACER_TRANS_QUAL_REG_QUALIF_TH0_MASK (0x0000000Cu)
#define CSL_CP_TRACER_TRANS_QUAL_REG_QUALIF_TH0_SHIFT (0x00000002u)
#define CSL_CP_TRACER_TRANS_QUAL_REG_QUALIF_TH0_RESETVAL (0x00000000u)

#define CSL_CP_TRACER_TRANS_QUAL_REG_QUALIF_TH1_MASK (0x00000030u)
#define CSL_CP_TRACER_TRANS_QUAL_REG_QUALIF_TH1_SHIFT (0x00000004u)
#define CSL_CP_TRACER_TRANS_QUAL_REG_QUALIF_TH1_RESETVAL (0x00000000u)

#define CSL_CP_TRACER_TRANS_QUAL_REG_QUALIF_TRIG_MASK (0x000000C0u)
#define CSL_CP_TRACER_TRANS_QUAL_REG_QUALIF_TRIG_SHIFT (0x00000006u)
#define CSL_CP_TRACER_TRANS_QUAL_REG_QUALIF_TRIG_RESETVAL (0x00000000u)

#define CSL_CP_TRACER_TRANS_QUAL_REG_QUALIF_DTYPE_MASK (0x00000F00u)
#define CSL_CP_TRACER_TRANS_QUAL_REG_QUALIF_DTYPE_SHIFT (0x00000008u)
#define CSL_CP_TRACER_TRANS_QUAL_REG_QUALIF_DTYPE_RESETVAL (0x00000000u)

#define CSL_CP_TRACER_TRANS_QUAL_REG_QUALIF_DT0_MASK (0x0000F000u)
#define CSL_CP_TRACER_TRANS_QUAL_REG_QUALIF_DT0_SHIFT (0x0000000Cu)
#define CSL_CP_TRACER_TRANS_QUAL_REG_QUALIF_DT0_RESETVAL (0x00000000u)

#define CSL_CP_TRACER_TRANS_QUAL_REG_QUALIF_DT1_MASK (0x000F0000u)
#define CSL_CP_TRACER_TRANS_QUAL_REG_QUALIF_DT1_SHIFT (0x00000010u)
#define CSL_CP_TRACER_TRANS_QUAL_REG_QUALIF_DT1_RESETVAL (0x00000000u)

#define CSL_CP_TRACER_TRANS_QUAL_REG_QUALIF_DT_TRIG_MASK (0x00F00000u)
#define CSL_CP_TRACER_TRANS_QUAL_REG_QUALIF_DT_TRIG_SHIFT (0x00000014u)
#define CSL_CP_TRACER_TRANS_QUAL_REG_QUALIF_DT_TRIG_RESETVAL (0x00000000u)

#define CSL_CP_TRACER_TRANS_QUAL_REG_QUALIF_EMU_MASK (0x01000000u)
#define CSL_CP_TRACER_TRANS_QUAL_REG_QUALIF_EMU_SHIFT (0x00000018u)
#define CSL_CP_TRACER_TRANS_QUAL_REG_QUALIF_EMU_RESETVAL (0x00000000u)

#define CSL_CP_TRACER_TRANS_QUAL_REG_EMU_STATUS_MASK (0x02000000u)
#define CSL_CP_TRACER_TRANS_QUAL_REG_EMU_STATUS_SHIFT (0x00000019u)
#define CSL_CP_TRACER_TRANS_QUAL_REG_EMU_STATUS_RESETVAL (0x00000001u)

#define CSL_CP_TRACER_TRANS_QUAL_REG_EMU1_TRIGGER_MASK (0x04000000u)
#define CSL_CP_TRACER_TRANS_QUAL_REG_EMU1_TRIGGER_SHIFT (0x0000001Au)
#define CSL_CP_TRACER_TRANS_QUAL_REG_EMU1_TRIGGER_RESETVAL (0x00000000u)

#define CSL_CP_TRACER_TRANS_QUAL_REG_EMU0_TRIGGER_MASK (0x08000000u)
#define CSL_CP_TRACER_TRANS_QUAL_REG_EMU0_TRIGGER_SHIFT (0x0000001Bu)
#define CSL_CP_TRACER_TRANS_QUAL_REG_EMU0_TRIGGER_RESETVAL (0x00000000u)

#define CSL_CP_TRACER_TRANS_QUAL_REG_RESETVAL (0x02000000u)

/* ctrl_and_status_reg */

#define CSL_CP_TRACER_CTRL_AND_STATUS_REG_CP_TRACER_ID_MASK (0x0000001Fu)
#define CSL_CP_TRACER_CTRL_AND_STATUS_REG_CP_TRACER_ID_SHIFT (0x00000000u)
#define CSL_CP_TRACER_CTRL_AND_STATUS_REG_CP_TRACER_ID_RESETVAL (0x00000000u)

#define CSL_CP_TRACER_CTRL_AND_STATUS_REG_ADDR_MODE_MASK (0x000000E0u)
#define CSL_CP_TRACER_CTRL_AND_STATUS_REG_ADDR_MODE_SHIFT (0x00000005u)
#define CSL_CP_TRACER_CTRL_AND_STATUS_REG_ADDR_MODE_RESETVAL (0x00000000u)

#define CSL_CP_TRACER_CTRL_AND_STATUS_REG_EXPORT_SELECT_MASK (0x00001F00u)
#define CSL_CP_TRACER_CTRL_AND_STATUS_REG_EXPORT_SELECT_SHIFT (0x00000008u)
#define CSL_CP_TRACER_CTRL_AND_STATUS_REG_EXPORT_SELECT_RESETVAL (0x00000000u)

#define CSL_CP_TRACER_CTRL_AND_STATUS_REG_NUM_GRANT_CNT_EN_MASK (0x00002000u)
#define CSL_CP_TRACER_CTRL_AND_STATUS_REG_NUM_GRANT_CNT_EN_SHIFT (0x0000000Du)
#define CSL_CP_TRACER_CTRL_AND_STATUS_REG_NUM_GRANT_CNT_EN_RESETVAL (0x00000000u)

#define CSL_CP_TRACER_CTRL_AND_STATUS_REG_ACC_WAIT_CNT_EN_MASK (0x00004000u)
#define CSL_CP_TRACER_CTRL_AND_STATUS_REG_ACC_WAIT_CNT_EN_SHIFT (0x0000000Eu)
#define CSL_CP_TRACER_CTRL_AND_STATUS_REG_ACC_WAIT_CNT_EN_RESETVAL (0x00000000u)

#define CSL_CP_TRACER_CTRL_AND_STATUS_REG_EXCL_ADDR_FILTER_EN_MASK (0x00008000u)
#define CSL_CP_TRACER_CTRL_AND_STATUS_REG_EXCL_ADDR_FILTER_EN_SHIFT (0x0000000Fu)
#define CSL_CP_TRACER_CTRL_AND_STATUS_REG_EXCL_ADDR_FILTER_EN_RESETVAL (0x00000000u)

#define CSL_CP_TRACER_CTRL_AND_STATUS_REG_UPPER_ADDR_BITS_MASK (0xFFFF0000u)
#define CSL_CP_TRACER_CTRL_AND_STATUS_REG_UPPER_ADDR_BITS_SHIFT (0x00000010u)
#define CSL_CP_TRACER_CTRL_AND_STATUS_REG_UPPER_ADDR_BITS_RESETVAL (0x00000000u)

#define CSL_CP_TRACER_CTRL_AND_STATUS_REG_RESETVAL (0x00000000u)

/* sldg_time_window_reg */

#define CSL_CP_TRACER_SLDG_TIME_WINDOW_REG_SLDG_TIME_WINDOW_MASK (0xFFFFFFFFu)
#define CSL_CP_TRACER_SLDG_TIME_WINDOW_REG_SLDG_TIME_WINDOW_SHIFT (0x00000000u)
#define CSL_CP_TRACER_SLDG_TIME_WINDOW_REG_SLDG_TIME_WINDOW_RESETVAL (0xFFFFFFFFu)

#define CSL_CP_TRACER_SLDG_TIME_WINDOW_REG_RESETVAL (0xFFFFFFFFu)

/* mstid_sela_th0_reg */

#define CSL_CP_TRACER_MSTID_SELA_TH0_REG_MSTID_SELA_TH0_MASK (0xFFFFFFFFu)
#define CSL_CP_TRACER_MSTID_SELA_TH0_REG_MSTID_SELA_TH0_SHIFT (0x00000000u)
#define CSL_CP_TRACER_MSTID_SELA_TH0_REG_MSTID_SELA_TH0_RESETVAL (0x00000000u)

#define CSL_CP_TRACER_MSTID_SELA_TH0_REG_RESETVAL (0x00000000u)

/* mstid_selb_th0_reg */

#define CSL_CP_TRACER_MSTID_SELB_TH0_REG_MSTID_SELB_TH0_MASK (0xFFFFFFFFu)
#define CSL_CP_TRACER_MSTID_SELB_TH0_REG_MSTID_SELB_TH0_SHIFT (0x00000000u)
#define CSL_CP_TRACER_MSTID_SELB_TH0_REG_MSTID_SELB_TH0_RESETVAL (0x00000000u)

#define CSL_CP_TRACER_MSTID_SELB_TH0_REG_RESETVAL (0x00000000u)

/* mstid_selc_th0_reg */

#define CSL_CP_TRACER_MSTID_SELC_TH0_REG_MSTID_SELC_TH0_MASK (0xFFFFFFFFu)
#define CSL_CP_TRACER_MSTID_SELC_TH0_REG_MSTID_SELC_TH0_SHIFT (0x00000000u)
#define CSL_CP_TRACER_MSTID_SELC_TH0_REG_MSTID_SELC_TH0_RESETVAL (0x00000000u)

#define CSL_CP_TRACER_MSTID_SELC_TH0_REG_RESETVAL (0x00000000u)

/* mstid_seld_th0_reg */

#define CSL_CP_TRACER_MSTID_SELD_TH0_REG_MSTID_SELD_TH0_MASK (0xFFFFFFFFu)
#define CSL_CP_TRACER_MSTID_SELD_TH0_REG_MSTID_SELD_TH0_SHIFT (0x00000000u)
#define CSL_CP_TRACER_MSTID_SELD_TH0_REG_MSTID_SELD_TH0_RESETVAL (0x00000000u)

#define CSL_CP_TRACER_MSTID_SELD_TH0_REG_RESETVAL (0x00000000u)

/* mstid_sela_th1_reg */

#define CSL_CP_TRACER_MSTID_SELA_TH1_REG_MSTID_SELA_TH1_MASK (0xFFFFFFFFu)
#define CSL_CP_TRACER_MSTID_SELA_TH1_REG_MSTID_SELA_TH1_SHIFT (0x00000000u)
#define CSL_CP_TRACER_MSTID_SELA_TH1_REG_MSTID_SELA_TH1_RESETVAL (0x00000000u)

#define CSL_CP_TRACER_MSTID_SELA_TH1_REG_RESETVAL (0x00000000u)

/* mstid_selb_th1_reg */

#define CSL_CP_TRACER_MSTID_SELB_TH1_REG_MSTID_SELB_TH1_MASK (0xFFFFFFFFu)
#define CSL_CP_TRACER_MSTID_SELB_TH1_REG_MSTID_SELB_TH1_SHIFT (0x00000000u)
#define CSL_CP_TRACER_MSTID_SELB_TH1_REG_MSTID_SELB_TH1_RESETVAL (0x00000000u)

#define CSL_CP_TRACER_MSTID_SELB_TH1_REG_RESETVAL (0x00000000u)

/* mstid_selc_th1_reg */

#define CSL_CP_TRACER_MSTID_SELC_TH1_REG_MSTID_SELC_TH1_MASK (0xFFFFFFFFu)
#define CSL_CP_TRACER_MSTID_SELC_TH1_REG_MSTID_SELC_TH1_SHIFT (0x00000000u)
#define CSL_CP_TRACER_MSTID_SELC_TH1_REG_MSTID_SELC_TH1_RESETVAL (0x00000000u)

#define CSL_CP_TRACER_MSTID_SELC_TH1_REG_RESETVAL (0x00000000u)

/* mstid_seld_th1_reg */

#define CSL_CP_TRACER_MSTID_SELD_TH1_REG_MSTID_SELD_TH1_MASK (0xFFFFFFFFu)
#define CSL_CP_TRACER_MSTID_SELD_TH1_REG_MSTID_SELD_TH1_SHIFT (0x00000000u)
#define CSL_CP_TRACER_MSTID_SELD_TH1_REG_MSTID_SELD_TH1_RESETVAL (0x00000000u)

#define CSL_CP_TRACER_MSTID_SELD_TH1_REG_RESETVAL (0x00000000u)

/* end_address_reg */

#define CSL_CP_TRACER_END_ADDRESS_REG_END_ADDRESS_MASK (0xFFFFFFFFu)
#define CSL_CP_TRACER_END_ADDRESS_REG_END_ADDRESS_SHIFT (0x00000000u)
#define CSL_CP_TRACER_END_ADDRESS_REG_END_ADDRESS_RESETVAL (0x00000000u)

#define CSL_CP_TRACER_END_ADDRESS_REG_RESETVAL (0x00000000u)

/* start_address_reg */

#define CSL_CP_TRACER_START_ADDRESS_REG_START_ADDRESS_MASK (0xFFFFFFFFu)
#define CSL_CP_TRACER_START_ADDRESS_REG_START_ADDRESS_SHIFT (0x00000000u)
#define CSL_CP_TRACER_START_ADDRESS_REG_START_ADDRESS_RESETVAL (0x00000000u)

#define CSL_CP_TRACER_START_ADDRESS_REG_RESETVAL (0x00000000u)

/* access_status_reg */

#define CSL_CP_TRACER_ACCESS_STATUS_REG_ACCESS_STATUS_MASK (0xFFFFFFFFu)
#define CSL_CP_TRACER_ACCESS_STATUS_REG_ACCESS_STATUS_SHIFT (0x00000000u)
#define CSL_CP_TRACER_ACCESS_STATUS_REG_ACCESS_STATUS_RESETVAL (0x00000000u)

#define CSL_CP_TRACER_ACCESS_STATUS_REG_RESETVAL (0x00000000u)

/* access_status_pacing_reg */

#define CSL_CP_TRACER_ACCESS_STATUS_PACING_REG_ACCESS_STATUS_PACING_MASK (0x00FFFFFFu)
#define CSL_CP_TRACER_ACCESS_STATUS_PACING_REG_ACCESS_STATUS_PACING_SHIFT (0x00000000u)
#define CSL_CP_TRACER_ACCESS_STATUS_PACING_REG_ACCESS_STATUS_PACING_RESETVAL (0x00000000u)

#define CSL_CP_TRACER_ACCESS_STATUS_PACING_REG_RESETVAL (0x00000000u)

/* address_mask_reg */

#define CSL_CP_TRACER_ADDRESS_MASK_REG_ADDR_BITS_SEL_MASK (0x0000003Fu)
#define CSL_CP_TRACER_ADDRESS_MASK_REG_ADDR_BITS_SEL_SHIFT (0x00000000u)
#define CSL_CP_TRACER_ADDRESS_MASK_REG_ADDR_BITS_SEL_RESETVAL (0x00000000u)

#define CSL_CP_TRACER_ADDRESS_MASK_REG_RESETVAL (0x00000000u)

/* dest_address_reg */

#define CSL_CP_TRACER_DEST_ADDRESS_REG_DEST_ADDRESS_MASK (0xFFFFFFFCu)
#define CSL_CP_TRACER_DEST_ADDRESS_REG_DEST_ADDRESS_SHIFT (0x00000002u)
#define CSL_CP_TRACER_DEST_ADDRESS_REG_DEST_ADDRESS_RESETVAL (0x00000000u)

#define CSL_CP_TRACER_DEST_ADDRESS_REG_RESETVAL (0x00000000u)

/* msg_prio_reg */

#define CSL_CP_TRACER_MSG_PRIO_REG_ACCESS_MSG_PRIO_MASK (0x00000007u)
#define CSL_CP_TRACER_MSG_PRIO_REG_ACCESS_MSG_PRIO_SHIFT (0x00000000u)
#define CSL_CP_TRACER_MSG_PRIO_REG_ACCESS_MSG_PRIO_RESETVAL (0x00000007u)

#define CSL_CP_TRACER_MSG_PRIO_REG_EVENT_B_MSG_PRIO_MASK (0x00000038u)
#define CSL_CP_TRACER_MSG_PRIO_REG_EVENT_B_MSG_PRIO_SHIFT (0x00000003u)
#define CSL_CP_TRACER_MSG_PRIO_REG_EVENT_B_MSG_PRIO_RESETVAL (0x00000007u)

#define CSL_CP_TRACER_MSG_PRIO_REG_EVENT_C_MSG_PRIO_MASK (0x000001C0u)
#define CSL_CP_TRACER_MSG_PRIO_REG_EVENT_C_MSG_PRIO_SHIFT (0x00000006u)
#define CSL_CP_TRACER_MSG_PRIO_REG_EVENT_C_MSG_PRIO_RESETVAL (0x00000007u)

#define CSL_CP_TRACER_MSG_PRIO_REG_EVENT_E_MSG_PRIO_MASK (0x00000E00u)
#define CSL_CP_TRACER_MSG_PRIO_REG_EVENT_E_MSG_PRIO_SHIFT (0x00000009u)
#define CSL_CP_TRACER_MSG_PRIO_REG_EVENT_E_MSG_PRIO_RESETVAL (0x00000007u)

#define CSL_CP_TRACER_MSG_PRIO_REG_STAT_MSG_PRIO_MASK (0x00007000u)
#define CSL_CP_TRACER_MSG_PRIO_REG_STAT_MSG_PRIO_SHIFT (0x0000000Cu)
#define CSL_CP_TRACER_MSG_PRIO_REG_STAT_MSG_PRIO_RESETVAL (0x00000007u)

#define CSL_CP_TRACER_MSG_PRIO_REG_RESETVAL (0x00007FFFu)

/* ownership_reg */

#define CSL_CP_TRACER_OWNERSHIP_REG_OWNERSHIP_MASK (0x00000001u)
#define CSL_CP_TRACER_OWNERSHIP_REG_OWNERSHIP_SHIFT (0x00000000u)
#define CSL_CP_TRACER_OWNERSHIP_REG_OWNERSHIP_RESETVAL (0x00000000u)

#define CSL_CP_TRACER_OWNERSHIP_REG_RESETVAL (0x00000000u)

/* throughput0_reg */

#define CSL_CP_TRACER_THROUGHPUT0_REG_THROUGHPUT0_MASK (0x00FFFFFFu)
#define CSL_CP_TRACER_THROUGHPUT0_REG_THROUGHPUT0_SHIFT (0x00000000u)
#define CSL_CP_TRACER_THROUGHPUT0_REG_THROUGHPUT0_RESETVAL (0x00000000u)

#define CSL_CP_TRACER_THROUGHPUT0_REG_RESETVAL (0x00000000u)

/* throughput1_reg */

#define CSL_CP_TRACER_THROUGHPUT1_REG_THROUGHPUT1_MASK (0x00FFFFFFu)
#define CSL_CP_TRACER_THROUGHPUT1_REG_THROUGHPUT1_SHIFT (0x00000000u)
#define CSL_CP_TRACER_THROUGHPUT1_REG_THROUGHPUT1_RESETVAL (0x00000000u)

#define CSL_CP_TRACER_THROUGHPUT1_REG_RESETVAL (0x00000000u)

/* acc_wait_time_reg */

#define CSL_CP_TRACER_ACC_WAIT_TIME_REG_ACC_WAIT_TIME_MASK (0x00FFFFFFu)
#define CSL_CP_TRACER_ACC_WAIT_TIME_REG_ACC_WAIT_TIME_SHIFT (0x00000000u)
#define CSL_CP_TRACER_ACC_WAIT_TIME_REG_ACC_WAIT_TIME_RESETVAL (0x00000000u)

#define CSL_CP_TRACER_ACC_WAIT_TIME_REG_RESETVAL (0x00000000u)

/* num_grant_reg */

#define CSL_CP_TRACER_NUM_GRANT_REG_NUM_GRANT_MASK (0x00FFFFFFu)
#define CSL_CP_TRACER_NUM_GRANT_REG_NUM_GRANT_SHIFT (0x00000000u)
#define CSL_CP_TRACER_NUM_GRANT_REG_NUM_GRANT_RESETVAL (0x00000000u)

#define CSL_CP_TRACER_NUM_GRANT_REG_RESETVAL (0x00000000u)

/* intr_raw_status_reg */

#define CSL_CP_TRACER_INTR_RAW_STATUS_REG_INTR_STATUS_RAW_MASK (0x00000001u)
#define CSL_CP_TRACER_INTR_RAW_STATUS_REG_INTR_STATUS_RAW_SHIFT (0x00000000u)
#define CSL_CP_TRACER_INTR_RAW_STATUS_REG_INTR_STATUS_RAW_RESETVAL (0x00000000u)

#define CSL_CP_TRACER_INTR_RAW_STATUS_REG_RESETVAL (0x00000000u)

/* intr_masked_status_reg */

#define CSL_CP_TRACER_INTR_MASKED_STATUS_REG_INTR_STATUS_MSKD_MASK (0x00000001u)
#define CSL_CP_TRACER_INTR_MASKED_STATUS_REG_INTR_STATUS_MSKD_SHIFT (0x00000000u)
#define CSL_CP_TRACER_INTR_MASKED_STATUS_REG_INTR_STATUS_MSKD_RESETVAL (0x00000000u)

#define CSL_CP_TRACER_INTR_MASKED_STATUS_REG_RESETVAL (0x00000000u)

/* intr_mask_set_reg */

#define CSL_CP_TRACER_INTR_MASK_SET_REG_INTR_MASK_SET_MASK (0x00000001u)
#define CSL_CP_TRACER_INTR_MASK_SET_REG_INTR_MASK_SET_SHIFT (0x00000000u)
#define CSL_CP_TRACER_INTR_MASK_SET_REG_INTR_MASK_SET_RESETVAL (0x00000000u)

#define CSL_CP_TRACER_INTR_MASK_SET_REG_RESETVAL (0x00000000u)

/* intr_mask_clear_reg */

#define CSL_CP_TRACER_INTR_MASK_CLEAR_REG_INTR_MASK_CLEAR_MASK (0x00000001u)
#define CSL_CP_TRACER_INTR_MASK_CLEAR_REG_INTR_MASK_CLEAR_SHIFT (0x00000000u)
#define CSL_CP_TRACER_INTR_MASK_CLEAR_REG_INTR_MASK_CLEAR_RESETVAL (0x00000000u)

#define CSL_CP_TRACER_INTR_MASK_CLEAR_REG_RESETVAL (0x00000000u)

/* eoi_reg */

#define CSL_CP_TRACER_EOI_REG_EOI_VECTOR_MASK (0x000000FFu)
#define CSL_CP_TRACER_EOI_REG_EOI_VECTOR_SHIFT (0x00000000u)
#define CSL_CP_TRACER_EOI_REG_EOI_VECTOR_RESETVAL (0x00000000u)

#define CSL_CP_TRACER_EOI_REG_RESETVAL   (0x00000000u)

#endif
