# ******************************************************************************
# * FILE PURPOSE: PDK Unit Test and Example Project Creator
# ******************************************************************************
# * FILE NAME: pdkProjectCreate.bat
# *
# * DESCRIPTION: 
# *  The script file is used to create the test and example projects of all
# *  components under PDK. These projects are available in the specified 
# *  workspace.
# *
# * USAGE:
# *  pdkProjectCreate.bat "C:\Program Files\Texas Instruments\pdk_C6670_1_1_1_4\packages"
# *      --- OR ---
# *  pdkProjectCreate.bat
# *
# *
# * Copyright (C) 2010, Texas Instruments, Inc.
# *****************************************************************************


export PDK_SHORT_NAME=$PWD


# *****************************************************************************
# * Version Information of the various tools etc required to build the test
# * projects. Customers are free to modify these to meet their requi#ents.
# *****************************************************************************

# This is to control the CCS version specific project create command
# export to 'no' when using CCSv5 or export to 'yes' when using CCSv4
export IS_CCS_VERSION_4=no

# export to 'no' when using QT, EVM, VDB, or other hardware. export to 'yes' only when using the simulator.
export IS_SIMULATOR_SUPPORT_NEEDED=no

# Install Location for CCS
export CCS_INSTALL_PATH=~/ti/ccsv5

# Workspace where the PDK projects will be created.
export MY_WORKSPACE=$PDK_SHORT_NAME/exampleProjects

# This is Endianess of the Projects being created.
# Valid Values are 'little' and 'big'
export ENDIAN=little

# This is the format of the executable being created
# Valid Values are 'ELF' and 'COFF'
export OUTPUT_FORMAT=ELF

# Version of CG-Tools
export CGT_VERSION=7.4.0

# Version of XDC
export XDC_VERSION=3.23.04.60

# Version of BIOS
export BIOS_VERSION=6.33.06.50

# Version of the IPC
export IPC_VERSION=1.24.03.32

# EDMA3 Version 
export EDMA_VERSION=02.11.05

# Version of the PDK
export PDK_VERSION=1.1.2.5

# PDK Part Number
export PDK_PARTNO=C6678L

# RTSC Platform Name
export RTSC_PLATFORM_NAME=ti.platforms.evm6678

# RTSC Target 
# - Please ensure that you select this taking into account the
#   OUTPUT_FORMAT and the RTSC_PLATFORM_NAME 
# RTSC_TARGET=ti.targets.elf.C66_big_endian
export RTSC_TARGET=ti.targets.elf.C66

# *****************************************************************************
# *****************************************************************************
#                 Please do NOT change anything below this
# *****************************************************************************
# *****************************************************************************

# export auto create command by default for use with CCSv5
export AUTO_CREATE_COMMAND=eclipse/ccstudio

# If is CCS version 4 then export auto create command for use with CCSv4
# If .%IS_CCS_VERSION_4% == .yes export AUTO_CREATE_COMMAND=eclipse\jre\bin\java -jar $CCS_INSTALL_PATH\eclipse\startup.jar

# export project for Silicon or QT by default
export SIMULATOR_SUPPORT_DEFINE=

ccs_create()
{
	echo found $1
	textfile=${1#*/}
	$CCS_INSTALL_PATH/$AUTO_CREATE_COMMAND -nosplash -data $MY_WORKSPACE -application com.ti.ccstudio.apps.projectCreate -ccs.name ${textfile%.*} -ccs.outputFormat $OUTPUT_FORMAT -ccs.device com.ti.ccstudio.deviceModel.C6000.GenericC66xxDevice -ccs.endianness $ENDIAN -ccs.kind executable -ccs.cgtVersion $CGT_VERSION -rtsc.xdcVersion $XDC_VERSION -rtsc.enableDspBios -rtsc.biosVersion $BIOS_VERSION -rtsc.buildProfile "debug" -rtsc.products "com.ti.sdo.edma3:$EDMA_VERSION;com.ti.rtsc.IPC:$IPC_VERSION;com.ti.rtsc.SYSBIOS:$BIOS_VERSION;com.ti.biosmcsdk.pdk.$PDK_PARTNO:$PDK_VERSION" -rtsc.platform "$RTSC_PLATFORM_NAME" -rtsc.target $RTSC_TARGET -ccs.rts libc.a -ccs.args $textfile \;
}		

export -f ccs_create

find -name "*roject.txt" -execdir bash -c 'ccs_create {}' \;




