/******************************************************************************
 * FILE PURPOSE: TSIP Source module specification file.
 ******************************************************************************
 * FILE NAME: module.xs
 *
 * DESCRIPTION: 
 *  This file contains the module specification for TSIP LLD test files.
 *
 * Copyright (C) 2010, Texas Instruments, Inc.
 *****************************************************************************/

/* Load the library utility. */
var libUtility = xdc.loadCapsule ("../build/buildlib.xs");

/**************************************************************************
 * FUNCTION NAME : modBuild
 **************************************************************************
 * DESCRIPTION   :
 *  The function is used to add all the source files in the test 
 *  directory into the package.
 **************************************************************************/
function modBuild() 
{
    /* Add all the .c files to the release package. */
    var testFiles = libUtility.listAllFiles (".c", "test", true);
    for (var k = 0 ; k < testFiles.length; k++)
        Pkg.otherFiles[Pkg.otherFiles.length++] = testFiles[k];

    /* Add all the .h files to the release package. */
    var testFiles = libUtility.listAllFiles (".h", "test", true);
    for (var k = 0 ; k < testFiles.length; k++)
        Pkg.otherFiles[Pkg.otherFiles.length++] = testFiles[k];

    /* Add all the .cmd files to the release package. */
    var testFiles = libUtility.listAllFiles (".cmd", "test", true);
    for (var k = 0 ; k < testFiles.length; k++)
        Pkg.otherFiles[Pkg.otherFiles.length++] = testFiles[k];

    /* Add all the .cfg files to the release package. */
    var testFiles = libUtility.listAllFiles (".cfg", "test", true);
    for (var k = 0 ; k < testFiles.length; k++)
        Pkg.otherFiles[Pkg.otherFiles.length++] = testFiles[k];


    /* add project.txt */
    Pkg.otherFiles[Pkg.otherFiles.length++] = "test/TSIP_testProject.txt";
                                                     
    /* Add example project related files. */                     
/*
    Pkg.otherFiles[Pkg.otherFiles.length++] = "test/LE/TestProject_LE/.ccsproject";
    Pkg.otherFiles[Pkg.otherFiles.length++] = "test/LE/TestProject_LE/.cdtproject";
    Pkg.otherFiles[Pkg.otherFiles.length++] = "test/LE/TestProject_LE/.project";
    Pkg.otherFiles[Pkg.otherFiles.length++] = "test/LE/TestProject_LE/.cdtbuild";

    Pkg.otherFiles[Pkg.otherFiles.length++] = "test/BE/TestProject_BE/.ccsproject";
    Pkg.otherFiles[Pkg.otherFiles.length++] = "test/BE/TestProject_BE/.cdtproject";
    Pkg.otherFiles[Pkg.otherFiles.length++] = "test/BE/TestProject_BE/.project";
    Pkg.otherFiles[Pkg.otherFiles.length++] = "test/BE/TestProject_BE/.cdtbuild";

    Pkg.otherFiles[Pkg.otherFiles.length++] = "test/LE/TestProject_LEConfig/.ccsproject";
    Pkg.otherFiles[Pkg.otherFiles.length++] = "test/LE/TestProject_LEConfig/.cdtproject";
    Pkg.otherFiles[Pkg.otherFiles.length++] = "test/LE/TestProject_LEConfig/.project";
    Pkg.otherFiles[Pkg.otherFiles.length++] = "test/LE/TestProject_LEConfig/.cdtbuild";

    Pkg.otherFiles[Pkg.otherFiles.length++] = "test/BE/TestProject_BEConfig/.ccsproject";
    Pkg.otherFiles[Pkg.otherFiles.length++] = "test/BE/TestProject_BEConfig/.cdtproject";
    Pkg.otherFiles[Pkg.otherFiles.length++] = "test/BE/TestProject_BEConfig/.project";
    Pkg.otherFiles[Pkg.otherFiles.length++] = "test/BE/TestProject_BEConfig/.cdtbuild";
*/

}

