
#include <c6x.h>
#include <xdc/std.h>
#include <xdc/runtime/System.h>

#include <ti/csl/cslr_device.h>

#include "ti/drv/rm/test/rm_test.h"

Void main (Void)
{
    Rm_Result ret_val;
    Rm_Handle rm_handle;


    rm_test_expect_e expect;

    System_printf ("*********************************************************\n");
    System_printf ("******************* RM LLD Testing **********************\n");
    System_printf ("*********************************************************\n");

    System_printf ("RM Version : 0x%08x\nVersion String: %s\n", Rm_getVersion(), Rm_getVersionStr());

    if (DNUM == 0) {
        expect = rm_granted;
    } else {
        expect = rm_denied;
    }

    if (DNUM == 0) {
		ret_val = Rm_init(rmTestResourceTable);
		if (ret_val < 0) {
			System_printf ("Rm_init failed error code : %d\n", ret_val);
			return;
		}
    } else {
        Rm_start();
    }

    rm_handle = Rm_getHandle();
    if (!rm_handle) {
        System_printf ("Rm_getHandle returned NULL\n");
        return;
    }

    System_printf ("Testing QMSS\n");
    rm_test_qmss(rm_handle, expect);
    
    System_printf ("Testing CPPI\n");
    rm_test_cppi(rm_handle, expect);

#ifndef _C6657_Atrenta_DSP1_H_  /* C6657 does not have PA */
    System_printf ("Testing PA\n");
    rm_test_pa(rm_handle, expect);
#endif    
    
}
