/********************************************************************
* Copyright (C) 2003-2008 Texas Instruments Incorporated.
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/
#ifndef _CSLR_EMIF4F_H_
#define _CSLR_EMIF4F_H_

/* CSL Modification:
 *  The file has been modified from the AUTOGEN file for the following
 *  reasons:-
 *      a) Modified the header file includes to be RTSC compliant
 */
#include <ti/csl/cslr.h>
#include <ti/csl/tistdtypes.h>


/* Minimum unit = 1 byte */

/**************************************************************************\
* Register Overlay Structure
\**************************************************************************/
typedef struct  {
    volatile Uint32 EMIF_MOD_ID_REV;
    volatile Uint32 STATUS;
    volatile Uint32 SDRAM_CONFIG;
    volatile Uint32 SDRAM_CONFIG_2;
    volatile Uint32 SDRAM_REF_CTRL;
    volatile Uint32 SDRAM_REF_CTRL_SHDW;
    volatile Uint32 SDRAM_TIM_1;
    volatile Uint32 SDRAM_TIM_1_SHDW;
    volatile Uint32 SDRAM_TIM_2;
    volatile Uint32 SDRAM_TIM_2_SHDW;
    volatile Uint32 SDRAM_TIM_3;
    volatile Uint32 SDRAM_TIM_3_SHDW;
    volatile Uint32 LPDDR2_NVM_TIM;
    volatile Uint32 LPDDR2_NVM_TIM_SHDW;
    volatile Uint32 PWR_MGMT_CTRL;
    volatile Uint32 PWR_MGMT_CTRL_SHDW;
    volatile Uint32 LPDDR2_MODE_REG_DATA;
    volatile Uint8 RSVD0[12];
    volatile Uint32 LPDDR2_MODE_REG_CFG;
    volatile Uint32 VBUSM_CONFIG;
    volatile Uint32 VBUSM_CFG_VAL_1;
    volatile Uint32 VBUSM_CFG_VAL_2;
    volatile Uint32 IODFT_TLGC;
    volatile Uint32 IODFT_CTRL_MISR_RSLT;
    volatile Uint32 IODFT_ADDR_MISR_RSLT;
    volatile Uint32 IODFT_DATA_MISR_RSLT_1;
    volatile Uint32 IODFT_DATA_MISR_RSLT_2;
    volatile Uint32 IODFT_DATA_MISR_RSLT_3;
    volatile Uint32 IODFT_DATA_MISR_RSLT_4;
    volatile Uint32 IODFT_DATA_MISR_RSLT_5;
    volatile Uint32 PERF_CNT_1;
    volatile Uint32 PERF_CNT_2;
    volatile Uint32 PERF_CNT_CFG;
    volatile Uint32 PERF_CNT_SEL;
    volatile Uint32 PERF_CNT_TIM;
    volatile Uint8 RSVD1[4];
    volatile Uint32 READ_IDLE_CTRL;
    volatile Uint32 READ_IDLE_CTRL_SHDW;
    volatile Uint8 RSVD2[4];
    volatile Uint32 IRQSTATUS_RAW_SYS;
    volatile Uint8 RSVD3[4];
    volatile Uint32 IRQSTATUS_SYS;
    volatile Uint8 RSVD4[4];
    volatile Uint32 IRQENABLE_SET_SYS;
    volatile Uint8 RSVD5[4];
    volatile Uint32 IRQENABLE_CLR_SYS;
    volatile Uint8 RSVD6[8];
    volatile Uint32 ZQ_CONFIG;
    volatile Uint32 TEMP_ALERT_CONFIG;
    volatile Uint32 VBUSM_ERR_LOG;
    volatile Uint32 RDWR_LVL_RMP_WIN;
    volatile Uint32 RDWR_LVL_RMP_CTRL;
    volatile Uint32 RDWR_LVL_CTRL;
    volatile Uint8 RSVD7[4];
    volatile Uint32 DDR_PHY_CTRL_1;
    volatile Uint32 DDR_PHY_CTRL_1_SHDW;
    volatile Uint32 DDR_PHY_CTRL_2;
    volatile Uint8 RSVD8[16];
    volatile Uint32 PRI_COS_MAP;
    volatile Uint32 MSTID_COS_1_MAP;
    volatile Uint32 MSTID_COS_2_MAP;
    volatile Uint8 RSVD9[4];
    volatile Uint32 ECC_CTRL;
    volatile Uint32 ECC_ADDR_RNG_1;
    volatile Uint32 ECC_ADDR_RNG_2;
    volatile Uint8 RSVD10[4];
    volatile Uint32 RD_WR_EXEC_THRSH;
} CSL_Emif4fRegs;

/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* EMIF_MOD_ID_REV */

#define CSL_EMIF4F_EMIF_MOD_ID_REV_REG_SCHEME_MASK (0xC0000000u)
#define CSL_EMIF4F_EMIF_MOD_ID_REV_REG_SCHEME_SHIFT (0x0000001Eu)
#define CSL_EMIF4F_EMIF_MOD_ID_REV_REG_SCHEME_RESETVAL (0x00000001u)

#define CSL_EMIF4F_EMIF_MOD_ID_REV_REG_MODULE_ID_MASK (0x0FFF0000u)
#define CSL_EMIF4F_EMIF_MOD_ID_REV_REG_MODULE_ID_SHIFT (0x00000010u)
#define CSL_EMIF4F_EMIF_MOD_ID_REV_REG_MODULE_ID_RESETVAL (0x00000046u)

#define CSL_EMIF4F_EMIF_MOD_ID_REV_REG_RTL_VERSION_MASK (0x0000F800u)
#define CSL_EMIF4F_EMIF_MOD_ID_REV_REG_RTL_VERSION_SHIFT (0x0000000Bu)
#define CSL_EMIF4F_EMIF_MOD_ID_REV_REG_RTL_VERSION_RESETVAL (0x00000010u)

#define CSL_EMIF4F_EMIF_MOD_ID_REV_REG_MAJOR_REVISION_MASK (0x00000700u)
#define CSL_EMIF4F_EMIF_MOD_ID_REV_REG_MAJOR_REVISION_SHIFT (0x00000008u)
#define CSL_EMIF4F_EMIF_MOD_ID_REV_REG_MAJOR_REVISION_RESETVAL (0x00000004u)

#define CSL_EMIF4F_EMIF_MOD_ID_REV_REG_MINOR_REVISION_MASK (0x0000003Fu)
#define CSL_EMIF4F_EMIF_MOD_ID_REV_REG_MINOR_REVISION_SHIFT (0x00000000u)
#define CSL_EMIF4F_EMIF_MOD_ID_REV_REG_MINOR_REVISION_RESETVAL (0x00000000u)

#define CSL_EMIF4F_EMIF_MOD_ID_REV_RESETVAL (0x40468400u)

/* STATUS */

#define CSL_EMIF4F_STATUS_REG_BE_MASK    (0x80000000u)
#define CSL_EMIF4F_STATUS_REG_BE_SHIFT   (0x0000001Fu)

#define CSL_EMIF4F_STATUS_REG_DUAL_CLK_MODE_MASK (0x40000000u)
#define CSL_EMIF4F_STATUS_REG_DUAL_CLK_MODE_SHIFT (0x0000001Eu)

#define CSL_EMIF4F_STATUS_REG_FAST_INIT_MASK (0x20000000u)
#define CSL_EMIF4F_STATUS_REG_FAST_INIT_SHIFT (0x0000001Du)

#define CSL_EMIF4F_STATUS_REG_RDLVLGATETO_MASK (0x00000040u)
#define CSL_EMIF4F_STATUS_REG_RDLVLGATETO_SHIFT (0x00000006u)
#define CSL_EMIF4F_STATUS_REG_RDLVLGATETO_RESETVAL (0x00000000u)

#define CSL_EMIF4F_STATUS_REG_RDLVLTO_MASK (0x00000020u)
#define CSL_EMIF4F_STATUS_REG_RDLVLTO_SHIFT (0x00000005u)
#define CSL_EMIF4F_STATUS_REG_RDLVLTO_RESETVAL (0x00000000u)

#define CSL_EMIF4F_STATUS_REG_WRLVLTO_MASK (0x00000010u)
#define CSL_EMIF4F_STATUS_REG_WRLVLTO_SHIFT (0x00000004u)
#define CSL_EMIF4F_STATUS_REG_WRLVLTO_RESETVAL (0x00000000u)

#define CSL_EMIF4F_STATUS_REG_PHY_DLL_READY_MASK (0x00000004u)
#define CSL_EMIF4F_STATUS_REG_PHY_DLL_READY_SHIFT (0x00000002u)

#define CSL_EMIF4F_STATUS_RESETVAL       (0x00000000u)

/* SDRAM_CONFIG */

#define CSL_EMIF4F_SDRAM_CONFIG_REG_SDRAM_TYPE_MASK (0xE0000000u)
#define CSL_EMIF4F_SDRAM_CONFIG_REG_SDRAM_TYPE_SHIFT (0x0000001Du)

#define CSL_EMIF4F_SDRAM_CONFIG_REG_IBANK_POS_MASK (0x18000000u)
#define CSL_EMIF4F_SDRAM_CONFIG_REG_IBANK_POS_SHIFT (0x0000001Bu)

#define CSL_EMIF4F_SDRAM_CONFIG_REG_DDR_TERM_MASK (0x07000000u)
#define CSL_EMIF4F_SDRAM_CONFIG_REG_DDR_TERM_SHIFT (0x00000018u)

#define CSL_EMIF4F_SDRAM_CONFIG_REG_DDR2_DDQS_MASK (0x00800000u)
#define CSL_EMIF4F_SDRAM_CONFIG_REG_DDR2_DDQS_SHIFT (0x00000017u)

#define CSL_EMIF4F_SDRAM_CONFIG_REG_DYN_ODT_MASK (0x00600000u)
#define CSL_EMIF4F_SDRAM_CONFIG_REG_DYN_ODT_SHIFT (0x00000015u)

#define CSL_EMIF4F_SDRAM_CONFIG_REG_DDR_DISABLE_DLL_MASK (0x00100000u)
#define CSL_EMIF4F_SDRAM_CONFIG_REG_DDR_DISABLE_DLL_SHIFT (0x00000014u)

#define CSL_EMIF4F_SDRAM_CONFIG_REG_SDRAM_DRIVE_MASK (0x000C0000u)
#define CSL_EMIF4F_SDRAM_CONFIG_REG_SDRAM_DRIVE_SHIFT (0x00000012u)

#define CSL_EMIF4F_SDRAM_CONFIG_REG_CWL_MASK (0x00030000u)
#define CSL_EMIF4F_SDRAM_CONFIG_REG_CWL_SHIFT (0x00000010u)

#define CSL_EMIF4F_SDRAM_CONFIG_REG_NARROW_MODE_MASK (0x0000C000u)
#define CSL_EMIF4F_SDRAM_CONFIG_REG_NARROW_MODE_SHIFT (0x0000000Eu)

#define CSL_EMIF4F_SDRAM_CONFIG_REG_CL_MASK (0x00003C00u)
#define CSL_EMIF4F_SDRAM_CONFIG_REG_CL_SHIFT (0x0000000Au)

#define CSL_EMIF4F_SDRAM_CONFIG_REG_ROWSIZE_MASK (0x00000380u)
#define CSL_EMIF4F_SDRAM_CONFIG_REG_ROWSIZE_SHIFT (0x00000007u)

#define CSL_EMIF4F_SDRAM_CONFIG_REG_IBANK_MASK (0x00000070u)
#define CSL_EMIF4F_SDRAM_CONFIG_REG_IBANK_SHIFT (0x00000004u)

#define CSL_EMIF4F_SDRAM_CONFIG_REG_EBANK_MASK (0x00000008u)
#define CSL_EMIF4F_SDRAM_CONFIG_REG_EBANK_SHIFT (0x00000003u)

#define CSL_EMIF4F_SDRAM_CONFIG_REG_PAGESIZE_MASK (0x00000007u)
#define CSL_EMIF4F_SDRAM_CONFIG_REG_PAGESIZE_SHIFT (0x00000000u)

#define CSL_EMIF4F_SDRAM_CONFIG_RESETVAL (0x00000000u)

/* SDRAM_CONFIG_2 */

#define CSL_EMIF4F_SDRAM_CONFIG_2_REG_CS1NVMEN_MASK (0x40000000u)
#define CSL_EMIF4F_SDRAM_CONFIG_2_REG_CS1NVMEN_SHIFT (0x0000001Eu)

#define CSL_EMIF4F_SDRAM_CONFIG_2_REG_EBANK_POS_MASK (0x08000000u)
#define CSL_EMIF4F_SDRAM_CONFIG_2_REG_EBANK_POS_SHIFT (0x0000001Bu)
#define CSL_EMIF4F_SDRAM_CONFIG_2_REG_EBANK_POS_RESETVAL (0x00000000u)

#define CSL_EMIF4F_SDRAM_CONFIG_2_REG_RDBNUM_MASK (0x00000030u)
#define CSL_EMIF4F_SDRAM_CONFIG_2_REG_RDBNUM_SHIFT (0x00000004u)

#define CSL_EMIF4F_SDRAM_CONFIG_2_REG_RDBSIZE_MASK (0x00000007u)
#define CSL_EMIF4F_SDRAM_CONFIG_2_REG_RDBSIZE_SHIFT (0x00000000u)

#define CSL_EMIF4F_SDRAM_CONFIG_2_RESETVAL (0x00000000u)

/* SDRAM_REF_CTRL */

#define CSL_EMIF4F_SDRAM_REF_CTRL_REG_INITREF_DIS_MASK (0x80000000u)
#define CSL_EMIF4F_SDRAM_REF_CTRL_REG_INITREF_DIS_SHIFT (0x0000001Fu)

#define CSL_EMIF4F_SDRAM_REF_CTRL_REG_SRT_MASK (0x20000000u)
#define CSL_EMIF4F_SDRAM_REF_CTRL_REG_SRT_SHIFT (0x0000001Du)
#define CSL_EMIF4F_SDRAM_REF_CTRL_REG_SRT_RESETVAL (0x00000000u)

#define CSL_EMIF4F_SDRAM_REF_CTRL_REG_ASR_MASK (0x10000000u)
#define CSL_EMIF4F_SDRAM_REF_CTRL_REG_ASR_SHIFT (0x0000001Cu)
#define CSL_EMIF4F_SDRAM_REF_CTRL_REG_ASR_RESETVAL (0x00000000u)

#define CSL_EMIF4F_SDRAM_REF_CTRL_REG_PASR_MASK (0x07000000u)
#define CSL_EMIF4F_SDRAM_REF_CTRL_REG_PASR_SHIFT (0x00000018u)
#define CSL_EMIF4F_SDRAM_REF_CTRL_REG_PASR_RESETVAL (0x00000000u)

#define CSL_EMIF4F_SDRAM_REF_CTRL_REG_REFRESH_RATE_MASK (0x0000FFFFu)
#define CSL_EMIF4F_SDRAM_REF_CTRL_REG_REFRESH_RATE_SHIFT (0x00000000u)

#define CSL_EMIF4F_SDRAM_REF_CTRL_RESETVAL (0x00000000u)

/* SDRAM_REF_CTRL_SHDW */

#define CSL_EMIF4F_SDRAM_REF_CTRL_SHDW_REG_REFRESH_RATE_SHDW_MASK (0x0000FFFFu)
#define CSL_EMIF4F_SDRAM_REF_CTRL_SHDW_REG_REFRESH_RATE_SHDW_SHIFT (0x00000000u)

#define CSL_EMIF4F_SDRAM_REF_CTRL_SHDW_RESETVAL (0x00000000u)

/* SDRAM_TIM_1 */

#define CSL_EMIF4F_SDRAM_TIM_1_REG_T_RP_MASK (0x1E000000u)
#define CSL_EMIF4F_SDRAM_TIM_1_REG_T_RP_SHIFT (0x00000019u)

#define CSL_EMIF4F_SDRAM_TIM_1_REG_T_RCD_MASK (0x01E00000u)
#define CSL_EMIF4F_SDRAM_TIM_1_REG_T_RCD_SHIFT (0x00000015u)

#define CSL_EMIF4F_SDRAM_TIM_1_REG_T_WR_MASK (0x001E0000u)
#define CSL_EMIF4F_SDRAM_TIM_1_REG_T_WR_SHIFT (0x00000011u)

#define CSL_EMIF4F_SDRAM_TIM_1_REG_T_RAS_MASK (0x0001F000u)
#define CSL_EMIF4F_SDRAM_TIM_1_REG_T_RAS_SHIFT (0x0000000Cu)

#define CSL_EMIF4F_SDRAM_TIM_1_REG_T_RC_MASK (0x00000FC0u)
#define CSL_EMIF4F_SDRAM_TIM_1_REG_T_RC_SHIFT (0x00000006u)

#define CSL_EMIF4F_SDRAM_TIM_1_REG_T_RRD_MASK (0x00000038u)
#define CSL_EMIF4F_SDRAM_TIM_1_REG_T_RRD_SHIFT (0x00000003u)

#define CSL_EMIF4F_SDRAM_TIM_1_REG_T_WTR_MASK (0x00000007u)
#define CSL_EMIF4F_SDRAM_TIM_1_REG_T_WTR_SHIFT (0x00000000u)

#define CSL_EMIF4F_SDRAM_TIM_1_RESETVAL  (0x00000000u)

/* SDRAM_TIM_1_SHDW */

#define CSL_EMIF4F_SDRAM_TIM_1_SHDW_REG_T_RP_SHDW_MASK (0x1E000000u)
#define CSL_EMIF4F_SDRAM_TIM_1_SHDW_REG_T_RP_SHDW_SHIFT (0x00000019u)

#define CSL_EMIF4F_SDRAM_TIM_1_SHDW_REG_T_RCD_SHDW_MASK (0x01E00000u)
#define CSL_EMIF4F_SDRAM_TIM_1_SHDW_REG_T_RCD_SHDW_SHIFT (0x00000015u)

#define CSL_EMIF4F_SDRAM_TIM_1_SHDW_REG_T_WR_SHDW_MASK (0x001E0000u)
#define CSL_EMIF4F_SDRAM_TIM_1_SHDW_REG_T_WR_SHDW_SHIFT (0x00000011u)

#define CSL_EMIF4F_SDRAM_TIM_1_SHDW_REG_T_RAS_SHDW_MASK (0x0001F000u)
#define CSL_EMIF4F_SDRAM_TIM_1_SHDW_REG_T_RAS_SHDW_SHIFT (0x0000000Cu)

#define CSL_EMIF4F_SDRAM_TIM_1_SHDW_REG_T_RC_SHDW_MASK (0x00000FC0u)
#define CSL_EMIF4F_SDRAM_TIM_1_SHDW_REG_T_RC_SHDW_SHIFT (0x00000006u)

#define CSL_EMIF4F_SDRAM_TIM_1_SHDW_REG_T_RRD_SHDW_MASK (0x00000038u)
#define CSL_EMIF4F_SDRAM_TIM_1_SHDW_REG_T_RRD_SHDW_SHIFT (0x00000003u)

#define CSL_EMIF4F_SDRAM_TIM_1_SHDW_REG_T_WTR_SHDW_MASK (0x00000007u)
#define CSL_EMIF4F_SDRAM_TIM_1_SHDW_REG_T_WTR_SHDW_SHIFT (0x00000000u)

#define CSL_EMIF4F_SDRAM_TIM_1_SHDW_RESETVAL (0x00000000u)

/* SDRAM_TIM_2 */

#define CSL_EMIF4F_SDRAM_TIM_2_REG_T_XP_MASK (0x70000000u)
#define CSL_EMIF4F_SDRAM_TIM_2_REG_T_XP_SHIFT (0x0000001Cu)

#define CSL_EMIF4F_SDRAM_TIM_2_REG_T_ODT_MASK (0x0E000000u)
#define CSL_EMIF4F_SDRAM_TIM_2_REG_T_ODT_SHIFT (0x00000019u)

#define CSL_EMIF4F_SDRAM_TIM_2_REG_T_XSNR_MASK (0x01FF0000u)
#define CSL_EMIF4F_SDRAM_TIM_2_REG_T_XSNR_SHIFT (0x00000010u)

#define CSL_EMIF4F_SDRAM_TIM_2_REG_T_XSRD_MASK (0x0000FFC0u)
#define CSL_EMIF4F_SDRAM_TIM_2_REG_T_XSRD_SHIFT (0x00000006u)

#define CSL_EMIF4F_SDRAM_TIM_2_REG_T_RTP_MASK (0x00000038u)
#define CSL_EMIF4F_SDRAM_TIM_2_REG_T_RTP_SHIFT (0x00000003u)

#define CSL_EMIF4F_SDRAM_TIM_2_REG_T_CKE_MASK (0x00000007u)
#define CSL_EMIF4F_SDRAM_TIM_2_REG_T_CKE_SHIFT (0x00000000u)

#define CSL_EMIF4F_SDRAM_TIM_2_RESETVAL  (0x00000000u)

/* SDRAM_TIM_2_SHDW */

#define CSL_EMIF4F_SDRAM_TIM_2_SHDW_REG_T_XP_SHDW_MASK (0x70000000u)
#define CSL_EMIF4F_SDRAM_TIM_2_SHDW_REG_T_XP_SHDW_SHIFT (0x0000001Cu)

#define CSL_EMIF4F_SDRAM_TIM_2_SHDW_REG_T_ODT_SHDW_MASK (0x0E000000u)
#define CSL_EMIF4F_SDRAM_TIM_2_SHDW_REG_T_ODT_SHDW_SHIFT (0x00000019u)

#define CSL_EMIF4F_SDRAM_TIM_2_SHDW_REG_T_XSNR_SHDW_MASK (0x01FF0000u)
#define CSL_EMIF4F_SDRAM_TIM_2_SHDW_REG_T_XSNR_SHDW_SHIFT (0x00000010u)

#define CSL_EMIF4F_SDRAM_TIM_2_SHDW_REG_T_XSRD_SHDW_MASK (0x0000FFC0u)
#define CSL_EMIF4F_SDRAM_TIM_2_SHDW_REG_T_XSRD_SHDW_SHIFT (0x00000006u)

#define CSL_EMIF4F_SDRAM_TIM_2_SHDW_REG_T_RTP_SHDW_MASK (0x00000038u)
#define CSL_EMIF4F_SDRAM_TIM_2_SHDW_REG_T_RTP_SHDW_SHIFT (0x00000003u)

#define CSL_EMIF4F_SDRAM_TIM_2_SHDW_REG_T_CKE_SHDW_MASK (0x00000007u)
#define CSL_EMIF4F_SDRAM_TIM_2_SHDW_REG_T_CKE_SHDW_SHIFT (0x00000000u)

#define CSL_EMIF4F_SDRAM_TIM_2_SHDW_RESETVAL (0x00000000u)

/* SDRAM_TIM_3 */

#define CSL_EMIF4F_SDRAM_TIM_3_REG_T_PDLL_UL_MASK (0xF0000000u)
#define CSL_EMIF4F_SDRAM_TIM_3_REG_T_PDLL_UL_SHIFT (0x0000001Cu)

#define CSL_EMIF4F_SDRAM_TIM_3_REG_T_CSTA_MASK (0x0F000000u)
#define CSL_EMIF4F_SDRAM_TIM_3_REG_T_CSTA_SHIFT (0x00000018u)

#define CSL_EMIF4F_SDRAM_TIM_3_REG_T_CKESR_MASK (0x00E00000u)
#define CSL_EMIF4F_SDRAM_TIM_3_REG_T_CKESR_SHIFT (0x00000015u)

#define CSL_EMIF4F_SDRAM_TIM_3_REG_ZQ_ZQCS_MASK (0x001F8000u)
#define CSL_EMIF4F_SDRAM_TIM_3_REG_ZQ_ZQCS_SHIFT (0x0000000Fu)

#define CSL_EMIF4F_SDRAM_TIM_3_REG_T_TDQSCKMAX_MASK (0x00006000u)
#define CSL_EMIF4F_SDRAM_TIM_3_REG_T_TDQSCKMAX_SHIFT (0x0000000Du)

#define CSL_EMIF4F_SDRAM_TIM_3_REG_T_RFC_MASK (0x00001FF0u)
#define CSL_EMIF4F_SDRAM_TIM_3_REG_T_RFC_SHIFT (0x00000004u)

#define CSL_EMIF4F_SDRAM_TIM_3_REG_T_RAS_MAX_MASK (0x0000000Fu)
#define CSL_EMIF4F_SDRAM_TIM_3_REG_T_RAS_MAX_SHIFT (0x00000000u)

#define CSL_EMIF4F_SDRAM_TIM_3_RESETVAL  (0x00000000u)

/* SDRAM_TIM_3_SHDW */

#define CSL_EMIF4F_SDRAM_TIM_3_SHDW_REG_T_PDLL_UL_SHDW_MASK (0xF0000000u)
#define CSL_EMIF4F_SDRAM_TIM_3_SHDW_REG_T_PDLL_UL_SHDW_SHIFT (0x0000001Cu)

#define CSL_EMIF4F_SDRAM_TIM_3_SHDW_REG_T_CSTA_SHDW_MASK (0x0F000000u)
#define CSL_EMIF4F_SDRAM_TIM_3_SHDW_REG_T_CSTA_SHDW_SHIFT (0x00000018u)

#define CSL_EMIF4F_SDRAM_TIM_3_SHDW_REG_T_CKESR_SHDW_MASK (0x00E00000u)
#define CSL_EMIF4F_SDRAM_TIM_3_SHDW_REG_T_CKESR_SHDW_SHIFT (0x00000015u)

#define CSL_EMIF4F_SDRAM_TIM_3_SHDW_REG_ZQ_ZQCS_SHDW_MASK (0x001F8000u)
#define CSL_EMIF4F_SDRAM_TIM_3_SHDW_REG_ZQ_ZQCS_SHDW_SHIFT (0x0000000Fu)

#define CSL_EMIF4F_SDRAM_TIM_3_SHDW_REG_T_TDQSCKMAX_SHDW_MASK (0x00006000u)
#define CSL_EMIF4F_SDRAM_TIM_3_SHDW_REG_T_TDQSCKMAX_SHDW_SHIFT (0x0000000Du)

#define CSL_EMIF4F_SDRAM_TIM_3_SHDW_REG_T_RFC_SHDW_MASK (0x00001FF0u)
#define CSL_EMIF4F_SDRAM_TIM_3_SHDW_REG_T_RFC_SHDW_SHIFT (0x00000004u)

#define CSL_EMIF4F_SDRAM_TIM_3_SHDW_REG_T_RAS_MAX_SHDW_MASK (0x0000000Fu)
#define CSL_EMIF4F_SDRAM_TIM_3_SHDW_REG_T_RAS_MAX_SHDW_SHIFT (0x00000000u)

#define CSL_EMIF4F_SDRAM_TIM_3_SHDW_RESETVAL (0x00000000u)

/* LPDDR2_NVM_TIM */

#define CSL_EMIF4F_LPDDR2_NVM_TIM_REG_NVM_T_XP_MASK (0x70000000u)
#define CSL_EMIF4F_LPDDR2_NVM_TIM_REG_NVM_T_XP_SHIFT (0x0000001Cu)

#define CSL_EMIF4F_LPDDR2_NVM_TIM_REG_NVM_T_WTR_MASK (0x07000000u)
#define CSL_EMIF4F_LPDDR2_NVM_TIM_REG_NVM_T_WTR_SHIFT (0x00000018u)

#define CSL_EMIF4F_LPDDR2_NVM_TIM_REG_NVM_T_RP_MASK (0x00F00000u)
#define CSL_EMIF4F_LPDDR2_NVM_TIM_REG_NVM_T_RP_SHIFT (0x00000014u)

#define CSL_EMIF4F_LPDDR2_NVM_TIM_REG_NVM_T_WRA_MASK (0x000F0000u)
#define CSL_EMIF4F_LPDDR2_NVM_TIM_REG_NVM_T_WRA_SHIFT (0x00000010u)

#define CSL_EMIF4F_LPDDR2_NVM_TIM_REG_NVM_T_RRD_MASK (0x0000FF00u)
#define CSL_EMIF4F_LPDDR2_NVM_TIM_REG_NVM_T_RRD_SHIFT (0x00000008u)

#define CSL_EMIF4F_LPDDR2_NVM_TIM_REG_NVM_T_RCDMIN_MASK (0x000000FFu)
#define CSL_EMIF4F_LPDDR2_NVM_TIM_REG_NVM_T_RCDMIN_SHIFT (0x00000000u)

#define CSL_EMIF4F_LPDDR2_NVM_TIM_RESETVAL (0x00000000u)

/* LPDDR2_NVM_TIM_SHDW */

#define CSL_EMIF4F_LPDDR2_NVM_TIM_SHDW_REG_NVM_T_XP_SHDW_MASK (0x70000000u)
#define CSL_EMIF4F_LPDDR2_NVM_TIM_SHDW_REG_NVM_T_XP_SHDW_SHIFT (0x0000001Cu)

#define CSL_EMIF4F_LPDDR2_NVM_TIM_SHDW_REG_NVM_T_WTR_SHDW_MASK (0x07000000u)
#define CSL_EMIF4F_LPDDR2_NVM_TIM_SHDW_REG_NVM_T_WTR_SHDW_SHIFT (0x00000018u)

#define CSL_EMIF4F_LPDDR2_NVM_TIM_SHDW_REG_NVM_T_RP_SHDW_MASK (0x00F00000u)
#define CSL_EMIF4F_LPDDR2_NVM_TIM_SHDW_REG_NVM_T_RP_SHDW_SHIFT (0x00000014u)

#define CSL_EMIF4F_LPDDR2_NVM_TIM_SHDW_REG_NVM_T_WRA_SHDW_MASK (0x000F0000u)
#define CSL_EMIF4F_LPDDR2_NVM_TIM_SHDW_REG_NVM_T_WRA_SHDW_SHIFT (0x00000010u)

#define CSL_EMIF4F_LPDDR2_NVM_TIM_SHDW_REG_NVM_T_RRD_SHDW_MASK (0x0000FF00u)
#define CSL_EMIF4F_LPDDR2_NVM_TIM_SHDW_REG_NVM_T_RRD_SHDW_SHIFT (0x00000008u)

#define CSL_EMIF4F_LPDDR2_NVM_TIM_SHDW_REG_NVM_T_RCDMIN_SHDW_MASK (0x000000FFu)
#define CSL_EMIF4F_LPDDR2_NVM_TIM_SHDW_REG_NVM_T_RCDMIN_SHDW_SHIFT (0x00000000u)

#define CSL_EMIF4F_LPDDR2_NVM_TIM_SHDW_RESETVAL (0x00000000u)

/* PWR_MGMT_CTRL */

#define CSL_EMIF4F_PWR_MGMT_CTRL_REG_PD_TIM_MASK (0x0000F000u)
#define CSL_EMIF4F_PWR_MGMT_CTRL_REG_PD_TIM_SHIFT (0x0000000Cu)
#define CSL_EMIF4F_PWR_MGMT_CTRL_REG_PD_TIM_RESETVAL (0x00000000u)

#define CSL_EMIF4F_PWR_MGMT_CTRL_REG_DPD_EN_MASK (0x00000800u)
#define CSL_EMIF4F_PWR_MGMT_CTRL_REG_DPD_EN_SHIFT (0x0000000Bu)
#define CSL_EMIF4F_PWR_MGMT_CTRL_REG_DPD_EN_RESETVAL (0x00000000u)

#define CSL_EMIF4F_PWR_MGMT_CTRL_REG_LP_MODE_MASK (0x00000700u)
#define CSL_EMIF4F_PWR_MGMT_CTRL_REG_LP_MODE_SHIFT (0x00000008u)
#define CSL_EMIF4F_PWR_MGMT_CTRL_REG_LP_MODE_RESETVAL (0x00000000u)

#define CSL_EMIF4F_PWR_MGMT_CTRL_REG_SR_TIM_MASK (0x000000F0u)
#define CSL_EMIF4F_PWR_MGMT_CTRL_REG_SR_TIM_SHIFT (0x00000004u)
#define CSL_EMIF4F_PWR_MGMT_CTRL_REG_SR_TIM_RESETVAL (0x00000000u)

#define CSL_EMIF4F_PWR_MGMT_CTRL_REG_CS_TIM_MASK (0x0000000Fu)
#define CSL_EMIF4F_PWR_MGMT_CTRL_REG_CS_TIM_SHIFT (0x00000000u)
#define CSL_EMIF4F_PWR_MGMT_CTRL_REG_CS_TIM_RESETVAL (0x00000000u)

#define CSL_EMIF4F_PWR_MGMT_CTRL_RESETVAL (0x00000000u)

/* PWR_MGMT_CTRL_SHDW */

#define CSL_EMIF4F_PWR_MGMT_CTRL_SHDW_REG_PD_TIM_SHDW_MASK (0x0000F000u)
#define CSL_EMIF4F_PWR_MGMT_CTRL_SHDW_REG_PD_TIM_SHDW_SHIFT (0x0000000Cu)
#define CSL_EMIF4F_PWR_MGMT_CTRL_SHDW_REG_PD_TIM_SHDW_RESETVAL (0x00000000u)

#define CSL_EMIF4F_PWR_MGMT_CTRL_SHDW_REG_SR_TIM_SHDW_MASK (0x000000F0u)
#define CSL_EMIF4F_PWR_MGMT_CTRL_SHDW_REG_SR_TIM_SHDW_SHIFT (0x00000004u)
#define CSL_EMIF4F_PWR_MGMT_CTRL_SHDW_REG_SR_TIM_SHDW_RESETVAL (0x00000000u)

#define CSL_EMIF4F_PWR_MGMT_CTRL_SHDW_REG_CS_TIM_SHDW_MASK (0x0000000Fu)
#define CSL_EMIF4F_PWR_MGMT_CTRL_SHDW_REG_CS_TIM_SHDW_SHIFT (0x00000000u)
#define CSL_EMIF4F_PWR_MGMT_CTRL_SHDW_REG_CS_TIM_SHDW_RESETVAL (0x00000000u)

#define CSL_EMIF4F_PWR_MGMT_CTRL_SHDW_RESETVAL (0x00000000u)

/* LPDDR2_MODE_REG_DATA */

#define CSL_EMIF4F_LPDDR2_MODE_REG_DATA_REG_VALUE_0_MASK (0x0000007Fu)
#define CSL_EMIF4F_LPDDR2_MODE_REG_DATA_REG_VALUE_0_SHIFT (0x00000000u)
#define CSL_EMIF4F_LPDDR2_MODE_REG_DATA_REG_VALUE_0_RESETVAL (0x00000000u)

#define CSL_EMIF4F_LPDDR2_MODE_REG_DATA_RESETVAL (0x00000000u)

/* LPDDR2_MODE_REG_CFG */

#define CSL_EMIF4F_LPDDR2_MODE_REG_CFG_REG_CS_MASK (0x80000000u)
#define CSL_EMIF4F_LPDDR2_MODE_REG_CFG_REG_CS_SHIFT (0x0000001Fu)
#define CSL_EMIF4F_LPDDR2_MODE_REG_CFG_REG_CS_RESETVAL (0x00000000u)

#define CSL_EMIF4F_LPDDR2_MODE_REG_CFG_REG_REFRESH_EN_MASK (0x40000000u)
#define CSL_EMIF4F_LPDDR2_MODE_REG_CFG_REG_REFRESH_EN_SHIFT (0x0000001Eu)
#define CSL_EMIF4F_LPDDR2_MODE_REG_CFG_REG_REFRESH_EN_RESETVAL (0x00000000u)

#define CSL_EMIF4F_LPDDR2_MODE_REG_CFG_REG_ADDRESS_MASK (0x000000FFu)
#define CSL_EMIF4F_LPDDR2_MODE_REG_CFG_REG_ADDRESS_SHIFT (0x00000000u)
#define CSL_EMIF4F_LPDDR2_MODE_REG_CFG_REG_ADDRESS_RESETVAL (0x00000000u)

#define CSL_EMIF4F_LPDDR2_MODE_REG_CFG_RESETVAL (0x00000000u)

/* VBUSM_CONFIG */

#define CSL_EMIF4F_VBUSM_CONFIG_REG_COS_COUNT_1_MASK (0x00FF0000u)
#define CSL_EMIF4F_VBUSM_CONFIG_REG_COS_COUNT_1_SHIFT (0x00000010u)
#define CSL_EMIF4F_VBUSM_CONFIG_REG_COS_COUNT_1_RESETVAL (0x000000FFu)

#define CSL_EMIF4F_VBUSM_CONFIG_REG_COS_COUNT_2_MASK (0x0000FF00u)
#define CSL_EMIF4F_VBUSM_CONFIG_REG_COS_COUNT_2_SHIFT (0x00000008u)
#define CSL_EMIF4F_VBUSM_CONFIG_REG_COS_COUNT_2_RESETVAL (0x000000FFu)

#define CSL_EMIF4F_VBUSM_CONFIG_REG_PR_OLD_COUNT_MASK (0x000000FFu)
#define CSL_EMIF4F_VBUSM_CONFIG_REG_PR_OLD_COUNT_SHIFT (0x00000000u)
#define CSL_EMIF4F_VBUSM_CONFIG_REG_PR_OLD_COUNT_RESETVAL (0x000000FFu)

#define CSL_EMIF4F_VBUSM_CONFIG_RESETVAL (0x00FFFFFFu)

/* VBUSM_CFG_VAL_1 */

#define CSL_EMIF4F_VBUSM_CFG_VAL_1_REG_SYS_BUS_WIDTH_MASK (0xC0000000u)
#define CSL_EMIF4F_VBUSM_CFG_VAL_1_REG_SYS_BUS_WIDTH_SHIFT (0x0000001Eu)
#define CSL_EMIF4F_VBUSM_CFG_VAL_1_REG_SYS_BUS_WIDTH_RESETVAL (0x00000003u)

#define CSL_EMIF4F_VBUSM_CFG_VAL_1_REG_STAT_FIFO_DEPTH_MASK (0x00FF0000u)
#define CSL_EMIF4F_VBUSM_CFG_VAL_1_REG_STAT_FIFO_DEPTH_SHIFT (0x00000010u)
#define CSL_EMIF4F_VBUSM_CFG_VAL_1_REG_STAT_FIFO_DEPTH_RESETVAL (0x00000007u)

#define CSL_EMIF4F_VBUSM_CFG_VAL_1_REG_WR_FIFO_DEPTH_MASK (0x0000FF00u)
#define CSL_EMIF4F_VBUSM_CFG_VAL_1_REG_WR_FIFO_DEPTH_SHIFT (0x00000008u)
#define CSL_EMIF4F_VBUSM_CFG_VAL_1_REG_WR_FIFO_DEPTH_RESETVAL (0x00000014u)

#define CSL_EMIF4F_VBUSM_CFG_VAL_1_REG_CMD_FIFO_DEPTH_MASK (0x000000FFu)
#define CSL_EMIF4F_VBUSM_CFG_VAL_1_REG_CMD_FIFO_DEPTH_SHIFT (0x00000000u)
#define CSL_EMIF4F_VBUSM_CFG_VAL_1_REG_CMD_FIFO_DEPTH_RESETVAL (0x00000010u)

#define CSL_EMIF4F_VBUSM_CFG_VAL_1_RESETVAL (0xC0071410u)

/* VBUSM_CFG_VAL_2 */

#define CSL_EMIF4F_VBUSM_CFG_VAL_2_REG_RREG_FIFO_DEPTH_MASK (0x00FF0000u)
#define CSL_EMIF4F_VBUSM_CFG_VAL_2_REG_RREG_FIFO_DEPTH_SHIFT (0x00000010u)
#define CSL_EMIF4F_VBUSM_CFG_VAL_2_REG_RREG_FIFO_DEPTH_RESETVAL (0x00000002u)

#define CSL_EMIF4F_VBUSM_CFG_VAL_2_REG_RSD_FIFO_DEPTH_MASK (0x0000FF00u)
#define CSL_EMIF4F_VBUSM_CFG_VAL_2_REG_RSD_FIFO_DEPTH_SHIFT (0x00000008u)
#define CSL_EMIF4F_VBUSM_CFG_VAL_2_REG_RSD_FIFO_DEPTH_RESETVAL (0x00000016u)

#define CSL_EMIF4F_VBUSM_CFG_VAL_2_REG_RCMD_FIFO_DEPTH_MASK (0x000000FFu)
#define CSL_EMIF4F_VBUSM_CFG_VAL_2_REG_RCMD_FIFO_DEPTH_SHIFT (0x00000000u)
#define CSL_EMIF4F_VBUSM_CFG_VAL_2_REG_RCMD_FIFO_DEPTH_RESETVAL (0x00000016u)

#define CSL_EMIF4F_VBUSM_CFG_VAL_2_RESETVAL (0x00021616u)

/* IODFT_TLGC */

#define CSL_EMIF4F_IODFT_TLGC_REG_TLEC_MASK (0xFFFF0000u)
#define CSL_EMIF4F_IODFT_TLGC_REG_TLEC_SHIFT (0x00000010u)
#define CSL_EMIF4F_IODFT_TLGC_REG_TLEC_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_TLGC_REG_MT_MASK (0x00004000u)
#define CSL_EMIF4F_IODFT_TLGC_REG_MT_SHIFT (0x0000000Eu)
#define CSL_EMIF4F_IODFT_TLGC_REG_MT_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_TLGC_REG_ACT_CAP_EN_MASK (0x00002000u)
#define CSL_EMIF4F_IODFT_TLGC_REG_ACT_CAP_EN_SHIFT (0x0000000Du)
#define CSL_EMIF4F_IODFT_TLGC_REG_ACT_CAP_EN_RESETVAL (0x00000001u)

#define CSL_EMIF4F_IODFT_TLGC_REG_OPG_LD_MASK (0x00001000u)
#define CSL_EMIF4F_IODFT_TLGC_REG_OPG_LD_SHIFT (0x0000000Cu)
#define CSL_EMIF4F_IODFT_TLGC_REG_OPG_LD_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_TLGC_REG_MMS_MASK (0x00000100u)
#define CSL_EMIF4F_IODFT_TLGC_REG_MMS_SHIFT (0x00000008u)
#define CSL_EMIF4F_IODFT_TLGC_REG_MMS_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_TLGC_REG_MC_MASK (0x00000030u)
#define CSL_EMIF4F_IODFT_TLGC_REG_MC_SHIFT (0x00000004u)
#define CSL_EMIF4F_IODFT_TLGC_REG_MC_RESETVAL (0x00000001u)

#define CSL_EMIF4F_IODFT_TLGC_REG_PC_MASK (0x0000000Eu)
#define CSL_EMIF4F_IODFT_TLGC_REG_PC_SHIFT (0x00000001u)
#define CSL_EMIF4F_IODFT_TLGC_REG_PC_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_TLGC_REG_TM_MASK (0x00000001u)
#define CSL_EMIF4F_IODFT_TLGC_REG_TM_SHIFT (0x00000000u)
#define CSL_EMIF4F_IODFT_TLGC_REG_TM_RESETVAL (0x00000001u)

#define CSL_EMIF4F_IODFT_TLGC_RESETVAL   (0x00002011u)

/* IODFT_CTRL_MISR_RSLT */

#define CSL_EMIF4F_IODFT_CTRL_MISR_RSLT_REG_DQM_TLMR_MASK (0xFFFFF000u)
#define CSL_EMIF4F_IODFT_CTRL_MISR_RSLT_REG_DQM_TLMR_SHIFT (0x0000000Cu)
#define CSL_EMIF4F_IODFT_CTRL_MISR_RSLT_REG_DQM_TLMR_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_CTRL_MISR_RSLT_REG_CTL_TLMR_MASK (0x000007FFu)
#define CSL_EMIF4F_IODFT_CTRL_MISR_RSLT_REG_CTL_TLMR_SHIFT (0x00000000u)
#define CSL_EMIF4F_IODFT_CTRL_MISR_RSLT_REG_CTL_TLMR_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_CTRL_MISR_RSLT_RESETVAL (0x00000000u)

/* IODFT_ADDR_MISR_RSLT */

#define CSL_EMIF4F_IODFT_ADDR_MISR_RSLT_REG_ADDR_TLMR_MASK (0x001FFFFFu)
#define CSL_EMIF4F_IODFT_ADDR_MISR_RSLT_REG_ADDR_TLMR_SHIFT (0x00000000u)
#define CSL_EMIF4F_IODFT_ADDR_MISR_RSLT_REG_ADDR_TLMR_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_ADDR_MISR_RSLT_RESETVAL (0x00000000u)

/* IODFT_DATA_MISR_RSLT_1 */

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR31_MASK (0x80000000u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR31_SHIFT (0x0000001fu)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR31_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR30_MASK (0x40000000u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR30_SHIFT (0x0000001eu)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR30_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR29_MASK (0x20000000u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR29_SHIFT (0x0000001du)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR29_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR28_MASK (0x10000000u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR28_SHIFT (0x0000001cu)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR28_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR27_MASK (0x08000000u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR27_SHIFT (0x0000001bu)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR27_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR26_MASK (0x04000000u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR26_SHIFT (0x0000001au)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR26_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR25_MASK (0x02000000u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR25_SHIFT (0x00000019u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR25_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR24_MASK (0x01000000u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR24_SHIFT (0x00000018u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR24_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR23_MASK (0x00800000u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR23_SHIFT (0x00000017u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR23_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR22_MASK (0x00400000u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR22_SHIFT (0x00000016u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR22_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR21_MASK (0x00200000u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR21_SHIFT (0x00000015u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR21_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR20_MASK (0x00100000u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR20_SHIFT (0x00000014u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR20_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR19_MASK (0x00080000u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR19_SHIFT (0x00000013u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR19_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR18_MASK (0x00040000u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR18_SHIFT (0x00000012u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR18_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR17_MASK (0x00020000u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR17_SHIFT (0x00000011u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR17_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR16_MASK (0x00010000u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR16_SHIFT (0x00000010u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR16_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR15_MASK (0x00008000u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR15_SHIFT (0x0000000fu)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR15_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR14_MASK (0x00004000u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR14_SHIFT (0x0000000eu)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR14_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR13_MASK (0x00002000u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR13_SHIFT (0x0000000du)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR13_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR12_MASK (0x00001000u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR12_SHIFT (0x0000000cu)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR12_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR11_MASK (0x00000800u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR11_SHIFT (0x0000000bu)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR11_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR10_MASK (0x00000400u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR10_SHIFT (0x0000000au)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR10_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR9_MASK (0x00000200u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR9_SHIFT (0x00000009u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR9_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR8_MASK (0x00000100u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR8_SHIFT (0x00000008u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR8_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR7_MASK (0x00000080u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR7_SHIFT (0x00000007u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR7_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR6_MASK (0x00000040u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR6_SHIFT (0x00000006u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR6_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR5_MASK (0x00000020u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR5_SHIFT (0x00000005u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR5_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR4_MASK (0x00000010u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR4_SHIFT (0x00000004u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR4_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR3_MASK (0x00000008u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR3_SHIFT (0x00000003u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR3_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR2_MASK (0x00000004u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR2_SHIFT (0x00000002u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR2_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR1_MASK (0x00000002u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR1_SHIFT (0x00000001u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR1_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR0_MASK (0x00000001u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR0_SHIFT (0x00000000u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_REG_DATA_TLMR0_RESETVAL (0x00000000u)


#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_1_RESETVAL (0x00000000u)

/* IODFT_DATA_MISR_RSLT_2 */

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR63_MASK (0x80000000u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR63_SHIFT (0x0000003fu)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR63_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR62_MASK (0x40000000u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR62_SHIFT (0x0000003eu)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR62_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR61_MASK (0x20000000u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR61_SHIFT (0x0000003du)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR61_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR60_MASK (0x10000000u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR60_SHIFT (0x0000003cu)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR60_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR59_MASK (0x08000000u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR59_SHIFT (0x0000003bu)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR59_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR58_MASK (0x04000000u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR58_SHIFT (0x0000003au)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR58_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR57_MASK (0x02000000u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR57_SHIFT (0x00000039u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR57_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR56_MASK (0x01000000u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR56_SHIFT (0x00000038u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR56_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR55_MASK (0x00800000u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR55_SHIFT (0x00000037u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR55_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR54_MASK (0x00400000u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR54_SHIFT (0x00000036u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR54_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR53_MASK (0x00200000u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR53_SHIFT (0x00000035u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR53_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR52_MASK (0x00100000u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR52_SHIFT (0x00000034u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR52_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR51_MASK (0x00080000u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR51_SHIFT (0x00000033u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR51_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR50_MASK (0x00040000u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR50_SHIFT (0x00000032u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR50_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR49_MASK (0x00020000u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR49_SHIFT (0x00000031u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR49_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR48_MASK (0x00010000u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR48_SHIFT (0x00000030u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR48_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR47_MASK (0x00008000u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR47_SHIFT (0x0000002fu)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR47_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR46_MASK (0x00004000u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR46_SHIFT (0x0000002eu)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR46_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR45_MASK (0x00002000u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR45_SHIFT (0x0000002du)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR45_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR44_MASK (0x00001000u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR44_SHIFT (0x0000002cu)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR44_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR43_MASK (0x00000800u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR43_SHIFT (0x0000002bu)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR43_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR42_MASK (0x00000400u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR42_SHIFT (0x0000002au)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR42_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR41_MASK (0x00000200u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR41_SHIFT (0x00000029u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR41_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR40_MASK (0x00000100u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR40_SHIFT (0x00000028u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR40_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR39_MASK (0x00000080u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR39_SHIFT (0x00000027u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR39_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR38_MASK (0x00000040u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR38_SHIFT (0x00000026u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR38_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR37_MASK (0x00000020u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR37_SHIFT (0x00000025u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR37_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR36_MASK (0x00000010u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR36_SHIFT (0x00000024u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR36_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR35_MASK (0x00000008u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR35_SHIFT (0x00000023u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR35_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR34_MASK (0x00000004u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR34_SHIFT (0x00000022u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR34_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR33_MASK (0x00000002u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR33_SHIFT (0x00000021u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR33_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR32_MASK (0x00000001u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR32_SHIFT (0x00000020u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_REG_DATA_TLMR32_RESETVAL (0x00000000u)


#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_2_RESETVAL (0x00000000u)

/* IODFT_DATA_MISR_RSLT_3 */

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR95_MASK (0x80000000u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR95_SHIFT (0x0000005fu)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR95_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR94_MASK (0x40000000u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR94_SHIFT (0x0000005eu)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR94_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR93_MASK (0x20000000u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR93_SHIFT (0x0000005du)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR93_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR92_MASK (0x10000000u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR92_SHIFT (0x0000005cu)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR92_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR91_MASK (0x08000000u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR91_SHIFT (0x0000005bu)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR91_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR90_MASK (0x04000000u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR90_SHIFT (0x0000005au)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR90_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR89_MASK (0x02000000u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR89_SHIFT (0x00000059u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR89_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR88_MASK (0x01000000u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR88_SHIFT (0x00000058u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR88_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR87_MASK (0x00800000u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR87_SHIFT (0x00000057u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR87_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR86_MASK (0x00400000u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR86_SHIFT (0x00000056u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR86_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR85_MASK (0x00200000u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR85_SHIFT (0x00000055u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR85_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR84_MASK (0x00100000u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR84_SHIFT (0x00000054u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR84_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR83_MASK (0x00080000u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR83_SHIFT (0x00000053u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR83_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR82_MASK (0x00040000u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR82_SHIFT (0x00000052u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR82_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR81_MASK (0x00020000u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR81_SHIFT (0x00000051u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR81_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR80_MASK (0x00010000u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR80_SHIFT (0x00000050u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR80_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR79_MASK (0x00008000u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR79_SHIFT (0x0000004fu)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR79_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR78_MASK (0x00004000u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR78_SHIFT (0x0000004eu)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR78_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR77_MASK (0x00002000u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR77_SHIFT (0x0000004du)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR77_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR76_MASK (0x00001000u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR76_SHIFT (0x0000004cu)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR76_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR75_MASK (0x00000800u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR75_SHIFT (0x0000004bu)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR75_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR74_MASK (0x00000400u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR74_SHIFT (0x0000004au)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR74_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR73_MASK (0x00000200u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR73_SHIFT (0x00000049u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR73_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR72_MASK (0x00000100u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR72_SHIFT (0x00000048u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR72_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR71_MASK (0x00000080u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR71_SHIFT (0x00000047u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR71_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR70_MASK (0x00000040u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR70_SHIFT (0x00000046u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR70_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR69_MASK (0x00000020u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR69_SHIFT (0x00000045u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR69_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR68_MASK (0x00000010u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR68_SHIFT (0x00000044u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR68_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR67_MASK (0x00000008u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR67_SHIFT (0x00000043u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR67_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR66_MASK (0x00000004u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR66_SHIFT (0x00000042u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR66_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR65_MASK (0x00000002u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR65_SHIFT (0x00000041u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR65_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR64_MASK (0x00000001u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR64_SHIFT (0x00000040u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_REG_DATA_TLMR64_RESETVAL (0x00000000u)


#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_3_RESETVAL (0x00000000u)

/* IODFT_DATA_MISR_RSLT_4 */

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR127_MASK (0x80000000u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR127_SHIFT (0x0000007fu)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR127_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR126_MASK (0x40000000u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR126_SHIFT (0x0000007eu)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR126_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR125_MASK (0x20000000u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR125_SHIFT (0x0000007du)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR125_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR124_MASK (0x10000000u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR124_SHIFT (0x0000007cu)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR124_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR123_MASK (0x08000000u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR123_SHIFT (0x0000007bu)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR123_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR122_MASK (0x04000000u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR122_SHIFT (0x0000007au)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR122_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR121_MASK (0x02000000u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR121_SHIFT (0x00000079u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR121_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR120_MASK (0x01000000u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR120_SHIFT (0x00000078u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR120_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR119_MASK (0x00800000u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR119_SHIFT (0x00000077u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR119_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR118_MASK (0x00400000u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR118_SHIFT (0x00000076u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR118_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR117_MASK (0x00200000u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR117_SHIFT (0x00000075u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR117_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR116_MASK (0x00100000u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR116_SHIFT (0x00000074u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR116_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR115_MASK (0x00080000u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR115_SHIFT (0x00000073u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR115_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR114_MASK (0x00040000u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR114_SHIFT (0x00000072u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR114_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR113_MASK (0x00020000u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR113_SHIFT (0x00000071u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR113_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR112_MASK (0x00010000u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR112_SHIFT (0x00000070u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR112_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR111_MASK (0x00008000u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR111_SHIFT (0x0000006fu)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR111_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR110_MASK (0x00004000u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR110_SHIFT (0x0000006eu)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR110_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR109_MASK (0x00002000u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR109_SHIFT (0x0000006du)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR109_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR108_MASK (0x00001000u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR108_SHIFT (0x0000006cu)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR108_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR107_MASK (0x00000800u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR107_SHIFT (0x0000006bu)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR107_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR106_MASK (0x00000400u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR106_SHIFT (0x0000006au)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR106_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR105_MASK (0x00000200u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR105_SHIFT (0x00000069u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR105_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR104_MASK (0x00000100u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR104_SHIFT (0x00000068u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR104_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR103_MASK (0x00000080u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR103_SHIFT (0x00000067u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR103_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR102_MASK (0x00000040u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR102_SHIFT (0x00000066u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR102_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR101_MASK (0x00000020u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR101_SHIFT (0x00000065u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR101_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR100_MASK (0x00000010u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR100_SHIFT (0x00000064u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR100_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR99_MASK (0x00000008u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR99_SHIFT (0x00000063u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR99_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR98_MASK (0x00000004u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR98_SHIFT (0x00000062u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR98_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR97_MASK (0x00000002u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR97_SHIFT (0x00000061u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR97_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR96_MASK (0x00000001u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR96_SHIFT (0x00000060u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_REG_DATA_TLMR96_RESETVAL (0x00000000u)


#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_4_RESETVAL (0x00000000u)

/* IODFT_DATA_MISR_RSLT_5 */

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_5_REG_DATA_TLMR146_MASK (0x00040000u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_5_REG_DATA_TLMR146_SHIFT (0x00000092u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_5_REG_DATA_TLMR146_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_5_REG_DATA_TLMR145_MASK (0x00020000u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_5_REG_DATA_TLMR145_SHIFT (0x00000091u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_5_REG_DATA_TLMR145_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_5_REG_DATA_TLMR144_MASK (0x00010000u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_5_REG_DATA_TLMR144_SHIFT (0x00000090u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_5_REG_DATA_TLMR144_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_5_REG_DATA_TLMR143_MASK (0x00008000u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_5_REG_DATA_TLMR143_SHIFT (0x0000008fu)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_5_REG_DATA_TLMR143_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_5_REG_DATA_TLMR142_MASK (0x00004000u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_5_REG_DATA_TLMR142_SHIFT (0x0000008eu)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_5_REG_DATA_TLMR142_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_5_REG_DATA_TLMR141_MASK (0x00002000u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_5_REG_DATA_TLMR141_SHIFT (0x0000008du)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_5_REG_DATA_TLMR141_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_5_REG_DATA_TLMR140_MASK (0x00001000u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_5_REG_DATA_TLMR140_SHIFT (0x0000008cu)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_5_REG_DATA_TLMR140_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_5_REG_DATA_TLMR139_MASK (0x00000800u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_5_REG_DATA_TLMR139_SHIFT (0x0000008bu)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_5_REG_DATA_TLMR139_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_5_REG_DATA_TLMR138_MASK (0x00000400u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_5_REG_DATA_TLMR138_SHIFT (0x0000008au)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_5_REG_DATA_TLMR138_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_5_REG_DATA_TLMR137_MASK (0x00000200u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_5_REG_DATA_TLMR137_SHIFT (0x00000089u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_5_REG_DATA_TLMR137_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_5_REG_DATA_TLMR136_MASK (0x00000100u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_5_REG_DATA_TLMR136_SHIFT (0x00000088u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_5_REG_DATA_TLMR136_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_5_REG_DATA_TLMR135_MASK (0x00000080u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_5_REG_DATA_TLMR135_SHIFT (0x00000087u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_5_REG_DATA_TLMR135_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_5_REG_DATA_TLMR134_MASK (0x00000040u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_5_REG_DATA_TLMR134_SHIFT (0x00000086u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_5_REG_DATA_TLMR134_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_5_REG_DATA_TLMR133_MASK (0x00000020u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_5_REG_DATA_TLMR133_SHIFT (0x00000085u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_5_REG_DATA_TLMR133_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_5_REG_DATA_TLMR132_MASK (0x00000010u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_5_REG_DATA_TLMR132_SHIFT (0x00000084u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_5_REG_DATA_TLMR132_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_5_REG_DATA_TLMR131_MASK (0x00000008u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_5_REG_DATA_TLMR131_SHIFT (0x00000083u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_5_REG_DATA_TLMR131_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_5_REG_DATA_TLMR130_MASK (0x00000004u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_5_REG_DATA_TLMR130_SHIFT (0x00000082u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_5_REG_DATA_TLMR130_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_5_REG_DATA_TLMR129_MASK (0x00000002u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_5_REG_DATA_TLMR129_SHIFT (0x00000081u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_5_REG_DATA_TLMR129_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_5_REG_DATA_TLMR128_MASK (0x00000001u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_5_REG_DATA_TLMR128_SHIFT (0x00000080u)
#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_5_REG_DATA_TLMR128_RESETVAL (0x00000000u)


#define CSL_EMIF4F_IODFT_DATA_MISR_RSLT_5_RESETVAL (0x00000000u)

/* PERF_CNT_1 */

#define CSL_EMIF4F_PERF_CNT_1_REG_COUNTER1_MASK (0xFFFFFFFFu)
#define CSL_EMIF4F_PERF_CNT_1_REG_COUNTER1_SHIFT (0x00000000u)
#define CSL_EMIF4F_PERF_CNT_1_REG_COUNTER1_RESETVAL (0x00000000u)

#define CSL_EMIF4F_PERF_CNT_1_RESETVAL   (0x00000000u)

/* PERF_CNT_2 */

#define CSL_EMIF4F_PERF_CNT_2_REG_COUNTER2_MASK (0xFFFFFFFFu)
#define CSL_EMIF4F_PERF_CNT_2_REG_COUNTER2_SHIFT (0x00000000u)
#define CSL_EMIF4F_PERF_CNT_2_REG_COUNTER2_RESETVAL (0x00000000u)

#define CSL_EMIF4F_PERF_CNT_2_RESETVAL   (0x00000000u)

/* PERF_CNT_CFG */

#define CSL_EMIF4F_PERF_CNT_CFG_REG_CNTR2_MSTID_EN_MASK (0x80000000u)
#define CSL_EMIF4F_PERF_CNT_CFG_REG_CNTR2_MSTID_EN_SHIFT (0x0000001Fu)
#define CSL_EMIF4F_PERF_CNT_CFG_REG_CNTR2_MSTID_EN_RESETVAL (0x00000000u)

#define CSL_EMIF4F_PERF_CNT_CFG_REG_CNTR2_REGION_EN_MASK (0x40000000u)
#define CSL_EMIF4F_PERF_CNT_CFG_REG_CNTR2_REGION_EN_SHIFT (0x0000001Eu)
#define CSL_EMIF4F_PERF_CNT_CFG_REG_CNTR2_REGION_EN_RESETVAL (0x00000000u)

#define CSL_EMIF4F_PERF_CNT_CFG_REG_CNTR2_CFG_MASK (0x000F0000u)
#define CSL_EMIF4F_PERF_CNT_CFG_REG_CNTR2_CFG_SHIFT (0x00000010u)
#define CSL_EMIF4F_PERF_CNT_CFG_REG_CNTR2_CFG_RESETVAL (0x00000001u)

#define CSL_EMIF4F_PERF_CNT_CFG_REG_CNTR1_MSTID_EN_MASK (0x00008000u)
#define CSL_EMIF4F_PERF_CNT_CFG_REG_CNTR1_MSTID_EN_SHIFT (0x0000000Fu)
#define CSL_EMIF4F_PERF_CNT_CFG_REG_CNTR1_MSTID_EN_RESETVAL (0x00000000u)

#define CSL_EMIF4F_PERF_CNT_CFG_REG_CNTR1_REGION_EN_MASK (0x00004000u)
#define CSL_EMIF4F_PERF_CNT_CFG_REG_CNTR1_REGION_EN_SHIFT (0x0000000Eu)
#define CSL_EMIF4F_PERF_CNT_CFG_REG_CNTR1_REGION_EN_RESETVAL (0x00000000u)

#define CSL_EMIF4F_PERF_CNT_CFG_REG_CNTR1_CFG_MASK (0x0000000Fu)
#define CSL_EMIF4F_PERF_CNT_CFG_REG_CNTR1_CFG_SHIFT (0x00000000u)
#define CSL_EMIF4F_PERF_CNT_CFG_REG_CNTR1_CFG_RESETVAL (0x00000000u)

#define CSL_EMIF4F_PERF_CNT_CFG_RESETVAL (0x00010000u)

/* PERF_CNT_SEL */

#define CSL_EMIF4F_PERF_CNT_SEL_REG_MSTID2_MASK (0xFF000000u)
#define CSL_EMIF4F_PERF_CNT_SEL_REG_MSTID2_SHIFT (0x00000018u)
#define CSL_EMIF4F_PERF_CNT_SEL_REG_MSTID2_RESETVAL (0x00000000u)

#define CSL_EMIF4F_PERF_CNT_SEL_REG_REGION_SEL2_MASK (0x000F0000u)
#define CSL_EMIF4F_PERF_CNT_SEL_REG_REGION_SEL2_SHIFT (0x00000010u)
#define CSL_EMIF4F_PERF_CNT_SEL_REG_REGION_SEL2_RESETVAL (0x00000000u)

#define CSL_EMIF4F_PERF_CNT_SEL_REG_MSTID1_MASK (0x0000FF00u)
#define CSL_EMIF4F_PERF_CNT_SEL_REG_MSTID1_SHIFT (0x00000008u)
#define CSL_EMIF4F_PERF_CNT_SEL_REG_MSTID1_RESETVAL (0x00000000u)

#define CSL_EMIF4F_PERF_CNT_SEL_REG_REGION_SEL1_MASK (0x0000000Fu)
#define CSL_EMIF4F_PERF_CNT_SEL_REG_REGION_SEL1_SHIFT (0x00000000u)
#define CSL_EMIF4F_PERF_CNT_SEL_REG_REGION_SEL1_RESETVAL (0x00000000u)

#define CSL_EMIF4F_PERF_CNT_SEL_RESETVAL (0x00000000u)

/* PERF_CNT_TIM */

#define CSL_EMIF4F_PERF_CNT_TIM_REG_TOTAL_TIME_MASK (0xFFFFFFFFu)
#define CSL_EMIF4F_PERF_CNT_TIM_REG_TOTAL_TIME_SHIFT (0x00000000u)
#define CSL_EMIF4F_PERF_CNT_TIM_REG_TOTAL_TIME_RESETVAL (0x00000000u)

#define CSL_EMIF4F_PERF_CNT_TIM_RESETVAL (0x00000000u)

/* READ_IDLE_CTRL */

#define CSL_EMIF4F_READ_IDLE_CTRL_REG_READ_IDLE_LEN_MASK (0x000F0000u)
#define CSL_EMIF4F_READ_IDLE_CTRL_REG_READ_IDLE_LEN_SHIFT (0x00000010u)
#define CSL_EMIF4F_READ_IDLE_CTRL_REG_READ_IDLE_LEN_RESETVAL (0x00000005u)

#define CSL_EMIF4F_READ_IDLE_CTRL_REG_READ_IDLE_INTERVAL_MASK (0x000001FFu)
#define CSL_EMIF4F_READ_IDLE_CTRL_REG_READ_IDLE_INTERVAL_SHIFT (0x00000000u)
#define CSL_EMIF4F_READ_IDLE_CTRL_REG_READ_IDLE_INTERVAL_RESETVAL (0x00000000u)

#define CSL_EMIF4F_READ_IDLE_CTRL_RESETVAL (0x00050000u)

/* READ_IDLE_CTRL_SHDW */

#define CSL_EMIF4F_READ_IDLE_CTRL_SHDW_REG_READ_IDLE_LEN_SHDW_MASK (0x000F0000u)
#define CSL_EMIF4F_READ_IDLE_CTRL_SHDW_REG_READ_IDLE_LEN_SHDW_SHIFT (0x00000010u)
#define CSL_EMIF4F_READ_IDLE_CTRL_SHDW_REG_READ_IDLE_LEN_SHDW_RESETVAL (0x00000005u)

#define CSL_EMIF4F_READ_IDLE_CTRL_SHDW_REG_READ_IDLE_INTERVAL_SHDW_MASK (0x000001FFu)
#define CSL_EMIF4F_READ_IDLE_CTRL_SHDW_REG_READ_IDLE_INTERVAL_SHDW_SHIFT (0x00000000u)
#define CSL_EMIF4F_READ_IDLE_CTRL_SHDW_REG_READ_IDLE_INTERVAL_SHDW_RESETVAL (0x00000000u)

#define CSL_EMIF4F_READ_IDLE_CTRL_SHDW_RESETVAL (0x00050000u)

/* IRQSTATUS_RAW_SYS */

#define CSL_EMIF4F_IRQSTATUS_RAW_SYS_REG_RD_ECC_ERR_SYS_MASK (0x00000010u)
#define CSL_EMIF4F_IRQSTATUS_RAW_SYS_REG_RD_ECC_ERR_SYS_SHIFT (0x00000004u)
#define CSL_EMIF4F_IRQSTATUS_RAW_SYS_REG_RD_ECC_ERR_SYS_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IRQSTATUS_RAW_SYS_REG_WR_ECC_ERR_SYS_MASK (0x00000008u)
#define CSL_EMIF4F_IRQSTATUS_RAW_SYS_REG_WR_ECC_ERR_SYS_SHIFT (0x00000003u)
#define CSL_EMIF4F_IRQSTATUS_RAW_SYS_REG_WR_ECC_ERR_SYS_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IRQSTATUS_RAW_SYS_REG_DNV_SYS_MASK (0x00000004u)
#define CSL_EMIF4F_IRQSTATUS_RAW_SYS_REG_DNV_SYS_SHIFT (0x00000002u)
#define CSL_EMIF4F_IRQSTATUS_RAW_SYS_REG_DNV_SYS_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IRQSTATUS_RAW_SYS_REG_TA_SYS_MASK (0x00000002u)
#define CSL_EMIF4F_IRQSTATUS_RAW_SYS_REG_TA_SYS_SHIFT (0x00000001u)
#define CSL_EMIF4F_IRQSTATUS_RAW_SYS_REG_TA_SYS_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IRQSTATUS_RAW_SYS_REG_ERR_SYS_MASK (0x00000001u)
#define CSL_EMIF4F_IRQSTATUS_RAW_SYS_REG_ERR_SYS_SHIFT (0x00000000u)
#define CSL_EMIF4F_IRQSTATUS_RAW_SYS_REG_ERR_SYS_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IRQSTATUS_RAW_SYS_RESETVAL (0x00000000u)

/* IRQSTATUS_SYS */

#define CSL_EMIF4F_IRQSTATUS_SYS_REG_RD_ECC_ERR_SYS_MASK (0x00000010u)
#define CSL_EMIF4F_IRQSTATUS_SYS_REG_RD_ECC_ERR_SYS_SHIFT (0x00000004u)
#define CSL_EMIF4F_IRQSTATUS_SYS_REG_RD_ECC_ERR_SYS_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IRQSTATUS_SYS_REG_WR_ECC_ERR_SYS_MASK (0x00000008u)
#define CSL_EMIF4F_IRQSTATUS_SYS_REG_WR_ECC_ERR_SYS_SHIFT (0x00000003u)
#define CSL_EMIF4F_IRQSTATUS_SYS_REG_WR_ECC_ERR_SYS_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IRQSTATUS_SYS_REG_DNV_SYS_MASK (0x00000004u)
#define CSL_EMIF4F_IRQSTATUS_SYS_REG_DNV_SYS_SHIFT (0x00000002u)
#define CSL_EMIF4F_IRQSTATUS_SYS_REG_DNV_SYS_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IRQSTATUS_SYS_REG_TA_SYS_MASK (0x00000002u)
#define CSL_EMIF4F_IRQSTATUS_SYS_REG_TA_SYS_SHIFT (0x00000001u)
#define CSL_EMIF4F_IRQSTATUS_SYS_REG_TA_SYS_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IRQSTATUS_SYS_REG_ERR_SYS_MASK (0x00000001u)
#define CSL_EMIF4F_IRQSTATUS_SYS_REG_ERR_SYS_SHIFT (0x00000000u)
#define CSL_EMIF4F_IRQSTATUS_SYS_REG_ERR_SYS_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IRQSTATUS_SYS_RESETVAL (0x00000000u)

/* IRQENABLE_SET_SYS */

#define CSL_EMIF4F_IRQENABLE_SET_SYS_REG_EN_RD_ECC_ERR_SYS_MASK (0x00000010u)
#define CSL_EMIF4F_IRQENABLE_SET_SYS_REG_EN_RD_ECC_ERR_SYS_SHIFT (0x00000004u)
#define CSL_EMIF4F_IRQENABLE_SET_SYS_REG_EN_RD_ECC_ERR_SYS_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IRQENABLE_SET_SYS_REG_EN_WR_ECC_ERR_SYS_MASK (0x00000008u)
#define CSL_EMIF4F_IRQENABLE_SET_SYS_REG_EN_WR_ECC_ERR_SYS_SHIFT (0x00000003u)
#define CSL_EMIF4F_IRQENABLE_SET_SYS_REG_EN_WR_ECC_ERR_SYS_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IRQENABLE_SET_SYS_REG_EN_DNV_SYS_MASK (0x00000004u)
#define CSL_EMIF4F_IRQENABLE_SET_SYS_REG_EN_DNV_SYS_SHIFT (0x00000002u)
#define CSL_EMIF4F_IRQENABLE_SET_SYS_REG_EN_DNV_SYS_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IRQENABLE_SET_SYS_REG_EN_TA_SYS_MASK (0x00000002u)
#define CSL_EMIF4F_IRQENABLE_SET_SYS_REG_EN_TA_SYS_SHIFT (0x00000001u)
#define CSL_EMIF4F_IRQENABLE_SET_SYS_REG_EN_TA_SYS_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IRQENABLE_SET_SYS_REG_EN_ERR_SYS_MASK (0x00000001u)
#define CSL_EMIF4F_IRQENABLE_SET_SYS_REG_EN_ERR_SYS_SHIFT (0x00000000u)
#define CSL_EMIF4F_IRQENABLE_SET_SYS_REG_EN_ERR_SYS_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IRQENABLE_SET_SYS_RESETVAL (0x00000000u)

/* IRQENABLE_CLR_SYS */

#define CSL_EMIF4F_IRQENABLE_CLR_SYS_REG_EN_RD_ECC_ERR_SYS_MASK (0x00000010u)
#define CSL_EMIF4F_IRQENABLE_CLR_SYS_REG_EN_RD_ECC_ERR_SYS_SHIFT (0x00000004u)
#define CSL_EMIF4F_IRQENABLE_CLR_SYS_REG_EN_RD_ECC_ERR_SYS_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IRQENABLE_CLR_SYS_REG_EN_WR_ECC_ERR_SYS_MASK (0x00000008u)
#define CSL_EMIF4F_IRQENABLE_CLR_SYS_REG_EN_WR_ECC_ERR_SYS_SHIFT (0x00000003u)
#define CSL_EMIF4F_IRQENABLE_CLR_SYS_REG_EN_WR_ECC_ERR_SYS_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IRQENABLE_CLR_SYS_REG_EN_DNV_SYS_MASK (0x00000004u)
#define CSL_EMIF4F_IRQENABLE_CLR_SYS_REG_EN_DNV_SYS_SHIFT (0x00000002u)
#define CSL_EMIF4F_IRQENABLE_CLR_SYS_REG_EN_DNV_SYS_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IRQENABLE_CLR_SYS_REG_EN_TA_SYS_MASK (0x00000002u)
#define CSL_EMIF4F_IRQENABLE_CLR_SYS_REG_EN_TA_SYS_SHIFT (0x00000001u)
#define CSL_EMIF4F_IRQENABLE_CLR_SYS_REG_EN_TA_SYS_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IRQENABLE_CLR_SYS_REG_EN_ERR_SYS_MASK (0x00000001u)
#define CSL_EMIF4F_IRQENABLE_CLR_SYS_REG_EN_ERR_SYS_SHIFT (0x00000000u)
#define CSL_EMIF4F_IRQENABLE_CLR_SYS_REG_EN_ERR_SYS_RESETVAL (0x00000000u)

#define CSL_EMIF4F_IRQENABLE_CLR_SYS_RESETVAL (0x00000000u)

/* ZQ_CONFIG */

#define CSL_EMIF4F_ZQ_CONFIG_REG_ZQ_CS1EN_MASK (0x80000000u)
#define CSL_EMIF4F_ZQ_CONFIG_REG_ZQ_CS1EN_SHIFT (0x0000001Fu)

#define CSL_EMIF4F_ZQ_CONFIG_REG_ZQ_CS0EN_MASK (0x40000000u)
#define CSL_EMIF4F_ZQ_CONFIG_REG_ZQ_CS0EN_SHIFT (0x0000001Eu)

#define CSL_EMIF4F_ZQ_CONFIG_REG_ZQ_DUALCALEN_MASK (0x20000000u)
#define CSL_EMIF4F_ZQ_CONFIG_REG_ZQ_DUALCALEN_SHIFT (0x0000001Du)

#define CSL_EMIF4F_ZQ_CONFIG_REG_ZQ_SFEXITEN_MASK (0x10000000u)
#define CSL_EMIF4F_ZQ_CONFIG_REG_ZQ_SFEXITEN_SHIFT (0x0000001Cu)

#define CSL_EMIF4F_ZQ_CONFIG_REG_ZQ_ZQINIT_MULT_MASK (0x000C0000u)
#define CSL_EMIF4F_ZQ_CONFIG_REG_ZQ_ZQINIT_MULT_SHIFT (0x00000012u)

#define CSL_EMIF4F_ZQ_CONFIG_REG_ZQ_ZQCL_MULT_MASK (0x00030000u)
#define CSL_EMIF4F_ZQ_CONFIG_REG_ZQ_ZQCL_MULT_SHIFT (0x00000010u)

#define CSL_EMIF4F_ZQ_CONFIG_REG_ZQ_REFINTERVAL_MASK (0x0000FFFFu)
#define CSL_EMIF4F_ZQ_CONFIG_REG_ZQ_REFINTERVAL_SHIFT (0x00000000u)

#define CSL_EMIF4F_ZQ_CONFIG_RESETVAL    (0x00000000u)

/* TEMP_ALERT_CONFIG */

#define CSL_EMIF4F_TEMP_ALERT_CONFIG_REG_TA_CS1EN_MASK (0x80000000u)
#define CSL_EMIF4F_TEMP_ALERT_CONFIG_REG_TA_CS1EN_SHIFT (0x0000001Fu)

#define CSL_EMIF4F_TEMP_ALERT_CONFIG_REG_TA_CS0EN_MASK (0x40000000u)
#define CSL_EMIF4F_TEMP_ALERT_CONFIG_REG_TA_CS0EN_SHIFT (0x0000001Eu)

#define CSL_EMIF4F_TEMP_ALERT_CONFIG_REG_TA_SFEXITEN_MASK (0x10000000u)
#define CSL_EMIF4F_TEMP_ALERT_CONFIG_REG_TA_SFEXITEN_SHIFT (0x0000001Cu)

#define CSL_EMIF4F_TEMP_ALERT_CONFIG_REG_TA_DEVWDT_MASK (0x0C000000u)
#define CSL_EMIF4F_TEMP_ALERT_CONFIG_REG_TA_DEVWDT_SHIFT (0x0000001Au)

#define CSL_EMIF4F_TEMP_ALERT_CONFIG_REG_TA_DEVCNT_MASK (0x03000000u)
#define CSL_EMIF4F_TEMP_ALERT_CONFIG_REG_TA_DEVCNT_SHIFT (0x00000018u)

#define CSL_EMIF4F_TEMP_ALERT_CONFIG_REG_TA_REFINTERVAL_MASK (0x003FFFFFu)
#define CSL_EMIF4F_TEMP_ALERT_CONFIG_REG_TA_REFINTERVAL_SHIFT (0x00000000u)

#define CSL_EMIF4F_TEMP_ALERT_CONFIG_RESETVAL (0x00000000u)

/* VBUSM_ERR_LOG */

#define CSL_EMIF4F_VBUSM_ERR_LOG_REG_CRSEL_MASK (0x00007800u)
#define CSL_EMIF4F_VBUSM_ERR_LOG_REG_CRSEL_SHIFT (0x0000000Bu)
#define CSL_EMIF4F_VBUSM_ERR_LOG_REG_CRSEL_RESETVAL (0x00000000u)

#define CSL_EMIF4F_VBUSM_ERR_LOG_REG_CAMODE_MASK (0x00000600u)
#define CSL_EMIF4F_VBUSM_ERR_LOG_REG_CAMODE_SHIFT (0x00000009u)
#define CSL_EMIF4F_VBUSM_ERR_LOG_REG_CAMODE_RESETVAL (0x00000000u)

#define CSL_EMIF4F_VBUSM_ERR_LOG_REG_CDIR_MASK (0x00000100u)
#define CSL_EMIF4F_VBUSM_ERR_LOG_REG_CDIR_SHIFT (0x00000008u)
#define CSL_EMIF4F_VBUSM_ERR_LOG_REG_CDIR_RESETVAL (0x00000000u)

#define CSL_EMIF4F_VBUSM_ERR_LOG_REG_CMSTID_MASK (0x000000FFu)
#define CSL_EMIF4F_VBUSM_ERR_LOG_REG_CMSTID_SHIFT (0x00000000u)
#define CSL_EMIF4F_VBUSM_ERR_LOG_REG_CMSTID_RESETVAL (0x00000000u)

#define CSL_EMIF4F_VBUSM_ERR_LOG_RESETVAL (0x00000000u)

/* RDWR_LVL_RMP_WIN */

#define CSL_EMIF4F_RDWR_LVL_RMP_WIN_REG_RDWRLVLINC_RMP_WIN_MASK (0x00001FFFu)
#define CSL_EMIF4F_RDWR_LVL_RMP_WIN_REG_RDWRLVLINC_RMP_WIN_SHIFT (0x00000000u)
#define CSL_EMIF4F_RDWR_LVL_RMP_WIN_REG_RDWRLVLINC_RMP_WIN_RESETVAL (0x00000000u)

#define CSL_EMIF4F_RDWR_LVL_RMP_WIN_RESETVAL (0x00000000u)

/* RDWR_LVL_RMP_CTRL */

#define CSL_EMIF4F_RDWR_LVL_RMP_CTRL_REG_RDWRLVL_EN_MASK (0x80000000u)
#define CSL_EMIF4F_RDWR_LVL_RMP_CTRL_REG_RDWRLVL_EN_SHIFT (0x0000001Fu)
#define CSL_EMIF4F_RDWR_LVL_RMP_CTRL_REG_RDWRLVL_EN_RESETVAL (0x00000000u)

#define CSL_EMIF4F_RDWR_LVL_RMP_CTRL_REG_RDWRLVLINC_RMP_PRE_MASK (0x7F000000u)
#define CSL_EMIF4F_RDWR_LVL_RMP_CTRL_REG_RDWRLVLINC_RMP_PRE_SHIFT (0x00000018u)
#define CSL_EMIF4F_RDWR_LVL_RMP_CTRL_REG_RDWRLVLINC_RMP_PRE_RESETVAL (0x00000000u)

#define CSL_EMIF4F_RDWR_LVL_RMP_CTRL_REG_RDLVLINC_RMP_INT_MASK (0x00FF0000u)
#define CSL_EMIF4F_RDWR_LVL_RMP_CTRL_REG_RDLVLINC_RMP_INT_SHIFT (0x00000010u)
#define CSL_EMIF4F_RDWR_LVL_RMP_CTRL_REG_RDLVLINC_RMP_INT_RESETVAL (0x00000000u)

#define CSL_EMIF4F_RDWR_LVL_RMP_CTRL_REG_RDLVLGATEINC_RMP_INT_MASK (0x0000FF00u)
#define CSL_EMIF4F_RDWR_LVL_RMP_CTRL_REG_RDLVLGATEINC_RMP_INT_SHIFT (0x00000008u)
#define CSL_EMIF4F_RDWR_LVL_RMP_CTRL_REG_RDLVLGATEINC_RMP_INT_RESETVAL (0x00000000u)

#define CSL_EMIF4F_RDWR_LVL_RMP_CTRL_REG_WRLVLINC_RMP_INT_MASK (0x000000FFu)
#define CSL_EMIF4F_RDWR_LVL_RMP_CTRL_REG_WRLVLINC_RMP_INT_SHIFT (0x00000000u)
#define CSL_EMIF4F_RDWR_LVL_RMP_CTRL_REG_WRLVLINC_RMP_INT_RESETVAL (0x00000000u)

#define CSL_EMIF4F_RDWR_LVL_RMP_CTRL_RESETVAL (0x00000000u)

/* RDWR_LVL_CTRL */

#define CSL_EMIF4F_RDWR_LVL_CTRL_REG_RDWRLVLFULL_START_MASK (0x80000000u)
#define CSL_EMIF4F_RDWR_LVL_CTRL_REG_RDWRLVLFULL_START_SHIFT (0x0000001Fu)
#define CSL_EMIF4F_RDWR_LVL_CTRL_REG_RDWRLVLFULL_START_RESETVAL (0x00000000u)

#define CSL_EMIF4F_RDWR_LVL_CTRL_REG_RDWRLVLINC_PRE_MASK (0x7F000000u)
#define CSL_EMIF4F_RDWR_LVL_CTRL_REG_RDWRLVLINC_PRE_SHIFT (0x00000018u)
#define CSL_EMIF4F_RDWR_LVL_CTRL_REG_RDWRLVLINC_PRE_RESETVAL (0x00000000u)

#define CSL_EMIF4F_RDWR_LVL_CTRL_REG_RDLVLINC_INT_MASK (0x00FF0000u)
#define CSL_EMIF4F_RDWR_LVL_CTRL_REG_RDLVLINC_INT_SHIFT (0x00000010u)
#define CSL_EMIF4F_RDWR_LVL_CTRL_REG_RDLVLINC_INT_RESETVAL (0x00000000u)

#define CSL_EMIF4F_RDWR_LVL_CTRL_REG_RDLVLGATEINC_INT_MASK (0x0000FF00u)
#define CSL_EMIF4F_RDWR_LVL_CTRL_REG_RDLVLGATEINC_INT_SHIFT (0x00000008u)
#define CSL_EMIF4F_RDWR_LVL_CTRL_REG_RDLVLGATEINC_INT_RESETVAL (0x00000000u)

#define CSL_EMIF4F_RDWR_LVL_CTRL_REG_WRLVLINC_INT_MASK (0x000000FFu)
#define CSL_EMIF4F_RDWR_LVL_CTRL_REG_WRLVLINC_INT_SHIFT (0x00000000u)
#define CSL_EMIF4F_RDWR_LVL_CTRL_REG_WRLVLINC_INT_RESETVAL (0x00000000u)

#define CSL_EMIF4F_RDWR_LVL_CTRL_RESETVAL (0x00000000u)

/* DDR_PHY_CTRL_1 */

#define CSL_EMIF4F_DDR_PHY_CTRL_1_REG_DDR_PHY_CTRL_1_MASK (0xFFFFFFE0u)
#define CSL_EMIF4F_DDR_PHY_CTRL_1_REG_DDR_PHY_CTRL_1_SHIFT (0x00000005u)

#define CSL_EMIF4F_DDR_PHY_CTRL_1_REG_READ_LATENCY_MASK (0x0000001Fu)
#define CSL_EMIF4F_DDR_PHY_CTRL_1_REG_READ_LATENCY_SHIFT (0x00000000u)

#define CSL_EMIF4F_DDR_PHY_CTRL_1_RESETVAL (0x00000000u)

/* DDR_PHY_CTRL_1_SHDW */

#define CSL_EMIF4F_DDR_PHY_CTRL_1_SHDW_REG_DDR_PHY_CTRL_1_SHDW_MASK (0xFFFFFFE0u)
#define CSL_EMIF4F_DDR_PHY_CTRL_1_SHDW_REG_DDR_PHY_CTRL_1_SHDW_SHIFT (0x00000005u)

#define CSL_EMIF4F_DDR_PHY_CTRL_1_SHDW_REG_READ_LATENCY_SHDW_MASK (0x0000001Fu)
#define CSL_EMIF4F_DDR_PHY_CTRL_1_SHDW_REG_READ_LATENCY_SHDW_SHIFT (0x00000000u)

#define CSL_EMIF4F_DDR_PHY_CTRL_1_SHDW_RESETVAL (0x00000000u)

/* DDR_PHY_CTRL_2 */

#define CSL_EMIF4F_DDR_PHY_CTRL_2_REG_DDR_PHY_CTRL_2_MASK (0xFFFFFFFFu)
#define CSL_EMIF4F_DDR_PHY_CTRL_2_REG_DDR_PHY_CTRL_2_SHIFT (0x00000000u)

#define CSL_EMIF4F_DDR_PHY_CTRL_2_RESETVAL (0x00000000u)

/* PRI_COS_MAP */

#define CSL_EMIF4F_PRI_COS_MAP_REG_PRI_COS_MAP_EN_MASK (0x80000000u)
#define CSL_EMIF4F_PRI_COS_MAP_REG_PRI_COS_MAP_EN_SHIFT (0x0000001Fu)
#define CSL_EMIF4F_PRI_COS_MAP_REG_PRI_COS_MAP_EN_RESETVAL (0x00000000u)

#define CSL_EMIF4F_PRI_COS_MAP_REG_PRI_7_COS_MASK (0x0000C000u)
#define CSL_EMIF4F_PRI_COS_MAP_REG_PRI_7_COS_SHIFT (0x0000000Eu)
#define CSL_EMIF4F_PRI_COS_MAP_REG_PRI_7_COS_RESETVAL (0x00000000u)

#define CSL_EMIF4F_PRI_COS_MAP_REG_PRI_6_COS_MASK (0x00003000u)
#define CSL_EMIF4F_PRI_COS_MAP_REG_PRI_6_COS_SHIFT (0x0000000Cu)
#define CSL_EMIF4F_PRI_COS_MAP_REG_PRI_6_COS_RESETVAL (0x00000000u)

#define CSL_EMIF4F_PRI_COS_MAP_REG_PRI_5_COS_MASK (0x00000C00u)
#define CSL_EMIF4F_PRI_COS_MAP_REG_PRI_5_COS_SHIFT (0x0000000Au)
#define CSL_EMIF4F_PRI_COS_MAP_REG_PRI_5_COS_RESETVAL (0x00000000u)

#define CSL_EMIF4F_PRI_COS_MAP_REG_PRI_4_COS_MASK (0x00000300u)
#define CSL_EMIF4F_PRI_COS_MAP_REG_PRI_4_COS_SHIFT (0x00000008u)
#define CSL_EMIF4F_PRI_COS_MAP_REG_PRI_4_COS_RESETVAL (0x00000000u)

#define CSL_EMIF4F_PRI_COS_MAP_REG_PRI_3_COS_MASK (0x000000C0u)
#define CSL_EMIF4F_PRI_COS_MAP_REG_PRI_3_COS_SHIFT (0x00000006u)
#define CSL_EMIF4F_PRI_COS_MAP_REG_PRI_3_COS_RESETVAL (0x00000000u)

#define CSL_EMIF4F_PRI_COS_MAP_REG_PRI_2_COS_MASK (0x00000030u)
#define CSL_EMIF4F_PRI_COS_MAP_REG_PRI_2_COS_SHIFT (0x00000004u)
#define CSL_EMIF4F_PRI_COS_MAP_REG_PRI_2_COS_RESETVAL (0x00000000u)

#define CSL_EMIF4F_PRI_COS_MAP_REG_PRI_1_COS_MASK (0x0000000Cu)
#define CSL_EMIF4F_PRI_COS_MAP_REG_PRI_1_COS_SHIFT (0x00000002u)
#define CSL_EMIF4F_PRI_COS_MAP_REG_PRI_1_COS_RESETVAL (0x00000000u)

#define CSL_EMIF4F_PRI_COS_MAP_REG_PRI_0_COS_MASK (0x00000003u)
#define CSL_EMIF4F_PRI_COS_MAP_REG_PRI_0_COS_SHIFT (0x00000000u)
#define CSL_EMIF4F_PRI_COS_MAP_REG_PRI_0_COS_RESETVAL (0x00000000u)

#define CSL_EMIF4F_PRI_COS_MAP_RESETVAL  (0x00000000u)

/* MSTID_COS_1_MAP */

#define CSL_EMIF4F_MSTID_COS_1_MAP_REG_MSTID_COS_1_MAP_EN_MASK (0x80000000u)
#define CSL_EMIF4F_MSTID_COS_1_MAP_REG_MSTID_COS_1_MAP_EN_SHIFT (0x0000001Fu)
#define CSL_EMIF4F_MSTID_COS_1_MAP_REG_MSTID_COS_1_MAP_EN_RESETVAL (0x00000000u)

#define CSL_EMIF4F_MSTID_COS_1_MAP_REG_MSTID_1_COS_1_MASK (0x7F800000u)
#define CSL_EMIF4F_MSTID_COS_1_MAP_REG_MSTID_1_COS_1_SHIFT (0x00000017u)
#define CSL_EMIF4F_MSTID_COS_1_MAP_REG_MSTID_1_COS_1_RESETVAL (0x00000000u)

#define CSL_EMIF4F_MSTID_COS_1_MAP_REG_MSK_1_COS_1_MASK (0x00700000u)
#define CSL_EMIF4F_MSTID_COS_1_MAP_REG_MSK_1_COS_1_SHIFT (0x00000014u)
#define CSL_EMIF4F_MSTID_COS_1_MAP_REG_MSK_1_COS_1_RESETVAL (0x00000000u)

#define CSL_EMIF4F_MSTID_COS_1_MAP_REG_MSTID_2_COS_1_MASK (0x000FF000u)
#define CSL_EMIF4F_MSTID_COS_1_MAP_REG_MSTID_2_COS_1_SHIFT (0x0000000Cu)
#define CSL_EMIF4F_MSTID_COS_1_MAP_REG_MSTID_2_COS_1_RESETVAL (0x00000000u)

#define CSL_EMIF4F_MSTID_COS_1_MAP_REG_MSK_2_COS_1_MASK (0x00000C00u)
#define CSL_EMIF4F_MSTID_COS_1_MAP_REG_MSK_2_COS_1_SHIFT (0x0000000Au)
#define CSL_EMIF4F_MSTID_COS_1_MAP_REG_MSK_2_COS_1_RESETVAL (0x00000000u)

#define CSL_EMIF4F_MSTID_COS_1_MAP_REG_MSTID_3_COS_1_MASK (0x000003FCu)
#define CSL_EMIF4F_MSTID_COS_1_MAP_REG_MSTID_3_COS_1_SHIFT (0x00000002u)
#define CSL_EMIF4F_MSTID_COS_1_MAP_REG_MSTID_3_COS_1_RESETVAL (0x00000000u)

#define CSL_EMIF4F_MSTID_COS_1_MAP_REG_MSK_3_COS_1_MASK (0x00000003u)
#define CSL_EMIF4F_MSTID_COS_1_MAP_REG_MSK_3_COS_1_SHIFT (0x00000000u)
#define CSL_EMIF4F_MSTID_COS_1_MAP_REG_MSK_3_COS_1_RESETVAL (0x00000000u)

#define CSL_EMIF4F_MSTID_COS_1_MAP_RESETVAL (0x00000000u)

/* MSTID_COS_2_MAP */

#define CSL_EMIF4F_MSTID_COS_2_MAP_REG_MSTID_COS_2_MAP_EN_MASK (0x80000000u)
#define CSL_EMIF4F_MSTID_COS_2_MAP_REG_MSTID_COS_2_MAP_EN_SHIFT (0x0000001Fu)
#define CSL_EMIF4F_MSTID_COS_2_MAP_REG_MSTID_COS_2_MAP_EN_RESETVAL (0x00000000u)

#define CSL_EMIF4F_MSTID_COS_2_MAP_REG_MSTID_1_COS_2_MASK (0x7F800000u)
#define CSL_EMIF4F_MSTID_COS_2_MAP_REG_MSTID_1_COS_2_SHIFT (0x00000017u)
#define CSL_EMIF4F_MSTID_COS_2_MAP_REG_MSTID_1_COS_2_RESETVAL (0x00000000u)

#define CSL_EMIF4F_MSTID_COS_2_MAP_REG_MSK_1_COS_2_MASK (0x00700000u)
#define CSL_EMIF4F_MSTID_COS_2_MAP_REG_MSK_1_COS_2_SHIFT (0x00000014u)
#define CSL_EMIF4F_MSTID_COS_2_MAP_REG_MSK_1_COS_2_RESETVAL (0x00000000u)

#define CSL_EMIF4F_MSTID_COS_2_MAP_REG_MSTID_2_COS_2_MASK (0x000FF000u)
#define CSL_EMIF4F_MSTID_COS_2_MAP_REG_MSTID_2_COS_2_SHIFT (0x0000000Cu)
#define CSL_EMIF4F_MSTID_COS_2_MAP_REG_MSTID_2_COS_2_RESETVAL (0x00000000u)

#define CSL_EMIF4F_MSTID_COS_2_MAP_REG_MSK_2_COS_2_MASK (0x00000C00u)
#define CSL_EMIF4F_MSTID_COS_2_MAP_REG_MSK_2_COS_2_SHIFT (0x0000000Au)
#define CSL_EMIF4F_MSTID_COS_2_MAP_REG_MSK_2_COS_2_RESETVAL (0x00000000u)

#define CSL_EMIF4F_MSTID_COS_2_MAP_REG_MSTID_3_COS_2_MASK (0x000003FCu)
#define CSL_EMIF4F_MSTID_COS_2_MAP_REG_MSTID_3_COS_2_SHIFT (0x00000002u)
#define CSL_EMIF4F_MSTID_COS_2_MAP_REG_MSTID_3_COS_2_RESETVAL (0x00000000u)

#define CSL_EMIF4F_MSTID_COS_2_MAP_REG_MSK_3_COS_2_MASK (0x00000003u)
#define CSL_EMIF4F_MSTID_COS_2_MAP_REG_MSK_3_COS_2_SHIFT (0x00000000u)
#define CSL_EMIF4F_MSTID_COS_2_MAP_REG_MSK_3_COS_2_RESETVAL (0x00000000u)

#define CSL_EMIF4F_MSTID_COS_2_MAP_RESETVAL (0x00000000u)

/* ECC_CTRL */

#define CSL_EMIF4F_ECC_CTRL_REG_ECC_EN_MASK (0x80000000u)
#define CSL_EMIF4F_ECC_CTRL_REG_ECC_EN_SHIFT (0x0000001Fu)
#define CSL_EMIF4F_ECC_CTRL_REG_ECC_EN_RESETVAL (0x00000000u)

#define CSL_EMIF4F_ECC_CTRL_REG_ECC_ADDR_RNG_PROT_MASK (0x40000000u)
#define CSL_EMIF4F_ECC_CTRL_REG_ECC_ADDR_RNG_PROT_SHIFT (0x0000001Eu)
#define CSL_EMIF4F_ECC_CTRL_REG_ECC_ADDR_RNG_PROT_RESETVAL (0x00000000u)

#define CSL_EMIF4F_ECC_CTRL_REG_ECC_ADDR_RNG_2_EN_MASK (0x00000002u)
#define CSL_EMIF4F_ECC_CTRL_REG_ECC_ADDR_RNG_2_EN_SHIFT (0x00000001u)
#define CSL_EMIF4F_ECC_CTRL_REG_ECC_ADDR_RNG_2_EN_RESETVAL (0x00000000u)

#define CSL_EMIF4F_ECC_CTRL_REG_ECC_ADDR_RNG_1_EN_MASK (0x00000001u)
#define CSL_EMIF4F_ECC_CTRL_REG_ECC_ADDR_RNG_1_EN_SHIFT (0x00000000u)
#define CSL_EMIF4F_ECC_CTRL_REG_ECC_ADDR_RNG_1_EN_RESETVAL (0x00000000u)

#define CSL_EMIF4F_ECC_CTRL_RESETVAL     (0x00000000u)

/* ECC_ADDR_RNG_1 */

#define CSL_EMIF4F_ECC_ADDR_RNG_1_REG_ECC_END_ADDR_1_MASK (0xFFFF0000u)
#define CSL_EMIF4F_ECC_ADDR_RNG_1_REG_ECC_END_ADDR_1_SHIFT (0x00000010u)
#define CSL_EMIF4F_ECC_ADDR_RNG_1_REG_ECC_END_ADDR_1_RESETVAL (0x00000000u)

#define CSL_EMIF4F_ECC_ADDR_RNG_1_REG_ECC_STRT_ADDR_1_MASK (0x0000FFFFu)
#define CSL_EMIF4F_ECC_ADDR_RNG_1_REG_ECC_STRT_ADDR_1_SHIFT (0x00000000u)
#define CSL_EMIF4F_ECC_ADDR_RNG_1_REG_ECC_STRT_ADDR_1_RESETVAL (0x00000000u)

#define CSL_EMIF4F_ECC_ADDR_RNG_1_RESETVAL (0x00000000u)

/* ECC_ADDR_RNG_2 */

#define CSL_EMIF4F_ECC_ADDR_RNG_2_REG_ECC_END_ADDR_2_MASK (0xFFFF0000u)
#define CSL_EMIF4F_ECC_ADDR_RNG_2_REG_ECC_END_ADDR_2_SHIFT (0x00000010u)
#define CSL_EMIF4F_ECC_ADDR_RNG_2_REG_ECC_END_ADDR_2_RESETVAL (0x00000000u)

#define CSL_EMIF4F_ECC_ADDR_RNG_2_REG_ECC_STRT_ADDR_2_MASK (0x0000FFFFu)
#define CSL_EMIF4F_ECC_ADDR_RNG_2_REG_ECC_STRT_ADDR_2_SHIFT (0x00000000u)
#define CSL_EMIF4F_ECC_ADDR_RNG_2_REG_ECC_STRT_ADDR_2_RESETVAL (0x00000000u)

#define CSL_EMIF4F_ECC_ADDR_RNG_2_RESETVAL (0x00000000u)

/* RD_WR_EXEC_THRSH */

#define CSL_EMIF4F_RD_WR_EXEC_THRSH_REG_WR_THRSH_MASK (0x00001F00u)
#define CSL_EMIF4F_RD_WR_EXEC_THRSH_REG_WR_THRSH_SHIFT (0x00000008u)
#define CSL_EMIF4F_RD_WR_EXEC_THRSH_REG_WR_THRSH_RESETVAL (0x00000003u)

#define CSL_EMIF4F_RD_WR_EXEC_THRSH_REG_RD_THRSH_MASK (0x0000001Fu)
#define CSL_EMIF4F_RD_WR_EXEC_THRSH_REG_RD_THRSH_SHIFT (0x00000000u)
#define CSL_EMIF4F_RD_WR_EXEC_THRSH_REG_RD_THRSH_RESETVAL (0x00000005u)

#define CSL_EMIF4F_RD_WR_EXEC_THRSH_RESETVAL (0x00000305u)

#endif
