@REM ******************************************************************************
@REM * FILE PURPOSE: PDK Unit Test and Example Project Creator
@REM ******************************************************************************
@REM * FILE NAME: pdkProjectCreate.bat
@REM *
@REM * DESCRIPTION: 
@REM *  The script file is used to create the test and example projects of all
@REM *  components under PDK. These projects are available in the specified 
@REM *  workspace.
@REM *
@REM * USAGE:
@REM *  pdkProjectCreate.bat "C:\Program Files\Texas Instruments\pdk_C6678_1_1_1_4\packages"
@REM *      --- OR ---
@REM *  pdkProjectCreate.bat
@REM *
@REM *
@REM * Copyright (C) 2010, Texas Instruments, Inc.
@REM *****************************************************************************

@echo OFF

REM Parameter Validation: Check if the argument was passed to the batch file and
REM if so we use that else we default to the working directory where the batch 
REM file was invoked from. We convert the PDK Install path to short names because
REM otherwise the batch file commands do not work 
set tempVar=%1
IF NOT DEFINED tempVar GOTO noparameter
set PDK_SHORT_NAME=%~fs1
goto done
:noparameter
set PDK_SHORT_NAME=%~sdp0
:done

REM *****************************************************************************
REM * Version Information of the various tools etc required to build the test
REM * projects. Customers are free to modify these to meet their requirements.
REM *****************************************************************************

REM This is to control the CCS version specific project create command
REM Set to 'no' when using CCSv5 or set to 'yes' when using CCSv4
set IS_CCS_VERSION_4=no

REM Set to 'no' when using QT, EVM, VDB, or other hardware. Set to 'yes' only when using the simulator.
set IS_SIMULATOR_SUPPORT_NEEDED=no

REM Install Location for CCS
set CCS_INSTALL_PATH="C:\ti\ccsv5"

REM Workspace where the PDK projects will be created.
set MY_WORKSPACE="%PDK_SHORT_NAME%\MyexampleProjects"

REM This is Endianess of the Projects being created.
REM Valid Values are 'little' and 'big'
set ENDIAN=little

REM This is the format of the executable being created
REM Valid Values are 'ELF' and 'COFF'
set OUTPUT_FORMAT=ELF

REM Version of CG-Tools
set CGT_VERSION=7.4.0

REM Version of XDC
set XDC_VERSION=3.23.04.60

REM Version of BIOS
set BIOS_VERSION=6.33.06.50

REM Version of the IPC
set IPC_VERSION=1.24.03.32

REM Version of the PDK
set PDK_VERSION=1.1.2.5

REM PDK Part Number
set PDK_PARTNO=C6678L

REM RTSC Platform Name
set RTSC_PLATFORM_NAME=ti.platforms.evm6678

REM RTSC Target 
REM - Please ensure that you select this taking into account the
REM   OUTPUT_FORMAT and the RTSC_PLATFORM_NAME 
REM RTSC_TARGET=ti.targets.elf.C66_big_endian
set RTSC_TARGET=ti.targets.elf.C66

REM *****************************************************************************
REM *****************************************************************************
REM                 Please do NOT change anything below this
REM *****************************************************************************
REM *****************************************************************************

REM Set auto create command by default for use with CCSv5
set AUTO_CREATE_COMMAND=eclipse\eclipsec -noSplash

REM If is CCS version 4 then set auto create command for use with CCSv4
If .%IS_CCS_VERSION_4% == .yes set AUTO_CREATE_COMMAND=eclipse\jre\bin\java -jar %CCS_INSTALL_PATH%\eclipse\startup.jar

REM Set project for Silicon or QT by default
set SIMULATOR_SUPPORT_DEFINE=

REM If simulator support is needed then set the define
If .%IS_SIMULATOR_SUPPORT_NEEDED% == .yes set SIMULATOR_SUPPORT_DEFINE=-ccs.setCompilerOptions "--define SIMULATOR_SUPPORT"

REM Goto the PDK Installation Path.
pushd %PDK_SHORT_NAME%

echo *****************************************************************************
echo Detecting UnitTest Projects in PDK and importing them in the workspace %MY_WORKSPACE%

REM Search for all the test Project Files in the PDK.
for /F %%I IN ('dir /b /s *testproject.txt') do (
echo Detected Test Project: %%~nI

REM Goto each directory where the test project file is located and create the projects.
pushd %%~dI%%~pI

REM Execute the command to create the project using the parameters specified above.
%CCS_INSTALL_PATH%\%AUTO_CREATE_COMMAND% -data %MY_WORKSPACE% -application com.ti.ccstudio.apps.projectCreate -ccs.name %%~nI -ccs.outputFormat %OUTPUT_FORMAT% -ccs.device com.ti.ccstudio.deviceModel.C6000.GenericC64xPlusDevice -ccs.endianness %ENDIAN% -ccs.kind executable -ccs.cgtVersion %CGT_VERSION% -rtsc.xdcVersion %XDC_VERSION% -rtsc.enableDspBios -rtsc.biosVersion %BIOS_VERSION% -rtsc.buildProfile "debug" -rtsc.products "com.ti.rtsc.IPC:%IPC_VERSION%;com.ti.rtsc.SYSBIOS:%BIOS_VERSION%;com.ti.biosmcsdk.pdk.%PDK_PARTNO%:%PDK_VERSION%" -rtsc.platform "%RTSC_PLATFORM_NAME%" -rtsc.target %RTSC_TARGET% -ccs.rts libc.a -ccs.args %%~nI%%~xI %SIMULATOR_SUPPORT_DEFINE%

popd
)

echo *****************************************************************************
echo Detecting Example Projects in PDK and importing them in the workspace %MY_WORKSPACE%

REM Search for all the Example Project Files in the PDK.
for /F %%I IN ('dir /b /s *exampleproject.txt') do (
echo Detected Example Project: %%~nI

REM Goto each directory where the example project file is located and create the projects.
pushd %%~dI%%~pI

REM Execute the command to create the project using the parameters specified above.
%CCS_INSTALL_PATH%\%AUTO_CREATE_COMMAND% -data %MY_WORKSPACE% -application com.ti.ccstudio.apps.projectCreate -ccs.name %%~nI -ccs.outputFormat %OUTPUT_FORMAT% -ccs.device com.ti.ccstudio.deviceModel.C6000.GenericC64xPlusDevice -ccs.endianness %ENDIAN% -ccs.kind executable -ccs.cgtVersion %CGT_VERSION% -rtsc.xdcVersion %XDC_VERSION% -rtsc.enableDspBios -rtsc.biosVersion %BIOS_VERSION% -rtsc.buildProfile "debug" -rtsc.products "com.ti.rtsc.IPC:%IPC_VERSION%;com.ti.rtsc.SYSBIOS:%BIOS_VERSION%;com.ti.biosmcsdk.pdk.%PDK_PARTNO%:%PDK_VERSION%" -rtsc.platform "%RTSC_PLATFORM_NAME%" -rtsc.target %RTSC_TARGET% -ccs.rts libc.a -ccs.args %%~nI%%~xI %SIMULATOR_SUPPORT_DEFINE%

popd
)

popd

