/*
 *  ======== package.xs ========
 *
 */


/*
 *  ======== Package.getLibs ========
 *  This function is called when a program's configuration files are
 *  being generated and it returns the name of a library appropriate
 *  for the program's configuration.
 */

function getLibs(prog)
{
    var lib = "";
    var cslSettings = this.Settings;

    /* COFF: BIG or LITTLE endian? */
    if (prog.build.target.suffix == "64Pe")
    {
        /* 64P COFF BIG: INTC or NO */
        if (cslSettings.useCSLIntcLib == true)
            lib = "lib/ti.csl.a64Pe;lib/ti.csl.intc.a64Pe";
        else
            lib = "lib/ti.csl.a64Pe";
    }
    else if (prog.build.target.suffix == "64P")
    {
        /* 64P COFF LITTLE: INTC or NO */
        if (cslSettings.useCSLIntcLib == true)
            lib = "lib/ti.csl.a64P;lib/ti.csl.intc.a64P";
        else
            lib = "lib/ti.csl.a64P";
    }
    else if (prog.build.target.suffix == "e64Pe")
    {
        /* 64P ELF BIG: INTC or NO */
        if (cslSettings.useCSLIntcLib == true)
            lib = "lib/ti.csl.ae64Pe;lib/ti.csl.intc.ae64Pe";
        else
            lib = "lib/ti.csl.ae64Pe";
    }
    else if (prog.build.target.suffix == "e64P")
    {
        /* 64P ELF LITTLE: INTC or NO */
        if (cslSettings.useCSLIntcLib == true)
            lib = "lib/ti.csl.ae64P;lib/ti.csl.intc.ae64P";
        else
            lib = "lib/ti.csl.ae64P";
    }
    else if (prog.build.target.suffix == "e66")
    {
        /* 66 ELF LITTLE: INTC or NO */
        if (cslSettings.useCSLIntcLib == true)
            lib = "lib/ti.csl.ae66;lib/ti.csl.intc.ae66";
        else
            lib = "lib/ti.csl.ae66";
    }
    else if (prog.build.target.suffix == "e66e")
    {
        /* 66 ELF BIG: INTC or NO */
        if (cslSettings.useCSLIntcLib == true)
            lib = "lib/ti.csl.ae66e;lib/ti.csl.intc.ae66e";
        else
            lib = "lib/ti.csl.ae66e";
    }
    return lib;
}

/*
 *  ======== package.close ========
 */
function close()
{    
    if (xdc.om.$name != 'cfg') {
        return;
    }
}

