/********************************************************************
* Copyright (C) 2003-2010 Texas Instruments Incorporated.
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/
#ifndef _CSLR_MSMC_H_
#define _CSLR_MSMC_H_

/* CSL Modification:
 *  The file has been modified from the AUTOGEN file for the following
 *  reasons:-
 *      a) Removed the redundant 'CSL_MsmcSbndRegs' structure for SBND
 *         since this was a data structure with a single field.
 *      b) Modified the 'CSL_MsmcSms_mpax_prividRegs' to the the new
 *         counterpart 'CSL_MsmcSms_mpax_per_prividRegs' which in turn
 *         now includes an array of 8 MPAXH and MPAXL registers.
 *      c) Modified the 'CSL_MsmcSes_mpax_prividRegs' to the the new
 *         counterpart 'CSL_MsmcSes_mpax_per_prividRegs' which in turn
 *         now includes an array of 8 MPAXH and MPAXL registers.
 *      d) Modified the header file includes to be RTSC compliant
 */

#include <ti/csl/cslr.h>
#include <ti/csl/tistdtypes.h>

/* Minimum unit = 1 byte */

/**************************************************************************\
* Register Overlay Structure for SBND
\**************************************************************************/

typedef struct
{
    volatile Uint32 MPAXL;
    volatile Uint32 MPAXH;
}CSL_Msmc_Control_Regs;

/**************************************************************************\
* Register Overlay Structure for SMS_MPAX_per_PrivID
\**************************************************************************/
typedef struct
{
    CSL_Msmc_Control_Regs SMS[8];
} CSL_MsmcSms_mpax_per_prividRegs;

/**************************************************************************\
* Register Overlay Structure for SES_MPAX_per_PrivID
\**************************************************************************/
typedef struct
{
      CSL_Msmc_Control_Regs SES[8];
} CSL_MsmcSes_mpax_per_prividRegs;

/**************************************************************************\
* Register Overlay Structure
\**************************************************************************/
typedef struct  {
    volatile Uint32 PID;
    volatile Uint32 SMCC;
    volatile Uint32 SMCERRAR;
    volatile Uint32 SMCERRXR;
    volatile Uint32 SMEDCC;
    volatile Uint32 SMCEA;
    volatile Uint32 SMSECC;
    volatile Uint32 SMPFAR;
    volatile Uint32 SMPFXR;
    volatile Uint32 SMPFR;
    volatile Uint32 SMPFCR;
    volatile Uint32 SMSTA;
    volatile Uint32 SBND[8];
    volatile Uint32 SBNDM;
    volatile Uint32 SBNDE;
    volatile Uint32 SMEDCTST;
    volatile Uint32 CFGLCK;
    volatile Uint32 CFGULCK;
    volatile Uint32 CFGLCKSTAT;
    volatile Uint32 SMS_MPAX_LCK;
    volatile Uint32 SMS_MPAX_ULCK;
    volatile Uint32 SMS_MPAX_LCKSTAT;
    volatile Uint32 SES_MPAX_LCK;
    volatile Uint32 SES_MPAX_ULCK;
    volatile Uint32 SES_MPAX_LCKSTAT;
    volatile Uint32 SMESTAT;
    volatile Uint32 SMIRSTAT;
    volatile Uint32 SMIRC;
    volatile Uint32 SMIESTAT;
    volatile Uint32 SMIEC;
    volatile Uint8 RSVD0[12];
    volatile Uint32 SMATH;
    volatile Uint32 SMAH;
    volatile Uint32 SMARM;
    volatile Uint32 SMAWM;
    volatile Uint32 SMAV;
    volatile Uint32 SMAMP;
    volatile Uint32 SMAEP;
    volatile Uint32 SMAC;
    volatile Uint32 SMCFG;
    volatile Uint32 SMNCERRAR;
    volatile Uint32 SMNCERRXR;
    volatile Uint32 SMNCEA;
    volatile Uint8 RSVD1[304];
    CSL_MsmcSms_mpax_per_prividRegs SMS_MPAX_PER_PRIVID[16];
    CSL_MsmcSes_mpax_per_prividRegs SES_MPAX_PER_PRIVID[16];
} CSL_MsmcRegs;

/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* SMS_MPAXL_0 */

#define CSL_MSMC_SMS_MPAXL_0_UX_MASK     (0x00000001u)
#define CSL_MSMC_SMS_MPAXL_0_UX_SHIFT    (0x00000000u)
#define CSL_MSMC_SMS_MPAXL_0_UX_RESETVAL (0x00000001u)

#define CSL_MSMC_SMS_MPAXL_0_UW_MASK     (0x00000002u)
#define CSL_MSMC_SMS_MPAXL_0_UW_SHIFT    (0x00000001u)
#define CSL_MSMC_SMS_MPAXL_0_UW_RESETVAL (0x00000001u)

#define CSL_MSMC_SMS_MPAXL_0_UR_MASK     (0x00000004u)
#define CSL_MSMC_SMS_MPAXL_0_UR_SHIFT    (0x00000002u)
#define CSL_MSMC_SMS_MPAXL_0_UR_RESETVAL (0x00000001u)

#define CSL_MSMC_SMS_MPAXL_0_SX_MASK     (0x00000008u)
#define CSL_MSMC_SMS_MPAXL_0_SX_SHIFT    (0x00000003u)
#define CSL_MSMC_SMS_MPAXL_0_SX_RESETVAL (0x00000001u)

#define CSL_MSMC_SMS_MPAXL_0_SW_MASK     (0x00000010u)
#define CSL_MSMC_SMS_MPAXL_0_SW_SHIFT    (0x00000004u)
#define CSL_MSMC_SMS_MPAXL_0_SW_RESETVAL (0x00000001u)

#define CSL_MSMC_SMS_MPAXL_0_SR_MASK     (0x00000020u)
#define CSL_MSMC_SMS_MPAXL_0_SR_SHIFT    (0x00000005u)
#define CSL_MSMC_SMS_MPAXL_0_SR_RESETVAL (0x00000001u)



#define CSL_MSMC_SMS_MPAXL_0_RADDR_MASK  (0x000FFF00u)
#define CSL_MSMC_SMS_MPAXL_0_RADDR_SHIFT (0x00000008u)
#define CSL_MSMC_SMS_MPAXL_0_RADDR_RESETVAL (0x00000000u)

#define CSL_MSMC_SMS_MPAXL_0__CNST_MASK  (0x0FF00000u)
#define CSL_MSMC_SMS_MPAXL_0__CNST_SHIFT (0x00000014u)
#define CSL_MSMC_SMS_MPAXL_0__CNST_RESETVAL (0x0000000Cu)


#define CSL_MSMC_SMS_MPAXL_0_RESETVAL    (0x00C000BFu)

/* SMS_MPAXH_0 */

#define CSL_MSMC_SMS_MPAXH_0_SEGSZ_MASK  (0x0000001Fu)
#define CSL_MSMC_SMS_MPAXH_0_SEGSZ_SHIFT (0x00000000u)
#define CSL_MSMC_SMS_MPAXH_0_SEGSZ_RESETVAL (0x00000017u)


#define CSL_MSMC_SMS_MPAXH_0_BADDR_MASK  (0x00FFF000u)
#define CSL_MSMC_SMS_MPAXH_0_BADDR_SHIFT (0x0000000Cu)
#define CSL_MSMC_SMS_MPAXH_0_BADDR_RESETVAL (0x00000000u)

#define CSL_MSMC_SMS_MPAXH_0__CNST_MASK  (0xFF000000u)
#define CSL_MSMC_SMS_MPAXH_0__CNST_SHIFT (0x00000018u)
#define CSL_MSMC_SMS_MPAXH_0__CNST_RESETVAL (0x0000000Cu)

#define CSL_MSMC_SMS_MPAXH_0_RESETVAL    (0x0C000017u)

/* SMS_MPAXL_1 */

#define CSL_MSMC_SMS_MPAXL_1_UX_MASK     (0x00000001u)
#define CSL_MSMC_SMS_MPAXL_1_UX_SHIFT    (0x00000000u)
#define CSL_MSMC_SMS_MPAXL_1_UX_RESETVAL (0x00000000u)

#define CSL_MSMC_SMS_MPAXL_1_UW_MASK     (0x00000002u)
#define CSL_MSMC_SMS_MPAXL_1_UW_SHIFT    (0x00000001u)
#define CSL_MSMC_SMS_MPAXL_1_UW_RESETVAL (0x00000000u)

#define CSL_MSMC_SMS_MPAXL_1_UR_MASK     (0x00000004u)
#define CSL_MSMC_SMS_MPAXL_1_UR_SHIFT    (0x00000002u)
#define CSL_MSMC_SMS_MPAXL_1_UR_RESETVAL (0x00000000u)

#define CSL_MSMC_SMS_MPAXL_1_SX_MASK     (0x00000008u)
#define CSL_MSMC_SMS_MPAXL_1_SX_SHIFT    (0x00000003u)
#define CSL_MSMC_SMS_MPAXL_1_SX_RESETVAL (0x00000000u)

#define CSL_MSMC_SMS_MPAXL_1_SW_MASK     (0x00000010u)
#define CSL_MSMC_SMS_MPAXL_1_SW_SHIFT    (0x00000004u)
#define CSL_MSMC_SMS_MPAXL_1_SW_RESETVAL (0x00000000u)

#define CSL_MSMC_SMS_MPAXL_1_SR_MASK     (0x00000020u)
#define CSL_MSMC_SMS_MPAXL_1_SR_SHIFT    (0x00000005u)
#define CSL_MSMC_SMS_MPAXL_1_SR_RESETVAL (0x00000000u)



#define CSL_MSMC_SMS_MPAXL_1_RADDR_MASK  (0x000FFF00u)
#define CSL_MSMC_SMS_MPAXL_1_RADDR_SHIFT (0x00000008u)
#define CSL_MSMC_SMS_MPAXL_1_RADDR_RESETVAL (0x00000000u)

#define CSL_MSMC_SMS_MPAXL_1__CNST_MASK  (0x0FF00000u)
#define CSL_MSMC_SMS_MPAXL_1__CNST_SHIFT (0x00000014u)
#define CSL_MSMC_SMS_MPAXL_1__CNST_RESETVAL (0x0000000Cu)


#define CSL_MSMC_SMS_MPAXL_1_RESETVAL    (0x00C00000u)

/* SMS_MPAXH_1 */

#define CSL_MSMC_SMS_MPAXH_1_SEGSZ_MASK  (0x0000001Fu)
#define CSL_MSMC_SMS_MPAXH_1_SEGSZ_SHIFT (0x00000000u)
#define CSL_MSMC_SMS_MPAXH_1_SEGSZ_RESETVAL (0x00000000u)


#define CSL_MSMC_SMS_MPAXH_1_BADDR_MASK  (0x00FFF000u)
#define CSL_MSMC_SMS_MPAXH_1_BADDR_SHIFT (0x0000000Cu)
#define CSL_MSMC_SMS_MPAXH_1_BADDR_RESETVAL (0x00000000u)

#define CSL_MSMC_SMS_MPAXH_1__CNST_MASK  (0xFF000000u)
#define CSL_MSMC_SMS_MPAXH_1__CNST_SHIFT (0x00000018u)
#define CSL_MSMC_SMS_MPAXH_1__CNST_RESETVAL (0x0000000Cu)

#define CSL_MSMC_SMS_MPAXH_1_RESETVAL    (0x0C000000u)

/* SMS_MPAXL_2 */

#define CSL_MSMC_SMS_MPAXL_2_UX_MASK     (0x00000001u)
#define CSL_MSMC_SMS_MPAXL_2_UX_SHIFT    (0x00000000u)
#define CSL_MSMC_SMS_MPAXL_2_UX_RESETVAL (0x00000000u)

#define CSL_MSMC_SMS_MPAXL_2_UW_MASK     (0x00000002u)
#define CSL_MSMC_SMS_MPAXL_2_UW_SHIFT    (0x00000001u)
#define CSL_MSMC_SMS_MPAXL_2_UW_RESETVAL (0x00000000u)

#define CSL_MSMC_SMS_MPAXL_2_UR_MASK     (0x00000004u)
#define CSL_MSMC_SMS_MPAXL_2_UR_SHIFT    (0x00000002u)
#define CSL_MSMC_SMS_MPAXL_2_UR_RESETVAL (0x00000000u)

#define CSL_MSMC_SMS_MPAXL_2_SX_MASK     (0x00000008u)
#define CSL_MSMC_SMS_MPAXL_2_SX_SHIFT    (0x00000003u)
#define CSL_MSMC_SMS_MPAXL_2_SX_RESETVAL (0x00000000u)

#define CSL_MSMC_SMS_MPAXL_2_SW_MASK     (0x00000010u)
#define CSL_MSMC_SMS_MPAXL_2_SW_SHIFT    (0x00000004u)
#define CSL_MSMC_SMS_MPAXL_2_SW_RESETVAL (0x00000000u)

#define CSL_MSMC_SMS_MPAXL_2_SR_MASK     (0x00000020u)
#define CSL_MSMC_SMS_MPAXL_2_SR_SHIFT    (0x00000005u)
#define CSL_MSMC_SMS_MPAXL_2_SR_RESETVAL (0x00000000u)



#define CSL_MSMC_SMS_MPAXL_2_RADDR_MASK  (0x000FFF00u)
#define CSL_MSMC_SMS_MPAXL_2_RADDR_SHIFT (0x00000008u)
#define CSL_MSMC_SMS_MPAXL_2_RADDR_RESETVAL (0x00000000u)

#define CSL_MSMC_SMS_MPAXL_2__CNST_MASK  (0x0FF00000u)
#define CSL_MSMC_SMS_MPAXL_2__CNST_SHIFT (0x00000014u)
#define CSL_MSMC_SMS_MPAXL_2__CNST_RESETVAL (0x0000000Cu)


#define CSL_MSMC_SMS_MPAXL_2_RESETVAL    (0x00C00000u)

/* SMS_MPAXH_2 */

#define CSL_MSMC_SMS_MPAXH_2_SEGSZ_MASK  (0x0000001Fu)
#define CSL_MSMC_SMS_MPAXH_2_SEGSZ_SHIFT (0x00000000u)
#define CSL_MSMC_SMS_MPAXH_2_SEGSZ_RESETVAL (0x00000000u)


#define CSL_MSMC_SMS_MPAXH_2_BADDR_MASK  (0x00FFF000u)
#define CSL_MSMC_SMS_MPAXH_2_BADDR_SHIFT (0x0000000Cu)
#define CSL_MSMC_SMS_MPAXH_2_BADDR_RESETVAL (0x00000000u)

#define CSL_MSMC_SMS_MPAXH_2__CNST_MASK  (0xFF000000u)
#define CSL_MSMC_SMS_MPAXH_2__CNST_SHIFT (0x00000018u)
#define CSL_MSMC_SMS_MPAXH_2__CNST_RESETVAL (0x0000000Cu)

#define CSL_MSMC_SMS_MPAXH_2_RESETVAL    (0x0C000000u)

/* SMS_MPAXL_3 */

#define CSL_MSMC_SMS_MPAXL_3_UX_MASK     (0x00000001u)
#define CSL_MSMC_SMS_MPAXL_3_UX_SHIFT    (0x00000000u)
#define CSL_MSMC_SMS_MPAXL_3_UX_RESETVAL (0x00000000u)

#define CSL_MSMC_SMS_MPAXL_3_UW_MASK     (0x00000002u)
#define CSL_MSMC_SMS_MPAXL_3_UW_SHIFT    (0x00000001u)
#define CSL_MSMC_SMS_MPAXL_3_UW_RESETVAL (0x00000000u)

#define CSL_MSMC_SMS_MPAXL_3_UR_MASK     (0x00000004u)
#define CSL_MSMC_SMS_MPAXL_3_UR_SHIFT    (0x00000002u)
#define CSL_MSMC_SMS_MPAXL_3_UR_RESETVAL (0x00000000u)

#define CSL_MSMC_SMS_MPAXL_3_SX_MASK     (0x00000008u)
#define CSL_MSMC_SMS_MPAXL_3_SX_SHIFT    (0x00000003u)
#define CSL_MSMC_SMS_MPAXL_3_SX_RESETVAL (0x00000000u)

#define CSL_MSMC_SMS_MPAXL_3_SW_MASK     (0x00000010u)
#define CSL_MSMC_SMS_MPAXL_3_SW_SHIFT    (0x00000004u)
#define CSL_MSMC_SMS_MPAXL_3_SW_RESETVAL (0x00000000u)

#define CSL_MSMC_SMS_MPAXL_3_SR_MASK     (0x00000020u)
#define CSL_MSMC_SMS_MPAXL_3_SR_SHIFT    (0x00000005u)
#define CSL_MSMC_SMS_MPAXL_3_SR_RESETVAL (0x00000000u)



#define CSL_MSMC_SMS_MPAXL_3_RADDR_MASK  (0x000FFF00u)
#define CSL_MSMC_SMS_MPAXL_3_RADDR_SHIFT (0x00000008u)
#define CSL_MSMC_SMS_MPAXL_3_RADDR_RESETVAL (0x00000000u)

#define CSL_MSMC_SMS_MPAXL_3__CNST_MASK  (0x0FF00000u)
#define CSL_MSMC_SMS_MPAXL_3__CNST_SHIFT (0x00000014u)
#define CSL_MSMC_SMS_MPAXL_3__CNST_RESETVAL (0x0000000Cu)


#define CSL_MSMC_SMS_MPAXL_3_RESETVAL    (0x00C00000u)

/* SMS_MPAXH_3 */

#define CSL_MSMC_SMS_MPAXH_3_SEGSZ_MASK  (0x0000001Fu)
#define CSL_MSMC_SMS_MPAXH_3_SEGSZ_SHIFT (0x00000000u)
#define CSL_MSMC_SMS_MPAXH_3_SEGSZ_RESETVAL (0x00000000u)


#define CSL_MSMC_SMS_MPAXH_3_BADDR_MASK  (0x00FFF000u)
#define CSL_MSMC_SMS_MPAXH_3_BADDR_SHIFT (0x0000000Cu)
#define CSL_MSMC_SMS_MPAXH_3_BADDR_RESETVAL (0x00000000u)

#define CSL_MSMC_SMS_MPAXH_3__CNST_MASK  (0xFF000000u)
#define CSL_MSMC_SMS_MPAXH_3__CNST_SHIFT (0x00000018u)
#define CSL_MSMC_SMS_MPAXH_3__CNST_RESETVAL (0x0000000Cu)

#define CSL_MSMC_SMS_MPAXH_3_RESETVAL    (0x0C000000u)

/* SMS_MPAXL_4 */

#define CSL_MSMC_SMS_MPAXL_4_UX_MASK     (0x00000001u)
#define CSL_MSMC_SMS_MPAXL_4_UX_SHIFT    (0x00000000u)
#define CSL_MSMC_SMS_MPAXL_4_UX_RESETVAL (0x00000000u)

#define CSL_MSMC_SMS_MPAXL_4_UW_MASK     (0x00000002u)
#define CSL_MSMC_SMS_MPAXL_4_UW_SHIFT    (0x00000001u)
#define CSL_MSMC_SMS_MPAXL_4_UW_RESETVAL (0x00000000u)

#define CSL_MSMC_SMS_MPAXL_4_UR_MASK     (0x00000004u)
#define CSL_MSMC_SMS_MPAXL_4_UR_SHIFT    (0x00000002u)
#define CSL_MSMC_SMS_MPAXL_4_UR_RESETVAL (0x00000000u)

#define CSL_MSMC_SMS_MPAXL_4_SX_MASK     (0x00000008u)
#define CSL_MSMC_SMS_MPAXL_4_SX_SHIFT    (0x00000003u)
#define CSL_MSMC_SMS_MPAXL_4_SX_RESETVAL (0x00000000u)

#define CSL_MSMC_SMS_MPAXL_4_SW_MASK     (0x00000010u)
#define CSL_MSMC_SMS_MPAXL_4_SW_SHIFT    (0x00000004u)
#define CSL_MSMC_SMS_MPAXL_4_SW_RESETVAL (0x00000000u)

#define CSL_MSMC_SMS_MPAXL_4_SR_MASK     (0x00000020u)
#define CSL_MSMC_SMS_MPAXL_4_SR_SHIFT    (0x00000005u)
#define CSL_MSMC_SMS_MPAXL_4_SR_RESETVAL (0x00000000u)



#define CSL_MSMC_SMS_MPAXL_4_RADDR_MASK  (0x000FFF00u)
#define CSL_MSMC_SMS_MPAXL_4_RADDR_SHIFT (0x00000008u)
#define CSL_MSMC_SMS_MPAXL_4_RADDR_RESETVAL (0x00000000u)

#define CSL_MSMC_SMS_MPAXL_4__CNST_MASK  (0x0FF00000u)
#define CSL_MSMC_SMS_MPAXL_4__CNST_SHIFT (0x00000014u)
#define CSL_MSMC_SMS_MPAXL_4__CNST_RESETVAL (0x0000000Cu)


#define CSL_MSMC_SMS_MPAXL_4_RESETVAL    (0x00C00000u)

/* SMS_MPAXH_4 */

#define CSL_MSMC_SMS_MPAXH_4_SEGSZ_MASK  (0x0000001Fu)
#define CSL_MSMC_SMS_MPAXH_4_SEGSZ_SHIFT (0x00000000u)
#define CSL_MSMC_SMS_MPAXH_4_SEGSZ_RESETVAL (0x00000000u)


#define CSL_MSMC_SMS_MPAXH_4_BADDR_MASK  (0x00FFF000u)
#define CSL_MSMC_SMS_MPAXH_4_BADDR_SHIFT (0x0000000Cu)
#define CSL_MSMC_SMS_MPAXH_4_BADDR_RESETVAL (0x00000000u)

#define CSL_MSMC_SMS_MPAXH_4__CNST_MASK  (0xFF000000u)
#define CSL_MSMC_SMS_MPAXH_4__CNST_SHIFT (0x00000018u)
#define CSL_MSMC_SMS_MPAXH_4__CNST_RESETVAL (0x0000000Cu)

#define CSL_MSMC_SMS_MPAXH_4_RESETVAL    (0x0C000000u)

/* SMS_MPAXL_5 */

#define CSL_MSMC_SMS_MPAXL_5_UX_MASK     (0x00000001u)
#define CSL_MSMC_SMS_MPAXL_5_UX_SHIFT    (0x00000000u)
#define CSL_MSMC_SMS_MPAXL_5_UX_RESETVAL (0x00000000u)

#define CSL_MSMC_SMS_MPAXL_5_UW_MASK     (0x00000002u)
#define CSL_MSMC_SMS_MPAXL_5_UW_SHIFT    (0x00000001u)
#define CSL_MSMC_SMS_MPAXL_5_UW_RESETVAL (0x00000000u)

#define CSL_MSMC_SMS_MPAXL_5_UR_MASK     (0x00000004u)
#define CSL_MSMC_SMS_MPAXL_5_UR_SHIFT    (0x00000002u)
#define CSL_MSMC_SMS_MPAXL_5_UR_RESETVAL (0x00000000u)

#define CSL_MSMC_SMS_MPAXL_5_SX_MASK     (0x00000008u)
#define CSL_MSMC_SMS_MPAXL_5_SX_SHIFT    (0x00000003u)
#define CSL_MSMC_SMS_MPAXL_5_SX_RESETVAL (0x00000000u)

#define CSL_MSMC_SMS_MPAXL_5_SW_MASK     (0x00000010u)
#define CSL_MSMC_SMS_MPAXL_5_SW_SHIFT    (0x00000004u)
#define CSL_MSMC_SMS_MPAXL_5_SW_RESETVAL (0x00000000u)

#define CSL_MSMC_SMS_MPAXL_5_SR_MASK     (0x00000020u)
#define CSL_MSMC_SMS_MPAXL_5_SR_SHIFT    (0x00000005u)
#define CSL_MSMC_SMS_MPAXL_5_SR_RESETVAL (0x00000000u)



#define CSL_MSMC_SMS_MPAXL_5_RADDR_MASK  (0x000FFF00u)
#define CSL_MSMC_SMS_MPAXL_5_RADDR_SHIFT (0x00000008u)
#define CSL_MSMC_SMS_MPAXL_5_RADDR_RESETVAL (0x00000000u)

#define CSL_MSMC_SMS_MPAXL_5__CNST_MASK  (0x0FF00000u)
#define CSL_MSMC_SMS_MPAXL_5__CNST_SHIFT (0x00000014u)
#define CSL_MSMC_SMS_MPAXL_5__CNST_RESETVAL (0x0000000Cu)


#define CSL_MSMC_SMS_MPAXL_5_RESETVAL    (0x00C00000u)

/* SMS_MPAXH_5 */

#define CSL_MSMC_SMS_MPAXH_5_SEGSZ_MASK  (0x0000001Fu)
#define CSL_MSMC_SMS_MPAXH_5_SEGSZ_SHIFT (0x00000000u)
#define CSL_MSMC_SMS_MPAXH_5_SEGSZ_RESETVAL (0x00000000u)


#define CSL_MSMC_SMS_MPAXH_5_BADDR_MASK  (0x00FFF000u)
#define CSL_MSMC_SMS_MPAXH_5_BADDR_SHIFT (0x0000000Cu)
#define CSL_MSMC_SMS_MPAXH_5_BADDR_RESETVAL (0x00000000u)

#define CSL_MSMC_SMS_MPAXH_5__CNST_MASK  (0xFF000000u)
#define CSL_MSMC_SMS_MPAXH_5__CNST_SHIFT (0x00000018u)
#define CSL_MSMC_SMS_MPAXH_5__CNST_RESETVAL (0x0000000Cu)

#define CSL_MSMC_SMS_MPAXH_5_RESETVAL    (0x0C000000u)

/* SMS_MPAXL_6 */

#define CSL_MSMC_SMS_MPAXL_6_UX_MASK     (0x00000001u)
#define CSL_MSMC_SMS_MPAXL_6_UX_SHIFT    (0x00000000u)
#define CSL_MSMC_SMS_MPAXL_6_UX_RESETVAL (0x00000000u)

#define CSL_MSMC_SMS_MPAXL_6_UW_MASK     (0x00000002u)
#define CSL_MSMC_SMS_MPAXL_6_UW_SHIFT    (0x00000001u)
#define CSL_MSMC_SMS_MPAXL_6_UW_RESETVAL (0x00000000u)

#define CSL_MSMC_SMS_MPAXL_6_UR_MASK     (0x00000004u)
#define CSL_MSMC_SMS_MPAXL_6_UR_SHIFT    (0x00000002u)
#define CSL_MSMC_SMS_MPAXL_6_UR_RESETVAL (0x00000000u)

#define CSL_MSMC_SMS_MPAXL_6_SX_MASK     (0x00000008u)
#define CSL_MSMC_SMS_MPAXL_6_SX_SHIFT    (0x00000003u)
#define CSL_MSMC_SMS_MPAXL_6_SX_RESETVAL (0x00000000u)

#define CSL_MSMC_SMS_MPAXL_6_SW_MASK     (0x00000010u)
#define CSL_MSMC_SMS_MPAXL_6_SW_SHIFT    (0x00000004u)
#define CSL_MSMC_SMS_MPAXL_6_SW_RESETVAL (0x00000000u)

#define CSL_MSMC_SMS_MPAXL_6_SR_MASK     (0x00000020u)
#define CSL_MSMC_SMS_MPAXL_6_SR_SHIFT    (0x00000005u)
#define CSL_MSMC_SMS_MPAXL_6_SR_RESETVAL (0x00000000u)



#define CSL_MSMC_SMS_MPAXL_6_RADDR_MASK  (0x000FFF00u)
#define CSL_MSMC_SMS_MPAXL_6_RADDR_SHIFT (0x00000008u)
#define CSL_MSMC_SMS_MPAXL_6_RADDR_RESETVAL (0x00000000u)

#define CSL_MSMC_SMS_MPAXL_6__CNST_MASK  (0x0FF00000u)
#define CSL_MSMC_SMS_MPAXL_6__CNST_SHIFT (0x00000014u)
#define CSL_MSMC_SMS_MPAXL_6__CNST_RESETVAL (0x0000000Cu)


#define CSL_MSMC_SMS_MPAXL_6_RESETVAL    (0x00C00000u)

/* SMS_MPAXH_6 */

#define CSL_MSMC_SMS_MPAXH_6_SEGSZ_MASK  (0x0000001Fu)
#define CSL_MSMC_SMS_MPAXH_6_SEGSZ_SHIFT (0x00000000u)
#define CSL_MSMC_SMS_MPAXH_6_SEGSZ_RESETVAL (0x00000000u)


#define CSL_MSMC_SMS_MPAXH_6_BADDR_MASK  (0x00FFF000u)
#define CSL_MSMC_SMS_MPAXH_6_BADDR_SHIFT (0x0000000Cu)
#define CSL_MSMC_SMS_MPAXH_6_BADDR_RESETVAL (0x00000000u)

#define CSL_MSMC_SMS_MPAXH_6__CNST_MASK  (0xFF000000u)
#define CSL_MSMC_SMS_MPAXH_6__CNST_SHIFT (0x00000018u)
#define CSL_MSMC_SMS_MPAXH_6__CNST_RESETVAL (0x0000000Cu)

#define CSL_MSMC_SMS_MPAXH_6_RESETVAL    (0x0C000000u)

/* SMS_MPAXL_7 */

#define CSL_MSMC_SMS_MPAXL_7_UX_MASK     (0x00000001u)
#define CSL_MSMC_SMS_MPAXL_7_UX_SHIFT    (0x00000000u)
#define CSL_MSMC_SMS_MPAXL_7_UX_RESETVAL (0x00000000u)

#define CSL_MSMC_SMS_MPAXL_7_UW_MASK     (0x00000002u)
#define CSL_MSMC_SMS_MPAXL_7_UW_SHIFT    (0x00000001u)
#define CSL_MSMC_SMS_MPAXL_7_UW_RESETVAL (0x00000000u)

#define CSL_MSMC_SMS_MPAXL_7_UR_MASK     (0x00000004u)
#define CSL_MSMC_SMS_MPAXL_7_UR_SHIFT    (0x00000002u)
#define CSL_MSMC_SMS_MPAXL_7_UR_RESETVAL (0x00000000u)

#define CSL_MSMC_SMS_MPAXL_7_SX_MASK     (0x00000008u)
#define CSL_MSMC_SMS_MPAXL_7_SX_SHIFT    (0x00000003u)
#define CSL_MSMC_SMS_MPAXL_7_SX_RESETVAL (0x00000000u)

#define CSL_MSMC_SMS_MPAXL_7_SW_MASK     (0x00000010u)
#define CSL_MSMC_SMS_MPAXL_7_SW_SHIFT    (0x00000004u)
#define CSL_MSMC_SMS_MPAXL_7_SW_RESETVAL (0x00000000u)

#define CSL_MSMC_SMS_MPAXL_7_SR_MASK     (0x00000020u)
#define CSL_MSMC_SMS_MPAXL_7_SR_SHIFT    (0x00000005u)
#define CSL_MSMC_SMS_MPAXL_7_SR_RESETVAL (0x00000000u)



#define CSL_MSMC_SMS_MPAXL_7_RADDR_MASK  (0x000FFF00u)
#define CSL_MSMC_SMS_MPAXL_7_RADDR_SHIFT (0x00000008u)
#define CSL_MSMC_SMS_MPAXL_7_RADDR_RESETVAL (0x00000000u)

#define CSL_MSMC_SMS_MPAXL_7__CNST_MASK  (0x0FF00000u)
#define CSL_MSMC_SMS_MPAXL_7__CNST_SHIFT (0x00000014u)
#define CSL_MSMC_SMS_MPAXL_7__CNST_RESETVAL (0x0000000Cu)


#define CSL_MSMC_SMS_MPAXL_7_RESETVAL    (0x00C00000u)

/* SMS_MPAXH_7 */

#define CSL_MSMC_SMS_MPAXH_7_SEGSZ_MASK  (0x0000001Fu)
#define CSL_MSMC_SMS_MPAXH_7_SEGSZ_SHIFT (0x00000000u)
#define CSL_MSMC_SMS_MPAXH_7_SEGSZ_RESETVAL (0x00000000u)


#define CSL_MSMC_SMS_MPAXH_7_BADDR_MASK  (0x00FFF000u)
#define CSL_MSMC_SMS_MPAXH_7_BADDR_SHIFT (0x0000000Cu)
#define CSL_MSMC_SMS_MPAXH_7_BADDR_RESETVAL (0x00000000u)

#define CSL_MSMC_SMS_MPAXH_7__CNST_MASK  (0xFF000000u)
#define CSL_MSMC_SMS_MPAXH_7__CNST_SHIFT (0x00000018u)
#define CSL_MSMC_SMS_MPAXH_7__CNST_RESETVAL (0x0000000Cu)

#define CSL_MSMC_SMS_MPAXH_7_RESETVAL    (0x0C000000u)

/* SES_MPAXL_0 */

#define CSL_MSMC_SES_MPAXL_0_UX_MASK     (0x00000001u)
#define CSL_MSMC_SES_MPAXL_0_UX_SHIFT    (0x00000000u)
#define CSL_MSMC_SES_MPAXL_0_UX_RESETVAL (0x00000001u)

#define CSL_MSMC_SES_MPAXL_0_UW_MASK     (0x00000002u)
#define CSL_MSMC_SES_MPAXL_0_UW_SHIFT    (0x00000001u)
#define CSL_MSMC_SES_MPAXL_0_UW_RESETVAL (0x00000001u)

#define CSL_MSMC_SES_MPAXL_0_UR_MASK     (0x00000004u)
#define CSL_MSMC_SES_MPAXL_0_UR_SHIFT    (0x00000002u)
#define CSL_MSMC_SES_MPAXL_0_UR_RESETVAL (0x00000001u)

#define CSL_MSMC_SES_MPAXL_0_SX_MASK     (0x00000008u)
#define CSL_MSMC_SES_MPAXL_0_SX_SHIFT    (0x00000003u)
#define CSL_MSMC_SES_MPAXL_0_SX_RESETVAL (0x00000001u)

#define CSL_MSMC_SES_MPAXL_0_SW_MASK     (0x00000010u)
#define CSL_MSMC_SES_MPAXL_0_SW_SHIFT    (0x00000004u)
#define CSL_MSMC_SES_MPAXL_0_SW_RESETVAL (0x00000001u)

#define CSL_MSMC_SES_MPAXL_0_SR_MASK     (0x00000020u)
#define CSL_MSMC_SES_MPAXL_0_SR_SHIFT    (0x00000005u)
#define CSL_MSMC_SES_MPAXL_0_SR_RESETVAL (0x00000001u)



#define CSL_MSMC_SES_MPAXL_0_RADDR_MASK  (0xFFFFFF00u)
#define CSL_MSMC_SES_MPAXL_0_RADDR_SHIFT (0x00000008u)
#define CSL_MSMC_SES_MPAXL_0_RADDR_RESETVAL (0x00800000u)

#define CSL_MSMC_SES_MPAXL_0_RESETVAL    (0x800000BFu)

/* SES_MPAXH_0 */

#define CSL_MSMC_SES_MPAXH_0_SEGSZ_MASK  (0x0000001Fu)
#define CSL_MSMC_SES_MPAXH_0_SEGSZ_SHIFT (0x00000000u)
#define CSL_MSMC_SES_MPAXH_0_SEGSZ_RESETVAL (0x0000001Eu)

#define CSL_MSMC_SES_MPAXH_0_AI_MASK     (0x00000020u)
#define CSL_MSMC_SES_MPAXH_0_AI_SHIFT    (0x00000005u)
#define CSL_MSMC_SES_MPAXH_0_AI_RESETVAL (0x00000000u)

#define CSL_MSMC_SES_MPAXH_0_BE_MASK     (0x00000040u)
#define CSL_MSMC_SES_MPAXH_0_BE_SHIFT    (0x00000006u)
#define CSL_MSMC_SES_MPAXH_0_BE_RESETVAL (0x00000000u)


#define CSL_MSMC_SES_MPAXH_0_BADDR_MASK  (0xFFFFF000u)
#define CSL_MSMC_SES_MPAXH_0_BADDR_SHIFT (0x0000000Cu)
#define CSL_MSMC_SES_MPAXH_0_BADDR_RESETVAL (0x00080000u)


#define CSL_MSMC_SES_MPAXH_0_RESETVAL    (0x8000001Eu)

/* SES_MPAXL_1 */

#define CSL_MSMC_SES_MPAXL_1_UX_MASK     (0x00000001u)
#define CSL_MSMC_SES_MPAXL_1_UX_SHIFT    (0x00000000u)
#define CSL_MSMC_SES_MPAXL_1_UX_RESETVAL (0x00000000u)

#define CSL_MSMC_SES_MPAXL_1_UW_MASK     (0x00000002u)
#define CSL_MSMC_SES_MPAXL_1_UW_SHIFT    (0x00000001u)
#define CSL_MSMC_SES_MPAXL_1_UW_RESETVAL (0x00000000u)

#define CSL_MSMC_SES_MPAXL_1_UR_MASK     (0x00000004u)
#define CSL_MSMC_SES_MPAXL_1_UR_SHIFT    (0x00000002u)
#define CSL_MSMC_SES_MPAXL_1_UR_RESETVAL (0x00000000u)

#define CSL_MSMC_SES_MPAXL_1_SX_MASK     (0x00000008u)
#define CSL_MSMC_SES_MPAXL_1_SX_SHIFT    (0x00000003u)
#define CSL_MSMC_SES_MPAXL_1_SX_RESETVAL (0x00000000u)

#define CSL_MSMC_SES_MPAXL_1_SW_MASK     (0x00000010u)
#define CSL_MSMC_SES_MPAXL_1_SW_SHIFT    (0x00000004u)
#define CSL_MSMC_SES_MPAXL_1_SW_RESETVAL (0x00000000u)

#define CSL_MSMC_SES_MPAXL_1_SR_MASK     (0x00000020u)
#define CSL_MSMC_SES_MPAXL_1_SR_SHIFT    (0x00000005u)
#define CSL_MSMC_SES_MPAXL_1_SR_RESETVAL (0x00000000u)



#define CSL_MSMC_SES_MPAXL_1_RADDR_MASK  (0xFFFFFF00u)
#define CSL_MSMC_SES_MPAXL_1_RADDR_SHIFT (0x00000008u)
#define CSL_MSMC_SES_MPAXL_1_RADDR_RESETVAL (0x00000000u)

#define CSL_MSMC_SES_MPAXL_1_RESETVAL    (0x00000000u)

/* SES_MPAXH_1 */

#define CSL_MSMC_SES_MPAXH_1_SEGSZ_MASK  (0x0000001Fu)
#define CSL_MSMC_SES_MPAXH_1_SEGSZ_SHIFT (0x00000000u)
#define CSL_MSMC_SES_MPAXH_1_SEGSZ_RESETVAL (0x00000000u)

#define CSL_MSMC_SES_MPAXH_1_AI_MASK     (0x00000020u)
#define CSL_MSMC_SES_MPAXH_1_AI_SHIFT    (0x00000005u)
#define CSL_MSMC_SES_MPAXH_1_AI_RESETVAL (0x00000000u)

#define CSL_MSMC_SES_MPAXH_1_BE_MASK     (0x00000040u)
#define CSL_MSMC_SES_MPAXH_1_BE_SHIFT    (0x00000006u)
#define CSL_MSMC_SES_MPAXH_1_BE_RESETVAL (0x00000000u)


#define CSL_MSMC_SES_MPAXH_1_BADDR_MASK  (0xFFFFF000u)
#define CSL_MSMC_SES_MPAXH_1_BADDR_SHIFT (0x0000000Cu)
#define CSL_MSMC_SES_MPAXH_1_BADDR_RESETVAL (0x00000000u)


#define CSL_MSMC_SES_MPAXH_1_RESETVAL    (0x00000000u)

/* SES_MPAXL_2 */

#define CSL_MSMC_SES_MPAXL_2_UX_MASK     (0x00000001u)
#define CSL_MSMC_SES_MPAXL_2_UX_SHIFT    (0x00000000u)
#define CSL_MSMC_SES_MPAXL_2_UX_RESETVAL (0x00000000u)

#define CSL_MSMC_SES_MPAXL_2_UW_MASK     (0x00000002u)
#define CSL_MSMC_SES_MPAXL_2_UW_SHIFT    (0x00000001u)
#define CSL_MSMC_SES_MPAXL_2_UW_RESETVAL (0x00000000u)

#define CSL_MSMC_SES_MPAXL_2_UR_MASK     (0x00000004u)
#define CSL_MSMC_SES_MPAXL_2_UR_SHIFT    (0x00000002u)
#define CSL_MSMC_SES_MPAXL_2_UR_RESETVAL (0x00000000u)

#define CSL_MSMC_SES_MPAXL_2_SX_MASK     (0x00000008u)
#define CSL_MSMC_SES_MPAXL_2_SX_SHIFT    (0x00000003u)
#define CSL_MSMC_SES_MPAXL_2_SX_RESETVAL (0x00000000u)

#define CSL_MSMC_SES_MPAXL_2_SW_MASK     (0x00000010u)
#define CSL_MSMC_SES_MPAXL_2_SW_SHIFT    (0x00000004u)
#define CSL_MSMC_SES_MPAXL_2_SW_RESETVAL (0x00000000u)

#define CSL_MSMC_SES_MPAXL_2_SR_MASK     (0x00000020u)
#define CSL_MSMC_SES_MPAXL_2_SR_SHIFT    (0x00000005u)
#define CSL_MSMC_SES_MPAXL_2_SR_RESETVAL (0x00000000u)



#define CSL_MSMC_SES_MPAXL_2_RADDR_MASK  (0xFFFFFF00u)
#define CSL_MSMC_SES_MPAXL_2_RADDR_SHIFT (0x00000008u)
#define CSL_MSMC_SES_MPAXL_2_RADDR_RESETVAL (0x00000000u)

#define CSL_MSMC_SES_MPAXL_2_RESETVAL    (0x00000000u)

/* SES_MPAXH_2 */

#define CSL_MSMC_SES_MPAXH_2_SEGSZ_MASK  (0x0000001Fu)
#define CSL_MSMC_SES_MPAXH_2_SEGSZ_SHIFT (0x00000000u)
#define CSL_MSMC_SES_MPAXH_2_SEGSZ_RESETVAL (0x00000000u)

#define CSL_MSMC_SES_MPAXH_2_AI_MASK     (0x00000020u)
#define CSL_MSMC_SES_MPAXH_2_AI_SHIFT    (0x00000005u)
#define CSL_MSMC_SES_MPAXH_2_AI_RESETVAL (0x00000000u)

#define CSL_MSMC_SES_MPAXH_2_BE_MASK     (0x00000040u)
#define CSL_MSMC_SES_MPAXH_2_BE_SHIFT    (0x00000006u)
#define CSL_MSMC_SES_MPAXH_2_BE_RESETVAL (0x00000000u)


#define CSL_MSMC_SES_MPAXH_2_BADDR_MASK  (0xFFFFF000u)
#define CSL_MSMC_SES_MPAXH_2_BADDR_SHIFT (0x0000000Cu)
#define CSL_MSMC_SES_MPAXH_2_BADDR_RESETVAL (0x00000000u)


#define CSL_MSMC_SES_MPAXH_2_RESETVAL    (0x00000000u)

/* SES_MPAXL_3 */

#define CSL_MSMC_SES_MPAXL_3_UX_MASK     (0x00000001u)
#define CSL_MSMC_SES_MPAXL_3_UX_SHIFT    (0x00000000u)
#define CSL_MSMC_SES_MPAXL_3_UX_RESETVAL (0x00000000u)

#define CSL_MSMC_SES_MPAXL_3_UW_MASK     (0x00000002u)
#define CSL_MSMC_SES_MPAXL_3_UW_SHIFT    (0x00000001u)
#define CSL_MSMC_SES_MPAXL_3_UW_RESETVAL (0x00000000u)

#define CSL_MSMC_SES_MPAXL_3_UR_MASK     (0x00000004u)
#define CSL_MSMC_SES_MPAXL_3_UR_SHIFT    (0x00000002u)
#define CSL_MSMC_SES_MPAXL_3_UR_RESETVAL (0x00000000u)

#define CSL_MSMC_SES_MPAXL_3_SX_MASK     (0x00000008u)
#define CSL_MSMC_SES_MPAXL_3_SX_SHIFT    (0x00000003u)
#define CSL_MSMC_SES_MPAXL_3_SX_RESETVAL (0x00000000u)

#define CSL_MSMC_SES_MPAXL_3_SW_MASK     (0x00000010u)
#define CSL_MSMC_SES_MPAXL_3_SW_SHIFT    (0x00000004u)
#define CSL_MSMC_SES_MPAXL_3_SW_RESETVAL (0x00000000u)

#define CSL_MSMC_SES_MPAXL_3_SR_MASK     (0x00000020u)
#define CSL_MSMC_SES_MPAXL_3_SR_SHIFT    (0x00000005u)
#define CSL_MSMC_SES_MPAXL_3_SR_RESETVAL (0x00000000u)



#define CSL_MSMC_SES_MPAXL_3_RADDR_MASK  (0xFFFFFF00u)
#define CSL_MSMC_SES_MPAXL_3_RADDR_SHIFT (0x00000008u)
#define CSL_MSMC_SES_MPAXL_3_RADDR_RESETVAL (0x00000000u)

#define CSL_MSMC_SES_MPAXL_3_RESETVAL    (0x00000000u)

/* SES_MPAXH_3 */

#define CSL_MSMC_SES_MPAXH_3_SEGSZ_MASK  (0x0000001Fu)
#define CSL_MSMC_SES_MPAXH_3_SEGSZ_SHIFT (0x00000000u)
#define CSL_MSMC_SES_MPAXH_3_SEGSZ_RESETVAL (0x00000000u)

#define CSL_MSMC_SES_MPAXH_3_AI_MASK     (0x00000020u)
#define CSL_MSMC_SES_MPAXH_3_AI_SHIFT    (0x00000005u)
#define CSL_MSMC_SES_MPAXH_3_AI_RESETVAL (0x00000000u)

#define CSL_MSMC_SES_MPAXH_3_BE_MASK     (0x00000040u)
#define CSL_MSMC_SES_MPAXH_3_BE_SHIFT    (0x00000006u)
#define CSL_MSMC_SES_MPAXH_3_BE_RESETVAL (0x00000000u)


#define CSL_MSMC_SES_MPAXH_3_BADDR_MASK  (0xFFFFF000u)
#define CSL_MSMC_SES_MPAXH_3_BADDR_SHIFT (0x0000000Cu)
#define CSL_MSMC_SES_MPAXH_3_BADDR_RESETVAL (0x00000000u)


#define CSL_MSMC_SES_MPAXH_3_RESETVAL    (0x00000000u)

/* SES_MPAXL_4 */

#define CSL_MSMC_SES_MPAXL_4_UX_MASK     (0x00000001u)
#define CSL_MSMC_SES_MPAXL_4_UX_SHIFT    (0x00000000u)
#define CSL_MSMC_SES_MPAXL_4_UX_RESETVAL (0x00000000u)

#define CSL_MSMC_SES_MPAXL_4_UW_MASK     (0x00000002u)
#define CSL_MSMC_SES_MPAXL_4_UW_SHIFT    (0x00000001u)
#define CSL_MSMC_SES_MPAXL_4_UW_RESETVAL (0x00000000u)

#define CSL_MSMC_SES_MPAXL_4_UR_MASK     (0x00000004u)
#define CSL_MSMC_SES_MPAXL_4_UR_SHIFT    (0x00000002u)
#define CSL_MSMC_SES_MPAXL_4_UR_RESETVAL (0x00000000u)

#define CSL_MSMC_SES_MPAXL_4_SX_MASK     (0x00000008u)
#define CSL_MSMC_SES_MPAXL_4_SX_SHIFT    (0x00000003u)
#define CSL_MSMC_SES_MPAXL_4_SX_RESETVAL (0x00000000u)

#define CSL_MSMC_SES_MPAXL_4_SW_MASK     (0x00000010u)
#define CSL_MSMC_SES_MPAXL_4_SW_SHIFT    (0x00000004u)
#define CSL_MSMC_SES_MPAXL_4_SW_RESETVAL (0x00000000u)

#define CSL_MSMC_SES_MPAXL_4_SR_MASK     (0x00000020u)
#define CSL_MSMC_SES_MPAXL_4_SR_SHIFT    (0x00000005u)
#define CSL_MSMC_SES_MPAXL_4_SR_RESETVAL (0x00000000u)



#define CSL_MSMC_SES_MPAXL_4_RADDR_MASK  (0xFFFFFF00u)
#define CSL_MSMC_SES_MPAXL_4_RADDR_SHIFT (0x00000008u)
#define CSL_MSMC_SES_MPAXL_4_RADDR_RESETVAL (0x00000000u)

#define CSL_MSMC_SES_MPAXL_4_RESETVAL    (0x00000000u)

/* SES_MPAXH_4 */

#define CSL_MSMC_SES_MPAXH_4_SEGSZ_MASK  (0x0000001Fu)
#define CSL_MSMC_SES_MPAXH_4_SEGSZ_SHIFT (0x00000000u)
#define CSL_MSMC_SES_MPAXH_4_SEGSZ_RESETVAL (0x00000000u)

#define CSL_MSMC_SES_MPAXH_4_AI_MASK     (0x00000020u)
#define CSL_MSMC_SES_MPAXH_4_AI_SHIFT    (0x00000005u)
#define CSL_MSMC_SES_MPAXH_4_AI_RESETVAL (0x00000000u)

#define CSL_MSMC_SES_MPAXH_4_BE_MASK     (0x00000040u)
#define CSL_MSMC_SES_MPAXH_4_BE_SHIFT    (0x00000006u)
#define CSL_MSMC_SES_MPAXH_4_BE_RESETVAL (0x00000000u)


#define CSL_MSMC_SES_MPAXH_4_BADDR_MASK  (0xFFFFF000u)
#define CSL_MSMC_SES_MPAXH_4_BADDR_SHIFT (0x0000000Cu)
#define CSL_MSMC_SES_MPAXH_4_BADDR_RESETVAL (0x00000000u)


#define CSL_MSMC_SES_MPAXH_4_RESETVAL    (0x00000000u)

/* SES_MPAXL_5 */

#define CSL_MSMC_SES_MPAXL_5_UX_MASK     (0x00000001u)
#define CSL_MSMC_SES_MPAXL_5_UX_SHIFT    (0x00000000u)
#define CSL_MSMC_SES_MPAXL_5_UX_RESETVAL (0x00000000u)

#define CSL_MSMC_SES_MPAXL_5_UW_MASK     (0x00000002u)
#define CSL_MSMC_SES_MPAXL_5_UW_SHIFT    (0x00000001u)
#define CSL_MSMC_SES_MPAXL_5_UW_RESETVAL (0x00000000u)

#define CSL_MSMC_SES_MPAXL_5_UR_MASK     (0x00000004u)
#define CSL_MSMC_SES_MPAXL_5_UR_SHIFT    (0x00000002u)
#define CSL_MSMC_SES_MPAXL_5_UR_RESETVAL (0x00000000u)

#define CSL_MSMC_SES_MPAXL_5_SX_MASK     (0x00000008u)
#define CSL_MSMC_SES_MPAXL_5_SX_SHIFT    (0x00000003u)
#define CSL_MSMC_SES_MPAXL_5_SX_RESETVAL (0x00000000u)

#define CSL_MSMC_SES_MPAXL_5_SW_MASK     (0x00000010u)
#define CSL_MSMC_SES_MPAXL_5_SW_SHIFT    (0x00000004u)
#define CSL_MSMC_SES_MPAXL_5_SW_RESETVAL (0x00000000u)

#define CSL_MSMC_SES_MPAXL_5_SR_MASK     (0x00000020u)
#define CSL_MSMC_SES_MPAXL_5_SR_SHIFT    (0x00000005u)
#define CSL_MSMC_SES_MPAXL_5_SR_RESETVAL (0x00000000u)



#define CSL_MSMC_SES_MPAXL_5_RADDR_MASK  (0xFFFFFF00u)
#define CSL_MSMC_SES_MPAXL_5_RADDR_SHIFT (0x00000008u)
#define CSL_MSMC_SES_MPAXL_5_RADDR_RESETVAL (0x00000000u)

#define CSL_MSMC_SES_MPAXL_5_RESETVAL    (0x00000000u)

/* SES_MPAXH_5 */

#define CSL_MSMC_SES_MPAXH_5_SEGSZ_MASK  (0x0000001Fu)
#define CSL_MSMC_SES_MPAXH_5_SEGSZ_SHIFT (0x00000000u)
#define CSL_MSMC_SES_MPAXH_5_SEGSZ_RESETVAL (0x00000000u)

#define CSL_MSMC_SES_MPAXH_5_AI_MASK     (0x00000020u)
#define CSL_MSMC_SES_MPAXH_5_AI_SHIFT    (0x00000005u)
#define CSL_MSMC_SES_MPAXH_5_AI_RESETVAL (0x00000000u)

#define CSL_MSMC_SES_MPAXH_5_BE_MASK     (0x00000040u)
#define CSL_MSMC_SES_MPAXH_5_BE_SHIFT    (0x00000006u)
#define CSL_MSMC_SES_MPAXH_5_BE_RESETVAL (0x00000000u)


#define CSL_MSMC_SES_MPAXH_5_BADDR_MASK  (0xFFFFF000u)
#define CSL_MSMC_SES_MPAXH_5_BADDR_SHIFT (0x0000000Cu)
#define CSL_MSMC_SES_MPAXH_5_BADDR_RESETVAL (0x00000000u)


#define CSL_MSMC_SES_MPAXH_5_RESETVAL    (0x00000000u)

/* SES_MPAXL_6 */

#define CSL_MSMC_SES_MPAXL_6_UX_MASK     (0x00000001u)
#define CSL_MSMC_SES_MPAXL_6_UX_SHIFT    (0x00000000u)
#define CSL_MSMC_SES_MPAXL_6_UX_RESETVAL (0x00000000u)

#define CSL_MSMC_SES_MPAXL_6_UW_MASK     (0x00000002u)
#define CSL_MSMC_SES_MPAXL_6_UW_SHIFT    (0x00000001u)
#define CSL_MSMC_SES_MPAXL_6_UW_RESETVAL (0x00000000u)

#define CSL_MSMC_SES_MPAXL_6_UR_MASK     (0x00000004u)
#define CSL_MSMC_SES_MPAXL_6_UR_SHIFT    (0x00000002u)
#define CSL_MSMC_SES_MPAXL_6_UR_RESETVAL (0x00000000u)

#define CSL_MSMC_SES_MPAXL_6_SX_MASK     (0x00000008u)
#define CSL_MSMC_SES_MPAXL_6_SX_SHIFT    (0x00000003u)
#define CSL_MSMC_SES_MPAXL_6_SX_RESETVAL (0x00000000u)

#define CSL_MSMC_SES_MPAXL_6_SW_MASK     (0x00000010u)
#define CSL_MSMC_SES_MPAXL_6_SW_SHIFT    (0x00000004u)
#define CSL_MSMC_SES_MPAXL_6_SW_RESETVAL (0x00000000u)

#define CSL_MSMC_SES_MPAXL_6_SR_MASK     (0x00000020u)
#define CSL_MSMC_SES_MPAXL_6_SR_SHIFT    (0x00000005u)
#define CSL_MSMC_SES_MPAXL_6_SR_RESETVAL (0x00000000u)



#define CSL_MSMC_SES_MPAXL_6_RADDR_MASK  (0xFFFFFF00u)
#define CSL_MSMC_SES_MPAXL_6_RADDR_SHIFT (0x00000008u)
#define CSL_MSMC_SES_MPAXL_6_RADDR_RESETVAL (0x00000000u)

#define CSL_MSMC_SES_MPAXL_6_RESETVAL    (0x00000000u)

/* SES_MPAXH_6 */

#define CSL_MSMC_SES_MPAXH_6_SEGSZ_MASK  (0x0000001Fu)
#define CSL_MSMC_SES_MPAXH_6_SEGSZ_SHIFT (0x00000000u)
#define CSL_MSMC_SES_MPAXH_6_SEGSZ_RESETVAL (0x00000000u)

#define CSL_MSMC_SES_MPAXH_6_AI_MASK     (0x00000020u)
#define CSL_MSMC_SES_MPAXH_6_AI_SHIFT    (0x00000005u)
#define CSL_MSMC_SES_MPAXH_6_AI_RESETVAL (0x00000000u)

#define CSL_MSMC_SES_MPAXH_6_BE_MASK     (0x00000040u)
#define CSL_MSMC_SES_MPAXH_6_BE_SHIFT    (0x00000006u)
#define CSL_MSMC_SES_MPAXH_6_BE_RESETVAL (0x00000000u)


#define CSL_MSMC_SES_MPAXH_6_BADDR_MASK  (0xFFFFF000u)
#define CSL_MSMC_SES_MPAXH_6_BADDR_SHIFT (0x0000000Cu)
#define CSL_MSMC_SES_MPAXH_6_BADDR_RESETVAL (0x00000000u)


#define CSL_MSMC_SES_MPAXH_6_RESETVAL    (0x00000000u)

/* SES_MPAXL_7 */

#define CSL_MSMC_SES_MPAXL_7_UX_MASK     (0x00000001u)
#define CSL_MSMC_SES_MPAXL_7_UX_SHIFT    (0x00000000u)
#define CSL_MSMC_SES_MPAXL_7_UX_RESETVAL (0x00000000u)

#define CSL_MSMC_SES_MPAXL_7_UW_MASK     (0x00000002u)
#define CSL_MSMC_SES_MPAXL_7_UW_SHIFT    (0x00000001u)
#define CSL_MSMC_SES_MPAXL_7_UW_RESETVAL (0x00000000u)

#define CSL_MSMC_SES_MPAXL_7_UR_MASK     (0x00000004u)
#define CSL_MSMC_SES_MPAXL_7_UR_SHIFT    (0x00000002u)
#define CSL_MSMC_SES_MPAXL_7_UR_RESETVAL (0x00000000u)

#define CSL_MSMC_SES_MPAXL_7_SX_MASK     (0x00000008u)
#define CSL_MSMC_SES_MPAXL_7_SX_SHIFT    (0x00000003u)
#define CSL_MSMC_SES_MPAXL_7_SX_RESETVAL (0x00000000u)

#define CSL_MSMC_SES_MPAXL_7_SW_MASK     (0x00000010u)
#define CSL_MSMC_SES_MPAXL_7_SW_SHIFT    (0x00000004u)
#define CSL_MSMC_SES_MPAXL_7_SW_RESETVAL (0x00000000u)

#define CSL_MSMC_SES_MPAXL_7_SR_MASK     (0x00000020u)
#define CSL_MSMC_SES_MPAXL_7_SR_SHIFT    (0x00000005u)
#define CSL_MSMC_SES_MPAXL_7_SR_RESETVAL (0x00000000u)



#define CSL_MSMC_SES_MPAXL_7_RADDR_MASK  (0xFFFFFF00u)
#define CSL_MSMC_SES_MPAXL_7_RADDR_SHIFT (0x00000008u)
#define CSL_MSMC_SES_MPAXL_7_RADDR_RESETVAL (0x00000000u)

#define CSL_MSMC_SES_MPAXL_7_RESETVAL    (0x00000000u)

/* SES_MPAXH_7 */

#define CSL_MSMC_SES_MPAXH_7_SEGSZ_MASK  (0x0000001Fu)
#define CSL_MSMC_SES_MPAXH_7_SEGSZ_SHIFT (0x00000000u)
#define CSL_MSMC_SES_MPAXH_7_SEGSZ_RESETVAL (0x00000000u)

#define CSL_MSMC_SES_MPAXH_7_AI_MASK     (0x00000020u)
#define CSL_MSMC_SES_MPAXH_7_AI_SHIFT    (0x00000005u)
#define CSL_MSMC_SES_MPAXH_7_AI_RESETVAL (0x00000000u)

#define CSL_MSMC_SES_MPAXH_7_BE_MASK     (0x00000040u)
#define CSL_MSMC_SES_MPAXH_7_BE_SHIFT    (0x00000006u)
#define CSL_MSMC_SES_MPAXH_7_BE_RESETVAL (0x00000000u)


#define CSL_MSMC_SES_MPAXH_7_BADDR_MASK  (0xFFFFF000u)
#define CSL_MSMC_SES_MPAXH_7_BADDR_SHIFT (0x0000000Cu)
#define CSL_MSMC_SES_MPAXH_7_BADDR_RESETVAL (0x00000000u)


#define CSL_MSMC_SES_MPAXH_7_RESETVAL    (0x00000000u)

/* PID */

#define CSL_MSMC_PID_Y_MASK              (0x0000003Fu)
#define CSL_MSMC_PID_Y_SHIFT             (0x00000000u)
#define CSL_MSMC_PID_Y_RESETVAL          (0x00000000u)

#define CSL_MSMC_PID_CUSTOM_MASK         (0x000000C0u)
#define CSL_MSMC_PID_CUSTOM_SHIFT        (0x00000006u)
#define CSL_MSMC_PID_CUSTOM_RESETVAL     (0x00000000u)

#define CSL_MSMC_PID_X_MASK              (0x00000700u)
#define CSL_MSMC_PID_X_SHIFT             (0x00000008u)
#define CSL_MSMC_PID_X_RESETVAL          (0x00000000u)

#define CSL_MSMC_PID_R_MASK              (0x0000F800u)
#define CSL_MSMC_PID_R_SHIFT             (0x0000000Bu)
#define CSL_MSMC_PID_R_RESETVAL          (0x00000000u)

#define CSL_MSMC_PID_FUNC_MASK           (0x0FFF0000u)
#define CSL_MSMC_PID_FUNC_SHIFT          (0x00000010u)
#define CSL_MSMC_PID_FUNC_RESETVAL       (0x00000500u)

#define CSL_MSMC_PID_BU_MASK             (0x30000000u)
#define CSL_MSMC_PID_BU_SHIFT            (0x0000001Cu)
#define CSL_MSMC_PID_BU_RESETVAL         (0x00000000u)

#define CSL_MSMC_PID_SCHEME_MASK         (0xC0000000u)
#define CSL_MSMC_PID_SCHEME_SHIFT        (0x0000001Eu)
#define CSL_MSMC_PID_SCHEME_RESETVAL     (0x00000001u)

#define CSL_MSMC_PID_RESETVAL            (0x45000000u)

/* SMCC */

#define CSL_MSMC_SMCC_MCP_MASK           (0x00000001u)
#define CSL_MSMC_SMCC_MCP_SHIFT          (0x00000000u)
#define CSL_MSMC_SMCC_MCP_RESETVAL       (0x00000000u)

#define CSL_MSMC_SMCC__RESV1_MASK        (0xFFFFFFFEu)
#define CSL_MSMC_SMCC__RESV1_SHIFT       (0x00000001u)
#define CSL_MSMC_SMCC__RESV1_RESETVAL    (0x00000000u)

#define CSL_MSMC_SMCC_RESETVAL           (0x00000000u)

/* SMCERRAR */

#define CSL_MSMC_SMCERRAR_SEADDR_MASK    (0xFFFFFFFFu)
#define CSL_MSMC_SMCERRAR_SEADDR_SHIFT   (0x00000000u)
#define CSL_MSMC_SMCERRAR_SEADDR_RESETVAL (0x00000000u)

#define CSL_MSMC_SMCERRAR_RESETVAL       (0x00000000u)

/* SMCERRXR */

#define CSL_MSMC_SMCERRXR_SEEADDR_MASK   (0x0000000Fu)
#define CSL_MSMC_SMCERRXR_SEEADDR_SHIFT  (0x00000000u)
#define CSL_MSMC_SMCERRXR_SEEADDR_RESETVAL (0x00000000u)

#define CSL_MSMC_SMCERRXR_SEPID_MASK     (0x000000F0u)
#define CSL_MSMC_SMCERRXR_SEPID_SHIFT    (0x00000004u)
#define CSL_MSMC_SMCERRXR_SEPID_RESETVAL (0x00000000u)

#define CSL_MSMC_SMCERRXR_SER_MASK       (0x00000100u)
#define CSL_MSMC_SMCERRXR_SER_SHIFT      (0x00000008u)
#define CSL_MSMC_SMCERRXR_SER_RESETVAL   (0x00000000u)

#define CSL_MSMC_SMCERRXR__RESV1_MASK    (0x0000FE00u)
#define CSL_MSMC_SMCERRXR__RESV1_SHIFT   (0x00000009u)
#define CSL_MSMC_SMCERRXR__RESV1_RESETVAL (0x00000000u)

#define CSL_MSMC_SMCERRXR_ESYN_MASK      (0x00FF0000u)
#define CSL_MSMC_SMCERRXR_ESYN_SHIFT     (0x00000010u)
#define CSL_MSMC_SMCERRXR_ESYN_RESETVAL  (0x00000000u)

#define CSL_MSMC_SMCERRXR__RESV2_MASK    (0xFF000000u)
#define CSL_MSMC_SMCERRXR__RESV2_SHIFT   (0x00000018u)
#define CSL_MSMC_SMCERRXR__RESV2_RESETVAL (0x00000000u)

#define CSL_MSMC_SMCERRXR_RESETVAL       (0x00000000u)

/* SMEDCC */

#define CSL_MSMC_SMEDCC_REFDEL_MASK      (0x000000FFu)
#define CSL_MSMC_SMEDCC_REFDEL_SHIFT     (0x00000000u)
#define CSL_MSMC_SMEDCC_REFDEL_RESETVAL  (0x00000001u)

#define CSL_MSMC_SMEDCC__RESV1_MASK      (0x03FFFF00u)
#define CSL_MSMC_SMEDCC__RESV1_SHIFT     (0x00000008u)
#define CSL_MSMC_SMEDCC__RESV1_RESETVAL  (0x00000000u)

#define CSL_MSMC_SMEDCC_PRR_MASK         (0x04000000u)
#define CSL_MSMC_SMEDCC_PRR_SHIFT        (0x0000001Au)
#define CSL_MSMC_SMEDCC_PRR_RESETVAL     (0x00000000u)

#define CSL_MSMC_SMEDCC_CSE_MASK         (0x08000000u)
#define CSL_MSMC_SMEDCC_CSE_SHIFT        (0x0000001Bu)
#define CSL_MSMC_SMEDCC_CSE_RESETVAL     (0x00000000u)

#define CSL_MSMC_SMEDCC__RESV2_MASK      (0x30000000u)
#define CSL_MSMC_SMEDCC__RESV2_SHIFT     (0x0000001Cu)
#define CSL_MSMC_SMEDCC__RESV2_RESETVAL  (0x00000000u)

#define CSL_MSMC_SMEDCC_ECM_MASK         (0x40000000u)
#define CSL_MSMC_SMEDCC_ECM_SHIFT        (0x0000001Eu)
#define CSL_MSMC_SMEDCC_ECM_RESETVAL     (0x00000000u)

#define CSL_MSMC_SMEDCC_SEN_MASK         (0x80000000u)
#define CSL_MSMC_SMEDCC_SEN_SHIFT        (0x0000001Fu)
#define CSL_MSMC_SMEDCC_SEN_RESETVAL     (0x00000000u)

#define CSL_MSMC_SMEDCC_RESETVAL         (0x00000001u)

/* SMCEA */

#define CSL_MSMC_SMCEA_SECA_MASK         (0x00FFFFFFu)
#define CSL_MSMC_SMCEA_SECA_SHIFT        (0x00000000u)
#define CSL_MSMC_SMCEA_SECA_RESETVAL     (0x00000000u)

#define CSL_MSMC_SMCEA_ESYN_MASK         (0xFF000000u)
#define CSL_MSMC_SMCEA_ESYN_SHIFT        (0x00000018u)
#define CSL_MSMC_SMCEA_ESYN_RESETVAL     (0x00000000u)

#define CSL_MSMC_SMCEA_RESETVAL          (0x00000000u)

/* SMSECC */

#define CSL_MSMC_SMSECC_SCEC_MASK        (0x0000FFFFu)
#define CSL_MSMC_SMSECC_SCEC_SHIFT       (0x00000000u)
#define CSL_MSMC_SMSECC_SCEC_RESETVAL    (0x00000000u)

#define CSL_MSMC_SMSECC_SNCEC_MASK       (0xFFFF0000u)
#define CSL_MSMC_SMSECC_SNCEC_SHIFT      (0x00000010u)
#define CSL_MSMC_SMSECC_SNCEC_RESETVAL   (0x00000000u)

#define CSL_MSMC_SMSECC_RESETVAL         (0x00000000u)

/* SMPFAR */

#define CSL_MSMC_SMPFAR_FAULT_ADDRESS_MASK (0xFFFFFFFFu)
#define CSL_MSMC_SMPFAR_FAULT_ADDRESS_SHIFT (0x00000000u)
#define CSL_MSMC_SMPFAR_FAULT_ADDRESS_RESETVAL (0x00000000u)

#define CSL_MSMC_SMPFAR_RESETVAL         (0x00000000u)

/* SMPFXR */

#define CSL_MSMC_SMPFXR_NM_MASK          (0x00000001u)
#define CSL_MSMC_SMPFXR_NM_SHIFT         (0x00000000u)
#define CSL_MSMC_SMPFXR_NM_RESETVAL      (0x00000000u)

#define CSL_MSMC_SMPFXR__RESV1_MASK      (0xFFFFFFFEu)
#define CSL_MSMC_SMPFXR__RESV1_SHIFT     (0x00000001u)
#define CSL_MSMC_SMPFXR__RESV1_RESETVAL  (0x00000000u)

#define CSL_MSMC_SMPFXR_RESETVAL         (0x00000000u)

/* SMPFR */

#define CSL_MSMC_SMPFR_FMSTID_MASK       (0x000000FFu)
#define CSL_MSMC_SMPFR_FMSTID_SHIFT      (0x00000000u)
#define CSL_MSMC_SMPFR_FMSTID_RESETVAL   (0x00000000u)

#define CSL_MSMC_SMPFR_FPID_MASK         (0x00000F00u)
#define CSL_MSMC_SMPFR_FPID_SHIFT        (0x00000008u)
#define CSL_MSMC_SMPFR_FPID_RESETVAL     (0x00000000u)

#define CSL_MSMC_SMPFR__RESV1_MASK       (0xFFFFF000u)
#define CSL_MSMC_SMPFR__RESV1_SHIFT      (0x0000000Cu)
#define CSL_MSMC_SMPFR__RESV1_RESETVAL   (0x00000000u)

#define CSL_MSMC_SMPFR_RESETVAL          (0x00000000u)

/* SMPFCR */

#define CSL_MSMC_SMPFCR_CLR_MASK         (0x00000001u)
#define CSL_MSMC_SMPFCR_CLR_SHIFT        (0x00000000u)
#define CSL_MSMC_SMPFCR_CLR_RESETVAL     (0x00000000u)

#define CSL_MSMC_SMPFCR__RESV1_MASK      (0xFFFFFFFEu)
#define CSL_MSMC_SMPFCR__RESV1_SHIFT     (0x00000001u)
#define CSL_MSMC_SMPFCR__RESV1_RESETVAL  (0x00000000u)

#define CSL_MSMC_SMPFCR_RESETVAL         (0x00000000u)

/* SMSTA */

#define CSL_MSMC_SMSTA_CONSTANT_MASK     (0x00000FFFu)
#define CSL_MSMC_SMSTA_CONSTANT_SHIFT    (0x00000000u)
#define CSL_MSMC_SMSTA_CONSTANT_RESETVAL (0x00000000u)

#define CSL_MSMC_SMSTA_SECURITY_THRESHOLD_SEGMENT_ADDRESS_MASK (0x00FFF000u)
#define CSL_MSMC_SMSTA_SECURITY_THRESHOLD_SEGMENT_ADDRESS_SHIFT (0x0000000Cu)
#define CSL_MSMC_SMSTA_SECURITY_THRESHOLD_SEGMENT_ADDRESS_RESETVAL (0x00000000u)

#define CSL_MSMC_SMSTA__RESV1_MASK       (0x7F000000u)
#define CSL_MSMC_SMSTA__RESV1_SHIFT      (0x00000018u)
#define CSL_MSMC_SMSTA__RESV1_RESETVAL   (0x00000000u)

#define CSL_MSMC_SMSTA_NS_MASK           (0x80000000u)
#define CSL_MSMC_SMSTA_NS_SHIFT          (0x0000001Fu)
#define CSL_MSMC_SMSTA_NS_RESETVAL       (0x00000000u)

#define CSL_MSMC_SMSTA_RESETVAL          (0x00000000u)

/* SBNDC0 */

#define CSL_MSMC_SBNDC0_SCNTCM_MASK      (0x000000FFu)
#define CSL_MSMC_SBNDC0_SCNTCM_SHIFT     (0x00000000u)
#define CSL_MSMC_SBNDC0_SCNTCM_RESETVAL  (0x0000001Fu)

#define CSL_MSMC_SBNDC0__RESV1_MASK      (0x0000FF00u)
#define CSL_MSMC_SBNDC0__RESV1_SHIFT     (0x00000008u)
#define CSL_MSMC_SBNDC0__RESV1_RESETVAL  (0x00000000u)

#define CSL_MSMC_SBNDC0_SCNTCE_MASK      (0x00FF0000u)
#define CSL_MSMC_SBNDC0_SCNTCE_SHIFT     (0x00000010u)
#define CSL_MSMC_SBNDC0_SCNTCE_RESETVAL  (0x0000001Fu)

#define CSL_MSMC_SBNDC0__RESV2_MASK      (0xFF000000u)
#define CSL_MSMC_SBNDC0__RESV2_SHIFT     (0x00000018u)
#define CSL_MSMC_SBNDC0__RESV2_RESETVAL  (0x00000000u)

#define CSL_MSMC_SBNDC0_RESETVAL         (0x001F001Fu)

/* SBNDC1 */

#define CSL_MSMC_SBNDC1_SCNTCM_MASK      (0x000000FFu)
#define CSL_MSMC_SBNDC1_SCNTCM_SHIFT     (0x00000000u)
#define CSL_MSMC_SBNDC1_SCNTCM_RESETVAL  (0x0000001Fu)

#define CSL_MSMC_SBNDC1__RESV1_MASK      (0x0000FF00u)
#define CSL_MSMC_SBNDC1__RESV1_SHIFT     (0x00000008u)
#define CSL_MSMC_SBNDC1__RESV1_RESETVAL  (0x00000000u)

#define CSL_MSMC_SBNDC1_SCNTCE_MASK      (0x00FF0000u)
#define CSL_MSMC_SBNDC1_SCNTCE_SHIFT     (0x00000010u)
#define CSL_MSMC_SBNDC1_SCNTCE_RESETVAL  (0x0000001Fu)

#define CSL_MSMC_SBNDC1__RESV2_MASK      (0xFF000000u)
#define CSL_MSMC_SBNDC1__RESV2_SHIFT     (0x00000018u)
#define CSL_MSMC_SBNDC1__RESV2_RESETVAL  (0x00000000u)

#define CSL_MSMC_SBNDC1_RESETVAL         (0x001F001Fu)

/* SBNDC2 */

#define CSL_MSMC_SBNDC2_SCNTCM_MASK      (0x000000FFu)
#define CSL_MSMC_SBNDC2_SCNTCM_SHIFT     (0x00000000u)
#define CSL_MSMC_SBNDC2_SCNTCM_RESETVAL  (0x0000001Fu)

#define CSL_MSMC_SBNDC2__RESV1_MASK      (0x0000FF00u)
#define CSL_MSMC_SBNDC2__RESV1_SHIFT     (0x00000008u)
#define CSL_MSMC_SBNDC2__RESV1_RESETVAL  (0x00000000u)

#define CSL_MSMC_SBNDC2_SCNTCE_MASK      (0x00FF0000u)
#define CSL_MSMC_SBNDC2_SCNTCE_SHIFT     (0x00000010u)
#define CSL_MSMC_SBNDC2_SCNTCE_RESETVAL  (0x0000001Fu)

#define CSL_MSMC_SBNDC2__RESV2_MASK      (0xFF000000u)
#define CSL_MSMC_SBNDC2__RESV2_SHIFT     (0x00000018u)
#define CSL_MSMC_SBNDC2__RESV2_RESETVAL  (0x00000000u)

#define CSL_MSMC_SBNDC2_RESETVAL         (0x001F001Fu)

/* SBNDC3 */

#define CSL_MSMC_SBNDC3_SCNTCM_MASK      (0x000000FFu)
#define CSL_MSMC_SBNDC3_SCNTCM_SHIFT     (0x00000000u)
#define CSL_MSMC_SBNDC3_SCNTCM_RESETVAL  (0x0000001Fu)

#define CSL_MSMC_SBNDC3__RESV1_MASK      (0x0000FF00u)
#define CSL_MSMC_SBNDC3__RESV1_SHIFT     (0x00000008u)
#define CSL_MSMC_SBNDC3__RESV1_RESETVAL  (0x00000000u)

#define CSL_MSMC_SBNDC3_SCNTCE_MASK      (0x00FF0000u)
#define CSL_MSMC_SBNDC3_SCNTCE_SHIFT     (0x00000010u)
#define CSL_MSMC_SBNDC3_SCNTCE_RESETVAL  (0x0000001Fu)

#define CSL_MSMC_SBNDC3__RESV2_MASK      (0xFF000000u)
#define CSL_MSMC_SBNDC3__RESV2_SHIFT     (0x00000018u)
#define CSL_MSMC_SBNDC3__RESV2_RESETVAL  (0x00000000u)

#define CSL_MSMC_SBNDC3_RESETVAL         (0x001F001Fu)

/* SBNDC4 */

#define CSL_MSMC_SBNDC4_SCNTCM_MASK      (0x000000FFu)
#define CSL_MSMC_SBNDC4_SCNTCM_SHIFT     (0x00000000u)
#define CSL_MSMC_SBNDC4_SCNTCM_RESETVAL  (0x0000001Fu)

#define CSL_MSMC_SBNDC4__RESV1_MASK      (0x0000FF00u)
#define CSL_MSMC_SBNDC4__RESV1_SHIFT     (0x00000008u)
#define CSL_MSMC_SBNDC4__RESV1_RESETVAL  (0x00000000u)

#define CSL_MSMC_SBNDC4_SCNTCE_MASK      (0x00FF0000u)
#define CSL_MSMC_SBNDC4_SCNTCE_SHIFT     (0x00000010u)
#define CSL_MSMC_SBNDC4_SCNTCE_RESETVAL  (0x0000001Fu)

#define CSL_MSMC_SBNDC4__RESV2_MASK      (0xFF000000u)
#define CSL_MSMC_SBNDC4__RESV2_SHIFT     (0x00000018u)
#define CSL_MSMC_SBNDC4__RESV2_RESETVAL  (0x00000000u)

#define CSL_MSMC_SBNDC4_RESETVAL         (0x001F001Fu)

/* SBNDC5 */

#define CSL_MSMC_SBNDC5_SCNTCM_MASK      (0x000000FFu)
#define CSL_MSMC_SBNDC5_SCNTCM_SHIFT     (0x00000000u)
#define CSL_MSMC_SBNDC5_SCNTCM_RESETVAL  (0x0000001Fu)

#define CSL_MSMC_SBNDC5__RESV1_MASK      (0x0000FF00u)
#define CSL_MSMC_SBNDC5__RESV1_SHIFT     (0x00000008u)
#define CSL_MSMC_SBNDC5__RESV1_RESETVAL  (0x00000000u)

#define CSL_MSMC_SBNDC5_SCNTCE_MASK      (0x00FF0000u)
#define CSL_MSMC_SBNDC5_SCNTCE_SHIFT     (0x00000010u)
#define CSL_MSMC_SBNDC5_SCNTCE_RESETVAL  (0x0000001Fu)

#define CSL_MSMC_SBNDC5__RESV2_MASK      (0xFF000000u)
#define CSL_MSMC_SBNDC5__RESV2_SHIFT     (0x00000018u)
#define CSL_MSMC_SBNDC5__RESV2_RESETVAL  (0x00000000u)

#define CSL_MSMC_SBNDC5_RESETVAL         (0x001F001Fu)

/* SBNDC6 */

#define CSL_MSMC_SBNDC6_SCNTCM_MASK      (0x000000FFu)
#define CSL_MSMC_SBNDC6_SCNTCM_SHIFT     (0x00000000u)
#define CSL_MSMC_SBNDC6_SCNTCM_RESETVAL  (0x0000001Fu)

#define CSL_MSMC_SBNDC6__RESV1_MASK      (0x0000FF00u)
#define CSL_MSMC_SBNDC6__RESV1_SHIFT     (0x00000008u)
#define CSL_MSMC_SBNDC6__RESV1_RESETVAL  (0x00000000u)

#define CSL_MSMC_SBNDC6_SCNTCE_MASK      (0x00FF0000u)
#define CSL_MSMC_SBNDC6_SCNTCE_SHIFT     (0x00000010u)
#define CSL_MSMC_SBNDC6_SCNTCE_RESETVAL  (0x0000001Fu)

#define CSL_MSMC_SBNDC6__RESV2_MASK      (0xFF000000u)
#define CSL_MSMC_SBNDC6__RESV2_SHIFT     (0x00000018u)
#define CSL_MSMC_SBNDC6__RESV2_RESETVAL  (0x00000000u)

#define CSL_MSMC_SBNDC6_RESETVAL         (0x001F001Fu)

/* SBNDC7 */

#define CSL_MSMC_SBNDC7_SCNTCM_MASK      (0x000000FFu)
#define CSL_MSMC_SBNDC7_SCNTCM_SHIFT     (0x00000000u)
#define CSL_MSMC_SBNDC7_SCNTCM_RESETVAL  (0x0000001Fu)

#define CSL_MSMC_SBNDC7__RESV1_MASK      (0x0000FF00u)
#define CSL_MSMC_SBNDC7__RESV1_SHIFT     (0x00000008u)
#define CSL_MSMC_SBNDC7__RESV1_RESETVAL  (0x00000000u)

#define CSL_MSMC_SBNDC7_SCNTCE_MASK      (0x00FF0000u)
#define CSL_MSMC_SBNDC7_SCNTCE_SHIFT     (0x00000010u)
#define CSL_MSMC_SBNDC7_SCNTCE_RESETVAL  (0x0000001Fu)

#define CSL_MSMC_SBNDC7__RESV2_MASK      (0xFF000000u)
#define CSL_MSMC_SBNDC7__RESV2_SHIFT     (0x00000018u)
#define CSL_MSMC_SBNDC7__RESV2_RESETVAL  (0x00000000u)

#define CSL_MSMC_SBNDC7_RESETVAL         (0x001F001Fu)

/* SBNDM */

#define CSL_MSMC_SBNDM_SCNTMM_MASK       (0x000000FFu)
#define CSL_MSMC_SBNDM_SCNTMM_SHIFT      (0x00000000u)
#define CSL_MSMC_SBNDM_SCNTMM_RESETVAL   (0x0000001Fu)

#define CSL_MSMC_SBNDM__RESV1_MASK       (0xFFFFFF00u)
#define CSL_MSMC_SBNDM__RESV1_SHIFT      (0x00000008u)
#define CSL_MSMC_SBNDM__RESV1_RESETVAL   (0x00000000u)

#define CSL_MSMC_SBNDM_RESETVAL          (0x0000001Fu)

/* SBNDE */

#define CSL_MSMC_SBNDE_SCNTEM_MASK       (0x000000FFu)
#define CSL_MSMC_SBNDE_SCNTEM_SHIFT      (0x00000000u)
#define CSL_MSMC_SBNDE_SCNTEM_RESETVAL   (0x0000001Fu)

#define CSL_MSMC_SBNDE__RESV1_MASK       (0x0000FF00u)
#define CSL_MSMC_SBNDE__RESV1_SHIFT      (0x00000008u)
#define CSL_MSMC_SBNDE__RESV1_RESETVAL   (0x00000000u)

#define CSL_MSMC_SBNDE_SCNTEE_MASK       (0x00FF0000u)
#define CSL_MSMC_SBNDE_SCNTEE_SHIFT      (0x00000010u)
#define CSL_MSMC_SBNDE_SCNTEE_RESETVAL   (0x0000001Fu)

#define CSL_MSMC_SBNDE__RESV2_MASK       (0xFF000000u)
#define CSL_MSMC_SBNDE__RESV2_SHIFT      (0x00000018u)
#define CSL_MSMC_SBNDE__RESV2_RESETVAL   (0x00000000u)

#define CSL_MSMC_SBNDE_RESETVAL          (0x001F001Fu)

/* SMEDCTST */

#define CSL_MSMC_SMEDCTST_PF0_MASK       (0x00000001u)
#define CSL_MSMC_SMEDCTST_PF0_SHIFT      (0x00000000u)
#define CSL_MSMC_SMEDCTST_PF0_RESETVAL   (0x00000000u)

#define CSL_MSMC_SMEDCTST_PF1_MASK       (0x00000002u)
#define CSL_MSMC_SMEDCTST_PF1_SHIFT      (0x00000001u)
#define CSL_MSMC_SMEDCTST_PF1_RESETVAL   (0x00000000u)

#define CSL_MSMC_SMEDCTST_PF2_MASK       (0x00000004u)
#define CSL_MSMC_SMEDCTST_PF2_SHIFT      (0x00000002u)
#define CSL_MSMC_SMEDCTST_PF2_RESETVAL   (0x00000000u)

#define CSL_MSMC_SMEDCTST_PF3_MASK       (0x00000008u)
#define CSL_MSMC_SMEDCTST_PF3_SHIFT      (0x00000003u)
#define CSL_MSMC_SMEDCTST_PF3_RESETVAL   (0x00000000u)

#define CSL_MSMC_SMEDCTST_BCNT_MASK      (0x00000070u)
#define CSL_MSMC_SMEDCTST_BCNT_SHIFT     (0x00000004u)
#define CSL_MSMC_SMEDCTST_BCNT_RESETVAL  (0x00000000u)

#define CSL_MSMC_SMEDCTST_SCRBADDR_MASK  (0x00FFFF80u)
#define CSL_MSMC_SMEDCTST_SCRBADDR_SHIFT (0x00000007u)
#define CSL_MSMC_SMEDCTST_SCRBADDR_RESETVAL (0x00000000u)

#define CSL_MSMC_SMEDCTST_DPS_MASK       (0xFF000000u)
#define CSL_MSMC_SMEDCTST_DPS_SHIFT      (0x00000018u)
#define CSL_MSMC_SMEDCTST_DPS_RESETVAL   (0x0000002Cu)

#define CSL_MSMC_SMEDCTST_RESETVAL       (0x2C000000u)

/* CFGLCK */

#define CSL_MSMC_CFGLCK_WLCK_MASK        (0x00000001u)
#define CSL_MSMC_CFGLCK_WLCK_SHIFT       (0x00000000u)
#define CSL_MSMC_CFGLCK_WLCK_RESETVAL    (0x00000000u)


#define CSL_MSMC_CFGLCK_MGCID_MASK       (0xFFFF0000u)
#define CSL_MSMC_CFGLCK_MGCID_SHIFT      (0x00000010u)
#define CSL_MSMC_CFGLCK_MGCID_RESETVAL   (0x00002CD0u)

#define CSL_MSMC_CFGLCK_RESETVAL         (0x2CD00000u)

/* CFGULCK */

#define CSL_MSMC_CFGULCK_WEN_MASK        (0x00000001u)
#define CSL_MSMC_CFGULCK_WEN_SHIFT       (0x00000000u)
#define CSL_MSMC_CFGULCK_WEN_RESETVAL    (0x00000000u)

#define CSL_MSMC_CFGULCK__RESV1_MASK     (0x0000FFFEu)
#define CSL_MSMC_CFGULCK__RESV1_SHIFT    (0x00000001u)
#define CSL_MSMC_CFGULCK__RESV1_RESETVAL (0x00000000u)

#define CSL_MSMC_CFGULCK_MGCID_MASK      (0xFFFF0000u)
#define CSL_MSMC_CFGULCK_MGCID_SHIFT     (0x00000010u)
#define CSL_MSMC_CFGULCK_MGCID_RESETVAL  (0x00002CD0u)

#define CSL_MSMC_CFGULCK_RESETVAL        (0x2CD00000u)

/* CFGLCKSTAT */

#define CSL_MSMC_CFGLCKSTAT_WSTAT_MASK   (0x00000001u)
#define CSL_MSMC_CFGLCKSTAT_WSTAT_SHIFT  (0x00000000u)
#define CSL_MSMC_CFGLCKSTAT_WSTAT_RESETVAL (0x00000000u)

#define CSL_MSMC_CFGLCKSTAT__RESV1_MASK  (0xFFFFFFFEu)
#define CSL_MSMC_CFGLCKSTAT__RESV1_SHIFT (0x00000001u)
#define CSL_MSMC_CFGLCKSTAT__RESV1_RESETVAL (0x00000000u)

#define CSL_MSMC_CFGLCKSTAT_RESETVAL     (0x00000000u)

/* SMS_MPAX_LCK */

#define CSL_MSMC_SMS_MPAX_LCK_WLCK_MASK  (0x0000FFFFu)
#define CSL_MSMC_SMS_MPAX_LCK_WLCK_SHIFT (0x00000000u)
#define CSL_MSMC_SMS_MPAX_LCK_WLCK_RESETVAL (0x00000000u)

#define CSL_MSMC_SMS_MPAX_LCK_MGCID_MASK (0xFFFF0000u)
#define CSL_MSMC_SMS_MPAX_LCK_MGCID_SHIFT (0x00000010u)
#define CSL_MSMC_SMS_MPAX_LCK_MGCID_RESETVAL (0x00002CD1u)

#define CSL_MSMC_SMS_MPAX_LCK_RESETVAL   (0x2CD10000u)

/* SMS_MPAX_ULCK */

#define CSL_MSMC_SMS_MPAX_ULCK_WEN_MASK  (0x0000FFFFu)
#define CSL_MSMC_SMS_MPAX_ULCK_WEN_SHIFT (0x00000000u)
#define CSL_MSMC_SMS_MPAX_ULCK_WEN_RESETVAL (0x00000000u)

#define CSL_MSMC_SMS_MPAX_ULCK_MGCID_MASK (0xFFFF0000u)
#define CSL_MSMC_SMS_MPAX_ULCK_MGCID_SHIFT (0x00000010u)
#define CSL_MSMC_SMS_MPAX_ULCK_MGCID_RESETVAL (0x00002CD1u)

#define CSL_MSMC_SMS_MPAX_ULCK_RESETVAL  (0x2CD10000u)

/* SMS_MPAX_LCKSTAT */

#define CSL_MSMC_SMS_MPAX_LCKSTAT_WSTAT_MASK (0x0000FFFFu)
#define CSL_MSMC_SMS_MPAX_LCKSTAT_WSTAT_SHIFT (0x00000000u)
#define CSL_MSMC_SMS_MPAX_LCKSTAT_WSTAT_RESETVAL (0x00000000u)

#define CSL_MSMC_SMS_MPAX_LCKSTAT__RESV1_MASK (0xFFFF0000u)
#define CSL_MSMC_SMS_MPAX_LCKSTAT__RESV1_SHIFT (0x00000010u)
#define CSL_MSMC_SMS_MPAX_LCKSTAT__RESV1_RESETVAL (0x00000000u)

#define CSL_MSMC_SMS_MPAX_LCKSTAT_RESETVAL (0x00000000u)

/* SES_MPAX_LCK */

#define CSL_MSMC_SES_MPAX_LCK_WLCK_MASK  (0x0000FFFFu)
#define CSL_MSMC_SES_MPAX_LCK_WLCK_SHIFT (0x00000000u)
#define CSL_MSMC_SES_MPAX_LCK_WLCK_RESETVAL (0x00000000u)

#define CSL_MSMC_SES_MPAX_LCK_MGCID_MASK (0xFFFF0000u)
#define CSL_MSMC_SES_MPAX_LCK_MGCID_SHIFT (0x00000010u)
#define CSL_MSMC_SES_MPAX_LCK_MGCID_RESETVAL (0x00002CD2u)

#define CSL_MSMC_SES_MPAX_LCK_RESETVAL   (0x2CD20000u)

/* SES_MPAX_ULCK */

#define CSL_MSMC_SES_MPAX_ULCK_WEN_MASK  (0x0000FFFFu)
#define CSL_MSMC_SES_MPAX_ULCK_WEN_SHIFT (0x00000000u)
#define CSL_MSMC_SES_MPAX_ULCK_WEN_RESETVAL (0x00000000u)

#define CSL_MSMC_SES_MPAX_ULCK_MGCID_MASK (0xFFFF0000u)
#define CSL_MSMC_SES_MPAX_ULCK_MGCID_SHIFT (0x00000010u)
#define CSL_MSMC_SES_MPAX_ULCK_MGCID_RESETVAL (0x00002CD2u)

#define CSL_MSMC_SES_MPAX_ULCK_RESETVAL  (0x2CD20000u)

/* SES_MPAX_LCKSTAT */

#define CSL_MSMC_SES_MPAX_LCKSTAT_WSTAT_MASK (0x0000FFFFu)
#define CSL_MSMC_SES_MPAX_LCKSTAT_WSTAT_SHIFT (0x00000000u)
#define CSL_MSMC_SES_MPAX_LCKSTAT_WSTAT_RESETVAL (0x00000000u)

#define CSL_MSMC_SES_MPAX_LCKSTAT__RESV1_MASK (0xFFFF0000u)
#define CSL_MSMC_SES_MPAX_LCKSTAT__RESV1_SHIFT (0x00000010u)
#define CSL_MSMC_SES_MPAX_LCKSTAT__RESV1_RESETVAL (0x00000000u)

#define CSL_MSMC_SES_MPAX_LCKSTAT_RESETVAL (0x00000000u)

/* SMESTAT */

#define CSL_MSMC_SMESTAT_NCSES_MASK      (0x00000001u)
#define CSL_MSMC_SMESTAT_NCSES_SHIFT     (0x00000000u)
#define CSL_MSMC_SMESTAT_NCSES_RESETVAL  (0x00000000u)

#define CSL_MSMC_SMESTAT_CSES_MASK       (0x00000002u)
#define CSL_MSMC_SMESTAT_CSES_SHIFT      (0x00000001u)
#define CSL_MSMC_SMESTAT_CSES_RESETVAL   (0x00000000u)

#define CSL_MSMC_SMESTAT_NCEES_MASK      (0x00000004u)
#define CSL_MSMC_SMESTAT_NCEES_SHIFT     (0x00000002u)
#define CSL_MSMC_SMESTAT_NCEES_RESETVAL  (0x00000000u)

#define CSL_MSMC_SMESTAT_CEES_MASK       (0x00000008u)
#define CSL_MSMC_SMESTAT_CEES_SHIFT      (0x00000003u)
#define CSL_MSMC_SMESTAT_CEES_RESETVAL   (0x00000000u)

#define CSL_MSMC_SMESTAT__RESV1_MASK     (0x0000FFF0u)
#define CSL_MSMC_SMESTAT__RESV1_SHIFT    (0x00000004u)
#define CSL_MSMC_SMESTAT__RESV1_RESETVAL (0x00000000u)

#define CSL_MSMC_SMESTAT_PFESTAT_MASK    (0xFFFF0000u)
#define CSL_MSMC_SMESTAT_PFESTAT_SHIFT   (0x00000010u)
#define CSL_MSMC_SMESTAT_PFESTAT_RESETVAL (0x00000000u)

#define CSL_MSMC_SMESTAT_RESETVAL        (0x00000000u)

/* SMIRSTAT */

#define CSL_MSMC_SMIRSTAT_NCSES_MASK     (0x00000001u)
#define CSL_MSMC_SMIRSTAT_NCSES_SHIFT    (0x00000000u)
#define CSL_MSMC_SMIRSTAT_NCSES_RESETVAL (0x00000000u)

#define CSL_MSMC_SMIRSTAT_CSES_MASK      (0x00000002u)
#define CSL_MSMC_SMIRSTAT_CSES_SHIFT     (0x00000001u)
#define CSL_MSMC_SMIRSTAT_CSES_RESETVAL  (0x00000000u)

#define CSL_MSMC_SMIRSTAT_NCEES_MASK     (0x00000004u)
#define CSL_MSMC_SMIRSTAT_NCEES_SHIFT    (0x00000002u)
#define CSL_MSMC_SMIRSTAT_NCEES_RESETVAL (0x00000000u)

#define CSL_MSMC_SMIRSTAT_CEES_MASK      (0x00000008u)
#define CSL_MSMC_SMIRSTAT_CEES_SHIFT     (0x00000003u)
#define CSL_MSMC_SMIRSTAT_CEES_RESETVAL  (0x00000000u)

#define CSL_MSMC_SMIRSTAT__RESV1_MASK    (0x0000FFF0u)
#define CSL_MSMC_SMIRSTAT__RESV1_SHIFT   (0x00000004u)
#define CSL_MSMC_SMIRSTAT__RESV1_RESETVAL (0x00000000u)

#define CSL_MSMC_SMIRSTAT_PFESTAT_MASK   (0xFFFF0000u)
#define CSL_MSMC_SMIRSTAT_PFESTAT_SHIFT  (0x00000010u)
#define CSL_MSMC_SMIRSTAT_PFESTAT_RESETVAL (0x00000000u)

#define CSL_MSMC_SMIRSTAT_RESETVAL       (0x00000000u)

/* SMIRC */

#define CSL_MSMC_SMIRC_NCSC_MASK         (0x00000001u)
#define CSL_MSMC_SMIRC_NCSC_SHIFT        (0x00000000u)
#define CSL_MSMC_SMIRC_NCSC_RESETVAL     (0x00000000u)

#define CSL_MSMC_SMIRC_CSC_MASK          (0x00000002u)
#define CSL_MSMC_SMIRC_CSC_SHIFT         (0x00000001u)
#define CSL_MSMC_SMIRC_CSC_RESETVAL      (0x00000000u)

#define CSL_MSMC_SMIRC_NCEC_MASK         (0x00000004u)
#define CSL_MSMC_SMIRC_NCEC_SHIFT        (0x00000002u)
#define CSL_MSMC_SMIRC_NCEC_RESETVAL     (0x00000000u)

#define CSL_MSMC_SMIRC_CEC_MASK          (0x00000008u)
#define CSL_MSMC_SMIRC_CEC_SHIFT         (0x00000003u)
#define CSL_MSMC_SMIRC_CEC_RESETVAL      (0x00000000u)

#define CSL_MSMC_SMIRC__RESV1_MASK       (0x0000FFF0u)
#define CSL_MSMC_SMIRC__RESV1_SHIFT      (0x00000004u)
#define CSL_MSMC_SMIRC__RESV1_RESETVAL   (0x00000000u)

#define CSL_MSMC_SMIRC_PFIC_MASK         (0xFFFF0000u)
#define CSL_MSMC_SMIRC_PFIC_SHIFT        (0x00000010u)
#define CSL_MSMC_SMIRC_PFIC_RESETVAL     (0x00000000u)

#define CSL_MSMC_SMIRC_RESETVAL          (0x00000000u)

/* SMIESTAT */

#define CSL_MSMC_SMIESTAT_NCSIE_MASK     (0x00000001u)
#define CSL_MSMC_SMIESTAT_NCSIE_SHIFT    (0x00000000u)
#define CSL_MSMC_SMIESTAT_NCSIE_RESETVAL (0x00000000u)

#define CSL_MSMC_SMIESTAT_CSIE_MASK      (0x00000002u)
#define CSL_MSMC_SMIESTAT_CSIE_SHIFT     (0x00000001u)
#define CSL_MSMC_SMIESTAT_CSIE_RESETVAL  (0x00000000u)

#define CSL_MSMC_SMIESTAT_NCEIE_MASK     (0x00000004u)
#define CSL_MSMC_SMIESTAT_NCEIE_SHIFT    (0x00000002u)
#define CSL_MSMC_SMIESTAT_NCEIE_RESETVAL (0x00000000u)

#define CSL_MSMC_SMIESTAT_CEIE_MASK      (0x00000008u)
#define CSL_MSMC_SMIESTAT_CEIE_SHIFT     (0x00000003u)
#define CSL_MSMC_SMIESTAT_CEIE_RESETVAL  (0x00000000u)

#define CSL_MSMC_SMIESTAT__RESV1_MASK    (0x0000FFF0u)
#define CSL_MSMC_SMIESTAT__RESV1_SHIFT   (0x00000004u)
#define CSL_MSMC_SMIESTAT__RESV1_RESETVAL (0x00000000u)

#define CSL_MSMC_SMIESTAT_PFIESTAT_MASK  (0xFFFF0000u)
#define CSL_MSMC_SMIESTAT_PFIESTAT_SHIFT (0x00000010u)
#define CSL_MSMC_SMIESTAT_PFIESTAT_RESETVAL (0x00000000u)

#define CSL_MSMC_SMIESTAT_RESETVAL       (0x00000000u)

/* SMIEC */

#define CSL_MSMC_SMIEC_NCSEC_MASK        (0x00000001u)
#define CSL_MSMC_SMIEC_NCSEC_SHIFT       (0x00000000u)
#define CSL_MSMC_SMIEC_NCSEC_RESETVAL    (0x00000000u)

#define CSL_MSMC_SMIEC_CSEC_MASK         (0x00000002u)
#define CSL_MSMC_SMIEC_CSEC_SHIFT        (0x00000001u)
#define CSL_MSMC_SMIEC_CSEC_RESETVAL     (0x00000000u)

#define CSL_MSMC_SMIEC_NCEEC_MASK        (0x00000004u)
#define CSL_MSMC_SMIEC_NCEEC_SHIFT       (0x00000002u)
#define CSL_MSMC_SMIEC_NCEEC_RESETVAL    (0x00000000u)

#define CSL_MSMC_SMIEC_CEEC_MASK         (0x00000008u)
#define CSL_MSMC_SMIEC_CEEC_SHIFT        (0x00000003u)
#define CSL_MSMC_SMIEC_CEEC_RESETVAL     (0x00000000u)

#define CSL_MSMC_SMIEC__RESV1_MASK       (0x0000FFF0u)
#define CSL_MSMC_SMIEC__RESV1_SHIFT      (0x00000004u)
#define CSL_MSMC_SMIEC__RESV1_RESETVAL   (0x00000000u)

#define CSL_MSMC_SMIEC_PFIEC_MASK        (0xFFFF0000u)
#define CSL_MSMC_SMIEC_PFIEC_SHIFT       (0x00000010u)
#define CSL_MSMC_SMIEC_PFIEC_RESETVAL    (0x00000000u)

#define CSL_MSMC_SMIEC_RESETVAL          (0x00000000u)

/* SMATH */

#define CSL_MSMC_SMATH_THEADER_MASK      (0xFFFFFFFFu)
#define CSL_MSMC_SMATH_THEADER_SHIFT     (0x00000000u)
#define CSL_MSMC_SMATH_THEADER_RESETVAL  (0x00000000u)

#define CSL_MSMC_SMATH_RESETVAL          (0x00000000u)

/* SMAH */

#define CSL_MSMC_SMAH_HCNT_MASK          (0x000FFFFFu)
#define CSL_MSMC_SMAH_HCNT_SHIFT         (0x00000000u)
#define CSL_MSMC_SMAH_HCNT_RESETVAL      (0x00000000u)

#define CSL_MSMC_SMAH__RESV1_MASK        (0xFFF00000u)
#define CSL_MSMC_SMAH__RESV1_SHIFT       (0x00000014u)
#define CSL_MSMC_SMAH__RESV1_RESETVAL    (0x00000000u)

#define CSL_MSMC_SMAH_RESETVAL           (0x00000000u)

/* SMARM */

#define CSL_MSMC_SMARM_RMCNT_MASK        (0x000FFFFFu)
#define CSL_MSMC_SMARM_RMCNT_SHIFT       (0x00000000u)
#define CSL_MSMC_SMARM_RMCNT_RESETVAL    (0x00000000u)

#define CSL_MSMC_SMARM__RESV1_MASK       (0xFFF00000u)
#define CSL_MSMC_SMARM__RESV1_SHIFT      (0x00000014u)
#define CSL_MSMC_SMARM__RESV1_RESETVAL   (0x00000000u)

#define CSL_MSMC_SMARM_RESETVAL          (0x00000000u)

/* SMAWM */

#define CSL_MSMC_SMAWM_WMCNT_MASK        (0x000FFFFFu)
#define CSL_MSMC_SMAWM_WMCNT_SHIFT       (0x00000000u)
#define CSL_MSMC_SMAWM_WMCNT_RESETVAL    (0x00000000u)

#define CSL_MSMC_SMAWM__RESV1_MASK       (0xFFF00000u)
#define CSL_MSMC_SMAWM__RESV1_SHIFT      (0x00000014u)
#define CSL_MSMC_SMAWM__RESV1_RESETVAL   (0x00000000u)

#define CSL_MSMC_SMAWM_RESETVAL          (0x00000000u)

/* SMAV */

#define CSL_MSMC_SMAV_VCNT_MASK          (0x000FFFFFu)
#define CSL_MSMC_SMAV_VCNT_SHIFT         (0x00000000u)
#define CSL_MSMC_SMAV_VCNT_RESETVAL      (0x00000000u)

#define CSL_MSMC_SMAV__RESV1_MASK        (0xFFF00000u)
#define CSL_MSMC_SMAV__RESV1_SHIFT       (0x00000014u)
#define CSL_MSMC_SMAV__RESV1_RESETVAL    (0x00000000u)

#define CSL_MSMC_SMAV_RESETVAL           (0x00000000u)

/* SMAMP */

#define CSL_MSMC_SMAMP_ACWM_MASK         (0x000FFFFFu)
#define CSL_MSMC_SMAMP_ACWM_SHIFT        (0x00000000u)
#define CSL_MSMC_SMAMP_ACWM_RESETVAL     (0x00000000u)

#define CSL_MSMC_SMAMP__RESV1_MASK       (0x00F00000u)
#define CSL_MSMC_SMAMP__RESV1_SHIFT      (0x00000014u)
#define CSL_MSMC_SMAMP__RESV1_RESETVAL   (0x00000000u)

#define CSL_MSMC_SMAMP_MPECNT_MASK       (0xFF000000u)
#define CSL_MSMC_SMAMP_MPECNT_SHIFT      (0x00000018u)
#define CSL_MSMC_SMAMP_MPECNT_RESETVAL   (0x00000000u)

#define CSL_MSMC_SMAMP_RESETVAL          (0x00000000u)

/* SMAEP */

#define CSL_MSMC_SMAEP_ACWE_MASK         (0x000FFFFFu)
#define CSL_MSMC_SMAEP_ACWE_SHIFT        (0x00000000u)
#define CSL_MSMC_SMAEP_ACWE_RESETVAL     (0x00000000u)

#define CSL_MSMC_SMAEP__RESV1_MASK       (0x00F00000u)
#define CSL_MSMC_SMAEP__RESV1_SHIFT      (0x00000014u)
#define CSL_MSMC_SMAEP__RESV1_RESETVAL   (0x00000000u)

#define CSL_MSMC_SMAEP_EPECNT_MASK       (0xFF000000u)
#define CSL_MSMC_SMAEP_EPECNT_SHIFT      (0x00000018u)
#define CSL_MSMC_SMAEP_EPECNT_RESETVAL   (0x00000000u)

#define CSL_MSMC_SMAEP_RESETVAL          (0x00000000u)

/* SMAC */

#define CSL_MSMC_SMAC__RESV1_MASK        (0x00000001u)
#define CSL_MSMC_SMAC__RESV1_SHIFT       (0x00000000u)
#define CSL_MSMC_SMAC__RESV1_RESETVAL    (0x00000000u)

#define CSL_MSMC_SMAC_AEN_MASK           (0x00000002u)
#define CSL_MSMC_SMAC_AEN_SHIFT          (0x00000001u)
#define CSL_MSMC_SMAC_AEN_RESETVAL       (0x00000000u)

#define CSL_MSMC_SMAC_PTH_MASK           (0x0000001Cu)
#define CSL_MSMC_SMAC_PTH_SHIFT          (0x00000002u)
#define CSL_MSMC_SMAC_PTH_RESETVAL       (0x00000007u)

#define CSL_MSMC_SMAC_HM_MASK            (0x00000020u)
#define CSL_MSMC_SMAC_HM_SHIFT           (0x00000005u)
#define CSL_MSMC_SMAC_HM_RESETVAL        (0x00000000u)

#define CSL_MSMC_SMAC__RESV2_MASK        (0x000000C0u)
#define CSL_MSMC_SMAC__RESV2_SHIFT       (0x00000006u)
#define CSL_MSMC_SMAC__RESV2_RESETVAL    (0x00000000u)

#define CSL_MSMC_SMAC_PIDF_MASK          (0x00FFFF00u)
#define CSL_MSMC_SMAC_PIDF_SHIFT         (0x00000008u)
#define CSL_MSMC_SMAC_PIDF_RESETVAL      (0x0000FFFFu)

#define CSL_MSMC_SMAC_CCF_MASK           (0xFF000000u)
#define CSL_MSMC_SMAC_CCF_SHIFT          (0x00000018u)
#define CSL_MSMC_SMAC_CCF_RESETVAL       (0x000000FFu)

#define CSL_MSMC_SMAC_RESETVAL           (0xFFFFFF1Cu)

/* SMCFG */

#define CSL_MSMC_SMCFG_CMODE_MASK        (0x0000000Fu)
#define CSL_MSMC_SMCFG_CMODE_SHIFT       (0x00000000u)
#define CSL_MSMC_SMCFG_CMODE_RESETVAL    (0x00000000u)

#define CSL_MSMC_SMCFG_GIW_MASK          (0x00000010u)
#define CSL_MSMC_SMCFG_GIW_SHIFT         (0x00000004u)
#define CSL_MSMC_SMCFG_GIW_RESETVAL      (0x00000000u)

#define CSL_MSMC_SMCFG_EFZ_MASK          (0x00000020u)
#define CSL_MSMC_SMCFG_EFZ_SHIFT         (0x00000005u)
#define CSL_MSMC_SMCFG_EFZ_RESETVAL      (0x00000000u)

#define CSL_MSMC_SMCFG_INVP_MASK         (0x000001C0u)
#define CSL_MSMC_SMCFG_INVP_SHIFT        (0x00000006u)
#define CSL_MSMC_SMCFG_INVP_RESETVAL     (0x00000007u)

#define CSL_MSMC_SMCFG__RESV1_MASK       (0xFFFFFE00u)
#define CSL_MSMC_SMCFG__RESV1_SHIFT      (0x00000009u)
#define CSL_MSMC_SMCFG__RESV1_RESETVAL   (0x00000000u)

#define CSL_MSMC_SMCFG_RESETVAL          (0x000001C0u)

/* SMNCERRAR */

#define CSL_MSMC_SMNCERRAR_SEADDR_MASK   (0xFFFFFFFFu)
#define CSL_MSMC_SMNCERRAR_SEADDR_SHIFT  (0x00000000u)
#define CSL_MSMC_SMNCERRAR_SEADDR_RESETVAL (0x00000000u)

#define CSL_MSMC_SMNCERRAR_RESETVAL      (0x00000000u)

/* SMNCERRXR */

#define CSL_MSMC_SMNCERRXR_SEEADDR_MASK  (0x0000000Fu)
#define CSL_MSMC_SMNCERRXR_SEEADDR_SHIFT (0x00000000u)
#define CSL_MSMC_SMNCERRXR_SEEADDR_RESETVAL (0x00000000u)

#define CSL_MSMC_SMNCERRXR_SEPID_MASK    (0x000000F0u)
#define CSL_MSMC_SMNCERRXR_SEPID_SHIFT   (0x00000004u)
#define CSL_MSMC_SMNCERRXR_SEPID_RESETVAL (0x00000000u)

#define CSL_MSMC_SMNCERRXR_SER_MASK      (0x00000100u)
#define CSL_MSMC_SMNCERRXR_SER_SHIFT     (0x00000008u)
#define CSL_MSMC_SMNCERRXR_SER_RESETVAL  (0x00000000u)

#define CSL_MSMC_SMNCERRXR__RESV1_MASK   (0xFFFFFE00u)
#define CSL_MSMC_SMNCERRXR__RESV1_SHIFT  (0x00000009u)
#define CSL_MSMC_SMNCERRXR__RESV1_RESETVAL (0x00000000u)

#define CSL_MSMC_SMNCERRXR_RESETVAL      (0x00000000u)

/* SMNCEA */

#define CSL_MSMC_SMNCEA_SENCA_MASK       (0x00FFFFFFu)
#define CSL_MSMC_SMNCEA_SENCA_SHIFT      (0x00000000u)
#define CSL_MSMC_SMNCEA_SENCA_RESETVAL   (0x00000000u)

#define CSL_MSMC_SMNCEA__RESV1_MASK      (0xFF000000u)
#define CSL_MSMC_SMNCEA__RESV1_SHIFT     (0x00000018u)
#define CSL_MSMC_SMNCEA__RESV1_RESETVAL  (0x00000000u)

#define CSL_MSMC_SMNCEA_RESETVAL         (0x00000000u)

#endif

