/******************************************************************************
 * FILE PURPOSE: PA FW module specification file.
 ******************************************************************************
 * FILE NAME: module.xs
 *
 * DESCRIPTION: 
 *  This file contains the module specification for the PA fw directory.
 *
 * Copyright (C) 2009, Texas Instruments, Inc.
 *****************************************************************************/

/* Load the library utility. */
var libUtility = xdc.loadCapsule ("../build/buildlib.xs");

/**************************************************************************
 * FUNCTION NAME : modBuild
 **************************************************************************
 * DESCRIPTION   :
 *  The function is used to build all the components of the PA library
 **************************************************************************/
function modBuild() 
{

    /* Assemble the firmware */
    Pkg.makePrologue += ".PHONY: firmware\n\n";
    Pkg.makePrologue += "release: firmware\n";
    Pkg.makePrologue += "firmware: \n";
    Pkg.makePrologue += "\t $(ECHO) making the firmware\n";
    Pkg.makePrologue += "\t cd fw; pasm_linux -EBldXc -Cc1 classify1.p\n";
    Pkg.makePrologue += "\t cd fw; pasm_linux -EBldXc -Cc2 classify2.p\n";
    Pkg.makePrologue += "\t cd fw; pasm_linux -EBldXc -Cm pam.p\n";

    /* format the firmware assembler output */
    Pkg.makePrologue += "\t cd fw; cat classify1_desc.c > classify1_bin.c\n";
    Pkg.makePrologue += "\t cd fw; cat classify1_bin.h | sed -e s/\"unsigned int\"/\"uint32_t\"/g >> classify1_bin.c\n";
    Pkg.makePrologue += "\t cd fw; $(ECHO) \"const int c1Size = sizeof(c1);\" >> classify1_bin.c\n";

    Pkg.makePrologue += "\t cd fw; cat classify2_desc.c > classify2_bin.c\n";
    Pkg.makePrologue += "\t cd fw; cat classify2_bin.h | sed -e s/\"unsigned int\"/\"uint32_t\"/g >> classify2_bin.c\n";
    Pkg.makePrologue += "\t cd fw; $(ECHO) \"const int c2Size = sizeof(c2);\" >> classify2_bin.c\n";

    Pkg.makePrologue += "\t cd fw; cat pam_desc.c > pam_bin.c\n";
    Pkg.makePrologue += "\t cd fw; cat pam_bin.h | sed -e s/\"unsigned int\"/\"uint32_t\"/g >> pam_bin.c\n";
    Pkg.makePrologue += "\t cd fw; $(ECHO) \"const int mSize = sizeof(m);\" >> pam_bin.c\n";

    Pkg.otherFiles[Pkg.otherFiles.length++] = "fw/classify1_bin.c";
    Pkg.otherFiles[Pkg.otherFiles.length++] = "fw/classify2_bin.c";
    Pkg.otherFiles[Pkg.otherFiles.length++] = "fw/pam_bin.c";
    Pkg.otherFiles[Pkg.otherFiles.length++] = "fw/pafw.h";
    Pkg.otherFiles[Pkg.otherFiles.length++] = "fw/classify1.bib";
    Pkg.otherFiles[Pkg.otherFiles.length++] = "fw/classify2.bib";
    Pkg.otherFiles[Pkg.otherFiles.length++] = "fw/pam.bib";

    /* Delete temporary files */
    Pkg.makePrologue += "\t cd fw; rm -f classify1_bin.h classify2_bin.h pam_bin.h\n";

}

