/**  
 * @file fw_test.h
 *
 * @brief 
 *  Holds all the constants and API definitions required by the example
 *  application to run.
 *
 *  \par
 *  ============================================================================
 *  @n   (C) Copyright 2012, Texas Instruments, Inc.
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/
#ifndef _FW_TEST_H_
#define _FW_TEST_H_

/* C Standard library Include */
#include <stdio.h>
/* System level header files */
#include <stdint.h>
#include <stdlib.h>

#include <sys/types.h> 
#include <string.h>
#include <ti/drv/pa/pa.h>


/* CPPI LLD include */
#include <ti/drv/cppi/cppi_drv.h>
#include <ti/drv/cppi/cppi_desc.h>

/* QMSS LLD include */
#include <ti/drv/qmss/qmss_drv.h>


#define System_printf   printf

#define CACHE_LINESZ    64

/* Workaround not to use flow ID 0 as it is currently used by Kernel */
#define FLOW_WORKAROUND 1

typedef uint16_t fw_Bool_t;
#define  fw_TRUE  1
#define  fw_FALSE  0

/* Total Permanent memory required in Example
 * for Packet buffers & descriptor buffers
 * Allocating entire MSMC
 */
#define MSMC_TEST_PERM_MEM_SZ   (2*1024*1024)

/* Physical address map & size for various subsystems */
#define QMSS_CFG_BASE_ADDR  CSL_QM_SS_CFG_QUE_PEEK_REGS
#define QMSS_CFG_BLK_SZ (1*1024*1024)
#define QMSS_DATA_BASE_ADDR 0x44020000 
#define QMSS_DATA_BASE_QUEUE_PROXY_ADDR 0x44040000 
#define QMSS_DATA_BLK_SZ (0x60000)
#define SRIO_CFG_BASE_ADDR  CSL_SRIO_CONFIG_REGS
#define SRIO_CFG_BLK_SZ (132*1024)
#define PASS_CFG_BASE_ADDR  CSL_PA_SS_CFG_REGS 
#define PASS_CFG_BLK_SZ (1*1024*1024)
#define MSMC_SRAM_BASE_ADDR CSL_MSMC_SRAM_REGS

/* Global variables to hold virtual address of various subsystems */
void *fw_qmssCfgVaddr;
void *fw_qmssDataVaddr;
void *fw_srioCfgVaddr;
void *fw_passCfgVaddr;


/** Enable Extended Debug with printfs */
/*
#define         EXT_DEBUG                   1
*/

/** Number of ports in the ethernet subsystem */
#define         NUM_PORTS                   3u

/** Number of MAC/GMII ports in the ethernet switch */
#define         NUM_MAC_PORTS               2u

/** Number of host descriptors used by the CPSW example program */
#define         NUM_HOST_DESC               32

/** Host descriptor size. 
 *
 *  Big enough to hold the mandatory fields of the 
 *  host descriptor and PA Control Data
 * 
 *  = 32 bytes for Host desc + PA Control data
 */
#define         SIZE_HOST_DESC              80 

/** Number of PA Tx queues available */
#define         NUM_PA_TX_QUEUES            9

/** Number of PA Rx channels available */
#define         NUM_PA_RX_CHANNELS          24

/* Number of Tx Free descriptors to allocate */
#define     NUM_TX_DESC                 NUM_HOST_DESC/2

/* Number of Rx Free descriptors to allocate */
#define     NUM_RX_DESC                 NUM_HOST_DESC/2

/* Buffer sizes configured for 
 * -  maximum command size to PA 
 * -  Maximum size of the control messages
 *    from DSP
 * - Maximum size of the packets being transmitted
 */
#define TX_BUF_SIZE 		(((300+15)/16)*16)  
#define RX_BUF_SIZE 		TX_BUF_SIZE  


/* Define LoopBack modes */  
#define PASS_LOOPBACK_INTERNAL       1
#define PASS_LOOPBACK_EXTERNAL       2

/* Invalidate  cache. This should invalidate Cache
 * Wait until operation is complete. Currently stub function
 */    
#define SYS_CACHE_INV(addr, size, code)  Osal_invalidateCache(addr,size)  

/* Writeback L2 cache. This should Writeback L1D as well. 
 * Wait until operation is complete. Currently stub function
 */ 
#define SYS_CACHE_WB(addr, size, code) Osal_writeBackCache(addr,size) 
#define ALIGN(x)    __attribute__((aligned (x)))

extern int32_t passLpbkMode;
extern Cppi_FlowHnd gRxFlowHnd;


extern int32_t Init_Qmss (void);
extern int32_t Init_Cppi (void);
extern int32_t Init_PASS (void);
extern int32_t Setup_Tx (void);
extern int32_t Setup_Rx (void);
extern int32_t Setup_PASS (void);
extern int32_t SendPacket (void);
extern int32_t getPaStats (void);
extern void    CycleDelay (int32_t count);
extern int32_t ReceivePacket (void);
extern int32_t VerifyPacket (Cppi_Desc* pCppiDesc);
extern void Osal_invalidateCache (void *blockPtr, uint32_t size);
extern void Osal_writeBackCache (void *blockPtr, uint32_t size);
#endif
