/******************************************************************************
 * FILE PURPOSE: PA Source module specification file.
 ******************************************************************************
 * FILE NAME: module.xs
 *
 * DESCRIPTION: 
 *  This file contains the module specification for the PA source directory.
 *
 * Copyright (C) 2009, Texas Instruments, Inc.
 *****************************************************************************/

/* Load the library utility. */
var libUtility = xdc.loadCapsule ("../build/buildlib.xs");

/**************************************************************************
 * FUNCTION NAME : modBuild
 **************************************************************************
 * DESCRIPTION   :
 *  The function is used to build all the components of the PA library
 **************************************************************************/
function modBuild() 
{
    /* Add all the .c files to the release package. */
    var exampleFiles = libUtility.listAllFiles (".c", "example", true);
    for (var k = 0 ; k < exampleFiles.length; k++)
        Pkg.otherFiles[Pkg.otherFiles.length++] = exampleFiles[k];

    /* Add all the .h files to the release package. */
    var exampleFiles = libUtility.listAllFiles (".h", "example", true);
    for (var k = 0 ; k < exampleFiles.length; k++)
        Pkg.otherFiles[Pkg.otherFiles.length++] = exampleFiles[k];

    /* Add all the .cmd files to the release package. */
    var exampleFiles = libUtility.listAllFiles (".cmd", "example", true);
    for (var k = 0 ; k < exampleFiles.length; k++)
        Pkg.otherFiles[Pkg.otherFiles.length++] = exampleFiles[k];

    /* Add all the .make files to the release package. */
    var exampleFiles = libUtility.listAllFiles ("makefile", "example", true);
    for (var k = 0 ; k < exampleFiles.length; k++)
        Pkg.otherFiles[Pkg.otherFiles.length++] = exampleFiles[k];

    /* Add the Readme.txt to the package */
    Pkg.otherFiles[Pkg.otherFiles.length++] = "example/simpleExample/Readme.txt";
    Pkg.otherFiles[Pkg.otherFiles.length++] = "example/emacExample/Readme.txt";
    Pkg.otherFiles[Pkg.otherFiles.length++] = "example/multicoreExample/Readme.txt";
    
    /* Add project files */
    Pkg.otherFiles[Pkg.otherFiles.length++] = "example/simpleExample/PA_simpleExample_exampleProject.txt";
    Pkg.otherFiles[Pkg.otherFiles.length++] = "example/emacExample/PA_emacExample_exampleProject.txt";
    Pkg.otherFiles[Pkg.otherFiles.length++] = "example/multicoreExample/PA_multicoreExample_exampleProject.txt";

    /* Add example project related files. */
    Pkg.otherFiles[Pkg.otherFiles.length++] = "example/simpleExample/paExample/paExample.cfg";
    Pkg.otherFiles[Pkg.otherFiles.length++] = "example/emacExample/cpsw_example.cfg"
    Pkg.otherFiles[Pkg.otherFiles.length++] = "example/multicoreExample/multicore_example.cfg"

    


}

