#*******************************************************************************
#* FILE PURPOSE: Lower level makefile for Creating Component Libraries
#*******************************************************************************
#* FILE NAME: ./lib/ti.csl.intc.ae66e.mk
#*
#* DESCRIPTION: Defines Source Files, Compilers flags and build rules
#*
#*
#*******************************************************************************
#

#
# Macro definitions referenced below
#
empty =
space =$(empty) $(empty)
CC = $(C6X_GEN_INSTALL_PATH)/bin/cl6x -c --strip_coff_underscore -mo -o3 -q -k -eo.o -DBIGENDIAN -DC6678 -me -mv6600 --abi=eabi
AC = $(C6X_GEN_INSTALL_PATH)/bin/cl6x -c --strip_coff_underscore -me -mv6600 --abi=eabi
ARIN = $(C6X_GEN_INSTALL_PATH)/bin/ar6x rq
LD = $(C6X_GEN_INSTALL_PATH)/bin/lnk6x --abi=eabi
RTSLIB = -l $(C6X_GEN_INSTALL_PATH)/lib/rts6600e_elf.lib
INCS = -I. -I$(strip $(subst ;, -I,$(subst $(space),\$(space),$(INCDIR))))
OBJEXT = oe66e
AOBJEXT = se66e
INTERNALDEFS = -Dti_targets_elf_C66_big_endian  -DMAKEFILE_BUILD -eo.$(OBJEXT) -ea.$(AOBJEXT) -fr=$(@D) -fs=$(@D) -ppa -ppd=$@.dep
INTERNALLINKDEFS = -o $@ -m $@.map
OBJDIR =  $(LIBDIR)

#List the COMMONSRC Files
COMMONSRCC= \
    src/intc/_csl_intcCombEventDispatcher.c\
    src/intc/_csl_intcDispatcher.c\
    src/intc/_csl_intcResource.c\
    src/intc/csl_intcClose.c\
    src/intc/csl_intcExcep.c\
    src/intc/csl_intcGetHwStatus.c\
    src/intc/csl_intcHookIsr.c\
    src/intc/csl_intcHwControl.c\
    src/intc/csl_intcInit.c\
    src/intc/csl_intcOpen.c\
    src/intc/csl_intcPlugEventHandler.c

# FLAGS for the COMMONSRC Files
COMMONSRCCFLAGS =   -i./src/intc -i. 

# Make Rule for the COMMONSRC Files
COMMONSRCCOBJS = $(patsubst %.c, $(OBJDIR)/%.$(OBJEXT), $(COMMONSRCC))

$(COMMONSRCCOBJS): $(OBJDIR)/%.$(OBJEXT): %.c
	-@echo cle66e $< ...
	if [ ! -d $(@D) ]; then $(MKDIR) $(@D) ; fi;
	$(RM) $@.dep
	$(CC) $(COMMONSRCCFLAGS) $(INTERNALDEFS) $(INCS) -fc $< 
	-@$(CP) $@.dep $@.pp; \
         $(SED) -e 's/#.*//' -e 's/^[^:]*: *//' -e 's/ *\\$$//' \
             -e '/^$$/ d' -e 's/$$/ :/' < $@.pp >> $@.dep; \
         $(RM) $@.pp 

#Create Empty rule for dependency
$(COMMONSRCCOBJS):./lib/ti.csl.intc.ae66e.mk
./lib/ti.csl.intc.ae66e.mk:

#Include Depedency for COMMONSRC Files
ifneq (clean,$(MAKECMDGOALS))
 -include $(COMMONSRCCOBJS:%.$(OBJEXT)=%.$(OBJEXT).dep)
endif

#List the COMMONSRC Files
COMMONSRCASM= \
    src/intc/_csl_intcIntrEnDisRes.asm\
    src/intc/_csl_intcIsrDispatch.asm\
    src/intc/_csl_intcNmiDummy.asm

# FLAGS for the COMMONSRC Files
COMMONSRCASMFLAGS =   -i./src/intc -i. 

# Make Rule for the COMMONSRC Files
COMMONSRCASMOBJS = $(patsubst %.asm, $(OBJDIR)/%.$(OBJEXT), $(COMMONSRCASM))

$(COMMONSRCASMOBJS): $(OBJDIR)/%.$(OBJEXT): %.asm
	-@echo asme66e $< ...
	if [ ! -d $(@D) ]; then $(MKDIR) $(@D) ; fi;
	$(AC) $(COMMONSRCASMFLAGS) $(INTERNALDEFS) $(INCS) -fa $< 

#Create Empty rule for dependency
$(COMMONSRCASMOBJS):./lib/ti.csl.intc.ae66e.mk
./lib/ti.csl.intc.ae66e.mk:

#Include Depedency for COMMONSRC Files
ifneq (clean,$(MAKECMDGOALS))
 -include $(COMMONSRCASMOBJS:%.$(OBJEXT)=%.$(OBJEXT).dep)
endif


$(LIBDIR)/ti.csl.intc.ae66e : $(COMMONSRCCOBJS) $(COMMONSRCASMOBJS)
	@echo archiving $? into $@ ...
	$(ARIN) $@ $?
