/********************************************************************
* Copyright (C) 2003-2008 Texas Instruments Incorporated.
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/
#ifndef _CSLR_PDSP_H_
#define _CSLR_PDSP_H_

/* CSL Modification:
 *  The file has been modified from the AUTOGEN file for the following
 *  reasons:-
 *      a) Modified the header file includes to be RTSC compliant
 */

#include <ti/csl/cslr.h>
#include <ti/csl/tistdtypes.h>

/* Minimum unit = 1 byte */

/**************************************************************************\
* Register Overlay Structure
\**************************************************************************/
typedef struct  {
    volatile Uint32 PDSP_CONTROL_REG;
    volatile Uint32 PDSP_STATUS_REG;
    volatile Uint32 PDSP_WAKEUP_ENABLE_REG;
    volatile Uint32 PDSP_CYCLE_COUNT_REG;
    volatile Uint32 PDSP_STALL_COUNT_REG;
    volatile Uint8 RSVD0[12];
    volatile Uint32 PDSP_CONSTANT_TABLE_BLOCK_INDEX_REG_0;
    volatile Uint32 PDSP_CONSTANT_TABLE_BLOCK_INDEX_REG_1;
    volatile Uint32 PDSP_CONSTANT_TABLE_PROG_PTR_REG_0;
    volatile Uint32 PDSP_CONSTANT_TABLE_PROG_PTR_REG_1;
} CSL_PdspRegs;

/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* PDSP_CONTROL_REG */

#define CSL_PDSP_PDSP_CONTROL_REG_SOFT_RST_N_MASK (0x00000001u)
#define CSL_PDSP_PDSP_CONTROL_REG_SOFT_RST_N_SHIFT (0x00000000u)
#define CSL_PDSP_PDSP_CONTROL_REG_SOFT_RST_N_RESETVAL (0x00000001u)

#define CSL_PDSP_PDSP_CONTROL_REG_PDSP_ENABLE_MASK (0x00000002u)
#define CSL_PDSP_PDSP_CONTROL_REG_PDSP_ENABLE_SHIFT (0x00000001u)
#define CSL_PDSP_PDSP_CONTROL_REG_PDSP_ENABLE_RESETVAL (0x00000000u)

#define CSL_PDSP_PDSP_CONTROL_REG_PDSP_SLEEPING_MASK (0x00000004u)
#define CSL_PDSP_PDSP_CONTROL_REG_PDSP_SLEEPING_SHIFT (0x00000002u)
#define CSL_PDSP_PDSP_CONTROL_REG_PDSP_SLEEPING_RESETVAL (0x00000000u)

#define CSL_PDSP_PDSP_CONTROL_REG_COUNTER_ENABLE_MASK (0x00000008u)
#define CSL_PDSP_PDSP_CONTROL_REG_COUNTER_ENABLE_SHIFT (0x00000003u)
#define CSL_PDSP_PDSP_CONTROL_REG_COUNTER_ENABLE_RESETVAL (0x00000000u)

#define CSL_PDSP_PDSP_CONTROL_REG_SINGLE_STEP_MASK (0x00000100u)
#define CSL_PDSP_PDSP_CONTROL_REG_SINGLE_STEP_SHIFT (0x00000008u)
#define CSL_PDSP_PDSP_CONTROL_REG_SINGLE_STEP_RESETVAL (0x00000000u)

#define CSL_PDSP_PDSP_CONTROL_REG_BIG_ENDIAN_MASK (0x00004000u)
#define CSL_PDSP_PDSP_CONTROL_REG_BIG_ENDIAN_SHIFT (0x0000000Eu)
#define CSL_PDSP_PDSP_CONTROL_REG_BIG_ENDIAN_RESETVAL (0x00000000u)

#define CSL_PDSP_PDSP_CONTROL_REG_PDSP_STATE_MASK (0x00008000u)
#define CSL_PDSP_PDSP_CONTROL_REG_PDSP_STATE_SHIFT (0x0000000Fu)
#define CSL_PDSP_PDSP_CONTROL_REG_PDSP_STATE_RESETVAL (0x00000000u)

#define CSL_PDSP_PDSP_CONTROL_REG_PCOUNTER_RST_VAL_MASK (0xFFFF0000u)
#define CSL_PDSP_PDSP_CONTROL_REG_PCOUNTER_RST_VAL_SHIFT (0x00000010u)
#define CSL_PDSP_PDSP_CONTROL_REG_PCOUNTER_RST_VAL_RESETVAL (0x00000000u)

#define CSL_PDSP_PDSP_CONTROL_REG_RESETVAL (0x00000001u)

/* PDSP_STATUS_REG */

#define CSL_PDSP_PDSP_STATUS_REG_PCOUNTER_MASK (0x0000FFFFu)
#define CSL_PDSP_PDSP_STATUS_REG_PCOUNTER_SHIFT (0x00000000u)
#define CSL_PDSP_PDSP_STATUS_REG_PCOUNTER_RESETVAL (0x00000000u)

#define CSL_PDSP_PDSP_STATUS_REG_RESETVAL (0x00000000u)

/* PDSP_WAKEUP_ENABLE_REG */

#define CSL_PDSP_PDSP_WAKEUP_ENABLE_REG_BITWISE_ENABLES_MASK (0xFFFFFFFFu)
#define CSL_PDSP_PDSP_WAKEUP_ENABLE_REG_BITWISE_ENABLES_SHIFT (0x00000000u)
#define CSL_PDSP_PDSP_WAKEUP_ENABLE_REG_BITWISE_ENABLES_RESETVAL (0x00000000u)

#define CSL_PDSP_PDSP_WAKEUP_ENABLE_REG_RESETVAL (0x00000000u)

/* PDSP_CYCLE_COUNT_REG */

#define CSL_PDSP_PDSP_CYCLE_COUNT_REG_CYCLECOUNT_MASK (0xFFFFFFFFu)
#define CSL_PDSP_PDSP_CYCLE_COUNT_REG_CYCLECOUNT_SHIFT (0x00000000u)
#define CSL_PDSP_PDSP_CYCLE_COUNT_REG_CYCLECOUNT_RESETVAL (0x00000000u)

#define CSL_PDSP_PDSP_CYCLE_COUNT_REG_RESETVAL (0x00000000u)

/* PDSP_STALL_COUNT_REG */

#define CSL_PDSP_PDSP_STALL_COUNT_REG_STALLCOUNT_MASK (0xFFFFFFFFu)
#define CSL_PDSP_PDSP_STALL_COUNT_REG_STALLCOUNT_SHIFT (0x00000000u)
#define CSL_PDSP_PDSP_STALL_COUNT_REG_STALLCOUNT_RESETVAL (0x00000000u)

#define CSL_PDSP_PDSP_STALL_COUNT_REG_RESETVAL (0x00000000u)

/* PDSP_CONSTANT_TABLE_BLOCK_INDEX_REG_0 */

#define CSL_PDSP_PDSP_CONSTANT_TABLE_BLOCK_INDEX_REG_0_C24_BLK_INDEX_MASK (0x0000000Fu)
#define CSL_PDSP_PDSP_CONSTANT_TABLE_BLOCK_INDEX_REG_0_C24_BLK_INDEX_SHIFT (0x00000000u)
#define CSL_PDSP_PDSP_CONSTANT_TABLE_BLOCK_INDEX_REG_0_C24_BLK_INDEX_RESETVAL (0x00000000u)

#define CSL_PDSP_PDSP_CONSTANT_TABLE_BLOCK_INDEX_REG_0_C25_BLK_INDEX_MASK (0x000F0000u)
#define CSL_PDSP_PDSP_CONSTANT_TABLE_BLOCK_INDEX_REG_0_C25_BLK_INDEX_SHIFT (0x00000010u)
#define CSL_PDSP_PDSP_CONSTANT_TABLE_BLOCK_INDEX_REG_0_C25_BLK_INDEX_RESETVAL (0x00000000u)

#define CSL_PDSP_PDSP_CONSTANT_TABLE_BLOCK_INDEX_REG_0_RESETVAL (0x00000000u)

/* PDSP_CONSTANT_TABLE_BLOCK_INDEX_REG_1 */

#define CSL_PDSP_PDSP_CONSTANT_TABLE_BLOCK_INDEX_REG_1_C26_BLK_INDEX_MASK (0x0000000Fu)
#define CSL_PDSP_PDSP_CONSTANT_TABLE_BLOCK_INDEX_REG_1_C26_BLK_INDEX_SHIFT (0x00000000u)
#define CSL_PDSP_PDSP_CONSTANT_TABLE_BLOCK_INDEX_REG_1_C26_BLK_INDEX_RESETVAL (0x00000000u)

#define CSL_PDSP_PDSP_CONSTANT_TABLE_BLOCK_INDEX_REG_1_C27_BLK_INDEX_MASK (0x000F0000u)
#define CSL_PDSP_PDSP_CONSTANT_TABLE_BLOCK_INDEX_REG_1_C27_BLK_INDEX_SHIFT (0x00000010u)
#define CSL_PDSP_PDSP_CONSTANT_TABLE_BLOCK_INDEX_REG_1_C27_BLK_INDEX_RESETVAL (0x00000000u)

#define CSL_PDSP_PDSP_CONSTANT_TABLE_BLOCK_INDEX_REG_1_RESETVAL (0x00000000u)

/* PDSP_CONSTANT_TABLE_PROG_PTR_REG_0 */

#define CSL_PDSP_PDSP_CONSTANT_TABLE_PROG_PTR_REG_0_C28_POINTER_MASK (0x0000FFFFu)
#define CSL_PDSP_PDSP_CONSTANT_TABLE_PROG_PTR_REG_0_C28_POINTER_SHIFT (0x00000000u)
#define CSL_PDSP_PDSP_CONSTANT_TABLE_PROG_PTR_REG_0_C28_POINTER_RESETVAL (0x00000000u)

#define CSL_PDSP_PDSP_CONSTANT_TABLE_PROG_PTR_REG_0_C29_POINTER_MASK (0xFFFF0000u)
#define CSL_PDSP_PDSP_CONSTANT_TABLE_PROG_PTR_REG_0_C29_POINTER_SHIFT (0x00000010u)
#define CSL_PDSP_PDSP_CONSTANT_TABLE_PROG_PTR_REG_0_C29_POINTER_RESETVAL (0x00000000u)

#define CSL_PDSP_PDSP_CONSTANT_TABLE_PROG_PTR_REG_0_RESETVAL (0x00000000u)

/* PDSP_CONSTANT_TABLE_PROG_PTR_REG_1 */

#define CSL_PDSP_PDSP_CONSTANT_TABLE_PROG_PTR_REG_1_C30_POINTER_MASK (0x0000FFFFu)
#define CSL_PDSP_PDSP_CONSTANT_TABLE_PROG_PTR_REG_1_C30_POINTER_SHIFT (0x00000000u)
#define CSL_PDSP_PDSP_CONSTANT_TABLE_PROG_PTR_REG_1_C30_POINTER_RESETVAL (0x00000000u)

#define CSL_PDSP_PDSP_CONSTANT_TABLE_PROG_PTR_REG_1_C31_POINTER_MASK (0xFFFF0000u)
#define CSL_PDSP_PDSP_CONSTANT_TABLE_PROG_PTR_REG_1_C31_POINTER_SHIFT (0x00000010u)
#define CSL_PDSP_PDSP_CONSTANT_TABLE_PROG_PTR_REG_1_C31_POINTER_RESETVAL (0x00000000u)

#define CSL_PDSP_PDSP_CONSTANT_TABLE_PROG_PTR_REG_1_RESETVAL (0x00000000u)

#endif
