/*  ===========================================================================
 *  Copyright (c) Texas Instruments Incorporated 2011
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/

/** ============================================================================
 *   @file  cslr_emif16.h
 *
 *   @path  $(CSLPATH)\inc
 *
 *   @desc  This file contains the Register Desciptions for EMIF16
 *
 */
#ifndef _CSLR_EMIF16_H_
#define _CSLR_EMIF16_H_

#include <ti/csl/cslr.h>

#include <ti/csl/tistdtypes.h>


/* Minimum unit = 1 byte */

/**************************************************************************\
* Register Overlay Structure
\**************************************************************************/
typedef struct  {
    volatile Uint32 RCSR;
    volatile Uint32 AWCCR;
    volatile Uint8 RSVD0[8];
    volatile Uint32 A0CR;
    volatile Uint32 A1CR;
    volatile Uint32 A2CR;
    volatile Uint32 A3CR;
    volatile Uint8 RSVD1[32];
    volatile Uint32 IRR;
    volatile Uint32 IMR;
    volatile Uint32 IMSR;
    volatile Uint32 IMCR;
    volatile Uint32 IOCR;
    volatile Uint32 IOSR;
    volatile Uint8 RSVD2[8];
    volatile Uint32 NANDFCTL;
    volatile Uint32 NANDFSR;
    volatile Uint32 PMCR;
    volatile Uint8 RSVD3[4];
    volatile Uint32 NFECCCE0;
    volatile Uint32 NFECCCE1;
    volatile Uint32 NFECCCE2;
    volatile Uint32 NFECCCE3;
    volatile Uint8 RSVD4[4];
    volatile Uint32 IODFTEXECNT;
    volatile Uint32 IODFTGBLCTRL;
    volatile Uint8 RSVD5[4];
    volatile Uint32 IODFTTLAMISR;
    volatile Uint32 IODFTTLDMISR;
    volatile Uint32 IODFTTLDCMISR;
    volatile Uint8 RSVD6[20];
    volatile Uint32 MODRELNUM;
    volatile Uint8 RSVD7[8];
    volatile Uint32 NANDF4BECCLR;
    volatile Uint32 NANDF4BECC1R;
    volatile Uint32 NANDF4BECC2R;
    volatile Uint32 NANDF4BECC3R;
    volatile Uint32 NANDF4BECC4R;
    volatile Uint32 NANDFEA1R;
    volatile Uint32 NANDFEA2R;
    volatile Uint32 NANDFEV1R;
    volatile Uint32 NANDFEV2R;
} CSL_Emif16Regs;

/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* RCSR */

#define CSL_EMIF16_RCSR_BE_MASK          (0x80000000u)
#define CSL_EMIF16_RCSR_BE_SHIFT         (0x0000001Fu)
#define CSL_EMIF16_RCSR_BE_RESETVAL      (0x00000000u)

#define CSL_EMIF16_RCSR_FR_MASK          (0x40000000u)
#define CSL_EMIF16_RCSR_FR_SHIFT         (0x0000001Eu)
#define CSL_EMIF16_RCSR_FR_RESETVAL      (0x00000000u)

#define CSL_EMIF16_RCSR_MODID_MASK       (0x3FFF0000u)
#define CSL_EMIF16_RCSR_MODID_SHIFT      (0x00000010u)
#define CSL_EMIF16_RCSR_MODID_RESETVAL   (0x00000000u)

#define CSL_EMIF16_RCSR_MAJREV_MASK      (0x0000FF00u)
#define CSL_EMIF16_RCSR_MAJREV_SHIFT     (0x00000008u)
#define CSL_EMIF16_RCSR_MAJREV_RESETVAL  (0x00000002u)

#define CSL_EMIF16_RCSR_MINREV_MASK      (0x000000FFu)
#define CSL_EMIF16_RCSR_MINREV_SHIFT     (0x00000000u)
#define CSL_EMIF16_RCSR_MINREV_RESETVAL  (0x00000005u)

#define CSL_EMIF16_RCSR_RESETVAL         (0x00000205u)

/* AWCCR */

#define CSL_EMIF16_AWCCR_WP3_MASK        (0x80000000u)
#define CSL_EMIF16_AWCCR_WP3_SHIFT       (0x0000001Fu)
#define CSL_EMIF16_AWCCR_WP3_RESETVAL    (0x00000001u)
/*----wp3 Tokens----*/
#define CSL_EMIF16_AWCCR_WP3_WAITLOW     (0x00000000u)
#define CSL_EMIF16_AWCCR_WP3_WAITHIGH    (0x00000001u)

#define CSL_EMIF16_AWCCR_WP2_MASK        (0x40000000u)
#define CSL_EMIF16_AWCCR_WP2_SHIFT       (0x0000001Eu)
#define CSL_EMIF16_AWCCR_WP2_RESETVAL    (0x00000001u)
/*----wp2 Tokens----*/
#define CSL_EMIF16_AWCCR_WP2_WAITLOW     (0x00000000u)
#define CSL_EMIF16_AWCCR_WP2_WAITHIGH    (0x00000001u)

#define CSL_EMIF16_AWCCR_WP1_MASK        (0x20000000u)
#define CSL_EMIF16_AWCCR_WP1_SHIFT       (0x0000001Du)
#define CSL_EMIF16_AWCCR_WP1_RESETVAL    (0x00000001u)
/*----wp1 Tokens----*/
#define CSL_EMIF16_AWCCR_WP1_WAITLOW     (0x00000000u)
#define CSL_EMIF16_AWCCR_WP1_WAITHIGH    (0x00000001u)

#define CSL_EMIF16_AWCCR_WP0_MASK        (0x10000000u)
#define CSL_EMIF16_AWCCR_WP0_SHIFT       (0x0000001Cu)
#define CSL_EMIF16_AWCCR_WP0_RESETVAL    (0x00000001u)
/*----wp0 Tokens----*/
#define CSL_EMIF16_AWCCR_WP0_WAITLOW     (0x00000000u)
#define CSL_EMIF16_AWCCR_WP0_WAITHIGH    (0x00000001u)


#define CSL_EMIF16_AWCCR_CE3WAIT_MASK    (0x00C00000u)
#define CSL_EMIF16_AWCCR_CE3WAIT_SHIFT   (0x00000016u)
#define CSL_EMIF16_AWCCR_CE3WAIT_RESETVAL (0x00000000u)
/*----ce3wait Tokens----*/
#define CSL_EMIF16_AWCCR_CE3WAIT_WAIT0   (0x00000000u)

#define CSL_EMIF16_AWCCR_CE2WAIT_MASK    (0x00300000u)
#define CSL_EMIF16_AWCCR_CE2WAIT_SHIFT   (0x00000014u)
#define CSL_EMIF16_AWCCR_CE2WAIT_RESETVAL (0x00000000u)
/*----ce2wait Tokens----*/
#define CSL_EMIF16_AWCCR_CE2WAIT_WAIT0   (0x00000000u)

#define CSL_EMIF16_AWCCR_CE1WAIT_MASK    (0x000C0000u)
#define CSL_EMIF16_AWCCR_CE1WAIT_SHIFT   (0x00000012u)
#define CSL_EMIF16_AWCCR_CE1WAIT_RESETVAL (0x00000000u)
/*----ce1wait Tokens----*/
#define CSL_EMIF16_AWCCR_CE1WAIT_WAIT0   (0x00000000u)

#define CSL_EMIF16_AWCCR_CE0WAIT_MASK    (0x00030000u)
#define CSL_EMIF16_AWCCR_CE0WAIT_SHIFT   (0x00000010u)
#define CSL_EMIF16_AWCCR_CE0WAIT_RESETVAL (0x00000000u)
/*----ce0wait Tokens----*/
#define CSL_EMIF16_AWCCR_CE0WAIT_WAIT0   (0x00000000u)


#define CSL_EMIF16_AWCCR_MAXEXTWAIT_MASK (0x000000FFu)
#define CSL_EMIF16_AWCCR_MAXEXTWAIT_SHIFT (0x00000000u)
#define CSL_EMIF16_AWCCR_MAXEXTWAIT_RESETVAL (0x00000080u)

#define CSL_EMIF16_AWCCR_RESETVAL        (0xF0000080u)

/* A0CR */

#define CSL_EMIF16_A0CR_SS_MASK          (0x80000000u)
#define CSL_EMIF16_A0CR_SS_SHIFT         (0x0000001Fu)
#define CSL_EMIF16_A0CR_SS_RESETVAL      (0x00000000u)
/*----ss Tokens----*/
#define CSL_EMIF16_A0CR_SS_DISABLE       (0x00000000u)
#define CSL_EMIF16_A0CR_SS_ENABLE        (0x00000001u)

#define CSL_EMIF16_A0CR_EW_MASK          (0x40000000u)
#define CSL_EMIF16_A0CR_EW_SHIFT         (0x0000001Eu)
#define CSL_EMIF16_A0CR_EW_RESETVAL      (0x00000000u)
/*----ew Tokens----*/
#define CSL_EMIF16_A0CR_EW_DISABLE       (0x00000000u)
#define CSL_EMIF16_A0CR_EW_ENABLE        (0x00000001u)

#define CSL_EMIF16_A0CR_WSETUP_MASK      (0x3C000000u)
#define CSL_EMIF16_A0CR_WSETUP_SHIFT     (0x0000001Au)
#define CSL_EMIF16_A0CR_WSETUP_RESETVAL  (0x0000000Fu)

#define CSL_EMIF16_A0CR_WSTROBE_MASK     (0x03F00000u)
#define CSL_EMIF16_A0CR_WSTROBE_SHIFT    (0x00000014u)
#define CSL_EMIF16_A0CR_WSTROBE_RESETVAL (0x0000003Fu)

#define CSL_EMIF16_A0CR_WHOLD_MASK       (0x000E0000u)
#define CSL_EMIF16_A0CR_WHOLD_SHIFT      (0x00000011u)
#define CSL_EMIF16_A0CR_WHOLD_RESETVAL   (0x00000007u)

#define CSL_EMIF16_A0CR_RSETUP_MASK      (0x0001E000u)
#define CSL_EMIF16_A0CR_RSETUP_SHIFT     (0x0000000Du)
#define CSL_EMIF16_A0CR_RSETUP_RESETVAL  (0x0000000Fu)

#define CSL_EMIF16_A0CR_RSTROBE_MASK     (0x00001F80u)
#define CSL_EMIF16_A0CR_RSTROBE_SHIFT    (0x00000007u)
#define CSL_EMIF16_A0CR_RSTROBE_RESETVAL (0x0000003Fu)

#define CSL_EMIF16_A0CR_RHOLD_MASK       (0x00000070u)
#define CSL_EMIF16_A0CR_RHOLD_SHIFT      (0x00000004u)
#define CSL_EMIF16_A0CR_RHOLD_RESETVAL   (0x00000007u)

#define CSL_EMIF16_A0CR_TA_MASK          (0x0000000Cu)
#define CSL_EMIF16_A0CR_TA_SHIFT         (0x00000002u)
#define CSL_EMIF16_A0CR_TA_RESETVAL      (0x00000003u)

#define CSL_EMIF16_A0CR_ASIZE_MASK       (0x00000003u)
#define CSL_EMIF16_A0CR_ASIZE_SHIFT      (0x00000000u)
#define CSL_EMIF16_A0CR_ASIZE_RESETVAL   (0x00000000u)
/*----asize Tokens----*/
#define CSL_EMIF16_A0CR_ASIZE_8BITS      (0x00000000u)
#define CSL_EMIF16_A0CR_ASIZE_16BITS     (0x00000001u)
#define CSL_EMIF16_A0CR_ASIZE_32BITS     (0x00000002u)

#define CSL_EMIF16_A0CR_RESETVAL         (0x3FFFFFFCu)

/* A1CR */

#define CSL_EMIF16_A1CR_SS_MASK          (0x80000000u)
#define CSL_EMIF16_A1CR_SS_SHIFT         (0x0000001Fu)
#define CSL_EMIF16_A1CR_SS_RESETVAL      (0x00000000u)
/*----ss Tokens----*/
#define CSL_EMIF16_A1CR_SS_DISABLE       (0x00000000u)
#define CSL_EMIF16_A1CR_SS_ENABLE        (0x00000001u)

#define CSL_EMIF16_A1CR_EW_MASK          (0x40000000u)
#define CSL_EMIF16_A1CR_EW_SHIFT         (0x0000001Eu)
#define CSL_EMIF16_A1CR_EW_RESETVAL      (0x00000000u)
/*----ew Tokens----*/
#define CSL_EMIF16_A1CR_EW_DISABLE       (0x00000000u)
#define CSL_EMIF16_A1CR_EW_ENABLE        (0x00000001u)

#define CSL_EMIF16_A1CR_WSETUP_MASK      (0x3C000000u)
#define CSL_EMIF16_A1CR_WSETUP_SHIFT     (0x0000001Au)
#define CSL_EMIF16_A1CR_WSETUP_RESETVAL  (0x0000000Fu)

#define CSL_EMIF16_A1CR_WSTROBE_MASK     (0x03F00000u)
#define CSL_EMIF16_A1CR_WSTROBE_SHIFT    (0x00000014u)
#define CSL_EMIF16_A1CR_WSTROBE_RESETVAL (0x0000003Fu)

#define CSL_EMIF16_A1CR_WHOLD_MASK       (0x000E0000u)
#define CSL_EMIF16_A1CR_WHOLD_SHIFT      (0x00000011u)
#define CSL_EMIF16_A1CR_WHOLD_RESETVAL   (0x00000007u)

#define CSL_EMIF16_A1CR_RSETUP_MASK      (0x0001E000u)
#define CSL_EMIF16_A1CR_RSETUP_SHIFT     (0x0000000Du)
#define CSL_EMIF16_A1CR_RSETUP_RESETVAL  (0x0000000Fu)

#define CSL_EMIF16_A1CR_RSTROBE_MASK     (0x00001F80u)
#define CSL_EMIF16_A1CR_RSTROBE_SHIFT    (0x00000007u)
#define CSL_EMIF16_A1CR_RSTROBE_RESETVAL (0x0000003Fu)

#define CSL_EMIF16_A1CR_RHOLD_MASK       (0x00000070u)
#define CSL_EMIF16_A1CR_RHOLD_SHIFT      (0x00000004u)
#define CSL_EMIF16_A1CR_RHOLD_RESETVAL   (0x00000007u)

#define CSL_EMIF16_A1CR_TA_MASK          (0x0000000Cu)
#define CSL_EMIF16_A1CR_TA_SHIFT         (0x00000002u)
#define CSL_EMIF16_A1CR_TA_RESETVAL      (0x00000003u)

#define CSL_EMIF16_A1CR_ASIZE_MASK       (0x00000003u)
#define CSL_EMIF16_A1CR_ASIZE_SHIFT      (0x00000000u)
#define CSL_EMIF16_A1CR_ASIZE_RESETVAL   (0x00000000u)
/*----asize Tokens----*/
#define CSL_EMIF16_A1CR_ASIZE_8BITS      (0x00000000u)
#define CSL_EMIF16_A1CR_ASIZE_16BITS     (0x00000001u)
#define CSL_EMIF16_A1CR_ASIZE_32BITS     (0x00000002u)

#define CSL_EMIF16_A1CR_RESETVAL         (0x3FFFFFFCu)

/* A2CR */

#define CSL_EMIF16_A2CR_SS_MASK          (0x80000000u)
#define CSL_EMIF16_A2CR_SS_SHIFT         (0x0000001Fu)
#define CSL_EMIF16_A2CR_SS_RESETVAL      (0x00000000u)
/*----ss Tokens----*/
#define CSL_EMIF16_A2CR_SS_DISABLE       (0x00000000u)
#define CSL_EMIF16_A2CR_SS_ENABLE        (0x00000001u)

#define CSL_EMIF16_A2CR_EW_MASK          (0x40000000u)
#define CSL_EMIF16_A2CR_EW_SHIFT         (0x0000001Eu)
#define CSL_EMIF16_A2CR_EW_RESETVAL      (0x00000000u)
/*----ew Tokens----*/
#define CSL_EMIF16_A2CR_EW_DISABLE       (0x00000000u)
#define CSL_EMIF16_A2CR_EW_ENABLE        (0x00000001u)

#define CSL_EMIF16_A2CR_WSETUP_MASK      (0x3C000000u)
#define CSL_EMIF16_A2CR_WSETUP_SHIFT     (0x0000001Au)
#define CSL_EMIF16_A2CR_WSETUP_RESETVAL  (0x0000000Fu)

#define CSL_EMIF16_A2CR_WSTROBE_MASK     (0x03F00000u)
#define CSL_EMIF16_A2CR_WSTROBE_SHIFT    (0x00000014u)
#define CSL_EMIF16_A2CR_WSTROBE_RESETVAL (0x0000003Fu)

#define CSL_EMIF16_A2CR_WHOLD_MASK       (0x000E0000u)
#define CSL_EMIF16_A2CR_WHOLD_SHIFT      (0x00000011u)
#define CSL_EMIF16_A2CR_WHOLD_RESETVAL   (0x00000007u)

#define CSL_EMIF16_A2CR_RSETUP_MASK      (0x0001E000u)
#define CSL_EMIF16_A2CR_RSETUP_SHIFT     (0x0000000Du)
#define CSL_EMIF16_A2CR_RSETUP_RESETVAL  (0x0000000Fu)

#define CSL_EMIF16_A2CR_RSTROBE_MASK     (0x00001F80u)
#define CSL_EMIF16_A2CR_RSTROBE_SHIFT    (0x00000007u)
#define CSL_EMIF16_A2CR_RSTROBE_RESETVAL (0x0000003Fu)

#define CSL_EMIF16_A2CR_RHOLD_MASK       (0x00000070u)
#define CSL_EMIF16_A2CR_RHOLD_SHIFT      (0x00000004u)
#define CSL_EMIF16_A2CR_RHOLD_RESETVAL   (0x00000007u)

#define CSL_EMIF16_A2CR_TA_MASK          (0x0000000Cu)
#define CSL_EMIF16_A2CR_TA_SHIFT         (0x00000002u)
#define CSL_EMIF16_A2CR_TA_RESETVAL      (0x00000003u)

#define CSL_EMIF16_A2CR_ASIZE_MASK       (0x00000003u)
#define CSL_EMIF16_A2CR_ASIZE_SHIFT      (0x00000000u)
#define CSL_EMIF16_A2CR_ASIZE_RESETVAL   (0x00000000u)
/*----asize Tokens----*/
#define CSL_EMIF16_A2CR_ASIZE_8BITS      (0x00000000u)
#define CSL_EMIF16_A2CR_ASIZE_16BITS     (0x00000001u)
#define CSL_EMIF16_A2CR_ASIZE_32BITS     (0x00000002u)

#define CSL_EMIF16_A2CR_RESETVAL         (0x3FFFFFFCu)

/* A3CR */

#define CSL_EMIF16_A3CR_SS_MASK          (0x80000000u)
#define CSL_EMIF16_A3CR_SS_SHIFT         (0x0000001Fu)
#define CSL_EMIF16_A3CR_SS_RESETVAL      (0x00000000u)
/*----ss Tokens----*/
#define CSL_EMIF16_A3CR_SS_DISABLE       (0x00000000u)
#define CSL_EMIF16_A3CR_SS_ENABLE        (0x00000001u)

#define CSL_EMIF16_A3CR_EW_MASK          (0x40000000u)
#define CSL_EMIF16_A3CR_EW_SHIFT         (0x0000001Eu)
#define CSL_EMIF16_A3CR_EW_RESETVAL      (0x00000000u)
/*----ew Tokens----*/
#define CSL_EMIF16_A3CR_EW_DISABLE       (0x00000000u)
#define CSL_EMIF16_A3CR_EW_ENABLE        (0x00000001u)

#define CSL_EMIF16_A3CR_WSETUP_MASK      (0x3C000000u)
#define CSL_EMIF16_A3CR_WSETUP_SHIFT     (0x0000001Au)
#define CSL_EMIF16_A3CR_WSETUP_RESETVAL  (0x0000000Fu)

#define CSL_EMIF16_A3CR_WSTROBE_MASK     (0x03F00000u)
#define CSL_EMIF16_A3CR_WSTROBE_SHIFT    (0x00000014u)
#define CSL_EMIF16_A3CR_WSTROBE_RESETVAL (0x0000003Fu)

#define CSL_EMIF16_A3CR_WHOLD_MASK       (0x000E0000u)
#define CSL_EMIF16_A3CR_WHOLD_SHIFT      (0x00000011u)
#define CSL_EMIF16_A3CR_WHOLD_RESETVAL   (0x00000007u)

#define CSL_EMIF16_A3CR_RSETUP_MASK      (0x0001E000u)
#define CSL_EMIF16_A3CR_RSETUP_SHIFT     (0x0000000Du)
#define CSL_EMIF16_A3CR_RSETUP_RESETVAL  (0x0000000Fu)

#define CSL_EMIF16_A3CR_RSTROBE_MASK     (0x00001F80u)
#define CSL_EMIF16_A3CR_RSTROBE_SHIFT    (0x00000007u)
#define CSL_EMIF16_A3CR_RSTROBE_RESETVAL (0x0000003Fu)

#define CSL_EMIF16_A3CR_RHOLD_MASK       (0x00000070u)
#define CSL_EMIF16_A3CR_RHOLD_SHIFT      (0x00000004u)
#define CSL_EMIF16_A3CR_RHOLD_RESETVAL   (0x00000007u)

#define CSL_EMIF16_A3CR_TA_MASK          (0x0000000Cu)
#define CSL_EMIF16_A3CR_TA_SHIFT         (0x00000002u)
#define CSL_EMIF16_A3CR_TA_RESETVAL      (0x00000003u)

#define CSL_EMIF16_A3CR_ASIZE_MASK       (0x00000003u)
#define CSL_EMIF16_A3CR_ASIZE_SHIFT      (0x00000000u)
#define CSL_EMIF16_A3CR_ASIZE_RESETVAL   (0x00000000u)
/*----asize Tokens----*/
#define CSL_EMIF16_A3CR_ASIZE_8BITS      (0x00000000u)
#define CSL_EMIF16_A3CR_ASIZE_16BITS     (0x00000001u)
#define CSL_EMIF16_A3CR_ASIZE_32BITS     (0x00000002u)

#define CSL_EMIF16_A3CR_RESETVAL         (0x3FFFFFFCu)

/* IRR */


#define CSL_EMIF16_IRR_WR_MASK           (0x0000003Cu)
#define CSL_EMIF16_IRR_WR_SHIFT          (0x00000002u)
#define CSL_EMIF16_IRR_WR_RESETVAL       (0x00000000u)
/*----wr Tokens----*/
#define CSL_EMIF16_IRR_WR_NOACTION       (0x00000000u)
#define CSL_EMIF16_IRR_WR_CLEARBIT       (0x00000001u)

#define CSL_EMIF16_IRR_LT_MASK           (0x00000002u)
#define CSL_EMIF16_IRR_LT_SHIFT          (0x00000001u)
#define CSL_EMIF16_IRR_LT_RESETVAL       (0x00000000u)
/*----lt Tokens----*/
#define CSL_EMIF16_IRR_LT_NOACTION       (0x00000000u)
#define CSL_EMIF16_IRR_LT_CLEARBIT       (0x00000001u)

#define CSL_EMIF16_IRR_AT_MASK           (0x00000001u)
#define CSL_EMIF16_IRR_AT_SHIFT          (0x00000000u)
#define CSL_EMIF16_IRR_AT_RESETVAL       (0x00000000u)
/*----at Tokens----*/
#define CSL_EMIF16_IRR_AT_NOACTION       (0x00000000u)
#define CSL_EMIF16_IRR_AT_CLEARBIT       (0x00000001u)

#define CSL_EMIF16_IRR_RESETVAL          (0x00000000u)

/* IMR */


#define CSL_EMIF16_IMR_WRM_MASK          (0x0000003Cu)
#define CSL_EMIF16_IMR_WRM_SHIFT         (0x00000002u)
#define CSL_EMIF16_IMR_WRM_RESETVAL      (0x00000000u)
/*----wrm Tokens----*/
#define CSL_EMIF16_IMR_WRM_NOACTION      (0x00000000u)
#define CSL_EMIF16_IMR_WRM_CLEARBIT      (0x00000001u)

#define CSL_EMIF16_IMR_LTM_MASK          (0x00000002u)
#define CSL_EMIF16_IMR_LTM_SHIFT         (0x00000001u)
#define CSL_EMIF16_IMR_LTM_RESETVAL      (0x00000000u)
/*----ltm Tokens----*/
#define CSL_EMIF16_IMR_LTM_NOACTION      (0x00000000u)
#define CSL_EMIF16_IMR_LTM_CLEARBIT      (0x00000001u)

#define CSL_EMIF16_IMR_ATM_MASK          (0x00000001u)
#define CSL_EMIF16_IMR_ATM_SHIFT         (0x00000000u)
#define CSL_EMIF16_IMR_ATM_RESETVAL      (0x00000000u)
/*----atm Tokens----*/
#define CSL_EMIF16_IMR_ATM_NOACTION      (0x00000000u)
#define CSL_EMIF16_IMR_ATM_CLEARBIT      (0x00000001u)

#define CSL_EMIF16_IMR_RESETVAL          (0x00000000u)

/* IMSR */


#define CSL_EMIF16_IMSR_WRMSET_MASK      (0x0000003Cu)
#define CSL_EMIF16_IMSR_WRMSET_SHIFT     (0x00000002u)
#define CSL_EMIF16_IMSR_WRMSET_RESETVAL  (0x00000000u)
/*----wrmset Tokens----*/
#define CSL_EMIF16_IMSR_WRMSET_NOACTION  (0x00000000u)
#define CSL_EMIF16_IMSR_WRMSET_ENABLE    (0x00000001u)

#define CSL_EMIF16_IMSR_LTMSET_MASK      (0x00000002u)
#define CSL_EMIF16_IMSR_LTMSET_SHIFT     (0x00000001u)
#define CSL_EMIF16_IMSR_LTMSET_RESETVAL  (0x00000000u)
/*----ltmset Tokens----*/
#define CSL_EMIF16_IMSR_LTMSET_NOACTION  (0x00000000u)
#define CSL_EMIF16_IMSR_LTMSET_ENABLE    (0x00000001u)

#define CSL_EMIF16_IMSR_ATMSET_MASK      (0x00000001u)
#define CSL_EMIF16_IMSR_ATMSET_SHIFT     (0x00000000u)
#define CSL_EMIF16_IMSR_ATMSET_RESETVAL  (0x00000000u)
/*----atmset Tokens----*/
#define CSL_EMIF16_IMSR_ATMSET_NOACTION  (0x00000000u)
#define CSL_EMIF16_IMSR_ATMSET_ENABLE    (0x00000001u)

#define CSL_EMIF16_IMSR_RESETVAL         (0x00000000u)

/* IMCR */


#define CSL_EMIF16_IMCR_WRMCLR_MASK      (0x0000003Cu)
#define CSL_EMIF16_IMCR_WRMCLR_SHIFT     (0x00000002u)
#define CSL_EMIF16_IMCR_WRMCLR_RESETVAL  (0x00000000u)
/*----wrmclr Tokens----*/
#define CSL_EMIF16_IMCR_WRMCLR_NOACTION  (0x00000000u)
#define CSL_EMIF16_IMCR_WRMCLR_DISABLE   (0x00000001u)

#define CSL_EMIF16_IMCR_LTMCLR_MASK      (0x00000002u)
#define CSL_EMIF16_IMCR_LTMCLR_SHIFT     (0x00000001u)
#define CSL_EMIF16_IMCR_LTMCLR_RESETVAL  (0x00000000u)
/*----ltmclr Tokens----*/
#define CSL_EMIF16_IMCR_LTMCLR_NOACTION  (0x00000000u)
#define CSL_EMIF16_IMCR_LTMCLR_DISABLE   (0x00000001u)

#define CSL_EMIF16_IMCR_ATMCLR_MASK      (0x00000001u)
#define CSL_EMIF16_IMCR_ATMCLR_SHIFT     (0x00000000u)
#define CSL_EMIF16_IMCR_ATMCLR_RESETVAL  (0x00000000u)
/*----atmclr Tokens----*/
#define CSL_EMIF16_IMCR_ATMCLR_NOACTION  (0x00000000u)
#define CSL_EMIF16_IMCR_ATMCLR_DISABLE   (0x00000001u)

#define CSL_EMIF16_IMCR_RESETVAL         (0x00000000u)

/* IOCR */


#define CSL_EMIF16_IOCR_IOCTRL_MASK      (0x0000FFFFu)
#define CSL_EMIF16_IOCR_IOCTRL_SHIFT     (0x00000000u)
#define CSL_EMIF16_IOCR_IOCTRL_RESETVAL  (0x00000000u)

#define CSL_EMIF16_IOCR_RESETVAL         (0x00000000u)

/* IOSR */


#define CSL_EMIF16_IOSR_IOSTAT_MASK      (0x0000000Fu)
#define CSL_EMIF16_IOSR_IOSTAT_SHIFT     (0x00000000u)
#define CSL_EMIF16_IOSR_IOSTAT_RESETVAL  (0x00000000u)

#define CSL_EMIF16_IOSR_RESETVAL         (0x00000000u)

/* NANDFCTL */


#define CSL_EMIF16_NANDFCTL_ADDR_CALC_ST_MASK (0x00002000u)
#define CSL_EMIF16_NANDFCTL_ADDR_CALC_ST_SHIFT (0x0000000Du)
#define CSL_EMIF16_NANDFCTL_ADDR_CALC_ST_RESETVAL (0x00000000u)
/*----addr_calc_st Tokens----*/
#define CSL_EMIF16_NANDFCTL_ADDR_CALC_ST_NOACTION (0x00000000u)
#define CSL_EMIF16_NANDFCTL_ADDR_CALC_ST_STARTCALC (0x00000001u)

#define CSL_EMIF16_NANDFCTL_4BIT_ECC_ST_MASK (0x00001000u)
#define CSL_EMIF16_NANDFCTL_4BIT_ECC_ST_SHIFT (0x0000000Cu)
#define CSL_EMIF16_NANDFCTL_4BIT_ECC_ST_RESETVAL (0x00000000u)
/*----4bit_ecc_st Tokens----*/
#define CSL_EMIF16_NANDFCTL_4BIT_ECC_ST_NOACTION (0x00000000u)
#define CSL_EMIF16_NANDFCTL_4BIT_ECC_ST_STARTCALC (0x00000001u)

#define CSL_EMIF16_NANDFCTL_CE3ECC_MASK  (0x00000800u)
#define CSL_EMIF16_NANDFCTL_CE3ECC_SHIFT (0x0000000Bu)
#define CSL_EMIF16_NANDFCTL_CE3ECC_RESETVAL (0x00000000u)
/*----ce3ecc Tokens----*/
#define CSL_EMIF16_NANDFCTL_CE3ECC_NOACTION (0x00000000u)
#define CSL_EMIF16_NANDFCTL_CE3ECC_STARTCALC (0x00000001u)

#define CSL_EMIF16_NANDFCTL_CE2ECC_MASK  (0x00000400u)
#define CSL_EMIF16_NANDFCTL_CE2ECC_SHIFT (0x0000000Au)
#define CSL_EMIF16_NANDFCTL_CE2ECC_RESETVAL (0x00000000u)
/*----ce2ecc Tokens----*/
#define CSL_EMIF16_NANDFCTL_CE2ECC_NOACTION (0x00000000u)
#define CSL_EMIF16_NANDFCTL_CE2ECC_STARTCALC (0x00000001u)

#define CSL_EMIF16_NANDFCTL_CE1ECC_MASK  (0x00000200u)
#define CSL_EMIF16_NANDFCTL_CE1ECC_SHIFT (0x00000009u)
#define CSL_EMIF16_NANDFCTL_CE1ECC_RESETVAL (0x00000000u)
/*----ce1ecc Tokens----*/
#define CSL_EMIF16_NANDFCTL_CE1ECC_NOACTION (0x00000000u)
#define CSL_EMIF16_NANDFCTL_CE1ECC_STARTCALC (0x00000001u)

#define CSL_EMIF16_NANDFCTL_CE0ECC_MASK  (0x00000100u)
#define CSL_EMIF16_NANDFCTL_CE0ECC_SHIFT (0x00000008u)
#define CSL_EMIF16_NANDFCTL_CE0ECC_RESETVAL (0x00000000u)
/*----ce0ecc Tokens----*/
#define CSL_EMIF16_NANDFCTL_CE0ECC_NOACTION (0x00000000u)
#define CSL_EMIF16_NANDFCTL_CE0ECC_STARTCALC (0x00000001u)


#define CSL_EMIF16_NANDFCTL_4BIT_ECC_SEL_MASK (0x00000030u)
#define CSL_EMIF16_NANDFCTL_4BIT_ECC_SEL_SHIFT (0x00000004u)
#define CSL_EMIF16_NANDFCTL_4BIT_ECC_SEL_RESETVAL (0x00000000u)
/*----4bit_ecc_sel Tokens----*/
#define CSL_EMIF16_NANDFCTL_4BIT_ECC_SEL_SELCE0 (0x00000000u)
#define CSL_EMIF16_NANDFCTL_4BIT_ECC_SEL_SELCE1 (0x00000001u)
#define CSL_EMIF16_NANDFCTL_4BIT_ECC_SEL_SELCE2 (0x00000002u)
#define CSL_EMIF16_NANDFCTL_4BIT_ECC_SEL_SELCE3 (0x00000003u)

#define CSL_EMIF16_NANDFCTL_CE3NAND_MASK (0x00000008u)
#define CSL_EMIF16_NANDFCTL_CE3NAND_SHIFT (0x00000003u)
#define CSL_EMIF16_NANDFCTL_CE3NAND_RESETVAL (0x00000000u)
/*----ce3nand Tokens----*/
#define CSL_EMIF16_NANDFCTL_CE3NAND_DISABLE (0x00000000u)
#define CSL_EMIF16_NANDFCTL_CE3NAND_ENABLE (0x00000001u)

#define CSL_EMIF16_NANDFCTL_CE2NAND_MASK (0x00000004u)
#define CSL_EMIF16_NANDFCTL_CE2NAND_SHIFT (0x00000002u)
#define CSL_EMIF16_NANDFCTL_CE2NAND_RESETVAL (0x00000000u)
/*----ce2nand Tokens----*/
#define CSL_EMIF16_NANDFCTL_CE2NAND_DISABLE (0x00000000u)
#define CSL_EMIF16_NANDFCTL_CE2NAND_ENABLE (0x00000001u)

#define CSL_EMIF16_NANDFCTL_CE1NAND_MASK (0x00000002u)
#define CSL_EMIF16_NANDFCTL_CE1NAND_SHIFT (0x00000001u)
#define CSL_EMIF16_NANDFCTL_CE1NAND_RESETVAL (0x00000000u)
/*----ce1nand Tokens----*/
#define CSL_EMIF16_NANDFCTL_CE1NAND_DISABLE (0x00000000u)
#define CSL_EMIF16_NANDFCTL_CE1NAND_ENABLE (0x00000001u)

#define CSL_EMIF16_NANDFCTL_CE0NAND_MASK (0x00000001u)
#define CSL_EMIF16_NANDFCTL_CE0NAND_SHIFT (0x00000000u)
#define CSL_EMIF16_NANDFCTL_CE0NAND_RESETVAL (0x00000000u)
/*----ce0nand Tokens----*/
#define CSL_EMIF16_NANDFCTL_CE0NAND_DISABLE (0x00000000u)
#define CSL_EMIF16_NANDFCTL_CE0NAND_ENABLE (0x00000001u)

#define CSL_EMIF16_NANDFCTL_RESETVAL     (0x00000000u)

/* NANDFSR */


#define CSL_EMIF16_NANDFSR_ERR_NUM_MASK  (0x00030000u)
#define CSL_EMIF16_NANDFSR_ERR_NUM_SHIFT (0x00000010u)
#define CSL_EMIF16_NANDFSR_ERR_NUM_RESETVAL (0x00000000u)
/*----err_num Tokens----*/
#define CSL_EMIF16_NANDFSR_ERR_NUM_ERROR1 (0x00000000u)
#define CSL_EMIF16_NANDFSR_ERR_NUM_ERROR2 (0x00000001u)
#define CSL_EMIF16_NANDFSR_ERR_NUM_ERROR3 (0x00000002u)
#define CSL_EMIF16_NANDFSR_ERR_NUM_ERROR4 (0x00000003u)


#define CSL_EMIF16_NANDFSR_CORR_STATE_MASK (0x00000F00u)
#define CSL_EMIF16_NANDFSR_CORR_STATE_SHIFT (0x00000008u)
#define CSL_EMIF16_NANDFSR_CORR_STATE_RESETVAL (0x00000000u)
/*----corr_state Tokens----*/
#define CSL_EMIF16_NANDFSR_CORR_STATE_NOERROR (0x00000000u)
#define CSL_EMIF16_NANDFSR_CORR_STATE_NOCORRECT (0x00000001u)
#define CSL_EMIF16_NANDFSR_CORR_STATE_CORRECTCOMPLETE2 (0x00000002u)
#define CSL_EMIF16_NANDFSR_CORR_STATE_CORRECTCOMPLETE3 (0x00000003u)
#define CSL_EMIF16_NANDFSR_CORR_STATE_CALCNUMERR (0x00000005u)
#define CSL_EMIF16_NANDFSR_CORR_STATE_PREPERROR6 (0x00000006u)
#define CSL_EMIF16_NANDFSR_CORR_STATE_PREPERROR7 (0x00000007u)
#define CSL_EMIF16_NANDFSR_CORR_STATE_SEARCHERR (0x00000008u)
#define CSL_EMIF16_NANDFSR_CORR_STATE_CALCERR12 (0x0000000cu)
#define CSL_EMIF16_NANDFSR_CORR_STATE_CALCERR13 (0x0000000du)
#define CSL_EMIF16_NANDFSR_CORR_STATE_CALCERR14 (0x0000000eu)
#define CSL_EMIF16_NANDFSR_CORR_STATE_CALCERR15 (0x0000000fu)


#define CSL_EMIF16_NANDFSR_WAITSTAT_MASK (0x0000000Fu)
#define CSL_EMIF16_NANDFSR_WAITSTAT_SHIFT (0x00000000u)
#define CSL_EMIF16_NANDFSR_WAITSTAT_RESETVAL (0x00000000u)

#define CSL_EMIF16_NANDFSR_RESETVAL      (0x00000000u)

/* PMCR */

#define CSL_EMIF16_PMCR_CE3PGDEL_MASK    (0xFC000000u)
#define CSL_EMIF16_PMCR_CE3PGDEL_SHIFT   (0x0000001Au)
#define CSL_EMIF16_PMCR_CE3PGDEL_RESETVAL (0x0000003Fu)

#define CSL_EMIF16_PMCR_CE3PGSIZE_MASK   (0x02000000u)
#define CSL_EMIF16_PMCR_CE3PGSIZE_SHIFT  (0x00000019u)
#define CSL_EMIF16_PMCR_CE3PGSIZE_RESETVAL (0x00000000u)
/*----ce3pgsize Tokens----*/
#define CSL_EMIF16_PMCR_CE3PGSIZE_4WORD  (0x00000000u)
#define CSL_EMIF16_PMCR_CE3PGSIZE_8WORD  (0x00000001u)

#define CSL_EMIF16_PMCR_CE3PGMDEN_MASK   (0x01000000u)
#define CSL_EMIF16_PMCR_CE3PGMDEN_SHIFT  (0x00000018u)
#define CSL_EMIF16_PMCR_CE3PGMDEN_RESETVAL (0x00000000u)
/*----ce3pgmden Tokens----*/
#define CSL_EMIF16_PMCR_CE3PGMDEN_DISABLE (0x00000000u)
#define CSL_EMIF16_PMCR_CE3PGMDEN_ENABLE (0x00000001u)

#define CSL_EMIF16_PMCR_CE2PGDEL_MASK    (0x00FC0000u)
#define CSL_EMIF16_PMCR_CE2PGDEL_SHIFT   (0x00000012u)
#define CSL_EMIF16_PMCR_CE2PGDEL_RESETVAL (0x0000003Fu)

#define CSL_EMIF16_PMCR_CE2PGSIZE_MASK   (0x00020000u)
#define CSL_EMIF16_PMCR_CE2PGSIZE_SHIFT  (0x00000011u)
#define CSL_EMIF16_PMCR_CE2PGSIZE_RESETVAL (0x00000000u)
/*----ce2pgsize Tokens----*/
#define CSL_EMIF16_PMCR_CE2PGSIZE_4WORD  (0x00000000u)
#define CSL_EMIF16_PMCR_CE2PGSIZE_8WORD  (0x00000001u)

#define CSL_EMIF16_PMCR_CE2PGMDEN_MASK   (0x00010000u)
#define CSL_EMIF16_PMCR_CE2PGMDEN_SHIFT  (0x00000010u)
#define CSL_EMIF16_PMCR_CE2PGMDEN_RESETVAL (0x00000000u)
/*----ce2pgmden Tokens----*/
#define CSL_EMIF16_PMCR_CE2PGMDEN_DISABLE (0x00000000u)
#define CSL_EMIF16_PMCR_CE2PGMDEN_ENABLE (0x00000001u)

#define CSL_EMIF16_PMCR_CE1PGDEL_MASK    (0x0000FC00u)
#define CSL_EMIF16_PMCR_CE1PGDEL_SHIFT   (0x0000000Au)
#define CSL_EMIF16_PMCR_CE1PGDEL_RESETVAL (0x0000003Fu)

#define CSL_EMIF16_PMCR_CE1PGSIZE_MASK   (0x00000200u)
#define CSL_EMIF16_PMCR_CE1PGSIZE_SHIFT  (0x00000009u)
#define CSL_EMIF16_PMCR_CE1PGSIZE_RESETVAL (0x00000000u)
/*----ce1pgsize Tokens----*/
#define CSL_EMIF16_PMCR_CE1PGSIZE_4WORD  (0x00000000u)
#define CSL_EMIF16_PMCR_CE1PGSIZE_8WORD  (0x00000001u)

#define CSL_EMIF16_PMCR_C3EPGMDEN_MASK   (0x00000100u)
#define CSL_EMIF16_PMCR_C3EPGMDEN_SHIFT  (0x00000008u)
#define CSL_EMIF16_PMCR_C3EPGMDEN_RESETVAL (0x00000000u)
/*----c3epgmden Tokens----*/
#define CSL_EMIF16_PMCR_C3EPGMDEN_DISABLE (0x00000000u)
#define CSL_EMIF16_PMCR_C3EPGMDEN_ENABLE (0x00000001u)

#define CSL_EMIF16_PMCR_CE0PGDEL_MASK    (0x000000FCu)
#define CSL_EMIF16_PMCR_CE0PGDEL_SHIFT   (0x00000002u)
#define CSL_EMIF16_PMCR_CE0PGDEL_RESETVAL (0x0000003Fu)

#define CSL_EMIF16_PMCR_CE0PGSIZE_MASK   (0x00000002u)
#define CSL_EMIF16_PMCR_CE0PGSIZE_SHIFT  (0x00000001u)
#define CSL_EMIF16_PMCR_CE0PGSIZE_RESETVAL (0x00000000u)
/*----ce0pgsize Tokens----*/
#define CSL_EMIF16_PMCR_CE0PGSIZE_4WORD  (0x00000000u)
#define CSL_EMIF16_PMCR_CE0PGSIZE_8WORD  (0x00000001u)

#define CSL_EMIF16_PMCR_CE0PGMDEN_MASK   (0x00000001u)
#define CSL_EMIF16_PMCR_CE0PGMDEN_SHIFT  (0x00000000u)
#define CSL_EMIF16_PMCR_CE0PGMDEN_RESETVAL (0x00000000u)
/*----ce0pgmden Tokens----*/
#define CSL_EMIF16_PMCR_CE0PGMDEN_DISABLE (0x00000000u)
#define CSL_EMIF16_PMCR_CE0PGMDEN_ENABLE (0x00000001u)

#define CSL_EMIF16_PMCR_RESETVAL         (0xFCFCFCFCu)

/* NFECCCE0 */


#define CSL_EMIF16_NFECCCE0_P2048O_MASK  (0x08000000u)
#define CSL_EMIF16_NFECCCE0_P2048O_SHIFT (0x0000001Bu)
#define CSL_EMIF16_NFECCCE0_P2048O_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE0_P1024O_MASK  (0x04000000u)
#define CSL_EMIF16_NFECCCE0_P1024O_SHIFT (0x0000001Au)
#define CSL_EMIF16_NFECCCE0_P1024O_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE0_P512O_MASK   (0x02000000u)
#define CSL_EMIF16_NFECCCE0_P512O_SHIFT  (0x00000019u)
#define CSL_EMIF16_NFECCCE0_P512O_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE0_P256O_MASK   (0x01000000u)
#define CSL_EMIF16_NFECCCE0_P256O_SHIFT  (0x00000018u)
#define CSL_EMIF16_NFECCCE0_P256O_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE0_P128O_MASK   (0x00800000u)
#define CSL_EMIF16_NFECCCE0_P128O_SHIFT  (0x00000017u)
#define CSL_EMIF16_NFECCCE0_P128O_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE0_P64O_MASK    (0x00400000u)
#define CSL_EMIF16_NFECCCE0_P64O_SHIFT   (0x00000016u)
#define CSL_EMIF16_NFECCCE0_P64O_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE0_P32O_MASK    (0x00200000u)
#define CSL_EMIF16_NFECCCE0_P32O_SHIFT   (0x00000015u)
#define CSL_EMIF16_NFECCCE0_P32O_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE0_P16O_MASK    (0x00100000u)
#define CSL_EMIF16_NFECCCE0_P16O_SHIFT   (0x00000014u)
#define CSL_EMIF16_NFECCCE0_P16O_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE0_P8O_MASK     (0x00080000u)
#define CSL_EMIF16_NFECCCE0_P8O_SHIFT    (0x00000013u)
#define CSL_EMIF16_NFECCCE0_P8O_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE0_P4O_MASK     (0x00040000u)
#define CSL_EMIF16_NFECCCE0_P4O_SHIFT    (0x00000012u)
#define CSL_EMIF16_NFECCCE0_P4O_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE0_P2O_MASK     (0x00020000u)
#define CSL_EMIF16_NFECCCE0_P2O_SHIFT    (0x00000011u)
#define CSL_EMIF16_NFECCCE0_P2O_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE0_P1O_MASK     (0x00010000u)
#define CSL_EMIF16_NFECCCE0_P1O_SHIFT    (0x00000010u)
#define CSL_EMIF16_NFECCCE0_P1O_RESETVAL (0x00000000u)


#define CSL_EMIF16_NFECCCE0_P2048E_MASK  (0x00000800u)
#define CSL_EMIF16_NFECCCE0_P2048E_SHIFT (0x0000000Bu)
#define CSL_EMIF16_NFECCCE0_P2048E_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE0_P1024E_MASK  (0x00000400u)
#define CSL_EMIF16_NFECCCE0_P1024E_SHIFT (0x0000000Au)
#define CSL_EMIF16_NFECCCE0_P1024E_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE0_P512E_MASK   (0x00000200u)
#define CSL_EMIF16_NFECCCE0_P512E_SHIFT  (0x00000009u)
#define CSL_EMIF16_NFECCCE0_P512E_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE0_P256E_MASK   (0x00000100u)
#define CSL_EMIF16_NFECCCE0_P256E_SHIFT  (0x00000008u)
#define CSL_EMIF16_NFECCCE0_P256E_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE0_P128E_MASK   (0x00000080u)
#define CSL_EMIF16_NFECCCE0_P128E_SHIFT  (0x00000007u)
#define CSL_EMIF16_NFECCCE0_P128E_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE0_P64E_MASK    (0x00000040u)
#define CSL_EMIF16_NFECCCE0_P64E_SHIFT   (0x00000006u)
#define CSL_EMIF16_NFECCCE0_P64E_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE0_P32E_MASK    (0x00000020u)
#define CSL_EMIF16_NFECCCE0_P32E_SHIFT   (0x00000005u)
#define CSL_EMIF16_NFECCCE0_P32E_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE0_P16E_MASK    (0x00000010u)
#define CSL_EMIF16_NFECCCE0_P16E_SHIFT   (0x00000004u)
#define CSL_EMIF16_NFECCCE0_P16E_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE0_P8E_MASK     (0x00000008u)
#define CSL_EMIF16_NFECCCE0_P8E_SHIFT    (0x00000003u)
#define CSL_EMIF16_NFECCCE0_P8E_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE0_P4E_MASK     (0x00000004u)
#define CSL_EMIF16_NFECCCE0_P4E_SHIFT    (0x00000002u)
#define CSL_EMIF16_NFECCCE0_P4E_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE0_P2E_MASK     (0x00000002u)
#define CSL_EMIF16_NFECCCE0_P2E_SHIFT    (0x00000001u)
#define CSL_EMIF16_NFECCCE0_P2E_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE0_P1E_MASK     (0x00000001u)
#define CSL_EMIF16_NFECCCE0_P1E_SHIFT    (0x00000000u)
#define CSL_EMIF16_NFECCCE0_P1E_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE0_RESETVAL     (0x00000000u)

/* NFECCCE1 */


#define CSL_EMIF16_NFECCCE1_P2048O_MASK  (0x08000000u)
#define CSL_EMIF16_NFECCCE1_P2048O_SHIFT (0x0000001Bu)
#define CSL_EMIF16_NFECCCE1_P2048O_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE1_P1024O_MASK  (0x04000000u)
#define CSL_EMIF16_NFECCCE1_P1024O_SHIFT (0x0000001Au)
#define CSL_EMIF16_NFECCCE1_P1024O_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE1_P512O_MASK   (0x02000000u)
#define CSL_EMIF16_NFECCCE1_P512O_SHIFT  (0x00000019u)
#define CSL_EMIF16_NFECCCE1_P512O_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE1_P256O_MASK   (0x01000000u)
#define CSL_EMIF16_NFECCCE1_P256O_SHIFT  (0x00000018u)
#define CSL_EMIF16_NFECCCE1_P256O_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE1_P128O_MASK   (0x00800000u)
#define CSL_EMIF16_NFECCCE1_P128O_SHIFT  (0x00000017u)
#define CSL_EMIF16_NFECCCE1_P128O_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE1_P64O_MASK    (0x00400000u)
#define CSL_EMIF16_NFECCCE1_P64O_SHIFT   (0x00000016u)
#define CSL_EMIF16_NFECCCE1_P64O_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE1_P32O_MASK    (0x00200000u)
#define CSL_EMIF16_NFECCCE1_P32O_SHIFT   (0x00000015u)
#define CSL_EMIF16_NFECCCE1_P32O_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE1_P16O_MASK    (0x00100000u)
#define CSL_EMIF16_NFECCCE1_P16O_SHIFT   (0x00000014u)
#define CSL_EMIF16_NFECCCE1_P16O_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE1_P8O_MASK     (0x00080000u)
#define CSL_EMIF16_NFECCCE1_P8O_SHIFT    (0x00000013u)
#define CSL_EMIF16_NFECCCE1_P8O_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE1_P4O_MASK     (0x00040000u)
#define CSL_EMIF16_NFECCCE1_P4O_SHIFT    (0x00000012u)
#define CSL_EMIF16_NFECCCE1_P4O_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE1_P2O_MASK     (0x00020000u)
#define CSL_EMIF16_NFECCCE1_P2O_SHIFT    (0x00000011u)
#define CSL_EMIF16_NFECCCE1_P2O_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE1_P1O_MASK     (0x00010000u)
#define CSL_EMIF16_NFECCCE1_P1O_SHIFT    (0x00000010u)
#define CSL_EMIF16_NFECCCE1_P1O_RESETVAL (0x00000000u)


#define CSL_EMIF16_NFECCCE1_P2048E_MASK  (0x00000800u)
#define CSL_EMIF16_NFECCCE1_P2048E_SHIFT (0x0000000Bu)
#define CSL_EMIF16_NFECCCE1_P2048E_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE1_P1024E_MASK  (0x00000400u)
#define CSL_EMIF16_NFECCCE1_P1024E_SHIFT (0x0000000Au)
#define CSL_EMIF16_NFECCCE1_P1024E_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE1_P512E_MASK   (0x00000200u)
#define CSL_EMIF16_NFECCCE1_P512E_SHIFT  (0x00000009u)
#define CSL_EMIF16_NFECCCE1_P512E_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE1_P256E_MASK   (0x00000100u)
#define CSL_EMIF16_NFECCCE1_P256E_SHIFT  (0x00000008u)
#define CSL_EMIF16_NFECCCE1_P256E_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE1_P128E_MASK   (0x00000080u)
#define CSL_EMIF16_NFECCCE1_P128E_SHIFT  (0x00000007u)
#define CSL_EMIF16_NFECCCE1_P128E_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE1_P64E_MASK    (0x00000040u)
#define CSL_EMIF16_NFECCCE1_P64E_SHIFT   (0x00000006u)
#define CSL_EMIF16_NFECCCE1_P64E_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE1_P32E_MASK    (0x00000020u)
#define CSL_EMIF16_NFECCCE1_P32E_SHIFT   (0x00000005u)
#define CSL_EMIF16_NFECCCE1_P32E_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE1_P16E_MASK    (0x00000010u)
#define CSL_EMIF16_NFECCCE1_P16E_SHIFT   (0x00000004u)
#define CSL_EMIF16_NFECCCE1_P16E_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE1_P8E_MASK     (0x00000008u)
#define CSL_EMIF16_NFECCCE1_P8E_SHIFT    (0x00000003u)
#define CSL_EMIF16_NFECCCE1_P8E_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE1_P4E_MASK     (0x00000004u)
#define CSL_EMIF16_NFECCCE1_P4E_SHIFT    (0x00000002u)
#define CSL_EMIF16_NFECCCE1_P4E_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE1_P2E_MASK     (0x00000002u)
#define CSL_EMIF16_NFECCCE1_P2E_SHIFT    (0x00000001u)
#define CSL_EMIF16_NFECCCE1_P2E_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE1_P1E_MASK     (0x00000001u)
#define CSL_EMIF16_NFECCCE1_P1E_SHIFT    (0x00000000u)
#define CSL_EMIF16_NFECCCE1_P1E_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE1_RESETVAL     (0x00000000u)

/* NFECCCE2 */


#define CSL_EMIF16_NFECCCE2_P2048O_MASK  (0x08000000u)
#define CSL_EMIF16_NFECCCE2_P2048O_SHIFT (0x0000001Bu)
#define CSL_EMIF16_NFECCCE2_P2048O_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE2_P1024O_MASK  (0x04000000u)
#define CSL_EMIF16_NFECCCE2_P1024O_SHIFT (0x0000001Au)
#define CSL_EMIF16_NFECCCE2_P1024O_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE2_P512O_MASK   (0x02000000u)
#define CSL_EMIF16_NFECCCE2_P512O_SHIFT  (0x00000019u)
#define CSL_EMIF16_NFECCCE2_P512O_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE2_P256O_MASK   (0x01000000u)
#define CSL_EMIF16_NFECCCE2_P256O_SHIFT  (0x00000018u)
#define CSL_EMIF16_NFECCCE2_P256O_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE2_P128O_MASK   (0x00800000u)
#define CSL_EMIF16_NFECCCE2_P128O_SHIFT  (0x00000017u)
#define CSL_EMIF16_NFECCCE2_P128O_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE2_P64O_MASK    (0x00400000u)
#define CSL_EMIF16_NFECCCE2_P64O_SHIFT   (0x00000016u)
#define CSL_EMIF16_NFECCCE2_P64O_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE2_P32O_MASK    (0x00200000u)
#define CSL_EMIF16_NFECCCE2_P32O_SHIFT   (0x00000015u)
#define CSL_EMIF16_NFECCCE2_P32O_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE2_P16O_MASK    (0x00100000u)
#define CSL_EMIF16_NFECCCE2_P16O_SHIFT   (0x00000014u)
#define CSL_EMIF16_NFECCCE2_P16O_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE2_P8O_MASK     (0x00080000u)
#define CSL_EMIF16_NFECCCE2_P8O_SHIFT    (0x00000013u)
#define CSL_EMIF16_NFECCCE2_P8O_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE2_P4O_MASK     (0x00040000u)
#define CSL_EMIF16_NFECCCE2_P4O_SHIFT    (0x00000012u)
#define CSL_EMIF16_NFECCCE2_P4O_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE2_P2O_MASK     (0x00020000u)
#define CSL_EMIF16_NFECCCE2_P2O_SHIFT    (0x00000011u)
#define CSL_EMIF16_NFECCCE2_P2O_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE2_P1O_MASK     (0x00010000u)
#define CSL_EMIF16_NFECCCE2_P1O_SHIFT    (0x00000010u)
#define CSL_EMIF16_NFECCCE2_P1O_RESETVAL (0x00000000u)


#define CSL_EMIF16_NFECCCE2_P2048E_MASK  (0x00000800u)
#define CSL_EMIF16_NFECCCE2_P2048E_SHIFT (0x0000000Bu)
#define CSL_EMIF16_NFECCCE2_P2048E_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE2_P1024E_MASK  (0x00000400u)
#define CSL_EMIF16_NFECCCE2_P1024E_SHIFT (0x0000000Au)
#define CSL_EMIF16_NFECCCE2_P1024E_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE2_P512E_MASK   (0x00000200u)
#define CSL_EMIF16_NFECCCE2_P512E_SHIFT  (0x00000009u)
#define CSL_EMIF16_NFECCCE2_P512E_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE2_P256E_MASK   (0x00000100u)
#define CSL_EMIF16_NFECCCE2_P256E_SHIFT  (0x00000008u)
#define CSL_EMIF16_NFECCCE2_P256E_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE2_P128E_MASK   (0x00000080u)
#define CSL_EMIF16_NFECCCE2_P128E_SHIFT  (0x00000007u)
#define CSL_EMIF16_NFECCCE2_P128E_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE2_P64E_MASK    (0x00000040u)
#define CSL_EMIF16_NFECCCE2_P64E_SHIFT   (0x00000006u)
#define CSL_EMIF16_NFECCCE2_P64E_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE2_P32E_MASK    (0x00000020u)
#define CSL_EMIF16_NFECCCE2_P32E_SHIFT   (0x00000005u)
#define CSL_EMIF16_NFECCCE2_P32E_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE2_P16E_MASK    (0x00000010u)
#define CSL_EMIF16_NFECCCE2_P16E_SHIFT   (0x00000004u)
#define CSL_EMIF16_NFECCCE2_P16E_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE2_P8E_MASK     (0x00000008u)
#define CSL_EMIF16_NFECCCE2_P8E_SHIFT    (0x00000003u)
#define CSL_EMIF16_NFECCCE2_P8E_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE2_P4E_MASK     (0x00000004u)
#define CSL_EMIF16_NFECCCE2_P4E_SHIFT    (0x00000002u)
#define CSL_EMIF16_NFECCCE2_P4E_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE2_P2E_MASK     (0x00000002u)
#define CSL_EMIF16_NFECCCE2_P2E_SHIFT    (0x00000001u)
#define CSL_EMIF16_NFECCCE2_P2E_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE2_P1E_MASK     (0x00000001u)
#define CSL_EMIF16_NFECCCE2_P1E_SHIFT    (0x00000000u)
#define CSL_EMIF16_NFECCCE2_P1E_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE2_RESETVAL     (0x00000000u)

/* NFECCCE3 */


#define CSL_EMIF16_NFECCCE3_P2048O_MASK  (0x08000000u)
#define CSL_EMIF16_NFECCCE3_P2048O_SHIFT (0x0000001Bu)
#define CSL_EMIF16_NFECCCE3_P2048O_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE3_P1024O_MASK  (0x04000000u)
#define CSL_EMIF16_NFECCCE3_P1024O_SHIFT (0x0000001Au)
#define CSL_EMIF16_NFECCCE3_P1024O_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE3_P512O_MASK   (0x02000000u)
#define CSL_EMIF16_NFECCCE3_P512O_SHIFT  (0x00000019u)
#define CSL_EMIF16_NFECCCE3_P512O_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE3_P256O_MASK   (0x01000000u)
#define CSL_EMIF16_NFECCCE3_P256O_SHIFT  (0x00000018u)
#define CSL_EMIF16_NFECCCE3_P256O_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE3_P128O_MASK   (0x00800000u)
#define CSL_EMIF16_NFECCCE3_P128O_SHIFT  (0x00000017u)
#define CSL_EMIF16_NFECCCE3_P128O_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE3_P64O_MASK    (0x00400000u)
#define CSL_EMIF16_NFECCCE3_P64O_SHIFT   (0x00000016u)
#define CSL_EMIF16_NFECCCE3_P64O_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE3_P32O_MASK    (0x00200000u)
#define CSL_EMIF16_NFECCCE3_P32O_SHIFT   (0x00000015u)
#define CSL_EMIF16_NFECCCE3_P32O_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE3_P16O_MASK    (0x00100000u)
#define CSL_EMIF16_NFECCCE3_P16O_SHIFT   (0x00000014u)
#define CSL_EMIF16_NFECCCE3_P16O_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE3_P8O_MASK     (0x00080000u)
#define CSL_EMIF16_NFECCCE3_P8O_SHIFT    (0x00000013u)
#define CSL_EMIF16_NFECCCE3_P8O_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE3_P4O_MASK     (0x00040000u)
#define CSL_EMIF16_NFECCCE3_P4O_SHIFT    (0x00000012u)
#define CSL_EMIF16_NFECCCE3_P4O_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE3_P2O_MASK     (0x00020000u)
#define CSL_EMIF16_NFECCCE3_P2O_SHIFT    (0x00000011u)
#define CSL_EMIF16_NFECCCE3_P2O_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE3_P1O_MASK     (0x00010000u)
#define CSL_EMIF16_NFECCCE3_P1O_SHIFT    (0x00000010u)
#define CSL_EMIF16_NFECCCE3_P1O_RESETVAL (0x00000000u)


#define CSL_EMIF16_NFECCCE3_P2048E_MASK  (0x00000800u)
#define CSL_EMIF16_NFECCCE3_P2048E_SHIFT (0x0000000Bu)
#define CSL_EMIF16_NFECCCE3_P2048E_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE3_P1024E_MASK  (0x00000400u)
#define CSL_EMIF16_NFECCCE3_P1024E_SHIFT (0x0000000Au)
#define CSL_EMIF16_NFECCCE3_P1024E_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE3_P512E_MASK   (0x00000200u)
#define CSL_EMIF16_NFECCCE3_P512E_SHIFT  (0x00000009u)
#define CSL_EMIF16_NFECCCE3_P512E_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE3_P256E_MASK   (0x00000100u)
#define CSL_EMIF16_NFECCCE3_P256E_SHIFT  (0x00000008u)
#define CSL_EMIF16_NFECCCE3_P256E_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE3_P128E_MASK   (0x00000080u)
#define CSL_EMIF16_NFECCCE3_P128E_SHIFT  (0x00000007u)
#define CSL_EMIF16_NFECCCE3_P128E_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE3_P64E_MASK    (0x00000040u)
#define CSL_EMIF16_NFECCCE3_P64E_SHIFT   (0x00000006u)
#define CSL_EMIF16_NFECCCE3_P64E_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE3_P32E_MASK    (0x00000020u)
#define CSL_EMIF16_NFECCCE3_P32E_SHIFT   (0x00000005u)
#define CSL_EMIF16_NFECCCE3_P32E_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE3_P16E_MASK    (0x00000010u)
#define CSL_EMIF16_NFECCCE3_P16E_SHIFT   (0x00000004u)
#define CSL_EMIF16_NFECCCE3_P16E_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE3_P8E_MASK     (0x00000008u)
#define CSL_EMIF16_NFECCCE3_P8E_SHIFT    (0x00000003u)
#define CSL_EMIF16_NFECCCE3_P8E_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE3_P4E_MASK     (0x00000004u)
#define CSL_EMIF16_NFECCCE3_P4E_SHIFT    (0x00000002u)
#define CSL_EMIF16_NFECCCE3_P4E_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE3_P2E_MASK     (0x00000002u)
#define CSL_EMIF16_NFECCCE3_P2E_SHIFT    (0x00000001u)
#define CSL_EMIF16_NFECCCE3_P2E_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE3_P1E_MASK     (0x00000001u)
#define CSL_EMIF16_NFECCCE3_P1E_SHIFT    (0x00000000u)
#define CSL_EMIF16_NFECCCE3_P1E_RESETVAL (0x00000000u)

#define CSL_EMIF16_NFECCCE3_RESETVAL     (0x00000000u)

/* IODFTEXECNT */


#define CSL_EMIF16_IODFTEXECNT_TLEC_MASK (0x0000FFFFu)
#define CSL_EMIF16_IODFTEXECNT_TLEC_SHIFT (0x00000000u)
#define CSL_EMIF16_IODFTEXECNT_TLEC_RESETVAL (0x00000000u)

#define CSL_EMIF16_IODFTEXECNT_RESETVAL  (0x00000000u)

/* IODFTGBLCTRL */


#define CSL_EMIF16_IODFTGBLCTRL_MT_MASK  (0x00004000u)
#define CSL_EMIF16_IODFTGBLCTRL_MT_SHIFT (0x0000000Eu)
#define CSL_EMIF16_IODFTGBLCTRL_MT_RESETVAL (0x00000000u)

#define CSL_EMIF16_IODFTGBLCTRL_ACT_CAP_EN_MASK (0x00002000u)
#define CSL_EMIF16_IODFTGBLCTRL_ACT_CAP_EN_SHIFT (0x0000000Du)
#define CSL_EMIF16_IODFTGBLCTRL_ACT_CAP_EN_RESETVAL (0x00000000u)

#define CSL_EMIF16_IODFTGBLCTRL_OPG_LD_MASK (0x00001000u)
#define CSL_EMIF16_IODFTGBLCTRL_OPG_LD_SHIFT (0x0000000Cu)
#define CSL_EMIF16_IODFTGBLCTRL_OPG_LD_RESETVAL (0x00000000u)


#define CSL_EMIF16_IODFTGBLCTRL_MMS_MASK (0x00000100u)
#define CSL_EMIF16_IODFTGBLCTRL_MMS_SHIFT (0x00000008u)
#define CSL_EMIF16_IODFTGBLCTRL_MMS_RESETVAL (0x00000000u)
/*----mms Tokens----*/
#define CSL_EMIF16_IODFTGBLCTRL_MMS_OUTPUTREG (0x00000000u)
#define CSL_EMIF16_IODFTGBLCTRL_MMS_INPUTCAP (0x00000001u)

#define CSL_EMIF16_IODFTGBLCTRL_ESEL_MASK (0x00000080u)
#define CSL_EMIF16_IODFTGBLCTRL_ESEL_SHIFT (0x00000007u)
#define CSL_EMIF16_IODFTGBLCTRL_ESEL_RESETVAL (0x00000001u)
/*----esel Tokens----*/
#define CSL_EMIF16_IODFTGBLCTRL_ESEL_TESTMODE (0x00000000u)
#define CSL_EMIF16_IODFTGBLCTRL_ESEL_NORMALMODE (0x00000001u)

#define CSL_EMIF16_IODFTGBLCTRL_TOEN_MASK (0x00000040u)
#define CSL_EMIF16_IODFTGBLCTRL_TOEN_SHIFT (0x00000006u)
#define CSL_EMIF16_IODFTGBLCTRL_TOEN_RESETVAL (0x00000000u)
/*----toen Tokens----*/
#define CSL_EMIF16_IODFTGBLCTRL_TOEN_ENABLE (0x00000000u)
#define CSL_EMIF16_IODFTGBLCTRL_TOEN_DISABLE (0x00000001u)

#define CSL_EMIF16_IODFTGBLCTRL_MC_MASK  (0x00000030u)
#define CSL_EMIF16_IODFTGBLCTRL_MC_SHIFT (0x00000004u)
#define CSL_EMIF16_IODFTGBLCTRL_MC_RESETVAL (0x00000001u)
/*----mc Tokens----*/
#define CSL_EMIF16_IODFTGBLCTRL_MC_DNLWD (0x00000000u)
#define CSL_EMIF16_IODFTGBLCTRL_MC_HOLD  (0x00000001u)
#define CSL_EMIF16_IODFTGBLCTRL_MC_LWDINIT (0x00000002u)
#define CSL_EMIF16_IODFTGBLCTRL_MC_MISRENCAP (0x00000003u)

#define CSL_EMIF16_IODFTGBLCTRL_PC_MASK  (0x0000000Eu)
#define CSL_EMIF16_IODFTGBLCTRL_PC_SHIFT (0x00000001u)
#define CSL_EMIF16_IODFTGBLCTRL_PC_RESETVAL (0x00000000u)

#define CSL_EMIF16_IODFTGBLCTRL_TM_MASK  (0x00000001u)
#define CSL_EMIF16_IODFTGBLCTRL_TM_SHIFT (0x00000000u)
#define CSL_EMIF16_IODFTGBLCTRL_TM_RESETVAL (0x00000001u)

#define CSL_EMIF16_IODFTGBLCTRL_RESETVAL (0x00000091u)

/* IODFTTLAMISR */


#define CSL_EMIF16_IODFTTLAMISR_ADDR_TLMR_MASK (0x0FFFFFFFu)
#define CSL_EMIF16_IODFTTLAMISR_ADDR_TLMR_SHIFT (0x00000000u)
#define CSL_EMIF16_IODFTTLAMISR_ADDR_TLMR_RESETVAL (0x00000000u)

#define CSL_EMIF16_IODFTTLAMISR_RESETVAL (0x00000000u)

/* IODFTTLDMISR */

#define CSL_EMIF16_IODFTTLDMISR_TLMR_31_0_MASK (0xFFFFFFFFu)
#define CSL_EMIF16_IODFTTLDMISR_TLMR_31_0_SHIFT (0x00000000u)
#define CSL_EMIF16_IODFTTLDMISR_TLMR_31_0_RESETVAL (0x00000000u)

#define CSL_EMIF16_IODFTTLDMISR_RESETVAL (0x00000000u)

/* IODFTTLDCMISR */


#define CSL_EMIF16_IODFTTLDCMISR_CTL_TLMR_MASK (0x3FFF0000u)
#define CSL_EMIF16_IODFTTLDCMISR_CTL_TLMR_SHIFT (0x00000010u)
#define CSL_EMIF16_IODFTTLDCMISR_CTL_TLMR_RESETVAL (0x00000000u)


#define CSL_EMIF16_IODFTTLDCMISR_DQM_TLMR_MASK (0x00003F00u)
#define CSL_EMIF16_IODFTTLDCMISR_DQM_TLMR_SHIFT (0x00000008u)
#define CSL_EMIF16_IODFTTLDCMISR_DQM_TLMR_RESETVAL (0x00000000u)


#define CSL_EMIF16_IODFTTLDCMISR_TLMR_34_32_MASK (0x00000007u)
#define CSL_EMIF16_IODFTTLDCMISR_TLMR_34_32_SHIFT (0x00000000u)
#define CSL_EMIF16_IODFTTLDCMISR_TLMR_34_32_RESETVAL (0x00000000u)

#define CSL_EMIF16_IODFTTLDCMISR_RESETVAL (0x00000000u)

/* MODRELNUM */


#define CSL_EMIF16_MODRELNUM_RELEASE_NUM_MASK (0x000000FFu)
#define CSL_EMIF16_MODRELNUM_RELEASE_NUM_SHIFT (0x00000000u)
#define CSL_EMIF16_MODRELNUM_RELEASE_NUM_RESETVAL (0x00000000u)

#define CSL_EMIF16_MODRELNUM_RESETVAL    (0x00000000u)

/* NANDF4BECCLR */


#define CSL_EMIF16_NANDF4BECCLR_4BIT_ECC_LOAD_MASK (0x000003FFu)
#define CSL_EMIF16_NANDF4BECCLR_4BIT_ECC_LOAD_SHIFT (0x00000000u)
#define CSL_EMIF16_NANDF4BECCLR_4BIT_ECC_LOAD_RESETVAL (0x00000000u)

#define CSL_EMIF16_NANDF4BECCLR_RESETVAL (0x00000000u)

/* NANDF4BECC1R */


#define CSL_EMIF16_NANDF4BECC1R_4BIT_ECC_VAL2_MASK (0x03FF0000u)
#define CSL_EMIF16_NANDF4BECC1R_4BIT_ECC_VAL2_SHIFT (0x00000010u)
#define CSL_EMIF16_NANDF4BECC1R_4BIT_ECC_VAL2_RESETVAL (0x00000000u)


#define CSL_EMIF16_NANDF4BECC1R_4BIT_ECC_VAL1_MASK (0x000003FFu)
#define CSL_EMIF16_NANDF4BECC1R_4BIT_ECC_VAL1_SHIFT (0x00000000u)
#define CSL_EMIF16_NANDF4BECC1R_4BIT_ECC_VAL1_RESETVAL (0x00000000u)

#define CSL_EMIF16_NANDF4BECC1R_RESETVAL (0x00000000u)

/* NANDF4BECC2R */


#define CSL_EMIF16_NANDF4BECC2R_4BIT_ECC_VAL4_MASK (0x03FF0000u)
#define CSL_EMIF16_NANDF4BECC2R_4BIT_ECC_VAL4_SHIFT (0x00000010u)
#define CSL_EMIF16_NANDF4BECC2R_4BIT_ECC_VAL4_RESETVAL (0x00000000u)


#define CSL_EMIF16_NANDF4BECC2R_4BIT_ECC_VAL3_MASK (0x000003FFu)
#define CSL_EMIF16_NANDF4BECC2R_4BIT_ECC_VAL3_SHIFT (0x00000000u)
#define CSL_EMIF16_NANDF4BECC2R_4BIT_ECC_VAL3_RESETVAL (0x00000000u)

#define CSL_EMIF16_NANDF4BECC2R_RESETVAL (0x00000000u)

/* NANDF4BECC3R */


#define CSL_EMIF16_NANDF4BECC3R_4BIT_ECC_VAL6_MASK (0x03FF0000u)
#define CSL_EMIF16_NANDF4BECC3R_4BIT_ECC_VAL6_SHIFT (0x00000010u)
#define CSL_EMIF16_NANDF4BECC3R_4BIT_ECC_VAL6_RESETVAL (0x00000000u)


#define CSL_EMIF16_NANDF4BECC3R_4BIT_ECC_VAL5_MASK (0x000003FFu)
#define CSL_EMIF16_NANDF4BECC3R_4BIT_ECC_VAL5_SHIFT (0x00000000u)
#define CSL_EMIF16_NANDF4BECC3R_4BIT_ECC_VAL5_RESETVAL (0x00000000u)

#define CSL_EMIF16_NANDF4BECC3R_RESETVAL (0x00000000u)

/* NANDF4BECC4R */


#define CSL_EMIF16_NANDF4BECC4R_4BIT_ECC_VAL8_MASK (0x03FF0000u)
#define CSL_EMIF16_NANDF4BECC4R_4BIT_ECC_VAL8_SHIFT (0x00000010u)
#define CSL_EMIF16_NANDF4BECC4R_4BIT_ECC_VAL8_RESETVAL (0x00000000u)


#define CSL_EMIF16_NANDF4BECC4R_4BIT_ECC_VAL7_MASK (0x000003FFu)
#define CSL_EMIF16_NANDF4BECC4R_4BIT_ECC_VAL7_SHIFT (0x00000000u)
#define CSL_EMIF16_NANDF4BECC4R_4BIT_ECC_VAL7_RESETVAL (0x00000000u)

#define CSL_EMIF16_NANDF4BECC4R_RESETVAL (0x00000000u)

/* NANDFEA1R */


#define CSL_EMIF16_NANDFEA1R_ERR_ADDR2_MASK (0x03FF0000u)
#define CSL_EMIF16_NANDFEA1R_ERR_ADDR2_SHIFT (0x00000010u)
#define CSL_EMIF16_NANDFEA1R_ERR_ADDR2_RESETVAL (0x00000000u)


#define CSL_EMIF16_NANDFEA1R_ERR_ADDR1_MASK (0x000003FFu)
#define CSL_EMIF16_NANDFEA1R_ERR_ADDR1_SHIFT (0x00000000u)
#define CSL_EMIF16_NANDFEA1R_ERR_ADDR1_RESETVAL (0x00000000u)

#define CSL_EMIF16_NANDFEA1R_RESETVAL    (0x00000000u)

/* NANDFEA2R */


#define CSL_EMIF16_NANDFEA2R_ERR_ADDR4_MASK (0x03FF0000u)
#define CSL_EMIF16_NANDFEA2R_ERR_ADDR4_SHIFT (0x00000010u)
#define CSL_EMIF16_NANDFEA2R_ERR_ADDR4_RESETVAL (0x00000000u)


#define CSL_EMIF16_NANDFEA2R_ERR_ADDR3_MASK (0x000003FFu)
#define CSL_EMIF16_NANDFEA2R_ERR_ADDR3_SHIFT (0x00000000u)
#define CSL_EMIF16_NANDFEA2R_ERR_ADDR3_RESETVAL (0x00000000u)

#define CSL_EMIF16_NANDFEA2R_RESETVAL    (0x00000000u)

/* NANDFEV1R */


#define CSL_EMIF16_NANDFEV1R_ERR_VALUE2_MASK (0x03FF0000u)
#define CSL_EMIF16_NANDFEV1R_ERR_VALUE2_SHIFT (0x00000010u)
#define CSL_EMIF16_NANDFEV1R_ERR_VALUE2_RESETVAL (0x00000000u)


#define CSL_EMIF16_NANDFEV1R_ERR_VALUE1_MASK (0x000003FFu)
#define CSL_EMIF16_NANDFEV1R_ERR_VALUE1_SHIFT (0x00000000u)
#define CSL_EMIF16_NANDFEV1R_ERR_VALUE1_RESETVAL (0x00000000u)

#define CSL_EMIF16_NANDFEV1R_RESETVAL    (0x00000000u)

/* NANDFEV2R */


#define CSL_EMIF16_NANDFEV2R_ERR_VALUE4_MASK (0x03FF0000u)
#define CSL_EMIF16_NANDFEV2R_ERR_VALUE4_SHIFT (0x00000010u)
#define CSL_EMIF16_NANDFEV2R_ERR_VALUE4_RESETVAL (0x00000000u)


#define CSL_EMIF16_NANDFEV2R_ERR_VALUE3_MASK (0x000003FFu)
#define CSL_EMIF16_NANDFEV2R_ERR_VALUE3_SHIFT (0x00000000u)
#define CSL_EMIF16_NANDFEV2R_ERR_VALUE3_RESETVAL (0x00000000u)

#define CSL_EMIF16_NANDFEV2R_RESETVAL    (0x00000000u)

#endif
