/********************************************************************
* Copyright (C) 2003-2008 Texas Instruments Incorporated.
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/
#ifndef _CSLR_CPSW_3GF_H_
#define _CSLR_CPSW_3GF_H_

/* Modified by CSL team for:
 *      (1) Header files are included to be RTSC compliant
 */

#include <ti/csl/cslr.h>
#include <ti/csl/tistdtypes.h>


/* Minimum unit = 1 byte */

/**************************************************************************\
* Register Overlay Structure for port_info_group
\**************************************************************************/
typedef struct  {
    volatile Uint32 P_MAX_BLKS_REG;
    volatile Uint32 P_BLK_CNT_REG;
    volatile Uint32 P_PORT_VLAN_REG;
    volatile Uint32 P_TX_PRI_MAP_REG;
    volatile Uint32 SL_SA_LO_REG;
    volatile Uint32 SL_SA_HI_REG;
    volatile Uint32 P_TS_CTL_REG;
    volatile Uint32 P_TS_SEQ_LTYPE_REG;
    volatile Uint32 P_TS_VLAN_LTYPE_REG;
    volatile Uint8  RSVD2[12];
} CSL_Cpsw_3gfPort_info_groupRegs;

/**************************************************************************\
* Register Overlay Structure for port_stats_group
\**************************************************************************/
typedef struct  {
    volatile Uint32 RXGOODFRAMES;
    volatile Uint32 RXBROADCASTFRAMES;
    volatile Uint32 RXMULTICASTFRAMES;
    volatile Uint32 RXPAUSEFRAMES;
    volatile Uint32 RXCRCERRORS;
    volatile Uint32 RXALIGNCODEERRORS;
    volatile Uint32 RXOVERSIZEDFRAMES;
    volatile Uint32 RXJABBERFRAMES;
    volatile Uint32 RXUNDERSIZEDFRAMES;
    volatile Uint32 RXFRAGMENTS;
    volatile Uint8  RSVD0[8];
    volatile Uint32 RXOCTETS;
    volatile Uint32 TXGOODFRAMES;
    volatile Uint32 TXBROADCASTFRAMES;
    volatile Uint32 TXMULTICASTFRAMES;
    volatile Uint32 TXPAUSEFRAMES;
    volatile Uint32 TXDEFERREDFRAMES;
    volatile Uint32 TXCOLLISIONFRAMES;
    volatile Uint32 TXSINGLECOLLFRAMES;
    volatile Uint32 TXMULTCOLLFRAMES;
    volatile Uint32 TXEXCESSIVECOLLISIONS;
    volatile Uint32 TXLATECOLLISIONS;
    volatile Uint32 TXUNDERRUN;
    volatile Uint32 TXCARRIERSENSEERRORS;
    volatile Uint32 TXOCTETS;
    volatile Uint32 OCTETFRAMES64;
    volatile Uint32 OCTETFRAMES65T127;
    volatile Uint32 OCTETFRAMES128T255;
    volatile Uint32 OCTETFRAMES256T511;
    volatile Uint32 OCTETFRAMES512T1023;
    volatile Uint32 OCTETFRAMES1024TUP;
    volatile Uint32 NETOCTETS;
    volatile Uint32 RXSOFOVERRUNS;
    volatile Uint32 RXMOFOVERRUNS;
    volatile Uint32 RXDMAOVERRUNS;
    volatile Uint8  RSVD4[112];
} CSL_Cpsw_3gfPort_stats_groupRegs;

/**************************************************************************\
* Register Overlay Structure
\**************************************************************************/
typedef struct  {
    volatile Uint32 CPSW_ID_VER_REG;
    volatile Uint32 CPSW_CONTROL_REG;
    volatile Uint32 EM_CONTROL_REG;
    volatile Uint32 STAT_PORT_EN_REG;
    volatile Uint32 PTYPE_REG;
    volatile Uint8  RSVD0[8];
    volatile Uint32 GAP_THRESH_CPGMAC_SL_REG;
    volatile Uint32 TX_START_WDS_REG;
    volatile Uint32 FLOW_CONTROL_REG;
    volatile Uint8  RSVD1[12];
    volatile Uint32 P0_CPPI_SRC_ID_REG;
    volatile Uint32 P0_PORT_VLAN_REG;
    volatile Uint32 P0_RX_PRI_MAP_REG;
    volatile Uint32 RX_MAXLEN_REG;
    volatile Uint8  RSVD3[28];
    CSL_Cpsw_3gfPort_info_groupRegs PORT_INFO_GROUP[2];
    volatile Uint8  RSVD5[576];
    CSL_Cpsw_3gfPort_stats_groupRegs PORT_STATS_GROUP[2];
    volatile Uint8  RSVD6[256];
    volatile Uint32 ALE_ID_REG;
    volatile Uint8  RSVD7[4];
    volatile Uint32 ALE_CONTROL_REG;
    volatile Uint8  RSVD8[4];
    volatile Uint32 ALE_PRESCALE_REG;
    volatile Uint8  RSVD9[4];
    volatile Uint32 ALE_UNKNOWN_VLAN_REG;
    volatile Uint8  RSVD10[4];
    volatile Uint32 ALE_TABLE_CONTROL_REG;
    volatile Uint8  RSVD11[16];
    volatile Uint32 ALE_TABLE_WORD2_REG;
    volatile Uint32 ALE_TABLE_WORD1_REG;
    volatile Uint32 ALE_TABLE_WORD0_REG;
    volatile Uint32 ALE_PORT_CONTROL_REG[3];
    volatile Uint8  RSVD12[12];
} CSL_Cpsw_3gfRegs;

/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* p_max_blks_reg */

#define CSL_CPSW_3GF_P_MAX_BLKS_REG_RX_MAX_BLKS_MASK (0x0000000Fu)
#define CSL_CPSW_3GF_P_MAX_BLKS_REG_RX_MAX_BLKS_SHIFT (0x00000000u)
#define CSL_CPSW_3GF_P_MAX_BLKS_REG_RX_MAX_BLKS_RESETVAL (0x00000003u)

#define CSL_CPSW_3GF_P_MAX_BLKS_REG_TX_MAX_BLKS_MASK (0x000001F0u)
#define CSL_CPSW_3GF_P_MAX_BLKS_REG_TX_MAX_BLKS_SHIFT (0x00000004u)
#define CSL_CPSW_3GF_P_MAX_BLKS_REG_TX_MAX_BLKS_RESETVAL (0x00000011u)

#define CSL_CPSW_3GF_P_MAX_BLKS_REG_RESETVAL (0x00000113u)

/* p_blk_cnt_reg */

#define CSL_CPSW_3GF_P_BLK_CNT_REG_RX_BLK_CNT_MASK (0x0000000Fu)
#define CSL_CPSW_3GF_P_BLK_CNT_REG_RX_BLK_CNT_SHIFT (0x00000000u)
#define CSL_CPSW_3GF_P_BLK_CNT_REG_RX_BLK_CNT_RESETVAL (0x00000001u)

#define CSL_CPSW_3GF_P_BLK_CNT_REG_TX_BLK_CNT_MASK (0x000001F0u)
#define CSL_CPSW_3GF_P_BLK_CNT_REG_TX_BLK_CNT_SHIFT (0x00000004u)
#define CSL_CPSW_3GF_P_BLK_CNT_REG_TX_BLK_CNT_RESETVAL (0x00000004u)

#define CSL_CPSW_3GF_P_BLK_CNT_REG_RESETVAL (0x00000041u)

/* p_port_vlan_reg */

#define CSL_CPSW_3GF_P_PORT_VLAN_REG_PORT_VID_MASK (0x00000FFFu)
#define CSL_CPSW_3GF_P_PORT_VLAN_REG_PORT_VID_SHIFT (0x00000000u)
#define CSL_CPSW_3GF_P_PORT_VLAN_REG_PORT_VID_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_P_PORT_VLAN_REG_PORT_CFI_MASK (0x00001000u)
#define CSL_CPSW_3GF_P_PORT_VLAN_REG_PORT_CFI_SHIFT (0x0000000Cu)
#define CSL_CPSW_3GF_P_PORT_VLAN_REG_PORT_CFI_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_P_PORT_VLAN_REG_PORT_PRI_MASK (0x0000E000u)
#define CSL_CPSW_3GF_P_PORT_VLAN_REG_PORT_PRI_SHIFT (0x0000000Du)
#define CSL_CPSW_3GF_P_PORT_VLAN_REG_PORT_PRI_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_P_PORT_VLAN_REG_RESETVAL (0x00000000u)

/* p_tx_pri_map_reg */

#define CSL_CPSW_3GF_P_TX_PRI_MAP_REG_PRI0_MASK (0x00000003u)
#define CSL_CPSW_3GF_P_TX_PRI_MAP_REG_PRI0_SHIFT (0x00000000u)
#define CSL_CPSW_3GF_P_TX_PRI_MAP_REG_PRI0_RESETVAL (0x00000001u)

#define CSL_CPSW_3GF_P_TX_PRI_MAP_REG_PRI1_MASK (0x00000030u)
#define CSL_CPSW_3GF_P_TX_PRI_MAP_REG_PRI1_SHIFT (0x00000004u)
#define CSL_CPSW_3GF_P_TX_PRI_MAP_REG_PRI1_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_P_TX_PRI_MAP_REG_PRI2_MASK (0x00000300u)
#define CSL_CPSW_3GF_P_TX_PRI_MAP_REG_PRI2_SHIFT (0x00000008u)
#define CSL_CPSW_3GF_P_TX_PRI_MAP_REG_PRI2_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_P_TX_PRI_MAP_REG_PRI3_MASK (0x00003000u)
#define CSL_CPSW_3GF_P_TX_PRI_MAP_REG_PRI3_SHIFT (0x0000000Cu)
#define CSL_CPSW_3GF_P_TX_PRI_MAP_REG_PRI3_RESETVAL (0x00000001u)

#define CSL_CPSW_3GF_P_TX_PRI_MAP_REG_PRI4_MASK (0x00030000u)
#define CSL_CPSW_3GF_P_TX_PRI_MAP_REG_PRI4_SHIFT (0x00000010u)
#define CSL_CPSW_3GF_P_TX_PRI_MAP_REG_PRI4_RESETVAL (0x00000002u)

#define CSL_CPSW_3GF_P_TX_PRI_MAP_REG_PRI5_MASK (0x00300000u)
#define CSL_CPSW_3GF_P_TX_PRI_MAP_REG_PRI5_SHIFT (0x00000014u)
#define CSL_CPSW_3GF_P_TX_PRI_MAP_REG_PRI5_RESETVAL (0x00000002u)

#define CSL_CPSW_3GF_P_TX_PRI_MAP_REG_PRI6_MASK (0x03000000u)
#define CSL_CPSW_3GF_P_TX_PRI_MAP_REG_PRI6_SHIFT (0x00000018u)
#define CSL_CPSW_3GF_P_TX_PRI_MAP_REG_PRI6_RESETVAL (0x00000003u)

#define CSL_CPSW_3GF_P_TX_PRI_MAP_REG_PRI7_MASK (0x30000000u)
#define CSL_CPSW_3GF_P_TX_PRI_MAP_REG_PRI7_SHIFT (0x0000001Cu)
#define CSL_CPSW_3GF_P_TX_PRI_MAP_REG_PRI7_RESETVAL (0x00000003u)

#define CSL_CPSW_3GF_P_TX_PRI_MAP_REG_RESETVAL (0x33221001u)

/* sl_sa_lo_reg */

#define CSL_CPSW_3GF_SL_SA_LO_REG_MACSRCADDR_7_0_MASK (0x0000FF00u)       
#define CSL_CPSW_3GF_SL_SA_LO_REG_MACSRCADDR_7_0_SHIFT (0x00000008u)      
#define CSL_CPSW_3GF_SL_SA_LO_REG_MACSRCADDR_7_0_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_SL_SA_LO_REG_MACSRCADDR_15_8_MASK (0x000000FFu)      
#define CSL_CPSW_3GF_SL_SA_LO_REG_MACSRCADDR_15_8_SHIFT (0x00000000u)     
#define CSL_CPSW_3GF_SL_SA_LO_REG_MACSRCADDR_15_8_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_SL_SA_LO_REG_RESETVAL (0x00000000u)

/* sl_sa_hi_reg */

#define CSL_CPSW_3GF_SL_SA_HI_REG_MACSRCADDR_47_40_MASK (0x000000FFu)
#define CSL_CPSW_3GF_SL_SA_HI_REG_MACSRCADDR_47_40_SHIFT (0x00000000u)
#define CSL_CPSW_3GF_SL_SA_HI_REG_MACSRCADDR_47_40_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_SL_SA_HI_REG_MACSRCADDR_39_32_MASK (0x0000FF00u)
#define CSL_CPSW_3GF_SL_SA_HI_REG_MACSRCADDR_39_32_SHIFT (0x00000008u)
#define CSL_CPSW_3GF_SL_SA_HI_REG_MACSRCADDR_39_32_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_SL_SA_HI_REG_MACSRCADDR_31_24_MASK (0x00FF0000u)
#define CSL_CPSW_3GF_SL_SA_HI_REG_MACSRCADDR_31_24_SHIFT (0x00000010u)
#define CSL_CPSW_3GF_SL_SA_HI_REG_MACSRCADDR_31_24_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_SL_SA_HI_REG_MACSRCADDR_23_16_MASK (0xFF000000u)
#define CSL_CPSW_3GF_SL_SA_HI_REG_MACSRCADDR_23_16_SHIFT (0x00000018u)
#define CSL_CPSW_3GF_SL_SA_HI_REG_MACSRCADDR_23_16_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_SL_SA_HI_REG_RESETVAL (0x00000000u)

/* p_ts_ctl_reg */

#define CSL_CPSW_3GF_P_TS_CTL_REG_TX_MSG_TYPE_EN_15_0_MASK (0xFFFF0000u)
#define CSL_CPSW_3GF_P_TS_CTL_REG_TX_MSG_TYPE_EN_15_0_SHIFT (0x00000010u)
#define CSL_CPSW_3GF_P_TS_CTL_REG_TX_MSG_TYPE_EN_15_0_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_P_TS_CTL_REG_TS_TX_VLAN_LTYPE2_EN_MASK (0x00000040u)
#define CSL_CPSW_3GF_P_TS_CTL_REG_TS_TX_VLAN_LTYPE2_EN_SHIFT (0x00000006u)
#define CSL_CPSW_3GF_P_TS_CTL_REG_TS_TX_VLAN_LTYPE2_EN_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_P_TS_CTL_REG_TS_TX_VLAN_LTYPE1_EN_MASK (0x00000020u)
#define CSL_CPSW_3GF_P_TS_CTL_REG_TS_TX_VLAN_LTYPE1_EN_SHIFT (0x00000005u)
#define CSL_CPSW_3GF_P_TS_CTL_REG_TS_TX_VLAN_LTYPE1_EN_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_P_TS_CTL_REG_TS_TX_EN_MASK (0x00000010u)
#define CSL_CPSW_3GF_P_TS_CTL_REG_TS_TX_EN_SHIFT (0x00000004u)
#define CSL_CPSW_3GF_P_TS_CTL_REG_TS_TX_EN_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_P_TS_CTL_REG_TS_RX_VLAN_LTYPE2_EN_MASK (0x00000004u)
#define CSL_CPSW_3GF_P_TS_CTL_REG_TS_RX_VLAN_LTYPE2_EN_SHIFT (0x00000002u)
#define CSL_CPSW_3GF_P_TS_CTL_REG_TS_RX_VLAN_LTYPE2_EN_RESETVAL (0x00000000u)


#define CSL_CPSW_3GF_P_TS_CTL_REG_TS_RX_VLAN_LTYPE1_EN_MASK (0x00000002u)       
#define CSL_CPSW_3GF_P_TS_CTL_REG_TS_RX_VLAN_LTYPE1_EN_SHIFT (0x00000001u)      
#define CSL_CPSW_3GF_P_TS_CTL_REG_TS_RX_VLAN_LTYPE1_EN_RESETVAL (0x00000000u)   


#define CSL_CPSW_3GF_P_TS_CTL_REG_TS_RX_EN_MASK (0x00000001u)                   
#define CSL_CPSW_3GF_P_TS_CTL_REG_TS_RX_EN_SHIFT (0x00000000u)                  
#define CSL_CPSW_3GF_P_TS_CTL_REG_TS_RX_EN_RESETVAL (0x00000000u)               

#define CSL_CPSW_3GF_P_TS_CTL_REG_RESETVAL (0x00000000u)

/* p_ts_seq_ltype_reg */

#define CSL_CPSW_3GF_P_TS_SEQ_LTYPE_REG_TS_SEQ_ID_OFFSET_MASK (0x003F0000u)
#define CSL_CPSW_3GF_P_TS_SEQ_LTYPE_REG_TS_SEQ_ID_OFFSET_SHIFT (0x00000010u)
#define CSL_CPSW_3GF_P_TS_SEQ_LTYPE_REG_TS_SEQ_ID_OFFSET_RESETVAL (0x0000001Eu)

#define CSL_CPSW_3GF_P_TS_SEQ_LTYPE_REG_TS_LTYPE_MASK (0x0000FFFFu)
#define CSL_CPSW_3GF_P_TS_SEQ_LTYPE_REG_TS_LTYPE_SHIFT (0x00000000u)
#define CSL_CPSW_3GF_P_TS_SEQ_LTYPE_REG_TS_LTYPE_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_P_TS_SEQ_LTYPE_REG_RESETVAL (0x001E0000u)

/* p_ts_vlan_ltype_reg */

#define CSL_CPSW_3GF_P_TS_VLAN_LTYPE_REG_TS_VLAN_LTYPE2_MASK (0xFFFF0000u)
#define CSL_CPSW_3GF_P_TS_VLAN_LTYPE_REG_TS_VLAN_LTYPE2_SHIFT (0x00000010u)
#define CSL_CPSW_3GF_P_TS_VLAN_LTYPE_REG_TS_VLAN_LTYPE2_RESETVAL (0x00008100u)

#define CSL_CPSW_3GF_P_TS_VLAN_LTYPE_REG_TS_VLAN_LTYPE1_MASK (0x0000FFFFu)
#define CSL_CPSW_3GF_P_TS_VLAN_LTYPE_REG_TS_VLAN_LTYPE1_SHIFT (0x00000000u)
#define CSL_CPSW_3GF_P_TS_VLAN_LTYPE_REG_TS_VLAN_LTYPE1_RESETVAL (0x00008100u)

#define CSL_CPSW_3GF_P_TS_VLAN_LTYPE_REG_RESETVAL (0x81008100u)

/* RxGoodFrames */

#define CSL_CPSW_3GF_RXGOODFRAMES_COUNT_MASK (0xFFFFFFFFu)
#define CSL_CPSW_3GF_RXGOODFRAMES_COUNT_SHIFT (0x00000000u)
#define CSL_CPSW_3GF_RXGOODFRAMES_COUNT_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_RXGOODFRAMES_RESETVAL (0x00000000u)

/* RxBroadcastFrames */

#define CSL_CPSW_3GF_RXBROADCASTFRAMES_COUNT_MASK (0xFFFFFFFFu)
#define CSL_CPSW_3GF_RXBROADCASTFRAMES_COUNT_SHIFT (0x00000000u)
#define CSL_CPSW_3GF_RXBROADCASTFRAMES_COUNT_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_RXBROADCASTFRAMES_RESETVAL (0x00000000u)

/* RxMulticastFrames */

#define CSL_CPSW_3GF_RXMULTICASTFRAMES_COUNT_MASK (0xFFFFFFFFu)
#define CSL_CPSW_3GF_RXMULTICASTFRAMES_COUNT_SHIFT (0x00000000u)
#define CSL_CPSW_3GF_RXMULTICASTFRAMES_COUNT_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_RXMULTICASTFRAMES_RESETVAL (0x00000000u)

/* RxPauseFrames */

#define CSL_CPSW_3GF_RXPAUSEFRAMES_COUNT_MASK (0xFFFFFFFFu)
#define CSL_CPSW_3GF_RXPAUSEFRAMES_COUNT_SHIFT (0x00000000u)
#define CSL_CPSW_3GF_RXPAUSEFRAMES_COUNT_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_RXPAUSEFRAMES_RESETVAL (0x00000000u)

/* RxCRCErrors */

#define CSL_CPSW_3GF_RXCRCERRORS_COUNT_MASK (0xFFFFFFFFu)
#define CSL_CPSW_3GF_RXCRCERRORS_COUNT_SHIFT (0x00000000u)
#define CSL_CPSW_3GF_RXCRCERRORS_COUNT_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_RXCRCERRORS_RESETVAL (0x00000000u)

/* RxAlignCodeErrors */

#define CSL_CPSW_3GF_RXALIGNCODEERRORS_COUNT_MASK (0xFFFFFFFFu)
#define CSL_CPSW_3GF_RXALIGNCODEERRORS_COUNT_SHIFT (0x00000000u)
#define CSL_CPSW_3GF_RXALIGNCODEERRORS_COUNT_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_RXALIGNCODEERRORS_RESETVAL (0x00000000u)

/* RxOversizedFrames */

#define CSL_CPSW_3GF_RXOVERSIZEDFRAMES_COUNT_MASK (0xFFFFFFFFu)
#define CSL_CPSW_3GF_RXOVERSIZEDFRAMES_COUNT_SHIFT (0x00000000u)
#define CSL_CPSW_3GF_RXOVERSIZEDFRAMES_COUNT_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_RXOVERSIZEDFRAMES_RESETVAL (0x00000000u)

/* RxJabberFrames */

#define CSL_CPSW_3GF_RXJABBERFRAMES_COUNT_MASK (0xFFFFFFFFu)
#define CSL_CPSW_3GF_RXJABBERFRAMES_COUNT_SHIFT (0x00000000u)
#define CSL_CPSW_3GF_RXJABBERFRAMES_COUNT_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_RXJABBERFRAMES_RESETVAL (0x00000000u)

/* RxUndersizedFrames */

#define CSL_CPSW_3GF_RXUNDERSIZEDFRAMES_COUNT_MASK (0xFFFFFFFFu)
#define CSL_CPSW_3GF_RXUNDERSIZEDFRAMES_COUNT_SHIFT (0x00000000u)
#define CSL_CPSW_3GF_RXUNDERSIZEDFRAMES_COUNT_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_RXUNDERSIZEDFRAMES_RESETVAL (0x00000000u)

/* RxFragments */

#define CSL_CPSW_3GF_RXFRAGMENTS_COUNT_MASK (0xFFFFFFFFu)
#define CSL_CPSW_3GF_RXFRAGMENTS_COUNT_SHIFT (0x00000000u)
#define CSL_CPSW_3GF_RXFRAGMENTS_COUNT_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_RXFRAGMENTS_RESETVAL (0x00000000u)

/* RxOctets */

#define CSL_CPSW_3GF_RXOCTETS_COUNT_MASK (0xFFFFFFFFu)
#define CSL_CPSW_3GF_RXOCTETS_COUNT_SHIFT (0x00000000u)
#define CSL_CPSW_3GF_RXOCTETS_COUNT_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_RXOCTETS_RESETVAL   (0x00000000u)

/* TxGoodFrames */

#define CSL_CPSW_3GF_TXGOODFRAMES_COUNT_MASK (0xFFFFFFFFu)
#define CSL_CPSW_3GF_TXGOODFRAMES_COUNT_SHIFT (0x00000000u)
#define CSL_CPSW_3GF_TXGOODFRAMES_COUNT_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_TXGOODFRAMES_RESETVAL (0x00000000u)

/* TxBroadcastFrames */

#define CSL_CPSW_3GF_TXBROADCASTFRAMES_COUNT_MASK (0xFFFFFFFFu)
#define CSL_CPSW_3GF_TXBROADCASTFRAMES_COUNT_SHIFT (0x00000000u)
#define CSL_CPSW_3GF_TXBROADCASTFRAMES_COUNT_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_TXBROADCASTFRAMES_RESETVAL (0x00000000u)

/* TxMulticastFrames */

#define CSL_CPSW_3GF_TXMULTICASTFRAMES_COUNT_MASK (0xFFFFFFFFu)
#define CSL_CPSW_3GF_TXMULTICASTFRAMES_COUNT_SHIFT (0x00000000u)
#define CSL_CPSW_3GF_TXMULTICASTFRAMES_COUNT_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_TXMULTICASTFRAMES_RESETVAL (0x00000000u)

/* TxPauseFrames */

#define CSL_CPSW_3GF_TXPAUSEFRAMES_COUNT_MASK (0xFFFFFFFFu)
#define CSL_CPSW_3GF_TXPAUSEFRAMES_COUNT_SHIFT (0x00000000u)
#define CSL_CPSW_3GF_TXPAUSEFRAMES_COUNT_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_TXPAUSEFRAMES_RESETVAL (0x00000000u)

/* TxDeferredFrames */

#define CSL_CPSW_3GF_TXDEFERREDFRAMES_COUNT_MASK (0xFFFFFFFFu)
#define CSL_CPSW_3GF_TXDEFERREDFRAMES_COUNT_SHIFT (0x00000000u)
#define CSL_CPSW_3GF_TXDEFERREDFRAMES_COUNT_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_TXDEFERREDFRAMES_RESETVAL (0x00000000u)

/* TxCollisionFrames */

#define CSL_CPSW_3GF_TXCOLLISIONFRAMES_COUNT_MASK (0xFFFFFFFFu)
#define CSL_CPSW_3GF_TXCOLLISIONFRAMES_COUNT_SHIFT (0x00000000u)
#define CSL_CPSW_3GF_TXCOLLISIONFRAMES_COUNT_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_TXCOLLISIONFRAMES_RESETVAL (0x00000000u)

/* TxSingleCollFrames */

#define CSL_CPSW_3GF_TXSINGLECOLLFRAMES_COUNT_MASK (0xFFFFFFFFu)
#define CSL_CPSW_3GF_TXSINGLECOLLFRAMES_COUNT_SHIFT (0x00000000u)
#define CSL_CPSW_3GF_TXSINGLECOLLFRAMES_COUNT_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_TXSINGLECOLLFRAMES_RESETVAL (0x00000000u)

/* TxMultCollFrames */

#define CSL_CPSW_3GF_TXMULTCOLLFRAMES_COUNT_MASK (0xFFFFFFFFu)
#define CSL_CPSW_3GF_TXMULTCOLLFRAMES_COUNT_SHIFT (0x00000000u)
#define CSL_CPSW_3GF_TXMULTCOLLFRAMES_COUNT_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_TXMULTCOLLFRAMES_RESETVAL (0x00000000u)

/* TxExcessiveCollisions */

#define CSL_CPSW_3GF_TXEXCESSIVECOLLISIONS_COUNT_MASK (0xFFFFFFFFu)
#define CSL_CPSW_3GF_TXEXCESSIVECOLLISIONS_COUNT_SHIFT (0x00000000u)
#define CSL_CPSW_3GF_TXEXCESSIVECOLLISIONS_COUNT_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_TXEXCESSIVECOLLISIONS_RESETVAL (0x00000000u)

/* TxLateCollisions */

#define CSL_CPSW_3GF_TXLATECOLLISIONS_COUNT_MASK (0xFFFFFFFFu)
#define CSL_CPSW_3GF_TXLATECOLLISIONS_COUNT_SHIFT (0x00000000u)
#define CSL_CPSW_3GF_TXLATECOLLISIONS_COUNT_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_TXLATECOLLISIONS_RESETVAL (0x00000000u)

/* TxUnderrun */

#define CSL_CPSW_3GF_TXUNDERRUN_COUNT_MASK (0xFFFFFFFFu)
#define CSL_CPSW_3GF_TXUNDERRUN_COUNT_SHIFT (0x00000000u)
#define CSL_CPSW_3GF_TXUNDERRUN_COUNT_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_TXUNDERRUN_RESETVAL (0x00000000u)

/* TxCarrierSenseErrors */

#define CSL_CPSW_3GF_TXCARRIERSENSEERRORS_COUNT_MASK (0xFFFFFFFFu)
#define CSL_CPSW_3GF_TXCARRIERSENSEERRORS_COUNT_SHIFT (0x00000000u)
#define CSL_CPSW_3GF_TXCARRIERSENSEERRORS_COUNT_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_TXCARRIERSENSEERRORS_RESETVAL (0x00000000u)

/* TxOctets */

#define CSL_CPSW_3GF_TXOCTETS_COUNT_MASK (0xFFFFFFFFu)
#define CSL_CPSW_3GF_TXOCTETS_COUNT_SHIFT (0x00000000u)
#define CSL_CPSW_3GF_TXOCTETS_COUNT_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_TXOCTETS_RESETVAL   (0x00000000u)

/* 64octetFrames */

#define CSL_CPSW_3GF_OCTETFRAMES64_COUNT_MASK (0xFFFFFFFFu)
#define CSL_CPSW_3GF_OCTETFRAMES64_COUNT_SHIFT (0x00000000u)
#define CSL_CPSW_3GF_OCTETFRAMES64_COUNT_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_OCTETFRAMES64_RESETVAL (0x00000000u)

/* 65t127octetFrames */

#define CSL_CPSW_3GF_OCTETFRAMES65T127_COUNT_MASK (0xFFFFFFFFu)
#define CSL_CPSW_3GF_OCTETFRAMES65T127_COUNT_SHIFT (0x00000000u)
#define CSL_CPSW_3GF_OCTETFRAMES65T127_COUNT_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_OCTETFRAMES65T127_RESETVAL (0x00000000u)

/* 128t255octetFrames */

#define CSL_CPSW_3GF_OCTETFRAMES128T255_COUNT_MASK (0xFFFFFFFFu)
#define CSL_CPSW_3GF_OCTETFRAMES128T255_COUNT_SHIFT (0x00000000u)
#define CSL_CPSW_3GF_OCTETFRAMES128T255_COUNT_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_OCTETFRAMES128T255_RESETVAL (0x00000000u)

/* 256t511octetFrames */

#define CSL_CPSW_3GF_OCTETFRAMES256T511_COUNT_MASK (0xFFFFFFFFu)
#define CSL_CPSW_3GF_OCTETFRAMES256T511_COUNT_SHIFT (0x00000000u)
#define CSL_CPSW_3GF_OCTETFRAMES256T511_COUNT_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_OCTETFRAMES256T511_RESETVAL (0x00000000u)

/* 512t1023octetFrames */

#define CSL_CPSW_3GF_OCTETFRAMES512T1023_COUNT_MASK (0xFFFFFFFFu)
#define CSL_CPSW_3GF_OCTETFRAMES512T1023_COUNT_SHIFT (0x00000000u)
#define CSL_CPSW_3GF_OCTETFRAMES512T1023_COUNT_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_OCTETFRAMES512T1023_RESETVAL (0x00000000u)

/* 1024tUPoctetFrames */

#define CSL_CPSW_3GF_OCTETFRAMES1024TUP_COUNT_MASK (0xFFFFFFFFu)
#define CSL_CPSW_3GF_OCTETFRAMES1024TUP_COUNT_SHIFT (0x00000000u)
#define CSL_CPSW_3GF_OCTETFRAMES1024TUP_COUNT_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_OCTETFRAMES1024TUP_RESETVAL (0x00000000u)

/* NetOctets */

#define CSL_CPSW_3GF_NETOCTETS_COUNT_MASK (0xFFFFFFFFu)
#define CSL_CPSW_3GF_NETOCTETS_COUNT_SHIFT (0x00000000u)
#define CSL_CPSW_3GF_NETOCTETS_COUNT_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_NETOCTETS_RESETVAL  (0x00000000u)

/* RxSofOverruns */

#define CSL_CPSW_3GF_RXSOFOVERRUNS_COUNT_MASK (0xFFFFFFFFu)
#define CSL_CPSW_3GF_RXSOFOVERRUNS_COUNT_SHIFT (0x00000000u)
#define CSL_CPSW_3GF_RXSOFOVERRUNS_COUNT_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_RXSOFOVERRUNS_RESETVAL (0x00000000u)

/* RxMofOverruns */

#define CSL_CPSW_3GF_RXMOFOVERRUNS_COUNT_MASK (0xFFFFFFFFu)
#define CSL_CPSW_3GF_RXMOFOVERRUNS_COUNT_SHIFT (0x00000000u)
#define CSL_CPSW_3GF_RXMOFOVERRUNS_COUNT_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_RXMOFOVERRUNS_RESETVAL (0x00000000u)

/* RxDmaOverruns */

#define CSL_CPSW_3GF_RXDMAOVERRUNS_COUNT_MASK (0xFFFFFFFFu)
#define CSL_CPSW_3GF_RXDMAOVERRUNS_COUNT_SHIFT (0x00000000u)
#define CSL_CPSW_3GF_RXDMAOVERRUNS_COUNT_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_RXDMAOVERRUNS_RESETVAL (0x00000000u)

/* cpsw_id_ver_reg */

#define CSL_CPSW_3GF_CPSW_ID_VER_REG_CPSW_3GF_MINOR_VER_MASK (0x000000FFu)
#define CSL_CPSW_3GF_CPSW_ID_VER_REG_CPSW_3GF_MINOR_VER_SHIFT (0x00000000u)
#define CSL_CPSW_3GF_CPSW_ID_VER_REG_CPSW_3GF_MINOR_VER_RESETVAL (0x00000007u)

#define CSL_CPSW_3GF_CPSW_ID_VER_REG_CPSW_3GF_MAJ_VER_MASK (0x00000700u)
#define CSL_CPSW_3GF_CPSW_ID_VER_REG_CPSW_3GF_MAJ_VER_SHIFT (0x00000008u)
#define CSL_CPSW_3GF_CPSW_ID_VER_REG_CPSW_3GF_MAJ_VER_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_CPSW_ID_VER_REG_CPSW_3GF_RTL_VER_MASK (0x0000F800u)
#define CSL_CPSW_3GF_CPSW_ID_VER_REG_CPSW_3GF_RTL_VER_SHIFT (0x0000000Bu)
#define CSL_CPSW_3GF_CPSW_ID_VER_REG_CPSW_3GF_RTL_VER_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_CPSW_ID_VER_REG_CPSW_3GF_IDENT_MASK (0xFFFF0000u)
#define CSL_CPSW_3GF_CPSW_ID_VER_REG_CPSW_3GF_IDENT_SHIFT (0x00000010u)
#define CSL_CPSW_3GF_CPSW_ID_VER_REG_CPSW_3GF_IDENT_RESETVAL (0x00004ED8u)

#define CSL_CPSW_3GF_CPSW_ID_VER_REG_RESETVAL (0x4ED80007u)

/* cpsw_control_reg */

#define CSL_CPSW_3GF_CPSW_CONTROL_REG_FIFO_LOOPBACK_MASK (0x00000001u)
#define CSL_CPSW_3GF_CPSW_CONTROL_REG_FIFO_LOOPBACK_SHIFT (0x00000000u)
#define CSL_CPSW_3GF_CPSW_CONTROL_REG_FIFO_LOOPBACK_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_CPSW_CONTROL_REG_VLAN_AWARE_MASK (0x00000002u)
#define CSL_CPSW_3GF_CPSW_CONTROL_REG_VLAN_AWARE_SHIFT (0x00000001u)
#define CSL_CPSW_3GF_CPSW_CONTROL_REG_VLAN_AWARE_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_CPSW_CONTROL_REG_P0_ENABLE_MASK (0x00000004u)
#define CSL_CPSW_3GF_CPSW_CONTROL_REG_P0_ENABLE_SHIFT (0x00000002u)
#define CSL_CPSW_3GF_CPSW_CONTROL_REG_P0_ENABLE_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_CPSW_CONTROL_REG_P0_PASS_PRI_TAGGED_MASK (0x00000010u)
#define CSL_CPSW_3GF_CPSW_CONTROL_REG_P0_PASS_PRI_TAGGED_SHIFT (0x00000004u)
#define CSL_CPSW_3GF_CPSW_CONTROL_REG_P0_PASS_PRI_TAGGED_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_CPSW_CONTROL_REG_P1_PASS_PRI_TAGGED_MASK (0x00000020u)
#define CSL_CPSW_3GF_CPSW_CONTROL_REG_P1_PASS_PRI_TAGGED_SHIFT (0x00000005u)
#define CSL_CPSW_3GF_CPSW_CONTROL_REG_P1_PASS_PRI_TAGGED_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_CPSW_CONTROL_REG_P2_PASS_PRI_TAGGED_MASK (0x00000040u)
#define CSL_CPSW_3GF_CPSW_CONTROL_REG_P2_PASS_PRI_TAGGED_SHIFT (0x00000006u)
#define CSL_CPSW_3GF_CPSW_CONTROL_REG_P2_PASS_PRI_TAGGED_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_CPSW_CONTROL_REG_RESETVAL (0x00000000u)

/* em_control_reg */

#define CSL_CPSW_3GF_EM_CONTROL_REG_FREE_MASK (0x00000001u)
#define CSL_CPSW_3GF_EM_CONTROL_REG_FREE_SHIFT (0x00000000u)
#define CSL_CPSW_3GF_EM_CONTROL_REG_FREE_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_EM_CONTROL_REG_SOFT_MASK (0x00000002u)
#define CSL_CPSW_3GF_EM_CONTROL_REG_SOFT_SHIFT (0x00000001u)
#define CSL_CPSW_3GF_EM_CONTROL_REG_SOFT_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_EM_CONTROL_REG_RESETVAL (0x00000000u)

/* stat_port_en_reg */

#define CSL_CPSW_3GF_STAT_PORT_EN_REG_P0A_STAT_EN_MASK (0x00000001u)
#define CSL_CPSW_3GF_STAT_PORT_EN_REG_P0A_STAT_EN_SHIFT (0x00000000u)
#define CSL_CPSW_3GF_STAT_PORT_EN_REG_P0A_STAT_EN_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_STAT_PORT_EN_REG_P0B_STAT_EN_MASK (0x00000002u)
#define CSL_CPSW_3GF_STAT_PORT_EN_REG_P0B_STAT_EN_SHIFT (0x00000001u)
#define CSL_CPSW_3GF_STAT_PORT_EN_REG_P0B_STAT_EN_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_STAT_PORT_EN_REG_P1_STAT_EN_MASK (0x00000004u)
#define CSL_CPSW_3GF_STAT_PORT_EN_REG_P1_STAT_EN_SHIFT (0x00000002u)
#define CSL_CPSW_3GF_STAT_PORT_EN_REG_P1_STAT_EN_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_STAT_PORT_EN_REG_P2_STAT_EN_MASK (0x00000008u)
#define CSL_CPSW_3GF_STAT_PORT_EN_REG_P2_STAT_EN_SHIFT (0x00000003u)
#define CSL_CPSW_3GF_STAT_PORT_EN_REG_P2_STAT_EN_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_STAT_PORT_EN_REG_RESETVAL (0x00000000u)

/* ptype_reg */

#define CSL_CPSW_3GF_PTYPE_REG_ESC_PRI_LD_VAL_MASK (0x0000001Fu)
#define CSL_CPSW_3GF_PTYPE_REG_ESC_PRI_LD_VAL_SHIFT (0x00000000u)
#define CSL_CPSW_3GF_PTYPE_REG_ESC_PRI_LD_VAL_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_PTYPE_REG_P0_PTYPE_ESC_MASK (0x00000100u)
#define CSL_CPSW_3GF_PTYPE_REG_P0_PTYPE_ESC_SHIFT (0x00000008u)
#define CSL_CPSW_3GF_PTYPE_REG_P0_PTYPE_ESC_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_PTYPE_REG_P1_PTYPE_ESC_MASK (0x00000200u)
#define CSL_CPSW_3GF_PTYPE_REG_P1_PTYPE_ESC_SHIFT (0x00000009u)
#define CSL_CPSW_3GF_PTYPE_REG_P1_PTYPE_ESC_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_PTYPE_REG_P2_PTYPE_ESC_MASK (0x00000400u)
#define CSL_CPSW_3GF_PTYPE_REG_P2_PTYPE_ESC_SHIFT (0x0000000Au)
#define CSL_CPSW_3GF_PTYPE_REG_P2_PTYPE_ESC_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_PTYPE_REG_RESETVAL  (0x00000000u)

/* gap_thresh_cpgmac_sl_reg */

#define CSL_CPSW_3GF_GAP_THRESH_CPGMAC_SL_REG_GAP_THRESH_MASK (0x0000001Fu)
#define CSL_CPSW_3GF_GAP_THRESH_CPGMAC_SL_REG_GAP_THRESH_SHIFT (0x00000000u)
#define CSL_CPSW_3GF_GAP_THRESH_CPGMAC_SL_REG_GAP_THRESH_RESETVAL (0x0000000Bu)

#define CSL_CPSW_3GF_GAP_THRESH_CPGMAC_SL_REG_RESETVAL (0x0000000Bu)

/* tx_start_wds_reg */

#define CSL_CPSW_3GF_TX_START_WDS_REG_TX_START_WDS_MASK (0x000007FFu)
#define CSL_CPSW_3GF_TX_START_WDS_REG_TX_START_WDS_SHIFT (0x00000000u)
#define CSL_CPSW_3GF_TX_START_WDS_REG_TX_START_WDS_RESETVAL (0x00000020u)

#define CSL_CPSW_3GF_TX_START_WDS_REG_RESETVAL (0x00000020u)

/* flow_control_reg */

#define CSL_CPSW_3GF_FLOW_CONTROL_REG_P0_FLOW_EN_MASK (0x00000001u)
#define CSL_CPSW_3GF_FLOW_CONTROL_REG_P0_FLOW_EN_SHIFT (0x00000000u)
#define CSL_CPSW_3GF_FLOW_CONTROL_REG_P0_FLOW_EN_RESETVAL (0x00000001u)

#define CSL_CPSW_3GF_FLOW_CONTROL_REG_P1_FLOW_EN_MASK (0x00000002u)
#define CSL_CPSW_3GF_FLOW_CONTROL_REG_P1_FLOW_EN_SHIFT (0x00000001u)
#define CSL_CPSW_3GF_FLOW_CONTROL_REG_P1_FLOW_EN_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_FLOW_CONTROL_REG_P2_FLOW_EN_MASK (0x00000004u)
#define CSL_CPSW_3GF_FLOW_CONTROL_REG_P2_FLOW_EN_SHIFT (0x00000002u)
#define CSL_CPSW_3GF_FLOW_CONTROL_REG_P2_FLOW_EN_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_FLOW_CONTROL_REG_RESETVAL (0x00000001u)

/* p0_cppi_src_id_reg */

#define CSL_CPSW_3GF_P0_CPPI_SRC_ID_REG_TXA_SRC_ID_MASK (0x000000FFu)
#define CSL_CPSW_3GF_P0_CPPI_SRC_ID_REG_TXA_SRC_ID_SHIFT (0x00000000u)
#define CSL_CPSW_3GF_P0_CPPI_SRC_ID_REG_TXA_SRC_ID_RESETVAL (0x00000001u)

#define CSL_CPSW_3GF_P0_CPPI_SRC_ID_REG_TXB_SRC_ID_MASK (0x0000FF00u)
#define CSL_CPSW_3GF_P0_CPPI_SRC_ID_REG_TXB_SRC_ID_SHIFT (0x00000008u)
#define CSL_CPSW_3GF_P0_CPPI_SRC_ID_REG_TXB_SRC_ID_RESETVAL (0x00000002u)

#define CSL_CPSW_3GF_P0_CPPI_SRC_ID_REG_RESETVAL (0x00000201u)

/* p0_port_vlan_reg */

#define CSL_CPSW_3GF_P0_PORT_VLAN_REG_PORT_VID_MASK (0x00000FFFu)
#define CSL_CPSW_3GF_P0_PORT_VLAN_REG_PORT_VID_SHIFT (0x00000000u)
#define CSL_CPSW_3GF_P0_PORT_VLAN_REG_PORT_VID_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_P0_PORT_VLAN_REG_PORT_CFI_MASK (0x00001000u)
#define CSL_CPSW_3GF_P0_PORT_VLAN_REG_PORT_CFI_SHIFT (0x0000000Cu)
#define CSL_CPSW_3GF_P0_PORT_VLAN_REG_PORT_CFI_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_P0_PORT_VLAN_REG_PORT_PRI_MASK (0x0000E000u)
#define CSL_CPSW_3GF_P0_PORT_VLAN_REG_PORT_PRI_SHIFT (0x0000000Du)
#define CSL_CPSW_3GF_P0_PORT_VLAN_REG_PORT_PRI_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_P0_PORT_VLAN_REG_RESETVAL (0x00000000u)

/* p0_rx_pri_map_reg */

#define CSL_CPSW_3GF_P0_RX_PRI_MAP_REG_PRI0_MASK (0x00000007u)
#define CSL_CPSW_3GF_P0_RX_PRI_MAP_REG_PRI0_SHIFT (0x00000000u)
#define CSL_CPSW_3GF_P0_RX_PRI_MAP_REG_PRI0_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_P0_RX_PRI_MAP_REG_PRI1_MASK (0x00000070u)
#define CSL_CPSW_3GF_P0_RX_PRI_MAP_REG_PRI1_SHIFT (0x00000004u)
#define CSL_CPSW_3GF_P0_RX_PRI_MAP_REG_PRI1_RESETVAL (0x00000001u)

#define CSL_CPSW_3GF_P0_RX_PRI_MAP_REG_PRI2_MASK (0x00000700u)
#define CSL_CPSW_3GF_P0_RX_PRI_MAP_REG_PRI2_SHIFT (0x00000008u)
#define CSL_CPSW_3GF_P0_RX_PRI_MAP_REG_PRI2_RESETVAL (0x00000002u)

#define CSL_CPSW_3GF_P0_RX_PRI_MAP_REG_PRI3_MASK (0x00007000u)
#define CSL_CPSW_3GF_P0_RX_PRI_MAP_REG_PRI3_SHIFT (0x0000000Cu)
#define CSL_CPSW_3GF_P0_RX_PRI_MAP_REG_PRI3_RESETVAL (0x00000003u)

#define CSL_CPSW_3GF_P0_RX_PRI_MAP_REG_PRI4_MASK (0x00070000u)
#define CSL_CPSW_3GF_P0_RX_PRI_MAP_REG_PRI4_SHIFT (0x00000010u)
#define CSL_CPSW_3GF_P0_RX_PRI_MAP_REG_PRI4_RESETVAL (0x00000004u)

#define CSL_CPSW_3GF_P0_RX_PRI_MAP_REG_PRI5_MASK (0x00700000u)
#define CSL_CPSW_3GF_P0_RX_PRI_MAP_REG_PRI5_SHIFT (0x00000014u)
#define CSL_CPSW_3GF_P0_RX_PRI_MAP_REG_PRI5_RESETVAL (0x00000005u)

#define CSL_CPSW_3GF_P0_RX_PRI_MAP_REG_PRI6_MASK (0x07000000u)
#define CSL_CPSW_3GF_P0_RX_PRI_MAP_REG_PRI6_SHIFT (0x00000018u)
#define CSL_CPSW_3GF_P0_RX_PRI_MAP_REG_PRI6_RESETVAL (0x00000006u)

#define CSL_CPSW_3GF_P0_RX_PRI_MAP_REG_PRI7_MASK (0x70000000u)
#define CSL_CPSW_3GF_P0_RX_PRI_MAP_REG_PRI7_SHIFT (0x0000001Cu)
#define CSL_CPSW_3GF_P0_RX_PRI_MAP_REG_PRI7_RESETVAL (0x00000007u)

#define CSL_CPSW_3GF_P0_RX_PRI_MAP_REG_RESETVAL (0x76543210u)

/* rx_maxlen_reg */

#define CSL_CPSW_3GF_RX_MAXLEN_REG_RX_MAXLEN_MASK (0x00003FFFu)
#define CSL_CPSW_3GF_RX_MAXLEN_REG_RX_MAXLEN_SHIFT (0x00000000u)
#define CSL_CPSW_3GF_RX_MAXLEN_REG_RX_MAXLEN_RESETVAL (0x000005EEu)

#define CSL_CPSW_3GF_RX_MAXLEN_REG_RESETVAL (0x000005EEu)

/* ale_id_reg */

#define CSL_CPSW_3GF_ALE_ID_REG_ALE_MINOR_VER_MASK (0x000000FFu)
#define CSL_CPSW_3GF_ALE_ID_REG_ALE_MINOR_VER_SHIFT (0x00000000u)
#define CSL_CPSW_3GF_ALE_ID_REG_ALE_MINOR_VER_RESETVAL (0x00000002u)

#define CSL_CPSW_3GF_ALE_ID_REG_ALE_MAJOR_VER_MASK (0x0000FF00u)
#define CSL_CPSW_3GF_ALE_ID_REG_ALE_MAJOR_VER_SHIFT (0x00000008u)
#define CSL_CPSW_3GF_ALE_ID_REG_ALE_MAJOR_VER_RESETVAL (0x00000001u)

#define CSL_CPSW_3GF_ALE_ID_REG_ALE_IDENT_MASK (0xFFFF0000u)
#define CSL_CPSW_3GF_ALE_ID_REG_ALE_IDENT_SHIFT (0x00000010u)
#define CSL_CPSW_3GF_ALE_ID_REG_ALE_IDENT_RESETVAL (0x00000029u)

#define CSL_CPSW_3GF_ALE_ID_REG_RESETVAL (0x00290102u)

/* ale_control_reg */

#define CSL_CPSW_3GF_ALE_CONTROL_REG_ENABLE_RATE_LIMIT_MASK (0x00000001u)
#define CSL_CPSW_3GF_ALE_CONTROL_REG_ENABLE_RATE_LIMIT_SHIFT (0x00000000u)
#define CSL_CPSW_3GF_ALE_CONTROL_REG_ENABLE_RATE_LIMIT_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_ALE_CONTROL_REG_ENABLE_AUTH_MODE_MASK (0x00000002u)
#define CSL_CPSW_3GF_ALE_CONTROL_REG_ENABLE_AUTH_MODE_SHIFT (0x00000001u)
#define CSL_CPSW_3GF_ALE_CONTROL_REG_ENABLE_AUTH_MODE_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_ALE_CONTROL_REG_ALE_VLAN_AWARE_MASK (0x00000004u)
#define CSL_CPSW_3GF_ALE_CONTROL_REG_ALE_VLAN_AWARE_SHIFT (0x00000002u)
#define CSL_CPSW_3GF_ALE_CONTROL_REG_ALE_VLAN_AWARE_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_ALE_CONTROL_REG_RATE_LIMIT_TX_MASK (0x00000008u)
#define CSL_CPSW_3GF_ALE_CONTROL_REG_RATE_LIMIT_TX_SHIFT (0x00000003u)
#define CSL_CPSW_3GF_ALE_CONTROL_REG_RATE_LIMIT_TX_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_ALE_CONTROL_REG_ALE_BYPASS_MASK (0x00000010u)
#define CSL_CPSW_3GF_ALE_CONTROL_REG_ALE_BYPASS_SHIFT (0x00000004u)
#define CSL_CPSW_3GF_ALE_CONTROL_REG_ALE_BYPASS_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_ALE_CONTROL_REG_ENABLE_OUI_DENY_MASK (0x00000020u)
#define CSL_CPSW_3GF_ALE_CONTROL_REG_ENABLE_OUI_DENY_SHIFT (0x00000005u)
#define CSL_CPSW_3GF_ALE_CONTROL_REG_ENABLE_OUI_DENY_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_ALE_CONTROL_REG_EN_VID0_MODE_MASK (0x00000040u)
#define CSL_CPSW_3GF_ALE_CONTROL_REG_EN_VID0_MODE_SHIFT (0x00000006u)
#define CSL_CPSW_3GF_ALE_CONTROL_REG_EN_VID0_MODE_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_ALE_CONTROL_REG_LEARN_NO_VID_MASK (0x00000080u)
#define CSL_CPSW_3GF_ALE_CONTROL_REG_LEARN_NO_VID_SHIFT (0x00000007u)
#define CSL_CPSW_3GF_ALE_CONTROL_REG_LEARN_NO_VID_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_ALE_CONTROL_REG_AGE_OUT_NOW_MASK (0x20000000u)
#define CSL_CPSW_3GF_ALE_CONTROL_REG_AGE_OUT_NOW_SHIFT (0x0000001Du)
#define CSL_CPSW_3GF_ALE_CONTROL_REG_AGE_OUT_NOW_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_ALE_CONTROL_REG_CLEAR_TABLE_MASK (0x40000000u)
#define CSL_CPSW_3GF_ALE_CONTROL_REG_CLEAR_TABLE_SHIFT (0x0000001Eu)
#define CSL_CPSW_3GF_ALE_CONTROL_REG_CLEAR_TABLE_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_ALE_CONTROL_REG_ENABLE_ALE_MASK (0x80000000u)
#define CSL_CPSW_3GF_ALE_CONTROL_REG_ENABLE_ALE_SHIFT (0x0000001Fu)
#define CSL_CPSW_3GF_ALE_CONTROL_REG_ENABLE_ALE_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_ALE_CONTROL_REG_RESETVAL (0x00000000u)

/* ale_prescale_reg */

#define CSL_CPSW_3GF_ALE_PRESCALE_REG_ALE_PRESCALE_MASK (0x000FFFFFu)
#define CSL_CPSW_3GF_ALE_PRESCALE_REG_ALE_PRESCALE_SHIFT (0x00000000u)
#define CSL_CPSW_3GF_ALE_PRESCALE_REG_ALE_PRESCALE_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_ALE_PRESCALE_REG_RESETVAL (0x00000000u)

/* ale_unknown_vlan_reg */

#define CSL_CPSW_3GF_ALE_UNKNOWN_VLAN_REG_UNKNOWN_VLAN_MEMBER_LIST_MASK (0x0000003Fu)
#define CSL_CPSW_3GF_ALE_UNKNOWN_VLAN_REG_UNKNOWN_VLAN_MEMBER_LIST_SHIFT (0x00000000u)
#define CSL_CPSW_3GF_ALE_UNKNOWN_VLAN_REG_UNKNOWN_VLAN_MEMBER_LIST_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_ALE_UNKNOWN_VLAN_REG_UNKNOWN_MCAST_FLOOD_MASK_MASK (0x00003F00u)
#define CSL_CPSW_3GF_ALE_UNKNOWN_VLAN_REG_UNKNOWN_MCAST_FLOOD_MASK_SHIFT (0x00000008u)
#define CSL_CPSW_3GF_ALE_UNKNOWN_VLAN_REG_UNKNOWN_MCAST_FLOOD_MASK_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_ALE_UNKNOWN_VLAN_REG_UNKNOWN_REG_MCAST_FLOOD_MASK_MASK (0x003F0000u)
#define CSL_CPSW_3GF_ALE_UNKNOWN_VLAN_REG_UNKNOWN_REG_MCAST_FLOOD_MASK_SHIFT (0x00000010u)
#define CSL_CPSW_3GF_ALE_UNKNOWN_VLAN_REG_UNKNOWN_REG_MCAST_FLOOD_MASK_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_ALE_UNKNOWN_VLAN_REG_UNKNOWN_FORCE_UNTAGGED_EGRESS_MASK (0x3F000000u)
#define CSL_CPSW_3GF_ALE_UNKNOWN_VLAN_REG_UNKNOWN_FORCE_UNTAGGED_EGRESS_SHIFT (0x00000018u)
#define CSL_CPSW_3GF_ALE_UNKNOWN_VLAN_REG_UNKNOWN_FORCE_UNTAGGED_EGRESS_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_ALE_UNKNOWN_VLAN_REG_RESETVAL (0x00000000u)

/* ale_table_control_reg */

#define CSL_CPSW_3GF_ALE_TABLE_CONTROL_REG_ENTRY_POINTER_MASK (0x000003FFu)
#define CSL_CPSW_3GF_ALE_TABLE_CONTROL_REG_ENTRY_POINTER_SHIFT (0x00000000u)
#define CSL_CPSW_3GF_ALE_TABLE_CONTROL_REG_ENTRY_POINTER_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_ALE_TABLE_CONTROL_REG_WRITE_RDZ_MASK (0x80000000u)
#define CSL_CPSW_3GF_ALE_TABLE_CONTROL_REG_WRITE_RDZ_SHIFT (0x0000001Fu)
#define CSL_CPSW_3GF_ALE_TABLE_CONTROL_REG_WRITE_RDZ_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_ALE_TABLE_CONTROL_REG_RESETVAL (0x00000000u)

/* ale_table_word2_reg */

#define CSL_CPSW_3GF_ALE_TABLE_WORD2_REG_ENTRY_71_64_MASK (0x000000FFu)
#define CSL_CPSW_3GF_ALE_TABLE_WORD2_REG_ENTRY_71_64_SHIFT (0x00000000u)
#define CSL_CPSW_3GF_ALE_TABLE_WORD2_REG_ENTRY_71_64_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_ALE_TABLE_WORD2_REG_RESETVAL (0x00000000u)

/* ale_table_word1_reg */

#define CSL_CPSW_3GF_ALE_TABLE_WORD1_REG_ENTRY_63_32_MASK (0xFFFFFFFFu)
#define CSL_CPSW_3GF_ALE_TABLE_WORD1_REG_ENTRY_63_32_SHIFT (0x00000000u)
#define CSL_CPSW_3GF_ALE_TABLE_WORD1_REG_ENTRY_63_32_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_ALE_TABLE_WORD1_REG_RESETVAL (0x00000000u)

/* ale_table_word0_reg */

#define CSL_CPSW_3GF_ALE_TABLE_WORD0_REG_ENTRY_31_0_MASK (0xFFFFFFFFu)
#define CSL_CPSW_3GF_ALE_TABLE_WORD0_REG_ENTRY_31_0_SHIFT (0x00000000u)
#define CSL_CPSW_3GF_ALE_TABLE_WORD0_REG_ENTRY_31_0_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_ALE_TABLE_WORD0_REG_RESETVAL (0x00000000u)

/* ale_port_control_reg0 */

#define CSL_CPSW_3GF_ALE_PORT_CONTROL_REG_PORT_STATE_MASK (0x00000003u)
#define CSL_CPSW_3GF_ALE_PORT_CONTROL_REG_PORT_STATE_SHIFT (0x00000000u)
#define CSL_CPSW_3GF_ALE_PORT_CONTROL_REG_PORT_STATE_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_ALE_PORT_CONTROL_REG_DROP_UNTAGGED_MASK (0x00000004u)
#define CSL_CPSW_3GF_ALE_PORT_CONTROL_REG_DROP_UNTAGGED_SHIFT (0x00000002u)
#define CSL_CPSW_3GF_ALE_PORT_CONTROL_REG_DROP_UNTAGGED_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_ALE_PORT_CONTROL_REG_VID_INGRESS_CHECK_MASK (0x00000008u)
#define CSL_CPSW_3GF_ALE_PORT_CONTROL_REG_VID_INGRESS_CHECK_SHIFT (0x00000003u)
#define CSL_CPSW_3GF_ALE_PORT_CONTROL_REG_VID_INGRESS_CHECK_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_ALE_PORT_CONTROL_REG_NO_LEARN_MASK (0x00000010u)
#define CSL_CPSW_3GF_ALE_PORT_CONTROL_REG_NO_LEARN_SHIFT (0x00000004u)
#define CSL_CPSW_3GF_ALE_PORT_CONTROL_REG_NO_LEARN_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_ALE_PORT_CONTROL_REG_MCAST_LIMIT_MASK (0x00FF0000u)
#define CSL_CPSW_3GF_ALE_PORT_CONTROL_REG_MCAST_LIMIT_SHIFT (0x00000010u)
#define CSL_CPSW_3GF_ALE_PORT_CONTROL_REG_MCAST_LIMIT_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_ALE_PORT_CONTROL_REG_BCAST_LIMIT_MASK (0xFF000000u)
#define CSL_CPSW_3GF_ALE_PORT_CONTROL_REG_BCAST_LIMIT_SHIFT (0x00000018u)
#define CSL_CPSW_3GF_ALE_PORT_CONTROL_REG_BCAST_LIMIT_RESETVAL (0x00000000u)

#define CSL_CPSW_3GF_ALE_PORT_CONTROL_REG_RESETVAL (0x00000000u)

#endif
