/*
 *
 * Copyright (C) 2010 Texas Instruments Incorporated - http://www.ti.com/ 
 * 
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/



/*  pa1.c
 *
 *  A simple example of using the PA/QM/SGMII 
 *
 *
 *  The overall system setup is shown in the following figure:                             /------------------\
 *                                                                                         | Q899             |
 *                                                                                         | Teardown         |
 *                                            /------------------\                         |------------------|
 *                                            |                  |<------------------------| Q900             |
 *                                            |  Packet Created  |-----\                   | Free descriptor  |
 *                                            |  by GEM          |     |                   |------------------|
 *                                            |                  |     |                   | Q901             |
 *                                            \------------------/     |  /------------\   | Free buffer      |-\
 *                                                                     |  |            |   |------------------| | Flow 0
 *                                                                     |  |            |   | Q902             |_|
 *                                                                     |  |            |   | PA cmd reply     | |
 *                                                                    \|/ |            |   |------------------| |
 *  /-----------------------------------------------------------------------\          |   | Q903             | |
 *  | Q640  | Q641  | Q642  | Q643  | Q644  | Q645  | Q646  | Q647  | Q648  |          |   | Pkt Send recycle | |  
 *  | PaTx0 | PaTx1 | PaTx2 | PaTx3 | PaTx4 | PaTx5 | SaTx0 | SaTx1 | SwTx0 |          |   |------------------| |   
 *  \-----------------------------------------------------------------------/          \-->| Q904             |<-  
 *                                                                     |                   | Pkt Receive      |<--\     
 *                                                                     |                   \------------------/   |      
 *                                                                     |                                          |
 *                                                                     |                                          |
 *           /------------\    /------------\    /----------------\    |                                          |
 *           |            |    |            |    |         Port 0 |    |                                          |
 *           |         /--|<---|------------|<---|----------------|<---/                                          |
 *           |  SGMII  |  |    |   EMAC     |    |  Switch        |                                               |
 *           |         \--|--->|------------|--->|-\              |                                               |
 *           |            |    |            |    | |Port 2 Port 1 |                                               |
 *           \------------/    \------------/    \----------------/                                               |
 *                                                 |                                                              |
 *                      /--------------------------/                                                              |
 *                      |                                                                                         |
 *               /------------\                                                                                   |
 *               |            |                                                                                   |
 *               |     PA     |-----------------------------------------------------------------------------------/
 *               |            |
 *               \------------/
 *
 *
 *
 *
 *  The example is meant to be the simplest possible example which demonstrates configuration of the QM, CDMA, flows
 *  PA, and switch/emac/SGMII.
 *
 *
 *  One manual entry is made in the switch tables to forward route mac address 00:01:02:03:04:aa to ports 0 and 1.
 *
 *  The PA is configured to forward packets with headers:
 *
 *          dest mac  = 10:11:12:13:14:15, ethertype = 0x0800 (ipv4)
 *          dest IP   = 1.2.3.4, protocol = any
 *          dest port = 0x0555
 *
 *      To queue 902 using flow 0.
 *
 *
 *  Flow 0 is configured to use Q901 as the free buffer queue. No size selection of source queues is made.
 *
 *
 *  See file pa1config.h for build time configuration.
 *
 */
 
#include <xdc/runtime/System.h>
#include <ti/drv/pa/pa.h>
#include <ti/csl/cslr_device.h>
#include <ti/csl/csl_psc.h>
#include <ti/csl/csl_pscAux.h>
 
#include "pa1.h"

/*
 * Default test configuration for the silicon
 *
 * To run test at the CCS simulator
 *    cpswSimTest = 0
 *    cpswLpbkMode = CPSW_LOOPBACK_PA
 */
#ifdef SIMULATOR_SUPPORT
Int cpswLpbkMode = CPSW_LOOPBACK_PA;
Int cpswSimTest = 1;
#else 
Int cpswLpbkMode = CPSW_LOOPBACK_PA;
Int cpswSimTest = 0;
#endif

/***************************************************************************************
 * FUNCTION PURPOSE: Power up PA subsystem
 ***************************************************************************************
 * DESCRIPTION: this function powers up the PA subsystem domains
 ***************************************************************************************/
void passPowerUp (void)
{

    /* PASS power domain is turned OFF by default. It needs to be turned on before doing any 
     * PASS device register access. This not required for the simulator. */

    /* Set PASS Power domain to ON */        
    CSL_PSC_enablePowerDomain (CSL_PSC_PD_PASS);

    /* Enable the clocks for PASS modules */
    CSL_PSC_setModuleNextState (CSL_PSC_LPSC_PKTPROC, PSC_MODSTATE_ENABLE);
    CSL_PSC_setModuleNextState (CSL_PSC_LPSC_CPGMAC,  PSC_MODSTATE_ENABLE);
    CSL_PSC_setModuleNextState (CSL_PSC_LPSC_Crypto,  PSC_MODSTATE_ENABLE);

    /* Start the state transition */
    CSL_PSC_startStateTransition (CSL_PSC_PD_PASS);

    /* Wait until the state transition process is completed. */
    while (!CSL_PSC_isStateTransitionDone (CSL_PSC_PD_PASS));
}

void main (void)
{
  TSCL = 1;  /* Init internal cycle counter */

  /* Power up PA sub-systems */
  if (!cpswSimTest)
  {
    passPowerUp();
  }

  if (setupQmCdma ())  {
    System_printf ("Function setupQmCdma failed\n");
    return;
  }

  if (Init_Cpsw())  {
    System_printf ("Function Init_Cpsw failed\n");
    tearDownQmCdma ();
    return;
  }
  
  if (setupPa ())  {
    System_printf ("Function setupPa failed\n");
    tearDownQmCdma ();
    return;
  }



  if (sendPacket ())  {
    System_printf ("Function sendPacket failed\n");
    tearDownQmCdma ();
    return;
  }
  
  /* Look for the return packet */
  if (findPacket ())  {
  	getPaStats ();
    System_printf ("Function findPacket failed\n");
    return;
  }

  if (getPaStats ())  {
  	System_printf ("Function getPaStats failed\n");
  	return;
  }
  	
  tearDownQmCdma ();

  System_printf ("Test Completed successfully\n");

}


