/******************************************************************************
 * FILE PURPOSE: CSL Source module specification file.
 ******************************************************************************
 * FILE NAME: module.xs
 *
 * DESCRIPTION: 
 *  This file contains the module specification for the CSL source directory.
 *
 * Copyright (C) 2008, Texas Instruments, Inc.
 *****************************************************************************/

/* Load the library utility. */
var libUtility = xdc.loadCapsule ("../build/buildlib.xs");

/* List of all subdirectories that combine to make the CSL and intc library.
 * Note the ip directory is not listed here. It will be build when soc is built. 
 * The packaging is done below.
 */
var subDirectories = [ "src/intc", "src/soc" ];

/* List of all subdirectories that contain the header files. These files will 
 * be added to the "inc" directory */
var headerDirectories = [ "src/ip", "src/soc/inc" ];

function copy(src, dst)
{
    var ins = new java.io.FileInputStream(src);
    var outs = new java.io.FileOutputStream(dst, true);
    var inc = ins.getChannel();
    var outc = outs.getChannel();
    inc.transferTo(0, inc.size(), outc);    /* transfer entire src to dst */
    inc.close();
    outc.close();
    ins.close();
    outs.close();
}

/**************************************************************************
 * FUNCTION NAME : modBuild
 **************************************************************************
 * DESCRIPTION   :
 *  The function is used to build all the components of the CSL
 **************************************************************************/
function modBuild() 
{
	var file = new java.io.File(headerDirectories[1]);

    /* Do we need to copy the header files to the top level directory or not? */
	if (file.exists())
	{
        /* Create an Epilogue section so that we can clean all the copied header files */
        Pkg.makeEpilogue += "clean::\n";

        /* Copy all the header files to the top level directory */
    	for (var i = 0; i < headerDirectories.length; i++) 
	    {
    	    /* Get a list of all the header files in each directory and add them */
        	var copyFiles = libUtility.listAllFiles (".h", headerDirectories[i]);
	        for (var k = 0 ; k < copyFiles.length; k++) 
    	    {
                print ("Copying File " + copyFiles[k]);

        	    /* Copy to the top level directory */
	            var file = new java.io.File(copyFiles[k]);
            	copy(copyFiles[k], file.getName());

                /* Add the top level header files to the package */
                Pkg.otherFiles[Pkg.otherFiles.length++] = file.getName();

                /* Add the cleaning of the copied file in the clean target. */
                Pkg.makeEpilogue += "\t $(RM) " + file.getName() + " \n";
    	    }
    	}
    }
    else
    {
        /* The files have already been copied to the top level directory. */
        var copyFiles = libUtility.listAllFiles (".h", ".");

        /* This is a list of all header files in the CSL package. Here we will add only the header 
         * files in the top level directory. */
        for (var k = 0 ; k < copyFiles.length; k++)
        {
            var file = new java.io.File(copyFiles[k]);

            /* The file Settings.h is a special case since this gets added automatically by the XDC package. */
            if (file.getName() != "Settings.h")
            {
                /* We add only those header files which are in the top level directory. */
                if (file.getParent() == ".")
                    Pkg.otherFiles[Pkg.otherFiles.length++] = copyFiles[k];
            }
        } 
    }

    /* Now cycle through each subdirectory inside source and build the libraries. */
    for (var i = 0; i < subDirectories.length; i++) 
    {
        /* Load the capsule in the sub directory. */
        var caps = xdc.loadCapsule (subDirectories[i]+"/Build.xs");
  
        Pkg.otherFiles[Pkg.otherFiles.length++] = subDirectories[i]+"/Build.xs";

		/* Get a list of all source files and add them to the package. */
        var srcFiles = caps.getSources();
        for (var j = 0; j < srcFiles.length; j++)
        	Pkg.otherFiles[Pkg.otherFiles.length++] = srcFiles[j];

        if (subDirectories[i] == "src/intc")
        {
           	/* For the source release we need to get a list of all the 
             * internal header files in each capsule and add them */
		    var packageFiles = libUtility.listAllFiles (".h", subDirectories[i]);
            for (var k = 0 ; k < packageFiles.length; k++) 
                Pkg.otherFiles[Pkg.otherFiles.length++] = packageFiles[k];
        }

        /* Build the libraries for all the targets specified. */
        for (var targets=0; targets < Build.targets.length; targets++)
            caps.buildLibrary (Build.targets[targets]);
    }
}

