#*******************************************************************************
#* FILE PURPOSE: Lower level makefile for Creating Component Libraries
#*******************************************************************************
#* FILE NAME: ./lib/ti.csl.ae66.mk
#*
#* DESCRIPTION: Defines Source Files, Compilers flags and build rules
#*
#*
#*******************************************************************************
#

#
# Macro definitions referenced below
#
empty =
space =$(empty) $(empty)
CC = $(C6X_GEN_INSTALL_PATH)/bin/cl6x -c --strip_coff_underscore -mo -o3 -q -k -eo.o -DC6678 -mv6600 --abi=eabi
AC = $(C6X_GEN_INSTALL_PATH)/bin/cl6x -c --strip_coff_underscore -mv6600 --abi=eabi
ARIN = $(C6X_GEN_INSTALL_PATH)/bin/ar6x rq
LD = $(C6X_GEN_INSTALL_PATH)/bin/lnk6x --abi=eabi
RTSLIB = -l $(C6X_GEN_INSTALL_PATH)/lib/rts6600_elf.lib
INCS = -I. -I$(strip $(subst ;, -I,$(subst $(space),\$(space),$(INCDIR))))
OBJEXT = oe66
AOBJEXT = se66
INTERNALDEFS = -Dti_targets_elf_C66  -DMAKEFILE_BUILD -eo.$(OBJEXT) -ea.$(AOBJEXT) -fr=$(@D) -fs=$(@D) -ppa -ppd=$@.dep
INTERNALLINKDEFS = -o $@ -m $@.map
OBJDIR =  $(LIBDIR)

#List the COMMONSRC Files
COMMONSRCC= \
    src/soc/common/csl_version.c\
    src/soc/common/csl_gpioGetBaseAddress.c\
    src/soc/common/csl_edma3GetBaseAddress.c\
    src/soc/common/csl_cpIntcGetBaseAddress.c\
    src/soc/common/csl_srioGetBaseAddress.c\
    src/soc/common/csl_timerGetBaseAddress.c\
    src/soc/common/csl_pllcGetBaseAddress.c\
    src/soc/common/csl_tsipGetBaseAddress.c\
    src/soc/common/csl_mpuGetBaseAddress.c\
    src/ip/chip/csl_chip.c\
    src/ip/edma/csl_edma3Init.c\
    src/ip/edma/csl_edma3Open.c\
    src/ip/edma/csl_edma3Close.c\
    src/ip/edma/csl_edma3HwSetup.c\
    src/ip/edma/csl_edma3HwControl.c\
    src/ip/edma/csl_edma3GetHwStatus.c\
    src/ip/edma/csl_edma3GetHwSetup.c\
    src/ip/edma/csl_edma3ChannelOpen.c\
    src/ip/edma/csl_edma3ChannelClose.c\
    src/ip/edma/csl_edma3HwChannelSetup.c\
    src/ip/edma/csl_edma3HwChannelControl.c\
    src/ip/edma/csl_edma3GetHwChannelStatus.c\
    src/ip/edma/csl_edma3GetHwChannelSetup.c\
    src/ip/edma/csl_edma3Param.c\
    src/ip/timer/csl_tmrInit.c\
    src/ip/timer/csl_tmrOpen.c\
    src/ip/timer/csl_tmrClose.c\
    src/ip/timer/csl_tmrHwSetup.c\
    src/ip/timer/csl_tmrHwSetupRaw.c\
    src/ip/timer/csl_tmrHwControl.c\
    src/ip/timer/csl_tmrGetHwStatus.c\
    src/ip/timer/csl_tmrGetHwSetup.c

# FLAGS for the COMMONSRC Files
COMMONSRCCFLAGS =    -i./src/intc -i. 

# Make Rule for the COMMONSRC Files
COMMONSRCCOBJS = $(patsubst %.c, $(OBJDIR)/%.$(OBJEXT), $(COMMONSRCC))

$(COMMONSRCCOBJS): $(OBJDIR)/%.$(OBJEXT): %.c
	-@echo cle66 $< ...
	if [ ! -d $(@D) ]; then $(MKDIR) $(@D) ; fi;
	$(RM) $@.dep
	$(CC) $(COMMONSRCCFLAGS) $(INTERNALDEFS) $(INCS) -fc $< 
	-@$(CP) $@.dep $@.pp; \
         $(SED) -e 's/#.*//' -e 's/^[^:]*: *//' -e 's/ *\\$$//' \
             -e '/^$$/ d' -e 's/$$/ :/' < $@.pp >> $@.dep; \
         $(RM) $@.pp 

#Create Empty rule for dependency
$(COMMONSRCCOBJS):./lib/ti.csl.ae66.mk
./lib/ti.csl.ae66.mk:

#Include Depedency for COMMONSRC Files
ifneq (clean,$(MAKECMDGOALS))
 -include $(COMMONSRCCOBJS:%.$(OBJEXT)=%.$(OBJEXT).dep)
endif

#List the COMMONSRC Files
COMMONSRCASM= \
    src/ip/tsc/csl_tsc.asm

# FLAGS for the COMMONSRC Files
COMMONSRCASMFLAGS =   -i./src/intc -i. 

# Make Rule for the COMMONSRC Files
COMMONSRCASMOBJS = $(patsubst %.asm, $(OBJDIR)/%.$(OBJEXT), $(COMMONSRCASM))

$(COMMONSRCASMOBJS): $(OBJDIR)/%.$(OBJEXT): %.asm
	-@echo asme66 $< ...
	if [ ! -d $(@D) ]; then $(MKDIR) $(@D) ; fi;
	$(AC) $(COMMONSRCASMFLAGS) $(INTERNALDEFS) $(INCS) -fa $< 

#Create Empty rule for dependency
$(COMMONSRCASMOBJS):./lib/ti.csl.ae66.mk
./lib/ti.csl.ae66.mk:

#Include Depedency for COMMONSRC Files
ifneq (clean,$(MAKECMDGOALS))
 -include $(COMMONSRCASMOBJS:%.$(OBJEXT)=%.$(OBJEXT).dep)
endif


$(LIBDIR)/ti.csl.ae66 : $(COMMONSRCCOBJS) $(COMMONSRCASMOBJS)
	@echo archiving $? into $@ ...
	$(ARIN) $@ $?
