/********************************************************************
* Copyright (C) 2003-2008 Texas Instruments Incorporated.
* All Rights Reserved
*********************************************************************
* file: cslr_tptc.h
*
* Brief: This file contains the Register Description for tptc
*
*********************************************************************/
#ifndef _CSLR_TPTC_H_
#define _CSLR_TPTC_H_

/* CSL Modification:
 *  The file has been modified from the AUTOGEN file for the following
 *  reasons:-
 *      a) Modified header file includes as per the RTSC specification
 *      b) Added the DST FIFO Regs and modified RL 
 */
#include <ti/csl/cslr.h>
#include <ti/csl/tistdtypes.h>

/* Minimum unit = 1 byte */

/**************************************************************************\
* Register Overlay Structure for CSL_TptcDstFifoRegs 
\**************************************************************************/
typedef struct  {
    volatile Uint32 TPTC_DFOPT;
    volatile Uint8 RSVD0[4];
    volatile Uint32 TPTC_DFCNT;
    volatile Uint32 TPTC_DFDST;
    volatile Uint32 TPTC_DFBIDX;
    volatile Uint32 TPTC_DFMPPRXY;
    volatile Uint8 RSVD1[40];    
} CSL_TptcDstFifoRegs;

/**************************************************************************\
* Register Overlay Structure
\**************************************************************************/
typedef struct  {
    volatile Uint32 TPCC_PID;
    volatile Uint32 TPTC_TCCFG;
    volatile Uint8 RSVD0[244];
    volatile Uint32 TPTC_CLKGDIS;
    volatile Uint32 TPTC_STAT;
    volatile Uint32 TPTC_INTSTAT;
    volatile Uint32 TPTC_INTEN;
    volatile Uint32 TPTC_INTCLR;
    volatile Uint32 TPTC_INTCMD;
    volatile Uint8 RSVD1[12];
    volatile Uint32 TPTC_ERRSTAT;
    volatile Uint32 TPTC_ERREN;
    volatile Uint32 TPTC_ERRCLR;
    volatile Uint32 TPTC_ERRDET;
    volatile Uint32 TPTC_ERRCMD;
    volatile Uint8 RSVD2[12];
    volatile Uint32 TPTC_RDRATE;
    volatile Uint8 RSVD3[188];
    volatile Uint32 TPTC_POPT;
    volatile Uint32 TPTC_PSRC;
    volatile Uint32 TPTC_PCNT;
    volatile Uint32 TPTC_PDST;
    volatile Uint32 TPTC_PBIDX;
    volatile Uint32 TPTC_PMPPRXY;
    volatile Uint8 RSVD4[40];
    volatile Uint32 TPTC_SAOPT;
    volatile Uint32 TPTC_SASRC;
    volatile Uint32 TPTC_SACNT;
    volatile Uint8 RSVD5[4];
    volatile Uint32 TPTC_SABIDX;
    volatile Uint32 TPTC_SAMPPRXY;
    volatile Uint32 TPTC_SACNTRLD;
    volatile Uint32 TPTC_SASRCBREF;
    volatile Uint8 RSVD6[32];
    volatile Uint32 TPTC_DFCNTRLD;
    volatile Uint32 TPTC_DFSRCBREF;
    volatile Uint32 TPTC_DFDSTBREF;
    volatile Uint8 RSVD7[116];
    CSL_TptcDstFifoRegs TPTC_DSTFIFO[4];
} CSL_TptcRegs;

/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* TPCC_PID */

#define CSL_TPTC_TPCC_PID_SCHEME_MASK    (0x00000000u)
#define CSL_TPTC_TPCC_PID_SCHEME_SHIFT   (0x0000001Fu)
#define CSL_TPTC_TPCC_PID_SCHEME_RESETVAL (0x00000001u)

#define CSL_TPTC_TPCC_PID_FUNC_MASK      (0x00000000u)
#define CSL_TPTC_TPCC_PID_FUNC_SHIFT     (0x0000001Bu)
#define CSL_TPTC_TPCC_PID_FUNC_RESETVAL  (0x00000000u)

#define CSL_TPTC_TPCC_PID_RTL_MASK       (0x00000000u)
#define CSL_TPTC_TPCC_PID_RTL_SHIFT      (0x0000000Fu)
#define CSL_TPTC_TPCC_PID_RTL_RESETVAL   (0x00000010u)

#define CSL_TPTC_TPCC_PID_MAJOR_MASK     (0x00000000u)
#define CSL_TPTC_TPCC_PID_MAJOR_SHIFT    (0x0000000Au)
#define CSL_TPTC_TPCC_PID_MAJOR_RESETVAL (0x00000003u)


#define CSL_TPTC_TPCC_PID_MINOR_MASK     (0x00000000u)
#define CSL_TPTC_TPCC_PID_MINOR_SHIFT    (0x00000005u)
#define CSL_TPTC_TPCC_PID_MINOR_RESETVAL (0x00000000u)

#define CSL_TPTC_TPCC_PID_RESETVAL       (0x00000000u)

/* TPTC_TCCFG */

#define CSL_TPTC_TPTC_TCCFG_FIFOSIZE_MASK (0x00000007u)
#define CSL_TPTC_TPTC_TCCFG_FIFOSIZE_SHIFT (0x00000000u)
#define CSL_TPTC_TPTC_TCCFG_FIFOSIZE_RESETVAL (0x00000005u)

#define CSL_TPTC_TPTC_TCCFG_BUS_WIDTH_MASK (0x00000030u)
#define CSL_TPTC_TPTC_TCCFG_BUS_WIDTH_SHIFT (0x00000004u)
#define CSL_TPTC_TPTC_TCCFG_BUS_WIDTH_RESETVAL (0x00000003u)

#define CSL_TPTC_TPTC_TCCFG_DREGDEPTH_MASK (0x00000300u)
#define CSL_TPTC_TPTC_TCCFG_DREGDEPTH_SHIFT (0x00000008u)
#define CSL_TPTC_TPTC_TCCFG_DREGDEPTH_RESETVAL (0x00000002u)

#define CSL_TPTC_TPTC_TCCFG_RESETVAL     (0x00000235u)

/* TPTC_CLKGDIS */

#define CSL_TPTC_TPTC_CLKGDIS_CLKGDIS_MASK (0x00000001u)
#define CSL_TPTC_TPTC_CLKGDIS_CLKGDIS_SHIFT (0x00000000u)
#define CSL_TPTC_TPTC_CLKGDIS_CLKGDIS_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_CLKGDIS_RESETVAL   (0x00000000u)

/* TPTC_STAT */

#define CSL_TPTC_TPTC_STAT_PROGBUSY_MASK (0x00000001u)
#define CSL_TPTC_TPTC_STAT_PROGBUSY_SHIFT (0x00000000u)
#define CSL_TPTC_TPTC_STAT_PROGBUSY_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_STAT_SRCACT_MASK   (0x00000002u)
#define CSL_TPTC_TPTC_STAT_SRCACT_SHIFT  (0x00000001u)
#define CSL_TPTC_TPTC_STAT_SRCACT_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_STAT_WSACT_MASK    (0x00000004u)
#define CSL_TPTC_TPTC_STAT_WSACT_SHIFT   (0x00000002u)
#define CSL_TPTC_TPTC_STAT_WSACT_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_STAT_DSTACT_MASK   (0x00000070u)
#define CSL_TPTC_TPTC_STAT_DSTACT_SHIFT  (0x00000004u)
#define CSL_TPTC_TPTC_STAT_DSTACT_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_STAT_ACT_MASK      (0x00000100u)
#define CSL_TPTC_TPTC_STAT_ACT_SHIFT     (0x00000008u)
#define CSL_TPTC_TPTC_STAT_ACT_RESETVAL  (0x00000000u)

#define CSL_TPTC_TPTC_STAT_DFSTRTPTR_MASK (0x00003000u)
#define CSL_TPTC_TPTC_STAT_DFSTRTPTR_SHIFT (0x0000000Cu)
#define CSL_TPTC_TPTC_STAT_DFSTRTPTR_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_STAT_RESETVAL      (0x00000000u)

/* TPTC_INTSTAT */

#define CSL_TPTC_TPTC_INTSTAT_PROGEMPTY_MASK (0x00000001u)
#define CSL_TPTC_TPTC_INTSTAT_PROGEMPTY_SHIFT (0x00000000u)
#define CSL_TPTC_TPTC_INTSTAT_PROGEMPTY_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_INTSTAT_TRDONE_MASK (0x00000002u)
#define CSL_TPTC_TPTC_INTSTAT_TRDONE_SHIFT (0x00000001u)
#define CSL_TPTC_TPTC_INTSTAT_TRDONE_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_INTSTAT_RESETVAL   (0x00000000u)

/* TPTC_INTEN */

#define CSL_TPTC_TPTC_INTEN_PROGEMPTY_MASK (0x00000001u)
#define CSL_TPTC_TPTC_INTEN_PROGEMPTY_SHIFT (0x00000000u)
#define CSL_TPTC_TPTC_INTEN_PROGEMPTY_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_INTEN_TRDONE_MASK  (0x00000002u)
#define CSL_TPTC_TPTC_INTEN_TRDONE_SHIFT (0x00000001u)
#define CSL_TPTC_TPTC_INTEN_TRDONE_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_INTEN_RESETVAL     (0x00000000u)

/* TPTC_INTCLR */

#define CSL_TPTC_TPTC_INTCLR_PROGEMPTY_MASK (0x00000001u)
#define CSL_TPTC_TPTC_INTCLR_PROGEMPTY_SHIFT (0x00000000u)
#define CSL_TPTC_TPTC_INTCLR_PROGEMPTY_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_INTCLR_TRDONE_MASK (0x00000002u)
#define CSL_TPTC_TPTC_INTCLR_TRDONE_SHIFT (0x00000001u)
#define CSL_TPTC_TPTC_INTCLR_TRDONE_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_INTCLR_RESETVAL    (0x00000000u)

/* TPTC_INTCMD */

#define CSL_TPTC_TPTC_INTCMD_EVAL_MASK   (0x00000001u)
#define CSL_TPTC_TPTC_INTCMD_EVAL_SHIFT  (0x00000000u)
#define CSL_TPTC_TPTC_INTCMD_EVAL_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_INTCMD_SET_MASK    (0x00000002u)
#define CSL_TPTC_TPTC_INTCMD_SET_SHIFT   (0x00000001u)
#define CSL_TPTC_TPTC_INTCMD_SET_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_INTCMD_RESETVAL    (0x00000000u)

/* TPTC_ERRSTAT */

#define CSL_TPTC_TPTC_ERRSTAT_BUSERR_MASK (0x00000001u)
#define CSL_TPTC_TPTC_ERRSTAT_BUSERR_SHIFT (0x00000000u)
#define CSL_TPTC_TPTC_ERRSTAT_BUSERR_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_ERRSTAT_TRERR_MASK (0x00000002u)
#define CSL_TPTC_TPTC_ERRSTAT_TRERR_SHIFT (0x00000001u)
#define CSL_TPTC_TPTC_ERRSTAT_TRERR_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_ERRSTAT_MMRAERR_MASK (0x00000008u)
#define CSL_TPTC_TPTC_ERRSTAT_MMRAERR_SHIFT (0x00000003u)
#define CSL_TPTC_TPTC_ERRSTAT_MMRAERR_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_ERRSTAT_RESETVAL   (0x00000000u)

/* TPTC_ERREN */

#define CSL_TPTC_TPTC_ERREN_BUSERR_MASK  (0x00000001u)
#define CSL_TPTC_TPTC_ERREN_BUSERR_SHIFT (0x00000000u)
#define CSL_TPTC_TPTC_ERREN_BUSERR_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_ERREN_TRERR_MASK   (0x00000002u)
#define CSL_TPTC_TPTC_ERREN_TRERR_SHIFT  (0x00000001u)
#define CSL_TPTC_TPTC_ERREN_TRERR_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_ERREN_MMRAERR_MASK (0x00000008u)
#define CSL_TPTC_TPTC_ERREN_MMRAERR_SHIFT (0x00000003u)
#define CSL_TPTC_TPTC_ERREN_MMRAERR_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_ERREN_RESETVAL     (0x00000000u)

/* TPTC_ERRCLR */

#define CSL_TPTC_TPTC_ERRCLR_BUSERR_MASK (0x00000001u)
#define CSL_TPTC_TPTC_ERRCLR_BUSERR_SHIFT (0x00000000u)
#define CSL_TPTC_TPTC_ERRCLR_BUSERR_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_ERRCLR_TRERR_MASK  (0x00000002u)
#define CSL_TPTC_TPTC_ERRCLR_TRERR_SHIFT (0x00000001u)
#define CSL_TPTC_TPTC_ERRCLR_TRERR_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_ERRCLR_MMRAERR_MASK (0x00000008u)
#define CSL_TPTC_TPTC_ERRCLR_MMRAERR_SHIFT (0x00000003u)
#define CSL_TPTC_TPTC_ERRCLR_MMRAERR_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_ERRCLR_RESETVAL    (0x00000000u)

/* TPTC_ERRDET */

#define CSL_TPTC_TPTC_ERRDET_STAT_MASK   (0x0000000Fu)
#define CSL_TPTC_TPTC_ERRDET_STAT_SHIFT  (0x00000000u)
#define CSL_TPTC_TPTC_ERRDET_STAT_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_ERRDET_TCC_MASK    (0x00003F00u)
#define CSL_TPTC_TPTC_ERRDET_TCC_SHIFT   (0x00000008u)
#define CSL_TPTC_TPTC_ERRDET_TCC_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_ERRDET_TCINTEN_MASK (0x00010000u)
#define CSL_TPTC_TPTC_ERRDET_TCINTEN_SHIFT (0x00000010u)
#define CSL_TPTC_TPTC_ERRDET_TCINTEN_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_ERRDET_TCCHEN_MASK (0x00020000u)
#define CSL_TPTC_TPTC_ERRDET_TCCHEN_SHIFT (0x00000011u)
#define CSL_TPTC_TPTC_ERRDET_TCCHEN_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_ERRDET_RESETVAL    (0x00000000u)

/* TPTC_ERRCMD */

#define CSL_TPTC_TPTC_ERRCMD_EVAL_MASK   (0x00000001u)
#define CSL_TPTC_TPTC_ERRCMD_EVAL_SHIFT  (0x00000000u)
#define CSL_TPTC_TPTC_ERRCMD_EVAL_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_ERRCMD_SET_MASK    (0x00000002u)
#define CSL_TPTC_TPTC_ERRCMD_SET_SHIFT   (0x00000001u)
#define CSL_TPTC_TPTC_ERRCMD_SET_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_ERRCMD_RESETVAL    (0x00000000u)

/* TPTC_RDRATE */

#define CSL_TPTC_TPTC_RDRATE_RDRATE_MASK (0x00000003u)
#define CSL_TPTC_TPTC_RDRATE_RDRATE_SHIFT (0x00000000u)
#define CSL_TPTC_TPTC_RDRATE_RDRATE_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_RDRATE_RESETVAL    (0x00000000u)

/* TPTC_POPT */

#define CSL_TPTC_TPTC_POPT_SAM_MASK      (0x00000001u)
#define CSL_TPTC_TPTC_POPT_SAM_SHIFT     (0x00000000u)
#define CSL_TPTC_TPTC_POPT_SAM_RESETVAL  (0x00000000u)

#define CSL_TPTC_TPTC_POPT_DAM_MASK      (0x00000002u)
#define CSL_TPTC_TPTC_POPT_DAM_SHIFT     (0x00000001u)
#define CSL_TPTC_TPTC_POPT_DAM_RESETVAL  (0x00000000u)

#define CSL_TPTC_TPTC_POPT_PRIORITY_MASK (0x00000070u)
#define CSL_TPTC_TPTC_POPT_PRIORITY_SHIFT (0x00000004u)
#define CSL_TPTC_TPTC_POPT_PRIORITY_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_POPT_FWID_MASK     (0x00000700u)
#define CSL_TPTC_TPTC_POPT_FWID_SHIFT    (0x00000008u)
#define CSL_TPTC_TPTC_POPT_FWID_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_POPT_TCC_MASK      (0x0003F000u)
#define CSL_TPTC_TPTC_POPT_TCC_SHIFT     (0x0000000Cu)
#define CSL_TPTC_TPTC_POPT_TCC_RESETVAL  (0x00000000u)

#define CSL_TPTC_TPTC_POPT_TCINTEN_MASK  (0x00100000u)
#define CSL_TPTC_TPTC_POPT_TCINTEN_SHIFT (0x00000014u)
#define CSL_TPTC_TPTC_POPT_TCINTEN_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_POPT_TCCHEN_MASK   (0x00400000u)
#define CSL_TPTC_TPTC_POPT_TCCHEN_SHIFT  (0x00000016u)
#define CSL_TPTC_TPTC_POPT_TCCHEN_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_POPT_RESETVAL      (0x00000000u)

/* TPTC_PSRC */

#define CSL_TPTC_TPTC_PSRC_SADDR_MASK    (0xFFFFFFFFu)
#define CSL_TPTC_TPTC_PSRC_SADDR_SHIFT   (0x00000000u)
#define CSL_TPTC_TPTC_PSRC_SADDR_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_PSRC_RESETVAL      (0x00000000u)

/* TPTC_PCNT */

#define CSL_TPTC_TPTC_PCNT_ACNT_MASK     (0x0000FFFFu)
#define CSL_TPTC_TPTC_PCNT_ACNT_SHIFT    (0x00000000u)
#define CSL_TPTC_TPTC_PCNT_ACNT_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_PCNT_BCNT_MASK     (0xFFFF0000u)
#define CSL_TPTC_TPTC_PCNT_BCNT_SHIFT    (0x00000010u)
#define CSL_TPTC_TPTC_PCNT_BCNT_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_PCNT_RESETVAL      (0x00000000u)

/* TPTC_PDST */

#define CSL_TPTC_TPTC_PDST_DADDR_MASK    (0xFFFFFFFFu)
#define CSL_TPTC_TPTC_PDST_DADDR_SHIFT   (0x00000000u)
#define CSL_TPTC_TPTC_PDST_DADDR_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_PDST_RESETVAL      (0x00000000u)

/* TPTC_PBIDX */

#define CSL_TPTC_TPTC_PBIDX_SBIDX_MASK   (0x0000FFFFu)
#define CSL_TPTC_TPTC_PBIDX_SBIDX_SHIFT  (0x00000000u)
#define CSL_TPTC_TPTC_PBIDX_SBIDX_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_PBIDX_DBIDX_MASK   (0xFFFF0000u)
#define CSL_TPTC_TPTC_PBIDX_DBIDX_SHIFT  (0x00000010u)
#define CSL_TPTC_TPTC_PBIDX_DBIDX_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_PBIDX_RESETVAL     (0x00000000u)

/* TPTC_PMPPRXY */

#define CSL_TPTC_TPTC_PMPPRXY_PRIVID_MASK (0x0000000Fu)
#define CSL_TPTC_TPTC_PMPPRXY_PRIVID_SHIFT (0x00000000u)
#define CSL_TPTC_TPTC_PMPPRXY_PRIVID_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_PMPPRXY_PRIV_MASK  (0x00000100u)
#define CSL_TPTC_TPTC_PMPPRXY_PRIV_SHIFT (0x00000008u)
#define CSL_TPTC_TPTC_PMPPRXY_PRIV_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_PMPPRXY_SECURE_MASK (0x00000200u)
#define CSL_TPTC_TPTC_PMPPRXY_SECURE_SHIFT (0x00000009u)
#define CSL_TPTC_TPTC_PMPPRXY_SECURE_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_PMPPRXY_RESETVAL   (0x00000000u)

/* TPTC_SAOPT */

#define CSL_TPTC_TPTC_SAOPT_SAM_MASK     (0x00000001u)
#define CSL_TPTC_TPTC_SAOPT_SAM_SHIFT    (0x00000000u)
#define CSL_TPTC_TPTC_SAOPT_SAM_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_SAOPT_DAM_MASK     (0x00000002u)
#define CSL_TPTC_TPTC_SAOPT_DAM_SHIFT    (0x00000001u)
#define CSL_TPTC_TPTC_SAOPT_DAM_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_SAOPT_PRIORITY_MASK (0x00000070u)
#define CSL_TPTC_TPTC_SAOPT_PRIORITY_SHIFT (0x00000004u)
#define CSL_TPTC_TPTC_SAOPT_PRIORITY_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_SAOPT_FWID_MASK    (0x00000700u)
#define CSL_TPTC_TPTC_SAOPT_FWID_SHIFT   (0x00000008u)
#define CSL_TPTC_TPTC_SAOPT_FWID_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_SAOPT_TCC_MASK     (0x0003F000u)
#define CSL_TPTC_TPTC_SAOPT_TCC_SHIFT    (0x0000000Cu)
#define CSL_TPTC_TPTC_SAOPT_TCC_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_SAOPT_TCINTEN_MASK (0x00100000u)
#define CSL_TPTC_TPTC_SAOPT_TCINTEN_SHIFT (0x00000014u)
#define CSL_TPTC_TPTC_SAOPT_TCINTEN_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_SAOPT_TCCHEN_MASK  (0x00400000u)
#define CSL_TPTC_TPTC_SAOPT_TCCHEN_SHIFT (0x00000016u)
#define CSL_TPTC_TPTC_SAOPT_TCCHEN_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_SAOPT_RESETVAL     (0x00000000u)

/* TPTC_SASRC */

#define CSL_TPTC_TPTC_SASRC_SADDR_MASK   (0xFFFFFFFFu)
#define CSL_TPTC_TPTC_SASRC_SADDR_SHIFT  (0x00000000u)
#define CSL_TPTC_TPTC_SASRC_SADDR_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_SASRC_RESETVAL     (0x00000000u)

/* TPTC_SACNT */

#define CSL_TPTC_TPTC_SACNT_ACNT_MASK    (0x0000FFFFu)
#define CSL_TPTC_TPTC_SACNT_ACNT_SHIFT   (0x00000000u)
#define CSL_TPTC_TPTC_SACNT_ACNT_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_SACNT_BCNT_MASK    (0xFFFF0000u)
#define CSL_TPTC_TPTC_SACNT_BCNT_SHIFT   (0x00000010u)
#define CSL_TPTC_TPTC_SACNT_BCNT_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_SACNT_RESETVAL     (0x00000000u)

/* TPTC_SABIDX */

#define CSL_TPTC_TPTC_SABIDX_SBIDX_MASK  (0x0000FFFFu)
#define CSL_TPTC_TPTC_SABIDX_SBIDX_SHIFT (0x00000000u)
#define CSL_TPTC_TPTC_SABIDX_SBIDX_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_SABIDX_DBIDX_MASK  (0xFFFF0000u)
#define CSL_TPTC_TPTC_SABIDX_DBIDX_SHIFT (0x00000010u)
#define CSL_TPTC_TPTC_SABIDX_DBIDX_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_SABIDX_RESETVAL    (0x00000000u)

/* TPTC_SAMPPRXY */

#define CSL_TPTC_TPTC_SAMPPRXY_PRIVID_MASK (0x0000000Fu)
#define CSL_TPTC_TPTC_SAMPPRXY_PRIVID_SHIFT (0x00000000u)
#define CSL_TPTC_TPTC_SAMPPRXY_PRIVID_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_SAMPPRXY_PRIV_MASK (0x00000100u)
#define CSL_TPTC_TPTC_SAMPPRXY_PRIV_SHIFT (0x00000008u)
#define CSL_TPTC_TPTC_SAMPPRXY_PRIV_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_SAMPPRXY_SECURE_MASK (0x00000200u)
#define CSL_TPTC_TPTC_SAMPPRXY_SECURE_SHIFT (0x00000009u)
#define CSL_TPTC_TPTC_SAMPPRXY_SECURE_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_SAMPPRXY_RESETVAL  (0x00000000u)

/* TPTC_SACNTRLD */

#define CSL_TPTC_TPTC_SACNTRLD_ACNTRLD_MASK (0x0000FFFFu)
#define CSL_TPTC_TPTC_SACNTRLD_ACNTRLD_SHIFT (0x00000000u)
#define CSL_TPTC_TPTC_SACNTRLD_ACNTRLD_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_SACNTRLD_RESETVAL  (0x00000000u)

/* TPTC_SASRCBREF */

#define CSL_TPTC_TPTC_SASRCBREF_SADDRBREF_MASK (0xFFFFFFFFu)
#define CSL_TPTC_TPTC_SASRCBREF_SADDRBREF_SHIFT (0x00000000u)
#define CSL_TPTC_TPTC_SASRCBREF_SADDRBREF_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_SASRCBREF_RESETVAL (0x00000000u)

/* TPTC_DFCNTRLD */

#define CSL_TPTC_TPTC_DFCNTRLD_ACNTRLD_MASK (0x0000FFFFu)
#define CSL_TPTC_TPTC_DFCNTRLD_ACNTRLD_SHIFT (0x00000000u)
#define CSL_TPTC_TPTC_DFCNTRLD_ACNTRLD_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_DFCNTRLD_RESETVAL  (0x00000000u)

/* TPTC_DFSRCBREF */

#define CSL_TPTC_TPTC_DFSRCBREF_SADDRBREF_MASK (0xFFFFFFFFu)
#define CSL_TPTC_TPTC_DFSRCBREF_SADDRBREF_SHIFT (0x00000000u)
#define CSL_TPTC_TPTC_DFSRCBREF_SADDRBREF_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_DFSRCBREF_RESETVAL (0x00000000u)

/* TPTC_DFDSTBREF */

#define CSL_TPTC_TPTC_DFDSTBREF_DADDRBREF_MASK (0xFFFFFFFFu)
#define CSL_TPTC_TPTC_DFDSTBREF_DADDRBREF_SHIFT (0x00000000u)
#define CSL_TPTC_TPTC_DFDSTBREF_DADDRBREF_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_DFDSTBREF_RESETVAL (0x00000000u)

/* TPTC_DFOPT0 */

#define CSL_TPTC_TPTC_DFOPT0_SAM_MASK    (0x00000001u)
#define CSL_TPTC_TPTC_DFOPT0_SAM_SHIFT   (0x00000000u)
#define CSL_TPTC_TPTC_DFOPT0_SAM_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_DFOPT0_DAM_MASK    (0x00000002u)
#define CSL_TPTC_TPTC_DFOPT0_DAM_SHIFT   (0x00000001u)
#define CSL_TPTC_TPTC_DFOPT0_DAM_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_DFOPT0_PRIORITY_MASK (0x00000070u)
#define CSL_TPTC_TPTC_DFOPT0_PRIORITY_SHIFT (0x00000004u)
#define CSL_TPTC_TPTC_DFOPT0_PRIORITY_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_DFOPT0_FWID_MASK   (0x00000700u)
#define CSL_TPTC_TPTC_DFOPT0_FWID_SHIFT  (0x00000008u)
#define CSL_TPTC_TPTC_DFOPT0_FWID_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_DFOPT0_TCC_MASK    (0x0003F000u)
#define CSL_TPTC_TPTC_DFOPT0_TCC_SHIFT   (0x0000000Cu)
#define CSL_TPTC_TPTC_DFOPT0_TCC_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_DFOPT0_TCINTEN_MASK (0x00100000u)
#define CSL_TPTC_TPTC_DFOPT0_TCINTEN_SHIFT (0x00000014u)
#define CSL_TPTC_TPTC_DFOPT0_TCINTEN_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_DFOPT0_TCCHEN_MASK (0x00400000u)
#define CSL_TPTC_TPTC_DFOPT0_TCCHEN_SHIFT (0x00000016u)
#define CSL_TPTC_TPTC_DFOPT0_TCCHEN_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_DFOPT0_RESETVAL    (0x00000000u)

/* TPTC_DFCNT0 */

#define CSL_TPTC_TPTC_DFCNT0_ACNT_MASK   (0x0000FFFFu)
#define CSL_TPTC_TPTC_DFCNT0_ACNT_SHIFT  (0x00000000u)
#define CSL_TPTC_TPTC_DFCNT0_ACNT_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_DFCNT0_BCNT_MASK   (0xFFFF0000u)
#define CSL_TPTC_TPTC_DFCNT0_BCNT_SHIFT  (0x00000010u)
#define CSL_TPTC_TPTC_DFCNT0_BCNT_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_DFCNT0_RESETVAL    (0x00000000u)

/* TPTC_DFDST0 */

#define CSL_TPTC_TPTC_DFDST0_DADDR_MASK  (0xFFFFFFFFu)
#define CSL_TPTC_TPTC_DFDST0_DADDR_SHIFT (0x00000000u)
#define CSL_TPTC_TPTC_DFDST0_DADDR_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_DFDST0_RESETVAL    (0x00000000u)

/* TPTC_DFBIDX0 */

#define CSL_TPTC_TPTC_DFBIDX0_SBIDX_MASK (0x0000FFFFu)
#define CSL_TPTC_TPTC_DFBIDX0_SBIDX_SHIFT (0x00000000u)
#define CSL_TPTC_TPTC_DFBIDX0_SBIDX_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_DFBIDX0_DBIDX_MASK (0xFFFF0000u)
#define CSL_TPTC_TPTC_DFBIDX0_DBIDX_SHIFT (0x00000010u)
#define CSL_TPTC_TPTC_DFBIDX0_DBIDX_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_DFBIDX0_RESETVAL   (0x00000000u)

/* TPTC_DFMPPRXY0 */

#define CSL_TPTC_TPTC_DFMPPRXY0_PRIVID_MASK (0x0000000Fu)
#define CSL_TPTC_TPTC_DFMPPRXY0_PRIVID_SHIFT (0x00000000u)
#define CSL_TPTC_TPTC_DFMPPRXY0_PRIVID_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_DFMPPRXY0_PRIV_MASK (0x00000100u)
#define CSL_TPTC_TPTC_DFMPPRXY0_PRIV_SHIFT (0x00000008u)
#define CSL_TPTC_TPTC_DFMPPRXY0_PRIV_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_DFMPPRXY0_SECURE_MASK (0x00000200u)
#define CSL_TPTC_TPTC_DFMPPRXY0_SECURE_SHIFT (0x00000009u)
#define CSL_TPTC_TPTC_DFMPPRXY0_SECURE_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_DFMPPRXY0_RESETVAL (0x00000000u)

/* TPTC_DFOPT1 */

#define CSL_TPTC_TPTC_DFOPT1_SAM_MASK    (0x00000001u)
#define CSL_TPTC_TPTC_DFOPT1_SAM_SHIFT   (0x00000000u)
#define CSL_TPTC_TPTC_DFOPT1_SAM_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_DFOPT1_DAM_MASK    (0x00000002u)
#define CSL_TPTC_TPTC_DFOPT1_DAM_SHIFT   (0x00000001u)
#define CSL_TPTC_TPTC_DFOPT1_DAM_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_DFOPT1_PRIORITY_MASK (0x00000070u)
#define CSL_TPTC_TPTC_DFOPT1_PRIORITY_SHIFT (0x00000004u)
#define CSL_TPTC_TPTC_DFOPT1_PRIORITY_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_DFOPT1_FWID_MASK   (0x00000700u)
#define CSL_TPTC_TPTC_DFOPT1_FWID_SHIFT  (0x00000008u)
#define CSL_TPTC_TPTC_DFOPT1_FWID_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_DFOPT1_TCC_MASK    (0x0003F000u)
#define CSL_TPTC_TPTC_DFOPT1_TCC_SHIFT   (0x0000000Cu)
#define CSL_TPTC_TPTC_DFOPT1_TCC_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_DFOPT1_TCINTEN_MASK (0x00100000u)
#define CSL_TPTC_TPTC_DFOPT1_TCINTEN_SHIFT (0x00000014u)
#define CSL_TPTC_TPTC_DFOPT1_TCINTEN_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_DFOPT1_TCCHEN_MASK (0x00400000u)
#define CSL_TPTC_TPTC_DFOPT1_TCCHEN_SHIFT (0x00000016u)
#define CSL_TPTC_TPTC_DFOPT1_TCCHEN_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_DFOPT1_RESETVAL    (0x00000000u)

/* TPTC_DFCNT1 */

#define CSL_TPTC_TPTC_DFCNT1_ACNT_MASK   (0x0000FFFFu)
#define CSL_TPTC_TPTC_DFCNT1_ACNT_SHIFT  (0x00000000u)
#define CSL_TPTC_TPTC_DFCNT1_ACNT_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_DFCNT1_BCNT_MASK   (0xFFFF0000u)
#define CSL_TPTC_TPTC_DFCNT1_BCNT_SHIFT  (0x00000010u)
#define CSL_TPTC_TPTC_DFCNT1_BCNT_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_DFCNT1_RESETVAL    (0x00000000u)

/* TPTC_DFDST1 */

#define CSL_TPTC_TPTC_DFDST1_DADDR_MASK  (0xFFFFFFFFu)
#define CSL_TPTC_TPTC_DFDST1_DADDR_SHIFT (0x00000000u)
#define CSL_TPTC_TPTC_DFDST1_DADDR_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_DFDST1_RESETVAL    (0x00000000u)

/* TPTC_DFBIDX1 */

#define CSL_TPTC_TPTC_DFBIDX1_SBIDX_MASK (0x0000FFFFu)
#define CSL_TPTC_TPTC_DFBIDX1_SBIDX_SHIFT (0x00000000u)
#define CSL_TPTC_TPTC_DFBIDX1_SBIDX_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_DFBIDX1_DBIDX_MASK (0xFFFF0000u)
#define CSL_TPTC_TPTC_DFBIDX1_DBIDX_SHIFT (0x00000010u)
#define CSL_TPTC_TPTC_DFBIDX1_DBIDX_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_DFBIDX1_RESETVAL   (0x00000000u)

/* TPTC_DFMPPRXY1 */

#define CSL_TPTC_TPTC_DFMPPRXY1_PRIVID_MASK (0x0000000Fu)
#define CSL_TPTC_TPTC_DFMPPRXY1_PRIVID_SHIFT (0x00000000u)
#define CSL_TPTC_TPTC_DFMPPRXY1_PRIVID_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_DFMPPRXY1_PRIV_MASK (0x00000100u)
#define CSL_TPTC_TPTC_DFMPPRXY1_PRIV_SHIFT (0x00000008u)
#define CSL_TPTC_TPTC_DFMPPRXY1_PRIV_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_DFMPPRXY1_SECURE_MASK (0x00000200u)
#define CSL_TPTC_TPTC_DFMPPRXY1_SECURE_SHIFT (0x00000009u)
#define CSL_TPTC_TPTC_DFMPPRXY1_SECURE_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_DFMPPRXY1_RESETVAL (0x00000000u)

/* TPTC_DFOPT2 */

#define CSL_TPTC_TPTC_DFOPT2_SAM_MASK    (0x00000001u)
#define CSL_TPTC_TPTC_DFOPT2_SAM_SHIFT   (0x00000000u)
#define CSL_TPTC_TPTC_DFOPT2_SAM_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_DFOPT2_DAM_MASK    (0x00000002u)
#define CSL_TPTC_TPTC_DFOPT2_DAM_SHIFT   (0x00000001u)
#define CSL_TPTC_TPTC_DFOPT2_DAM_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_DFOPT2_PRIORITY_MASK (0x00000070u)
#define CSL_TPTC_TPTC_DFOPT2_PRIORITY_SHIFT (0x00000004u)
#define CSL_TPTC_TPTC_DFOPT2_PRIORITY_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_DFOPT2_FWID_MASK   (0x00000700u)
#define CSL_TPTC_TPTC_DFOPT2_FWID_SHIFT  (0x00000008u)
#define CSL_TPTC_TPTC_DFOPT2_FWID_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_DFOPT2_TCC_MASK    (0x0003F000u)
#define CSL_TPTC_TPTC_DFOPT2_TCC_SHIFT   (0x0000000Cu)
#define CSL_TPTC_TPTC_DFOPT2_TCC_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_DFOPT2_TCINTEN_MASK (0x00100000u)
#define CSL_TPTC_TPTC_DFOPT2_TCINTEN_SHIFT (0x00000014u)
#define CSL_TPTC_TPTC_DFOPT2_TCINTEN_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_DFOPT2_TCCHEN_MASK (0x00400000u)
#define CSL_TPTC_TPTC_DFOPT2_TCCHEN_SHIFT (0x00000016u)
#define CSL_TPTC_TPTC_DFOPT2_TCCHEN_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_DFOPT2_RESETVAL    (0x00000000u)

/* TPTC_DFCNT2 */

#define CSL_TPTC_TPTC_DFCNT2_ACNT_MASK   (0x0000FFFFu)
#define CSL_TPTC_TPTC_DFCNT2_ACNT_SHIFT  (0x00000000u)
#define CSL_TPTC_TPTC_DFCNT2_ACNT_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_DFCNT2_BCNT_MASK   (0xFFFF0000u)
#define CSL_TPTC_TPTC_DFCNT2_BCNT_SHIFT  (0x00000010u)
#define CSL_TPTC_TPTC_DFCNT2_BCNT_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_DFCNT2_RESETVAL    (0x00000000u)

/* TPTC_DFDST2 */

#define CSL_TPTC_TPTC_DFDST2_DADDR_MASK  (0xFFFFFFFFu)
#define CSL_TPTC_TPTC_DFDST2_DADDR_SHIFT (0x00000000u)
#define CSL_TPTC_TPTC_DFDST2_DADDR_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_DFDST2_RESETVAL    (0x00000000u)

/* TPTC_DFBIDX2 */

#define CSL_TPTC_TPTC_DFBIDX2_SBIDX_MASK (0x0000FFFFu)
#define CSL_TPTC_TPTC_DFBIDX2_SBIDX_SHIFT (0x00000000u)
#define CSL_TPTC_TPTC_DFBIDX2_SBIDX_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_DFBIDX2_DBIDX_MASK (0xFFFF0000u)
#define CSL_TPTC_TPTC_DFBIDX2_DBIDX_SHIFT (0x00000010u)
#define CSL_TPTC_TPTC_DFBIDX2_DBIDX_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_DFBIDX2_RESETVAL   (0x00000000u)

/* TPTC_DFMPPRXY2 */

#define CSL_TPTC_TPTC_DFMPPRXY2_PRIVID_MASK (0x0000000Fu)
#define CSL_TPTC_TPTC_DFMPPRXY2_PRIVID_SHIFT (0x00000000u)
#define CSL_TPTC_TPTC_DFMPPRXY2_PRIVID_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_DFMPPRXY2_PRIV_MASK (0x00000100u)
#define CSL_TPTC_TPTC_DFMPPRXY2_PRIV_SHIFT (0x00000008u)
#define CSL_TPTC_TPTC_DFMPPRXY2_PRIV_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_DFMPPRXY2_SECURE_MASK (0x00000200u)
#define CSL_TPTC_TPTC_DFMPPRXY2_SECURE_SHIFT (0x00000009u)
#define CSL_TPTC_TPTC_DFMPPRXY2_SECURE_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_DFMPPRXY2_RESETVAL (0x00000000u)

/* TPTC_DFOPT3 */

#define CSL_TPTC_TPTC_DFOPT3_SAM_MASK    (0x00000001u)
#define CSL_TPTC_TPTC_DFOPT3_SAM_SHIFT   (0x00000000u)
#define CSL_TPTC_TPTC_DFOPT3_SAM_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_DFOPT3_DAM_MASK    (0x00000002u)
#define CSL_TPTC_TPTC_DFOPT3_DAM_SHIFT   (0x00000001u)
#define CSL_TPTC_TPTC_DFOPT3_DAM_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_DFOPT3_PRIORITY_MASK (0x00000070u)
#define CSL_TPTC_TPTC_DFOPT3_PRIORITY_SHIFT (0x00000004u)
#define CSL_TPTC_TPTC_DFOPT3_PRIORITY_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_DFOPT3_FWID_MASK   (0x00000700u)
#define CSL_TPTC_TPTC_DFOPT3_FWID_SHIFT  (0x00000008u)
#define CSL_TPTC_TPTC_DFOPT3_FWID_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_DFOPT3_TCC_MASK    (0x0003F000u)
#define CSL_TPTC_TPTC_DFOPT3_TCC_SHIFT   (0x0000000Cu)
#define CSL_TPTC_TPTC_DFOPT3_TCC_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_DFOPT3_TCINTEN_MASK (0x00100000u)
#define CSL_TPTC_TPTC_DFOPT3_TCINTEN_SHIFT (0x00000014u)
#define CSL_TPTC_TPTC_DFOPT3_TCINTEN_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_DFOPT3_TCCHEN_MASK (0x00400000u)
#define CSL_TPTC_TPTC_DFOPT3_TCCHEN_SHIFT (0x00000016u)
#define CSL_TPTC_TPTC_DFOPT3_TCCHEN_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_DFOPT3_RESETVAL    (0x00000000u)

/* TPTC_DFCNT3 */

#define CSL_TPTC_TPTC_DFCNT3_ACNT_MASK   (0x0000FFFFu)
#define CSL_TPTC_TPTC_DFCNT3_ACNT_SHIFT  (0x00000000u)
#define CSL_TPTC_TPTC_DFCNT3_ACNT_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_DFCNT3_BCNT_MASK   (0xFFFF0000u)
#define CSL_TPTC_TPTC_DFCNT3_BCNT_SHIFT  (0x00000010u)
#define CSL_TPTC_TPTC_DFCNT3_BCNT_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_DFCNT3_RESETVAL    (0x00000000u)

/* TPTC_DFDST3 */

#define CSL_TPTC_TPTC_DFDST3_DADDR_MASK  (0xFFFFFFFFu)
#define CSL_TPTC_TPTC_DFDST3_DADDR_SHIFT (0x00000000u)
#define CSL_TPTC_TPTC_DFDST3_DADDR_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_DFDST3_RESETVAL    (0x00000000u)

/* TPTC_DFBIDX3 */

#define CSL_TPTC_TPTC_DFBIDX3_SBIDX_MASK (0x0000FFFFu)
#define CSL_TPTC_TPTC_DFBIDX3_SBIDX_SHIFT (0x00000000u)
#define CSL_TPTC_TPTC_DFBIDX3_SBIDX_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_DFBIDX3_DBIDX_MASK (0xFFFF0000u)
#define CSL_TPTC_TPTC_DFBIDX3_DBIDX_SHIFT (0x00000010u)
#define CSL_TPTC_TPTC_DFBIDX3_DBIDX_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_DFBIDX3_RESETVAL   (0x00000000u)

/* TPTC_DFMPPRXY3 */

#define CSL_TPTC_TPTC_DFMPPRXY3_PRIVID_MASK (0x0000000Fu)
#define CSL_TPTC_TPTC_DFMPPRXY3_PRIVID_SHIFT (0x00000000u)
#define CSL_TPTC_TPTC_DFMPPRXY3_PRIVID_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_DFMPPRXY3_PRIV_MASK (0x00000100u)
#define CSL_TPTC_TPTC_DFMPPRXY3_PRIV_SHIFT (0x00000008u)
#define CSL_TPTC_TPTC_DFMPPRXY3_PRIV_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_DFMPPRXY3_SECURE_MASK (0x00000200u)
#define CSL_TPTC_TPTC_DFMPPRXY3_SECURE_SHIFT (0x00000009u)
#define CSL_TPTC_TPTC_DFMPPRXY3_SECURE_RESETVAL (0x00000000u)

#define CSL_TPTC_TPTC_DFMPPRXY3_RESETVAL (0x00000000u)

#endif
