/********************************************************************
* Copyright (C) 2003-2010 Texas Instruments Incorporated.
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/
#ifndef _CSLR_QM_INTD_H_
#define _CSLR_QM_INTD_H_

/* CSL Modification:
 *  The file has been modified from the AUTOGEN file for the following
 *  reasons:-
 *      a) Modified the header file includes to be RTSC compliant
 */

#include <ti/csl/cslr.h>
#include <ti/csl/tistdtypes.h>

/* Minimum unit = 1 byte */

/**************************************************************************\
* Register Overlay Structure
\**************************************************************************/
typedef struct  {
    volatile Uint32 REVISION_REG;
    volatile Uint8 RSVD0[12];
    volatile Uint32 EOI_REG;
    volatile Uint32 INTR_VECTOR_REG;
    volatile Uint8 RSVD1[488];
    volatile Uint32 STATUS_REG0;
    volatile Uint32 STATUS_REG1;
    volatile Uint32 STATUS_REG2;
    volatile Uint32 STATUS_REG3;
    volatile Uint32 STATUS_REG4;
    volatile Uint8 RSVD2[108];
    volatile Uint32 STATUS_CLR_REG0;
    volatile Uint32 STATUS_CLR_REG1;
    volatile Uint8 RSVD3[8];
    volatile Uint32 STATUS_CLR_REG4;
    volatile Uint8 RSVD4[108];
    volatile Uint32 INTCNT_REG[50];
    volatile Uint8 RSVD5[184];
    volatile Uint32 INTR_VECTOR_REG_HOST;
} CSL_Qm_intdRegs;

/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* REVISION_REG */

#define CSL_QM_INTD_REVISION_REG_SCHEME_MASK (0xC0000000u)
#define CSL_QM_INTD_REVISION_REG_SCHEME_SHIFT (0x0000001Eu)
#define CSL_QM_INTD_REVISION_REG_SCHEME_RESETVAL (0x00000001u)

#define CSL_QM_INTD_REVISION_REG_MODULE_MASK (0x0FFF0000u)
#define CSL_QM_INTD_REVISION_REG_MODULE_SHIFT (0x00000010u)
#define CSL_QM_INTD_REVISION_REG_MODULE_RESETVAL (0x00000E83u)

#define CSL_QM_INTD_REVISION_REG_REV_RTL_MASK (0x0000F800u)
#define CSL_QM_INTD_REVISION_REG_REV_RTL_SHIFT (0x0000000Bu)
#define CSL_QM_INTD_REVISION_REG_REV_RTL_RESETVAL (0x00000016u)

#define CSL_QM_INTD_REVISION_REG_REV_MAJOR_MASK (0x00000700u)
#define CSL_QM_INTD_REVISION_REG_REV_MAJOR_SHIFT (0x00000008u)
#define CSL_QM_INTD_REVISION_REG_REV_MAJOR_RESETVAL (0x00000001u)

#define CSL_QM_INTD_REVISION_REG_REV_CUSTOM_MASK (0x000000C0u)
#define CSL_QM_INTD_REVISION_REG_REV_CUSTOM_SHIFT (0x00000006u)
#define CSL_QM_INTD_REVISION_REG_REV_CUSTOM_RESETVAL (0x00000000u)

#define CSL_QM_INTD_REVISION_REG_REV_MINOR_MASK (0x0000003Fu)
#define CSL_QM_INTD_REVISION_REG_REV_MINOR_SHIFT (0x00000000u)
#define CSL_QM_INTD_REVISION_REG_REV_MINOR_RESETVAL (0x00000000u)

#define CSL_QM_INTD_REVISION_REG_RESETVAL (0x4E83B100u)

/* EOI_REG */

#define CSL_QM_INTD_EOI_REG_EOI_VECTOR_MASK (0x000000FFu)
#define CSL_QM_INTD_EOI_REG_EOI_VECTOR_SHIFT (0x00000000u)
#define CSL_QM_INTD_EOI_REG_EOI_VECTOR_RESETVAL (0x00000000u)

#define CSL_QM_INTD_EOI_REG_RESETVAL     (0x00000000u)

/* INTR_VECTOR_REG */

#define CSL_QM_INTD_INTR_VECTOR_REG_INTR_VECTOR_MASK (0xFFFFFFFFu)
#define CSL_QM_INTD_INTR_VECTOR_REG_INTR_VECTOR_SHIFT (0x00000000u)
#define CSL_QM_INTD_INTR_VECTOR_REG_INTR_VECTOR_RESETVAL (0x00000000u)

#define CSL_QM_INTD_INTR_VECTOR_REG_RESETVAL (0x00000000u)

/* STATUS_REG0 */

#define CSL_QM_INTD_STATUS_REG0_STATUS_HOST_HI_IN_INTR_MASK (0xFFFFFFFFu)
#define CSL_QM_INTD_STATUS_REG0_STATUS_HOST_HI_IN_INTR_SHIFT (0x00000000u)
#define CSL_QM_INTD_STATUS_REG0_STATUS_HOST_HI_IN_INTR_RESETVAL (0x00000000u)

#define CSL_QM_INTD_STATUS_REG0_RESETVAL (0x00000000u)

/* STATUS_REG1 */

#define CSL_QM_INTD_STATUS_REG1_STATUS_HOST_LO_IN_INTR_MASK (0x0000FFFFu)
#define CSL_QM_INTD_STATUS_REG1_STATUS_HOST_LO_IN_INTR_SHIFT (0x00000000u)
#define CSL_QM_INTD_STATUS_REG1_STATUS_HOST_LO_IN_INTR_RESETVAL (0x00000000u)

#define CSL_QM_INTD_STATUS_REG1_RESETVAL (0x00000000u)

/* STATUS_REG2 */

#define CSL_QM_INTD_STATUS_REG2_STATUS_HOST_HI_LINTR_MASK (0xFFFFFFFFu)
#define CSL_QM_INTD_STATUS_REG2_STATUS_HOST_HI_LINTR_SHIFT (0x00000000u)
#define CSL_QM_INTD_STATUS_REG2_STATUS_HOST_HI_LINTR_RESETVAL (0x00000000u)

#define CSL_QM_INTD_STATUS_REG2_RESETVAL (0x00000000u)

/* STATUS_REG3 */

#define CSL_QM_INTD_STATUS_REG3_STATUS_HOST_LO_LINTR_MASK (0x0001FFFFu)
#define CSL_QM_INTD_STATUS_REG3_STATUS_HOST_LO_LINTR_SHIFT (0x00000000u)
#define CSL_QM_INTD_STATUS_REG3_STATUS_HOST_LO_LINTR_RESETVAL (0x00000000u)

#define CSL_QM_INTD_STATUS_REG3_RESETVAL (0x00000000u)

/* STATUS_REG4 */

#define CSL_QM_INTD_STATUS_REG4_STATUS_HOST_CDMA_STARVE0_MASK (0x00000001u)
#define CSL_QM_INTD_STATUS_REG4_STATUS_HOST_CDMA_STARVE0_SHIFT (0x00000000u)
#define CSL_QM_INTD_STATUS_REG4_STATUS_HOST_CDMA_STARVE0_RESETVAL (0x00000000u)

#define CSL_QM_INTD_STATUS_REG4_STATUS_HOST_CDMA_STARVE1_MASK (0x00000002u)
#define CSL_QM_INTD_STATUS_REG4_STATUS_HOST_CDMA_STARVE1_SHIFT (0x00000001u)
#define CSL_QM_INTD_STATUS_REG4_STATUS_HOST_CDMA_STARVE1_RESETVAL (0x00000000u)

#define CSL_QM_INTD_STATUS_REG4_RESETVAL (0x00000000u)

/* STATUS_CLR_REG0 */

#define CSL_QM_INTD_STATUS_CLR_REG0_STATUS_HOST_HI_IN_INTR_CLR_MASK (0xFFFFFFFFu)
#define CSL_QM_INTD_STATUS_CLR_REG0_STATUS_HOST_HI_IN_INTR_CLR_SHIFT (0x00000000u)
#define CSL_QM_INTD_STATUS_CLR_REG0_STATUS_HOST_HI_IN_INTR_CLR_RESETVAL (0x00000000u)

#define CSL_QM_INTD_STATUS_CLR_REG0_RESETVAL (0x00000000u)

/* STATUS_CLR_REG1 */

#define CSL_QM_INTD_STATUS_CLR_REG1_STATUS_HOST_LO_IN_INTR_CLR_MASK (0x0000FFFFu)
#define CSL_QM_INTD_STATUS_CLR_REG1_STATUS_HOST_LO_IN_INTR_CLR_SHIFT (0x00000000u)
#define CSL_QM_INTD_STATUS_CLR_REG1_STATUS_HOST_LO_IN_INTR_CLR_RESETVAL (0x00000000u)

#define CSL_QM_INTD_STATUS_CLR_REG1_RESETVAL (0x00000000u)

/* STATUS_CLR_REG4 */

#define CSL_QM_INTD_STATUS_CLR_REG4_STATUS_HOST_CDMA_STARVE0_CLR_MASK (0x00000001u)
#define CSL_QM_INTD_STATUS_CLR_REG4_STATUS_HOST_CDMA_STARVE0_CLR_SHIFT (0x00000000u)
#define CSL_QM_INTD_STATUS_CLR_REG4_STATUS_HOST_CDMA_STARVE0_CLR_RESETVAL (0x00000000u)

#define CSL_QM_INTD_STATUS_CLR_REG4_STATUS_HOST_CDMA_STARVE1_CLR_MASK (0x00000002u)
#define CSL_QM_INTD_STATUS_CLR_REG4_STATUS_HOST_CDMA_STARVE1_CLR_SHIFT (0x00000001u)
#define CSL_QM_INTD_STATUS_CLR_REG4_STATUS_HOST_CDMA_STARVE1_CLR_RESETVAL (0x00000000u)

#define CSL_QM_INTD_STATUS_CLR_REG4_RESETVAL (0x00000000u)

/* INTCNT_REG */

#define CSL_QM_INTD_INTCNT_REG_INTCNT_HOST_CNT_HI_IN_INTR_MASK (0x000000FFu)
#define CSL_QM_INTD_INTCNT_REG_INTCNT_HOST_CNT_HI_IN_INTR_SHIFT (0x00000000u)
#define CSL_QM_INTD_INTCNT_REG_INTCNT_HOST_CNT_HI_IN_INTR_RESETVAL (0x00000000u)

#define CSL_QM_INTD_INTCNT_REG_RESETVAL  (0x00000000u)

/* INTR_VECTOR_REG_HOST */

#define CSL_QM_INTD_INTR_VECTOR_REG_HOST_INTR_VECTOR_HOST_MASK (0xFFFFFFFFu)
#define CSL_QM_INTD_INTR_VECTOR_REG_HOST_INTR_VECTOR_HOST_SHIFT (0x00000000u)
#define CSL_QM_INTD_INTR_VECTOR_REG_HOST_INTR_VECTOR_HOST_RESETVAL (0x00000000u)

#define CSL_QM_INTD_INTR_VECTOR_REG_HOST_RESETVAL (0x00000000u)

#endif
