/********************************************************************
* Copyright (C) 2003-2008 Texas Instruments Incorporated.
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/
#ifndef _CSLR_BOOTCFG_H_
#define _CSLR_BOOTCFG_H_

/* CSL Modification:
 *  The file has been modified from the AUTOGEN file for the following
 *  reasons:-
 *      a) Header files are included as per RTSC guidelines
 *      b) Changed BOOTADDR_GEM0_REG-BOOTADDR_GEM7_REG to an array BOOTADDR_GEM_REG[8]
 *      c) Changed RSTMUX0-RSTMUX7 to an array RSTMUX[8]
 *      d) Changed NMIGR_0-NMIGR_3 to an array NMIGR[8]
 *      e) Changed IPCGR0-IPCGR3 to an array IPCGR[8]
 *      f) Changed IPCAR0-IPCAR3 to an array IPCAR[8]
 *      g) Changed DDR3_CONFIG_REG_0-DDR3_CONFIG_REG_24 to an array DDR3_CONFIG_REG[25]
 */

#include <ti/csl/cslr.h>
#include <ti/csl/tistdtypes.h>

/* Minimum unit = 1 byte */

/**************************************************************************\
* Register Overlay Structure
\**************************************************************************/
typedef struct  {
    volatile Uint32 REVISION_REG;
    volatile Uint8 RSVD0[4];
    volatile Uint32 DIE_ID_REG0;
    volatile Uint32 DIE_ID_REG1;
    volatile Uint32 DIE_ID_REG2;
    volatile Uint32 DIE_ID_REG3;
    volatile Uint32 DEVICE_ID_REG0;
    volatile Uint32 DEVICE_ID_REG1;
    volatile Uint32 BOOT_REG0;
    volatile Uint8 RSVD1[20];
    volatile Uint32 KICK_REG0;
    volatile Uint32 KICK_REG1;
#ifdef CSL_MODIFICATION    
    volatile Uint32 BOOTADDR_GEM0_REG;
    volatile Uint32 BOOTADDR_GEM1_REG;
    volatile Uint32 BOOTADDR_GEM2_REG;
    volatile Uint32 BOOTADDR_GEM3_REG;
    volatile Uint32 BOOTADDR_GEM4_REG;
    volatile Uint32 BOOTADDR_GEM5_REG;
    volatile Uint32 BOOTADDR_GEM6_REG;
    volatile Uint32 BOOTADDR_GEM7_REG;
#else
    volatile Uint32 BOOTADDR_GEM_REG[8];
#endif    
    volatile Uint8 RSVD2[128];
    volatile Uint32 INTR_RAW_STATUS_REG;
    volatile Uint32 INTR_ENABLED_STATUS_REG;
    volatile Uint32 INTR_ENABLE_REG;
    volatile Uint32 INTR_ENABLE_CLR_REG;
    volatile Uint32 EOI_REG;
    volatile Uint32 FAULT_ADDRESS_REG;
    volatile Uint32 FAULT_STATUS_REG;
    volatile Uint32 FAULT_CLEAR_REG;
    volatile Uint8 RSVD3[16];
    volatile Uint32 EMAC_ID1;
    volatile Uint32 EMAC_ID2;
    volatile Uint32 SI_REV;
    volatile Uint8 RSVD4[20];
    volatile Uint32 LRSTNMISTAT_CLR;
    volatile Uint32 RESET_STAT_CLR;
    volatile Uint32 BOOT_LATCH;
    volatile Uint32 BOOT_COMPLETE;
    volatile Uint32 BOOT_PROGRESS;
    volatile Uint32 RESET_STAT;
    volatile Uint32 LRSTNMISTAT;
    volatile Uint32 DEVCFG;
    volatile Uint32 PWR_STAT;
    volatile Uint32 STS_SRIO;
    volatile Uint32 STS_SGMII;
    volatile Uint32 STS_PCIE;
    volatile Uint32 STS_VUSR;
    volatile Uint8 RSVD5[28];
    volatile Uint32 CLASS0_EFUSE_REG;
    volatile Uint8 RSVD6[12];
    volatile Uint32 EFUSE_REG0;
    volatile Uint32 EFUSE_REG1;
    volatile Uint32 EFUSE_REG2;
    volatile Uint32 EFUSE_REG3;
    volatile Uint32 EFUSE_REG4;
    volatile Uint32 EFUSE_REG5;
    volatile Uint32 EFUSE_REG6;
    volatile Uint32 EFUSE_REG7;
    volatile Uint32 EFUSE_REG8;
    volatile Uint32 EFUSE_REG9;
    volatile Uint32 EFUSE_REG10;
    volatile Uint32 EFUSE_REG11;
    volatile Uint32 EFUSE_REG12;
    volatile Uint32 EFUSE_REG13;
    volatile Uint32 EFUSE_REG14;
    volatile Uint32 EFUSE_REG15;
    volatile Uint8 RSVD7[48];
#ifdef CSL_MODIFICATION    
    volatile Uint32 NMIGR_0;
    volatile Uint32 NMIGR_1;
    volatile Uint32 NMIGR_2;
    volatile Uint32 NMIGR_3;
    volatile Uint32 NMIGR_4;
    volatile Uint32 NMIGR_5;
    volatile Uint32 NMIGR_6;
    volatile Uint32 NMIGR_7;
#else
    volatile Uint32 NMIGR[8];
#endif    
    volatile Uint8 RSVD8[32];
#ifdef CSL_MODIFICATION    
    volatile Uint32 IPCGR0;
    volatile Uint32 IPCGR1;
    volatile Uint32 IPCGR2;
    volatile Uint32 IPCGR3;
    volatile Uint32 IPCGR4;
    volatile Uint32 IPCGR5;
    volatile Uint32 IPCGR6;
    volatile Uint32 IPCGR7;
#else
    volatile Uint32 IPCGR[8];
#endif    
    volatile Uint8 RSVD9[28];
    volatile Uint32 IPCGRH;
#ifdef CSL_MODIFICATION    
    volatile Uint32 IPCAR0;
    volatile Uint32 IPCAR1;
    volatile Uint32 IPCAR2;
    volatile Uint32 IPCAR3;
    volatile Uint32 IPCAR4;
    volatile Uint32 IPCAR5;
    volatile Uint32 IPCAR6;
    volatile Uint32 IPCAR7;
#else
    volatile Uint32 IPCAR[8];
#endif    
    volatile Uint8 RSVD10[28];
    volatile Uint32 IPCARH;
    volatile Uint8 RSVD11[64];
    volatile Uint32 TINPSEL;
    volatile Uint32 TOUTSEL;
#ifdef CSL_MODIFICATION    
    volatile Uint32 RSTMUX0;
    volatile Uint32 RSTMUX1;
    volatile Uint32 RSTMUX2;
    volatile Uint32 RSTMUX3;
    volatile Uint32 RSTMUX4;
    volatile Uint32 RSTMUX5;
    volatile Uint32 RSTMUX6;
    volatile Uint32 RSTMUX7;
#else
    volatile Uint32 RSTMUX[8];
#endif
    volatile Uint32 CORE_PLL_CTL0;
    volatile Uint32 CORE_PLL_CTL1;
    volatile Uint32 DDR3_PLL_CTL0;
    volatile Uint32 DDR3_PLL_CTL1;
    volatile Uint32 PA_PLL_CTL0;
    volatile Uint32 PA_PLL_CTL1;
    volatile Uint32 SGMII_CFGPLL;
    volatile Uint32 SGMII_CFGRX0;
    volatile Uint32 SGMII_CFGTX0;
    volatile Uint32 SGMII_CFGRX1;
    volatile Uint32 SGMII_CFGTX1;
    volatile Uint32 SGMII_RSVD;
    volatile Uint32 PCIE_CFGPLL;
    volatile Uint32 PCIE_SERDES_RSVD;
    volatile Uint32 SRIO_SERDES_CFGPLL;
    volatile Uint32 SRIO_SERDES_CFGRX0;
    volatile Uint32 SRIO_SERDES_CFGTX0;
    volatile Uint32 SRIO_SERDES_CFGRX1;
    volatile Uint32 SRIO_SERDES_CFGTX1;
    volatile Uint32 SRIO_SERDES_CFGRX2;
    volatile Uint32 SRIO_SERDES_CFGTX2;
    volatile Uint32 SRIO_SERDES_CFGRX3;
    volatile Uint32 SRIO_SERDES_CFGTX3;
    volatile Uint32 SRIO_SERDES_RSVD;
    volatile Uint32 LED_GEM_PASSDONE;
    volatile Uint32 LED_PLLLOCK;
    volatile Uint32 LED_CHIP_PASSDONE;
    volatile Uint32 TDIODE;
    volatile Uint32 MARGIN;
    volatile Uint32 SECURE_CONTROL;
    volatile Uint8 RSVD12[4];
    volatile Uint32 EFUSE_SECROM_CHKSUM0;
    volatile Uint32 EFUSE_SECROM_CHKSUM1;
    volatile Uint32 OBSCLK_CTL;
    volatile Uint8 RSVD13[4];
    volatile Uint32 VUSR_CFGPLL;
    volatile Uint32 VUSR_CFGRX0;
    volatile Uint32 VUSR_CFGTX0;
    volatile Uint32 VUSR_CFGRX1;
    volatile Uint32 VUSR_CFGTX1;
    volatile Uint32 VUSR_CFGRX2;
    volatile Uint32 VUSR_CFGTX2;
    volatile Uint32 VUSR_CFGRX3;
    volatile Uint32 VUSR_CFGTX3;
    volatile Uint32 VUSR_SERDES_RSVD;
    volatile Uint32 LED_GPIO_CLR;
    volatile Uint32 LED_GPIO;
    volatile Uint8 RSVD14[12];
    volatile Uint32 EFUSE_RSVD0;
    volatile Uint32 EFUSE_RSVD1;
    volatile Uint32 EFUSE_RSVD2;
    volatile Uint32 EFUSE_RSVD3;
    volatile Uint32 CHIP_MISC;
#ifdef CSL_MODIFICATION    
    volatile Uint32 DDR3_CONFIG_REG_0;
    volatile Uint32 DDR3_CONFIG_REG_1;
    volatile Uint32 DDR3_CONFIG_REG_2;
    volatile Uint32 DDR3_CONFIG_REG_3;
    volatile Uint32 DDR3_CONFIG_REG_4;
    volatile Uint32 DDR3_CONFIG_REG_5;
    volatile Uint32 DDR3_CONFIG_REG_6;
    volatile Uint32 DDR3_CONFIG_REG_7;
    volatile Uint32 DDR3_CONFIG_REG_8;
    volatile Uint32 DDR3_CONFIG_REG_9;
    volatile Uint32 DDR3_CONFIG_REG_10;
    volatile Uint32 DDR3_CONFIG_REG_11;
    volatile Uint32 DDR3_CONFIG_REG_12;
    volatile Uint32 DDR3_CONFIG_REG_13;
    volatile Uint32 DDR3_CONFIG_REG_14;
    volatile Uint32 DDR3_CONFIG_REG_15;
    volatile Uint32 DDR3_CONFIG_REG_16;
    volatile Uint32 DDR3_CONFIG_REG_17;
    volatile Uint32 DDR3_CONFIG_REG_18;
    volatile Uint32 DDR3_CONFIG_REG_19;
    volatile Uint32 DDR3_CONFIG_REG_20;
    volatile Uint32 DDR3_CONFIG_REG_21;
    volatile Uint32 DDR3_CONFIG_REG_22;
    volatile Uint32 DDR3_CONFIG_REG_23;
    volatile Uint32 DDR3_CONFIG_REG_24;
#else
    volatile Uint32 DDR3_CONFIG_REG[25];
#endif
    volatile Uint8 RSVD15[7063];
    volatile Uint32 END_POINT;
} CSL_BootcfgRegs;

/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* revision_reg */

#define CSL_BOOTCFG_REVISION_REG_REV_SCHEME_MASK (0xC0000000u)
#define CSL_BOOTCFG_REVISION_REG_REV_SCHEME_SHIFT (0x0000001Eu)
#define CSL_BOOTCFG_REVISION_REG_REV_SCHEME_RESETVAL (0x00000001u)

#define CSL_BOOTCFG_REVISION_REG_REV_MODULE_MASK (0x0FFF0000u)
#define CSL_BOOTCFG_REVISION_REG_REV_MODULE_SHIFT (0x00000010u)
#define CSL_BOOTCFG_REVISION_REG_REV_MODULE_RESETVAL (0x00000E84u)

#define CSL_BOOTCFG_REVISION_REG_REV_RTL_MASK (0x0000F800u)
#define CSL_BOOTCFG_REVISION_REG_REV_RTL_SHIFT (0x0000000Bu)
#define CSL_BOOTCFG_REVISION_REG_REV_RTL_RESETVAL (0x00000025u)

#define CSL_BOOTCFG_REVISION_REG_REV_MAJOR_MASK (0x00000700u)
#define CSL_BOOTCFG_REVISION_REG_REV_MAJOR_SHIFT (0x00000008u)
#define CSL_BOOTCFG_REVISION_REG_REV_MAJOR_RESETVAL (0x00000001u)

#define CSL_BOOTCFG_REVISION_REG_REV_CUSTOM_MASK (0x000000C0u)
#define CSL_BOOTCFG_REVISION_REG_REV_CUSTOM_SHIFT (0x00000006u)
#define CSL_BOOTCFG_REVISION_REG_REV_CUSTOM_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_REVISION_REG_REV_MINOR_MASK (0x0000003Fu)
#define CSL_BOOTCFG_REVISION_REG_REV_MINOR_SHIFT (0x00000000u)
#define CSL_BOOTCFG_REVISION_REG_REV_MINOR_RESETVAL (0x00000001u)

#define CSL_BOOTCFG_REVISION_REG_RESETVAL (0x4E852901u)

/* die_id_reg0 */

#define CSL_BOOTCFG_DIE_ID_REG0_DIE_ID0_MASK (0xFFFFFFFFu)
#define CSL_BOOTCFG_DIE_ID_REG0_DIE_ID0_SHIFT (0x00000000u)
#define CSL_BOOTCFG_DIE_ID_REG0_DIE_ID0_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_DIE_ID_REG0_RESETVAL (0x00000000u)

/* die_id_reg1 */

#define CSL_BOOTCFG_DIE_ID_REG1_DIE_ID1_MASK (0xFFFFFFFFu)
#define CSL_BOOTCFG_DIE_ID_REG1_DIE_ID1_SHIFT (0x00000000u)
#define CSL_BOOTCFG_DIE_ID_REG1_DIE_ID1_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_DIE_ID_REG1_RESETVAL (0x00000000u)

/* die_id_reg2 */

#define CSL_BOOTCFG_DIE_ID_REG2_DIE_ID2_MASK (0xFFFFFFFFu)
#define CSL_BOOTCFG_DIE_ID_REG2_DIE_ID2_SHIFT (0x00000000u)
#define CSL_BOOTCFG_DIE_ID_REG2_DIE_ID2_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_DIE_ID_REG2_RESETVAL (0x00000000u)

/* die_id_reg3 */

#define CSL_BOOTCFG_DIE_ID_REG3_DIE_ID3_MASK (0xFFFFFFFFu)
#define CSL_BOOTCFG_DIE_ID_REG3_DIE_ID3_SHIFT (0x00000000u)
#define CSL_BOOTCFG_DIE_ID_REG3_DIE_ID3_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_DIE_ID_REG3_RESETVAL (0x00000000u)

/* device_id_reg0 */

#define CSL_BOOTCFG_DEVICE_ID_REG0_DEVICE_ID0_MASK (0xFFFFFFFFu)
#define CSL_BOOTCFG_DEVICE_ID_REG0_DEVICE_ID0_SHIFT (0x00000000u)
#define CSL_BOOTCFG_DEVICE_ID_REG0_DEVICE_ID0_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_DEVICE_ID_REG0_RESETVAL (0x00000000u)

/* device_id_reg1 */

#define CSL_BOOTCFG_DEVICE_ID_REG1_DEVICE_ID1_MASK (0xFFFFFFFFu)
#define CSL_BOOTCFG_DEVICE_ID_REG1_DEVICE_ID1_SHIFT (0x00000000u)
#define CSL_BOOTCFG_DEVICE_ID_REG1_DEVICE_ID1_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_DEVICE_ID_REG1_RESETVAL (0x00000000u)

/* boot_reg0 */

#define CSL_BOOTCFG_BOOT_REG0_BIG_ENDIAN_MASK (0x00000001u)
#define CSL_BOOTCFG_BOOT_REG0_BIG_ENDIAN_SHIFT (0x00000000u)
#define CSL_BOOTCFG_BOOT_REG0_BIG_ENDIAN_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_BOOT_REG0_BOOT_MODE_MASK (0x00003FFEu)
#define CSL_BOOTCFG_BOOT_REG0_BOOT_MODE_SHIFT (0x00000001u)
#define CSL_BOOTCFG_BOOT_REG0_BOOT_MODE_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_BOOT_REG0_PA_REFCLK_SEL_MASK (0x00020000u)
#define CSL_BOOTCFG_BOOT_REG0_PA_REFCLK_SEL_SHIFT (0x00000011u)
#define CSL_BOOTCFG_BOOT_REG0_PA_REFCLK_SEL_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_BOOT_REG0_PCIESS_MODE_MASK (0x0000C000u)
#define CSL_BOOTCFG_BOOT_REG0_PCIESS_MODE_SHIFT (0x0000000Eu)
#define CSL_BOOTCFG_BOOT_REG0_PCIESS_MODE_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_BOOT_REG0_PCIESSEN_MASK (0x00010000u)
#define CSL_BOOTCFG_BOOT_REG0_PCIESSEN_SHIFT (0x00000010u)
#define CSL_BOOTCFG_BOOT_REG0_PCIESSEN_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_BOOT_REG0_RESETVAL (0x00000000u)

/* kick_reg0 */

#define CSL_BOOTCFG_KICK_REG0_KICK0_MASK (0xFFFFFFFFu)
#define CSL_BOOTCFG_KICK_REG0_KICK0_SHIFT (0x00000000u)
#define CSL_BOOTCFG_KICK_REG0_KICK0_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_KICK_REG0_RESETVAL (0x00000000u)

/* kick_reg1 */

#define CSL_BOOTCFG_KICK_REG1_KICK1_MASK (0xFFFFFFFFu)
#define CSL_BOOTCFG_KICK_REG1_KICK1_SHIFT (0x00000000u)
#define CSL_BOOTCFG_KICK_REG1_KICK1_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_KICK_REG1_RESETVAL (0x00000000u)

/* bootaddr_gem0_reg */

#define CSL_BOOTCFG_BOOTADDR_GEM0_REG_GEM0_BOOT_RDY_MASK (0x00000001u)
#define CSL_BOOTCFG_BOOTADDR_GEM0_REG_GEM0_BOOT_RDY_SHIFT (0x00000000u)
#define CSL_BOOTCFG_BOOTADDR_GEM0_REG_GEM0_BOOT_RDY_RESETVAL (0x00000001u)

#define CSL_BOOTCFG_BOOTADDR_GEM0_REG_BOOTADDR_GEM0_MASK (0xFFFFFC00u)
#define CSL_BOOTCFG_BOOTADDR_GEM0_REG_BOOTADDR_GEM0_SHIFT (0x0000000Au)
#define CSL_BOOTCFG_BOOTADDR_GEM0_REG_BOOTADDR_GEM0_RESETVAL (0x00082C00u)

#define CSL_BOOTCFG_BOOTADDR_GEM0_REG_RESETVAL (0x20B00001u)

/* bootaddr_gem1_reg */

#define CSL_BOOTCFG_BOOTADDR_GEM1_REG_GEM1_BOOT_RDY_MASK (0x00000001u)
#define CSL_BOOTCFG_BOOTADDR_GEM1_REG_GEM1_BOOT_RDY_SHIFT (0x00000000u)
#define CSL_BOOTCFG_BOOTADDR_GEM1_REG_GEM1_BOOT_RDY_RESETVAL (0x00000001u)

#define CSL_BOOTCFG_BOOTADDR_GEM1_REG_BOOTADDR_GEM1_MASK (0xFFFFFC00u)
#define CSL_BOOTCFG_BOOTADDR_GEM1_REG_BOOTADDR_GEM1_SHIFT (0x0000000Au)
#define CSL_BOOTCFG_BOOTADDR_GEM1_REG_BOOTADDR_GEM1_RESETVAL (0x00082C00u)

#define CSL_BOOTCFG_BOOTADDR_GEM1_REG_RESETVAL (0x20B00001u)

/* bootaddr_gem2_reg */

#define CSL_BOOTCFG_BOOTADDR_GEM2_REG_GEM2_BOOT_RDY_MASK (0x00000001u)
#define CSL_BOOTCFG_BOOTADDR_GEM2_REG_GEM2_BOOT_RDY_SHIFT (0x00000000u)
#define CSL_BOOTCFG_BOOTADDR_GEM2_REG_GEM2_BOOT_RDY_RESETVAL (0x00000001u)

#define CSL_BOOTCFG_BOOTADDR_GEM2_REG_BOOTADDR_GEM2_MASK (0xFFFFFC00u)
#define CSL_BOOTCFG_BOOTADDR_GEM2_REG_BOOTADDR_GEM2_SHIFT (0x0000000Au)
#define CSL_BOOTCFG_BOOTADDR_GEM2_REG_BOOTADDR_GEM2_RESETVAL (0x00082C00u)

#define CSL_BOOTCFG_BOOTADDR_GEM2_REG_RESETVAL (0x20B00001u)

/* bootaddr_gem3_reg */

#define CSL_BOOTCFG_BOOTADDR_GEM3_REG_GEM3_BOOT_RDY_MASK (0x00000001u)
#define CSL_BOOTCFG_BOOTADDR_GEM3_REG_GEM3_BOOT_RDY_SHIFT (0x00000000u)
#define CSL_BOOTCFG_BOOTADDR_GEM3_REG_GEM3_BOOT_RDY_RESETVAL (0x00000001u)

#define CSL_BOOTCFG_BOOTADDR_GEM3_REG_BOOTADDR_GEM3_MASK (0xFFFFFC00u)
#define CSL_BOOTCFG_BOOTADDR_GEM3_REG_BOOTADDR_GEM3_SHIFT (0x0000000Au)
#define CSL_BOOTCFG_BOOTADDR_GEM3_REG_BOOTADDR_GEM3_RESETVAL (0x00082C00u)

#define CSL_BOOTCFG_BOOTADDR_GEM3_REG_RESETVAL (0x20B00001u)

/* bootaddr_gem4_reg */

#define CSL_BOOTCFG_BOOTADDR_GEM4_REG_GEM4_BOOT_RDY_MASK (0x00000001u)
#define CSL_BOOTCFG_BOOTADDR_GEM4_REG_GEM4_BOOT_RDY_SHIFT (0x00000000u)
#define CSL_BOOTCFG_BOOTADDR_GEM4_REG_GEM4_BOOT_RDY_RESETVAL (0x00000001u)

#define CSL_BOOTCFG_BOOTADDR_GEM4_REG_BOOTADDR_GEM4_MASK (0xFFFFFC00u)
#define CSL_BOOTCFG_BOOTADDR_GEM4_REG_BOOTADDR_GEM4_SHIFT (0x0000000Au)
#define CSL_BOOTCFG_BOOTADDR_GEM4_REG_BOOTADDR_GEM4_RESETVAL (0x00082C00u)

#define CSL_BOOTCFG_BOOTADDR_GEM4_REG_RESETVAL (0x20B00001u)

/* bootaddr_gem5_reg */

#define CSL_BOOTCFG_BOOTADDR_GEM5_REG_GEM5_BOOT_RDY_MASK (0x00000001u)
#define CSL_BOOTCFG_BOOTADDR_GEM5_REG_GEM5_BOOT_RDY_SHIFT (0x00000000u)
#define CSL_BOOTCFG_BOOTADDR_GEM5_REG_GEM5_BOOT_RDY_RESETVAL (0x00000001u)

#define CSL_BOOTCFG_BOOTADDR_GEM5_REG_BOOTADDR_GEM5_MASK (0xFFFFFC00u)
#define CSL_BOOTCFG_BOOTADDR_GEM5_REG_BOOTADDR_GEM5_SHIFT (0x0000000Au)
#define CSL_BOOTCFG_BOOTADDR_GEM5_REG_BOOTADDR_GEM5_RESETVAL (0x00082C00u)

#define CSL_BOOTCFG_BOOTADDR_GEM5_REG_RESETVAL (0x20B00001u)

/* bootaddr_gem6_reg */

#define CSL_BOOTCFG_BOOTADDR_GEM6_REG_GEM6_BOOT_RDY_MASK (0x00000001u)
#define CSL_BOOTCFG_BOOTADDR_GEM6_REG_GEM6_BOOT_RDY_SHIFT (0x00000000u)
#define CSL_BOOTCFG_BOOTADDR_GEM6_REG_GEM6_BOOT_RDY_RESETVAL (0x00000001u)

#define CSL_BOOTCFG_BOOTADDR_GEM6_REG_BOOTADDR_GEM6_MASK (0xFFFFFC00u)
#define CSL_BOOTCFG_BOOTADDR_GEM6_REG_BOOTADDR_GEM6_SHIFT (0x0000000Au)
#define CSL_BOOTCFG_BOOTADDR_GEM6_REG_BOOTADDR_GEM6_RESETVAL (0x00082C00u)

#define CSL_BOOTCFG_BOOTADDR_GEM6_REG_RESETVAL (0x20B00001u)

/* bootaddr_gem7_reg */

#define CSL_BOOTCFG_BOOTADDR_GEM7_REG_GEM7_BOOT_RDY_MASK (0x00000001u)
#define CSL_BOOTCFG_BOOTADDR_GEM7_REG_GEM7_BOOT_RDY_SHIFT (0x00000000u)
#define CSL_BOOTCFG_BOOTADDR_GEM7_REG_GEM7_BOOT_RDY_RESETVAL (0x00000001u)

#define CSL_BOOTCFG_BOOTADDR_GEM7_REG_BOOTADDR_GEM7_MASK (0xFFFFFC00u)
#define CSL_BOOTCFG_BOOTADDR_GEM7_REG_BOOTADDR_GEM7_SHIFT (0x0000000Au)
#define CSL_BOOTCFG_BOOTADDR_GEM7_REG_BOOTADDR_GEM7_RESETVAL (0x00082C00u)

#define CSL_BOOTCFG_BOOTADDR_GEM7_REG_RESETVAL (0x20B00001u)

/* intr_raw_status_reg */

#define CSL_BOOTCFG_INTR_RAW_STATUS_REG_ADDR_ERR_MASK (0x00000002u)
#define CSL_BOOTCFG_INTR_RAW_STATUS_REG_ADDR_ERR_SHIFT (0x00000001u)
#define CSL_BOOTCFG_INTR_RAW_STATUS_REG_ADDR_ERR_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_INTR_RAW_STATUS_REG_PROT_ERR_MASK (0x00000001u)
#define CSL_BOOTCFG_INTR_RAW_STATUS_REG_PROT_ERR_SHIFT (0x00000000u)
#define CSL_BOOTCFG_INTR_RAW_STATUS_REG_PROT_ERR_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_INTR_RAW_STATUS_REG_RESETVAL (0x00000000u)

/* intr_enabled_status_reg */

#define CSL_BOOTCFG_INTR_ENABLED_STATUS_REG_ENABLED_ADDR_ERR_MASK (0x00000002u)
#define CSL_BOOTCFG_INTR_ENABLED_STATUS_REG_ENABLED_ADDR_ERR_SHIFT (0x00000001u)
#define CSL_BOOTCFG_INTR_ENABLED_STATUS_REG_ENABLED_ADDR_ERR_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_INTR_ENABLED_STATUS_REG_ENABLED_PROT_ERR_MASK (0x00000001u)
#define CSL_BOOTCFG_INTR_ENABLED_STATUS_REG_ENABLED_PROT_ERR_SHIFT (0x00000000u)
#define CSL_BOOTCFG_INTR_ENABLED_STATUS_REG_ENABLED_PROT_ERR_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_INTR_ENABLED_STATUS_REG_RESETVAL (0x00000000u)

/* intr_enable_reg */

#define CSL_BOOTCFG_INTR_ENABLE_REG_ADDR_ERR_EN_MASK (0x00000002u)
#define CSL_BOOTCFG_INTR_ENABLE_REG_ADDR_ERR_EN_SHIFT (0x00000001u)
#define CSL_BOOTCFG_INTR_ENABLE_REG_ADDR_ERR_EN_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_INTR_ENABLE_REG_PROT_ERR_EN_MASK (0x00000001u)
#define CSL_BOOTCFG_INTR_ENABLE_REG_PROT_ERR_EN_SHIFT (0x00000000u)
#define CSL_BOOTCFG_INTR_ENABLE_REG_PROT_ERR_EN_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_INTR_ENABLE_REG_RESETVAL (0x00000000u)

/* intr_enable_clr_reg */

#define CSL_BOOTCFG_INTR_ENABLE_CLR_REG_ADDR_ERR_EN_CLR_MASK (0x00000002u)
#define CSL_BOOTCFG_INTR_ENABLE_CLR_REG_ADDR_ERR_EN_CLR_SHIFT (0x00000001u)
#define CSL_BOOTCFG_INTR_ENABLE_CLR_REG_ADDR_ERR_EN_CLR_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_INTR_ENABLE_CLR_REG_PROT_ERR_EN_CLR_MASK (0x00000001u)
#define CSL_BOOTCFG_INTR_ENABLE_CLR_REG_PROT_ERR_EN_CLR_SHIFT (0x00000000u)
#define CSL_BOOTCFG_INTR_ENABLE_CLR_REG_PROT_ERR_EN_CLR_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_INTR_ENABLE_CLR_REG_RESETVAL (0x00000000u)

/* eoi_reg */

#define CSL_BOOTCFG_EOI_REG_EOI_VECTOR_MASK (0x000000FFu)
#define CSL_BOOTCFG_EOI_REG_EOI_VECTOR_SHIFT (0x00000000u)
#define CSL_BOOTCFG_EOI_REG_EOI_VECTOR_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_EOI_REG_RESETVAL  (0x00000000u)

/* fault_address_reg */

#define CSL_BOOTCFG_FAULT_ADDRESS_REG_FAULT_ADDR_MASK (0xFFFFFFFFu)
#define CSL_BOOTCFG_FAULT_ADDRESS_REG_FAULT_ADDR_SHIFT (0x00000000u)
#define CSL_BOOTCFG_FAULT_ADDRESS_REG_FAULT_ADDR_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_FAULT_ADDRESS_REG_RESETVAL (0x00000000u)

/* fault_status_reg */

#define CSL_BOOTCFG_FAULT_STATUS_REG_FAULT_ID_MASK (0x0F000000u)
#define CSL_BOOTCFG_FAULT_STATUS_REG_FAULT_ID_SHIFT (0x00000018u)
#define CSL_BOOTCFG_FAULT_STATUS_REG_FAULT_ID_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_FAULT_STATUS_REG_FAULT_MSTID_MASK (0x00FF0000u)
#define CSL_BOOTCFG_FAULT_STATUS_REG_FAULT_MSTID_SHIFT (0x00000010u)
#define CSL_BOOTCFG_FAULT_STATUS_REG_FAULT_MSTID_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_FAULT_STATUS_REG_FAULT_PRIVID_MASK (0x00001E00u)
#define CSL_BOOTCFG_FAULT_STATUS_REG_FAULT_PRIVID_SHIFT (0x00000009u)
#define CSL_BOOTCFG_FAULT_STATUS_REG_FAULT_PRIVID_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_FAULT_STATUS_REG_FAULT_NS_MASK (0x00000080u)
#define CSL_BOOTCFG_FAULT_STATUS_REG_FAULT_NS_SHIFT (0x00000007u)
#define CSL_BOOTCFG_FAULT_STATUS_REG_FAULT_NS_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_FAULT_STATUS_REG_FAULT_TYPE_MASK (0x0000003Fu)
#define CSL_BOOTCFG_FAULT_STATUS_REG_FAULT_TYPE_SHIFT (0x00000000u)
#define CSL_BOOTCFG_FAULT_STATUS_REG_FAULT_TYPE_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_FAULT_STATUS_REG_RESETVAL (0x00000000u)

/* fault_clear_reg */

#define CSL_BOOTCFG_FAULT_CLEAR_REG_FAULT_CLEAR_MASK (0x00000001u)
#define CSL_BOOTCFG_FAULT_CLEAR_REG_FAULT_CLEAR_SHIFT (0x00000000u)
#define CSL_BOOTCFG_FAULT_CLEAR_REG_FAULT_CLEAR_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_FAULT_CLEAR_REG_RESETVAL (0x00000000u)

/* emac_id1 */

#define CSL_BOOTCFG_EMAC_ID1_EMAC_ID1_MASK (0xFFFFFFFFu)
#define CSL_BOOTCFG_EMAC_ID1_EMAC_ID1_SHIFT (0x00000000u)
#define CSL_BOOTCFG_EMAC_ID1_EMAC_ID1_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_EMAC_ID1_RESETVAL (0x00000000u)

/* emac_id2 */

#define CSL_BOOTCFG_EMAC_ID2_EMAC_ID2_MASK (0xFFFFFFFFu)
#define CSL_BOOTCFG_EMAC_ID2_EMAC_ID2_SHIFT (0x00000000u)
#define CSL_BOOTCFG_EMAC_ID2_EMAC_ID2_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_EMAC_ID2_RESETVAL (0x00000000u)

/* si_rev */

#define CSL_BOOTCFG_SI_REV_SI_REV_MASK (0xFFFFFFFFu)
#define CSL_BOOTCFG_SI_REV_SI_REV_SHIFT (0x00000000u)
#define CSL_BOOTCFG_SI_REV_SI_REV_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_SI_REV_RESETVAL   (0x00000000u)

/* lrstnmistat_clr */

#define CSL_BOOTCFG_LRSTNMISTAT_CLR_LRESET_STAT_0_CLR_MASK (0x00000001u)
#define CSL_BOOTCFG_LRSTNMISTAT_CLR_LRESET_STAT_0_CLR_SHIFT (0x00000000u)
#define CSL_BOOTCFG_LRSTNMISTAT_CLR_LRESET_STAT_0_CLR_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_LRSTNMISTAT_CLR_LRESET_STAT_1_CLR_MASK (0x00000002u)
#define CSL_BOOTCFG_LRSTNMISTAT_CLR_LRESET_STAT_1_CLR_SHIFT (0x00000001u)
#define CSL_BOOTCFG_LRSTNMISTAT_CLR_LRESET_STAT_1_CLR_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_LRSTNMISTAT_CLR_LRESET_STAT_2_CLR_MASK (0x00000004u)
#define CSL_BOOTCFG_LRSTNMISTAT_CLR_LRESET_STAT_2_CLR_SHIFT (0x00000002u)
#define CSL_BOOTCFG_LRSTNMISTAT_CLR_LRESET_STAT_2_CLR_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_LRSTNMISTAT_CLR_LRESET_STAT_3_CLR_MASK (0x00000008u)
#define CSL_BOOTCFG_LRSTNMISTAT_CLR_LRESET_STAT_3_CLR_SHIFT (0x00000003u)
#define CSL_BOOTCFG_LRSTNMISTAT_CLR_LRESET_STAT_3_CLR_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_LRSTNMISTAT_CLR_LRESET_STAT_4_CLR_MASK (0x00000010u)
#define CSL_BOOTCFG_LRSTNMISTAT_CLR_LRESET_STAT_4_CLR_SHIFT (0x00000004u)
#define CSL_BOOTCFG_LRSTNMISTAT_CLR_LRESET_STAT_4_CLR_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_LRSTNMISTAT_CLR_LRESET_STAT_5_CLR_MASK (0x00000020u)
#define CSL_BOOTCFG_LRSTNMISTAT_CLR_LRESET_STAT_5_CLR_SHIFT (0x00000005u)
#define CSL_BOOTCFG_LRSTNMISTAT_CLR_LRESET_STAT_5_CLR_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_LRSTNMISTAT_CLR_LRESET_STAT_6_CLR_MASK (0x00000040u)
#define CSL_BOOTCFG_LRSTNMISTAT_CLR_LRESET_STAT_6_CLR_SHIFT (0x00000006u)
#define CSL_BOOTCFG_LRSTNMISTAT_CLR_LRESET_STAT_6_CLR_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_LRSTNMISTAT_CLR_LRESET_STAT_7_CLR_MASK (0x00000080u)
#define CSL_BOOTCFG_LRSTNMISTAT_CLR_LRESET_STAT_7_CLR_SHIFT (0x00000007u)
#define CSL_BOOTCFG_LRSTNMISTAT_CLR_LRESET_STAT_7_CLR_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_LRSTNMISTAT_CLR_NMI_STAT_0_CLR_MASK (0x00000100u)
#define CSL_BOOTCFG_LRSTNMISTAT_CLR_NMI_STAT_0_CLR_SHIFT (0x00000008u)
#define CSL_BOOTCFG_LRSTNMISTAT_CLR_NMI_STAT_0_CLR_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_LRSTNMISTAT_CLR_NMI_STAT_1_CLR_MASK (0x00000200u)
#define CSL_BOOTCFG_LRSTNMISTAT_CLR_NMI_STAT_1_CLR_SHIFT (0x00000009u)
#define CSL_BOOTCFG_LRSTNMISTAT_CLR_NMI_STAT_1_CLR_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_LRSTNMISTAT_CLR_NMI_STAT_2_CLR_MASK (0x00000400u)
#define CSL_BOOTCFG_LRSTNMISTAT_CLR_NMI_STAT_2_CLR_SHIFT (0x0000000Au)
#define CSL_BOOTCFG_LRSTNMISTAT_CLR_NMI_STAT_2_CLR_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_LRSTNMISTAT_CLR_NMI_STAT_3_CLR_MASK (0x00000800u)
#define CSL_BOOTCFG_LRSTNMISTAT_CLR_NMI_STAT_3_CLR_SHIFT (0x0000000Bu)
#define CSL_BOOTCFG_LRSTNMISTAT_CLR_NMI_STAT_3_CLR_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_LRSTNMISTAT_CLR_NMI_STAT_4_CLR_MASK (0x00001000u)
#define CSL_BOOTCFG_LRSTNMISTAT_CLR_NMI_STAT_4_CLR_SHIFT (0x0000000Cu)
#define CSL_BOOTCFG_LRSTNMISTAT_CLR_NMI_STAT_4_CLR_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_LRSTNMISTAT_CLR_NMI_STAT_5_CLR_MASK (0x00002000u)
#define CSL_BOOTCFG_LRSTNMISTAT_CLR_NMI_STAT_5_CLR_SHIFT (0x0000000Du)
#define CSL_BOOTCFG_LRSTNMISTAT_CLR_NMI_STAT_5_CLR_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_LRSTNMISTAT_CLR_NMI_STAT_6_CLR_MASK (0x00004000u)
#define CSL_BOOTCFG_LRSTNMISTAT_CLR_NMI_STAT_6_CLR_SHIFT (0x0000000Eu)
#define CSL_BOOTCFG_LRSTNMISTAT_CLR_NMI_STAT_6_CLR_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_LRSTNMISTAT_CLR_NMI_STAT_7_CLR_MASK (0x00008000u)
#define CSL_BOOTCFG_LRSTNMISTAT_CLR_NMI_STAT_7_CLR_SHIFT (0x0000000Fu)
#define CSL_BOOTCFG_LRSTNMISTAT_CLR_NMI_STAT_7_CLR_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_LRSTNMISTAT_CLR_RESETVAL (0x00000000u)

/* reset_stat_clr */

#define CSL_BOOTCFG_RESET_STAT_CLR_GRST_STAT_CLR_MASK (0x80000000u)
#define CSL_BOOTCFG_RESET_STAT_CLR_GRST_STAT_CLR_SHIFT (0x0000001Fu)
#define CSL_BOOTCFG_RESET_STAT_CLR_GRST_STAT_CLR_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_RESET_STAT_CLR_LRST_STAT_0_CLR_MASK (0x00000001u)
#define CSL_BOOTCFG_RESET_STAT_CLR_LRST_STAT_0_CLR_SHIFT (0x00000000u)
#define CSL_BOOTCFG_RESET_STAT_CLR_LRST_STAT_0_CLR_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_RESET_STAT_CLR_LRST_STAT_1_CLR_MASK (0x00000002u)
#define CSL_BOOTCFG_RESET_STAT_CLR_LRST_STAT_1_CLR_SHIFT (0x00000001u)
#define CSL_BOOTCFG_RESET_STAT_CLR_LRST_STAT_1_CLR_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_RESET_STAT_CLR_LRST_STAT_2_CLR_MASK (0x00000004u)
#define CSL_BOOTCFG_RESET_STAT_CLR_LRST_STAT_2_CLR_SHIFT (0x00000002u)
#define CSL_BOOTCFG_RESET_STAT_CLR_LRST_STAT_2_CLR_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_RESET_STAT_CLR_LRST_STAT_3_CLR_MASK (0x00000008u)
#define CSL_BOOTCFG_RESET_STAT_CLR_LRST_STAT_3_CLR_SHIFT (0x00000003u)
#define CSL_BOOTCFG_RESET_STAT_CLR_LRST_STAT_3_CLR_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_RESET_STAT_CLR_LRST_STAT_4_CLR_MASK (0x00000010u)
#define CSL_BOOTCFG_RESET_STAT_CLR_LRST_STAT_4_CLR_SHIFT (0x00000004u)
#define CSL_BOOTCFG_RESET_STAT_CLR_LRST_STAT_4_CLR_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_RESET_STAT_CLR_LRST_STAT_5_CLR_MASK (0x00000020u)
#define CSL_BOOTCFG_RESET_STAT_CLR_LRST_STAT_5_CLR_SHIFT (0x00000005u)
#define CSL_BOOTCFG_RESET_STAT_CLR_LRST_STAT_5_CLR_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_RESET_STAT_CLR_LRST_STAT_6_CLR_MASK (0x00000040u)
#define CSL_BOOTCFG_RESET_STAT_CLR_LRST_STAT_6_CLR_SHIFT (0x00000006u)
#define CSL_BOOTCFG_RESET_STAT_CLR_LRST_STAT_6_CLR_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_RESET_STAT_CLR_LRST_STAT_7_CLR_MASK (0x00000080u)
#define CSL_BOOTCFG_RESET_STAT_CLR_LRST_STAT_7_CLR_SHIFT (0x00000007u)
#define CSL_BOOTCFG_RESET_STAT_CLR_LRST_STAT_7_CLR_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_RESET_STAT_CLR_RESETVAL (0x00000000u)

/* boot_latch */

#define CSL_BOOTCFG_BOOT_LATCH_BOOT_LATCH_MASK (0x00000001u)
#define CSL_BOOTCFG_BOOT_LATCH_BOOT_LATCH_SHIFT (0x00000000u)
#define CSL_BOOTCFG_BOOT_LATCH_BOOT_LATCH_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_BOOT_LATCH_RESETVAL (0x00000000u)

/* boot_complete */

#define CSL_BOOTCFG_BOOT_COMPLETE_GEM0_COMPLETE_MASK (0x00000001u)
#define CSL_BOOTCFG_BOOT_COMPLETE_GEM0_COMPLETE_SHIFT (0x00000000u)
#define CSL_BOOTCFG_BOOT_COMPLETE_GEM0_COMPLETE_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_BOOT_COMPLETE_GEM1_COMPLETE_MASK (0x00000002u)
#define CSL_BOOTCFG_BOOT_COMPLETE_GEM1_COMPLETE_SHIFT (0x00000001u)
#define CSL_BOOTCFG_BOOT_COMPLETE_GEM1_COMPLETE_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_BOOT_COMPLETE_GEM2_COMPLETE_MASK (0x00000004u)
#define CSL_BOOTCFG_BOOT_COMPLETE_GEM2_COMPLETE_SHIFT (0x00000002u)
#define CSL_BOOTCFG_BOOT_COMPLETE_GEM2_COMPLETE_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_BOOT_COMPLETE_GEM3_COMPLETE_MASK (0x00000008u)
#define CSL_BOOTCFG_BOOT_COMPLETE_GEM3_COMPLETE_SHIFT (0x00000003u)
#define CSL_BOOTCFG_BOOT_COMPLETE_GEM3_COMPLETE_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_BOOT_COMPLETE_GEM4_COMPLETE_MASK (0x00000010u)
#define CSL_BOOTCFG_BOOT_COMPLETE_GEM4_COMPLETE_SHIFT (0x00000004u)
#define CSL_BOOTCFG_BOOT_COMPLETE_GEM4_COMPLETE_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_BOOT_COMPLETE_GEM5_COMPLETE_MASK (0x00000020u)
#define CSL_BOOTCFG_BOOT_COMPLETE_GEM5_COMPLETE_SHIFT (0x00000005u)
#define CSL_BOOTCFG_BOOT_COMPLETE_GEM5_COMPLETE_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_BOOT_COMPLETE_GEM6_COMPLETE_MASK (0x00000040u)
#define CSL_BOOTCFG_BOOT_COMPLETE_GEM6_COMPLETE_SHIFT (0x00000006u)
#define CSL_BOOTCFG_BOOT_COMPLETE_GEM6_COMPLETE_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_BOOT_COMPLETE_GEM7_COMPLETE_MASK (0x00000080u)
#define CSL_BOOTCFG_BOOT_COMPLETE_GEM7_COMPLETE_SHIFT (0x00000007u)
#define CSL_BOOTCFG_BOOT_COMPLETE_GEM7_COMPLETE_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_BOOT_COMPLETE_RESETVAL (0x00000000u)

/* boot_progress */

#define CSL_BOOTCFG_BOOT_PROGRESS_BOOT_PROGRESS_MASK (0xFFFFFFFFu)
#define CSL_BOOTCFG_BOOT_PROGRESS_BOOT_PROGRESS_SHIFT (0x00000000u)
#define CSL_BOOTCFG_BOOT_PROGRESS_BOOT_PROGRESS_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_BOOT_PROGRESS_RESETVAL (0x00000000u)

/* reset_stat */

#define CSL_BOOTCFG_RESET_STAT_GRST_STAT_MASK (0x80000000u)
#define CSL_BOOTCFG_RESET_STAT_GRST_STAT_SHIFT (0x0000001Fu)
#define CSL_BOOTCFG_RESET_STAT_GRST_STAT_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_RESET_STAT_LRST_STAT0_MASK (0x00000001u)
#define CSL_BOOTCFG_RESET_STAT_LRST_STAT0_SHIFT (0x00000000u)
#define CSL_BOOTCFG_RESET_STAT_LRST_STAT0_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_RESET_STAT_LRST_STAT1_MASK (0x00000002u)
#define CSL_BOOTCFG_RESET_STAT_LRST_STAT1_SHIFT (0x00000001u)
#define CSL_BOOTCFG_RESET_STAT_LRST_STAT1_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_RESET_STAT_LRST_STAT2_MASK (0x00000004u)
#define CSL_BOOTCFG_RESET_STAT_LRST_STAT2_SHIFT (0x00000002u)
#define CSL_BOOTCFG_RESET_STAT_LRST_STAT2_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_RESET_STAT_LRST_STAT3_MASK (0x00000008u)
#define CSL_BOOTCFG_RESET_STAT_LRST_STAT3_SHIFT (0x00000003u)
#define CSL_BOOTCFG_RESET_STAT_LRST_STAT3_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_RESET_STAT_LRST_STAT4_MASK (0x00000010u)
#define CSL_BOOTCFG_RESET_STAT_LRST_STAT4_SHIFT (0x00000004u)
#define CSL_BOOTCFG_RESET_STAT_LRST_STAT4_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_RESET_STAT_LRST_STAT5_MASK (0x00000020u)
#define CSL_BOOTCFG_RESET_STAT_LRST_STAT5_SHIFT (0x00000005u)
#define CSL_BOOTCFG_RESET_STAT_LRST_STAT5_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_RESET_STAT_LRST_STAT6_MASK (0x00000040u)
#define CSL_BOOTCFG_RESET_STAT_LRST_STAT6_SHIFT (0x00000006u)
#define CSL_BOOTCFG_RESET_STAT_LRST_STAT6_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_RESET_STAT_LRST_STAT7_MASK (0x00000080u)
#define CSL_BOOTCFG_RESET_STAT_LRST_STAT7_SHIFT (0x00000007u)
#define CSL_BOOTCFG_RESET_STAT_LRST_STAT7_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_RESET_STAT_RESETVAL (0x00000000u)

/* lrstnmistat */

#define CSL_BOOTCFG_LRSTNMISTAT_LRESET_STAT0_MASK (0x00000001u)
#define CSL_BOOTCFG_LRSTNMISTAT_LRESET_STAT0_SHIFT (0x00000000u)
#define CSL_BOOTCFG_LRSTNMISTAT_LRESET_STAT0_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_LRSTNMISTAT_LRESET_STAT1_MASK (0x00000002u)
#define CSL_BOOTCFG_LRSTNMISTAT_LRESET_STAT1_SHIFT (0x00000001u)
#define CSL_BOOTCFG_LRSTNMISTAT_LRESET_STAT1_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_LRSTNMISTAT_LRESET_STAT2_MASK (0x00000004u)
#define CSL_BOOTCFG_LRSTNMISTAT_LRESET_STAT2_SHIFT (0x00000002u)
#define CSL_BOOTCFG_LRSTNMISTAT_LRESET_STAT2_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_LRSTNMISTAT_LRESET_STAT3_MASK (0x00000008u)
#define CSL_BOOTCFG_LRSTNMISTAT_LRESET_STAT3_SHIFT (0x00000003u)
#define CSL_BOOTCFG_LRSTNMISTAT_LRESET_STAT3_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_LRSTNMISTAT_LRESET_STAT4_MASK (0x00000010u)
#define CSL_BOOTCFG_LRSTNMISTAT_LRESET_STAT4_SHIFT (0x00000004u)
#define CSL_BOOTCFG_LRSTNMISTAT_LRESET_STAT4_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_LRSTNMISTAT_LRESET_STAT5_MASK (0x00000020u)
#define CSL_BOOTCFG_LRSTNMISTAT_LRESET_STAT5_SHIFT (0x00000005u)
#define CSL_BOOTCFG_LRSTNMISTAT_LRESET_STAT5_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_LRSTNMISTAT_LRESET_STAT6_MASK (0x00000040u)
#define CSL_BOOTCFG_LRSTNMISTAT_LRESET_STAT6_SHIFT (0x00000006u)
#define CSL_BOOTCFG_LRSTNMISTAT_LRESET_STAT6_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_LRSTNMISTAT_LRESET_STAT7_MASK (0x00000080u)
#define CSL_BOOTCFG_LRSTNMISTAT_LRESET_STAT7_SHIFT (0x00000007u)
#define CSL_BOOTCFG_LRSTNMISTAT_LRESET_STAT7_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_LRSTNMISTAT_NMI_STAT0_MASK (0x00000100u)
#define CSL_BOOTCFG_LRSTNMISTAT_NMI_STAT0_SHIFT (0x00000008u)
#define CSL_BOOTCFG_LRSTNMISTAT_NMI_STAT0_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_LRSTNMISTAT_NMI_STAT1_MASK (0x00000200u)
#define CSL_BOOTCFG_LRSTNMISTAT_NMI_STAT1_SHIFT (0x00000009u)
#define CSL_BOOTCFG_LRSTNMISTAT_NMI_STAT1_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_LRSTNMISTAT_NMI_STAT2_MASK (0x00000400u)
#define CSL_BOOTCFG_LRSTNMISTAT_NMI_STAT2_SHIFT (0x0000000Au)
#define CSL_BOOTCFG_LRSTNMISTAT_NMI_STAT2_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_LRSTNMISTAT_NMI_STAT3_MASK (0x00000800u)
#define CSL_BOOTCFG_LRSTNMISTAT_NMI_STAT3_SHIFT (0x0000000Bu)
#define CSL_BOOTCFG_LRSTNMISTAT_NMI_STAT3_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_LRSTNMISTAT_NMI_STAT4_MASK (0x00001000u)
#define CSL_BOOTCFG_LRSTNMISTAT_NMI_STAT4_SHIFT (0x0000000Cu)
#define CSL_BOOTCFG_LRSTNMISTAT_NMI_STAT4_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_LRSTNMISTAT_NMI_STAT5_MASK (0x00002000u)
#define CSL_BOOTCFG_LRSTNMISTAT_NMI_STAT5_SHIFT (0x0000000Du)
#define CSL_BOOTCFG_LRSTNMISTAT_NMI_STAT5_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_LRSTNMISTAT_NMI_STAT6_MASK (0x00004000u)
#define CSL_BOOTCFG_LRSTNMISTAT_NMI_STAT6_SHIFT (0x0000000Eu)
#define CSL_BOOTCFG_LRSTNMISTAT_NMI_STAT6_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_LRSTNMISTAT_NMI_STAT7_MASK (0x00008000u)
#define CSL_BOOTCFG_LRSTNMISTAT_NMI_STAT7_SHIFT (0x0000000Fu)
#define CSL_BOOTCFG_LRSTNMISTAT_NMI_STAT7_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_LRSTNMISTAT_RESETVAL (0x00000000u)

/* devcfg */

#define CSL_BOOTCFG_DEVCFG_SYSCLKOUTEN_MASK (0x00000001u)
#define CSL_BOOTCFG_DEVCFG_SYSCLKOUTEN_SHIFT (0x00000000u)
#define CSL_BOOTCFG_DEVCFG_SYSCLKOUTEN_RESETVAL (0x00000001u)

#define CSL_BOOTCFG_DEVCFG_RESETVAL   (0x00000001u)

/* pwr_stat */

#define CSL_BOOTCFG_PWR_STAT_HIBERNATION_MASK (0x00000002u)
#define CSL_BOOTCFG_PWR_STAT_HIBERNATION_SHIFT (0x00000001u)
#define CSL_BOOTCFG_PWR_STAT_HIBERNATION_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_PWR_STAT_HIBERNATION_MODE_MASK (0x00000004u)
#define CSL_BOOTCFG_PWR_STAT_HIBERNATION_MODE_SHIFT (0x00000002u)
#define CSL_BOOTCFG_PWR_STAT_HIBERNATION_MODE_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_PWR_STAT_PWR_STAT_GENERAL_MASK (0xFFFFFFF8u)
#define CSL_BOOTCFG_PWR_STAT_PWR_STAT_GENERAL_SHIFT (0x00000003u)
#define CSL_BOOTCFG_PWR_STAT_PWR_STAT_GENERAL_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_PWR_STAT_STANDBY_MASK (0x00000001u)
#define CSL_BOOTCFG_PWR_STAT_STANDBY_SHIFT (0x00000000u)
#define CSL_BOOTCFG_PWR_STAT_STANDBY_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_PWR_STAT_RESETVAL (0x00000000u)

/* sts_srio */

#define CSL_BOOTCFG_STS_SRIO_STS_SRIO_MASK (0x1FFFFFFFu)
#define CSL_BOOTCFG_STS_SRIO_STS_SRIO_SHIFT (0x00000000u)
#define CSL_BOOTCFG_STS_SRIO_STS_SRIO_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_STS_SRIO_RESETVAL (0x00000000u)

/* sts_sgmii */

#define CSL_BOOTCFG_STS_SGMII_STS_SGMII_MASK (0x00001FFFu)
#define CSL_BOOTCFG_STS_SGMII_STS_SGMII_SHIFT (0x00000000u)
#define CSL_BOOTCFG_STS_SGMII_STS_SGMII_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_STS_SGMII_RESETVAL (0x00000000u)

/* sts_pcie */

#define CSL_BOOTCFG_STS_PCIE_STS_PCIE_MASK (0x00001FFFu)
#define CSL_BOOTCFG_STS_PCIE_STS_PCIE_SHIFT (0x00000000u)
#define CSL_BOOTCFG_STS_PCIE_STS_PCIE_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_STS_PCIE_STS_LOCK_MASK (0x00000001u)
#define CSL_BOOTCFG_STS_PCIE_STS_LOCK_SHIFT (0x00000000u)
#define CSL_BOOTCFG_STS_PCIE_STS_LOCK_RESETVAL (0x00000000u)


#define CSL_BOOTCFG_STS_PCIE_RESETVAL (0x00000000u)

/* sts_vusr */

#define CSL_BOOTCFG_STS_VUSR_STS_VUSR_MASK (0x1FFFFFFFu)
#define CSL_BOOTCFG_STS_VUSR_STS_VUSR_SHIFT (0x00000000u)
#define CSL_BOOTCFG_STS_VUSR_STS_VUSR_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_STS_VUSR_RESETVAL (0x00000000u)

/* class0_efuse_reg */

#define CSL_BOOTCFG_CLASS0_EFUSE_REG_CLASS0_EFUSE_REG_MASK (0xFFFFFFFFu)
#define CSL_BOOTCFG_CLASS0_EFUSE_REG_CLASS0_EFUSE_REG_SHIFT (0x00000000u)
#define CSL_BOOTCFG_CLASS0_EFUSE_REG_CLASS0_EFUSE_REG_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_CLASS0_EFUSE_REG_RESETVAL (0x00000000u)

/* efuse_reg0 */

#define CSL_BOOTCFG_EFUSE_REG0_EFUSE_REG0_MASK (0xFFFFFFFFu)
#define CSL_BOOTCFG_EFUSE_REG0_EFUSE_REG0_SHIFT (0x00000000u)
#define CSL_BOOTCFG_EFUSE_REG0_EFUSE_REG0_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_EFUSE_REG0_RESETVAL (0x00000000u)

/* efuse_reg1 */

#define CSL_BOOTCFG_EFUSE_REG1_EFUSE_REG1_MASK (0xFFFFFFFFu)
#define CSL_BOOTCFG_EFUSE_REG1_EFUSE_REG1_SHIFT (0x00000000u)
#define CSL_BOOTCFG_EFUSE_REG1_EFUSE_REG1_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_EFUSE_REG1_RESETVAL (0x00000000u)

/* efuse_reg2 */

#define CSL_BOOTCFG_EFUSE_REG2_EFUSE_REG2_MASK (0xFFFFFFFFu)
#define CSL_BOOTCFG_EFUSE_REG2_EFUSE_REG2_SHIFT (0x00000000u)
#define CSL_BOOTCFG_EFUSE_REG2_EFUSE_REG2_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_EFUSE_REG2_RESETVAL (0x00000000u)

/* efuse_reg3 */

#define CSL_BOOTCFG_EFUSE_REG3_EFUSE_REG3_MASK (0xFFFFFFFFu)
#define CSL_BOOTCFG_EFUSE_REG3_EFUSE_REG3_SHIFT (0x00000000u)
#define CSL_BOOTCFG_EFUSE_REG3_EFUSE_REG3_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_EFUSE_REG3_RESETVAL (0x00000000u)

/* efuse_reg4 */

#define CSL_BOOTCFG_EFUSE_REG4_EFUSE_REG4_MASK (0xFFFFFFFFu)
#define CSL_BOOTCFG_EFUSE_REG4_EFUSE_REG4_SHIFT (0x00000000u)
#define CSL_BOOTCFG_EFUSE_REG4_EFUSE_REG4_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_EFUSE_REG4_RESETVAL (0x00000000u)

/* efuse_reg5 */

#define CSL_BOOTCFG_EFUSE_REG5_EFUSE_REG5_MASK (0xFFFFFFFFu)
#define CSL_BOOTCFG_EFUSE_REG5_EFUSE_REG5_SHIFT (0x00000000u)
#define CSL_BOOTCFG_EFUSE_REG5_EFUSE_REG5_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_EFUSE_REG5_RESETVAL (0x00000000u)

/* efuse_reg6 */

#define CSL_BOOTCFG_EFUSE_REG6_EFUSE_REG6_MASK (0xFFFFFFFFu)
#define CSL_BOOTCFG_EFUSE_REG6_EFUSE_REG6_SHIFT (0x00000000u)
#define CSL_BOOTCFG_EFUSE_REG6_EFUSE_REG6_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_EFUSE_REG6_RESETVAL (0x00000000u)

/* efuse_reg7 */

#define CSL_BOOTCFG_EFUSE_REG7_EFUSE_REG7_MASK (0xFFFFFFFFu)
#define CSL_BOOTCFG_EFUSE_REG7_EFUSE_REG7_SHIFT (0x00000000u)
#define CSL_BOOTCFG_EFUSE_REG7_EFUSE_REG7_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_EFUSE_REG7_RESETVAL (0x00000000u)

/* efuse_reg8 */

#define CSL_BOOTCFG_EFUSE_REG8_EFUSE_REG8_MASK (0xFFFFFFFFu)
#define CSL_BOOTCFG_EFUSE_REG8_EFUSE_REG8_SHIFT (0x00000000u)
#define CSL_BOOTCFG_EFUSE_REG8_EFUSE_REG8_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_EFUSE_REG8_RESETVAL (0x00000000u)

/* efuse_reg9 */

#define CSL_BOOTCFG_EFUSE_REG9_EFUSE_REG9_MASK (0xFFFFFFFFu)
#define CSL_BOOTCFG_EFUSE_REG9_EFUSE_REG9_SHIFT (0x00000000u)
#define CSL_BOOTCFG_EFUSE_REG9_EFUSE_REG9_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_EFUSE_REG9_RESETVAL (0x00000000u)

/* efuse_reg10 */

#define CSL_BOOTCFG_EFUSE_REG10_EFUSE_REG10_MASK (0xFFFFFFFFu)
#define CSL_BOOTCFG_EFUSE_REG10_EFUSE_REG10_SHIFT (0x00000000u)
#define CSL_BOOTCFG_EFUSE_REG10_EFUSE_REG10_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_EFUSE_REG10_RESETVAL (0x00000000u)

/* efuse_reg11 */

#define CSL_BOOTCFG_EFUSE_REG11_EFUSE_REG11_MASK (0xFFFFFFFFu)
#define CSL_BOOTCFG_EFUSE_REG11_EFUSE_REG11_SHIFT (0x00000000u)
#define CSL_BOOTCFG_EFUSE_REG11_EFUSE_REG11_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_EFUSE_REG11_RESETVAL (0x00000000u)

/* efuse_reg12 */

#define CSL_BOOTCFG_EFUSE_REG12_EFUSE_REG12_MASK (0xFFFFFFFFu)
#define CSL_BOOTCFG_EFUSE_REG12_EFUSE_REG12_SHIFT (0x00000000u)
#define CSL_BOOTCFG_EFUSE_REG12_EFUSE_REG12_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_EFUSE_REG12_RESETVAL (0x00000000u)

/* efuse_reg13 */

#define CSL_BOOTCFG_EFUSE_REG13_EFUSE_REG13_MASK (0xFFFFFFFFu)
#define CSL_BOOTCFG_EFUSE_REG13_EFUSE_REG13_SHIFT (0x00000000u)
#define CSL_BOOTCFG_EFUSE_REG13_EFUSE_REG13_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_EFUSE_REG13_RESETVAL (0x00000000u)

/* efuse_reg14 */

#define CSL_BOOTCFG_EFUSE_REG14_EFUSE_REG14_MASK (0xFFFFFFFFu)
#define CSL_BOOTCFG_EFUSE_REG14_EFUSE_REG14_SHIFT (0x00000000u)
#define CSL_BOOTCFG_EFUSE_REG14_EFUSE_REG14_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_EFUSE_REG14_RESETVAL (0x00000000u)

/* efuse_reg15 */

#define CSL_BOOTCFG_EFUSE_REG15_EFUSE_REG15_MASK (0xFFFFFFFFu)
#define CSL_BOOTCFG_EFUSE_REG15_EFUSE_REG15_SHIFT (0x00000000u)
#define CSL_BOOTCFG_EFUSE_REG15_EFUSE_REG15_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_EFUSE_REG15_RESETVAL (0x00000000u)

/* nmigr_0 */

#define CSL_BOOTCFG_NMIGR_0_NMIGR_0_REG_MASK (0x00000001u)
#define CSL_BOOTCFG_NMIGR_0_NMIGR_0_REG_SHIFT (0x00000000u)
#define CSL_BOOTCFG_NMIGR_0_NMIGR_0_REG_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_NMIGR_0_RESETVAL  (0x00000000u)

/* nmigr_1 */

#define CSL_BOOTCFG_NMIGR_1_NMIGR_1_REG_MASK (0x00000001u)
#define CSL_BOOTCFG_NMIGR_1_NMIGR_1_REG_SHIFT (0x00000000u)
#define CSL_BOOTCFG_NMIGR_1_NMIGR_1_REG_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_NMIGR_1_RESETVAL  (0x00000000u)

/* nmigr_2 */

#define CSL_BOOTCFG_NMIGR_2_NMIGR_2_REG_MASK (0x00000001u)
#define CSL_BOOTCFG_NMIGR_2_NMIGR_2_REG_SHIFT (0x00000000u)
#define CSL_BOOTCFG_NMIGR_2_NMIGR_2_REG_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_NMIGR_2_RESETVAL  (0x00000000u)

/* nmigr_3 */

#define CSL_BOOTCFG_NMIGR_3_NMIGR_3_REG_MASK (0x00000001u)
#define CSL_BOOTCFG_NMIGR_3_NMIGR_3_REG_SHIFT (0x00000000u)
#define CSL_BOOTCFG_NMIGR_3_NMIGR_3_REG_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_NMIGR_3_RESETVAL  (0x00000000u)

/* nmigr_4 */

#define CSL_BOOTCFG_NMIGR_4_NMIGR_4_REG_MASK (0x00000001u)
#define CSL_BOOTCFG_NMIGR_4_NMIGR_4_REG_SHIFT (0x00000000u)
#define CSL_BOOTCFG_NMIGR_4_NMIGR_4_REG_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_NMIGR_4_RESETVAL  (0x00000000u)

/* nmigr_5 */

#define CSL_BOOTCFG_NMIGR_5_NMIGR_5_REG_MASK (0x00000001u)
#define CSL_BOOTCFG_NMIGR_5_NMIGR_5_REG_SHIFT (0x00000000u)
#define CSL_BOOTCFG_NMIGR_5_NMIGR_5_REG_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_NMIGR_5_RESETVAL  (0x00000000u)

/* nmigr_6 */

#define CSL_BOOTCFG_NMIGR_6_NMIGR_6_REG_MASK (0x00000001u)
#define CSL_BOOTCFG_NMIGR_6_NMIGR_6_REG_SHIFT (0x00000000u)
#define CSL_BOOTCFG_NMIGR_6_NMIGR_6_REG_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_NMIGR_6_RESETVAL  (0x00000000u)

/* nmigr_7 */

#define CSL_BOOTCFG_NMIGR_7_NMIGR_7_REG_MASK (0x00000001u)
#define CSL_BOOTCFG_NMIGR_7_NMIGR_7_REG_SHIFT (0x00000000u)
#define CSL_BOOTCFG_NMIGR_7_NMIGR_7_REG_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_NMIGR_7_RESETVAL  (0x00000000u)

/* ipcgr0 */

#define CSL_BOOTCFG_IPCGR0_IPCGR0_REG_MASK (0x00000001u)
#define CSL_BOOTCFG_IPCGR0_IPCGR0_REG_SHIFT (0x00000000u)
#define CSL_BOOTCFG_IPCGR0_IPCGR0_REG_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_IPCGR0_IPCGR0_SRC_MASK (0xFFFFFFF0u)
#define CSL_BOOTCFG_IPCGR0_IPCGR0_SRC_SHIFT (0x00000004u)
#define CSL_BOOTCFG_IPCGR0_IPCGR0_SRC_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_IPCGR0_RESETVAL   (0x00000000u)

/* ipcgr1 */

#define CSL_BOOTCFG_IPCGR1_IPCGR1_REG_MASK (0x00000001u)
#define CSL_BOOTCFG_IPCGR1_IPCGR1_REG_SHIFT (0x00000000u)
#define CSL_BOOTCFG_IPCGR1_IPCGR1_REG_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_IPCGR1_IPCGR1_SRC_MASK (0xFFFFFFF0u)
#define CSL_BOOTCFG_IPCGR1_IPCGR1_SRC_SHIFT (0x00000004u)
#define CSL_BOOTCFG_IPCGR1_IPCGR1_SRC_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_IPCGR1_RESETVAL   (0x00000000u)

/* ipcgr2 */

#define CSL_BOOTCFG_IPCGR2_IPCGR2_REG_MASK (0x00000001u)
#define CSL_BOOTCFG_IPCGR2_IPCGR2_REG_SHIFT (0x00000000u)
#define CSL_BOOTCFG_IPCGR2_IPCGR2_REG_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_IPCGR2_IPCGR2_SRC_MASK (0xFFFFFFF0u)
#define CSL_BOOTCFG_IPCGR2_IPCGR2_SRC_SHIFT (0x00000004u)
#define CSL_BOOTCFG_IPCGR2_IPCGR2_SRC_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_IPCGR2_RESETVAL   (0x00000000u)

/* ipcgr3 */

#define CSL_BOOTCFG_IPCGR3_IPCGR3_REG_MASK (0x00000001u)
#define CSL_BOOTCFG_IPCGR3_IPCGR3_REG_SHIFT (0x00000000u)
#define CSL_BOOTCFG_IPCGR3_IPCGR3_REG_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_IPCGR3_IPCGR3_SRC_MASK (0xFFFFFFF0u)
#define CSL_BOOTCFG_IPCGR3_IPCGR3_SRC_SHIFT (0x00000004u)
#define CSL_BOOTCFG_IPCGR3_IPCGR3_SRC_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_IPCGR3_RESETVAL   (0x00000000u)

/* ipcgr4 */

#define CSL_BOOTCFG_IPCGR4_IPCGR4_REG_MASK (0x00000001u)
#define CSL_BOOTCFG_IPCGR4_IPCGR4_REG_SHIFT (0x00000000u)
#define CSL_BOOTCFG_IPCGR4_IPCGR4_REG_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_IPCGR4_IPCGR4_SRC_MASK (0xFFFFFFF0u)
#define CSL_BOOTCFG_IPCGR4_IPCGR4_SRC_SHIFT (0x00000004u)
#define CSL_BOOTCFG_IPCGR4_IPCGR4_SRC_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_IPCGR4_RESETVAL   (0x00000000u)

/* ipcgr5 */

#define CSL_BOOTCFG_IPCGR5_IPCGR5_REG_MASK (0x00000001u)
#define CSL_BOOTCFG_IPCGR5_IPCGR5_REG_SHIFT (0x00000000u)
#define CSL_BOOTCFG_IPCGR5_IPCGR5_REG_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_IPCGR5_IPCGR5_SRC_MASK (0xFFFFFFF0u)
#define CSL_BOOTCFG_IPCGR5_IPCGR5_SRC_SHIFT (0x00000004u)
#define CSL_BOOTCFG_IPCGR5_IPCGR5_SRC_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_IPCGR5_RESETVAL   (0x00000000u)

/* ipcgr6 */

#define CSL_BOOTCFG_IPCGR6_IPCGR6_REG_MASK (0x00000001u)
#define CSL_BOOTCFG_IPCGR6_IPCGR6_REG_SHIFT (0x00000000u)
#define CSL_BOOTCFG_IPCGR6_IPCGR6_REG_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_IPCGR6_IPCGR6_SRC_MASK (0xFFFFFFF0u)
#define CSL_BOOTCFG_IPCGR6_IPCGR6_SRC_SHIFT (0x00000004u)
#define CSL_BOOTCFG_IPCGR6_IPCGR6_SRC_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_IPCGR6_RESETVAL   (0x00000000u)

/* ipcgr7 */

#define CSL_BOOTCFG_IPCGR7_IPCGR7_REG_MASK (0x00000001u)
#define CSL_BOOTCFG_IPCGR7_IPCGR7_REG_SHIFT (0x00000000u)
#define CSL_BOOTCFG_IPCGR7_IPCGR7_REG_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_IPCGR7_IPCGR7_SRC_MASK (0xFFFFFFF0u)
#define CSL_BOOTCFG_IPCGR7_IPCGR7_SRC_SHIFT (0x00000004u)
#define CSL_BOOTCFG_IPCGR7_IPCGR7_SRC_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_IPCGR7_RESETVAL   (0x00000000u)

/* ipcgrh */

#define CSL_BOOTCFG_IPCGRH_IPCGRH_REG_MASK (0x00000001u)
#define CSL_BOOTCFG_IPCGRH_IPCGRH_REG_SHIFT (0x00000000u)
#define CSL_BOOTCFG_IPCGRH_IPCGRH_REG_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_IPCGRH_IPCGRH_SRC_MASK (0xFFFFFFF0u)
#define CSL_BOOTCFG_IPCGRH_IPCGRH_SRC_SHIFT (0x00000004u)
#define CSL_BOOTCFG_IPCGRH_IPCGRH_SRC_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_IPCGRH_RESETVAL   (0x00000000u)

/* ipcar0 */

#define CSL_BOOTCFG_IPCAR0_IPCGR0_SRC_CLR_MASK (0xFFFFFFF0u)
#define CSL_BOOTCFG_IPCAR0_IPCGR0_SRC_CLR_SHIFT (0x00000004u)
#define CSL_BOOTCFG_IPCAR0_IPCGR0_SRC_CLR_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_IPCAR0_RESETVAL   (0x00000000u)

/* ipcar1 */

#define CSL_BOOTCFG_IPCAR1_IPCGR1_SRC_CLR_MASK (0xFFFFFFF0u)
#define CSL_BOOTCFG_IPCAR1_IPCGR1_SRC_CLR_SHIFT (0x00000004u)
#define CSL_BOOTCFG_IPCAR1_IPCGR1_SRC_CLR_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_IPCAR1_RESETVAL   (0x00000000u)

/* ipcar2 */

#define CSL_BOOTCFG_IPCAR2_IPCGR2_SRC_CLR_MASK (0xFFFFFFF0u)
#define CSL_BOOTCFG_IPCAR2_IPCGR2_SRC_CLR_SHIFT (0x00000004u)
#define CSL_BOOTCFG_IPCAR2_IPCGR2_SRC_CLR_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_IPCAR2_RESETVAL   (0x00000000u)

/* ipcar3 */

#define CSL_BOOTCFG_IPCAR3_IPCGR3_SRC_CLR_MASK (0xFFFFFFF0u)
#define CSL_BOOTCFG_IPCAR3_IPCGR3_SRC_CLR_SHIFT (0x00000004u)
#define CSL_BOOTCFG_IPCAR3_IPCGR3_SRC_CLR_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_IPCAR3_RESETVAL   (0x00000000u)

/* ipcar4 */

#define CSL_BOOTCFG_IPCAR4_IPCGR4_SRC_CLR_MASK (0xFFFFFFF0u)
#define CSL_BOOTCFG_IPCAR4_IPCGR4_SRC_CLR_SHIFT (0x00000004u)
#define CSL_BOOTCFG_IPCAR4_IPCGR4_SRC_CLR_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_IPCAR4_RESETVAL   (0x00000000u)

/* ipcar5 */

#define CSL_BOOTCFG_IPCAR5_IPCGR5_SRC_CLR_MASK (0xFFFFFFF0u)
#define CSL_BOOTCFG_IPCAR5_IPCGR5_SRC_CLR_SHIFT (0x00000004u)
#define CSL_BOOTCFG_IPCAR5_IPCGR5_SRC_CLR_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_IPCAR5_RESETVAL   (0x00000000u)

/* ipcar6 */

#define CSL_BOOTCFG_IPCAR6_IPCGR6_SRC_CLR_MASK (0xFFFFFFF0u)
#define CSL_BOOTCFG_IPCAR6_IPCGR6_SRC_CLR_SHIFT (0x00000004u)
#define CSL_BOOTCFG_IPCAR6_IPCGR6_SRC_CLR_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_IPCAR6_RESETVAL   (0x00000000u)

/* ipcar7 */

#define CSL_BOOTCFG_IPCAR7_IPCGR7_SRC_CLR_MASK (0xFFFFFFF0u)
#define CSL_BOOTCFG_IPCAR7_IPCGR7_SRC_CLR_SHIFT (0x00000004u)
#define CSL_BOOTCFG_IPCAR7_IPCGR7_SRC_CLR_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_IPCAR7_RESETVAL   (0x00000000u)

/* ipcarh */

#define CSL_BOOTCFG_IPCARH_IPCGRH_SRC_CLR_MASK (0xFFFFFFF0u)
#define CSL_BOOTCFG_IPCARH_IPCGRH_SRC_CLR_SHIFT (0x00000004u)
#define CSL_BOOTCFG_IPCARH_IPCGRH_SRC_CLR_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_IPCARH_RESETVAL   (0x00000000u)

/* tinpsel */

#define CSL_BOOTCFG_TINPSEL_TINPSEL_MASK (0xFFFFFFFFu)
#define CSL_BOOTCFG_TINPSEL_TINPSEL_SHIFT (0x00000000u)
#define CSL_BOOTCFG_TINPSEL_TINPSEL_RESETVAL (0xAAAAAAAAu)

#define CSL_BOOTCFG_TINPSEL_RESETVAL  (0xAAAAAAAAu)

/* toutsel */

#define CSL_BOOTCFG_TOUTSEL_TOUTSEL0_MASK (0x0000001Fu)
#define CSL_BOOTCFG_TOUTSEL_TOUTSEL0_SHIFT (0x00000000u)
#define CSL_BOOTCFG_TOUTSEL_TOUTSEL0_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_TOUTSEL_TOUTSEL1_MASK (0x000003E0u)
#define CSL_BOOTCFG_TOUTSEL_TOUTSEL1_SHIFT (0x00000005u)
#define CSL_BOOTCFG_TOUTSEL_TOUTSEL1_RESETVAL (0x00000001u)

#define CSL_BOOTCFG_TOUTSEL_TOUTSEL1_RSVD_MASK (0x00000010u)
#define CSL_BOOTCFG_TOUTSEL_TOUTSEL1_RSVD_SHIFT (0x00000004u)
#define CSL_BOOTCFG_TOUTSEL_TOUTSEL1_RSVD_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_TOUTSEL_RESETVAL  (0x00000020u)

/* rstmux0 */

#define CSL_BOOTCFG_RSTMUX0_RSTMUX_DELAY0_MASK (0x000000E0u)
#define CSL_BOOTCFG_RSTMUX0_RSTMUX_DELAY0_SHIFT (0x00000005u)
#define CSL_BOOTCFG_RSTMUX0_RSTMUX_DELAY0_RESETVAL (0x00000004u)

#define CSL_BOOTCFG_RSTMUX0_RSTMUX_EVSTAT0_MASK (0x00000010u)
#define CSL_BOOTCFG_RSTMUX0_RSTMUX_EVSTAT0_SHIFT (0x00000004u)
#define CSL_BOOTCFG_RSTMUX0_RSTMUX_EVSTAT0_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_RSTMUX0_RSTMUX_EVSTAT_CLR0_MASK (0x00000200u)
#define CSL_BOOTCFG_RSTMUX0_RSTMUX_EVSTAT_CLR0_SHIFT (0x00000009u)
#define CSL_BOOTCFG_RSTMUX0_RSTMUX_EVSTAT_CLR0_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_RSTMUX0_RSTMUX_LOCK0_MASK (0x00000001u)
#define CSL_BOOTCFG_RSTMUX0_RSTMUX_LOCK0_SHIFT (0x00000000u)
#define CSL_BOOTCFG_RSTMUX0_RSTMUX_LOCK0_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_RSTMUX0_RSTMUX_OMODE0_MASK (0x0000000Eu)
#define CSL_BOOTCFG_RSTMUX0_RSTMUX_OMODE0_SHIFT (0x00000001u)
#define CSL_BOOTCFG_RSTMUX0_RSTMUX_OMODE0_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_RSTMUX0_RESETVAL  (0x00000080u)

/* rstmux1 */

#define CSL_BOOTCFG_RSTMUX1_RSTMUX_DELAY1_MASK (0x000000E0u)
#define CSL_BOOTCFG_RSTMUX1_RSTMUX_DELAY1_SHIFT (0x00000005u)
#define CSL_BOOTCFG_RSTMUX1_RSTMUX_DELAY1_RESETVAL (0x00000004u)

#define CSL_BOOTCFG_RSTMUX1_RSTMUX_EVSTAT1_MASK (0x00000010u)
#define CSL_BOOTCFG_RSTMUX1_RSTMUX_EVSTAT1_SHIFT (0x00000004u)
#define CSL_BOOTCFG_RSTMUX1_RSTMUX_EVSTAT1_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_RSTMUX1_RSTMUX_EVSTAT_CLR1_MASK (0x00000200u)
#define CSL_BOOTCFG_RSTMUX1_RSTMUX_EVSTAT_CLR1_SHIFT (0x00000009u)
#define CSL_BOOTCFG_RSTMUX1_RSTMUX_EVSTAT_CLR1_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_RSTMUX1_RSTMUX_LOCK1_MASK (0x00000001u)
#define CSL_BOOTCFG_RSTMUX1_RSTMUX_LOCK1_SHIFT (0x00000000u)
#define CSL_BOOTCFG_RSTMUX1_RSTMUX_LOCK1_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_RSTMUX1_RSTMUX_OMODE1_MASK (0x0000000Eu)
#define CSL_BOOTCFG_RSTMUX1_RSTMUX_OMODE1_SHIFT (0x00000001u)
#define CSL_BOOTCFG_RSTMUX1_RSTMUX_OMODE1_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_RSTMUX1_RESETVAL  (0x00000080u)

/* rstmux2 */

#define CSL_BOOTCFG_RSTMUX2_RSTMUX_DELAY2_MASK (0x000000E0u)
#define CSL_BOOTCFG_RSTMUX2_RSTMUX_DELAY2_SHIFT (0x00000005u)
#define CSL_BOOTCFG_RSTMUX2_RSTMUX_DELAY2_RESETVAL (0x00000004u)

#define CSL_BOOTCFG_RSTMUX2_RSTMUX_EVSTAT2_MASK (0x00000010u)
#define CSL_BOOTCFG_RSTMUX2_RSTMUX_EVSTAT2_SHIFT (0x00000004u)
#define CSL_BOOTCFG_RSTMUX2_RSTMUX_EVSTAT2_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_RSTMUX2_RSTMUX_EVSTAT_CLR2_MASK (0x00000200u)
#define CSL_BOOTCFG_RSTMUX2_RSTMUX_EVSTAT_CLR2_SHIFT (0x00000009u)
#define CSL_BOOTCFG_RSTMUX2_RSTMUX_EVSTAT_CLR2_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_RSTMUX2_RSTMUX_LOCK2_MASK (0x00000001u)
#define CSL_BOOTCFG_RSTMUX2_RSTMUX_LOCK2_SHIFT (0x00000000u)
#define CSL_BOOTCFG_RSTMUX2_RSTMUX_LOCK2_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_RSTMUX2_RSTMUX_OMODE2_MASK (0x0000000Eu)
#define CSL_BOOTCFG_RSTMUX2_RSTMUX_OMODE2_SHIFT (0x00000001u)
#define CSL_BOOTCFG_RSTMUX2_RSTMUX_OMODE2_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_RSTMUX2_RESETVAL  (0x00000080u)

/* rstmux3 */

#define CSL_BOOTCFG_RSTMUX3_RSTMUX_DELAY3_MASK (0x000000E0u)
#define CSL_BOOTCFG_RSTMUX3_RSTMUX_DELAY3_SHIFT (0x00000005u)
#define CSL_BOOTCFG_RSTMUX3_RSTMUX_DELAY3_RESETVAL (0x00000004u)

#define CSL_BOOTCFG_RSTMUX3_RSTMUX_EVSTAT3_MASK (0x00000010u)
#define CSL_BOOTCFG_RSTMUX3_RSTMUX_EVSTAT3_SHIFT (0x00000004u)
#define CSL_BOOTCFG_RSTMUX3_RSTMUX_EVSTAT3_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_RSTMUX3_RSTMUX_EVSTAT_CLR3_MASK (0x00000200u)
#define CSL_BOOTCFG_RSTMUX3_RSTMUX_EVSTAT_CLR3_SHIFT (0x00000009u)
#define CSL_BOOTCFG_RSTMUX3_RSTMUX_EVSTAT_CLR3_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_RSTMUX3_RSTMUX_LOCK3_MASK (0x00000001u)
#define CSL_BOOTCFG_RSTMUX3_RSTMUX_LOCK3_SHIFT (0x00000000u)
#define CSL_BOOTCFG_RSTMUX3_RSTMUX_LOCK3_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_RSTMUX3_RSTMUX_OMODE3_MASK (0x0000000Eu)
#define CSL_BOOTCFG_RSTMUX3_RSTMUX_OMODE3_SHIFT (0x00000001u)
#define CSL_BOOTCFG_RSTMUX3_RSTMUX_OMODE3_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_RSTMUX3_RESETVAL  (0x00000080u)

/* rstmux4 */

#define CSL_BOOTCFG_RSTMUX4_RSTMUX_DELAY4_MASK (0x000000E0u)
#define CSL_BOOTCFG_RSTMUX4_RSTMUX_DELAY4_SHIFT (0x00000005u)
#define CSL_BOOTCFG_RSTMUX4_RSTMUX_DELAY4_RESETVAL (0x00000004u)

#define CSL_BOOTCFG_RSTMUX4_RSTMUX_EVSTAT4_MASK (0x00000010u)
#define CSL_BOOTCFG_RSTMUX4_RSTMUX_EVSTAT4_SHIFT (0x00000004u)
#define CSL_BOOTCFG_RSTMUX4_RSTMUX_EVSTAT4_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_RSTMUX4_RSTMUX_EVSTAT_CLR4_MASK (0x00000200u)
#define CSL_BOOTCFG_RSTMUX4_RSTMUX_EVSTAT_CLR4_SHIFT (0x00000009u)
#define CSL_BOOTCFG_RSTMUX4_RSTMUX_EVSTAT_CLR4_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_RSTMUX4_RSTMUX_LOCK4_MASK (0x00000001u)
#define CSL_BOOTCFG_RSTMUX4_RSTMUX_LOCK4_SHIFT (0x00000000u)
#define CSL_BOOTCFG_RSTMUX4_RSTMUX_LOCK4_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_RSTMUX4_RSTMUX_OMODE4_MASK (0x0000000Eu)
#define CSL_BOOTCFG_RSTMUX4_RSTMUX_OMODE4_SHIFT (0x00000001u)
#define CSL_BOOTCFG_RSTMUX4_RSTMUX_OMODE4_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_RSTMUX4_RESETVAL  (0x00000080u)

/* rstmux5 */

#define CSL_BOOTCFG_RSTMUX5_RSTMUX_DELAY5_MASK (0x000000E0u)
#define CSL_BOOTCFG_RSTMUX5_RSTMUX_DELAY5_SHIFT (0x00000005u)
#define CSL_BOOTCFG_RSTMUX5_RSTMUX_DELAY5_RESETVAL (0x00000004u)

#define CSL_BOOTCFG_RSTMUX5_RSTMUX_EVSTAT5_MASK (0x00000010u)
#define CSL_BOOTCFG_RSTMUX5_RSTMUX_EVSTAT5_SHIFT (0x00000004u)
#define CSL_BOOTCFG_RSTMUX5_RSTMUX_EVSTAT5_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_RSTMUX5_RSTMUX_EVSTAT_CLR5_MASK (0x00000200u)
#define CSL_BOOTCFG_RSTMUX5_RSTMUX_EVSTAT_CLR5_SHIFT (0x00000009u)
#define CSL_BOOTCFG_RSTMUX5_RSTMUX_EVSTAT_CLR5_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_RSTMUX5_RSTMUX_LOCK5_MASK (0x00000001u)
#define CSL_BOOTCFG_RSTMUX5_RSTMUX_LOCK5_SHIFT (0x00000000u)
#define CSL_BOOTCFG_RSTMUX5_RSTMUX_LOCK5_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_RSTMUX5_RSTMUX_OMODE5_MASK (0x0000000Eu)
#define CSL_BOOTCFG_RSTMUX5_RSTMUX_OMODE5_SHIFT (0x00000001u)
#define CSL_BOOTCFG_RSTMUX5_RSTMUX_OMODE5_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_RSTMUX5_RESETVAL  (0x00000080u)

/* rstmux6 */

#define CSL_BOOTCFG_RSTMUX6_RSTMUX_DELAY6_MASK (0x000000E0u)
#define CSL_BOOTCFG_RSTMUX6_RSTMUX_DELAY6_SHIFT (0x00000005u)
#define CSL_BOOTCFG_RSTMUX6_RSTMUX_DELAY6_RESETVAL (0x00000004u)

#define CSL_BOOTCFG_RSTMUX6_RSTMUX_EVSTAT6_MASK (0x00000010u)
#define CSL_BOOTCFG_RSTMUX6_RSTMUX_EVSTAT6_SHIFT (0x00000004u)
#define CSL_BOOTCFG_RSTMUX6_RSTMUX_EVSTAT6_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_RSTMUX6_RSTMUX_EVSTAT_CLR6_MASK (0x00000200u)
#define CSL_BOOTCFG_RSTMUX6_RSTMUX_EVSTAT_CLR6_SHIFT (0x00000009u)
#define CSL_BOOTCFG_RSTMUX6_RSTMUX_EVSTAT_CLR6_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_RSTMUX6_RSTMUX_LOCK6_MASK (0x00000001u)
#define CSL_BOOTCFG_RSTMUX6_RSTMUX_LOCK6_SHIFT (0x00000000u)
#define CSL_BOOTCFG_RSTMUX6_RSTMUX_LOCK6_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_RSTMUX6_RSTMUX_OMODE6_MASK (0x0000000Eu)
#define CSL_BOOTCFG_RSTMUX6_RSTMUX_OMODE6_SHIFT (0x00000001u)
#define CSL_BOOTCFG_RSTMUX6_RSTMUX_OMODE6_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_RSTMUX6_RESETVAL  (0x00000080u)

/* rstmux7 */

#define CSL_BOOTCFG_RSTMUX7_RSTMUX_DELAY7_MASK (0x000000E0u)
#define CSL_BOOTCFG_RSTMUX7_RSTMUX_DELAY7_SHIFT (0x00000005u)
#define CSL_BOOTCFG_RSTMUX7_RSTMUX_DELAY7_RESETVAL (0x00000004u)

#define CSL_BOOTCFG_RSTMUX7_RSTMUX_EVSTAT7_MASK (0x00000010u)
#define CSL_BOOTCFG_RSTMUX7_RSTMUX_EVSTAT7_SHIFT (0x00000004u)
#define CSL_BOOTCFG_RSTMUX7_RSTMUX_EVSTAT7_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_RSTMUX7_RSTMUX_EVSTAT_CLR7_MASK (0x00000200u)
#define CSL_BOOTCFG_RSTMUX7_RSTMUX_EVSTAT_CLR7_SHIFT (0x00000009u)
#define CSL_BOOTCFG_RSTMUX7_RSTMUX_EVSTAT_CLR7_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_RSTMUX7_RSTMUX_LOCK7_MASK (0x00000001u)
#define CSL_BOOTCFG_RSTMUX7_RSTMUX_LOCK7_SHIFT (0x00000000u)
#define CSL_BOOTCFG_RSTMUX7_RSTMUX_LOCK7_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_RSTMUX7_RSTMUX_OMODE7_MASK (0x0000000Eu)
#define CSL_BOOTCFG_RSTMUX7_RSTMUX_OMODE7_SHIFT (0x00000001u)
#define CSL_BOOTCFG_RSTMUX7_RSTMUX_OMODE7_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_RSTMUX7_RESETVAL  (0x00000080u)

/* core_pll_ctl0 */

#define CSL_BOOTCFG_CORE_PLL_CTL0_CORE_PLL_CTL0_MASK (0xFFFFFFFFu)
#define CSL_BOOTCFG_CORE_PLL_CTL0_CORE_PLL_CTL0_SHIFT (0x00000000u)
#define CSL_BOOTCFG_CORE_PLL_CTL0_CORE_PLL_CTL0_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_CORE_PLL_CTL0_RESETVAL (0x00000000u)

/* core_pll_ctl1 */

#define CSL_BOOTCFG_CORE_PLL_CTL1_CORE_PLL_CTL1_MASK (0xFFFFFFFFu)
#define CSL_BOOTCFG_CORE_PLL_CTL1_CORE_PLL_CTL1_SHIFT (0x00000000u)
#define CSL_BOOTCFG_CORE_PLL_CTL1_CORE_PLL_CTL1_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_CORE_PLL_CTL1_RESETVAL (0x00000000u)

/* ddr3_pll_ctl0 */

#define CSL_BOOTCFG_DDR3_PLL_CTL0_DDR3_PLL_CTL0_MASK (0xFFFFFFFFu)
#define CSL_BOOTCFG_DDR3_PLL_CTL0_DDR3_PLL_CTL0_SHIFT (0x00000000u)
#define CSL_BOOTCFG_DDR3_PLL_CTL0_DDR3_PLL_CTL0_RESETVAL (0x098804C0u)

#define CSL_BOOTCFG_DDR3_PLL_CTL0_RESETVAL (0x098804C0u)

/* ddr3_pll_ctl1 */

#define CSL_BOOTCFG_DDR3_PLL_CTL1_DDR3_PLL_CTL1_MASK (0xFFFFFFFFu)
#define CSL_BOOTCFG_DDR3_PLL_CTL1_DDR3_PLL_CTL1_SHIFT (0x00000000u)
#define CSL_BOOTCFG_DDR3_PLL_CTL1_DDR3_PLL_CTL1_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_DDR3_PLL_CTL1_RESETVAL (0x00000000u)

/* pa_pll_ctl0 */

#define CSL_BOOTCFG_PA_PLL_CTL0_PA_PLL_CTL0_MASK (0xFFFFFFFFu)
#define CSL_BOOTCFG_PA_PLL_CTL0_PA_PLL_CTL0_SHIFT (0x00000000u)
#define CSL_BOOTCFG_PA_PLL_CTL0_PA_PLL_CTL0_RESETVAL (0x098804C0u)

#define CSL_BOOTCFG_PA_PLL_CTL0_RESETVAL (0x098804C0u)

/* pa_pll_ctl1 */

#define CSL_BOOTCFG_PA_PLL_CTL1_PA_PLL_CTL1_MASK (0xFFFFFFFFu)
#define CSL_BOOTCFG_PA_PLL_CTL1_PA_PLL_CTL1_SHIFT (0x00000000u)
#define CSL_BOOTCFG_PA_PLL_CTL1_PA_PLL_CTL1_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_PA_PLL_CTL1_RESETVAL (0x00000000u)

/* sgmii_cfgpll */

#define CSL_BOOTCFG_SGMII_CFGPLL_SGMII_CFGPLL_MASK (0x0000FFFFu)
#define CSL_BOOTCFG_SGMII_CFGPLL_SGMII_CFGPLL_SHIFT (0x00000000u)
#define CSL_BOOTCFG_SGMII_CFGPLL_SGMII_CFGPLL_RESETVAL (0x00000041u)

#define CSL_BOOTCFG_SGMII_CFGPLL_RESETVAL (0x00000041u)

/* sgmii_cfgrx0 */

#define CSL_BOOTCFG_SGMII_CFGRX0_SGMII_RXCFG0_MASK (0xFFFFFFFFu)
#define CSL_BOOTCFG_SGMII_CFGRX0_SGMII_RXCFG0_SHIFT (0x00000000u)
#define CSL_BOOTCFG_SGMII_CFGRX0_SGMII_RXCFG0_RESETVAL (0x00680210u)

#define CSL_BOOTCFG_SGMII_CFGRX0_RESETVAL (0x00680210u)

/* sgmii_cfgtx0 */

#define CSL_BOOTCFG_SGMII_CFGTX0_SGMII_TXCFG0_MASK (0xFFFFFFFFu)
#define CSL_BOOTCFG_SGMII_CFGTX0_SGMII_TXCFG0_SHIFT (0x00000000u)
#define CSL_BOOTCFG_SGMII_CFGTX0_SGMII_TXCFG0_RESETVAL (0x00001E90u)

#define CSL_BOOTCFG_SGMII_CFGTX0_RESETVAL (0x00001E90u)

/* sgmii_cfgrx1 */

#define CSL_BOOTCFG_SGMII_CFGRX1_SGMII_RXCFG1_MASK (0xFFFFFFFFu)
#define CSL_BOOTCFG_SGMII_CFGRX1_SGMII_RXCFG1_SHIFT (0x00000000u)
#define CSL_BOOTCFG_SGMII_CFGRX1_SGMII_RXCFG1_RESETVAL (0x00680210u)

#define CSL_BOOTCFG_SGMII_CFGRX1_RESETVAL (0x00680210u)

/* sgmii_cfgtx1 */

#define CSL_BOOTCFG_SGMII_CFGTX1_SGMII_TXCFG1_MASK (0xFFFFFFFFu)
#define CSL_BOOTCFG_SGMII_CFGTX1_SGMII_TXCFG1_SHIFT (0x00000000u)
#define CSL_BOOTCFG_SGMII_CFGTX1_SGMII_TXCFG1_RESETVAL (0x00001E90u)

#define CSL_BOOTCFG_SGMII_CFGTX1_RESETVAL (0x00001E90u)

/* sgmii_rsvd */

#define CSL_BOOTCFG_SGMII_RSVD_SGMII_RSVD_MASK (0xFFFFFFFFu)
#define CSL_BOOTCFG_SGMII_RSVD_SGMII_RSVD_SHIFT (0x00000000u)
#define CSL_BOOTCFG_SGMII_RSVD_SGMII_RSVD_RESETVAL (0x00000100u)

#define CSL_BOOTCFG_SGMII_RSVD_RESETVAL (0x00000100u)

/* pcie_cfgpll */

#define CSL_BOOTCFG_PCIE_CFGPLL_PCIE_CFGPLL_MASK (0x0000FFFFu)
#define CSL_BOOTCFG_PCIE_CFGPLL_PCIE_CFGPLL_SHIFT (0x00000000u)
#define CSL_BOOTCFG_PCIE_CFGPLL_PCIE_CFGPLL_RESETVAL (0x000001C9u)

#define CSL_BOOTCFG_PCIE_CFGPLL_RESETVAL (0x000001C9u)

/* pcie_serdes_rsvd */

#define CSL_BOOTCFG_PCIE_SERDES_RSVD_PCIE_SERDES_RSVD_MASK (0xFFFFFFFFu)
#define CSL_BOOTCFG_PCIE_SERDES_RSVD_PCIE_SERDES_RSVD_SHIFT (0x00000000u)
#define CSL_BOOTCFG_PCIE_SERDES_RSVD_PCIE_SERDES_RSVD_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_PCIE_SERDES_RSVD_RESETVAL (0x00000000u)

/* srio_serdes_cfgpll */

#define CSL_BOOTCFG_SRIO_SERDES_CFGPLL_SRIO_SERDES_CFGPLL_MASK (0xFFFFFFFFu)
#define CSL_BOOTCFG_SRIO_SERDES_CFGPLL_SRIO_SERDES_CFGPLL_SHIFT (0x00000000u)
#define CSL_BOOTCFG_SRIO_SERDES_CFGPLL_SRIO_SERDES_CFGPLL_RESETVAL (0x00000251u)

#define CSL_BOOTCFG_SRIO_SERDES_CFGPLL_RESETVAL (0x00000251u)

/* srio_serdes_cfgrx0 */

#define CSL_BOOTCFG_SRIO_SERDES_CFGRX0_SRIO_SERDES_CFGRX0_MASK (0xFFFFFFFFu)
#define CSL_BOOTCFG_SRIO_SERDES_CFGRX0_SRIO_SERDES_CFGRX0_SHIFT (0x00000000u)
#define CSL_BOOTCFG_SRIO_SERDES_CFGRX0_SRIO_SERDES_CFGRX0_RESETVAL (0x00040494u)

#define CSL_BOOTCFG_SRIO_SERDES_CFGRX0_RESETVAL (0x00040494u)

/* srio_serdes_cfgtx0 */

#define CSL_BOOTCFG_SRIO_SERDES_CFGTX0_SRIO_SERDES_CFGTX0_MASK (0xFFFFFFFFu)
#define CSL_BOOTCFG_SRIO_SERDES_CFGTX0_SRIO_SERDES_CFGTX0_SHIFT (0x00000000u)
#define CSL_BOOTCFG_SRIO_SERDES_CFGTX0_SRIO_SERDES_CFGTX0_RESETVAL (0x00080794u)

#define CSL_BOOTCFG_SRIO_SERDES_CFGTX0_RESETVAL (0x00080794u)

/* srio_serdes_cfgrx1 */

#define CSL_BOOTCFG_SRIO_SERDES_CFGRX1_SRIO_SERDES_CFGRX1_MASK (0xFFFFFFFFu)
#define CSL_BOOTCFG_SRIO_SERDES_CFGRX1_SRIO_SERDES_CFGRX1_SHIFT (0x00000000u)
#define CSL_BOOTCFG_SRIO_SERDES_CFGRX1_SRIO_SERDES_CFGRX1_RESETVAL (0x00040494u)

#define CSL_BOOTCFG_SRIO_SERDES_CFGRX1_RESETVAL (0x00040494u)

/* srio_serdes_cfgtx1 */

#define CSL_BOOTCFG_SRIO_SERDES_CFGTX1_SRIO_SERDES_CFGTX1_MASK (0xFFFFFFFFu)
#define CSL_BOOTCFG_SRIO_SERDES_CFGTX1_SRIO_SERDES_CFGTX1_SHIFT (0x00000000u)
#define CSL_BOOTCFG_SRIO_SERDES_CFGTX1_SRIO_SERDES_CFGTX1_RESETVAL (0x00080794u)

#define CSL_BOOTCFG_SRIO_SERDES_CFGTX1_RESETVAL (0x00080794u)

/* srio_serdes_cfgrx2 */

#define CSL_BOOTCFG_SRIO_SERDES_CFGRX2_SRIO_SERDES_CFGRX2_MASK (0xFFFFFFFFu)
#define CSL_BOOTCFG_SRIO_SERDES_CFGRX2_SRIO_SERDES_CFGRX2_SHIFT (0x00000000u)
#define CSL_BOOTCFG_SRIO_SERDES_CFGRX2_SRIO_SERDES_CFGRX2_RESETVAL (0x00040494u)

#define CSL_BOOTCFG_SRIO_SERDES_CFGRX2_RESETVAL (0x00040494u)

/* srio_serdes_cfgtx2 */

#define CSL_BOOTCFG_SRIO_SERDES_CFGTX2_SRIO_SERDES_CFGTX2_MASK (0xFFFFFFFFu)
#define CSL_BOOTCFG_SRIO_SERDES_CFGTX2_SRIO_SERDES_CFGTX2_SHIFT (0x00000000u)
#define CSL_BOOTCFG_SRIO_SERDES_CFGTX2_SRIO_SERDES_CFGTX2_RESETVAL (0x00080794u)

#define CSL_BOOTCFG_SRIO_SERDES_CFGTX2_RESETVAL (0x00080794u)

/* srio_serdes_cfgrx3 */

#define CSL_BOOTCFG_SRIO_SERDES_CFGRX3_SRIO_SERDES_CFGRX3_MASK (0xFFFFFFFFu)
#define CSL_BOOTCFG_SRIO_SERDES_CFGRX3_SRIO_SERDES_CFGRX3_SHIFT (0x00000000u)
#define CSL_BOOTCFG_SRIO_SERDES_CFGRX3_SRIO_SERDES_CFGRX3_RESETVAL (0x00040494u)

#define CSL_BOOTCFG_SRIO_SERDES_CFGRX3_RESETVAL (0x00040494u)

/* srio_serdes_cfgtx3 */

#define CSL_BOOTCFG_SRIO_SERDES_CFGTX3_SRIO_SERDES_CFGTX3_MASK (0xFFFFFFFFu)
#define CSL_BOOTCFG_SRIO_SERDES_CFGTX3_SRIO_SERDES_CFGTX3_SHIFT (0x00000000u)
#define CSL_BOOTCFG_SRIO_SERDES_CFGTX3_SRIO_SERDES_CFGTX3_RESETVAL (0x00080794u)

#define CSL_BOOTCFG_SRIO_SERDES_CFGTX3_RESETVAL (0x00080794u)

/* srio_serdes_rsvd */

#define CSL_BOOTCFG_SRIO_SERDES_RSVD_SRIO_SERDES_RSVD_MASK (0xFFFFFFFFu)
#define CSL_BOOTCFG_SRIO_SERDES_RSVD_SRIO_SERDES_RSVD_SHIFT (0x00000000u)
#define CSL_BOOTCFG_SRIO_SERDES_RSVD_SRIO_SERDES_RSVD_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_SRIO_SERDES_RSVD_RESETVAL (0x00000000u)

/* led_gem_passdone */

#define CSL_BOOTCFG_LED_GEM_PASSDONE_D0_MASK (0x00000002u)
#define CSL_BOOTCFG_LED_GEM_PASSDONE_D0_SHIFT (0x00000001u)
#define CSL_BOOTCFG_LED_GEM_PASSDONE_D0_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_LED_GEM_PASSDONE_D1_MASK (0x00000020u)
#define CSL_BOOTCFG_LED_GEM_PASSDONE_D1_SHIFT (0x00000005u)
#define CSL_BOOTCFG_LED_GEM_PASSDONE_D1_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_LED_GEM_PASSDONE_D2_MASK (0x00000200u)
#define CSL_BOOTCFG_LED_GEM_PASSDONE_D2_SHIFT (0x00000009u)
#define CSL_BOOTCFG_LED_GEM_PASSDONE_D2_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_LED_GEM_PASSDONE_D3_MASK (0x00002000u)
#define CSL_BOOTCFG_LED_GEM_PASSDONE_D3_SHIFT (0x0000000Du)
#define CSL_BOOTCFG_LED_GEM_PASSDONE_D3_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_LED_GEM_PASSDONE_D4_MASK (0x00020000u)
#define CSL_BOOTCFG_LED_GEM_PASSDONE_D4_SHIFT (0x00000011u)
#define CSL_BOOTCFG_LED_GEM_PASSDONE_D4_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_LED_GEM_PASSDONE_D5_MASK (0x00200000u)
#define CSL_BOOTCFG_LED_GEM_PASSDONE_D5_SHIFT (0x00000015u)
#define CSL_BOOTCFG_LED_GEM_PASSDONE_D5_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_LED_GEM_PASSDONE_D6_MASK (0x02000000u)
#define CSL_BOOTCFG_LED_GEM_PASSDONE_D6_SHIFT (0x00000019u)
#define CSL_BOOTCFG_LED_GEM_PASSDONE_D6_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_LED_GEM_PASSDONE_D7_MASK (0x20000000u)
#define CSL_BOOTCFG_LED_GEM_PASSDONE_D7_SHIFT (0x0000001Du)
#define CSL_BOOTCFG_LED_GEM_PASSDONE_D7_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_LED_GEM_PASSDONE_I0_MASK (0x00000004u)
#define CSL_BOOTCFG_LED_GEM_PASSDONE_I0_SHIFT (0x00000002u)
#define CSL_BOOTCFG_LED_GEM_PASSDONE_I0_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_LED_GEM_PASSDONE_I1_MASK (0x00000040u)
#define CSL_BOOTCFG_LED_GEM_PASSDONE_I1_SHIFT (0x00000006u)
#define CSL_BOOTCFG_LED_GEM_PASSDONE_I1_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_LED_GEM_PASSDONE_I2_MASK (0x00000400u)
#define CSL_BOOTCFG_LED_GEM_PASSDONE_I2_SHIFT (0x0000000Au)
#define CSL_BOOTCFG_LED_GEM_PASSDONE_I2_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_LED_GEM_PASSDONE_I3_MASK (0x00004000u)
#define CSL_BOOTCFG_LED_GEM_PASSDONE_I3_SHIFT (0x0000000Eu)
#define CSL_BOOTCFG_LED_GEM_PASSDONE_I3_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_LED_GEM_PASSDONE_I4_MASK (0x00040000u)
#define CSL_BOOTCFG_LED_GEM_PASSDONE_I4_SHIFT (0x00000012u)
#define CSL_BOOTCFG_LED_GEM_PASSDONE_I4_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_LED_GEM_PASSDONE_I5_MASK (0x00400000u)
#define CSL_BOOTCFG_LED_GEM_PASSDONE_I5_SHIFT (0x00000016u)
#define CSL_BOOTCFG_LED_GEM_PASSDONE_I5_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_LED_GEM_PASSDONE_I6_MASK (0x04000000u)
#define CSL_BOOTCFG_LED_GEM_PASSDONE_I6_SHIFT (0x0000001Au)
#define CSL_BOOTCFG_LED_GEM_PASSDONE_I6_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_LED_GEM_PASSDONE_I7_MASK (0x40000000u)
#define CSL_BOOTCFG_LED_GEM_PASSDONE_I7_SHIFT (0x0000001Eu)
#define CSL_BOOTCFG_LED_GEM_PASSDONE_I7_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_LED_GEM_PASSDONE_L0_MASK (0x00000008u)
#define CSL_BOOTCFG_LED_GEM_PASSDONE_L0_SHIFT (0x00000003u)
#define CSL_BOOTCFG_LED_GEM_PASSDONE_L0_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_LED_GEM_PASSDONE_L1_MASK (0x00000080u)
#define CSL_BOOTCFG_LED_GEM_PASSDONE_L1_SHIFT (0x00000007u)
#define CSL_BOOTCFG_LED_GEM_PASSDONE_L1_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_LED_GEM_PASSDONE_L2_MASK (0x00000800u)
#define CSL_BOOTCFG_LED_GEM_PASSDONE_L2_SHIFT (0x0000000Bu)
#define CSL_BOOTCFG_LED_GEM_PASSDONE_L2_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_LED_GEM_PASSDONE_L3_MASK (0x00008000u)
#define CSL_BOOTCFG_LED_GEM_PASSDONE_L3_SHIFT (0x0000000Fu)
#define CSL_BOOTCFG_LED_GEM_PASSDONE_L3_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_LED_GEM_PASSDONE_L4_MASK (0x00080000u)
#define CSL_BOOTCFG_LED_GEM_PASSDONE_L4_SHIFT (0x00000013u)
#define CSL_BOOTCFG_LED_GEM_PASSDONE_L4_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_LED_GEM_PASSDONE_L5_MASK (0x00800000u)
#define CSL_BOOTCFG_LED_GEM_PASSDONE_L5_SHIFT (0x00000017u)
#define CSL_BOOTCFG_LED_GEM_PASSDONE_L5_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_LED_GEM_PASSDONE_L6_MASK (0x08000000u)
#define CSL_BOOTCFG_LED_GEM_PASSDONE_L6_SHIFT (0x0000001Bu)
#define CSL_BOOTCFG_LED_GEM_PASSDONE_L6_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_LED_GEM_PASSDONE_L7_MASK (0x80000000u)
#define CSL_BOOTCFG_LED_GEM_PASSDONE_L7_SHIFT (0x0000001Fu)
#define CSL_BOOTCFG_LED_GEM_PASSDONE_L7_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_LED_GEM_PASSDONE_P0_MASK (0x00000001u)
#define CSL_BOOTCFG_LED_GEM_PASSDONE_P0_SHIFT (0x00000000u)
#define CSL_BOOTCFG_LED_GEM_PASSDONE_P0_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_LED_GEM_PASSDONE_P1_MASK (0x00000010u)
#define CSL_BOOTCFG_LED_GEM_PASSDONE_P1_SHIFT (0x00000004u)
#define CSL_BOOTCFG_LED_GEM_PASSDONE_P1_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_LED_GEM_PASSDONE_P2_MASK (0x00000100u)
#define CSL_BOOTCFG_LED_GEM_PASSDONE_P2_SHIFT (0x00000008u)
#define CSL_BOOTCFG_LED_GEM_PASSDONE_P2_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_LED_GEM_PASSDONE_P3_MASK (0x00001000u)
#define CSL_BOOTCFG_LED_GEM_PASSDONE_P3_SHIFT (0x0000000Cu)
#define CSL_BOOTCFG_LED_GEM_PASSDONE_P3_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_LED_GEM_PASSDONE_P4_MASK (0x00010000u)
#define CSL_BOOTCFG_LED_GEM_PASSDONE_P4_SHIFT (0x00000010u)
#define CSL_BOOTCFG_LED_GEM_PASSDONE_P4_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_LED_GEM_PASSDONE_P5_MASK (0x00100000u)
#define CSL_BOOTCFG_LED_GEM_PASSDONE_P5_SHIFT (0x00000014u)
#define CSL_BOOTCFG_LED_GEM_PASSDONE_P5_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_LED_GEM_PASSDONE_P6_MASK (0x01000000u)
#define CSL_BOOTCFG_LED_GEM_PASSDONE_P6_SHIFT (0x00000018u)
#define CSL_BOOTCFG_LED_GEM_PASSDONE_P6_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_LED_GEM_PASSDONE_P7_MASK (0x10000000u)
#define CSL_BOOTCFG_LED_GEM_PASSDONE_P7_SHIFT (0x0000001Cu)
#define CSL_BOOTCFG_LED_GEM_PASSDONE_P7_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_LED_GEM_PASSDONE_RESETVAL (0x00000000u)

/* led_plllock */

#define CSL_BOOTCFG_LED_PLLLOCK_GEM0_CODE_LOADED_MASK (0x00000004u)
#define CSL_BOOTCFG_LED_PLLLOCK_GEM0_CODE_LOADED_SHIFT (0x00000002u)
#define CSL_BOOTCFG_LED_PLLLOCK_GEM0_CODE_LOADED_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_LED_PLLLOCK_GEM0_EXE_OK_MASK (0x00000008u)
#define CSL_BOOTCFG_LED_PLLLOCK_GEM0_EXE_OK_SHIFT (0x00000003u)
#define CSL_BOOTCFG_LED_PLLLOCK_GEM0_EXE_OK_RESETVAL (0x00000001u)

#define CSL_BOOTCFG_LED_PLLLOCK_GEM1_CODE_LOADED_MASK (0x00000010u)
#define CSL_BOOTCFG_LED_PLLLOCK_GEM1_CODE_LOADED_SHIFT (0x00000004u)
#define CSL_BOOTCFG_LED_PLLLOCK_GEM1_CODE_LOADED_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_LED_PLLLOCK_GEM1_EXE_OK_MASK (0x00000020u)
#define CSL_BOOTCFG_LED_PLLLOCK_GEM1_EXE_OK_SHIFT (0x00000005u)
#define CSL_BOOTCFG_LED_PLLLOCK_GEM1_EXE_OK_RESETVAL (0x00000001u)

#define CSL_BOOTCFG_LED_PLLLOCK_GEM2_CODE_LOADED_MASK (0x00000040u)
#define CSL_BOOTCFG_LED_PLLLOCK_GEM2_CODE_LOADED_SHIFT (0x00000006u)
#define CSL_BOOTCFG_LED_PLLLOCK_GEM2_CODE_LOADED_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_LED_PLLLOCK_GEM2_EXE_OK_MASK (0x00000080u)
#define CSL_BOOTCFG_LED_PLLLOCK_GEM2_EXE_OK_SHIFT (0x00000007u)
#define CSL_BOOTCFG_LED_PLLLOCK_GEM2_EXE_OK_RESETVAL (0x00000001u)

#define CSL_BOOTCFG_LED_PLLLOCK_GEM3_CODE_LOADED_MASK (0x00000100u)
#define CSL_BOOTCFG_LED_PLLLOCK_GEM3_CODE_LOADED_SHIFT (0x00000008u)
#define CSL_BOOTCFG_LED_PLLLOCK_GEM3_CODE_LOADED_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_LED_PLLLOCK_GEM3_EXE_OK_MASK (0x00000200u)
#define CSL_BOOTCFG_LED_PLLLOCK_GEM3_EXE_OK_SHIFT (0x00000009u)
#define CSL_BOOTCFG_LED_PLLLOCK_GEM3_EXE_OK_RESETVAL (0x00000001u)

#define CSL_BOOTCFG_LED_PLLLOCK_GEM4_CODE_LOADED_MASK (0x00000400u)
#define CSL_BOOTCFG_LED_PLLLOCK_GEM4_CODE_LOADED_SHIFT (0x0000000Au)
#define CSL_BOOTCFG_LED_PLLLOCK_GEM4_CODE_LOADED_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_LED_PLLLOCK_GEM4_EXE_OK_MASK (0x00000800u)
#define CSL_BOOTCFG_LED_PLLLOCK_GEM4_EXE_OK_SHIFT (0x0000000Bu)
#define CSL_BOOTCFG_LED_PLLLOCK_GEM4_EXE_OK_RESETVAL (0x00000001u)

#define CSL_BOOTCFG_LED_PLLLOCK_GEM5_CODE_LOADED_MASK (0x00001000u)
#define CSL_BOOTCFG_LED_PLLLOCK_GEM5_CODE_LOADED_SHIFT (0x0000000Cu)
#define CSL_BOOTCFG_LED_PLLLOCK_GEM5_CODE_LOADED_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_LED_PLLLOCK_GEM5_EXE_OK_MASK (0x00002000u)
#define CSL_BOOTCFG_LED_PLLLOCK_GEM5_EXE_OK_SHIFT (0x0000000Du)
#define CSL_BOOTCFG_LED_PLLLOCK_GEM5_EXE_OK_RESETVAL (0x00000001u)

#define CSL_BOOTCFG_LED_PLLLOCK_GEM6_CODE_LOADED_MASK (0x00004000u)
#define CSL_BOOTCFG_LED_PLLLOCK_GEM6_CODE_LOADED_SHIFT (0x0000000Eu)
#define CSL_BOOTCFG_LED_PLLLOCK_GEM6_CODE_LOADED_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_LED_PLLLOCK_GEM6_EXE_OK_MASK (0x00008000u)
#define CSL_BOOTCFG_LED_PLLLOCK_GEM6_EXE_OK_SHIFT (0x0000000Fu)
#define CSL_BOOTCFG_LED_PLLLOCK_GEM6_EXE_OK_RESETVAL (0x00000001u)

#define CSL_BOOTCFG_LED_PLLLOCK_GEM7_CODE_LOADED_MASK (0x00010000u)
#define CSL_BOOTCFG_LED_PLLLOCK_GEM7_CODE_LOADED_SHIFT (0x00000010u)
#define CSL_BOOTCFG_LED_PLLLOCK_GEM7_CODE_LOADED_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_LED_PLLLOCK_GEM7_EXE_OK_MASK (0x00020000u)
#define CSL_BOOTCFG_LED_PLLLOCK_GEM7_EXE_OK_SHIFT (0x00000011u)
#define CSL_BOOTCFG_LED_PLLLOCK_GEM7_EXE_OK_RESETVAL (0x00000001u)

#define CSL_BOOTCFG_LED_PLLLOCK_GEM_GENERAL_MASK (0x7FFC0000u)
#define CSL_BOOTCFG_LED_PLLLOCK_GEM_GENERAL_SHIFT (0x00000012u)
#define CSL_BOOTCFG_LED_PLLLOCK_GEM_GENERAL_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_LED_PLLLOCK_GEM_SUSP_CTL_MASK (0x80000000u)
#define CSL_BOOTCFG_LED_PLLLOCK_GEM_SUSP_CTL_SHIFT (0x0000001Fu)
#define CSL_BOOTCFG_LED_PLLLOCK_GEM_SUSP_CTL_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_LED_PLLLOCK_PLLLOCK_MASK (0x00000001u)
#define CSL_BOOTCFG_LED_PLLLOCK_PLLLOCK_SHIFT (0x00000000u)
#define CSL_BOOTCFG_LED_PLLLOCK_PLLLOCK_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_LED_PLLLOCK_STICKY_EN_LOCK_MASK (0x00000002u)
#define CSL_BOOTCFG_LED_PLLLOCK_STICKY_EN_LOCK_SHIFT (0x00000001u)
#define CSL_BOOTCFG_LED_PLLLOCK_STICKY_EN_LOCK_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_LED_PLLLOCK_RESETVAL (0x0002AAA8u)

/* led_chip_passdone */

#define CSL_BOOTCFG_LED_CHIP_PASSDONE_CHIP_DONE_MASK (0x00000002u)
#define CSL_BOOTCFG_LED_CHIP_PASSDONE_CHIP_DONE_SHIFT (0x00000001u)
#define CSL_BOOTCFG_LED_CHIP_PASSDONE_CHIP_DONE_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_LED_CHIP_PASSDONE_CHIP_PASS_MASK (0x00000001u)
#define CSL_BOOTCFG_LED_CHIP_PASSDONE_CHIP_PASS_SHIFT (0x00000000u)
#define CSL_BOOTCFG_LED_CHIP_PASSDONE_CHIP_PASS_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_LED_CHIP_PASSDONE_LED_CHIP_PASSDONE_RSVD_MASK (0xFFFFFFFCu)
#define CSL_BOOTCFG_LED_CHIP_PASSDONE_LED_CHIP_PASSDONE_RSVD_SHIFT (0x00000002u)
#define CSL_BOOTCFG_LED_CHIP_PASSDONE_LED_CHIP_PASSDONE_RSVD_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_LED_CHIP_PASSDONE_RESETVAL (0x00000000u)

/* tdiode */

#define CSL_BOOTCFG_TDIODE_TDIODE_MASK (0xFFFFFFFFu)
#define CSL_BOOTCFG_TDIODE_TDIODE_SHIFT (0x00000000u)
#define CSL_BOOTCFG_TDIODE_TDIODE_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_TDIODE_RESETVAL   (0x00000000u)

/* margin */

#define CSL_BOOTCFG_MARGIN_BTCFG_MARGIN_EN_MASK (0x80000000u)
#define CSL_BOOTCFG_MARGIN_BTCFG_MARGIN_EN_SHIFT (0x0000001Fu)
#define CSL_BOOTCFG_MARGIN_BTCFG_MARGIN_EN_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_MARGIN_DFTREAD0_MASK (0x001FC000u)
#define CSL_BOOTCFG_MARGIN_DFTREAD0_SHIFT (0x0000000Eu)
#define CSL_BOOTCFG_MARGIN_DFTREAD0_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_MARGIN_DFTREAD1_MASK (0x0FE00000u)
#define CSL_BOOTCFG_MARGIN_DFTREAD1_SHIFT (0x00000015u)
#define CSL_BOOTCFG_MARGIN_DFTREAD1_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_MARGIN_DFTWRITE0_MASK (0x0000007Fu)
#define CSL_BOOTCFG_MARGIN_DFTWRITE0_SHIFT (0x00000000u)
#define CSL_BOOTCFG_MARGIN_DFTWRITE0_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_MARGIN_DFTWRITE1_MASK (0x00003F80u)
#define CSL_BOOTCFG_MARGIN_DFTWRITE1_SHIFT (0x00000007u)
#define CSL_BOOTCFG_MARGIN_DFTWRITE1_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_MARGIN_RESETVAL   (0x00000000u)

/* secure_control */

#define CSL_BOOTCFG_SECURE_CONTROL_PBIST_SECURE_EN_MASK (0x00000001u)
#define CSL_BOOTCFG_SECURE_CONTROL_PBIST_SECURE_EN_SHIFT (0x00000000u)
#define CSL_BOOTCFG_SECURE_CONTROL_PBIST_SECURE_EN_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_SECURE_CONTROL_VUSR_SEC_EN_MASK (0x00000002u)
#define CSL_BOOTCFG_SECURE_CONTROL_VUSR_SEC_EN_SHIFT (0x00000001u)
#define CSL_BOOTCFG_SECURE_CONTROL_VUSR_SEC_EN_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_SECURE_CONTROL_RESETVAL (0x00000000u)

/* efuse_secrom_chksum0 */

#define CSL_BOOTCFG_EFUSE_SECROM_CHKSUM0_EFUSE_SECROM_CHKSUM0_MASK (0xFFFFFFFFu)
#define CSL_BOOTCFG_EFUSE_SECROM_CHKSUM0_EFUSE_SECROM_CHKSUM0_SHIFT (0x00000000u)
#define CSL_BOOTCFG_EFUSE_SECROM_CHKSUM0_EFUSE_SECROM_CHKSUM0_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_EFUSE_SECROM_CHKSUM0_RESETVAL (0x00000000u)

/* efuse_secrom_chksum1 */

#define CSL_BOOTCFG_EFUSE_SECROM_CHKSUM1_EFUSE_SECROM_CHKSUM1_MASK (0xFFFFFFFFu)
#define CSL_BOOTCFG_EFUSE_SECROM_CHKSUM1_EFUSE_SECROM_CHKSUM1_SHIFT (0x00000000u)
#define CSL_BOOTCFG_EFUSE_SECROM_CHKSUM1_EFUSE_SECROM_CHKSUM1_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_EFUSE_SECROM_CHKSUM1_RESETVAL (0x00000000u)

/* obsclk_ctl */

#define CSL_BOOTCFG_OBSCLK_CTL_CORE_PLL_OBSCLK_EN_MASK (0x00000002u)
#define CSL_BOOTCFG_OBSCLK_CTL_CORE_PLL_OBSCLK_EN_SHIFT (0x00000001u)
#define CSL_BOOTCFG_OBSCLK_CTL_CORE_PLL_OBSCLK_EN_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_OBSCLK_CTL_CORE_PLL_OBSCLK_SEL_MASK (0x00000001u)
#define CSL_BOOTCFG_OBSCLK_CTL_CORE_PLL_OBSCLK_SEL_SHIFT (0x00000000u)
#define CSL_BOOTCFG_OBSCLK_CTL_CORE_PLL_OBSCLK_SEL_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_OBSCLK_CTL_DDR3_PLL_OBSCLK_EN_MASK (0x00000008u)
#define CSL_BOOTCFG_OBSCLK_CTL_DDR3_PLL_OBSCLK_EN_SHIFT (0x00000003u)
#define CSL_BOOTCFG_OBSCLK_CTL_DDR3_PLL_OBSCLK_EN_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_OBSCLK_CTL_DDR3_PLL_OBSCLK_SEL_MASK (0x00000004u)
#define CSL_BOOTCFG_OBSCLK_CTL_DDR3_PLL_OBSCLK_SEL_SHIFT (0x00000002u)
#define CSL_BOOTCFG_OBSCLK_CTL_DDR3_PLL_OBSCLK_SEL_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_OBSCLK_CTL_PA_PLL_OBSCLK_EN_MASK (0x00000020u)
#define CSL_BOOTCFG_OBSCLK_CTL_PA_PLL_OBSCLK_EN_SHIFT (0x00000005u)
#define CSL_BOOTCFG_OBSCLK_CTL_PA_PLL_OBSCLK_EN_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_OBSCLK_CTL_PA_PLL_OBSCLK_SEL_MASK (0x00000010u)
#define CSL_BOOTCFG_OBSCLK_CTL_PA_PLL_OBSCLK_SEL_SHIFT (0x00000004u)
#define CSL_BOOTCFG_OBSCLK_CTL_PA_PLL_OBSCLK_SEL_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_OBSCLK_CTL_PSC_EMIF4F_RST_EN_MASK (0x00000040u)
#define CSL_BOOTCFG_OBSCLK_CTL_PSC_EMIF4F_RST_EN_SHIFT (0x00000006u)
#define CSL_BOOTCFG_OBSCLK_CTL_PSC_EMIF4F_RST_EN_RESETVAL (0x00000000u)
#define CSL_BOOTCFG_OBSCLK_CTL_RESETVAL (0x00000000u)

/* vusr_cfgpll */

#define CSL_BOOTCFG_VUSR_CFGPLL_VUSR_CFGPLL_MASK (0x0000FFFFu)
#define CSL_BOOTCFG_VUSR_CFGPLL_VUSR_CFGPLL_SHIFT (0x00000000u)
#define CSL_BOOTCFG_VUSR_CFGPLL_VUSR_CFGPLL_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_VUSR_CFGPLL_RESETVAL (0x00000000u)

/* vusr_cfgrx0 */

#define CSL_BOOTCFG_VUSR_CFGRX0_VUSR_CFGRX0_MASK (0xFFFFFFFFu)
#define CSL_BOOTCFG_VUSR_CFGRX0_VUSR_CFGRX0_SHIFT (0x00000000u)
#define CSL_BOOTCFG_VUSR_CFGRX0_VUSR_CFGRX0_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_VUSR_CFGRX0_RESETVAL (0x00000000u)

/* vusr_cfgtx0 */

#define CSL_BOOTCFG_VUSR_CFGTX0_VUSR_CFGTX0_MASK (0xFFFFFFFFu)
#define CSL_BOOTCFG_VUSR_CFGTX0_VUSR_CFGTX0_SHIFT (0x00000000u)
#define CSL_BOOTCFG_VUSR_CFGTX0_VUSR_CFGTX0_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_VUSR_CFGTX0_RESETVAL (0x00000000u)

/* vusr_cfgrx1 */

#define CSL_BOOTCFG_VUSR_CFGRX1_VUSR_CFGRX1_MASK (0xFFFFFFFFu)
#define CSL_BOOTCFG_VUSR_CFGRX1_VUSR_CFGRX1_SHIFT (0x00000000u)
#define CSL_BOOTCFG_VUSR_CFGRX1_VUSR_CFGRX1_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_VUSR_CFGRX1_RESETVAL (0x00000000u)

/* vusr_cfgtx1 */

#define CSL_BOOTCFG_VUSR_CFGTX1_VUSR_CFGTX1_MASK (0xFFFFFFFFu)
#define CSL_BOOTCFG_VUSR_CFGTX1_VUSR_CFGTX1_SHIFT (0x00000000u)
#define CSL_BOOTCFG_VUSR_CFGTX1_VUSR_CFGTX1_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_VUSR_CFGTX1_RESETVAL (0x00000000u)

/* vusr_cfgrx2 */

#define CSL_BOOTCFG_VUSR_CFGRX2_VUSR_CFGRX2_MASK (0xFFFFFFFFu)
#define CSL_BOOTCFG_VUSR_CFGRX2_VUSR_CFGRX2_SHIFT (0x00000000u)
#define CSL_BOOTCFG_VUSR_CFGRX2_VUSR_CFGRX2_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_VUSR_CFGRX2_RESETVAL (0x00000000u)

/* vusr_cfgtx2 */

#define CSL_BOOTCFG_VUSR_CFGTX2_VUSR_CFGTX2_MASK (0xFFFFFFFFu)
#define CSL_BOOTCFG_VUSR_CFGTX2_VUSR_CFGTX2_SHIFT (0x00000000u)
#define CSL_BOOTCFG_VUSR_CFGTX2_VUSR_CFGTX2_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_VUSR_CFGTX2_RESETVAL (0x00000000u)

/* vusr_cfgrx3 */

#define CSL_BOOTCFG_VUSR_CFGRX3_VUSR_CFGRX3_MASK (0xFFFFFFFFu)
#define CSL_BOOTCFG_VUSR_CFGRX3_VUSR_CFGRX3_SHIFT (0x00000000u)
#define CSL_BOOTCFG_VUSR_CFGRX3_VUSR_CFGRX3_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_VUSR_CFGRX3_RESETVAL (0x00000000u)

/* vusr_cfgtx3 */

#define CSL_BOOTCFG_VUSR_CFGTX3_VUSR_CFGTX3_MASK (0xFFFFFFFFu)
#define CSL_BOOTCFG_VUSR_CFGTX3_VUSR_CFGTX3_SHIFT (0x00000000u)
#define CSL_BOOTCFG_VUSR_CFGTX3_VUSR_CFGTX3_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_VUSR_CFGTX3_RESETVAL (0x00000000u)

/* vusr_serdes_rsvd */

#define CSL_BOOTCFG_VUSR_SERDES_RSVD_VUSR_SERDES_RSVD_MASK (0xFFFFFFFFu)
#define CSL_BOOTCFG_VUSR_SERDES_RSVD_VUSR_SERDES_RSVD_SHIFT (0x00000000u)
#define CSL_BOOTCFG_VUSR_SERDES_RSVD_VUSR_SERDES_RSVD_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_VUSR_SERDES_RSVD_RESETVAL (0x00000000u)

/* led_gpio_clr */

#define CSL_BOOTCFG_LED_GPIO_CLR_LED_GPIO_SRC_CLR_MASK (0xFFFFFFFFu)
#define CSL_BOOTCFG_LED_GPIO_CLR_LED_GPIO_SRC_CLR_SHIFT (0x00000000u)
#define CSL_BOOTCFG_LED_GPIO_CLR_LED_GPIO_SRC_CLR_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_LED_GPIO_CLR_RESETVAL (0x00000000u)

/* led_gpio */

#define CSL_BOOTCFG_LED_GPIO_LED_GPIO_SRC_MASK (0xFFFFFFFFu)
#define CSL_BOOTCFG_LED_GPIO_LED_GPIO_SRC_SHIFT (0x00000000u)
#define CSL_BOOTCFG_LED_GPIO_LED_GPIO_SRC_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_LED_GPIO_RESETVAL (0x00000000u)

/* efuse_rsvd0 */

#define CSL_BOOTCFG_EFUSE_RSVD0_EFUSE_RSVD0_MASK (0xFFFFFFFFu)
#define CSL_BOOTCFG_EFUSE_RSVD0_EFUSE_RSVD0_SHIFT (0x00000000u)
#define CSL_BOOTCFG_EFUSE_RSVD0_EFUSE_RSVD0_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_EFUSE_RSVD0_RESETVAL (0x00000000u)

/* efuse_rsvd1 */

#define CSL_BOOTCFG_EFUSE_RSVD1_EFUSE_RSVD1_MASK (0xFFFFFFFFu)
#define CSL_BOOTCFG_EFUSE_RSVD1_EFUSE_RSVD1_SHIFT (0x00000000u)
#define CSL_BOOTCFG_EFUSE_RSVD1_EFUSE_RSVD1_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_EFUSE_RSVD1_RESETVAL (0x00000000u)

/* efuse_rsvd2 */

#define CSL_BOOTCFG_EFUSE_RSVD2_EFUSE_RSVD2_MASK (0xFFFFFFFFu)
#define CSL_BOOTCFG_EFUSE_RSVD2_EFUSE_RSVD2_SHIFT (0x00000000u)
#define CSL_BOOTCFG_EFUSE_RSVD2_EFUSE_RSVD2_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_EFUSE_RSVD2_RESETVAL (0x00000000u)

/* efuse_rsvd3 */

#define CSL_BOOTCFG_EFUSE_RSVD3_EFUSE_RSVD3_MASK (0xFFFFFFFFu)
#define CSL_BOOTCFG_EFUSE_RSVD3_EFUSE_RSVD3_SHIFT (0x00000000u)
#define CSL_BOOTCFG_EFUSE_RSVD3_EFUSE_RSVD3_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_EFUSE_RSVD3_RESETVAL (0x00000000u)

/* chip_misc */

#define CSL_BOOTCFG_CHIP_MISC_CHIP_MISC_GEM_EMIF4F_PSC_LOCK_N_MASK (0x00000800u)
#define CSL_BOOTCFG_CHIP_MISC_CHIP_MISC_GEM_EMIF4F_PSC_LOCK_N_SHIFT (0x0000000Bu)
#define CSL_BOOTCFG_CHIP_MISC_CHIP_MISC_GEM_EMIF4F_PSC_LOCK_N_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_CHIP_MISC_CHIP_MISC_GEM_L2ACS_LAT_MASK (0x00000780u)
#define CSL_BOOTCFG_CHIP_MISC_CHIP_MISC_GEM_L2ACS_LAT_SHIFT (0x00000007u)
#define CSL_BOOTCFG_CHIP_MISC_CHIP_MISC_GEM_L2ACS_LAT_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_CHIP_MISC_CHIP_MISC_GEM_L2RDLAT_MASK (0x00000078u)
#define CSL_BOOTCFG_CHIP_MISC_CHIP_MISC_GEM_L2RDLAT_SHIFT (0x00000003u)
#define CSL_BOOTCFG_CHIP_MISC_CHIP_MISC_GEM_L2RDLAT_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_CHIP_MISC_CHIP_MISC_MSMC_BLOCK_PARITY_RST_MASK (0x00001000u)
#define CSL_BOOTCFG_CHIP_MISC_CHIP_MISC_MSMC_BLOCK_PARITY_RST_SHIFT (0x0000000Cu)
#define CSL_BOOTCFG_CHIP_MISC_CHIP_MISC_MSMC_BLOCK_PARITY_RST_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_CHIP_MISC_CHIP_MISC_QM_PRIOR_MASK (0x00000007u)
#define CSL_BOOTCFG_CHIP_MISC_CHIP_MISC_QM_PRIOR_SHIFT (0x00000000u)
#define CSL_BOOTCFG_CHIP_MISC_CHIP_MISC_QM_PRIOR_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_CHIP_MISC_RST_ISO_IP_RST_BLK_MASK (0x000FE000u)
#define CSL_BOOTCFG_CHIP_MISC_RST_ISO_IP_RST_BLK_SHIFT (0x0000000Du)
#define CSL_BOOTCFG_CHIP_MISC_RST_ISO_IP_RST_BLK_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_CHIP_MISC_RESETVAL (0x00000000u)

/* ddr3_config_reg_0 */

#define CSL_BOOTCFG_DDR3_CONFIG_REG_0_CMD0_PHY_REG_STATUS_PHY_CTRL_DLL_LOCK_MASK (0x00000010u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_0_CMD0_PHY_REG_STATUS_PHY_CTRL_DLL_LOCK_SHIFT (0x00000004u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_0_CMD0_PHY_REG_STATUS_PHY_CTRL_DLL_LOCK_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_DDR3_CONFIG_REG_0_CMD0_PHY_REG_STATUS_PHY_CTRL_OF_IN_LOCK_STATE_MASK (0x00000180u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_0_CMD0_PHY_REG_STATUS_PHY_CTRL_OF_IN_LOCK_STATE_SHIFT (0x00000007u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_0_CMD0_PHY_REG_STATUS_PHY_CTRL_OF_IN_LOCK_STATE_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_DDR3_CONFIG_REG_0_CMD1_PHY_REG_STATUS_PHY_CTRL_DLL_LOCK_MASK (0x00000020u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_0_CMD1_PHY_REG_STATUS_PHY_CTRL_DLL_LOCK_SHIFT (0x00000005u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_0_CMD1_PHY_REG_STATUS_PHY_CTRL_DLL_LOCK_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_DDR3_CONFIG_REG_0_CMD1_PHY_REG_STATUS_PHY_CTRL_OF_IN_LOCK_STATE_MASK (0x00000600u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_0_CMD1_PHY_REG_STATUS_PHY_CTRL_OF_IN_LOCK_STATE_SHIFT (0x00000009u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_0_CMD1_PHY_REG_STATUS_PHY_CTRL_OF_IN_LOCK_STATE_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_DDR3_CONFIG_REG_0_CMD2_PHY_REG_STATUS_PHY_CTRL_DLL_LOCK_MASK (0x00000040u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_0_CMD2_PHY_REG_STATUS_PHY_CTRL_DLL_LOCK_SHIFT (0x00000006u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_0_CMD2_PHY_REG_STATUS_PHY_CTRL_DLL_LOCK_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_DDR3_CONFIG_REG_0_CMD2_PHY_REG_STATUS_PHY_CTRL_OF_IN_LOCK_STATE_MASK (0x00001800u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_0_CMD2_PHY_REG_STATUS_PHY_CTRL_OF_IN_LOCK_STATE_SHIFT (0x0000000Bu)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_0_CMD2_PHY_REG_STATUS_PHY_CTRL_OF_IN_LOCK_STATE_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_DDR3_CONFIG_REG_0_CMD_REG_PHY_CTRL_SLAVE_RATIO_MASK (0x007FE000u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_0_CMD_REG_PHY_CTRL_SLAVE_RATIO_SHIFT (0x0000000Du)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_0_CMD_REG_PHY_CTRL_SLAVE_RATIO_RESETVAL (0x00000080u)

#define CSL_BOOTCFG_DDR3_CONFIG_REG_0_CMD_REQ_PHY_DLL_LOCK_DIFF_MASK (0x0000000Fu)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_0_CMD_REQ_PHY_DLL_LOCK_DIFF_SHIFT (0x00000000u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_0_CMD_REQ_PHY_DLL_LOCK_DIFF_RESETVAL (0x00000001u)

#define CSL_BOOTCFG_DDR3_CONFIG_REG_0_DATA0_PHY_REG_STATUS_DLL_LOCK_MASK (0x00800000u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_0_DATA0_PHY_REG_STATUS_DLL_LOCK_SHIFT (0x00000017u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_0_DATA0_PHY_REG_STATUS_DLL_LOCK_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_DDR3_CONFIG_REG_0_DATA1_PHY_REG_STATUS_DLL_LOCK_MASK (0x01000000u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_0_DATA1_PHY_REG_STATUS_DLL_LOCK_SHIFT (0x00000018u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_0_DATA1_PHY_REG_STATUS_DLL_LOCK_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_DDR3_CONFIG_REG_0_DATA2_PHY_REG_STATUS_DLL_LOCK_MASK (0x02000000u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_0_DATA2_PHY_REG_STATUS_DLL_LOCK_SHIFT (0x00000019u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_0_DATA2_PHY_REG_STATUS_DLL_LOCK_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_DDR3_CONFIG_REG_0_DATA3_PHY_REG_STATUS_DLL_LOCK_MASK (0x04000000u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_0_DATA3_PHY_REG_STATUS_DLL_LOCK_SHIFT (0x0000001Au)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_0_DATA3_PHY_REG_STATUS_DLL_LOCK_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_DDR3_CONFIG_REG_0_DATA4_PHY_REG_STATUS_DLL_LOCK_MASK (0x08000000u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_0_DATA4_PHY_REG_STATUS_DLL_LOCK_SHIFT (0x0000001Bu)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_0_DATA4_PHY_REG_STATUS_DLL_LOCK_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_DDR3_CONFIG_REG_0_DATA5_PHY_REG_STATUS_DLL_LOCK_MASK (0x10000000u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_0_DATA5_PHY_REG_STATUS_DLL_LOCK_SHIFT (0x0000001Cu)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_0_DATA5_PHY_REG_STATUS_DLL_LOCK_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_DDR3_CONFIG_REG_0_DATA6_PHY_REG_STATUS_DLL_LOCK_MASK (0x20000000u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_0_DATA6_PHY_REG_STATUS_DLL_LOCK_SHIFT (0x0000001Du)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_0_DATA6_PHY_REG_STATUS_DLL_LOCK_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_DDR3_CONFIG_REG_0_DATA7_PHY_REG_STATUS_DLL_LOCK_MASK (0x40000000u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_0_DATA7_PHY_REG_STATUS_DLL_LOCK_SHIFT (0x0000001Eu)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_0_DATA7_PHY_REG_STATUS_DLL_LOCK_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_DDR3_CONFIG_REG_0_DATA8_PHY_REG_STATUS_DLL_LOCK_MASK (0x80000000u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_0_DATA8_PHY_REG_STATUS_DLL_LOCK_SHIFT (0x0000001Fu)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_0_DATA8_PHY_REG_STATUS_DLL_LOCK_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_DDR3_CONFIG_REG_0_RESETVAL (0x00100001u)

/* ddr3_config_reg_1 */

#define CSL_BOOTCFG_DDR3_CONFIG_REG_1_DATA0_PHY_REG_STATUS_OF_IN_LOCK_STATE_MASK (0x00000003u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_1_DATA0_PHY_REG_STATUS_OF_IN_LOCK_STATE_SHIFT (0x00000000u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_1_DATA0_PHY_REG_STATUS_OF_IN_LOCK_STATE_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_DDR3_CONFIG_REG_1_DATA1_PHY_REG_STATUS_OF_IN_LOCK_STATE_MASK (0x0000000Cu)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_1_DATA1_PHY_REG_STATUS_OF_IN_LOCK_STATE_SHIFT (0x00000002u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_1_DATA1_PHY_REG_STATUS_OF_IN_LOCK_STATE_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_DDR3_CONFIG_REG_1_DATA2_PHY_REG_STATUS_OF_IN_LOCK_STATE_MASK (0x00000030u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_1_DATA2_PHY_REG_STATUS_OF_IN_LOCK_STATE_SHIFT (0x00000004u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_1_DATA2_PHY_REG_STATUS_OF_IN_LOCK_STATE_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_DDR3_CONFIG_REG_1_DATA3_PHY_REG_STATUS_OF_IN_LOCK_STATE_MASK (0x000000C0u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_1_DATA3_PHY_REG_STATUS_OF_IN_LOCK_STATE_SHIFT (0x00000006u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_1_DATA3_PHY_REG_STATUS_OF_IN_LOCK_STATE_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_DDR3_CONFIG_REG_1_DATA4_PHY_REG_STATUS_OF_IN_LOCK_STATE_MASK (0x00000300u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_1_DATA4_PHY_REG_STATUS_OF_IN_LOCK_STATE_SHIFT (0x00000008u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_1_DATA4_PHY_REG_STATUS_OF_IN_LOCK_STATE_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_DDR3_CONFIG_REG_1_DATA5_PHY_REG_STATUS_OF_IN_LOCK_STATE_MASK (0x00000C00u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_1_DATA5_PHY_REG_STATUS_OF_IN_LOCK_STATE_SHIFT (0x0000000Au)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_1_DATA5_PHY_REG_STATUS_OF_IN_LOCK_STATE_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_DDR3_CONFIG_REG_1_DATA6_PHY_REG_STATUS_OF_IN_LOCK_STATE_MASK (0x00003000u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_1_DATA6_PHY_REG_STATUS_OF_IN_LOCK_STATE_SHIFT (0x0000000Cu)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_1_DATA6_PHY_REG_STATUS_OF_IN_LOCK_STATE_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_DDR3_CONFIG_REG_1_DATA7_PHY_REG_STATUS_OF_IN_LOCK_STATE_MASK (0x0000C000u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_1_DATA7_PHY_REG_STATUS_OF_IN_LOCK_STATE_SHIFT (0x0000000Eu)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_1_DATA7_PHY_REG_STATUS_OF_IN_LOCK_STATE_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_DDR3_CONFIG_REG_1_DATA8_PHY_REG_STATUS_OF_IN_LOCK_STATE_MASK (0x00030000u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_1_DATA8_PHY_REG_STATUS_OF_IN_LOCK_STATE_SHIFT (0x00000010u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_1_DATA8_PHY_REG_STATUS_OF_IN_LOCK_STATE_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_DDR3_CONFIG_REG_1_DATA_REG_PHY_DQ_OFFSET_MASK (0x01FC0000u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_1_DATA_REG_PHY_DQ_OFFSET_SHIFT (0x00000012u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_1_DATA_REG_PHY_DQ_OFFSET_RESETVAL (0x00000040u)

#define CSL_BOOTCFG_DDR3_CONFIG_REG_1_RESETVAL (0x01000000u)

/* ddr3_config_reg_2 */

#define CSL_BOOTCFG_DDR3_CONFIG_REG_2_DATA0_REG_PHY_WRLVL_INIT_RATIO_MASK (0x000FFFFFu)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_2_DATA0_REG_PHY_WRLVL_INIT_RATIO_SHIFT (0x00000000u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_2_DATA0_REG_PHY_WRLVL_INIT_RATIO_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_DDR3_CONFIG_REG_2_RESETVAL (0x00000000u)

/* ddr3_config_reg_3 */

#define CSL_BOOTCFG_DDR3_CONFIG_REG_3_DATA1_REG_PHY_WRLVL_INIT_RATIO_MASK (0x000FFFFFu)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_3_DATA1_REG_PHY_WRLVL_INIT_RATIO_SHIFT (0x00000000u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_3_DATA1_REG_PHY_WRLVL_INIT_RATIO_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_DDR3_CONFIG_REG_3_RESETVAL (0x00000000u)

/* ddr3_config_reg_4 */

#define CSL_BOOTCFG_DDR3_CONFIG_REG_4_DATA2_REG_PHY_WRLVL_INIT_RATIO_MASK (0x000FFFFFu)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_4_DATA2_REG_PHY_WRLVL_INIT_RATIO_SHIFT (0x00000000u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_4_DATA2_REG_PHY_WRLVL_INIT_RATIO_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_DDR3_CONFIG_REG_4_RESETVAL (0x00000000u)

/* ddr3_config_reg_5 */

#define CSL_BOOTCFG_DDR3_CONFIG_REG_5_DATA3_REG_PHY_WRLVL_INIT_RATIO_MASK (0x000FFFFFu)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_5_DATA3_REG_PHY_WRLVL_INIT_RATIO_SHIFT (0x00000000u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_5_DATA3_REG_PHY_WRLVL_INIT_RATIO_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_DDR3_CONFIG_REG_5_RESETVAL (0x00000000u)

/* ddr3_config_reg_6 */

#define CSL_BOOTCFG_DDR3_CONFIG_REG_6_DATA4_REG_PHY_WRLVL_INIT_RATIO_MASK (0x000FFFFFu)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_6_DATA4_REG_PHY_WRLVL_INIT_RATIO_SHIFT (0x00000000u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_6_DATA4_REG_PHY_WRLVL_INIT_RATIO_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_DDR3_CONFIG_REG_6_RESETVAL (0x00000000u)

/* ddr3_config_reg_7 */

#define CSL_BOOTCFG_DDR3_CONFIG_REG_7_DATA5_REG_PHY_WRLVL_INIT_RATIO_MASK (0x000FFFFFu)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_7_DATA5_REG_PHY_WRLVL_INIT_RATIO_SHIFT (0x00000000u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_7_DATA5_REG_PHY_WRLVL_INIT_RATIO_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_DDR3_CONFIG_REG_7_RESETVAL (0x00000000u)

/* ddr3_config_reg_8 */

#define CSL_BOOTCFG_DDR3_CONFIG_REG_8_DATA6_REG_PHY_WRLVL_INIT_RATIO_MASK (0x000FFFFFu)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_8_DATA6_REG_PHY_WRLVL_INIT_RATIO_SHIFT (0x00000000u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_8_DATA6_REG_PHY_WRLVL_INIT_RATIO_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_DDR3_CONFIG_REG_8_RESETVAL (0x00000000u)

/* ddr3_config_reg_9 */

#define CSL_BOOTCFG_DDR3_CONFIG_REG_9_DATA7_REG_PHY_WRLVL_INIT_RATIO_MASK (0x000FFFFFu)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_9_DATA7_REG_PHY_WRLVL_INIT_RATIO_SHIFT (0x00000000u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_9_DATA7_REG_PHY_WRLVL_INIT_RATIO_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_DDR3_CONFIG_REG_9_RESETVAL (0x00000000u)

/* ddr3_config_reg_10 */

#define CSL_BOOTCFG_DDR3_CONFIG_REG_10_DATA8_REG_PHY_WRLVL_INIT_RATIO_MASK (0x000FFFFFu)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_10_DATA8_REG_PHY_WRLVL_INIT_RATIO_SHIFT (0x00000000u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_10_DATA8_REG_PHY_WRLVL_INIT_RATIO_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_DDR3_CONFIG_REG_10_RESETVAL (0x00000000u)

/* ddr3_config_reg_11 */

#define CSL_BOOTCFG_DDR3_CONFIG_REG_11_DATA0_PHY_REG_RDC_FIFO_RST_ERR_CNT_MASK (0x003C0000u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_11_DATA0_PHY_REG_RDC_FIFO_RST_ERR_CNT_SHIFT (0x00000012u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_11_DATA0_PHY_REG_RDC_FIFO_RST_ERR_CNT_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_DDR3_CONFIG_REG_11_DATA0_REG_PHY_DIS_CALIB_RST_MASK (0x00000001u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_11_DATA0_REG_PHY_DIS_CALIB_RST_SHIFT (0x00000000u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_11_DATA0_REG_PHY_DIS_CALIB_RST_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_DDR3_CONFIG_REG_11_DATA0_REG_PHY_RDC_FIFO_RST_ERR_CNT_CLR_MASK (0x00000200u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_11_DATA0_REG_PHY_RDC_FIFO_RST_ERR_CNT_CLR_SHIFT (0x00000009u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_11_DATA0_REG_PHY_RDC_FIFO_RST_ERR_CNT_CLR_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_DDR3_CONFIG_REG_11_DATA1_PHY_REG_RDC_FIFO_RST_ERR_CNT_MASK (0x03C00000u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_11_DATA1_PHY_REG_RDC_FIFO_RST_ERR_CNT_SHIFT (0x00000016u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_11_DATA1_PHY_REG_RDC_FIFO_RST_ERR_CNT_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_DDR3_CONFIG_REG_11_DATA1_REG_PHY_DIS_CALIB_RST_MASK (0x00000002u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_11_DATA1_REG_PHY_DIS_CALIB_RST_SHIFT (0x00000001u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_11_DATA1_REG_PHY_DIS_CALIB_RST_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_DDR3_CONFIG_REG_11_DATA1_REG_PHY_RDC_FIFO_RST_ERR_CNT_CLR_MASK (0x00000400u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_11_DATA1_REG_PHY_RDC_FIFO_RST_ERR_CNT_CLR_SHIFT (0x0000000Au)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_11_DATA1_REG_PHY_RDC_FIFO_RST_ERR_CNT_CLR_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_DDR3_CONFIG_REG_11_DATA2_PHY_REG_RDC_FIFO_RST_ERR_CNT_MASK (0x3C000000u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_11_DATA2_PHY_REG_RDC_FIFO_RST_ERR_CNT_SHIFT (0x0000001Au)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_11_DATA2_PHY_REG_RDC_FIFO_RST_ERR_CNT_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_DDR3_CONFIG_REG_11_DATA2_REG_PHY_DIS_CALIB_RST_MASK (0x00000004u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_11_DATA2_REG_PHY_DIS_CALIB_RST_SHIFT (0x00000002u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_11_DATA2_REG_PHY_DIS_CALIB_RST_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_DDR3_CONFIG_REG_11_DATA2_REG_PHY_RDC_FIFO_RST_ERR_CNT_CLR_MASK (0x00000800u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_11_DATA2_REG_PHY_RDC_FIFO_RST_ERR_CNT_CLR_SHIFT (0x0000000Bu)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_11_DATA2_REG_PHY_RDC_FIFO_RST_ERR_CNT_CLR_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_DDR3_CONFIG_REG_11_DATA3_REG_PHY_DIS_CALIB_RST_MASK (0x00000008u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_11_DATA3_REG_PHY_DIS_CALIB_RST_SHIFT (0x00000003u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_11_DATA3_REG_PHY_DIS_CALIB_RST_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_DDR3_CONFIG_REG_11_DATA3_REG_PHY_RDC_FIFO_RST_ERR_CNT_CLR_MASK (0x00001000u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_11_DATA3_REG_PHY_RDC_FIFO_RST_ERR_CNT_CLR_SHIFT (0x0000000Cu)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_11_DATA3_REG_PHY_RDC_FIFO_RST_ERR_CNT_CLR_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_DDR3_CONFIG_REG_11_DATA4_REG_PHY_DIS_CALIB_RST_MASK (0x00000010u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_11_DATA4_REG_PHY_DIS_CALIB_RST_SHIFT (0x00000004u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_11_DATA4_REG_PHY_DIS_CALIB_RST_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_DDR3_CONFIG_REG_11_DATA4_REG_PHY_RDC_FIFO_RST_ERR_CNT_CLR_MASK (0x00002000u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_11_DATA4_REG_PHY_RDC_FIFO_RST_ERR_CNT_CLR_SHIFT (0x0000000Du)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_11_DATA4_REG_PHY_RDC_FIFO_RST_ERR_CNT_CLR_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_DDR3_CONFIG_REG_11_DATA5_REG_PHY_DIS_CALIB_RST_MASK (0x00000020u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_11_DATA5_REG_PHY_DIS_CALIB_RST_SHIFT (0x00000005u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_11_DATA5_REG_PHY_DIS_CALIB_RST_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_DDR3_CONFIG_REG_11_DATA5_REG_PHY_RDC_FIFO_RST_ERR_CNT_CLR_MASK (0x00004000u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_11_DATA5_REG_PHY_RDC_FIFO_RST_ERR_CNT_CLR_SHIFT (0x0000000Eu)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_11_DATA5_REG_PHY_RDC_FIFO_RST_ERR_CNT_CLR_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_DDR3_CONFIG_REG_11_DATA6_REG_PHY_DIS_CALIB_RST_MASK (0x00000040u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_11_DATA6_REG_PHY_DIS_CALIB_RST_SHIFT (0x00000006u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_11_DATA6_REG_PHY_DIS_CALIB_RST_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_DDR3_CONFIG_REG_11_DATA6_REG_PHY_RDC_FIFO_RST_ERR_CNT_CLR_MASK (0x00008000u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_11_DATA6_REG_PHY_RDC_FIFO_RST_ERR_CNT_CLR_SHIFT (0x0000000Fu)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_11_DATA6_REG_PHY_RDC_FIFO_RST_ERR_CNT_CLR_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_DDR3_CONFIG_REG_11_DATA7_REG_PHY_DIS_CALIB_RST_MASK (0x00000080u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_11_DATA7_REG_PHY_DIS_CALIB_RST_SHIFT (0x00000007u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_11_DATA7_REG_PHY_DIS_CALIB_RST_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_DDR3_CONFIG_REG_11_DATA7_REG_PHY_RDC_FIFO_RST_ERR_CNT_CLR_MASK (0x00010000u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_11_DATA7_REG_PHY_RDC_FIFO_RST_ERR_CNT_CLR_SHIFT (0x00000010u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_11_DATA7_REG_PHY_RDC_FIFO_RST_ERR_CNT_CLR_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_DDR3_CONFIG_REG_11_DATA8_REG_PHY_DIS_CALIB_RST_MASK (0x00000100u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_11_DATA8_REG_PHY_DIS_CALIB_RST_SHIFT (0x00000008u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_11_DATA8_REG_PHY_DIS_CALIB_RST_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_DDR3_CONFIG_REG_11_DATA8_REG_PHY_RDC_FIFO_RST_ERR_CNT_CLR_MASK (0x00020000u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_11_DATA8_REG_PHY_RDC_FIFO_RST_ERR_CNT_CLR_SHIFT (0x00000011u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_11_DATA8_REG_PHY_RDC_FIFO_RST_ERR_CNT_CLR_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_DDR3_CONFIG_REG_11_RESETVAL (0x00000000u)

/* ddr3_config_reg_12 */

#define CSL_BOOTCFG_DDR3_CONFIG_REG_12_CMD_REG_PHY_INVERT_CLKOUT_MASK (0x08000000u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_12_CMD_REG_PHY_INVERT_CLKOUT_SHIFT (0x0000001Bu)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_12_CMD_REG_PHY_INVERT_CLKOUT_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_DDR3_CONFIG_REG_12_DATA3_PHY_REG_RDC_FIFO_RST_ERR_CNT_MASK (0x0000000Fu)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_12_DATA3_PHY_REG_RDC_FIFO_RST_ERR_CNT_SHIFT (0x00000000u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_12_DATA3_PHY_REG_RDC_FIFO_RST_ERR_CNT_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_DDR3_CONFIG_REG_12_DATA4_PHY_REG_RDC_FIFO_RST_ERR_CNT_MASK (0x000000F0u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_12_DATA4_PHY_REG_RDC_FIFO_RST_ERR_CNT_SHIFT (0x00000004u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_12_DATA4_PHY_REG_RDC_FIFO_RST_ERR_CNT_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_DDR3_CONFIG_REG_12_DATA5_PHY_REG_RDC_FIFO_RST_ERR_CNT_MASK (0x00000F00u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_12_DATA5_PHY_REG_RDC_FIFO_RST_ERR_CNT_SHIFT (0x00000008u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_12_DATA5_PHY_REG_RDC_FIFO_RST_ERR_CNT_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_DDR3_CONFIG_REG_12_DATA6_PHY_REG_RDC_FIFO_RST_ERR_CNT_MASK (0x0000F000u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_12_DATA6_PHY_REG_RDC_FIFO_RST_ERR_CNT_SHIFT (0x0000000Cu)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_12_DATA6_PHY_REG_RDC_FIFO_RST_ERR_CNT_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_DDR3_CONFIG_REG_12_DATA7_PHY_REG_RDC_FIFO_RST_ERR_CNT_MASK (0x000F0000u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_12_DATA7_PHY_REG_RDC_FIFO_RST_ERR_CNT_SHIFT (0x00000010u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_12_DATA7_PHY_REG_RDC_FIFO_RST_ERR_CNT_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_DDR3_CONFIG_REG_12_DATA8_PHY_REG_RDC_FIFO_RST_ERR_CNT_MASK (0x00F00000u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_12_DATA8_PHY_REG_RDC_FIFO_RST_ERR_CNT_SHIFT (0x00000014u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_12_DATA8_PHY_REG_RDC_FIFO_RST_ERR_CNT_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_DDR3_CONFIG_REG_12_DATA_REG_PHY_USE_RANK0_DELAYS_MASK (0x01000000u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_12_DATA_REG_PHY_USE_RANK0_DELAYS_SHIFT (0x00000018u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_12_DATA_REG_PHY_USE_RANK0_DELAYS_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_DDR3_CONFIG_REG_12_DATA_REG_PHY_WR_LVL_BYPASS_DQS_IO_MASK (0x02000000u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_12_DATA_REG_PHY_WR_LVL_BYPASS_DQS_IO_SHIFT (0x00000019u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_12_DATA_REG_PHY_WR_LVL_BYPASS_DQS_IO_RESETVAL (0x00000001u)

#define CSL_BOOTCFG_DDR3_CONFIG_REG_12_DDR3_RST_DEF_VAL_MASK (0x04000000u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_12_DDR3_RST_DEF_VAL_SHIFT (0x0000001Au)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_12_DDR3_RST_DEF_VAL_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_DDR3_CONFIG_REG_12_RESETVAL (0x02000000u)

/* ddr3_config_reg_13 */

#define CSL_BOOTCFG_DDR3_CONFIG_REG_13_CMD0_IN_DELAY_VALUE_MASK (0x000001FFu)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_13_CMD0_IN_DELAY_VALUE_SHIFT (0x00000000u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_13_CMD0_IN_DELAY_VALUE_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_DDR3_CONFIG_REG_13_CMD1_IN_DELAY_VALUE_MASK (0x0007FC00u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_13_CMD1_IN_DELAY_VALUE_SHIFT (0x0000000Au)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_13_CMD1_IN_DELAY_VALUE_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_DDR3_CONFIG_REG_13_CMD2_IN_DELAY_VALUE_MASK (0x0FF80000u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_13_CMD2_IN_DELAY_VALUE_SHIFT (0x00000013u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_13_CMD2_IN_DELAY_VALUE_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_DDR3_CONFIG_REG_13_RESETVAL (0x00000000u)

/* ddr3_config_reg_14 */

#define CSL_BOOTCFG_DDR3_CONFIG_REG_14_DATA0_REG_PHY_GATELVL_INIT_RATIO_MASK (0x000FFFFFu)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_14_DATA0_REG_PHY_GATELVL_INIT_RATIO_SHIFT (0x00000000u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_14_DATA0_REG_PHY_GATELVL_INIT_RATIO_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_DDR3_CONFIG_REG_14_RESETVAL (0x00000000u)

/* ddr3_config_reg_15 */

#define CSL_BOOTCFG_DDR3_CONFIG_REG_15_DATA1_REG_PHY_GATELVL_INIT_RATIO_MASK (0x000FFFFFu)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_15_DATA1_REG_PHY_GATELVL_INIT_RATIO_SHIFT (0x00000000u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_15_DATA1_REG_PHY_GATELVL_INIT_RATIO_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_DDR3_CONFIG_REG_15_RESETVAL (0x00000000u)

/* ddr3_config_reg_16 */

#define CSL_BOOTCFG_DDR3_CONFIG_REG_16_DATA2_REG_PHY_GATELVL_INIT_RATIO_MASK (0x000FFFFFu)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_16_DATA2_REG_PHY_GATELVL_INIT_RATIO_SHIFT (0x00000000u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_16_DATA2_REG_PHY_GATELVL_INIT_RATIO_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_DDR3_CONFIG_REG_16_RESETVAL (0x00000000u)

/* ddr3_config_reg_17 */

#define CSL_BOOTCFG_DDR3_CONFIG_REG_17_DATA3_REG_PHY_GATELVL_INIT_RATIO_MASK (0x000FFFFFu)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_17_DATA3_REG_PHY_GATELVL_INIT_RATIO_SHIFT (0x00000000u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_17_DATA3_REG_PHY_GATELVL_INIT_RATIO_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_DDR3_CONFIG_REG_17_RESETVAL (0x00000000u)

/* ddr3_config_reg_18 */

#define CSL_BOOTCFG_DDR3_CONFIG_REG_18_DATA4_REG_PHY_GATELVL_INIT_RATIO_MASK (0x000FFFFFu)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_18_DATA4_REG_PHY_GATELVL_INIT_RATIO_SHIFT (0x00000000u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_18_DATA4_REG_PHY_GATELVL_INIT_RATIO_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_DDR3_CONFIG_REG_18_RESETVAL (0x00000000u)

/* ddr3_config_reg_19 */

#define CSL_BOOTCFG_DDR3_CONFIG_REG_19_DATA5_REG_PHY_GATELVL_INIT_RATIO_MASK (0x000FFFFFu)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_19_DATA5_REG_PHY_GATELVL_INIT_RATIO_SHIFT (0x00000000u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_19_DATA5_REG_PHY_GATELVL_INIT_RATIO_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_DDR3_CONFIG_REG_19_RESETVAL (0x00000000u)

/* ddr3_config_reg_20 */

#define CSL_BOOTCFG_DDR3_CONFIG_REG_20_DATA6_REG_PHY_GATELVL_INIT_RATIO_MASK (0x000FFFFFu)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_20_DATA6_REG_PHY_GATELVL_INIT_RATIO_SHIFT (0x00000000u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_20_DATA6_REG_PHY_GATELVL_INIT_RATIO_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_DDR3_CONFIG_REG_20_RESETVAL (0x00000000u)

/* ddr3_config_reg_21 */

#define CSL_BOOTCFG_DDR3_CONFIG_REG_21_DATA7_REG_PHY_GATELVL_INIT_RATIO_MASK (0x000FFFFFu)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_21_DATA7_REG_PHY_GATELVL_INIT_RATIO_SHIFT (0x00000000u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_21_DATA7_REG_PHY_GATELVL_INIT_RATIO_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_DDR3_CONFIG_REG_21_RESETVAL (0x00000000u)

/* ddr3_config_reg_22 */

#define CSL_BOOTCFG_DDR3_CONFIG_REG_22_DATA8_REG_PHY_GATELVL_INIT_RATIO_MASK (0x000FFFFFu)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_22_DATA8_REG_PHY_GATELVL_INIT_RATIO_SHIFT (0x00000000u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_22_DATA8_REG_PHY_GATELVL_INIT_RATIO_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_DDR3_CONFIG_REG_22_RESETVAL (0x00000000u)

/* ddr3_config_reg_23 */

#define CSL_BOOTCFG_DDR3_CONFIG_REG_23_RD_DQS_SLAVE_RAIO_MASK (0x000003FFu)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_23_RD_DQS_SLAVE_RAIO_SHIFT (0x00000000u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_23_RD_DQS_SLAVE_RAIO_RESETVAL (0x00000034u)

#define CSL_BOOTCFG_DDR3_CONFIG_REG_23_WR_DATA_SLAVE_RATIO_MASK (0x3FF00000u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_23_WR_DATA_SLAVE_RATIO_SHIFT (0x00000014u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_23_WR_DATA_SLAVE_RATIO_RESETVAL (0x000000A6u)

#define CSL_BOOTCFG_DDR3_CONFIG_REG_23_WR_DQS_SLAVE_RATIO_MASK (0x000FFC00u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_23_WR_DQS_SLAVE_RATIO_SHIFT (0x0000000Au)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_23_WR_DQS_SLAVE_RATIO_RESETVAL (0x00000066u)

#define CSL_BOOTCFG_DDR3_CONFIG_REG_23_RESETVAL (0x0A619834u)

/* ddr3_config_reg_24 */

#define CSL_BOOTCFG_DDR3_CONFIG_REG_24_FIFO_WE_SLAVE_RATIO_MASK (0x000007FFu)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_24_FIFO_WE_SLAVE_RATIO_SHIFT (0x00000000u)
#define CSL_BOOTCFG_DDR3_CONFIG_REG_24_FIFO_WE_SLAVE_RATIO_RESETVAL (0x0000015Bu)

#define CSL_BOOTCFG_DDR3_CONFIG_REG_24_RESETVAL (0x0000015Bu)

/* end_point */

#define CSL_BOOTCFG_END_POINT_END_POINT_MASK (0xFFFFFFFFu)
#define CSL_BOOTCFG_END_POINT_END_POINT_SHIFT (0x00000000u)
#define CSL_BOOTCFG_END_POINT_END_POINT_RESETVAL (0x00000000u)

#define CSL_BOOTCFG_END_POINT_RESETVAL (0x00000000u)

#endif
