#ifndef NXP_I3C_H
#define NXP_I3C_H

#include <linux/i3c/device.h>

#define NXP_I3C_CMD_CONF   0x00
#define NXP_I3C_CMD_DAA    0x01 // Do a Dynamic address asignement
#define NXP_I3C_CMD_CCC    0x02 // Execute a CCC command
#define NXP_I3C_CMD_WI3C   0x03 // Write in I3C
#define NXP_I3C_CMD_RI3C   0x04 // Read in I3C
#define NXP_I3C_CMD_WR3C   0x05 // Write then Read in I3C
#define NXP_I3C_CMD_WI2C   0x06 // Write in I2C mode
#define NXP_I3C_CMD_RI2C   0x07 // Read in I2C mode
#define NXP_I3C_CMD_WR2C   0x88 // Write then Read in I2C mode
// #define NXP_I3C_CMD_WDDR   0x09 // Write in DDR mode
// #define NXP_I3C_CMD_RDDR   0x0A // Read in DDR mode
#define NXP_I3C_CMD_STOP   0x0B // Do a write stop
#define NXP_I3C_CMD_EXIT   0x0C // Do a Write exit
#define NXP_I3C_CMD_GET_DEVICE_LIST 0x0D // Get all I3C device list
#define NXP_I3C_CMD_SET_HJ_MODE 0x0E // Change the HotJoin Mode (Ack, Nack, Manual)
#define NXP_I3C_CMD_GET_EVENT 0x0F // Get the last Event received
#define NXP_I3C_CMD_SET_TASK 0x10 // Get the last Event received


#define NXP_I3C_MODE_I3C 0x00 // SDR mode of I3C
#define NXP_I3C_MODE_I2C 0x01 // Standard I2C protocol
#define NXP_I3C_MODE_DDR 0x02 // HDR-DDR mode of I3C

#define NXP_I3C_HOTJOIN_ACK 0 // Ack the HJ IBI, then execute a daa a inform userland with signal
#define NXP_I3C_HOTJOIN_NACK 1 // Nack the HJ IBI
#define NXP_I3C_HOTJOIN_MANUAL 2  // Ack the HJ IBI, and inform userland with signal (no daa)

#define EVENT_FIFO_SIZE 32

#define NXP_I3C_IBITYPE_NONE 0
#define NXP_I3C_IBITYPE_IBI 1
#define NXP_I3C_IBITYPE_MR 2
#define NXP_I3C_IBITYPE_HJ 3

#define NXP_I3C_HOTJOIN_ADDR 0x02

#define SIGIBI 42
#define SIGHJ 43

typedef struct conf {
	__u8 stena;
	__u8 disto;
	__u8 hkeep;
	__u8 odstop;
	__u8 perlow;
	__u8 ppbaud;
	__u8 pplow;
	__u8 odbaud;
	__u8 odhpp;
	__u8 skew;
	__u8 i2cbaud;
} i3c_config;

typedef struct i3c_devices_list{
	__u8 nb_devices;
	struct i3c_device_info * device_list;
} i3c_devices_list;

typedef struct cmd_param{
	__u16 static_addr;
	__u8 dyn_addr;
	__u8 mode;
	__u8 write_data[255];
	__u8 * read_data;
	__u8 buffer_len;
	i3c_devices_list * i3c_devices_list;
} i3c_cmd_param;

typedef struct cmd_ccc_param{
	__u8 read;
	__u8 cmd_id;
	__u8 dest_addr;
	__u8 payload_len;
	__u8 write_payload[255];
	__u8 * read_payload;
} i3c_cmd_ccc_param;

struct ibi_event{
	__u8 type;
	__u8 wait_for_manual_action;
	__u8 len;
	__u8 data[255];
	__u8 dyn_addr;
};






#endif