/******************************************************************************
 * Generic driver for NXP NCI NFC chips: nxp-nci.h
 ******************************************************************************/
... some defines and functions declarations

enum nxp_nci_mode {
	NXP_NCI_MODE_COLD, 	NXP_NCI_MODE_NCI, 	NXP_NCI_MODE_FW
};

struct nxp_nci_phy_ops {
	int (*set_mode)(void *id, enum nxp_nci_mode mode);
	int (*write)(void *id, struct sk_buff *skb);
};

struct nxp_nci_fw_info {
	char name[NFC_FIRMWARE_NAME_MAXSIZE + 1];
	const struct firmware *fw;
	size_t size, written, frame_size;
	const u8 *data;
	struct work_struct work;
	struct completion cmd_completion;
	int cmd_result;
};

struct nxp_nci_info {
	struct nci_dev *ndev;
	void *phy_id;
	struct device *pdev;
	enum nxp_nci_mode mode;
	const struct nxp_nci_phy_ops *phy_ops;
	unsigned int max_payload;
	struct mutex info_lock;
	struct nxp_nci_fw_info fw_info;
};
