/*****************************************************************************/
t_starship_device arcadia_device;
static struct cdev cdev;

static TheHwDeviceRtnCode_t rendering_done_callback(void *callerHnd, \
                                              void *TheHwDeviceHandler, \
                                              TheHwDeviceMsg_t message, \
                                              TheHwDeviceMsgData_t *p_data)
{
   u32 *process_done = (u32 *)callerHnd;
   *process_done = DONE;
   wake_up(&arcadia_device.wait);
   return YAPA2SOUCIS;
}

static int arcadia_open(struct inode *pInode, struct file *pFile)
{
   t_starship_instance* this_instance;
   int err=0;
   int minor=iminor(pInode);

   if(minor >= MAX_MINOR) {
	   ARCADIA_WARNING("too many scene already opened");
	   return -EINVAL;
   }
   if(pFile->private_data == NULL) {
	   pFile->private_data = &arcadia_device.instance[minor];
   }
   this_instance = pFile->private_data;
   down(&this_instance->sem);
   if ((this_instance->user_counter++) && (this_instance->minor == minor)) {
      /* init already done */
      up(&this_instance->sem);
      return 0;
   }
   this_instance->minor = minor;
   this_instance->units.pui8_unitIDTable = (TheHwDeviceUInt8_t *) kzalloc(sizeof(TheHwDeviceUInt8_t),GFP_KERNEL);
   {
      const TheHwDeviceBackGround_t cBlackBg = {0,0,0,0};
      arcadia_device.radar_screen[minor].planeRGBVirtualAddr = 0;
      arcadia_device.radar_screen[minor].planeRGBPhysicalAddr = 0;

      /* Create the scene */
      err =DoSomeHwStuffCreate(&this_instance->TheHwDeviceHandler, 0, this_instance->units);
      if (YAPA2SOUCIS != err) {
         kfree(this_instance->units.pui8_unitIDTable);
         pFile->private_data = NULL;
         this_instance->user_counter--;
         up(&this_instance->sem);
         arcadia_ERROR(EIO,sTheHwDeviceErr(err));
      };
      err = TheHwDeviceSetCallback(this_instance->TheHwDeviceHandler, (void*)&this_instance->processed, rendering_done_callback);
      if (YAPA2SOUCIS != err) {
         CHECK_LIB_WARNING(NO_WAIT, DoSomeHwStuffDestroy(this_instance->TheHwDeviceHandler), sTheHwDeviceErr);
         kfree(this_instance->units.pui8_unitIDTable);
         pFile->private_data = NULL;
         this_instance->user_counter--;
         up(&this_instance->sem);
         arcadia_ERROR(EIO,sTheHwDeviceErr(err));
      };
      /* init objects */
      this_instance->obj_number = 0;
      INIT_LIST_HEAD(&this_instance->obj_list);
   }
   this_instance->processed = DONE; /* currently idle */
   up(&this_instance->sem);
   return 0;
}


static int arcadia_release(struct inode *pInode, struct file *pFile)
{
   int minor = iminor(pInode);
   t_starship_instance* this_instance;
   
   if(minor >= MAX_MINOR) return -EINVAL;
   this_instance = pFile->private_data;
   down(&this_instance->sem);

   this_instance->user_counter--;
   if(this_instance->user_counter == 0) {
         /* object stuff */
         arcadia_is_fighting_somewhere(this_instance);
         this_instance->HAS_A_CONFIG=0;
         kfree(this_instance->units.pui8_unitIDTable);
         pFile->private_data = NULL;
      }
   else {
      INFO("Still %d users pending for arcadia_release\n",this_instance->user_counter);
   }
   up(&this_instance->sem);
   return 0;
}

static int arcadia_ioctl(struct inode *pInode, struct file *pFile, unsigned int cmd, unsigned long arg)
{
   int err = 0;
   t_starship_instance* this_instance = pFile->private_data;

   BUG_ON(this_instance->minor!=iminor(pInode));
   down(&this_instance->sem);
   if (!this_instance->TheHwDeviceHandler) arcadia_ERROR(EIO,"Albator is not ready");

   switch ( cmd ) {
   case ARCADIA_CMD1 : err=do_some_stuff_for_cmd1_here();break;
   case ARCADIA_CMD2 : err=do_some_stuff_for_cmd2_here();break;
   case ARCADIA_CMD3 : err=do_some_stuff_for_cmd3_here();break;
   default: break;
   }

   /* do not add anything else, some ioctl might by in error ! */
   up(&this_instance->sem);
   return err;
}

static void arcadia_vm_open(struct vm_area_struct *vma)
{
   struct arcadia_mapping *map = vma->vm_private_data;
   map->count++;
}

static void arcadia_vm_close(struct vm_area_struct *vma)
{
   struct arcadia_mapping *map = vma->vm_private_data;
   map->count--;
   if(map->count == 0) kfree(map);
}

static struct vm_operations_struct arcadia_vm_ops = {
		.open     = arcadia_vm_open,
		.close    = arcadia_vm_close,
};

static int arcadia_mmap(struct file *pFile, struct vm_area_struct * vma)
{
   int retval = 0;
   struct arcadia_mapping *map;
   t_starship_instance* this_instance = pFile->private_data;

   if (vma->vm_pgoff) {
      retval = framemem_mmap(NULL,vma);
      if (retval != -ENOMEM) return 0;
   }
   map = kmalloc(sizeof(struct arcadia_mapping),GFP_KERNEL);
   map->count    = 1;
   map->start    = vma->vm_start;
   map->end      = vma->vm_end;
 
   vma->vm_ops   = &arcadia_vm_ops;
   vma->vm_flags |= VM_DONTEXPAND | VM_RESERVED;
   vma->vm_flags &= ~VM_IO; /* using shared anonymous pages */
   vma->vm_private_data = map;
   vma->vm_pgoff = 0;

   retval = dma_mmap_coherent(NULL, \
                              vma, \
                              (u32*)arcadia_device.radar_screen[this_instance->minor].planeRGBVirtualAddr, \
                              arcadia_device.radar_screen[this_instance->minor].planeRGBPhysicalAddr, \
                              vma->vm_end - vma->vm_start);
   return retval;
}

static struct file_operations arcadia_fops = {
   owner:    THIS_MODULE,
   open:     arcadia_open,
   release:  arcadia_release,
   ioctl:    arcadia_ioctl,
   mmap:     arcadia_mmap,
};

static int __init arcadia_dev_init(void)
{
   int i = 0;
   dev_t dev = 0;
   int retval = 0;

   memset(&arcadia_device,0,sizeof(t_starship_device));
   retval = alloc_chrdev_region(&dev, 0, MAX_MINOR,DEVICENAME);
   if (retval) {
	   INFO("unable to alloc chrdev region for %s, dev=%d %s\n",DEVICENAME,dev,ERR_TO_STR(retval));
	   return retval;
   }
   arcadia_device.major = MAJOR(dev);

   cdev_init(&cdev, &arcadia_fops);
   cdev.owner = THIS_MODULE;

   arcadia_device.devno = MKDEV(arcadia_device.major, arcadia_device.minor);
   retval = cdev_add(&cdev, arcadia_device.devno, MAX_MINOR);
   if (retval){
      INFO("unable to add device for %s, arcadia_devno=%d %s\n",DEVICENAME,arcadia_device.devno,ERR_TO_STR(retval));
      cdev_del(&cdev);
      unregister_chrdev_region(arcadia_device.devno, MAX_MINOR);
      return retval;
   }   
   arcadia_hw_init();
   memset(&arcadia_device.instance[0],0,sizeof(t_starship_instance)* MAX_MINOR);
   for (i =0; i< MAX_MINOR ; i++) {
      init_MUTEX(&arcadia_device.instance[i].sem);
   }
   init_waitqueue_head(&arcadia_device.wait);
   return 0;
}

static void __exit arcadia_dev_exit(void)
{
   cdev_del(&cdev);
   unregister_chrdev_region(arcadia_device.devno, MAX_MINOR);
}

module_init(arcadia_dev_init);
module_exit(arcadia_dev_exit);

MODULE_LICENSE("GNU V2.0");
MODULE_AUTHOR("Albator");
MODULE_DESCRIPTION("Arcadia Firegun driver);
MODULE_VERSION(ARCADIA_VERSION);
